/*

    File: hdaccess.c

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#define LINUX_WRITE 1
#ifdef LINUX_WRITE
#define open_mode O_RDWR
#else
#define open_mode O_RDONLY
#endif
#ifdef DJGPP
#include <stdlib.h>     /* atexit */
#include <go32.h>       /* dosmemget/put */
#include <dpmi.h>
#include <bios.h>       /* bios_k* */
#include "types.h"
#include "common.h"
#include "hdaccess.h"
#define HD_RW_BUF_SIZ 0x10
#define HDPARM_BUF_SIZ 0x1A
#define MAX_IO_NBR 10
#define PARA_CMD         8
int hd_super(int, int, int, int, int, int, void*);
int hd_parm(byte, void*);
extern t_param_disk disk_car;
static int dos_segment = 0;
static int dos_selector = 0;

void free_dos_buffer(void)
{
  __dpmi_free_dos_memory(dos_selector);
  dos_segment = dos_selector = 0;
}

int alloc_dos_buffer(void)
{
  if (dos_segment)
    return 0;
  if ((dos_segment = __dpmi_allocate_dos_memory(18*512/16, &dos_selector))== -1)
  {
    dos_segment = 0;
    return 1;
  }
  atexit(free_dos_buffer);
  return 0;
}

int hd_parm(byte drive, void*buffer)
{
  __dpmi_regs r;
  uchar buf[HDPARM_BUF_SIZ];
  if(dos_segment==0)
    if(alloc_dos_buffer())
      return 1;
  *(word*)&buf[0]=HDPARM_BUF_SIZ;
  r.h.ah = 0x48;
  r.x.ds = dos_segment;
  r.x.si = 0;
  r.h.dl = drive;
  dosmemput(buffer, HDPARM_BUF_SIZ, dos_segment<<4);
  __dpmi_int(0x13, &r);
  dosmemget(dos_segment<<4, HDPARM_BUF_SIZ, buffer);
  return 0;
}

int hd_super(int cmd, int drive, int head, int track,
	 int sector, int nsects, void *buffer)
{ // Limite CHS= 1023,255,63 = 8,064Mo ~= 7.8 Go
  __dpmi_regs r;
  uchar buf[HD_RW_BUF_SIZ];
  int dos_segment2, dos_selector2, xfer2=nsects*512;
  if(dos_segment==0)
    if(alloc_dos_buffer())
      return 1;
  if ( (dos_segment2=__dpmi_allocate_dos_memory((xfer2 + 15) >> 4, &dos_selector2)) == -1 )
    return 1;
  *(word*)&buf[0]=HD_RW_BUF_SIZ;
  *(word*)&buf[2]=nsects;
  *(dword*)&buf[0x4]=dos_segment2<<16;
  *(dword*)&buf[0x8]=(track*(disk_car->head+1)+head)*
    disk_car->sector+sector-1;
  *(dword*)&buf[0xC]=0;

  r.x.ds = dos_segment;
  r.x.si = 0;
  r.h.dl = drive;
  switch(cmd)
  {
    case 2:
      r.h.ah = 0x42;
      break;
    case 3:
      r.x.ax = 0x4300;
      dosmemput(buffer,xfer2,dos_segment2<<4);
      break;
  }
  dosmemput(&buf, HD_RW_BUF_SIZ, dos_segment<<4);
  __dpmi_int(0x13, &r);
  if(cmd==2)
    dosmemget(dos_segment2<<4, xfer2, buffer);
  __dpmi_free_dos_memory(dos_selector2);
#ifdef DEBUG
  if(r.h.ah)
  {
    doprintf(" %ld err %02X %04X\n",*(dword*)&buf[0x8], r.h.ah,r.x.flags);
  }
#endif
  return r.h.ah;
}

int hd_identify(t_param_disk param_disk)
{
  uchar buf[0x200];
  if(biosdisk(PARA_CMD,param_disk->disk,0,0,1,1,buf))
    return 1;
  param_disk->cylinder=((buf[0] & 0x0C0)<<2)|buf[1];
  param_disk->head=buf[3];
  param_disk->sector=buf[0] & 0x3F;
  if(param_disk->cylinder>=1023-1)
  {
    buf[0]=0x1A;
    buf[1]=0;
    hd_parm(param_disk->disk,&buf);
    param_disk->cylinder=*(word*)&buf[0x04];
    if(param_disk->cylinder)
    {
      param_disk->cylinder--;
      param_disk->head=*(word*)&buf[0x08]-1;
      param_disk->sector=*(word*)&buf[0x0C];
    }
    else
    {   /* ATTENTION qword en fait */
      param_disk->cylinder=(*(dword*)&buf[0x10]/255)/63-1;
      param_disk->head=255-1;
      param_disk->sector=63;
    }
  }
  return 0;
}

int hd_read(const uint nbr_secteur, void *nom_buffer, t_disk_cst lieu)
{
  int i,rc=-1;
/*
  static int nbr_read_op=0;
  if(nbr_secteur==0)
  { // Flush sectors
    return nbr_read_op;
  }
  else
*/
  {
    for(i=0;(rc!=0) && (i<MAX_IO_NBR);i++)
      if(lieu->cylinder>=1024)
	rc=hd_super(2, lieu->disk, lieu->head, lieu->cylinder,
	    lieu->sector, nbr_secteur, nom_buffer);
      else
	rc=biosdisk(2, lieu->disk, lieu->head,
	    lieu->cylinder, lieu->sector, nbr_secteur, nom_buffer);
/*
    if(rc==0)
      nbr_read_op++;
*/
    return rc;
  }
}

int hd_read2(const uint nbr_secteur, void *nom_buffer, t_diskext_cst lieu)
{
  int i,rc=-1;
/*
  static int nbr_read_op=0;
  if(nbr_secteur==0)
  { // Flush sectors
    return nbr_read_op;
  }
  else
*/
  {
    for(i=0;(rc!=0) && (i<MAX_IO_NBR);i++)
      if(lieu->scylinder>=1024)
	rc=hd_super(2, lieu->disk, lieu->shead, lieu->scylinder,
	    lieu->ssector, nbr_secteur, nom_buffer);
      else
	rc=biosdisk(2, lieu->disk, lieu->shead,
	    lieu->scylinder, lieu->ssector, nbr_secteur, nom_buffer);
/*
    if(rc==0)
      nbr_read_op++;
*/
    return rc;
  }
}

int hd_write(const uint nbr_secteur, void *nom_buffer, t_disk_cst lieu)
{
  int i,rc=-1;
  for(i=0;(rc!=0)&&(i<MAX_IO_NBR);i++)
  if(lieu->cylinder>=1024)
    rc=hd_super(3, lieu->disk, lieu->head, lieu->cylinder,
      lieu->sector, nbr_secteur, nom_buffer);
  else
    rc=biosdisk(3, lieu->disk, lieu->head,
	 lieu->cylinder, lieu->sector, nbr_secteur, nom_buffer);
  return rc;
}

int hd_write2(const uint nbr_secteur, void *nom_buffer, t_diskext_cst lieu)
{
  int i,rc=-1;
  for(i=0;(rc!=0)&&(i<MAX_IO_NBR);i++)
  if(lieu->scylinder>=1024)
    rc=hd_super(3, lieu->disk, lieu->shead, lieu->scylinder,
      lieu->ssector, nbr_secteur, nom_buffer);
  else
    rc=biosdisk(3, lieu->disk, lieu->shead,
	 lieu->scylinder, lieu->ssector, nbr_secteur, nom_buffer);
  return rc;
}
#else
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/hdreg.h>
#include <fcntl.h> 
#include "types.h"
#include "common.h"
#include "hdaccess.h"
loff_t llseek(int,loff_t, int);
int IN_DEV=0;                         /* holds the open input dev */
int CYLINDERS, HEADS, SECTORS;

int hd_read(const uint nbr_secteur, void *nom_buffer, t_disk_cst lieu)
{
  int i;
  loff_t pos;
  pos=(((loff_t)lieu->cylinder*(HEADS+1)+lieu->head)*SECTORS+lieu->sector-1)<<9;
  i=llseek(IN_DEV,pos,SEEK_SET);
  if(i==-1)
    return -1;
  read(IN_DEV, nom_buffer, nbr_secteur*0x200);
  return 0;
}

int hd_write(const uint nbr_secteur, void *nom_buffer, t_disk_cst lieu)
{
#ifdef LINUX_WRITE
  int i;
  loff_t pos;
  pos=(((loff_t)lieu->cylinder*(HEADS+1)+lieu->head)*SECTORS+lieu->sector-1)<<9;
  i=llseek(IN_DEV,pos,SEEK_SET);
  if(i==-1)
    return -1;
  if(write(IN_DEV, nom_buffer, nbr_secteur*0x200)<0)
    return -1;
  return 0;
#else
  return 1;
#endif
}

int hd_read2(const uint nbr_secteur, void *nom_buffer, t_diskext_cst lieu)
{
  int i;
  loff_t pos;
  pos=(((loff_t)lieu->scylinder*(HEADS+1)+lieu->shead)*SECTORS+lieu->ssector-1)<<9;
  i=llseek(IN_DEV,pos,SEEK_SET);
  if(i==-1)
    return -1;
  read(IN_DEV, nom_buffer, nbr_secteur*0x200);
  return 0;
}

int hd_write2(const uint nbr_secteur, void *nom_buffer, t_diskext_cst lieu)
{
#ifdef LINUX_WRITE
  int i;
  loff_t pos;
  pos=(((loff_t)lieu->scylinder*(HEADS+1)+lieu->shead)*SECTORS+lieu->ssector-1)<<9;
  i=llseek(IN_DEV,pos,SEEK_SET);
  if(i==-1)
    return -1;
  if(write(IN_DEV, nom_buffer, nbr_secteur*0x200)<0)
    return -1;
  return 0;
#else
  return 1;
#endif
}


int hd_identify(t_param_disk param_disk)
{
    struct hd_geometry geometry;
    if(IN_DEV)
      close(IN_DEV);
    switch(param_disk->disk)
    {
    case 0:
      IN_DEV = open("/dev/fd0", open_mode);
      break;
    case 1:
      IN_DEV = open("/dev/fd1", open_mode);
      break;
    case 0x80:
      IN_DEV = open("/dev/hda", open_mode);
      if(IN_DEV<0) {
	IN_DEV = open("/dev/sda", open_mode);
      }
      break;
    case 0x81:
      IN_DEV = open("/dev/hdb", open_mode);
      if(IN_DEV<0) {
	IN_DEV = open("/dev/sdb", open_mode);
      }
      break;
    case 0x82:
      IN_DEV = open("/dev/hdc", open_mode);
      if(IN_DEV<0) {
	IN_DEV = open("/dev/sdc", open_mode);
      }
      break;
    case 0x83:
      IN_DEV = open("/dev/hdd", open_mode);
      break;
      if(IN_DEV<0) {
	IN_DEV = open("/dev/sdd", open_mode);
      }
    case 0x84:
      IN_DEV = open("/dev/hde", open_mode);
      break;
      if(IN_DEV<0) {
	IN_DEV = open("/dev/sde", open_mode);
      }
    default:
      IN_DEV=0;
      break;
    }
    if(IN_DEV<0)
      return 1;
    if (ioctl(IN_DEV, HDIO_GETGEO, &geometry))
      return 1;
    CYLINDERS=param_disk->cylinder= geometry.cylinders-1;
    HEADS=param_disk->head=geometry.heads-1;
    SECTORS=param_disk->sector= geometry.sectors;
    return 0;
  }
#endif
