/*

    File: godmode.c

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#define FULL_GODMODE
#include <curses.h>
#include <ctype.h>      /* toupper, tolower */
//#include <string.h>
#include <strings.h>
#include "types.h"
#include "common.h"
#include "fnctdsk.h"
#include "analyse.h"
#include "lang.h"
#include "godmode.h"
#include "testdisk.h"
#define ESC 0x1B
#define RO 1
#define RW 0
extern t_param_disk disk_car;
extern int fast_mode;
extern char* nom_os[256];
extern int curses;
void init_structure(int nbr_part, t_diskext tab_part[NBR_PART_MAX]);
int ask_structure(int nbr_part, t_diskext tab_part[NBR_PART_MAX]);
void ask_mbr_order(int nbr_part, t_diskext tab_part[NBR_PART_MAX]);
void init_extended_order(int nbr_part, t_diskext tab_part[NBR_PART_MAX]);
int test_structure(int nbr_part, t_diskext tab_part[NBR_PART_MAX]);
int search_part(int *nbr_part,t_diskext tab_part[NBR_PART_MAX],int,int,int);
void reduce_structure(int*nbr_part, t_diskext tab_part[NBR_PART_MAX]);
void add_ext_part(int*nbr_part, t_diskext tab_part[NBR_PART_MAX]);
int write_mbr(int nbr_part, t_diskext tab_part[NBR_PART_MAX],int,int);
int write_all_log(int nbr_part, t_diskext tab_part[NBR_PART_MAX],int,int);
void adjust_part_size(t_diskext);
int can_be_ext(t_diskext);
void only_one_bootable(int nbr_part, t_diskext tab_part[NBR_PART_MAX], int pos);
int diff(char buffer[0x200], char buffer_org[0x200]);

void adjust_part_size(t_diskext part)
{
  part->part_size=((part->ecylinder-part->scylinder)*(disk_car->head+1)+part->ehead-part->shead)*disk_car->sector+part->esector-part->ssector+1;
}


void init_structure(int nbr_part, t_diskext tab_part[NBR_PART_MAX])
{
  /* Reconstruit une structure 
   * nbr_prim nombre de partition primaire
   * first_log, last_log : partition etendu du block etendu
   * nbr_log_block : nombre de block de partition etendu
   *                    devrait etre 0 ou 1 */
  int nbr_prim=0, first_log=-1, last_log=-1, nbr_log_block=0,last_prim=-1;
  int i;
  for(i=0;i<nbr_part;i++)
  {
    if(!can_be_ext(tab_part[i]))
    {
      nbr_prim++;
	  last_prim=i;
      if(i>0 && last_log==i-1)
      { nbr_log_block++; first_log=-1;}
    }
    else
	{
	  if(first_log==-1)
		first_log=i;
	  last_log=i;
	}
  }
  /* Verification */
  if(last_log==nbr_part-1)
    nbr_log_block++;
#ifdef DEBUG
  doprintf("\nRes: nbr_prim %d, nbr_log_block %d",
	nbr_prim, nbr_log_block);
#endif
  if(nbr_prim+nbr_log_block>4)
  { /* Probleme */
#ifdef DEBUG
    doprintf("\nProbleme");
#endif
  }
  else if(nbr_log_block>1)
  { /* Choix */
#ifdef DEBUG
    doprintf("\nChoix");
#endif
    for(i=0;i<nbr_part;i++)
    {
      if(!can_be_ext(tab_part[i]))
	tab_part[i]->status=STATUS_PRIM;
    }
  }
  else
  {
    for(i=0;i<nbr_part;i++)
    {
      if(!can_be_ext(tab_part[i]))
	tab_part[i]->status=STATUS_PRIM;
      else
	tab_part[i]->status=STATUS_LOG;
    }
  }
  /* */
  if(nbr_prim==1)
    if(tab_part[last_prim]->disk==0x80)
	tab_part[last_prim]->status=STATUS_PRIM_BOOT;
}

int can_be_ext(t_diskext partition)
{
  return((partition->shead>0)&&
      (partition->scylinder!=0 ||
       partition->shead!=1 ||
       partition->ssector!=1));
}

void only_one_bootable(int nbr_part, t_diskext tab_part[NBR_PART_MAX], int pos)
{
  int i;
  if(tab_part[pos]->status==STATUS_PRIM_BOOT)
    for(i=0;i<nbr_part;i++)
    {
      if((i!=pos)&&(tab_part[i]->status==STATUS_PRIM_BOOT))
	tab_part[i]->status=STATUS_PRIM;
    }
}

int ask_structure(int nbr_part, t_diskext tab_part[NBR_PART_MAX])
{
  int i;
  int pos=0;
  char car;
  int quit;
  curses=1;
  initscr();
  crmode();
  noecho();
  nonl();
  intrflush(stdscr, FALSE);
  keypad(stdscr, TRUE);
  clear();
  mvaddstr(0,0,m_CHOOSE_PART_TYPE);
  do
  {
    for(i=0;i<nbr_part;i++)
    {
      move(2+i,0);
      if(i==pos)
	standout();
      aff_part(0,tab_part[i]);
      if(i==pos)
	standend();
    }
    move(20,0);
    if(test_structure(nbr_part,tab_part))
      doprintf(m_STRUCT_BAD);
    else
      doprintf(m_STRUCT_OK);
    refresh();
#ifdef __linux__
    car=getchar();
#else
    car=getch();
#endif
    quit=0;
    switch(car)
    {
      case 3:
      case 'A':
	only_one_bootable(nbr_part,tab_part,pos);
	if(--pos<0)
	  pos=nbr_part-1;
	break;
      case 2:
      case 'B':
	only_one_bootable(nbr_part,tab_part,pos);
	if(++pos>=nbr_part)
	  pos=0;
	break;
      case 4:
      case ' ':
      case '+':
      case 'C':
      case 'l':
	if(tab_part[pos]->status==STATUS_LOG)
	  tab_part[pos]->status=STATUS_DELETED;
	else
	  tab_part[pos]->status++;
	if(tab_part[pos]->status==STATUS_LOG && !can_be_ext(tab_part[pos]))
	  tab_part[pos]->status=STATUS_DELETED;
	break;
      case 5:
      case '-':
      case 'D':
      case 'S':
	if(tab_part[pos]->status==STATUS_DELETED)
	  tab_part[pos]->status=STATUS_LOG;
	else
	  tab_part[pos]->status--;
	if(tab_part[pos]->status==STATUS_LOG && !can_be_ext(tab_part[pos]))
	  tab_part[pos]->status--;
	break;
      case 'q':
      case '\r':
      case 'M':
	quit=1;
	break;
      default:
//      doprintf("Touche %02X", car);
	break;
    }
  } while(!quit ||test_structure(nbr_part,tab_part));
  endwin();
  curses=0;
  
  return 0;
}

int test_structure(int nbr_part, t_diskext tab_part[NBR_PART_MAX])
{ /* Return 1 if bad*/
  int nbr_prim=0;
  int nbr_prim_boot=0;
  int nbr_log_block=0;
  int first_log=-1, last_log=-1;
  int err=-1;
  int i;
  for(i=0;i<nbr_part;i++)
  {
    switch(tab_part[i]->status)
    {
      case STATUS_LOG:
	if(nbr_log_block>0)
	  err=i;
	else
	{
	  if(first_log==-1)
	  { first_log=i; last_log=i; }
	  else
	    last_log=i;
	}
	break;
      case STATUS_PRIM_BOOT:
	if(nbr_prim_boot++)
	  return 1;
      case STATUS_PRIM:
	nbr_prim++;
	if(first_log!=-1 && first_log<=last_log)
	  nbr_log_block++;
	break;
      case STATUS_DELETED:
	break;
    }
  }
  if(last_log!=-1 && nbr_log_block==0)
    nbr_log_block=1;
  /* */
  return(err>=0 || nbr_log_block>1 || nbr_log_block+nbr_prim>4);
}

int search_part(int *nbr_part,t_diskext tab_part[NBR_PART_MAX], int paranoid, int debug, int dump_ind)
{
  dword pos_fin;
  int   ind=0;
  int avance=1;
  t_diskext partition=(t_diskext)MALLOC(sizeof(*partition));
  partition->disk=disk_car->disk;
  partition->scylinder=0;
  partition->shead=1;
  partition->ssector=1;
  while((get_SR_part(partition)<=get_SR(disk_car))&&(ind!='S'))
  {
    printf("\rAnalyse cylinder %4d/%d",partition->scylinder,disk_car->cylinder);
    fflush(stdout);
    partition->ecylinder=partition->scylinder;
    partition->ehead=partition->shead;
    if(search_type2(partition,debug,dump_ind))
    {
      doprintf(m_READ_ERROR_AT,
	  partition->scylinder,partition->shead,partition->ssector);
      avance=0;
    }
    else
    switch(partition->part_type)
    {
      case 0:
      case P_EXTENDED:
      case P_EXTENDX:
	avance=0;
	break;
      default:
	{
	  avance=1;
	  pos_fin=get_SR_part(partition)-1+partition->part_size-1;
	  if(pos_fin<=get_LBA(disk_car))
	  {
	    dup_t_diskext(tab_part[*nbr_part],partition);
	    tab_part[*nbr_part]->status=STATUS_DELETED;
	    tab_part[*nbr_part]->sect_rel=0;
	    if(tab_part[*nbr_part]->esector!=disk_car->sector)
	    { /* Propose d'aligner */
	      tab_part[*nbr_part]->part_size+=disk_car->sector-tab_part[*nbr_part]->esector;
	      tab_part[*nbr_part]->esector=disk_car->sector;
	    }
	    if(tab_part[*nbr_part]->ehead!=(unsigned)(disk_car->head-1))
	    { /* Propose d'aligner */
	      tab_part[*nbr_part]->part_size+=(disk_car->head-tab_part[*nbr_part]->ehead)*disk_car->sector;
	      tab_part[*nbr_part]->ehead=disk_car->head;
	    }
	    /* Il faut demander quoi faire de la partition par ici */
	    (*nbr_part)++;
	  }
	  else
	  {
		if(debug)
		{
		  doprintf("\nPartition %02X structure at %u/%u/%u", partition->part_type, partition->scylinder,partition->shead,partition->ssector);
		}
	  }
	}
	break;
    }
    /* Avance */
    partition->ssector=1;
    if(avance && !paranoid)
    {
      partition->scylinder=partition->ecylinder;
      partition->shead=partition->ehead;
    }
    if(partition->shead<disk_car->head && (!fast_mode || partition->shead<2))
    {
      partition->shead++;
    }
    else
    { partition->scylinder++; partition->shead=0;}
    ind=test_key();
    if(ind) ind=read_key();
  }
  printf("\r                                ");
  FREE(partition);
  return 0;
}

void ask_mbr_order(int nbr_part, t_diskext tab_part[NBR_PART_MAX])
{
  int table[nbr_part];
  int table2[nbr_part];
  int nbr_prim=0;
  int i,pos=0;
  int res;
  char car;
  int ind_sort=1;
  int ind_modif=0;
  int quit=0;
  /* Initialisation */
  for(i=0;i<nbr_part;i++)
  {
    if((tab_part[i]->status==STATUS_PRIM)||(tab_part[i]->status==STATUS_PRIM_BOOT)||(tab_part[i]->status==STATUS_EXT))
    {
      table[nbr_prim++]=i;
      tab_part[i]->order=nbr_prim;
    }
  }
  /* */
  curses=1;
  initscr();
  crmode();
  noecho();
  nonl();
  intrflush(stdscr, FALSE);
  keypad(stdscr, TRUE);
  clear();
  mvaddstr(0,0,m_MBR_ORDER);
  do
  {
    uint order,part=0;
    res=0;
    if(quit)
      ind_sort=1;
    if(ind_sort)
    for(order=1;order<=4;order++)
    {
      int nbr=0;
      for(i=0;i<nbr_prim;i++)
	if(tab_part[table[i]]->order==order)
	{
	  table2[part++]=table[i];
	  nbr++;
	}
      res|=(nbr>1);
    }
    for(i=0;i<nbr_prim;i++)
    {
      move(2+i,0);
      if(i==pos)
	standout();
      aff_part(2,tab_part[table2[i]]);
      if(i==pos)
	standend();
    }
    move(20,0);
    if(res)
      doprintf(m_MBR_ORDER_BAD);
    else
      doprintf(m_MBR_ORDER_GOOD);
    refresh();
#ifdef LINUX
    car=getchar();
#else
    car=getch();
#endif
    ind_sort=0;
    quit=0;
    switch(car)
    {
      case 3:
      case 'A':
	if(--pos<0)
	  pos=nbr_prim-1;
	ind_modif=0;
	ind_sort=1;
	break;
      case 2:
      case 'B':
	if(++pos>=nbr_prim)
	  pos=0;
	ind_modif=0;
	ind_sort=1;
	break;
      case '1':
      case '2':
      case '3':
      case '4':
	tab_part[table2[pos]]->order=car-'0';
	ind_modif=0;
	ind_sort=1;
	break;
      case 4:
      case ' ':
      case 'C':
      case '+':
      case 'l':
	if(++tab_part[table2[pos]]->order>4)
	  tab_part[table2[pos]]->order=1;
	ind_modif=1;
	break;
      case 5:
      case 'D':
      case '-':
      case 'S':
	if(--tab_part[table2[pos]]->order<1)
	  tab_part[table2[pos]]->order=4;
	ind_modif=1;
	break;
      case 'q':
      case '\r':
      case 'M':
	quit=1;
	if(ind_modif)
	{
	  ind_modif=0;
	  ind_sort=1;
	}
	break;
    }
  } while(res || ind_sort || !quit);
  endwin();
  curses=0;
}

void init_extended_order(int nbr_part, t_diskext tab_part[NBR_PART_MAX])
{ /* Initialisation */
  int nbr_log=0;
  int i;
  for(i=0;i<nbr_part;i++)
  {
    if(tab_part[i]->status==STATUS_LOG)
      tab_part[i]->order=(++nbr_log)+4;
  }
}

void reduce_structure(int *nbr_part, t_diskext tab_part[NBR_PART_MAX])
{ 
  int pos_read,pos_write=0;
  for(pos_read=0;pos_read<*nbr_part;pos_read++)
  {
    if(tab_part[pos_read]->status!=STATUS_DELETED)
    {
      if(pos_read==pos_write)
	pos_write++;
      else
      {
	dup_t_diskext(tab_part[pos_write++], tab_part[pos_read]);
	tab_part[pos_read]->status=STATUS_DELETED;
      }
    }
  }
  *nbr_part=pos_write;
  /*
  int i=0,j;
  while (i<(*nbr_part))
  {
    if(tab_part[i]->status==STATUS_DELETED)
//      dup_t_diskext(tab_part[i], tab_part[--(*nbr_part)]);
    {
      for(j=i;j<*nbr_part-1;j++)
	dup_t_diskext(tab_part[j], tab_part[j+1]);
      (*nbr_part)--
    }
    else
      i++;
  }
  */
}

void add_ext_part(int *nbr_part, t_diskext tab_part[NBR_PART_MAX])
{
  /* tab_part need to be sorted! */
  /* All extended partitions of an P_EXTENDX  are P_EXTENDED */
  int i,deb=-1,fin=-1;
  for(i=0;i<*nbr_part;i++)
    if(tab_part[i]->status==STATUS_LOG)
    {
      if(deb==-1) deb=fin=i; else fin=i;
    }
  if(deb!=-1)
  {
    tab_part[*nbr_part]->ssector=1;
    tab_part[*nbr_part]->disk=tab_part[0]->disk;
    if((*nbr_part)-(fin-deb)==4)
    {
#ifdef DEBUG
      doprintf("4 entrees dans le MBR => Creer une grande partition etendue");
#endif
      if(deb==0)
	tab_part[*nbr_part]->scylinder=1;
      else
	tab_part[*nbr_part]->scylinder=tab_part[deb-1]->ecylinder+1;
      tab_part[*nbr_part]->shead=0;
      if(fin==*nbr_part-1)
	tab_part[*nbr_part]->ecylinder=disk_car->cylinder;
      else
	tab_part[*nbr_part]->ecylinder=tab_part[fin+1]->scylinder-1;
      tab_part[*nbr_part]->ehead=disk_car->head;
      tab_part[*nbr_part]->esector=disk_car->sector;
    }
    else
    {
#ifdef DEBUG
      doprintf("Creer une partition etendue de taille minimale");
#endif
      tab_part[*nbr_part]->scylinder=tab_part[deb]->scylinder;
      tab_part[*nbr_part]->shead=tab_part[deb]->shead-1;
      tab_part[*nbr_part]->ecylinder=tab_part[fin]->ecylinder;
      tab_part[*nbr_part]->ehead=tab_part[fin]->ehead;
      tab_part[*nbr_part]->esector=tab_part[fin]->esector;
    }
    if(tab_part[*nbr_part]->ecylinder>1023)
      tab_part[*nbr_part]->part_type=P_EXTENDX;
    else
      tab_part[*nbr_part]->part_type=P_EXTENDED;
    tab_part[*nbr_part]->status=STATUS_EXT;
    adjust_part_size(tab_part[*nbr_part]);
    (*nbr_part)++;
  }
#ifdef DEBUG
  fflush(stdout);
  read_key();
#endif
}

int write_mbr(int nbr_part, t_diskext tab_part[NBR_PART_MAX], int ro,int debug)
{
  int i;
  uchar buffer[0x200];
  uchar buffer_org[0x200];
  if(debug)
  {
	doprintf("\nwrite_mbr: starting...");
	fflush(stdout);
  }
  if(read_MBR(&buffer_org)) return 1;
  memset((void *)&buffer,0,0x200);
  memcpy(buffer,buffer_org,TAB_PART);
  buffer[0x1FE]=0x55;
  buffer[0x1FF]=0xAA;
  for(i=0;i<nbr_part;i++)
  {
    switch(tab_part[i]->status)
    {
      case STATUS_PRIM:
      case STATUS_PRIM_BOOT:
      case STATUS_EXT:
      case STATUS_EXT_IN_EXT:
	partition2entree(1,tab_part[i], 
	    (t_entree*)&buffer[TAB_PART+(tab_part[i]->order-1)*0x10]);
	break;
    }
  }
  if(ro)
  {
    for(i=0;i<4;i++)
      aff_entree(&buffer[0x10*i+TAB_PART]);
#ifdef DUMP
    diff(buffer,buffer_org);
#endif
  }
  else
    return write_MBR(&buffer);
  return 0;
}

#ifdef DUMP
int diff(char buffer[0x200], char buffer_org[0x200])
{
  int j;
  if(memcmp(buffer,buffer_org,0x200))
  {
    for(j=0;j<4;j++)
      if(os(&buffer[0x10*j+TAB_PART]))
	aff_entree(&buffer_org[0x10*j+TAB_PART]);
    printf("\nSectors are differents\n");
    /*
       dump(buffer_org,0x200);
       dump(buffer,0x200);
     */
    for(j=0;j<0x200;j++)
      if(buffer[j]!=buffer_org[j])
	printf("%02X ", j);
  }
  return 0;
}
#endif

int write_all_log(int nbr_part, t_diskext tab_part[NBR_PART_MAX], int ro, int debug)
{
  int i,pos_ext=-1;
  int table[nbr_part];
  int nbr_log=0;
  dword pos;
  t_diskext bloc_ext,bloc_nextext;
  if(debug)
  {
	doprintf("\nwrite_all_log: starting...");
	fflush(stdout);
  }
  for(i=0;i<nbr_part;i++)
  {
    switch(tab_part[i]->status)
	{
	  case STATUS_EXT:          /* Pas bootable */
		if((tab_part[i]->part_type==P_EXTENDED) ||
			(tab_part[i]->part_type==P_EXTENDX))
		  pos_ext=i;
		break;
	  case STATUS_LOG:
		table[nbr_log++]=i;
		break;
	}
  }
  if(pos_ext==-1)
  {
    doprintf(m_NO_EXT_PART);
    return 1;
  }
  bloc_ext=(t_diskext)MALLOC(sizeof(*bloc_ext));
  bloc_nextext=(t_diskext)MALLOC(sizeof(*bloc_nextext));
  pos=get_SR_part(tab_part[pos_ext]);
  memcpy(bloc_ext,tab_part[pos_ext],sizeof(struct cellule_diskext));
  for(i=0;i<nbr_log;i++)
  {
    /* tabext: partition etendu conteneur */
    /* tab[part[table[i]]: partition */
    int j;
    uchar buffer[0x200];
    uchar buffer_org[0x200];
	if(debug)
	{
	  doprintf("\nwrite_all_log: D %02X CHS: %d %d %d", bloc_ext->disk, bloc_ext->scylinder, bloc_ext->shead, bloc_ext->ssector);
	  fflush(stdout);
	}
    if(read_ext(&buffer_org,bloc_ext))
      return 1;
    memset(buffer,0,0x200);
    memcpy(buffer,buffer_org,TAB_PART);
    buffer[0x1FE]=0x55;
    buffer[0x1FF]=0xAA;
    partition2entree(get_SR_part(bloc_ext),tab_part[table[i]], (t_entree*)&buffer[TAB_PART]);
    if(i<nbr_log-1)
    { /* Construit le pointeur vers la prochaine partition logique */
      bloc_nextext->disk=tab_part[table[i+1]]->disk;
      bloc_nextext->scylinder=tab_part[table[i+1]]->scylinder;
      bloc_nextext->shead=tab_part[table[i+1]]->shead-1;
      bloc_nextext->ssector=1;
      bloc_nextext->ecylinder=tab_part[table[i+1]]->ecylinder;
      bloc_nextext->ehead=tab_part[table[i+1]]->ehead;
      bloc_nextext->esector=tab_part[table[i+1]]->esector;
      /*
      if(bloc_nextext->ecylinder>1023)
	bloc_nextext->part_type=P_EXTENDX;
      else
      */
	bloc_nextext->part_type=P_EXTENDED;
      adjust_part_size(bloc_nextext);
      partition2entree(pos,bloc_nextext, (t_entree*)&buffer[TAB_PART+0x10]);
    }
    if(ro)
    {
	  for(j=0;j<4;j++)
		if(os(&buffer[0x10*j+TAB_PART]))
		  aff_entree(&buffer[0x10*j+TAB_PART]);
#ifdef DUMP
	  diff(buffer,buffer_org);
#endif
	}
	else
	  write_ext(&buffer_org,bloc_ext);
	memcpy(bloc_ext,bloc_nextext,sizeof(struct cellule_diskext));
  }
  FREE(bloc_ext);
  FREE(bloc_nextext);
  return 0;
}

int god_mode(int paranoid,int debug,int dump_ind)
{
  int   nbr_part=0;
  int   i;
  t_diskext tab_part[NBR_PART_MAX];
  for(i=0;i<NBR_PART_MAX;i++)
    tab_part[i]=(t_diskext)MALLOC(sizeof(struct cellule_diskext));
  if(search_part(&nbr_part,tab_part,paranoid,debug,dump_ind))
    return 1;   /* Err de lecture */
  init_structure(nbr_part, tab_part);
  /* Ajoute dans le fichier de log les partitions trouvees */
  ecrit_rapport("\nResults");
  for(i=0;i<nbr_part;i++)
    aff_part_rapport(1,tab_part[i]);
  doprintf(m_GOD_MODE);
  ask_structure(nbr_part,tab_part);
  reduce_structure(&nbr_part,tab_part);
  /* Creer la partition etendue globale */
  add_ext_part(&nbr_part,tab_part);
  /* Demande l'ordre des entrees dans le MBR */
  ask_mbr_order(nbr_part,tab_part);
  /* Demande l'ordre des partitions etendues */
  init_extended_order(nbr_part,tab_part);
  /* Construit le MBR */
  //write_mbr(nbr_part,tab_part,RO);
  /* Construit les partitions etendus */
  //write_all_log(nbr_part,tab_part,RO);
  for(i=0;i<nbr_part;i++)
	if(tab_part[i]->status!=STATUS_LOG)
	  aff_part(1,tab_part[i]);
  for(i=0;i<nbr_part;i++)
	if(tab_part[i]->status==STATUS_LOG)
	  aff_part(1,tab_part[i]);
  if(ask_YN(m_GODMODE_WRITE))
  {
    write_mbr(nbr_part,tab_part,RW,debug);
    write_all_log(nbr_part,tab_part,RW,debug);
  }
  /* Libere la memoire */
  if(debug)
  {
    doprintf("\ngod_mode: free the memory");
    fflush(stdout);
  }
  for(i=0;i<NBR_PART_MAX;i++)
    FREE(tab_part[i]);
  return 0;
}
