/*

    File: bsd.c

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include <stdio.h>
#include "types.h"
#include "common.h"
#include "bsd.h"
#include "fnctdsk.h"

int test_bsd(struct disklabel *bsd_header,t_diskext partition, int debug)
{
  if((bsd_header->d_magic == DISKMAGIC)&&(bsd_header->d_magic2==DISKMAGIC))
  {
    int i;
    int i_max_p_offset=0;
    u_int16_t* cp;
    u_int16_t crc;
    if(debug)
      doprintf("\nBSD offset %d, nbr_part %d/%d",get_LBA_part(partition),bsd_header->d_npartitions,MAXPARTITIONS);
    if(bsd_header->d_npartitions>MAXPARTITIONS)
      return 1;
    crc=0;
    for(cp=(u_int16_t*)bsd_header;
	cp<(u_int16_t*)&bsd_header->d_partitions[MAXPARTITIONS+1];cp++)
      crc^=*cp;
    if(debug)
    {
      if(!crc)
	doprintf("\nCRC Ok");
      else
	doprintf("\nBad CRC! CRC must be xor'd by %04X",crc);
    }
    if(crc)
      return 1;
    for(i=0;i<MAXPARTITIONS;i++)
    {
      if(debug)
      {
	doprintf("\n\nBSD offset %d size %d type %02X\n",
      bsd_header->d_partitions[i].p_offset,
      bsd_header->d_partitions[i].p_size,
      bsd_header->d_partitions[i].p_fstype);
	aff_LBA2CHS(bsd_header->d_partitions[i].p_offset);
	doprintf(" ");
	aff_LBA2CHS(bsd_header->d_partitions[i].p_offset+bsd_header->d_partitions[i].p_size-1);
      }

      if(bsd_header->d_partitions[i].p_fstype>0&&bsd_header->d_partitions[i].p_offset>
	  bsd_header->d_partitions[i_max_p_offset].p_offset)
	i_max_p_offset=i;
    }
    partition->part_size=bsd_header->d_partitions[i_max_p_offset].p_size+
      bsd_header->d_partitions[i_max_p_offset].p_offset-
	get_LBA_part(partition) -1;
    partition->part_type=P_BSD;
    return 0;
  }
  return 1;
}
