/*

    File: analyse.c

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
#include <stdio.h>
//#include <string.h>
#ifdef  DJGPP
#include <bios.h>       /* bioskey */
#else
#include <sys/types.h>
#endif
#include "types.h"
#include "common.h"
#include "fnctdsk.h" /* get_LBA_part */
#include "hdaccess.h"
#include "analyse.h"
#include "bfs.h"
#include "swap.h"
#include "bsd.h"
#include "fat.h"
#include "ext2.h"
#include "netware.h"

extern t_param_disk disk_car;

int search_type2(t_diskext partition,int debug, int dump_ind)
{
  dword tmp;
  dword pos_fin;
  if(search_type(partition,debug,dump_ind)<0)
    return 1;
  tmp=disk_car->sector;
  pos_fin=get_LBA_part(partition)+partition->part_size-1;
  partition->esector=(pos_fin%tmp)+1;
  tmp=pos_fin/tmp;
  partition->ecylinder=tmp/(disk_car->head+1);
  partition->ehead=tmp%(disk_car->head+1);
  return 0;
}

int search_type(t_diskext partition, int debug,int dump_ind)
{
  uchar buffer[8*0x200];
  partition->part_size=0;
  partition->part_type=0;
  if(hd_read2(8, &buffer, partition))
    return -1;
  if(!test_linux((struct ext2_super_block*)&buffer[0x400],partition)) return 1;
  if(!test_bsd((struct disklabel *)&buffer[0x200],partition,debug)) return 1;
  if(!test_beos((struct disk_super_block *)&buffer[0x200],partition)) return 1;
  if(!test_lin_swap((union swap_header *)&buffer,partition)) return 1;
  if(!analyse_FAT((struct fat_boot_sector*)&buffer,partition,debug,dump_ind))
    return 1;
  if(!test_netware((union disk_netware *)&buffer,partition)) return 1;
  return 0;
}
