/*

    File: rfs.c

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include <stdio.h>
#include "types.h"
#include "common.h"
#include "rfs.h"
#include "fnctdsk.h"

int test_rfs(struct reiserfs_super_block *sb,t_diskext partition)
{
  if (memcmp(sb->s_magic,REISERFS_SUPER_MAGIC,16) == 0)
  {
    /*
     * sanity checks.
     */

    if (sb->s_block_count < sb->s_free_blocks)
      return (1);

    if (sb->s_block_count < REISERFS_MIN_BLOCK_AMOUNT)
      return (1);

    if ((sb->s_state != REISERFS_VALID_FS) &&
	(sb->s_state != REISERFS_ERROR_FS))
      return (1);

    if (sb->s_oid_maxsize % 2) /* must be even */
      return (1);

    if (sb->s_oid_maxsize < sb->s_oid_cursize)
      return (1);

    if ((sb->s_blocksize != 4096) && (sb->s_blocksize != 8192))
      return (1);

    /*
     * ok.
     */

    partition->part_size = sb->s_block_count * sb->s_blocksize / 512;
    partition->part_type = 0x83;
  }
}
