/*

    File: fillfree.c

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */


#include <stdio.h>
#include <stdlib.h>     /* qsort */
//#include <string.h>
#include <ctype.h>      /* toupper, tolower */
#include "types.h"
#include "common.h"
#include "fillfree.h"
#include "testdisk.h"
#include "fnctdsk.h"
#include "analyse.h"
#include "hdaccess.h"
#include "lang.h"
#include "fat.h"
extern int search_mode;
extern int fast_mode;
extern t_param_disk disk_car;
extern int test_mode;
extern char* nom_os[256];
dword RS_offset;
t_diskext tab_part[NBR_PART_MAX];


/* teste:
      - la validite CHS
      - la position relative
      - le nbr de secteurs de la partition
 Verifie que CHS et le reste est a zero
*/

int get_ext_data(const uint pos_main_ext, uint *nbr_part)
{
  unsigned int i;
  int res=0;
  int pos_ext=pos_main_ext, next_pos_ext;
  uchar buffer[0x200];
  RS_offset=get_SR_part(tab_part[pos_main_ext]);
  do
  {
    int nb_hidden=0, nb_mb=0, nb_part=0, nb_ext=0, nb_boot=0;
#ifdef DEBUG
    doprintf(m_PART_HEADER_EXT " %d/%d/%d", 
	tab_part[pos_ext]->scylinder, tab_part[pos_ext]->shead,
	tab_part[pos_ext]->ssector);
    fflush(stdout);
#endif
    if(read_ext(&buffer,tab_part[pos_ext])) return 1;
    if((buffer[0x1FE]!=0x55)||(buffer[0x1FF]!=0xAA))
    {
      doprintf("\ntest_logical: " m_BAD_NMARK);
      return 1;
    }
    for(i=0;i<4;i++)
    {
      if(buffer[0x10*i+TAB_PART]==0x80)
	nb_boot++;
      switch(buffer[0x10*i+TAB_PART+4])
      {
	case P_16FATBDH:
	case P_16FATH:
	case P_NTFSH:
	  nb_hidden++;
	  break;
	case P_OS2MB:
	  nb_mb++;
	  break;
	case P_EXTENDX:
	case P_EXTENDED:
	  nb_ext++;
	  break;
	case P_NO_OS:
	  break;
	default:
	  nb_part++;
      }
    }
    if(nb_hidden>0)
      doprintf("Partition musn't be hidden");
    if(nb_mb>0)
      doprintf("Multiboot must be a primary partition, not a logical");
    if(nb_ext>1)
      doprintf("A logical partition musn't have more than one link to another logical partition");
    if(nb_part>1)
      doprintf("A logical partition must contain only one partition");
    if(nb_boot)
      doprintf("Logical partition musn't be bootable");
    next_pos_ext=-1;
    for(i=0;i<4;i++)
    {
      int status=STATUS_LOG;
      switch(buffer[0x10*i+TAB_PART+4])
      {
	case P_NO_OS:
	  break;
	case P_EXTENDX:
	case P_EXTENDED:
	  next_pos_ext=*nbr_part;
	  status=STATUS_EXT_IN_EXT;
	default:
	  {
	    int errcode=entree2partition(get_SR_part(tab_part[pos_ext]),
		tab_part[*nbr_part], &buffer[0x10*i+TAB_PART], status);
	    if(errcode)
	    {
	      aff_entree(&buffer[0x10*i+TAB_PART]);
	      doprintf(errmsg_entree2partition(errcode));
	      res|=1;
	    }
	    else
	      (*nbr_part)++;
	  }
	  break;
      }
    }
    pos_ext=next_pos_ext;
  } while ((res==0)&&(pos_ext!=-1));
  return res;
}

int compare2uint(uint a, uint b)
{
  if(a<b)
    return -1;
  else
    if(a==b)
      return 0;
    else
      return 1;
}

int compar(const void*pos1, const void*pos2)
{
  int res;
  res=compare2uint(tab_part[*(const int*)pos1]->scylinder,tab_part[*(const int*)pos2]->scylinder);
  if(res!=0)
    return res;
  res=compare2uint(tab_part[*(const int*)pos1]->shead,tab_part[*(const int*)pos2]->shead);
  if(res!=0)
    return res;
  res=compare2uint(tab_part[*(const int*)pos1]->ssector,tab_part[*(const int*)pos2]->ssector);
  return res;
}

int start_before_end(const int pos1, const int pos2)
{
  int res;
  res=compare2uint(tab_part[pos1]->ecylinder,tab_part[pos2]->scylinder);
  if(res!=0)
    return res;
  res=compare2uint(tab_part[pos1]->ehead,tab_part[pos2]->shead);
  if(res!=0)
    return res;
  res=compare2uint(tab_part[pos1]->esector,tab_part[pos2]->ssector);
  return res;
}

int get_MBR_data(uint *nbr_part,uint*pos_main_ext)
{
  uchar buffer[0x200];
  uint i;
  int res=0;
  if(read_MBR(&buffer))
    return 1;
  if((buffer[0x1FE]!=0x55)||(buffer[0x1FF]!=0xAA))
  {
    doprintf("\nget_MBR_data: " m_BAD_NMARK);
    return 1;
  }
  for(i=0;i<4;i++)
  {
    int status=STATUS_PRIM;
    switch(buffer[0x10*i+TAB_PART+4])
    {
      case P_NO_OS:
	break;
      case P_EXTENDX:
      case P_EXTENDED:
	*pos_main_ext=*nbr_part;
	status=STATUS_EXT;
	/* ne pas mettre de break */
      default:
	{
	  int errcode=entree2partition(1,tab_part[*nbr_part], &buffer[0x10*i+TAB_PART], status);
	  if(errcode)
	  {
	    aff_entree(&buffer[0x10*i+TAB_PART]);
	    doprintf(errmsg_entree2partition(errcode));
	    res|=1;
	  }
	  else
	    (*nbr_part)++;
	}
    }
  }
  return 0;
}

void aff_MBR_data(const uint nbr_part)
{
  uint i;
  doprintf(m_PART_HEADER);
  for(i=0;i<nbr_part;i++)
  {
    doprintf("\n%2d ", i);
    aff_part(0,tab_part[i]);
  }
}

void aff_ext_data(const uint old_nbr_part, const uint nbr_part)
{
  uint i;
  for(i=old_nbr_part;i<nbr_part;i++)
  {
    doprintf("\n%2d ", i);
    aff_part(0,tab_part[i]);
  }
}

void aff_MBR_type_err(const uint nbr_part)
{ /* Compte les differents type de partitions */
  uint nb_dos=0, nb_hidden=0, nb_mb=0, nb_ext=0, nb_boot=0;
  uint i;
  for(i=0;i<nbr_part;i++)
  {
    if(tab_part[i]->status==STATUS_PRIM_BOOT)
      nb_boot++;
    switch(tab_part[i]->part_type)
    {
      case P_12FAT:
      case P_16FAT:
      case P_16FATBD:
	nb_dos++;
	break;
      case P_16FATBDH:
      case P_16FATH:
      case P_NTFSH:
	nb_hidden++;
	break;
      case P_OS2MB:
	nb_mb++;
	break;
      case P_EXTENDX:
      case P_EXTENDED:
	nb_ext++;
	break;
    }
  }
  if(nb_dos>1)
    doprintf(m_ONLY_ONE_DOS);
  if(nb_ext>1)
    doprintf(m_ONLY_ONE_EXT);
  /* S'il y a des partitions caches, il faut un MB */
  if(nb_hidden>0 && nb_mb==0)
    doprintf(m_NO_OS2MB);
  /* Nombre de partition bootable */
  if(nb_boot==0)
    doprintf(m_NO_BOOTABLE);
  else
    if(nb_boot>1)
      doprintf(m_ONLY1MUSTBOOT);
}

int test_MBR_over(const uint nbr_part)
{/* Tester le chevauchement des partitions */
  int table_part[nbr_part];
  uint i;
  int res=0;
  for(i=0;i<nbr_part;i++) table_part[i]=i;
  qsort(table_part,nbr_part,sizeof(int),compar);
  for(i=1;i<nbr_part;i++)
    if(start_before_end(table_part[i-1],table_part[i])>=0)
    {
      res=1;
      doprintf(m_PARTITIONS " %d " m_AND " %d " m_SAME_SPACE,
	  table_part[i], table_part[i-1]);
    }
  return res;
}

int test_ext_over(const uint old_nbr_part, const uint nbr_part, const uint pos_main_ext)
{
  int res=0;
  uint i;
  int table_part[NBR_PART_MAX];
  for(i=0;i<nbr_part-old_nbr_part;i++) table_part[i]=i+old_nbr_part;
  qsort(table_part,nbr_part-old_nbr_part,sizeof(int),compar);
  /* logical partition must start after the beginning of the main_ext */
  if(compar(&pos_main_ext,&table_part[0])>=0)
  {
    res=1;
    doprintf(m_PARTITIONS " %d " m_AND " %d " m_SAME_SPACE,
	table_part[0], pos_main_ext);
  }
  if(nbr_part-old_nbr_part>1)
  {
    /* first EXT_INT_EXT must start after the end of the logical partition */
    if(start_before_end(table_part[0],table_part[1])>=0)
    {
      res=1;
      doprintf(m_PARTITIONS " X3 %d " m_AND " %d " m_SAME_SPACE,
	  table_part[0], table_part[1]);
    }

    for(i=2;i<nbr_part-old_nbr_part;i++)
      if(tab_part[table_part[i]]->status==STATUS_EXT_IN_EXT)
      {
	if(start_before_end(table_part[i-2],table_part[i])>=0)
	{
	  res=1;
	  doprintf(m_PARTITIONS " %d " m_AND " %d " m_SAME_SPACE,
	      table_part[i-2], table_part[i]);
	}
      }
      else
      {
	/* Verifie que je commence apres et que je termine avant */
	if((compar(&table_part[i-1],&table_part[i])>=0) ||
	    (start_before_end(table_part[i-1],table_part[i])<0))
	{
	  res=1;
	  doprintf(m_PARTITIONS " %d " m_AND " %d " m_SAME_SPACE,
	      table_part[i], table_part[i-1]);
	}
      }
  }
  return res;
}

int test_MBR(int debug)
{
  uint nbr_part=0;
  uint pos_main_ext=NBR_PART_MAX;
  uint i;
  int res=0;
  uint old_nbr_part;
  RS_offset=1;
  res=get_MBR_data(&nbr_part,&pos_main_ext);
  aff_MBR_data(nbr_part);
  if(res) return res;
  aff_MBR_type_err(nbr_part);
  test_MBR_over(nbr_part);
  if(res) return res;
  /* Va tester l'etendu */
  old_nbr_part=nbr_part;
  if(pos_main_ext!=NBR_PART_MAX)
  {
    res=get_ext_data(pos_main_ext, &nbr_part);
    aff_ext_data(old_nbr_part,nbr_part);
    if(res) return res;
    test_ext_over(old_nbr_part,nbr_part,pos_main_ext);
  }
  /* */
  for(i=0;i<nbr_part;i++)
  {
    switch(tab_part[i]->part_type)
    {
      case P_12FAT:
      case P_16FAT:
      case P_16FATH:
      case P_16FATBD:
      case P_16FATBDH:
      case P_32FAT_1:
      case P_32FAT_2:
      case P_32FAT_1H:
      case P_32FAT_2H:
	check_FAT(tab_part[i],debug);
	break;
    }
  }
  return res;
}
