/*

    File: ext2.c

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include "types.h"
#include "common.h"
#include "ext2.h"

int test_linux(struct ext2_super_block *sb,t_diskext partition)
{
  if(sb->s_magic==EXT2_SUPER_MAGIC)
  {
    if (sb->s_free_blocks_count >= sb->s_blocks_count) return 1;
    if (sb->s_free_inodes_count >= sb->s_inodes_count) return 1;
    if (sb->s_errors &&
	(sb->s_errors != EXT2_ERRORS_CONTINUE) &&
	(sb->s_errors != EXT2_ERRORS_RO) &&
	(sb->s_errors != EXT2_ERRORS_PANIC))
      return 1;
    if (sb->s_state & ~(EXT2_VALID_FS | EXT2_ERROR_FS))
      return 1;
    if (sb->s_blocks_count == 0) /* reject empty filesystem */
      return 1;
    if(sb->s_log_block_size>2)  /* block size max = 4096 */
      return 1;
    partition->part_size=sb->s_blocks_count*(EXT2_MIN_BLOCK<<sb->s_log_block_size);
    partition->part_type=P_LINUX;
    return 0;
  }
  return 1;
}
