/*

    File: common.c

    Copyright (C) 1998-2000  Christophe Grenier <grenier@nef.esiea.fr>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */


#include <stdlib.h>
#include <stdio.h>
#include <curses.h>
#include "types.h"
#include "common.h"
#include "lang.h"
#include <malloc.h>
#include <ctype.h>      /* toupper, tolower */
#ifdef DJGPP
#include <bios.h>
#else
#endif

void *MALLOC(size_t size)
{
  void *res;
  if((res=malloc(size))==NULL)
  {
    doprintf(m_MALLOC_ERROR);
    exit(1);
  }
  return res;
}

void FREE(void *ptr)
{
  if(ptr==NULL)
  {
    doprintf(m_FREE_ERROR);
    exit(1);
  }
  else
    free(ptr);
}

char read_key()
{
#ifdef DJGPP
  return toupper(bioskey(0));
#else
  return toupper(getchar());
  /*
  char res;
  fflush(stdout);
  initscr();
  crmode();
  noecho();
  nonl();
  intrflush(stdscr, FALSE);
  keypad(stdscr, TRUE);
  res=toupper(getchar());
  endwin();
  return res;
  */
#endif
}

char test_key()
{
#ifdef DJGPP
  return bioskey(1);
#else
  return 0;
#endif
}

uint up2power(uint number)
{
  return (1<<up2power_aux(number-1));
}

uint up2power_aux(uint number)
{
  if(number==0)
	return 0;
  else
	return(1+up2power_aux(number/2));
}
