/**
  * Sendmail version 1.0.0
  * Steve Kemp
  *
  */

#include "SendMail.h"

/* Options we accept */
struct option sendmail_options[] = {
    {"version", no_argument,NULL,'v'},
    {"help", no_argument,NULL,'h'},
    {"to", required_argument, NULL, ' t'},
    {"from", required_argument, NULL, 'f  '},
    {"body", required_argument, NULL, 'b'},
    {"attatch", required_argument, NULL, 'a'},
    {"subject", required_argument, NULL, 's'},
    {"mailhost", required_argument, NULL, 'm'},
    {"port", required_argument, NULL, 'p'},
    {0,0,0,0}
};



/**
  * Main entry point to code.
  */
int main( int argc, char *argv[] )
{
    CMIMEMessage msg;

    // Port number
    int port = 25;

    // B  uffer, and stream for reading message from
    char lineBuffer[ 1000 ];
    int lineBufferSize = 999;
    ifstream input; // The handle to the input file


    // Markers to see if the user has filled in enough
    // parameteres to send mail.
    int subject, to, from;
    subject = to = from = 0;

    CString server;
  
    int opt_index	       = 0;
    int retval	       = 0;

    /*    
     * Proce  ss the arguments...
     */
    retval = getopt_long (argc, argv, "tfsbamphv", sendmail_options, &opt_index);
    while (retval != EOF)
    {
        switch( retval)
        {
            case 'm':
                server = CString( optarg );
                break;
			case 'p':
				port = atoi(optarg);
				break;
            case 't': 
                msg.AddRecipient( CString( optarg ) );
                to = 1;
                break;
            case 'f':
                msg.m_sFrom = CString( optarg );
                from = 1;
                break;
            case 's':
                msg.m_sSubject = CString( optarg );
                subject = 1;
                break;
            case 'b':
                input.open( optarg, ios::in );
                if (input == NULL )
                {
                    printf( "Error opening input file :%s\n", optarg );
                    return 1;
                }
                while( input.getline( lineBuffer , lineBufferSize ) )
                {
                    msg.m_sBody += lineBuffer;
                    msg.m_sBody += "\r\n";
                }
                break;
            case 'a':
                msg.AddMIMEPart( CString( optarg ) );
                break;        
            case 'v':
                printf("\n" );
                showversion(argc, argv );
                exit(0);
                break;
            case 'h':
                printf("\n" );
                showusage(argc, argv );
                exit(0);
                break;
        }
    }

  
    // Only send mail if we have enought parameters.
    if ( to && from && server )
    {
        
        if ( !subject )
            msg.m_sSubject = CString( "[No Subject]" );
    
        printf("Sending ...");
        // Mail interface
        CSMTP smtp( server, port );
        smtp.Connect();
        smtp.SendMessage( &msg );
        smtp.Disconnect();       
  
        printf( " Done.\n" );
    }
    else
        showusage(argc, argv);

    return 0;
}


/**
  * Print usage information.
  */
void usage()
{
  printf( "Insufficient options, valid options are:\n\n" );
  printf ( "\t-t recipient -f sender -s subject -b filename -a filename -m mailserver\n" );
  printf ( "\t-t user@host.com\n" );
  printf ( "\t-f user@host.com\n" );
  printf ( "\t-s Mail subject\n" );
  printf ( "\t-b Text file to use for body of the message.\n" );
  printf ( "\t-a Filename of an attachment to include.\n" );
  printf ( "\t-m Mailhost.\n" );
  printf ( "\t-p Port Number.\n" );
  printf ( "\n[Attatchments are optional, and there may be multiple recipients specified.]\n\n" );
}


/*
 * Show the usage information for this program.
 */
void
showusage( int argc, char **argv)
{
    char *prog = argv[ 0 ];

    char *file;
    file = strrchr( prog, '\\' );
    if ( file )
    {
        prog = (file + 1 );
    }
    file = strrchr( prog, '/' );
    if ( file )
    {
        prog = (file + 1 );
    }
    showversion( argc, argv);

    printf ("\nusage: %s [<options>]\n", prog);
    printf ("Send mail from the command line.\n");
    printf ("-h, --help\t\t\tDisplay this message\n" );
    printf ("-v, --version\t\t\tDisplay the version number\n" );
    printf ("-t, --to\t\t\tSpecifies the recipients address\n" );
    printf ("-f, --from\t\t\tSpecifies the senders address\n" );
    printf ("-b, --body\t\t\tThe name of the text file to use for the body\n" );
    printf ("-a, --attatch\t\t\tSpecifies a file to attatch\n" );
    printf ("-s, --subject\t\t\tSpecifies the subject\n" );
    printf ("-m, --mailhost\t\t\tThe mailhost to use for sending\n" );
    printf ("-s, --subject\t\t\tSpecifies the subject\n" );
    printf ("-p, --port\t\t\tThe port to use for sending the message.\n" );
    printf ("\nReport bugs to Steve Kemp <skx@tardis.ed.ac.uk>\n");
}


/*
 * Show the version information for this program.
 */
void
showversion( int argc, char **argv)
{
    char *prog = argv[ 0 ];
    
    char *file;
    file = strrchr( prog, '\\' );
    if ( file )
    {
        prog = (file + 1 );
    }
    file = strrchr( prog, '/' );
    if ( file )
    {
        prog = (file + 1 );
    }

    printf( "%s version %s, (Compiled on %s).\n", prog,
            "2.1", __DATE__ );
}
