// OPCODE_OUTPUT.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "OPCODE_OUTPUT.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;

using namespace std;

static void asmfunc(void);	//must be static or we will get a vtable ptr
							//instead of the real function address

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
	}
	else
	{
		BYTE* myptr = (BYTE*)asmfunc; //Get a pointer to the function
		
		CFile file;
		CFileException err;

		if(!file.Open("asm_out.txt",CFile::modeCreate | CFile::modeWrite,&err))
		{
			err.ReportError();
			return 1;
		}
		
		while(myptr[0] != 0xC2 || myptr[1] != 0xFF || myptr[2] != 0x00) 
		{
			myptr++;	//find where our start marker is
		}
		myptr += 3;

		int index = 0;
		bool done = false;
		for(;!done;index++)
		{
			//grab our opcode bytes and output them nicely so we can place
			//them into a char buffer in C\C++ code easily
			char buff[5];
			CString txt;
			txt = "\\x";
			BYTE byte = myptr[index];
			if(myptr[index] == 0xEB && myptr[index+1] == 0x03 && myptr[index+2] == 0xC2 && myptr[index+3] == 0xFF && myptr[index+4] == 0x00)
			{	
				done = true; //marker found
			}
			else
			{
				_itoa(byte,buff,16);
				txt += buff;
				int x = txt.GetLength();
				file.Write(txt.GetBuffer(x),x);
				txt.ReleaseBuffer();
			}
			
		}

		file.Close();

		//asmfunc();	//you can call your function to test it if you like

	}

	return nRetCode;
}


void asmfunc(void)
{
	__asm	//leave this line of code ALONE!!! It is used as a marker
	{
		jmp next
		ret 0xff
		next:
	}
	
	
	__asm
	{
		//start your code insert here
		//you may replace all of this asm code with your asm code
		//to get your output
		/****NOTE**** DO NOT USE ZEROES ******/
		push        ebp
		push        ecx
		mov        ebp,esp
		sub         esp,10h
		xor         ecx,ecx
		push       ecx
		mov       dword ptr [ebp-4],0x1020AF90
		call        dword ptr[ebp-4]
		mov       esp,ebp
		pop       ecx
		pop       ebp
		//end your code insert here
	}
	

	__asm	//leave this line of code ALONE!!! It is used as a marker
	{
		jmp next1
		ret 0xff
		next1:
	}
}
