#!/usr/bin/perl
#This is the reigstry module to WCP.  Read legal junk in control.cgi.
#Same deal here.

#The purpose of this is to provide a traverseable registry key/value
#system similar to that implemented in Windows 98.

#THIS IS THE ONLY VARIABLE YOU SHOULD NEED TO CHANGE TO HAVE A
#FUNCTIONAL CONTROL PANEL OUT OF THE BOX (kind of)
$registry="/home/httpd/wcp/registry.dat";

#Now to the guts

#This is the procedure that READS the registry.
sub ReadReg {

	open(REG, "$registry")||die("Could not open registry");

	#Our goal is to create a list of full-path keys and their values
	#in an organized hash.  They will be stored in a "directory" based
	#on their paths for ease of maintenance.
	
	#A line starst with 1 + for each level of heirarchy it has.
	#It must have atleast 1 + or we get pissed.
	#All keys for a path will be attached to it.
	
	#Set our traverse level to 0
	$traverse = 1;
	while ($line = <REG>) {
	
		while ($line !~ /^\+/) {
			$line = <REG>;
		}
		
		#Count the +'s
		$line =~ /^(\++)(.*)/; 
		$plus = length($1);
		
		#Get the path and keys from the line
		($path, $keys) = split(/#/, $2);
	
		if ($plus <= $traverse) {
		
			#Pop off elements for each one below traverse
			for ($x=$traverse; $x>=$plus; $x--) {

				pop(@level);

			}
		}
			
		#Now add the new path to the traversal
		push(@level, $path);
		
		#Assemble a full path name for the key
		$fullpath = join("/", @level);
			
		#Add the keys for this path to the array. Set no-key paths to 0
		if (!$keys) { $keys = 1; }
		$keys{$fullpath} = $keys;	
		#Refresh the traversal level before the next loop
		$traverse = $plus;

	}

close REG;

} #End of ReadReg

#This is the procedure that WRITES the registry.
sub WriteReg {

	open(REG, ">$registry")||die("Could not open registry for write");

	#We have a lovely hash of paths and their list of keys.

	#Go through each key/value in the hash, sorting for heirarchy.
	foreach $path (sort keys %keys) {

		#Do a plus count and break up path
		@pathpieces = split(/\//, $path);
		$plus = "";
		for ($x = 0; $x < @pathpieces; $x++) {
			$plus = $plus . "+";
		}
	

		#If this path has no keys, don't print em.
		if (($keys{$path} != 1)&&($keys{$path} != 2)) {
			print REG "$plus$pathpieces[@pathpieces-1]#$keys{$path}\n";
		} elsif ($keys{$path} != 2) {
			print REG "$plus$pathpieces[@pathpieces-1]\n";
		}
	}

	#Quick and painless. I should've been a nurse.
	close REG;

} #End of WriteReg

#Here we get right down to the nit and gritty.
#Add a key to the hash.  This implies that we must check to see
#if the path does or does not have keys already and for that matter
#if it doesn't even exist!

sub AddKey {

	#READ THE REGISTRY
	&ReadReg;
	

	($keypath) = @_;
	
	if (!$keypath) {
	
		#Jerk forgot to supply parameters. KILL HIM!
		return 0;		
	}

	#Now we need to do the big ugly... strip away the last part
	#for the keyval and the rest for the path

	#We cannot use this method anymore because a key could
	#conceivably have a / in the value, breaking everything.
	#A Quickie Fix is to split out the value, get the key,
	#then put the value back in.
	
	($tpath, $val) = split(/=/, $keypath);
	@path = split(/\//, $tpath);
	$key = pop(@path);
	$path = join("/", @path);
	
	#Dork die again if the keypath was invalid
	if ((!$val)||(!$path)) {
	
		#Jerk supplied bad parameters
		return 0;
		
	}
	
	#This line says "If there is a path defined here and it has at
	#least one keyval, append the existing keyval."
	if (($keys{$path})&&($keys{$path} != 1)) {
		
		#Grab the key/vals to work with
		$keyval = $keys{$path};
		$keyval = $keyval . "%" . $key . "=" . $val;
		$keys{$path} = $keyval;
	
	}
	#This conditional says "If there is a path defined here but
	#no keys, make a new keyval"
	if (($keys{$path})&&($keys{$path} == 1)) {
	
		$keyval = $key . "=" . $val;
		$keys{$path} = $keyval;
			
	}
	#This conditional says "If there is no path defined here, make one
	#and add the keyval."
	if (!$keys{$path}) {
		$keyval = $key . "=" . $val;
		$keys{$path} = $keyval;
	}

	#Isolate the part of the path we want.
	(@pathpieces)=split(/\//,$path);
	
	#IMPORTANT!  We have to ensure that the path heirarchy exists
	#everywhere.
	
	for ($x = 0; $x < @pathpieces; $x++) {
	
		#Assemble full name out of it
		$fullpath = "";
		for ($i = 0; $i <= $x; $i++) {
			if (!$fullpath) {
				$fullpath = $pathpieces[$i];
			} else {
				$fullpath = $fullpath . "/" . $pathpieces[$i];
			}
		}
		#See if it exists
		if ((!$keys{$fullpath})&&($keys{$fullpath} != 1)) {
		
			#Doesn't exist.  Make it exist
			$keys{$fullpath}=1;
		}
	}

	#Write our registry back out
	&WriteReg;
	
	#Return successfully
	return 1;
	
	#We're finito. Key added.  World peace.	
} #End of AddKey

#This gets tricky funk weird.  What we need to do is strip path and key.
#The key is what's contained after the last slash.  Then we need to read
#the keys for the path and rewrite them, leaving out the one we're looking
#for.  It gets hairy.

sub RemoveKey {

	#READ THE REGISTRY!
	&ReadReg;
	
	($keypath) = @_;
	
	if (!$keypath) {
	
		#Jerk forgot to supply parameters. KILL HIM!
		return 0;
			
	}
	
	#Now we need to do the big ugly... strip away the last part
	#for the keyval and the rest for the path
	@path = split(/\//, $keypath);
	$key = pop(@path);
	$path = join("/", @path);
	
	#Dork die again if the keypath was invalid
	if ((!$key)||(!$path)) {
	
		#Jerk supplied bad parameters
		return 0;
		
	}
	#This line says "If there is a path defined here and it has at
	#least one keyval, check to see if our keyval is here"
	if (($keys{$path})&&($keys{$path} != 1)) {
		
		#Grab the key/vals to work with
		$keyval = $keys{$path};
		@keyvals = split(/\%/, $keyval);
		
		#Check em
		for ($x = 0; $x < @keyvals; $x++) {
		
			#($key) = split(/\=/, $keyvals[$x]);
			($skey, $sval) = split(/\=/, $keyvals[$x]);
			if ($skey =~ /$key/) {
			
				#Key matched
				splice(@keyvals, $x, 1);
			}
		}
		
		#Reform keys into an array
		$keyval = join("%", @keyvals);

		#If there are no more keys left make it 1 for writing ease
		if (!$keyval) {
			$keyval = 1;
		}
		
		#Put it back into the keyval hash
		$keys{$path} = $keyval;
	
	}
	
	#Write out the registry
	&WriteReg;
	
	#Return Successful
	return 1;

}

sub RemovePath {

	#READ THE REGISTRY!
	&ReadReg;
	
	($path) = @_;
	
	if (!$path) {
	
		#Jerk forgot to supply parameters. KILL HIM!
		return 0;
		
	}
	
	@path = split(/\//, $path);
	$path = join("/", @path);
	
	#Now we have to go through EVERY keypath. Hideous, really...
	foreach $cpath (sort keys %keys) {
		
		if ($cpath =~ /^$path/) {
		
			#It's a match, away it goes
			#Setting its keyval to 2 will signal to the writer
			#that this needs to go.
			$keys{$cpath} = 2
		}
		
	}
	
	#Write out the registry
	&WriteReg;
	
	#Return Successful
	return 1;

}

#This is why we came here aint it?
#This will retrieve a path/key combo for the value
sub GetKey {

	#READ THE REGISTRY!
	&ReadReg;
	
	#We set the found boolean to 0.  This means that
	#the key has not ben found yet.
	$found = 0;
	
	#Grab parameters
	($keypath) = @_;
	
	#Make sure they were specified
	if (!$keypath) {
	
		#Jerk forgot to supply parameters. KILL HIM!
		return 0;
		
	}
	
	#Divide the path/key into an array and pop off the last element
	#This is the key.
	@path = split(/\//, $keypath);
	$key = pop(@path);
	#Reassemble our path (minus key)
	$path = join("/", @path);
	
	#Dork die again if the keypath was invalid
	if ((!$key)||(!$path)) {
	
		#Jerk supplied bad parameters
		return 0;
		
	}

	#This line says "If there is a path defined here and it has at
	#least one keyval, check to see if our keyval is here"
	if (($keys{$path})&&($keys{$path} != 1)) {
		
		#Grab the key/vals to work with
		$keyval = $keys{$path};
		@keyvals = split(/\%/, $keyval);
		
		#Check em
		for ($x = 0; $x < @keyvals; $x++) {
		
			#($key) = split(/\=/, $keyvals[$x]);
			($skey, $sval) = split(/\=/, $keyvals[$x]);
			if ($skey =~ /$key/) {
			
				#Key matched. Mark found and set it.
				$fval = $sval;
				$found = 1;
			}
		}
		
	}

	#If we found the key, return the value.  If not, return 0	
	if ($found == 1) {
		return $fval;
		
	} else {
		return 0;
	}
}

#This function returns all key/vals in a given path as a hash
sub GetKeyHash {

	#READ THE REGISTRY!
	&ReadReg;
	
	#Grab parameters
	($path) = @_;
	
	#Make sure they were specified
	if (!$path) {
	
		#Jerk forgot to supply parameters. KILL HIM!
		return 0;
		
	}
	
	#This line says "If there is a path defined here and it has at
	#least one keyval, check to see if our keyval is here"
	if (($keys{$path})&&($keys{$path} != 1)) {
		
		#Grab the key/vals to work with
		$keyval = $keys{$path};
		@keyvals = split(/\%/, $keyval);
		
		#Check em
		for ($x = 0; $x < @keyvals; $x++) {
		
			($skey, $sval) = split(/\=/, $keyvals[$x]);
			$keys{$skey} = $sval;
		}		
	}

	return %keys;
}

#We'll take a key and change it to another value
sub ChangeKey {

	#READ THE REGISTRY!
	&ReadReg;
	
	#We set the found boolean to 0.  This means that
	#the key has not ben found yet.
	$found = 0;
	
	#Grab parameters
	($keypath) = @_;
	
	#Split the parameter into a keypath and new value
	($keypath, $newval) = split(/\=/, $keypath);	

	#Make sure they were specified
	if ((!$keypath)||(!$newval)) {
	
		#Jerk forgot to supply parameters. KILL HIM!
		return 0;
		
	}
	
	#Divide the path/key into an array and pop off the last element
	#This is the key.
	@path = split(/\//, $keypath);
	$key = pop(@path);
	#Reassemble our path (minus key)
	$path = join("/", @path);
	
	#Dork die again if the keypath was invalid
	if ((!$key)||(!$path)) {
	
		#Jerk supplied bad parameters
		return 0;
		
	}

	#This line says "If there is a path defined here and it has at
	#least one keyval, check to see if our keyval is here"
	if (($keys{$path})&&($keys{$path} != 1)) {
		
		#Grab the key/vals to work with
		$keyval = $keys{$path};
		@keyvals = split(/\%/, $keyval);
		
		#Check em
		for ($x = 0; $x < @keyvals; $x++) {
		
			($skey, $sval) = split(/\=/, $keyvals[$x]);
			if ($skey =~ /$key/) {
			
				#Key matched. Mark found and set it.
				$keyvals[$x] = "$skey=$newval";
				$found = 1;
			}
		}

		$keys{$path} = join('%', @keyvals);
		
	}

	#If we found the key, return successful.  If not, return 0	
	#Also we'll write out the registry if successful
	if ($found == 1) {
		&WriteReg;
		return 1;
		
	} else {
		return 0;
	}
}

#Show the registry in a tree-u-lar format
sub ShowRegistry {

	open(REG, "$registry")||die("Could not open registry");

	#Set our traverse level to 0
	$traverse = 0;
	while ($line = <REG>) {
	

		$spacer = "";
		while ($line !~ /^\+/) {
			$line = <REG>;
		}
		
		#Count the +'s
		$line =~ /^(\++)(.*)/; 
		$plus = length($1);
		$traverse = $plus;
		
		#Get the path and keys from the line
		($path, $keys) = split(/#/, $2);
	
		if ($plus <= $traverse) {
		
			#Pop off elements for each one below traverse
			for ($x=$traverse; $x>=$plus; $x--) {

				pop(@level);

			}
		}
			
		#Now add the new path to the traversal
		push(@level, $path);
		
		for ($x = 0; $x<$traverse; $x++) { $spacer = $spacer . " "; }
		print "$spacer$path\\\n";
		
		if ($keys) { 
		
			(@keyvals) = split(/%/, $keys);
			for ($x=0;$x<@keyvals;$x++) {
				($key, $val) = split(/=/, $keyvals[$x]);
				print "$spacer Key: $key - Value: $val\n";
			}		
		}
		
		#Add the keys for this path to the array. Set no-key paths to 0
		if (!$keys) { $keys = 1; }
		$keys{$fullpath} = $keys;	

	}

close REG;

} #End of ReadReg

#This tells perl we have a library.
1;


