library fpu;

{ Sample DLL for ViRC 2.0. This illustrates how to perform tasks externally
  that are difficult to do from a script.

  To use this from ViRC:
    $dll(fpu.dll fadd 1.23 4.56)
    $dll(fpu.dll fsub 1.23 4.56)
    $dll(fpu.dll fmul 1.23 4.56)
    $dll(fpu.dll fdiv 1.23 4.56)
    $dll(fpu.dll fsqrt 199)
    $dll(fpu.dll fround 21.6)
    /dll fpu.dll showver

  New for pre8 - persistent DLL support, using VSPersist and p_* functions...
    @ $fpuinst = $LoadDLL(fpu.dll)
    $dll($fpuinst fadd 1.23 4.56)
    ...
    FreeDLL $fpuinst

  A few aliases are defined by this VSPersist, so you can actually do this:
    @ $fpuinst = $LoadDLL(fpu.dll)
    $fadd(1.23 4.56)
    ...
    FreeDLL $fpuinst
}

uses
  SysUtils,
  Classes,
  Windows,
  Math;

// exported functions

// persistent versions:

type
  TDLLExecProc = procedure (X: PChar) stdcall;
  TDLLParseVarsProc = function (T, B: PChar; BS: Integer): Integer stdcall;
  TDLLDirectAliasProc = procedure (T, A, P: PChar) stdcall;
  
  PDLLInitStruct = ^TDLLInitStruct;
  TDLLInitStruct = packed record
    StructVer, StructSize: Word;
    ClientBuild, ClientPre: Word;
    ClientName, DLLToken: packed array[0..15] of Char;
    MainHWND, ClientHWND: HWND;
    // callback routines
    IRCExec: TDLLExecProc;
    Execute: TDLLExecProc;
    ParseVars: TDLLParseVarsProc;
    DirectAlias: TDLLDirectAliasProc;
  end;

function VSPersist(Params: PChar; InitStruct: PDLLInitStruct): Integer; stdcall;
begin
  // indicate success
  Result := 1;

  // set up the aliases
  with InitStruct^ do
  begin
    DirectAlias(DLLToken, 'fadd', 'fadd');
    DirectAlias(DLLToken, 'fsub', 'fsub');
    DirectAlias(DLLToken, 'fmul', 'fmul');
    DirectAlias(DLLToken, 'fdiv', 'fdiv');
    DirectAlias(DLLToken, 'fsqrt', 'fsqrt');
    DirectAlias(DLLToken, 'fround', 'fround');
  end;
end;

function p_fadd(Active: HWND; Channel, Buffer: PChar; BufSize: Integer;
  Silent: Boolean; Reserved: Pointer): Integer; stdcall;
var
  p: PChar;
  f1, f2: Extended;
begin
  // tell ViRC we're returning a string
  Result := 1;

  // break Buffer at the space
  p := StrScan(Buffer, ' ');
  if p = nil then Exit;
  try
    p^ := #0;
    Inc(p);
    f1 := StrToFloat(string(Buffer));
    f2 := StrToFloat(string(p));
    StrPCopy(Buffer, FloatToStr(f1 + f2));   // copy the result into the buffer
  except
    // set the result to 0 in case of an error
    Buffer[0] := '0';
    Buffer[1] := #0;
  end;
end;

function p_fsub(Active: HWND; Channel, Buffer: PChar; BufSize: Integer;
  Silent: Boolean; Reserved: Pointer): Integer; stdcall;
var
  p: PChar;
  f1, f2: Extended;
begin
  // tell ViRC we're returning a string
  Result := 1;

  // break Buffer at the space
  p := StrScan(Buffer, ' ');
  if p = nil then Exit;
  try
    p^ := #0;
    Inc(p);
    f1 := StrToFloat(string(Buffer));
    f2 := StrToFloat(string(p));
    StrPCopy(Buffer, FloatToStr(f1 - f2));   // copy the result into the buffer
  except
    // set the result to 0 in case of an error
    Buffer[0] := '0';
    Buffer[1] := #0;
  end;
end;

function p_fmul(Active: HWND; Channel, Buffer: PChar; BufSize: Integer;
  Silent: Boolean; Reserved: Pointer): Integer; stdcall;
var
  p: PChar;
  f1, f2: Extended;
begin
  // tell ViRC we're returning a string
  Result := 1;

  // break Buffer at the space
  p := StrScan(Buffer, ' ');
  if p = nil then Exit;
  try
    p^ := #0;
    Inc(p);
    f1 := StrToFloat(string(Buffer));
    f2 := StrToFloat(string(p));
    StrPCopy(Buffer, FloatToStr(f1 * f2));   // copy the result into the buffer
  except
    // set the result to 0 in case of an error
    Buffer[0] := '0';
    Buffer[1] := #0;
  end;
end;

function p_fdiv(Active: HWND; Channel, Buffer: PChar; BufSize: Integer;
  Silent: Boolean; Reserved: Pointer): Integer; stdcall;
var
  p: PChar;
  f1, f2: Extended;
begin
  // tell ViRC we're returning a string
  Result := 1;

  // break Buffer at the space
  p := StrScan(Buffer, ' ');
  if p = nil then Exit;
  try
    p^ := #0;
    Inc(p);
    f1 := StrToFloat(string(Buffer));
    f2 := StrToFloat(string(p));
    StrPCopy(Buffer, FloatToStr(f1 / f2));   // copy the result into the buffer
  except
    // set the result to 0 in case of an error
    Buffer[0] := '0';
    Buffer[1] := #0;
  end;
end;

function p_fsqrt(Active: HWND; Channel, Buffer: PChar; BufSize: Integer;
  Silent: Boolean; Reserved: Pointer): Integer; stdcall;
var
  f: Extended;
begin
  // tell ViRC we're returning a string
  Result := 1;
  
  try
    f := StrToFloat(string(Buffer));
    StrPCopy(Buffer, FloatToStr(Sqrt(f)));
  except
    Buffer[0] := '0';
    Buffer[1] := #0;
  end;
end;

function p_fround(Active: HWND; Channel, Buffer: PChar; BufSize: Integer;
  Silent: Boolean; Reserved: Pointer): Integer; stdcall;
var
  f: Extended;
begin
  // tell ViRC we're returning a string
  Result := 1;

  try
    f := StrToFloat(string(Buffer));
    StrPCopy(Buffer, IntToStr(Round(f)));
  except
    Buffer[0] := '0';
    Buffer[1] := #0;
  end;
end;

// non-persistent (mIRC compatible) versions:

function fadd(Main, Active: HWND; Data, Params: PChar; Show, NoPause: BOOL): Integer; stdcall;
var
  p: PChar;
  f1, f2: Extended;
begin
  Result := 3;       // tell ViRC that the function is returning a string value
  // break Data at the space
  p := StrScan(Data, ' ');
  if p = nil then Exit;
  try
    p^ := #0;
    Inc(p);
    f1 := StrToFloat(string(Data));
    f2 := StrToFloat(string(p));
    StrPCopy(Data, FloatToStr(f1 + f2));   // copy the result into the buffer
  except
    // set the result to 0 in case of an error
    Data[0] := '0';
    Data[1] := #0;
  end;
end;

function fsub(Main, Active: HWND; Data, Params: PChar; Show, NoPause: BOOL): Integer; stdcall;
var
  p: PChar;
  f1, f2: Extended;
begin
  Result := 3;
  p := StrScan(Data, ' ');
  if p = nil then Exit;
  try
    p^ := #0;
    Inc(p);
    f1 := StrToFloat(string(Data));
    f2 := StrToFloat(string(p));
    StrPCopy(Data, FloatToStr(f1 - f2));
  except
    Data[0] := '0';
    Data[1] := #0;
  end;
end;

function fmul(Main, Active: HWND; Data, Params: PChar; Show, NoPause: BOOL): Integer; stdcall;
var
  p: PChar;
  f1, f2: Extended;
begin
  Result := 3;
  p := StrScan(Data, ' ');
  if p = nil then Exit;
  try
    p^ := #0;
    Inc(p);
    f1 := StrToFloat(string(Data));
    f2 := StrToFloat(string(p));
    StrPCopy(Data, FloatToStr(f1 * f2));
  except
    Data[0] := '0';
    Data[1] := #0;
  end;
end;

function fdiv(Main, Active: HWND; Data, Params: PChar; Show, NoPause: BOOL): Integer; stdcall;
var
  p: PChar;
  f1, f2: Extended;
begin
  Result := 3;
  p := StrScan(Data, ' ');
  if p = nil then Exit;
  try
    p^ := #0;
    Inc(p);
    f1 := StrToFloat(string(Data));
    f2 := StrToFloat(string(p));
    StrPCopy(Data, FloatToStr(f1 / f2));
  except
    Data[0] := '0';
    Data[1] := #0;
  end;
end;

function fsqrt(Main, Active: HWND; Data, Params: PChar; Show, NoPause: BOOL): Integer; stdcall;
var
  f: Extended;
begin
  Result := 3;
  try
    f := StrToFloat(string(Data));
    StrPCopy(Data, FloatToStr(Sqrt(f)));
  except
    Data[0] := '0';
    Data[1] := #0;
  end;
end;

function fround(Main, Active: HWND; Data, Params: PChar; Show, NoPause: BOOL): Integer; stdcall;
var
  f: Extended;
begin
  Result := 3;
  try
    f := StrToFloat(string(Data));
    StrPCopy(Data, IntToStr(Round(f)));
  except
    Data[0] := '0';
    Data[1] := #0;
  end;
end;

function showver(Main, Active: HWND; Data, Params: PChar; Show, NoPause: BOOL): Integer; stdcall;
const
  DLLVer = 'fpu.dll demo by Jesse McGrew, version 1.1, 31 May 2001';
  Advert = ' (http://www.visualirc.com)';
begin
  Result := 2;    // the function returns a command to be run
  // running under ViRC?
  if StrLComp(Params, 'ViRC ', 5) = 0 then
    StrCopy(Data, 'MessageBox ' + DLLVer)
  else
    StrCopy(Data, '/echo 4 ' + DLLVer + Advert);
end;

exports
  VSPersist, p_fadd, p_fsub, p_fmul, p_fdiv, p_fsqrt, p_fround,
  fadd, fsub, fmul, fdiv, fsqrt, fround, showver;

begin
end.
