###
#>> Sin(zero) v2.3
#>>
###
#> Written by Ian D. E. (a Chaotic Realms Development)
#
#          _/_/_/_/                    _/            _/
#         _/                         _/   _/_/_/_/   _/
#        _/          _/             _/  _/       _/  _/
#       _/_/_/_/_/      _/_/   _/  _/  _/       _/  _/
#              _/  _/  _/ _/  _/  _/  _/       _/  _/
#             _/  _/  _/  _/ _/  _/  _/       _/  _/
#      _/_/_/_/  _/  _/   _/_/   _/   _/_/_/_/  _/
#
###
#>               http://www.chaoticrealms.com
#>                    chaos@chaoticrealms.com
###
#############################################
#  Filename        : sin0.tcl
#  Author          : Ian D. E. (Chaotic Realms Developer)
#  Script type     : IRC Script
#  Script platform : Windows 95/98/NT
#  Script client   : XiRCON v1.0b4
#  Website         : http://www.chaoticrealms.com
#  Email           : chaos@toolcity.net
#############################################
#
#  If you have questions about certain commands, please turn to /help or the
#  support docs first, if you still have unanswered questions after consulting
#  both of those resources, then contact me.  Much time has gone into both the
#  help and the support docs to make them adequate resources for information.
#
#############################################


set sin_zero(load_start) [clock clicks]
set sin_zero(truevers) "2.3"
set sin_zero(version) "Sin(zero/2.3)"
set sin_zero(build) 561
set sin_zero(show_output) 1
set sin_zero(quotes) {
  "/me is in flavor country.. %s" "/say Stay close a little longer, longer with %s"
  "/me is IRCing in style with %s" "/say %s: the only script with retsyn"
  "/say Burn the Witches with %s" "/say %s: you cannot sedate, all the things you hate"
  "/me senses the darkness clearer [%s]" "/me is IRCin' wiff %s"
  "/say Aren't you glad you use %s?  Don't you wish everybody did?" "/say %s: The Age of Panic"
  "/say %s: Take in the extent of my Sin." "/say %s: New aspirin free formula."
  "/say %s: Made cold, to cool you to the core." "/say %s: Your dishwasher was designed for me."
  "/say %s: Go ahead and use me, everyone else does." "/say %s: Material things will fail you."
  "/say Grant Hill endorses %s, shouldn't you?" "/say %s: recommended by nine out of ten proctologists"
  "/say %s: mmmm....Beefy!" "/say For each call made with %s, a portion of the proceeds goes towards the benifit of me."
  "/say %s: A proud sponser of Festering Goat Piss, The Drink of Champions" "/say It's %s Time"
  "/say %s: Drive Happy" "/say %s: There's nothing prettier than a pretty Panda"
  "/say %s: We can dance, We can dance!" "/say %s: like a rock"
  "/say %s: If I'm saying this, then I must be a Sin(zero) user!" "/say %s: Keep it in your pants!"
  "/say %s: Recomended by Doctor Mom." "/say %s: It's not just for breakfast anymore"
  "/say %s: The cause of, and solution to, all of life's problems." "/say %s: Just when you thought it was safe to go outside..."
  "/say %s: Now in new anti-drowsy formula!" "/say %s: For fast relief from Sinus Pressure."
  "/say Ever stop to think.... and then forget to start? - %s -" "/say %s: Take it like a man!"
  "/say %s: Where the rich get richer, and the poor get poorer" "/say New high-octane %s for the engine with umpFF!"
  "/say %s: Goo Goo Ga-Choo!" "/say %s: Do you ever yearn?"
  "/say %s: Have you ever seen a grown man naked?" "/me breathes friendly with %s"
  "/me is loaded with Sinergy! \[%s\]" "/say Off with the pants! \[%s\]"
  "/say %s: This is thick headed." "/say %s: The script with an extra chromosome!"
  "/say %s: The lord of ambiguity" "/say %s: As erroneus as the next guy"
  "/say %s: Anything's possible" "/say %s: Paved with good intentions"
  "/say %s: Tell me Jimmy, do you like gladiators?" "/say Is your wife a goer? Nudge nudge. %s"
  "/say %s: The Harrasment Endorser" "/say %s: THe end of the Line"
  "/say %s: Let the games begin!" "/say %s: Isn't it about.. \"time\""
}

set sin_zero(FALC_LOAD) 1
if [catch {load [pwd]/falcon.dll}] {
  if [catch {load /windows/system/falcon.dll}] {
    if [catch {load falcon.dll}] {
      echo "[color error]*** Falcon.dll could not be loaded.  The Falcon library (written by David Gravereaux) is required for Sin(zero) to run."
      set sin_zero(FALC_LOAD) 0
      on load { foreach s [scripts] { if ![string compare [string tolower [file tail $s]] "sin0.tcl"] { /unload $s; break } } }
      return
    }
  }
}
set extra_info(countries) {
  "AD Andorra"
  "AE United Arab Emirates"
  "AF Afghanistan"
  "AG Antigua and Barbuda"
  "AI Anguilla"
  "AL Albania"
  "AM Armenia"
  "AN Netherlands Antilles"
  "AO Angola"
  "AQ Antarctica"
  "AR Argentina"
  "AS American Samoa"
  "AT Austria"
  "AU Australia"
  "AW Aruba"
  "AZ Azerbaijan"
  "BA Bosnia and Herzegowina"
  "BB Barbados"
  "BD Bangladesh"
  "BE Belgium"
  "BF Burkina Faso"
  "BG Bulgaria"
  "BH Bahrain"
  "BI Burundi"
  "BJ Benin"
  "BM Bermuda"
  "BN Brunei Darussalam"
  "BO Bolivia"
  "BR Brazil"
  "BS Bahamas"
  "BT Bhutan"
  "BV Bouvet Island"
  "BW Botswana"
  "BY Belarus"
  "BZ Belize"
  "CA Canada"
  "CC Cocos Islands"
  "CF Central African Republic"
  "CG Congo"
  "CH Switzerland"
  "CI Cote D'Ivoire"
  "CK Cook Islands"
  "CL Chile"
  "CM Cameroon"
  "CN China"
  "CO Colombia"
  "CR Costa Rica"
  "CU Cuba"
  "CV Cape Verde"
  "CX Christmas Island"
  "CY Cyprus"
  "CZ Czech Republic"
  "DE Germany"
  "DJ Djibouti"
  "DK Denmark"
  "DM Dominica"
  "DO Dominican Republic"
  "DZ Algeria"
  "EC Ecuador"
  "EE Estonia"
  "EG Egypt"
  "EH Western Sahara"
  "ER Eritrea"
  "ES Spain"
  "ET Ethiopia"
  "FI Finland"
  "FJ Fiji"
  "FK Falkland Islands"
  "FM Micronesia"
  "FO Faeroe Islands"
  "FR France"
  "GA Gabon"
  "UK United Kingdom of Great Britain & N. Ireland"
  "GD Grenada"
  "GE Georgia"
  "GF French Guiana"
  "GH Ghana"
  "GI Gibraltar"
  "GL Greenland"
  "GM Gambia"
  "GN Guinea"
  "GP Guadaloupe including St. Barthelemy and French St. Martin"
  "GQ Equatorial Guinea"
  "GR Greece"
  "GS South Georgia and the South Sandwich Islands"
  "GT Guatemala"
  "GU Guam"
  "GW Guinea-Bissau"
  "GY Guyana"
  "HK Hong Kong"
  "HM Heard and McDonald Islands"
  "HN Honduras"
  "HR Hrvatska (Croatia)"
  "HT Haiti"
  "HU Hungary"
  "ID Indonesia"
  "IE Ireland"
  "IL Israel"
  "IN India"
  "IO British Indian Ocean Territory"
  "IQ Iraq"
  "IR Iran"
  "IS Iceland"
  "IT Italy"
  "JM Jamaica"
  "JO Jordan"
  "JP Japan"
  "KE Kenya"
  "KG Kyrgyz Republic"
  "KH Cambodia"
  "KI Kiribati"
  "KM Comoros"
  "KN Saint Kitts and Nevis"
  "KP Korea"
  "KR Korea"
  "KW Kuwait"
  "KY Cayman Islands"
  "KZ Kazakhstan"
  "LA Lao People's Democratic Republic"
  "LB Lebanon"
  "LC Saint Lucia"
  "LI Liechtenstein"
  "LK Sri Lanka"
  "LR Liberia"
  "LS Lesotho"
  "LT Lithuania"
  "LU Luxembourg"
  "LV Latvia"
  "LY Libyan Arab Jamahiriya S'list P. Libyan Arab Jamahiriya"
  "MA Morocco"
  "MC Monaco"
  "MD Moldova"
  "MG Madagascar"
  "MH Marshall Islands"
  "MK Macedonia"
  "ML Mali"
  "MM Myanmar"
  "MN Mongolia"
  "MO Macau"
  "MP Northern Mariana Islands"
  "MQ Martinique"
  "MR Mauritania"
  "MS Montserrat"
  "MT Malta"
  "MU Mauritius"
  "MV Maldives"
  "MW Malawi"
  "MX Mexico"
  "MY Malaysia"
  "MZ Mozambique"
  "NA Namibia"
  "NC New Caledonia"
  "NE Niger"
  "NF Norfolk Island"
  "NG Nigeria"
  "NI Nicaragua"
  "NL Netherlands"
  "NO Norway"
  "NP Nepal"
  "NR Nauru"
  "NU Niue"
  "NZ New Zealand"
  "OM Oman"
  "PA Panama"
  "PE Peru"
  "PF French Polynesia"
  "PG Papua New Guinea"
  "PH Philippines"
  "PK Pakistan"
  "PL Poland"
  "PM St. Pierre et Miquelon"
  "PN Pitcairn Island"
  "PR Puerto Rico"
  "PT Portugal"
  "PW Palau"
  "PY Paraguay"
  "QA Qatar"
  "RE Reunion"
  "RO Romania"
  "RU Russian Federation"
  "RW Rwanda"
  "SA Saudi Arabia"
  "SB Solomon Islands"
  "SC Seychelles"
  "SD Sudan"
  "SE Sweden"
  "SG Singapore"
  "SH St. Helena"
  "SI Slovenia"
  "SJ Svalbard & Jan Mayen Islands"
  "SK Slovakia"
  "SL Sierra Leone"
  "SM San Marino"
  "SN Senegal"
  "SO Somalia"
  "SR Suriname"
  "ST Sao Tome and Principe"
  "SU Russian Federation"
  "SV El Salvador"
  "SY Syrian Arab Republic"
  "SZ Swaziland"
  "TC Turks and Caicos Islands"
  "TD Chad"
  "TF French Southern Territories"
  "TG Togo"
  "TH Thailand"
  "TJ Tajikistan"
  "TK Tokelau"
  "TM Turkmenistan"
  "TN Tunisia"
  "TO Tonga"
  "TP East Timor"
  "TR Turkey"
  "TT Trinidad and Tobago"
  "TV Tuvalu"
  "TW Taiwan"
  "TZ Tanzania"
  "UA Ukraine"
  "UG Uganda"
  "UM United States Minor Outlying Islands"
  "US United States of America"
  "UY Uruguay"
  "UZ Uzbekistan"
  "VA Vatican City State"
  "VC Saint Vincent and the Grenadines"
  "VE Venezuela"
  "VG British Virgin Islands"
  "VI US Virgin Islands"
  "VN Viet Nam"
  "VU Vanuatu"
  "WF Wallis and Futuna Islands"
  "WS Samoa"
  "YE Yemen"
  "YT Mayotte"  
  "YU Montenegro and Serbia"
  "ZA South Africa"
  "ZM Zambia"
  "ZR Zaire"
  "ZW Zimbabwe"
  "NET Networking Organization"
  "COM Commercial Organization"
  "ORG Non-Profit Organization"
  "EDU Educational Organization"
  "GOV Government Organization"
  "MIL Military Organization"
}
proc addquote {type quote} {
  global sin_zero
  if ![info exists sin_zero(quotes)] { set sin_zero(quotes) "" }
  switch -- [stl $type] {
    "msg" { lappend sin_zero(quotes) "/say $quote" }
    "say" { lappend sin_zero(quotes) "/say $quote" }
    "text" { lappend sin_zero(quotes) "/say $quote" }
    "txt" { lappend sin_zero(quotes) "/say $quote" }
    "me" { lappend sin_zero(quotes) "/me $quote" }
    "action" { lappend sin_zero(quotes) "/me $quote" }
    default { lappend sin_zero(quotes) "/say $quote" }
  }
}

on load {
  global env
  if [info exists sin_zero(load_start)] { set load_fin [expr ([clock clicks]-$sin_zero(load_start))/1000.0]; echo "[c]00<[c]14\[[c]15Loaded: [c]00S[c]15i[c]14n[c]00([c]14zero[c]00)[c]15 in [c]14$load_fin[c]15 secs[c]14\][c]00>"; unset load_fin }
  set sin_zero(loadedup) 1; set env(sin_load) [clock clicks]; set sin_zero(load) $env(sin_load)
  if ![info exists AWAY_INFO] { if {[get_cookie tmp.away.[lindex [server] 0]] != ""} { set awayline [get_cookie tmp.away.[lindex [server] 0]]; set AWAY_INFO(away) 1; set AWAY_INFO(reason) [join [lindex $awayline 0]]; set AWAY_INFO(at) [join [lindex $awayline 1]]; set AWAY_INFO(msgs) [join [lindex $awayline 2]]; set AWAY_INFO(l) [get_tog "Away_Logging"]; set AWAY_INFO(e) [get_tog "Email_Address"]; set AWAY_INFO(p) [get_tog "Paging"]; unset awayline; set_cookie tmp.away.[lindex [server] 0] "" } { set AWAY_INFO(away) 0 } }
  if ![info exists USER_INFO] { set USER_INFO(hostname) [info hostname]; set USER_INFO(modes) [mode]; set USER_INFO(lagmeter) 0.000; if {[get_cookie tmp.serv.[lindex [server] 0]] != ""} { set USER_INFO(server) [get_cookie tmp.serv.[lindex [server] 0]]; set_cookie tmp.serv.[lindex [server] 0] "" } { set USER_INFO(server) [lindex [server] 0] }; if {[get_cookie tmp.online.[lindex [server] 0]] != ""} { set USER_INFO(online) [get_cookie tmp.online.[lindex [server] 0]]; set_cookie tmp.online.[lindex [server] 0] "" } { set USER_INFO(online) [clock seconds] } }
  if [string length [get_cookie "tmp.modes.[lindex [server] 0]"]] { set USER_INFO(modes) [get_cookie tmp.modes.[lindex [server] 0]]; set_cookie tmp.modes.[lindex [server] 0] "" }
  if [connected] { add_ial [my_nick] [my_user] [my_host]; set c ""; foreach c [channels] { window set_title [chanWindow $c [lindex [mode $c] 0] [get_chan_key [mode $c]] [get_chan_lim [mode $c]] [topic $c]] channel $c; set c [stl $c]; set CHAN_INFO($c:mode) [lindex [mode $c] 0]; set CHAN_INFO($c:topic) [topic $c]; set CHAN_INFO($c:key) [get_chan_key [mode $c]]; set CHAN_INFO($c:lim) [get_chan_lim [mode $c]] }; unset c }
  if [window exists query .HELP] { window set_title "Sin(zero/$sin_zero(truevers)) Help" query .HELP }
  if [window exists query .RDISP] { window set_title "Sin(zero) - Rdisp" query .RDISP }
  if [window exists query .WHOIS] { window set_title "Whois Domain Lookup" query .WHOIS }
  if [window exists query .TSEARCH] { window set_title "Sin(zero) - Tsearch" query .TSEARCH }
  if [window exists query .SAID] { window set_title "Sin(zero) - Said" query .SAID }
  build_tog "Crypt_Key" "abcd" "string"
  build_tog "Show_Decrypted" "on" "bool"
  build_tog "Auto_Decrypt" "on" "bool"
  build_tog "Auto_NComp" "on" "bool"
  build_tog "Auto_IALScan" "off" "bool"
  build_tog "Auto_Close_Chats" "off" "bool"
  build_tog "Auto_Join" "\001none\001" "string"
  build_tog "Away_Logging" "on" "bool"
  build_tog "Active_Window_Whois" "on" "bool"
  build_tog "AutoAway" "off" "bool"
  build_tog "AutoAwaySeconds" "600" "string"
  build_tog "JoinsInChan" "on" "bool"
  build_tog "PartsInChan" "on" "bool"
  build_tog "QuitsInChan" "on" "bool"
  build_tog "Query" "on" "bool"
  build_tog "Highlight_Nicks" "\001none\001" "string"
  build_tog "Highlight" "\001none\001" "string"
  build_tog "Default_Away_Message" "[b]g[b]one" "string"
  build_tog "Default_Kick_Message" "[u]s[b]Z[b][u]([b]k[b]icke[b]d[b])" "string"
  build_tog "Default_Text_Viewer" "notepad.exe" "string"
  build_tog "Paging" "on" "bool"
  build_tog "Page_File" "[pwd]/page.wav" "string"
  build_tog "Personal_Logging" "on" "bool"
  build_tog "Email_Address" "\001none\001" "string"
  build_tog "UserModes" "+iws" "string"
  build_tog "SoundDir" [pwd] "string"
  build_tog "Sound_Recursion" "on" "bool"
  build_tog "Sound_System" "on" "bool"
  build_tog "Cloak_CTCP" "off" "bool"
  build_tog "Cloak_DCC" "off" "bool"
  build_tog "Show_Links" "on" "bool"
  build_tog "KickBan_Msg" "[u]s[b]Z[b][u]([b]k[b]ick[u]\\[u]ba[b]n[b])" "string"
  build_tog "Motd" "always" "string"
  build_tog "Self_Ban_Protection" "on" "bool"
  build_tog "Xwall_List" "\001none\001" "string"
  build_tog "Ncomp" "0" "string"
  build_tog "NComp_Char" ":" "string"
  build_tog "Max_Tab" "5" "string"
  build_tog "AutoReLoad_styles" "off" "bool"
  build_tog "Beep_On_Highlight" "on" "bool"
  build_tog "Beep_On_Text" "on" "bool"
  build_tog "Beep_On_Notify" "on" "bool"
  build_tog "EasyRead" "off" "bool"
  build_tog "Auto_CTCP" "off" "bool"
  build_tog "UnHide_Text" "off" "bool"
  build_tog "Stats_On_Quit" "on" "bool"
  build_tog "Flood_Type" "mild" "string"
  build_tog "Flood_Prot" "on" "bool"
  build_tog "Back_On_Keypress" "on" "bool"
  build_tog "Lookup_On_Whois" "off" "bool"
  flood_setup
  set x "[pwd]/sin.ini"; if ![file exists [dirname $x]] { file mkdir [dirname $x] }
  if ![file exists $x] { filebuild $x }; set x "[pwd]/logs/awaymsgs.log"; if ![file exists [dirname $x]] { file mkdir [dirname $x] }; if ![file exists $x] { filebuild $x }; set x "[pwd]/logs/pagemsgs.log"; if ![file exists [dirname $x]] { file mkdir [dirname $x] }; if ![file exists $x] { filebuild $x }; unset x
}

proc def_flood_setting {type} {
  switch -- [stu $type] {
    "FPS" { return "5,30" }
    "FPM" { return "5,20" }
    "FPW" { return "5,10" }
    "FQS" { return "6,30" }
    "FQM" { return "5,20" }
    "FQW" { return "5,15" }
    "FCS" { return "5,60" }
    "FCM" { return "5,45" }
    "FCW" { return "5,30" }
  }
}
proc flood_setup {} {
  foreach t {"P" "Q" "S"} {
    foreach a {"S" "M" "W"} {
      if ![string length [get_cookie "F${t}${a}"]] {
        set_cookie "F${t}${a}" [def_flood_setting "F${t}${a}"]
      }
    }
  }
}
proc deFlood {what} {
  global FLOOD_SPOOL
  if [info exists FLOOD_SPOOL($what)] { unset FLOOD_SPOOL(${what}) }
}

###- Procedures -###

proc whoamistart {} {
  if [string length [get_env "WhoAmIStart"]] {
    return [eval return [get_env "WhoAmIStart"]]
  }
  return "[c]14[c]15-[c]00[c]15[c]14[c]15[c]00[c]15-[c]00[c]15[c]06\[[b]\[[c]13\[[b][shade [my_nick] 14 15 14][c]13[b]\][c]06\][b]\][c]15[c]00[c]15-[c]00[c]15[c]14[c]15[c]00[c]15-[c]14"
}
proc whoamiuserhost {} {
  if [string length [get_env "WhoAmIUserHost"]] {
    return [eval return [get_env "WhoAmIUserHost"]]
  }
  return "[c]14 [c]15user[c]14@[c]15host [c]13[b]:[b] [c]14[my_user][o][c]00@[c]14[my_host] [c]13[b]\[[b][c]15lag[c]00:[c]15 [lag][c]13[b]\][b]"
}
proc whoamilocal {} {
  if [string length [get_env "WhoAmILocal"]] {
    return [eval return [get_env "WhoAmILocal"]]
  }
  return "[c]14 [c]15info      [c]13[b]:[b] [c]14uptime[c]00:[c]14 [duration [uptime] "[c]00w[c]14" "[c]00d[c]14" "[c]00h[c]14" "[c]00m[c]14" "[c]00s[c]14" "" "" " "] [c]13[b]\[[b][c]15localhost[c]00:[c]15 [localhost][c]13[b]\][b]"
}
proc whoamiserver {} {
  if [string length [get_env "WhoAmIServer"]] {
    return [eval return [get_env "WhoAmIServer"]]
  }
  return "[c]14 [c]15server    [c]13[b]:[b] [c]14[serv] [c]00\[[c]14[port][c]00\]"
}
proc whoamionline {} {
  if [string length [get_env "WhoAmIOnline"]] {
    return [eval return [get_env "WhoAmIOnline"]]
  }
  return "[c]14 [c]15online    [c]13[b]:[b] [c]14[duration [online] "[c]00w[c]14" "[c]00d[c]14" "[c]00h[c]14" "[c]00m[c]14" "[c]00s[c]14" "" "" " "] [c]13[u]([u][c]14[duration [idle] "[c]00w[c]14" "[c]00d[c]14" "[c]00h[c]14" "[c]00m[c]14" "[c]00s[c]14" "" "" " "] [c]15idle[c]13[u])[u]"
}
proc whoamiaway {reason} {
  if [string length [get_env "WhoAmIAway"]] {
    return [eval return [get_env "WhoAmIAway"]]
  }
  return "[c]14 [c]15away      [c]13[b]:[b] [c]14$reason"
}
proc whoamiend {} {
  if [string length [get_env "WhoAmIEnd"]] {
    return [eval return [get_env "WhoAmIEnd"]]
  }
  return " "
}
proc localhost {} {
  global USER_INFO
  if ![info exists USER_INFO(hostname)] { set USER_INFO(hostname) [info hostname] }
  return $USER_INFO(hostname)
}
proc kick_menu {nick channel} {
  if [string length [get_env KickMenu]] {
    return [eval return [get_env KickMenu]]
  }
  return "[c]00[b][b][c]15[b][b][c]14[b][b] Kick Defense Menu [c]15-[c]14${channel}[c]15- [c]14[b][b][c]15[b][b][c]00\n[c]00 [c]14[b]^1[b]:[c]15 Kick $nick\n[c]00 [c]14[b]^2[b]:[c]15 Ban $nick\n[c]00. [c]14[b]^3[b]:[c]15 KickBan $nick\n "
}
proc cmpchar {c1 c2} {
  if {[asc $c1] == [asc $c2]} { return 1 }
  return 0
}
proc cmpchari {c1 c2} {
  if {[asc [stl $c1]] == [asc [stl $c2]]} { return 1 }
  return 0
}
proc strcmp {st1 st2} {
  return [string compare $st1 $st2]
}
proc strcmpi {st1 st2} {
  return [string compare [stl $st1] [stl $st2]]
}
proc flood_setting {} {
  if ![string compare [stl [get_tog "Flood_prot"]] "off"] { return "" }
  set fprot [get_tog "Flood_Type"]
  switch -- [stl $fprot] {
    "strong" { return "s" }
    "weak" { return "w" }
    default { return "m" }
  }
}
proc byte_format {bytes {indb " b"} {indk " kb"} {indm " Mb"}} {
  if ![isint $bytes] { return }
  if {$bytes >= 1024} {
    set kb [expr ${bytes}/1024.0]
    if {$kb >= 1024} {
      set mb [expr ${kb}/1024.0]
      set f "[format %0.2f $mb]${indm}"
    } {
      set f "[format %0.2f $kb]${indk}"
    }
  } {
    set f "${bytes}${indb}"
  }
  return $f
}
proc putdcc {nick text} {
  if [window exists chat $nick] {
    /privmsg =${nick} $text
  }
}
proc longest {list {num 0}} {
  if ![isint $num] { set num 0 }
  if {$num != 0} { set num 1 }
  set b ""
  foreach a $list { if ![string length $b] { set b $a } { if {[string length $a] > [string length $b]} { set b $a } } }
  if $num { return [string length $b] } { return $b }
}
proc userfile {} {
  set userf "[pwd]/sin.ini"
  if [file isdir $userf] { set userf "[file dirname $userf]/sin.ini" }
  set dir [file dirname $userf]
  if ![file exists $dir] { file mkdir $dir }
  set f [file tail $userf]
  set f [filefix $f]
  set userf $dir/$f
  if ![file exists $userf] { filebuild $userf }
  return $userf
}
proc dirname {path} {
  set path [replace $path "\\" "/"]
  if {[string index $path 0] == "~"} { set path "./$path" }
  set pos [string last "/" $path]
  if {$pos == -1} { return "." }
  set out [string range $path 0 [expr $pos-1]]
  if ![string length $out] { set out "/" }
  if [string match "?:" $out] { set out $out/ }
  return $out
}
proc idle {{set ""}} {
  global USER_INFO
  if ![info exists USER_INFO(idle)] { set USER_INFO(idle) 0 }
  if ![isint $set] {
    return $USER_INFO(idle)
  } {
    set USER_INFO(idle) $set
  }
}
proc lines fname {
  if [file exists $fname] {
    set x [open $fname "r"]
    set y 0
    while {![eof $x]} {
      incr y
      gets $x buf
    }
    catch {close $x}
    return $y
  }
}
proc line {fname line} {
  if [file exists $fname] {
    if ![isint $line] { set line [random 1 [lines $fname]] }
    set x 0
    set f [open $fname "r"]
    set buff ""
    while {![eof $f]} {
      gets $f buff
      incr x
      if {$x == $line} { break }
    }
    catch {close $f}
    return $buff
  }
}
proc randline fname {
  if [file exists $fname] {
    set lines [lines $fname]
    set line [line $fname [random 0 $lines]]
    return $line
  }
}
proc remini {f s {k ""}} {
  set rt 0
  if ![catch {open $f "r"} fb] {
    set rh 0
    set vlist ""
    while {![eof $fb]} {
      set vlist "${vlist}[read $fb]"
    }
    close $fb
    set vlist [split $vlist "\n"]
    set sw 0
    set fb [open $f w]
    foreach v $vlist {
      set v [string trim $v " "]
      if ![strcmpi [string index $v 0] "\["] {
        if ![strcmpi "\[$s\]" $v] {
          if ![string length $k] {
            set sw 1
            set rh 1
            set rt 1
          } {
            set rh 1
          }
        } elseif {$rh && ![string length $k]} {
          set rh 0
          set sw 0
        } {
          set rh 0
        }
      } elseif $rh {
        if {[string length $k] && [string match "[stl $k]=*" $v]} {
          set sw 1
          set rh 0
          set rt 1
        }
      }
      if !$sw {
        if [string length [replace $v "\n" ""]] { puts $fb $v }
      } elseif [string length $k] {
        set sw 0
      }
    }
    close $fb
  }
  return $rt
}
proc writeini {f s k val} {
  set rt 0
  if ![catch {open $f "r"} fb] {
    set rh 0
    set vlist ""
    while {![eof $fb]} {
      set vlist "${vlist}[read $fb]"
    }
    close $fb
    set vlist [split $vlist "\n"]
    set rh 0
    set fb [open $f w]
    foreach v $vlist {
      set v [string trim $v " "]
      if ![strcmpi [string index $v 0] "\["] {
        if ![strcmpi "\[$s\]" $v] {
          set rh 1
        } elseif $rh {
          puts $fb "${k}=${val}"
          set rt 1
        } {
          set rh 0
        }
      } elseif $rh {
        if [string match "[stl $k]=*" $v] {
          set v "[string range $v 0 [pos $v "="]]${val}"
          set rh 0
          set rt 1
        }
      }
      if [string length [replace $v "\n" ""]] { puts $fb $v }
    }
    if {!$rt && $rh} {
      puts $fb "${k}=${val}"
      set rt 1
    } elseif !$rt {
      puts $fb "\[$s\]\n${k}=${val}"
      set rt 1
    }
    close $fb
  }
  return $rt
}
proc readini {f s {k ""} {d ""}} {
  if ![catch {open $f "r"} fb] {
    set rh 0
    set vlist ""
    while {![eof $fb]} {
      gets $fb buff
      set buff [string trim $buff " "]
      if ![strcmpi [string index $buff 0] "\["] {
        if ![strcmpi "\[$s\]" $buff] {
          set rh 1
        } {
          set rh 0
        }
      } elseif $rh {
        if {[string match "[stl $k]=*" $buff] && [string length $k]} {
          set val [string range $buff [expr [pos $buff "="]+1] end]
          return $val
        } elseif ![string length $k] {
          set vlist "${vlist}${buff}\n"
        }
      }
    }
    close $fb
    if {[string length $vlist] && ![string length $k]} { return $vlist }
  }
  return $d
}
proc gethand {file mask} {
  set list [readini $file "users"]
  set handle ""
  foreach z [split $list "\n"] {
    set pos [pos $z "="]
    if {$pos < 1} { set hand "" } { set hand [string range $z 0 [expr $pos-1]] }
    set m [string range $z [expr $pos+1] end]
    set m [join [lindex [split $m ","] 0]]
    regsub -all {\|} $m \\\| mtmp
    regsub -all {\{} $mtmp \\\{ mtmp
    regsub -all {\}} $mtmp \\\} mtmp
    regsub -all {\[} $mtmp \\\[ mtmp
    regsub -all {\]} $mtmp \\\] mtmp
    regsub -all {\^} $mtmp \\\^ mtmp
    regsub -all {\|} $mask \\\| m2tmp
    regsub -all {\{} $m2tmp \\\{ m2tmp
    regsub -all {\}} $m2tmp \\\} m2tmp
    regsub -all {\[} $m2tmp \\\[ m2tmp
    regsub -all {\]} $m2tmp \\\] m2tmp
    regsub -all {\^} $m2tmp \\\^ m2tmp    
    if {[string match [stl $mtmp] [stl $mask]] || [string match [stl $m2tmp] [stl $m]]} {
      set handle $hand
      break
    }
  }
  return $handle
}
proc umode2fstring {level} {
  set fl ""
  if {[expr $level-16] >= 0} { set fl "${fl}o"; incr level -16 }
  if {[expr $level-8] >= 0} { set fl "${fl}p"; incr level -8 }
  if {[expr $level-4] >= 0} { set fl "${fl}v"; incr level -4 }
  if {[expr $level-2] >= 0} { set fl "${fl}b"; incr level -2 }
  if {[expr $level-1] >= 0} { set fl "${fl}k"; incr level -1 }
  return $fl
}
proc getlevel {file hand chan} {
  set list [readini $file "users"]
  set level 0
  foreach z [split $list "\n"] {
    set pos [pos $z "="]
    if {$pos < 1} { set f "" } { set f [string range $z 0 [expr $pos-1]] }
    if ![string compare [stl $hand] [stl $f]] {
      set mask [string range $z [expr $pos+1] end]
      set c [join [lrange [split $mask ","] 2 end]]
      if {![string compare $c "\*"] || [lfind $c $chan]} {
        set level [lindex [split $mask ","] 1]
        break
      }
    }
  }
  if [isint $level] { set level [umode2fstring $level] }
  return $level
}
proc getmask {file hand} {
  set list [readini $file "users"]
  set level 0
  foreach z [split $list "\n"] {
    set pos [pos $z "="]
    if {$pos < 1} { set f "" } { set f [string range $z 0 [expr $pos-1]] }
    if ![string compare [stl $hand] [stl $f]] {
      set mtmp [string range $z [expr $pos+1] end]
      set mask [string range $mtmp 0 [expr [pos $mtmp ","]-1]]
      return $mask
      break
    }
  }  
}
proc asc2ans {ansval} {
  set ans [string range $ansval 2 [expr [string length $ansval]-2]]
  set c [lindex [split $ans ";"] 0]
  set r [lindex [split $ans ";"] 1]
  if {![string compare $c "0"] && ![string length $r]} { return "[o][c][basecolor]" }
  set swap 0; set undr 0; set revr 0; set desc 0
  switch -- $c {
    "1" { set swap 1 }
    "4" { set undr 1 }
    "5" { set revr 1 }
    "7" { set revr 1 }
    "8" { set desc 1 }
  }
  if $desc { return "[o][c]01,01a" }
  switch -- $r {
    "30" { if !$swap { set out "[c]01" } { set out "[c]14" } }
    "31" { if !$swap { set out "[c]05" } { set out "[c]04" } }
    "32" { if !$swap { set out "[c]03" } { set out "[c]09" } }
    "33" { if !$swap { set out "[c]07" } { set out "[c]08" } }
    "34" { if !$swap { set out "[c]02" } { set out "[c]12" } }
    "35" { if !$swap { set out "[c]06" } { set out "[c]13" } }
    "36" { if !$swap { set out "[c]10" } { set out "[c]11" } }
    "37" { if !$swap { set out "[c]15" } { set out "[c]00" } }
    "40" { if !$swap { set out "[c]15,01" } { set out "[c]01,14" } }
    "41" { if !$swap { set out "[c]01,05" } { set out "[c]01,04" } }
    "42" { if !$swap { set out "[c]01,03" } { set out "[c]01,09" } }
    "43" { if !$swap { set out "[c]01,07" } { set out "[c]01,08" } }
    "44" { if !$swap { set out "[c]01,02" } { set out "[c]01,12" } }
    "45" { if !$swap { set out "[c]01,06" } { set out "[c]01,13" } }
    "46" { if !$swap { set out "[c]01,10" } { set out "[c]01,11" } }
    "47" { if !$swap { set out "[c]01,15" } { set out "[c]01,00" } }
    default { set out "[c][basecolor]" }
  }
  if $undr { set out [u]$out }
  if $revr { set out [r]$out }
  return $out
}
proc cd {} { return }
rename echo xircecho
proc d2b {text} {
  set text [replace $text "[b]" ""]
  set text [replace $text "[o]" "[o][b]"]
  if ![bgType "Default"] {
    set text [replace $text "[c]15" "[c]00"]
    set text [replace $text "[c]14" "[c]15"]
    set text [replace $text "[c]02" "[c]12"]
    set text [replace $text "[c]03" "[c]09"]
    set text [replace $text "[c]05" "[c]04"]
    set text [replace $text "[c]06" "[c]13"]
    set text [replace $text "[c]07" "[c]08"]
    set text [replace $text "[c]10" "[c]11"]
    set text [replace $text "[c]01" "[c]14"]
  } {
    set text [replace $text "[c]14" "[c]01"]
    set text [replace $text "[c]15" "[c]14"]
    set text [replace $text "[c]00" "[c]15"]
    set text [replace $text "[c]12" "[c]02"]
    set text [replace $text "[c]09" "[c]03"]
    set text [replace $text "[c]
  }
  set text "[b]$text[b]"
  return $text
}
proc echo {text {loc1 ""} {loc2 ""}} {
  global BASECOLOR sin_zero
  if ![info exists sin_zero(show_output)] { set sin_zero(show_output) 1 }
  if !$sin_zero(show_output) { return "" }
  if ![strcmpi [get_tog "Unhide_Text"] "on"] {
    if ![strcmpi [lindex [getXircColors "Default"] 1] "000000"] { regsub -all "[c]01" $text "[c]00" text }
    if ![strcmpi [lindex [getXircColors "Default"] 1] "FFFFFF"] { regsub -all "[c]00" $text "[c]01" text  }
  }
  if ![strcmpi [get_tog "EasyRead"] "on"] { set text [d2b $text] }
  if ![string compare [stl [get_tog "Show_Links"]] "off"] { regsub -all "www." $text "www\001." text; regsub -all "ftp." $text "ftp\001." text; regsub -all "://" $text ":\001//" text }
  set text [replace $text [o] "[o][c][basecolor]"]
  set txt ""
  set code ""
  set brk 1; set just_brk 0; set brk_pending 0; for {set x 0} {$x < [string length $text]} {incr x} { set y [string index $text $x]; if {!$brk && [ischar $y]} { set just_brk 1; if ![string compare [stl $y] "m"] { set brk_pending 1 } { set brk 1 } }; if $brk { if {$y == ","} { set pos 0; if {[string index $text [expr $x-2]] == [c]} { set pos [expr $x-2] }; if {[string index $text [expr $x-3]] == [c]} { set pos [expr $x-3] }; if $pos { set z [string range $text [expr $pos+1] [expr $x-1]]; if {[isint $z] && ![isint [string index $text [expr $x+1]]]} { set y ",," } } }; if {$y == [c] && ![isint [string index $text [expr $x+1]]]} { set y $y[basecolor] }; if ![string compare $y "\x1B"] { set brk 0; set code "" } }; if $brk { if {$just_brk && [string length $code]} { if {[stl [string index $code [expr [string length $code]-1]]] != "m"} { set code ${code}m }; set code [asc2ans $code]; set txt ${txt}${code}${y}; set just_brk 0; set code "" } { set txt ${txt}${y} } } { set code $code$y }; if $brk_pending { set brk 1; set brk_pending 0; set just_brk 0; if [string length $code] { set code [asc2ans $code]; set txt ${txt}$code; set code "" } } }; set text $txt; xircecho $text $loc1 $loc2
}
proc help_parse {win1 win2 {match "*"}} {
  global HELP_INFO
  set help_out ""
  set cnt 0
  set total 0
  set a ""
  set arg1 ""
  set arg2 ""
  set arg3 ""
  set arg4 ""
  echo [helplistheadEcho] $win1 $win2
  foreach a [lsort -ascii [array names HELP_INFO]] {
    if [string match $match $a] {
      incr cnt
      incr total
      lappend help_out $a
    }
    if {$cnt >= 4} {
      set arg1 [lindex $help_out 0]
      set arg2 [lindex $help_out 1]
      set arg3 [lindex $help_out 2]
      set arg4 [lindex $help_out 3]
      echo [helplistitemEcho $arg1 $arg2 $arg3 $arg4] $win1 $win2 
      set help_out ""
      set cnt 0
      FALC_yield
    }
  }
  if {$help_out != ""} {
    set arg1 [lindex $help_out 0]
    set arg2 [lindex $help_out 1]
    set arg3 [lindex $help_out 2]
    set arg4 [lindex $help_out 3]
    echo [helplistitemEcho $arg1 $arg2 $arg3 $arg4] $win1 $win2
    unset arg1 arg2 arg3 arg4
  }
  if {$total == 0 && $match != ""} {
    echo [helpnoneonEcho $match] $win1 $win2
  }
  echo [helplistendEcho $total] $win1 $win2
  unset help_out cnt a total
}
proc reverse {string} {
  if {[string length $string] <= 1} { return $string }
  set y ""
  for {set x 0} {$x < [string length $string]} {incr x} {
    set z [string index $string $x]
    set y ${z}${y}
  }
  return $y
}
proc i2h {int} {
  if ![isint $int] { return "invalid integer value" }
  if {$int > 15} { return "integer too large" }
  if {$int < 10} { return $int }
  if {$int < 16} { return [chr [expr $int+55]] }
}
proc h2i {hex} {
  if ![string length $hex] { return "invalid hex value" }
  if {![isint $hex] && ([string length [stl $hex]] > 1 || [string length [string trim [stl $hex] "abcdef"]])} { return "invalid hex value" }
  if [isint $hex] {
    if {$hex > 9} { return "hex value too large" } { return $hex }
  } {
    return [expr [asc [stu $hex]]-55]
  }
}
proc int2hex {num} {
  if ![isint $num] { return "00" }
  return [format "%0.2X" $num]
}
proc hex2int {hex} {
  if ![string length $hex] { return "invalid hex value" }
  set fin 0
  set hex [reverse $hex]
  for {set x 0} {$x < [string length $hex]} {incr x} {
    set y [string index $hex $x]
    set z [h2i $y]
    if ![isint $z] { set fin "invalid hex value"; break } { set fin [format %0.0f [expr $fin+($z*pow(16,$x))]] }
  }
  return $fin
}
proc getXircColors {{type "default"}} {
  switch -- [stl $type] {
    "action" { set type "Action" }
    "alert" { set type "Alert" }
    "change" { set type "Change" }
    "channel" { set type "Channel" }
    "command" { set type "Command" }
    "ctcp" { set type "CTCP" }
    "default" { set type "Default" }
    "error" { set type "Error" }
    "highlight" { set type "Highlight" }
    "join" { set type "Join" }
    "mode" { set type "Mode" }
    "nick" { set type "Nick" }
    "notice" { set type "Notice" }
    "part" { set type "Part" }
    "pause" { set type "Pause" }
    "private" { set type "Private" }
    "public" { set type "Public" }
    "quit" { set type "Quit" }
    "url" { set type "URL" }
    "users" { set type "Users" }
    default { set type "Default" }
  }
  set colval [FALC_config "Preferences\\Colors" $type]
  set hcode [int2hex $colval]
  set bg [string index $hcode 0]
  set fg [string index $hcode 1]
  set fg [expr [hex2int $fg]+1]
  set bg [expr [hex2int $bg]+1]
  set bgk [leadzero $bg 3]
  set fgk [leadzero $fg 3]
  set bgcode [FALC_config "Preferences\\Colors\\Table" $bgk]
  set fgcode [FALC_config "Preferences\\Colors\\Table" $fgk]
  set bgh [leadzero [int2hex $bgcode] 6]
  set fgh [leadzero [int2hex $fgcode] 6]
  set out ""
  lappend out $fgh $bgh
  return $out
}
proc bgType {{type "default"}} {
  set l [getXircColors $type]
  set bg [lindex $l 1]
  set c1 [hex2int [string range $bg 0 1]]
  set c2 [hex2int [string range $bg 2 3]]
  set c3 [hex2int [string range $bg 4 5]]
  if {$c1 > 127 || $c2 > 127 || $c3 > 127} { return 1 } { return 0 }
}
proc adate {{trimzero 0} {divider "/"}} {
  set mm [clock format [clock seconds] -format %m]
  set dd [clock format [clock seconds] -format %d]
  set yy [clock format [clock seconds] -format %y]
  if {$trimzero != 0} {
    set mm [string trimleft $mm 0]
    set dd [string trimleft $dd 0]
  }
  return "$mm$divider$dd$divider$yy"
}
proc tsearchEcho {channel string} {
  if [string length [get_env "TsearchText"]] {
    return [eval return [get_env "TsearchText"]]
  }
  return "[c]14([shade $channel 00 15 14][c]14) $string"
}
proc tsearchHead {channel text} {
  if [string length [get_env "TsearchHead"]] {
    return [eval return [get_env "TsearchHead"]]
  }
  return "[c]14Searching [c]00$channel[c]14 for [c]00\"[c]14$text[c]00\""
}
proc tsearchEnd {channel text matches} {
  if [string length [get_env "TsearchEnd"]] {
    return [eval return [get_env "TsearchEnd"]]
  }
  return "[c]14Search Completed[c]00:[c]14 found $matches match[c]00([c]14es[c]00)"
}

proc rdispEcho {string} {
  if [string length [get_env "RdispText"]] {
    return [eval return [get_env "RdispText"]]
  }
  return "[c]14 $string"
}
proc rdispHead {channel lines} {
  if [string length [get_env "RdispHead"]] {
    return [eval return [get_env "RdispHead"]]
  }
  return "[c]14[c]15[c]00[c]04\[[c]00Rdisp($channel)[c]04\][c]00[c]15[c]14"
}
proc rdispEnd {channel lines} {
  if [string length [get_env "RdispEnd"]] {
    return [eval return [get_env "RdispEnd"]]
  }
  return "[c]14[c]15[c]00[c]04\[[c]00$lines lines displayed[c]04\][c]00[c]15[c]14"
}
proc awayinfoEcho {awaymsg backmsg awayfor msgs} {
  if {[get_env AwayInfo] != ""} {
    return [eval return [get_env AwayInfo]]
  } {
    return "[c]13 [c]06You Recieved [b]([b][c]13$msgs[c]06[b])[b] messages while you were away."
  }
}
proc awaylogStyle {type msgnum dest nick user host text} {
  switch -- [stu $type] {
    "AWAY" {
      return "<Set away at [atime "am" "pm"] on [adate]: $text>"
    }
    "BACK" {
      return "<Set back at [atime "am" "pm"] on [adate]: $text \[total msgs($msgnum)\]>"
    }
    "PRIVMSG" {
      return "($msgnum): \[[atime " am" " pm" 1]\] ($nick ($user@$host)): $text"
    }
    "NOTICE" {
      return "($msgnum): \[[atime " am" " pm" 1]\] -$nick\[$user@$host\]- $text"
    }
    "ACTION" {
      return "($msgnum): \[[atime " am" " pm" 1]\] * $nick ($user@$host) $text"
    }
    default {
      if {[get_env AwayLog(default)] != ""} {
        return [eval return [get_env AwayLog(default)]]
      } {
        return "($msgnum): \[[atime " am" " pm" 1]\] :::${nick}($user@$host)::: $text"
      }
    }
  }
}
proc colr {type} {
  set val [get_env Color$type]
  if [string length $val] { return $val }
  switch -- [stl $type] {
    "selfmsg" { return "15,01" }
    "selfnotice" { return "15,01" }
    "selftext" { return "15,01" }
    "selfaction" { return "10,01" }
    "text" { return "14,01" }
    "action" { return "10,01" }
    "notice" { return "15,01" }
    "quit" { return "11,01" }
    "kick" { return "10,01" }
    "highlight" { return "11,01" }
    default { return "15,01" }
  }
}
proc basecolor {} {
  global BASECOLOR
  if ![info exists BASECOLOR] { return "[c][colr default]" }
  return $BASECOLOR
}
proc tog_on {togname} {
  set togval [stl [get_tog $togname]]
  if {$togval == "" || $togval == "off" || $togval == "\001none\001"} {
    return 0
  } {
    return 1
  }
}
proc even {numb {div 2}} {
  if ![isint $numb] {
    return ""
  }
  set sp [split [expr $numb/$div.0] "."]
  set tst [lindex $sp 1]
  if {$tst == 0} {
    unset tst sp
    return 1
  } {
    unset tst sp
    return 0
  }
}
proc awaynoticestyle {idx dest nick user host text} {
  if {[get_env AwayNotice] != ""} {
    return [eval return [get_env AwayNotice]]
  } {
    return "Your message has been logged [u]\[[u]([b]s[b]in[u]Log[u])[u]\][u]"
  }
}
proc ascreplace {string start stop {char ""}} {
  if {[isint $start] && [isint $stop]} {
    if {$start > $stop} {
      set s $stop
      set stop $start
      set start $s
      unset s
    }
    if {$start != $stop} {
      for {} {$start <= $stop} {incr start} {
        set string [replace $string [chr $start] $char]
      }
    } {
      set string [replace $string [chr $start] $char]
    }
    unset start stop
    return $string
  }
  return $string
}
proc hand_log {type idx dest nick user host text} {
  set f "[pwd]/logs/awaymsgs.log"
  if {$f != ""} {
    set path [dirname [replace $f "\\" "/"]]
    set path "$path/"
    if ![file exists $path] { file mkdir $path }
    set file [file tail $f]
    set file [filefix $file]
    set f $path$file
    if ![file exists $f] { filebuild $f }
    set x [open $f a+]
    set out [awaylogStyle $type $idx $dest $nick $user $host $text]
    puts $x $out
    catch {flush $x}
    catch {close $x}
    unset x f
  }
}
proc wallchopsText {dest nick user host text} {
  if {[get_cookie ENV(WallChops) ""] != ""} {
    return [eval return [get_cookie ENV(WallChops) ""]]
  } {
    return "[c]14![shade $nick 00 15 14][c]14![c]00[b]([b][c]15[u]ops[u][c]00/[shade $dest 14 15 00][c]15[c]00[b])[b][c]14:[c]15 $text"
  }
}
proc ignorelistEcho {mask types} {
  if {[get_cookie ENV(IgnoreList)] != ""} {
    return [eval return [get_cookie ENV(IgnoreList) ""]]
  } {
    return "[c]09 [shade $mask 00 15 14][c]14:[c]03 $types"
  }
}
proc helplistheadEcho {} {
  if {[get_cookie ENV(HelpListHead) ""] != ""} {
    return [eval return [get_cookie ENV(HelpListHead) ""]]
  } {
    return "[c]00[c]15[c]14[c]00[c]15[c]14[c]15[c]00[c]14[c]15[c]00"
  }
}
proc helplistendEcho {topics} {
  if {[get_cookie ENV(HelpListEnd) ""] != ""} {
    return [eval return [get_cookie ENV(HelpListEnd) ""]]
  } {
    return "[c]00[c]15[c]14[b][c]15\[[b][c]10Help [c]14([c]11$topics [c]15topics[c]14)[c]15[b]\][b][c]14[c]15[c]00"
  }
}
proc helpnoneonEcho {topic} {
  if {[get_cookie ENV(HelpNoneOn) ""] != ""} {
    return [eval return [get_cookie ENV(HelpNoneOn) ""]]
  } {
    return "[c]00 [c]14No Help for ([c]15([c]00([shade $topic 14 15 00][c]00)[c]15)[c]14)"
  }
}
proc helplistitemEcho {topic1 {topic2 ""} {topic3 ""} {topic4 ""}} {
  if {[join "$topic2 $topic3 $topic4"] == ""} {
    set ret "HelpList1Item"
    set out "[c]00 [shade $topic1 14 15 00]"
  } elseif {[join "$topic3 $topic4"] == ""} {
    set ret "HelpList2Items"
    set out "[c]00 [left [shade $topic1 14 15 00] 15] [left [shade $topic2 14 15 00] 15]"
  } elseif {$topic4 == ""} {
    set ret "HelpList3Items"
    set out "[c]00 [left [shade $topic1 14 15 00] 15] [left [shade $topic2 14 15 00] 15] [left [shade $topic3 14 15 00] 15]"
  } {
    set ret "HelpList4Items"
    set out "[c]00 [left [shade $topic1 14 15 00] 15] [left [shade $topic2 14 15 00] 15] [left [shade $topic3 14 15 00] 15] [left [shade $topic4 14 15 00] 15]"
  }
  if {[get_cookie ENV($ret) ""] != ""} {
    unset out
    return [eval return [get_cookie ENV($ret) ""]]
  } {
    unset ret
    return $out
  }
}
proc helpheadEcho {command} {
  if {[get_cookie ENV(HelpHead) ""] != ""} {
    return [eval return [get_cookie ENV(HelpHead) ""]]
  } {
    return "[c]00[c]15[c]14[c]00[b]\[[b]\[[c]15\[[c]14Help[c]00([shade $command 14 15 00][c]00)[c]15][c]00][b]][b][c]14[c]15[c]00"
  }
}
proc helpusageEcho {command usage} {
  if {[get_cookie ENV(HelpUsage) ""] != ""} {
    return [eval return [get_cookie ENV(HelpUsage) ""]]
  } {
    return "[c]00 [c]14usage      [c]00:[c]14 $usage"
  }
}
proc helpdescriptionEcho {command description} {
  if {[get_cookie ENV(HelpDescription) ""] != ""} {
    return [eval return [get_cookie ENV(HelpDescription) ""]]
  } {
    return "[c]00 [c]14description[c]00:[c]14 $description"
  }
}
proc helpalternatesEcho {command alternates} {
  if {[get_cookie ENV(HelpAlternates) ""] != ""} {
    return [eval return [get_cookie ENV(HelpAlternates) ""]]
  } {
    return "[c]00 [c]14alternates [c]00:[c]14 $alternates"
  }
}
proc helpseealsoEcho {command see_also} {
  if {[get_cookie ENV(HelpSeeAlso) ""] != ""} {
    return [eval return [get_cookie ENV(HelpSeeAlso) ""]]
  } {
    return "[c]00 [c]14see also  [c]00:[c]14 $see_also"
  }
}
proc helpendEcho {command} {
  if {[get_cookie ENV(HelpEnd) ""] != ""} {
    return [eval return [get_cookie ENV(HelpEnd) ""]]
  } {
    return "[c]00[c]15[c]14[c]00[c]15[c]14[c]15[c]00[c]14[c]15[c]00"
  }
}
proc olistHead {} {
  if [string length [get_env "OListHead"]] {
    return [eval return [get_env "OListHead"]]
  }
  return "[c]14[c]00-[c]14[c]15[c]00[c]14-[c]00[c]10\[[c]11\[[b]\[[b][c]00[u]stats o[u][c]11[b]\][b]\][c]10\][c]00[c]14-[c]00[c]15[c]14[c]00-[c]14"
}
proc olistUser {user host oline} {
  if [string length [get_env "OListUser"]] {
    return [eval return [get_env "OListUser"]]
  }
  return "[c]14 [shade $user 15 00 15] [c]00- [c]15$host [c]04([c]15$oline[c]04)"
}
proc olistUserx {user host oline} {
  if [string length [get_env "OListUserX"]] {
    return [eval return [get_env "OListUserX"]]
  }
  return "  [c]14 [c]15$host [c]04([c]15$oline[c]04)"
}
proc olistEnd {users total} {
  if [string length [get_env "OListEnd"]] {
    return [eval return [get_env "OListEnd"]]
  }
  return "[c]14[c]00-[c]14[c]15[c]00[c]14-[c]00[c]10\[[c]11\[[b]\[[b][c]14([c]00$users[c]14)[c]15 users [c]00/ [c]14([c]00$total[c]14)[c]15 olines[c]11[b]\][b]\][c]10\][c]00[c]14-[c]00[c]15[c]14[c]00-[c]14"
}
proc erroneusnickEcho {nick} {
  if [string length [get_env "ErroneusNick"]] {
    return [eval return [get_env "ErroneusNick"]]
  }
  return "[c]14* [shade $nick 00 14 15][c]15 is erroneus"
}
proc nickinuseEcho {nick} {
  if [string length [get_env "NickInUse"]] {
    return [eval return [get_env "NickInUse"]]
  }
  return "[c]14* [shade $nick 00 14 15][c]15 is in use"
}
proc nickownedbyEcho {nick user host} {
  if [string length [get_env "NickOwnedBy"]] {
    return [eval return [get_env "NickOwnedBy"]]
  }
  return "[c]14*[c]15 Nick taken by: [shade $nick 00 14 15] [c]14\[[c]15$user[c]14@[c]15$host[c]14\]"
}
proc regainnickEcho {nick} {
  if [string length [get_env "RegainNick"]] {
    return [eval return [get_env "RegainNick"]]
  }
  return "[c]14* [c]15regaining [shade $nick 14 00 15][c]15..."
}
proc regainnickfinEcho {nick reason} {
  if [string length [get_env "RegainNickFin"]] {
    return [eval return [get_env "RegainNickFin"]]
  }
  return "[c]14*[c]15 nick regain for [shade $nick 14 00 15][c]15 complete [c]00\[[c]14$reason[c]00\]"
}
proc add_block {mask} {
  set b_list [get_cookie BLOCKS]
  set a 1
  foreach b $b_list {
    if ![strcmpi $mask $b] { set a 0; break }
  }
  if $a { set_cookie BLOCKS "$b_list $mask"; echo [addblockEcho $mask] }
}
proc rem_block {mask} {
  set b_list [get_cookie BLOCKS]
  set r 0
  set out ""
  foreach b $b_list {
    if ![strcmpi $b $mask] { set r 1 } { append out $b }
  }
  if $r { echo [remblockEcho $mask] }
  set_cookie BLOCKS $out
}
proc isblocked {nick user host} {
  set b_list [get_cookie BLOCKS]
  set bd 0
  foreach b $b_list {
    if [string match $b "[nick]![user]@[host]"] { set bd 1; break }
  }
  if $bd { return 1 } { return 0 }
}
proc addblockEcho {mask} {
  if [string length [get_env "BlockAdded"]] {
    return [eval return [get_env "BlockAdded"]]
  }
  return "[c]04[c]15 Block added for [c]00$mask [c]04"
}
proc remblockEcho {mask} {
  if [string length [get_env "BlockRemoved"]] {
    return [eval return [get_env "BlockRemoved"]]
  }
  return "[c]09[c]15 Block on [c]00$mask[c]15 has been lifted [c]09"
}
proc listblockEcho {mask} {
  if [string length [get_env "BlockList"]] {
    return [eval return [get_env "BlockList"]]
  }
  return "[c]04 [c]00$mask [c]04"
}
proc starttimerEcho {idx reps delay command} {
  if {[get_cookie ENV(StartTimer) ""] != ""} {
    return [eval return [get_cookie ENV(StartTimer) ""]]
  } {
    return "[c]00[c]15 Timer[c]14([c]00$idx[c]14) [c]15started[c]14:[c]15 command[c]14([c]00$command[c]14)[c]15 repeat[c]14([c]00$reps[c]15 time[c]00\[[c]15s[c]00\][c]14)[c]15 delay[c]14([c]00$delay[c]15 sec[c]00\[[c]15s[c]00\][c]14)"
  }
}
proc startinfitimerEcho {idx reps delay command} {
  if {[get_cookie ENV(StartInfiTimer) ""] != ""} {
    return [eval return [get_cookie ENV(StartInfiTimer) ""]]
  } {
    return "[c]00[c]15 Timer[c]14([c]00$idx[c]14) [c]15started[c]14:[c]15 command[c]14([c]00$command[c]14)[c]15 delay[c]14([c]00$delay[c]15 sec[c]00\[[c]15s[c]00\][c]14)"
  }
}
proc timerstatusEcho {idx reps delay command} {
  if {[get_cookie ENV(TimerStatus) ""] != ""} {
    return [eval return [get_cookie ENV(TimerStatus) ""]]
  } {
    return "[c]00[c]15 Timer[c]14([c]00$idx[c]14) [c]15status[c]14:[c]15 command[c]14([c]00$command[c]14)[c]15 repeat[c]14([c]00$reps[c]14)[c]15 delay[c]14([c]00$delay[c]14)"
  }
}
proc timerinfistatusEcho {idx reps delay command} {
  if {[get_cookie ENV(TimerInfiStatus) ""] != ""} {
    return [eval return [get_cookie ENV(TimerInfiStatus) ""]]
  } {
    return "[c]00[c]15 Timer[c]14([c]00$idx[c]14) [c]15status[c]14:[c]15 command[c]14([c]00$command[c]14)[c]15 delay[c]14([c]00$delay[c]14)"
  }
}
proc timersilentstatusEcho {idx reps delay command} {
  if {[get_cookie ENV(TimerSilentStatus) ""] != ""} {
    return [eval return [get_cookie ENV(TimerSilentStatus) ""]]
  } {
    return "[c]00[c]15 Timer[c]14([c]00$idx[c]14) [c]15status[c]14:[c]15 command[c]14([c]00$command[c]14)[c]15 repeat[c]14([c]00$reps[c]14)[c]15 delay[c]14([c]00$delay[c]14) [c]00\[[c]14silent[c]00\]"
  }
}
proc timerinfisilentstatusEcho {idx reps delay command} {
  if {[get_cookie ENV(TimerInfiSilentStatus) ""] != ""} {
    return [eval return [get_cookie ENV(TimerInfiSilentStatus) ""]]
  } {
    return "[c]00[c]15 Timer[c]14([c]00$idx[c]14) [c]15status[c]14:[c]15 command[c]14([c]00$command[c]14)[c]15 delay[c]14([c]00$delay[c]14) [c]00\[[c]14silent[c]00\]"
  }
}
proc killtimerEcho {idx} {
  if {[get_cookie ENV(KillTimer) ""] != ""} {
    return [eval return [get_cookie ENV(KillTimer) ""]]
  } {
    return "[c]14[c]15 Timer[c]00([c]14$idx[c]00)[c]15 halted"
  }
}
proc killalltimersEcho {} {
  if {[get_cookie ENV(KillAllTimers) ""] != ""} {
    return [eval return [get_cookie ENV(KillAllTimers) ""]]
  } {
    return "[c]14[c]15 All timers halted"
  }
}
proc avail_timer {{var "TIMERS"}} {
  global $var
  set tchk 1
  while {[info exists ${var}($tchk)]} {
    incr tchk
  }
  return $tchk
}
proc start_timer {idx reps delay cmd silent} {
  global TIMERS TIMER_INF
  set TIMER_INF($idx) $reps,$delay,0,0
  set TIMERS($idx) $silent,$cmd
  return 1
}
proc sStartTimer {reps delay cmd} {
  global SCRIPT_TIMERS SCRIPT_TIMER_INFO
  set id [avail_timer "SCRIPT_TIMERS"]
  set SCRIPT_TIMER_INFO($id) "${reps},${delay},0,0"
  set SCRIPT_TIMERS($id) $cmd
  return ""
}
proc sTimerExists {idx} {
  global SCRIPT_TIMERS
  return [info exists SCRIPT_TIMERS($idx)]
}
proc sKillTimer {idx} {
  global SCRIPT_TIMERS SCRIPT_TIMER_INFO
  if [info exists SCRIPT_TIMERS($idx)] {
    unset SCRIPT_TIMERS($idx)
    unset SCRIPT_TIMER_INFO($idx)
  }
}
proc sKillAllTimers {} {
  global SCRIPT_TIMERS SCRIPT_TIMER_INFO
  if [info exists SCRIPT_TIMERS] { unset SCRIPT_TIMERS }
  if [info exists SCRIPT_TIMER_INFO] { unset SCRIPT_TIMER_INFO }
}
proc timer_status {idx} {
  global TIMERS TIMER_INF
  if [timer_exist $idx] {
    set reps [lindex [split $TIMER_INF($idx) ","] 0]
    set delay [lindex [split $TIMER_INF($idx) ","] 1]
    set s $TIMERS($idx)
    set pos [pos $s ","]
    if {$pos != -1} {
      set silent [string range $s 0 [expr $pos-1]]
      set cmd [string range $s [expr $pos+1] end]
      if ![isint $silent] {
        set silent 0
      }
    } {
      set silent 0
      set cmd $s
    }
    return "$reps $delay $silent [list $cmd]"
  } {
    return 0
  }
}
proc timer_exist {idx} {
  global TIMERS
  return [info exists TIMERS($idx)]
}
proc kill_timer {idx} {
  global TIMERS TIMER_INF
  if [timer_exist $idx] {
    set sil [string range $TIMERS($idx) 0 [expr [pos $TIMERS($idx) ","]-1]]
    unset TIMERS($idx)
    unset TIMER_INF($idx)
    if {$sil == 1} {
      return 2
    } {
      return 1
    }
  } {
    return 0
  }
}
proc div {number divisor} {
  if {![isint $number] || ![isint $divisor]} { return 0 }
  if {$divisor == 0} {
    return 0
  } {
    return [expr $number/$divisor]
  }
}
proc serv {} {
  global USER_INFO
  if [connected] {
    if ![info exists USER_INFO(server)] {
      return [lindex [server] 0]
    } {
      return $USER_INFO(server)
    }
  } {
    return ""
  }
}
proc port {} {
  if [connected] {
    return [lindex [server] 1]
  } {
    return ""
  }
}
proc fix4match {string} {
  regsub -all {\|} $string \\\| string
  regsub -all {\{} $string \\\{ string
  regsub -all {\}} $string \\\} string
  regsub -all {\[} $string \\\[ string
  regsub -all {\]} $string \\\] string
  regsub -all {\*} $string \\\* string
  regsub -all {\?} $string \\\? string
  regsub -all {\^} $string \\\^ string
  return $string
}
proc ascii_logo {wtype wname} {
  echo " \n \n " $wtype $wname
  echo "[c]14    _/_/_/_/                    _/          _/" $wtype $wname
  echo "[c]14   _/                          _/  [c]06_/_/_/_/[c]14  _/" $wtype $wname
  echo "[c]14  _/          [c]06_/[c]14             _/  [c]06_/      _/[c]14  _/" $wtype $wname
  echo "[c]14 _/_/_/_/_/      _/_/   _/  _/  [c]06_/      _/[c]14  _/" $wtype $wname
  echo "[c]14        _/  _/  _/ _/  _/  _/  [c]06_/      _/[c]14  _/" $wtype $wname
  echo "[c]14       _/  _/  _/  _/ _/  _/  [c]06_/      _/[c]14  _/" $wtype $wname
  echo "[c]14_/_/_/_/  _/  _/   _/_/   _/   [c]06_/_/_/[c]14   _/[c]06([c]14a [c]00C[c]15h[c]14aotic Realms Developme[c]15n[c]00t[c]06)" $wtype $wname
  echo "                       [c]14http[c]06://[c]14www.chaoticlrealms.com" $wtype $wname
  echo " \n \n " $wtype $wname
}
proc szaddhelp {command usage description alternates see_also} {
  global HELP_INFO
  if ![info exists HELP_INFO([stu $command])] {
    set HELP_INFO([stu $command]) "\{$command\} \{$usage\} \{$description\} \{$alternates\} \{$see_also\}"
  } {
    set com_list $HELP_INFO([stu $command])
    set usageb [lindex $com_list 1]
    set descriptionb [lindex $com_list 2]
    set alternatesb [lindex $com_list 3]
    set see_alsob [lindex $com_list 4]
    set usageb [join "$usageb $usage"]
    set descriptionb [join "$descriptionb $description"]
    set alternatesb [join "$alternatesb $alternates"]
    set see_alsob [join "$see_alsob $see_also" ","]
    set HELP_INFO([stu $command]) "\{$command\} \{$usageb\} \{$descriptionb\} \{$alternatesb\} \{$see_alsob\}"
    catch {unset usageb descriptionb alternatesb see_alsob}
  }
  return 1
}
proc filefix {filename} {
  set filename [replace $filename "*" "_"]
  set filename [replace $filename ":" "_"]
  set filename [replace $filename "?" "_"]
  set filename [replace $filename "<" "_"]
  set filename [replace $filename ">" "_"]
  set filename [replace $filename "\"" "_"]
  set filename [replace $filename "\|" "_"]
  set filename [ascreplace $filename 1 31 "_"]
  return $filename
}
proc filebuild {filename} {
  catch {open $filename w} x
  if ![catch {close $x}] {
    return 1
  } {
    return 0
  }
}
proc recurlist {dir {recurred ""}} {
  set recur_list ""
  if [string length $recurred] { set recur_list $recurred }
  set dir [replace $dir "\\" "/"]
  if {[string index $dir [expr [string length $dir]-1]] != "/"} { set dir ${dir}/ }
  set subs [glob -nocomplain ${dir}*/]
  foreach s $subs {
    lappend recur_list $s
    set recur_list [recurlist $s $recur_list]
  }
  return $recur_list
}
proc recurfile {dir index filespec} {
  set dspec [recurlist $dir]
  lappend dspec $dir
  set f_list ""
  set tidx 0
  foreach a $dspec {
    set glob [glob -nocomplain ${a}${filespec}]
    foreach g $glob {
      if {$index > 0} {
        incr tidx
        if {$tidx == $index} { return $g }
      } {
        incr tidx
      }
    }
  }
  if {$index == 0} { return $tidx } { return "" }
}
proc filefind {filespec index startpath} {
  if ![isint $index] { set index 0 }
  if {$index < 0} { set index 0 }
  return [recurfile $startpath $index $filespec]
}
proc addignore {mask types {timed 0} {secs 0}} {
  if ![isint $timed] { set timed 0 }
  set_cookie IGNORE($mask) $types
  set list [get_cookie IGNORES]
  if ![lfind $list $mask] {
    lappend list $mask
  }
  set list [lsort -ascii $list]
  set_cookie IGNORES $list
  if $timed {
    echo "[ignoreaddedText $mask $types][ignoretimeAppend $secs]"
  } {
    echo [ignoreaddedText $mask $types]
  }
  return 1
}
proc updignore {mask exists types {timed 0} {secs 0}} {
  if ![isint $timed] { set timed 0 }
  foreach f $types {
    if ![lfind $exists $f] {
      lappend exists $f
    }
  }
  set_cookie IGNORE($mask) $exists
  set list [get_cookie IGNORES]
  if ![lfind $list $mask] {
    lappend list $mask
  }
  set list [lsort -ascii $list]
  set_cookie IGNORES $list
  if $timed {
    echo "[ignoreupdatedText $mask $exists][ignoretimeAppend $secs]"
  } {
    echo [ignoreupdatedText $mask $exists]
  }
  return 1
}
proc remignore {mask} {
  set list [get_cookie IGNORES]
  if [isint $mask] {
    set pos [expr $mask-1]
    if {$pos < 0} {
      echo [errEcho "Ignore" "unable to remove ignore: invalid index value ($mask)"]
      return 0
    }
    set rem_mask [lindex $list $pos]
    if {$rem_mask != ""} {
      set list [lreplace $list $pos $pos]
      set_cookie IGNORE($rem_mask) ""
      set_cookie IGNORES $list
      echo [ignoreremovedText $rem_mask]
    } {
      echo [errEcho "Ignore" "unable to remove ignore: invalid index value ($mask)"]
      return 0
    }
  } {
    if ![lfind $list $mask] {
      echo [errEcho Ignore "$mask is not Ignored"]
      return 0
    }
    set pos [lsearch -exact [stl $list] [stl $mask]]
    set list [lreplace $list $pos $pos]
    set_cookie IGNORE($mask) ""
    set_cookie IGNORES $list
    echo [ignoreremovedText $mask]
  }
  return 1
}
proc isignored {mask type} {
  foreach i [get_cookie IGNORES] {
    if [string match [stl $i] [stl $mask]] {
      set types [get_cookie IGNORE($i)]
      if [lfind $types $type] {
        return 1
      }
    }
  }
  return 0
}
proc series {list} {
  if {[llength $list] <= 1} {
    return $list
  }
  if {[llength $list] == 2} {
    return "[lindex $list 0] and [lindex $list 1]"
  }
  set out ""
  for {set x 0} {$x < [expr [llength $list]-1]} {incr x} {
    if {$out == ""} {
      set out [lindex $list $x]
    } {
      set out "$out, [lindex $list $x]"
    }
  }
  set out "$out, and [lindex $list end]"
  return $out
}
proc repeat {char num} {
  if ![isint $num] { return "invalid integer specified" }
  set out ""
  for {set x 1} {$x <= $num} {incr x} { set out $out$char }
  return $out
}
proc encrypt {string key} {
  set y 0
  set inc 1
  set out1 ""
  for {set x 0} {$x < [string length $string]} {incr x} {
    set id1 [string index $string $x]
    set id2 [string index $key $y]
    set ch1 [chr [expr ([asc $id1]+[asc $id2])%256]]
    set mod1 [expr [asc $id2]%4]
    set ch2 ""
    if {$mod1 > 0} { set ch2 [randascii $mod1] }
    set out1 "${out1}$ch1$ch2"
    if $inc { incr y } { incr y -1 }
    if {$y >= [string length $key]} { set y [expr [string length $key]-1]; set inc 0 }
    if {$y < 0} { set y 0; set inc 1 }
  }
  return $out1
}
proc decrypt {string key} {
  set inc 1
  set done 0; set out ""
  set x 0; set y 0
  while {!$done} {
    set id1 [string index $string $x]
    set id2 [string index $key $y]
    set int1 [expr ([asc $id1]-[asc $id2])]
    if {$int1 < 0} { set int1 [expr $int1+256] }
    set ch1 [chr $int1]
    set out "${out}${ch1}"
    set mod1 [expr [asc $id2]%4]
    incr x
    if {$mod1 > 0} { incr x $mod1 }
    if $inc { incr y } { incr y -1 }
    if {$y < 0} { set y 0; set inc 1 }
    if {$y >= [string length $key]} { set y [expr [string length $key]-1]; set inc 0 }
    if {$x >= [string length $string]} { set done 1 }
  }
  return $out
}
proc randascii {{len 1}} {
  if ![isint $len] { set len 1 }
  if {$len < 1} { return "" }
  set rand "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
  set out ""
  for {set x 0} {$x < $len} {incr x} { set out "$out[string index $rand [random 0 [expr [string length $rand]-1]]]" }
  return $out
}
proc randitem {list} {
  if {[llength $list] <= 1} { return $list }
  set idx [random 0 [expr [llength $list]-1]]
  return [lindex $list $idx]
}
proc add_ial {nick user host} { global IAL; set IAL([stl $nick]) $user@$host; return 1 }
proc rem_ial {nick} { global IAL; if [info exists IAL([stl $nick])] { unset IAL([stl $nick]); return 1 } { return 0 } }
proc get_ial {nick} { global IAL; if [info exists IAL([stl $nick])] { return $IAL([stl $nick]) } { return "" } }
proc chanWindow {channel mode key limit topic} {
  if {[get_env ChannelWindow ""] != ""} {
    return [eval return [get_env ChannelWindow]]
  } {
    return "\[$channel\] (+[join "$mode $limit $key"]): [code_strip $topic]"
  }
}
proc queryWindow {nick user host} {
  if {[get_cookie ENV(QueryWindow) ""] != ""} {
    return [eval return [get_cookie ENV(QueryWindow) ""]]
  } {
    return "$nick \[$user@$host\]"
  }
}
proc statusunconnectedWindow {} {
  if {[get_cookie ENV(StatusUnconnectedWindow) ""] != ""} {
    return [eval return [get_cookie ENV(StatusUnconnectedWindow) ""]]
  } {
    return "Sin(zero): not connected (00:00:00)"
  }
}
proc statusWindow {nick mode} {
  if {[get_cookie ENV(StatusWindow) ""] != ""} {
    return [eval return [get_cookie ENV(StatusWindow) ""]]
  } {
    return "Sin(zero): $nick\(+$mode\) on [serv]\[[port]\] ([join [dur [online]] ":"])"
  }
}
proc mainWindow {type} {
  switch -- $type {
    "connected" {
      if [string length [get_env MainConnectedWindow]] {
        return [eval return [get_env MainConnectedWindow]]
      } {
        return "Sin(zero): -[atime "am" "pm" 1]- (lag: [lag]) :\[XiRC\]"
      }
    }
    "unconnected" {
      if [string length [get_env MainUnconnectedWindow]] {
        return [eval return [get_env MainUnconnectedWindow]]
      } {
        return "Sin(zero): -[atime "am" "pm" 1]-  not connected :\[XiRC\]"
      }
    }
    default {
      if {[get_cookie ENV(MainDefaultWindow) ""] != ""} {
        return [eval return [get_cookie ENV(MainDefaultWindow) ""]]
      } {
        return "sZ\[XiRC\]: -[atime "am" "pm" 1]- lag([lag] secs)  [window_type]([window_name])"
      }
    }
  }
}
proc chanunconnectedWindow {channel} {
  if {[get_cookie ENV(ChannelUnconnectedWindow) ""] != ""} {
    return [eval return [get_cookie ENV(ChannelUnconnectedWindow) ""]]
  } {
    return "\[$channel\]"
  }
}
proc chatuserhostWindow {nick user host} {
  if {[get_cookie ENV(ChatUserHostWindow) ""] != ""} {
    return [eval return [get_cookie ENV(ChatUserHostWindow) ""]]
  } {
    return "$nick \[$user@$host\] (DCC Chat)"
  }
}
proc chatWindow {nick} {
  if {[get_cookie ENV(ChatWindow) ""] != ""} {
    return [eval return [get_cookie ENV(ChatWindow) ""]]
  } {
    return "$nick (DCC Chat)"
  }
}
proc chatunconnectedWindow {nick} {
  if {[get_cookie ENV(ChatUnconnectedWindow) ""] != ""} {
    return [eval return [get_cookie ENV(ChatUnconnectedWindow) ""]]
  } {
    return "$nick (Not Connected)"
  }
}
proc addonEcho {addon size} {
  if {[get_cookie ENV(AddonEcho) ""] != ""} {
    return [eval return [get_cookie ENV(AddonEcho) ""]]
  } {
    return "[c]14<[c]00\[[c]15Addon [c]14: [c]15[file tail $addon] [c]00[b]([b][c]15[byte_format $size][c]00[b])[b]\][c]14>"
  }
}
proc nowircopEcho {} {
  if {[get_cookie ENV(NowIRCop) ""] != ""} {
    return [eval return [get_cookie ENV(NowIRCop) ""]]
  } {
    return "[c]00 \[[c]14you are now an [c]00IRC[c]14op[c]00(+[c]14o[c]00)\]"
  }
}
proc pagerView {dest nick user host reason} {
  if {[get_cookie ENV(PagerView) ""] != ""} {
    return [eval return [get_cookie ENV(PagerView) ""]]
  } {
    return "[c]09 [c]03PAGE[c]09([c]14$dest[c]09)[c]04>[c]05> [c]03$nick [c]09([c]14$user[c]09@[c]14$host[c]09) [c]03\[[c]15$reason[o][c]03\]"
  }
}
proc defctcpText {dest nick user host type rest} {
  if {[get_cookie ENV(DefCtcp) ""] != ""} {
    return [eval return [get_cookie ENV(DefCtcp) ""]]
  } {
    return "[c]14\[[c]12ctcp[c]02[b]([b][shade $nick 14 15 14][c]02[b])[b][c]14\][c]15:[c]12 $type $rest"
  }
}
proc defctcpreplyText {dest nick user host type rest} {
  if {[get_cookie ENV(DefCtcpReply) ""] != ""} {
    return [eval return [get_cookie ENV(DefCtcpReply) ""]]
  } {
    return "[c]12\[[c]02[b]([b][shade $nick 15 00 15][c]02[b])[b] [c]14$type reply[c]12\][c]14:[c]15 $rest"
  }
}
proc deftopicText {chan nick user host topic} {
  if {[get_env DefTopic] != ""} {
    return [eval return [get_env DefTopic]]
  } {
    return "[c]13*[c]06*[c]14*[c]00 $nick [c]14sets topic [c]15\"[c]06$topic[o][c]15\"[c]14 in [shade $chan 14 15 00] [c]00:([c]14[atime am pm][c]00)"
  }
}
proc defmodeText {chan nick user host mode} {
  if {[get_cookie ENV(DefMode) ""] != ""} {
    return [eval return [get_cookie ENV(DefMode) ""]]
  } {
    return "[c]00*[c]15*[c]14* [c]00$nick [c]15sets mode [b]([b][c]14$mode[c]15[b])[b] in [c]00$chan"
  }
}
proc defautodecrypted {dest nick user host text} { if [string length [get_env DefAutoDecrypted]] { return [eval return [get_env DefAutoDecrypted]] } { return "[c]13<[c]06<[c]14<[c]15$nick[c]14>[c]06>[c]13>[c]15 $text" } }
proc defqueryautodecrypted {dest nick user host text} { if [string length [get_env DefQueryAutoDecrypted]] { return [eval return [get_env DefQueryAutoDecrypted]] } { return "[c]13<[c]06<[c]14<[c]15$nick[c]14>[c]06>[c]13>[c]15 $text" } }
proc defnoqueryautodecrypted {dest nick user host text} { if [string length [get_env DefNoQueryAutoDecrypted]] { return [eval return [get_env DefNoQueryAutoDecrypted]] } {  return "[c]13<[c]06<[c]14<[c]15$nick[c]06([c]14$user@$host[c]06)[c]14>[c]06>[c]13>[c]14 $text" } }
proc selfchanencrypted {dest text} { if [string length [get_env SelfChanEncrypted]] { return [eval return [get_env SelfChanEncrypted]] } { return "[c]14<[c]06<[c]13<[c]15[my_nick][c]13>[c]06>[c]14>[c]15 $text" } }
proc selfqueryencrypted {dest text} { if [string length [get_env SelfQueryEncrypted]] { return [eval return [get_env SelfQueryEncrypted]] } { return "[c]14<[c]06<[c]13<[c]15[my_nick][c]13>[c]06>[c]14>[c]15 $text" } }
proc selfmsgencrypted {dest text} { if [string length [get_env SelfMsgEncrypted]] { return [eval return [get_env SelfMsgEncrypted]] } { return "[c]14:[c]06:[c]13:[c]15$dest [c]13>[c]06>[c]14>[c]15 $text" } }
proc defchanText {chan nick user host text} {
  if {[get_cookie ENV(DefChanText) ""] != ""} {
    return [eval return [get_cookie ENV(DefChanText) ""]]
  } {
    return "[c]00([c]14:[c]15$nick[c]14:[c]00)[c][colr text] $text"
  }
}
proc defqueryText {dest nick user host text} {
  if {[get_cookie ENV(DefQueryText) ""] != ""} {
    return [eval return [get_cookie ENV(DefQueryText) ""]]
  } {
    return "[c]14([c]15$nick[c]14)[c]00:[c][colr querytext] $text"
  }
}
proc defnoqueryText {dest nick user host text} {
  if {[get_cookie ENV(DefNoQueryText) ""] != ""} {
    return [eval return [get_cookie ENV(DefNoQueryText) ""]]
  } {
    return "[c]14([c]15$nick [c]00([c]14$user[c]00@[c]14$host[c]00)[c]14)[c]00:[c][colr noquerytext] $text"
  }
}
proc chanfloodText {nick user host chan} {
  if [string length [get_env "PublicFlood"]] {
    return [eval return [get_env "PublicFlood"]]
  } {
    return "[c]15\[[c]00[b]x[b][c]15\][c]14:[c]15 Public Flood detected on [c]00$chan[c]15 from [c]00$nick [c]14([c]15$user@$host[c]14)"
  }
}
proc privfloodText {nick user host} {
  if [string length [get_env "PrivateFlood"]] {
    return [eval return [get_env "PrivateFlood"]]
  } {
    return "[c]15\[[c]00[b]x[b][c]15\][c]14:[c]15 Private Flood detected from [c]00$nick [c]14([c]15$user@$host[c]14)"
  }
}
proc ctcpfloodText {nick user host} {
  if [string length [get_env "CtcpFlood"]] {
    return [eval return [get_env "CtcpFlood"]]
  } {
    return "[c]15\[[c]00[b]x[b][c]15\][c]14:[c]15 Ctcp Flood detected on [c]00$chan[c]15 from [c]00$nick [c]14([c]15$user@$host[c]14)"
  }
}
proc highlightText {dest nick user host text} {
  if [string length [get_env "Highlight"]] {
    return [eval return [get_env "Highlight"]]
  } {
    return "[c]00[b]![b][c]14:[shade $nick 15 14 00][c]14:[c]00[b]![b][c]15 $text"
  }
}
proc highlightnoqueryText {dest nick user host text} {
  if [string length [get_env "HighlightNoQuery"]] {
    return [eval return [get_env "HighlightNoQuery"]]
  } {
    return "[c]00[b]![b][c]15$nick [c]00[b]([b][c]15$user[c]14@[c]15$host[c]00[b])![b]:[c]15 $text"
  }
}
proc defnoticeText {dest nick user host text} {
  if {[get_cookie ENV(DefNoticeText) ""] != ""} {
    return [eval return [get_cookie ENV(DefNoticeText) ""]]
  } {
    return "[c]00-[c]14([shade $nick 00 15 14][c]14)[c]00-[c][colr notice] $text"
  }
}
proc defchatText {nick text} {
  if {[get_cookie ENV(DefChatText) ""] != ""} {
    return [eval return [get_cookie ENV(DefChatText) ""]]
  } {
    return "[c]15[b]\[[b][center [shade $nick 00 15 14] 10][c]15[b]\][b][c]00:[c][colr text] $text"
  }
}
proc defchatAction {nick text} {
  if {[get_cookie ENV(DefChatAction) ""] != ""} {
    return [eval return [get_cookie ENV(DefChatAction) ""]]
  } {
    return "[c]10 [c]15$nick[c][colr action] $text"
  }
}
proc defquitMsg {} {
  if [string length [get_env QuitMsg]] {
    return [eval return [get_env QuitMsg]]
  } {
    return "[my_nick]: signing off -[b]s[b]\[[b]z[b]\]-"
  }
}
proc channoticeText {dest nick user host text} {
  if {[get_cookie ENV(ChanNoticeText) ""] != ""} {
    return [eval return [get_cookie ENV(ChanNoticeText) ""]]
  } {
    return "[c]00:[c]15:[c]14:[shade $dest 00 15 14][c]14:[c]15:[c]00: -[c]14([shade $nick 00 15 14][c]14)[c]00-[c][colr notice] $text"
  }
}
proc chanctcpText {dest nick user host type rest} {
  if {[get_cookie ENV(ChanCtcp) ""] != ""} {
    return [eval return [get_cookie ENV(ChanCtcp) ""]]
  } {
    return "[c]00\[[shade $dest 14 15 00][c]00\][c]14([c]12ctcp[c]02[b]([b][c]14$nick[c]02[b])[b][c]14)[c]15:[c]12 $type $rest"
  }
}
proc defjoinText {chan nick user host} {
  if {[get_cookie ENV(DefJoin) ""] != ""} {
    return [eval return [get_cookie ENV(DefJoin)]]
  } {
    return "[c]14* [c]00$nick [c]14([c]11$user[c]14@[c]11$host[c]14) [c]10has joined [c]00$chan [o]:([c]14[atime "am" "pm"][c]00)"
  }
}
proc invitingEcho {nick chan} {
  if {[get_env Inviting] != ""} {
    return [eval return [get_env Inviting]]
  } {
    return "[c]14:[c]15:[c]00: [c]00I[c]14nviting [shade $nick 00 14 15][c]14 to [c]15$chan"
  }
}
proc invitedEcho {nick chan} {
  if {[get_env Invited] != ""} {
    return [eval return [get_env Invited]]
  } {
    return "[c]14:[c]15:[c]00: [shade $nick 14 15 00][c]14 invites you to join [c]00$chan"
  }
}
proc defpartText {chan nick user host partmsg} {
  if {[get_cookie ENV(DefPart) ""] != ""} {
    return [eval return [get_cookie ENV(DefPart)]]
  } {
    return "[c]14* [c]00$nick [c]15([c]10$user[c]15@[c]10$host[c]15) [c]11has left [c]00$chan[o] [pad $partmsg "[c]14\[[c]15" "[o][c]14\]"] [o]:([c]14[atime "am" "pm"][c]00)"
  }
}
proc defkickText {chan nick user host knick reason} {
  if {[get_cookie ENV(DefKick) ""] != ""} {
    return [eval return [get_cookie ENV(DefKick) ""]]
  } {
    return "[c]14* [c]00$knick [c]10has been kicked from [shade $chan 14 15 00][o] [c]10by [c]11$nick [c]00[b]([b][c]10$reason[o][c]00[b])[b] :[c]00([c]14[atime "am" "pm"][c]00)"
  }
}
proc defnickText {nick user host newnick} {
  if {[get_cookie ENV(DefNick) ""] != ""} {
    return [eval return [get_cookie ENV(DefNick)]]
  } {
    return "[c]11* [c]10$nick [c]14changed nick[c]11:[c]11 $newnick [c]00:([c]14[atime "am" "pm"][c]00)"
  }
}
proc servlistTop {} {
  if {[get_env servlistTop] != ""} {
    return [eval return [get_env servlistTop]]
  }
  return "[c]00[c]14-[c]15[c]00[c]15[c]14[c]15[c]14-[c]15[c]00\[[c]15\[[c]14\[[c]15Server List[c]14\][c]15\][c]00\][c]15[c]14-[c]15[c]14[c]15[c]00[c]15[c]14-[c]00"
}
proc servlistItem {idx server port} {
  if {[get_env servlistItem] != ""} {
    return [eval return [get_env servlistItem]]
  }
  return "[c]00- [c]14([c]15$idx[c]14)[c]15 [highlight $server "." 14 15] [c]00\[[c]14$port[c]00\]"
}
proc servlistEnd {} {
  if {[get_env servlistEnd] != ""} {
    return [eval return [get_env servlistEnd]]
  }
  return " "
}
proc servlistAdd {idx server port} {
  if {[get_env servlistAdd] != ""} {
    return [eval return [get_env servlistAdd]]
  }
  return "[c]00- [c]15Added [highlight $server "." 14 15] [c]00\[[c]14$port[c]00\][c]15 to server list [c]14([c]15idx[c]14:[c]00 $idx[c]14)"
}
proc servlistRem {idx server port} {
  if {[get_env servlistRem] != ""} {
    return [eval return [get_env servlistRem]]
  }
  return "[c]00- [c]15Removed server[c]14([c]00$idx[c]14)[c]15: [highlight $server "." 14 15] [c]00\[[c]14$port[c]00\][c]15"
}
proc togsaveEcho {file} {
  if {[get_env togsave] != ""} {
    return [eval return [get_env togsave]]
  }
  return "[c]14 [c]10Toggles Saved to [c]00$file"
}
proc togloadEcho {file} {
  if {[get_env togload] != ""} {
    return [eval return [get_env togload]]
  }
  return "[c]14 [c]10Loaded toggles from [c]00$file"
}
proc avoiceAdd {hand mask chan} {
  if {[get_env avoice] != ""} {
    return [eval return [get_env avoice]]
  }
  return "[c]11* [c]10Auto[c]11-[c]10voicing [c]11$hand [c]14([c]15$mask[c]14)[c]10 on [c]11$chan"
}
proc aopAdd {hand mask chan} {
  if {[get_env aop] != ""} {
    return [eval return [get_env aop]]
  }
  return "[c]11* [c]10Auto[c]11-[c]10op'ing [c]11$hand [c]14([c]15$mask[c]14)[c]10 on [c]11$chan"
}
proc protectAdd {hand mask chan} {
  if {[get_env protect] != ""} {
    return [eval return [get_env protect]]
  }
  return "[c]11* [c]10Protecting [c]11$hand [c]14([c]15$mask[c]14)[c]10 on [c]11$chan"
}
proc akickAdd {hand mask chan} {
  if {[get_env akick] != ""} {
    return [eval return [get_env akick]]
  }
  return "[c]11* [c]10Auto[c]11-[c]10kicking [c]11$hand [c]14([c]15$mask[c]14)[c]10 on [c]11$chan"
}
proc abanAdd {hand mask chan} {
  if {[get_env aban] != ""} {
    return [eval return [get_env aban]]
  }
  return "[c]11* [c]10Auto[c]11-[c]10banning [c]11$hand [c]14([c]15$mask[c]14)[c]10 on [c]11$chan"
}
proc akbAdd {hand mask chan} {
  if {[get_env akb] != ""} {
    return [eval return [get_env akb]]
  }
  return "[c]11* [c]10Auto[c]11-[c]10kickbanning [c]11$hand [c]14([c]15$mask[c]14)[c]10 on [c]11$chan"
}
proc userRem {hand mask} {
  if {[get_env UserRem] != ""} {
    return [eval return [get_env UserRem]]
  }
  return "[c]11* [c]10Removed [c]11$hand [c]14([c]15$mask[c]14)[c]10 from userlist"
}
proc userlistTop {} {
  if {[get_env UserListTop] != ""} {
    return [eval return [get_env UserListTop]]
  }
  return "[c]14[c]00-[c]14[c]15[c]00[c]15[c]14[c]00-[c]14[c]15\[[c]00\[[c]15\[[c]10User List[c]15\][c]00\][c]15\][c]14[c]00-[c]14[c]15[c]00[c]15[c]14[c]00-[c]14"
}
proc userlistItem {hand mask level chan} {
  if {[get_env UserListItem] != ""} {
    return [eval return [get_env UserListItem]]
  }
  return "[c]14- [c]10[b]\[[b][c]00$hand[c]10[b]\][b]: [c]14$mask [c]11[u]([u][c]14$level[c]11[u])[u] [c]14\[[c]15$chan[c]14\]"
}
proc userlistEnd {} {
  if {[get_env UserListEnd] != ""} {
    return [eval return [get_env UserListEnd]]
  }
  return " "
}
proc selfkickText {chan nick user host knick reason} {
  if {[get_cookie ENV(SelfKick) ""] != ""} {
    return [eval return [get_cookie ENV(SelfKick) ""]]
  } {
    return "[c]14* [c]10You have been kicked from [shade $chan 14 15 00][o] [c]10by [c]11$nick [c]00[b]([b][c]10$reason[o][c]00[b])[b] :[c]00([c]14[atime "am" "pm"][c]00)"
  }
}
proc selfnickText {nick user host newnick} {
  if {[get_cookie ENV(SelfNick) ""] != ""} {
    return [eval return [get_cookie ENV(SelfNick)]]
  } {
    return "[c]11* [c]14You changed your nick to [c]11$newnick [c]00:([c]14[atime "am" "pm"][c]00)"
  }
}
proc defquitText {nick user host quit_msg} {
  if {[get_cookie ENV(DefQuit) ""] != ""} {
    return [eval return [get_cookie ENV(DefQuit)]]
  } {
    return "[c]11* [c]10Signoff[c]11: $nick[c]14\[[c]10$user[c]14@[c]10$host[c]14\]:[c]11 $quit_msg [c]00:([c]14[atime "am" "pm"][c]00)"
  }
}
proc defqueryAction {dest nick user host text} {
  if {[get_cookie ENV(DefQueryAction) ""] != ""} {
    return [eval return [get_cookie ENV(DefQueryAction) ""]]
  } {
    return "[c]10 [c]15$nick[c][colr action] $text"
  }
}
proc defnoqueryAction {dest nick user host text} {
  if {[get_cookie ENV(DefNoQueryAction) ""] != ""} {
    return [eval return [get_cookie ENV(DefNoQueryAction) ""]]
  } {
    return "[c]10 [c]11([c]00$nick [c]10([c]14$user[c]15@[c]14$host[c]10)[c]11)[c]15:[colr action] $text"
  }
}
proc defchanAction {dest nick user host text} {
  if {[get_cookie ENV(DefChanAction) ""] != ""} {
    return [eval return [get_cookie ENV(DefChanAction) ""]]
  } {
    return "[c]10 [c]15$nick[c][colr action] $text"
  }
}
proc defchannotextSound {dest nick user host file} {
  if [string length [get_env DefChanNoTextSound]] {
    return [eval return [get_env DefChanNoTextSound]]
  } {
    return "[c]06 [shade $nick 14 15 00] [c]15sound[c]13([shade $file 00 15 14][c]13)"
  }
}
proc defchantextSound {dest nick user host file text} {
  if [string length [get_env DefChanTextSound]] {
    return [eval return [get_env DefChanTextSound]]
  } {
    return "[c]06 [shade $nick 14 15 00] [c]15sound[c]13([shade $file 00 15 14][c]13):[c]15 $text"
  }
}
proc defquerynotextSound {dest nick user host file} {
  if {[get_cookie ENV(DefQueryNoTextSound) ""] != ""} {
    return [eval return [get_cookie ENV(DefQueryNoTextSound) ""]]
  } {
    return "[c]06 [shade $nick 14 15 00] [c]15sound[c]13([shade $file 00 15 14][c]13)"
  }
}
proc defquerytextSound {dest nick user host file text} {
  if {[get_cookie ENV(DefQueryTextSound) ""] != ""} {
    return [eval return [get_cookie ENV(DefQueryTextSound) ""]]
  } {
    return "[c]06 [shade $nick 14 15 00] [c]15sound[c]13([shade $file 00 15 14][c]13):[c]15 $text"
  }
}
proc defnoquerynotextSound {dest nick user host file} {
  if {[get_cookie ENV(DefNoQueryNoTextSound) ""] != ""} {
    return [eval return [get_cookie ENV(DefNoQueryNoTextSound) ""]]
  } {
    return "[c]06 [shade $nick 14 15 00][c]06\[[c]14$user[c]00@[c]14$host[c]06\] [c]15sound[c]13([shade $file 00 15 14][c]13)"
  }
}
proc defnoquerytextSound {dest nick user host file text} {
  if {[get_cookie ENV(DefNoQueryTextSound) ""] != ""} {
    return [eval return [get_cookie ENV(DefNoQueryTextSound) ""]]
  } {
    return "[c]06 [shade $nick 14 15 00][c]06\[[c]14$user[c]00@[c]14$host[c]06\] [c]15sound[c]13([shade $file 00 15 14][c]13):[c]15 $text"
  }
}
proc selfsoundnotextEcho {dest sound} {
  if {[get_cookie ENV(SelfSoundNoText) ""] != ""} {
    return [eval return [get_cookie ENV(SelfSoundNoText) ""]]
  } {
    return "[c]13 [shade [my_nick] 00 15 14] [c]06sound[c]14([shade $sound 14 15 00][c]14)"
  }
}
proc selfsoundtextEcho {dest sound text} {
  if {[get_cookie ENV(SelfSoundText) ""] != ""} {
    return [eval return [get_cookie ENV(SelfSoundText) ""]]
  } {
    return "[c]13 [shade [my_nick] 00 15 14] [c]06sound[c]00([shade $sound 14 15 00][c]00):[c]14 $text"
  }
}
proc namesuserCount {chan users} {
  if [string length [get_env NamesUserCount]] {
    return [eval return [get_env NamesUserCount]]
  } {
    return "[c]00[c]14names[c]00[b]([b][shade $chan 14 15 14][c]00[b])[b][c]14:"
  }
}
proc namesmainText {chan list} {
  if {[get_cookie ENV(NamesMain) ""] != ""} {
    return [eval return [get_cookie ENV(NamesMain) ""]]
  } {
    return "    [c]14$list"
  }
}
proc nameselementText {item} {
  if {[get_cookie ENV(NamesElement) ""] != ""} {
    return [eval return [get_cookie ENV(NamesElement) ""]]
  } {
    return "[c]14\[[c]00[left [shade $item 00 15 14] 11 "."][c]14\]"
  }
}
proc synctimeEcho {chan sync_time} {
  if {[get_cookie ENV(SynctimeEcho) ""] != ""} {
    return [eval return [get_cookie ENV(SynctimeEcho) ""]]
  } {
    return "[c]00[c]14 channel[c]00([shade $chan 14 15 00][c]00)[c]14: synced in \[[c]00$sync_time[c]14\] secs"
  }
}
proc userisawayEcho {nick awaymsg} {
  if {[get_cookie ENV(UserIsAway) ""] != ""} {
    return [eval return [get_cookie ENV(UserIsAway) ""]]
  } {
    return "[c]14 [shade $nick 00 15 14] [c]14is [c]00a[c]14wa[c]00y[c]14:[c]15 $awaymsg"
  }
}
proc nosuchnickEcho {nick} {
  if {[get_cookie ENV(NoSuchNick) ""] != ""} {
    return [eval return [get_cookie ENV(NoSuchNick) ""]]
  } {
    return "[c]04 [c]15No Such Nick/Chan [c]14([c]00$nick[c]14)"
  }
}
proc unknowncommandEcho {command} {
  if {[get_cookie ENV(UnknownCommand) ""] != ""} {
    return [eval return [get_cookie ENV(UnknownCommand) ""]]
  } {
    return "[c]04 [c]00S[c]14in[c]00([c]14z[c]00er[c]14o[c]00)[c]14: Unknown Command [c]00([c]15$command[c]00)"
  }
}
proc notenoughparmsEcho {command} {
  if {[get_env NotEnoughParms] != ""} {
    return [eval return [get_env NotEnoughParms]]
  } {
    return "[c]14([c]15([c]00( [c]14$command [c]00)[c]15)[c]14)[c]15:[c]14 not enough parameters"
  }
}
proc usernotonchanEcho {nick chan} {
  if {[get_env "UserNotOnChan"] != ""} {
    return [eval return [get_env "UserNotOnChan"]]
  } {
    return "[c]14<[c]15<[c]00<[c]15 [shade $chan 14 00 15] [c]00>[c]15>[c]14> [shade $nick 00 14 15][c]15 is not on that channel"
  }
}
proc notchanopEcho {chan} {
  if {[get_env "NotChanOp"] != ""} {
    return [eval return [get_env "NotChanOp"]]
  } {
    return "[c]14:[c]15:[c]00: [shade $chan 14 15 00] [c]00:[c]15:[c]14:[c]15 you're not a channel operator"
  }
}
proc cannotsendtochanEcho {chan {reason 0}} {
  if ![isint $reason] { set reason 0 }
  if {$reason > 2 || $reason < 0} { set reason 0 }
  if {[get_env CannotSendToChan$reason] != ""} {
    return [eval return [get_env CannotSendToChan$reason]]
  }
  switch -- $reason {
    "0" {
      return "[c]04:[c]05[b]:[b]: [shade $chan 00 15 14] [c]05:[b]:[b][c]04:[c]15 cannot send to channel [c]14([c]15you're not on $chan[c]14)"
    }
    "1" {
      return "[c]04:[c]05[b]:[b]: [shade $chan 00 15 14] [c]05:[b]:[b][c]04:[c]15 cannot send to channel [c]14([c]15$chan is moderated[c]14)"
    }
    "2" {
      return "[c]04:[c]05[b]:[b]: [shade $chan 00 15 14] [c]05:[b]:[b][c]04:[c]15 cannot send to channel [c]14([c]15possible desync[c]00?[c]14)"
    }
  }
}
proc wholistEcho {chan nick user host hops modes ircname} {
  if {[get_cookie ENV(WhoList) ""] != ""} {
    return [eval return [get_cookie ENV(WhoList) ""]]
  } {
    return "[left [shade $chan 14 15 00] 15] [c]15[left $nick 11] [c]14[left [highlight $modes "@*" 00 14] 5] [c]14$user[c]00@[c]14$host ([c]15$ircname[c]14)"
  }
}
proc whoendEcho {pattern total} {
  if {[get_cookie ENV(WhoEnd) ""] != ""} {
    return [eval return [get_cookie ENV(WhoEnd) ""]]
  } {
    return "[c]14End of [c]00/[c]15WHO[c]14 list [c]00([c]14$pattern \[[c]00$total[c]14\][c]00)"
  }
}
proc errEcho {event error} {
  if {[get_cookie ENV(ErrEcho) ""] != ""} {
    return [eval return [get_cookie ENV(ErrEcho) ""]]
  } {
    return "[c]04*[c]14 Error[c]00([c]15$event[c]00):[c]14 $error"
  }
}
proc ignoreaddedText {mask types} {
  if {[get_cookie ENV(IgnoreAdded) ""] != ""} {
    return [eval return [get_cookie ENV(IgnoreAdded) ""]]
  } {
    return "[c]09*[b][c]03*[b]* Ignore added for [c]15$mask [c]03[u]([u][c]14$types[c]03[u])[u]"
  }
}
proc ignoretimeAppend {secs} {
  if [string length [get_env IgnoreTimeAppend]] {
    return [eval return [get_env IgnoreTimeAppend]]
  } {
    return " [c]03-[c]14[duration $secs "w" "d" "h" "m" "s" "" "" " "][c]03-"
  }
}
proc ignoreupdatedText {mask types} {
  if {[get_cookie ENV(IgnoreUpdated) ""] != ""} {
    return [eval return [get_cookie ENV(IgnoreUpdated) ""]]
  } {
    return "[c]09*[b][c]03*[b]* Updated Ignore for [c]15$mask [c]03[u]([u][c]14$types[c]03[u])[u]"
  }
}
proc ignoreremovedText {mask} {
  if {[get_cookie ENV(IgnoreRemoved) ""] != ""} {
    return [eval return [get_cookie ENV(IgnoreRemoved) ""]]
  } {
    return "[c]09*[b][c]03*[b]* Removed Ignore for [c]15$mask"
  }
}
proc cloneheader {dest} {
  if {[get_cookie ENV(CloneHeader) ""] != ""} {
    return [eval return [get_cookie ENV(CloneHeader) ""]]
  } {
    return "[c]00[c]15[c]14[c]05\[[b]\[[c]04\[[b][c]00clonescan([c]14$dest[c]00)[b][c]04\][c]05\][b]\][c]14[c]15[c]00"
  }
}
proc clonemajorline {dest host clones} {
  if {[get_cookie ENV(CloneMajorLine) ""] != ""} {
    return [eval return [get_cookie ENV(CloneMajorLine) ""]]
  } {
    return "[c]00 [left "[shade $host 14 15 00]:" 30] [c]15$clones"
  }
}
proc cloneminorline {dest user host clones nicks} {
  if {[get_cookie ENV(CloneMinorLine) ""] != ""} {
    return [eval return [get_cookie ENV(CloneMinorLine) ""]]
  } {
    return " [right "[c]14$user[c]00@[c]14$host[c]00:" 30] [c]14[left $clones 3] [c]00([c]05$nicks[c]00)"
  }
}
proc clonefooter {dest} {
  if {[get_cookie ENV(CloneFooter) ""] != ""} {
    return [eval return [get_cookie ENV(CloneFooter) ""]]
  } {
    return "[c]00[c]15[c]14[c]05\[[b]\[[c]04\[[b][c]00end of clonescan([c]14$dest[c]00)[b][c]04\][c]05\][b]\][c]14[c]15[c]00"
  }
}
proc noclonesdetected {dest} {
  if {[get_cookie ENV(NoClonesDetected) ""] != ""} {
    return [eval return [get_cookie ENV(NoClonesDetected) ""]]
  } {
    return "[c]00 [c]04([c]14$dest[c]04)[c]00:[c]15 no clones detected"
  }
}
proc operscanheader {dest total} {
  if {[get_cookie ENV(OperScanHeader) ""] != ""} {
    return [eval return [get_cookie ENV(OperScanHeader) ""]]
  } {
    return "[c]14[c]00-[c]14[c]00-[c]15[c]14\[[c]15\[[c]00[b]\[[b][c]14operscan[c]00([c]15$dest[c]00)[b]\][b][c]15\][c]14\][c]15[c]00-[c]14[c]00-[c]14"
  }
}
proc operlist {dest oper user host} {
  if {[get_cookie ENV(OperList) ""] != ""} {
    return [eval return [get_cookie ENV(OperList) ""]]
  } {
    return "[c]14 [left [shade $oper 14 15 00] 15] [c]00([c]14$user[c]00@[c]14$host[c]00)"
  }
}
proc operscanfooter {dest total} {
  if {[get_cookie ENV(OperScanFooter) ""] != ""} {
    return [eval return [get_cookie ENV(OperScanFooter) ""]]
  } {
    return "[c]14[c]00-[c]14[c]00-[c]15[c]14\[[c]15\[[c]00[b]\[[b][c]14total opers [c]00([c]15$total[c]00)[b]\][b][c]15\][c]14\][c]15[c]00-[c]14[c]00-[c]14"
  }
}
proc noopersdetected {dest} {
  if {[get_cookie ENV(NoOpersDetected) ""] != ""} {
    return [eval return [get_cookie ENV(NoOpersDetected) ""]]
  } {
    return "[c]14 [shade $dest 14 15 00][c]00:[c]15 no opers detected"
  }
}
proc toglistTop {} {
  if {[get_cookie ENV(TogListTop) ""] != ""} {
    return [eval return [get_cookie ENV(TogListTop) ""]]
  } {
    return "[c]10[c]11[b]-[b][c]10[c]11[b]-[b][c]10[c]11[b][b][c]10[c]11[b]-[b][c]10[c]11[b]-[b][c]10"
  }
}
proc toglistBottom {} {
  if {[get_cookie ENV(TogListBottom) ""] != ""} {
    return [eval return [get_cookie ENV(TogListBottom) ""]]
  } {
    return "[c]10[c]11[b]-[b][c]10[c]11[b]-[b][c]10[c]11[b][b][c]10[c]11[b]-[b][c]10[c]11[b]-[b][c]10"
  }
}
proc togstringsEcho {toggle value} {
  if {[get_env "TogStrings"] != ""} {
    return [eval return [get_env "TogStrings"]]
  } {
    return "[c]11 [c]10[left "$toggle[c]15" 21 "."][c]14..[c]15$value"
  }
}
proc togboolononEcho {tog1 tog2} {
  if {[get_env TogBoolOnOn] != ""} {
    return [eval return [get_env TogBoolOnOn]]
  }
  return "[c]10:[c]11:[b]:[b]:[c]10: \[[c]11x[c]10\] [left $tog1 20] [c]10:[c]11:[b]:[b]:[c]10: \[[c]11x[c]10\] [left $tog2 20] [c]10:[c]11:[b]:[b]:[c]10:"
}
proc togboolonoffEcho {tog1 tog2} {
  if {[get_env TogBoolOnOff] != ""} {
    return [eval return [get_env TogBoolOnOff]]
  }
  return "[c]10:[c]11:[b]:[b]:[c]10: \[[c]11x[c]10\] [left $tog1 20] [c]10:[c]11:[b]:[b]:[c]10: \[ \] [left $tog2 20] [c]10:[c]11:[b]:[b]:[c]10:"
}
proc togbooloffonEcho {tog1 tog2} {
  if {[get_env TogBoolOffOn] != ""} {
    return [eval return [get_env TogBoolOffOn]]
  }
  return "[c]10:[c]11:[b]:[b]:[c]10: \[ \] [left $tog1 20] [c]10:[c]11:[b]:[b]:[c]10: \[[c]11x[c]10\] [left $tog2 20] [c]10:[c]11:[b]:[b]:[c]10:"
}
proc togbooloffoffEcho {tog1 tog2} {
  if {[get_env TogBoolOffOff] != ""} {
    return [eval return [get_env TogBoolOffOff]]
  }
  return "[c]10:[c]11:[b]:[b]:[c]10: \[ \] [left $tog1 20] [c]10:[c]11:[b]:[b]:[c]10: \[ \] [left $tog2 20] [c]10:[c]11:[b]:[b]:[c]10:"
}
proc togboolonEcho {tog} {
  if {[get_env TogBoolOn] != ""} {
    return [eval return [get_env TogBoolOn]]
  }
  return "[c]10:[c]11:[b]:[b]:[c]10: \[[c]11x[c]10\] [left $tog 20] [c]10:[c]11:[b]:[b]:[c]10:"
}
proc togbooloffEcho {tog} {
  if {[get_env TogBoolOff] != ""} {
    return [eval return [get_env TogBoolOff]]
  }
  return "[c]10:[c]11:[b]:[b]:[c]10: \[ \] [left $tog 20] [c]10:[c]11:[b]:[b]:[c]10:"
}
proc togusersEcho {toggle value} {
  if {[get_env "TogUsers"] != ""} {
    return [eval return [get_env "TogUsers"]]
  }
  return "[c]11 [c]10[left $toggle[c]15 21 "."][c]14..[c]15$value"
}
proc awaystyle {reason logging paging email} {
  if {[get_cookie ENV(AwayStyle) ""] != ""} {
    return [eval return [get_cookie ENV(AwayStyle) ""]]
  }
  return "is away[u]:[u] $reason [b]s[b]in[u]([u][b]l[b]\[$logging\].[b]p[b]\[$paging\][u])[u]"
}
proc awaytext {reason logging paging email} {
  if {[get_cookie ENV(AwayText) ""] != ""} {
    return [eval return [get_cookie ENV(AwayText) ""]]
  } {
    return "$reason \[since:[atime "am" "pm" 0 "."]\] [u]e[u]mail($email) [b]s[b]in..."
  }
}
proc backstyle {reason baskmsg gonefor} {
  if {[get_cookie ENV(BackStyle) ""] != ""} {
    return [eval return [get_cookie ENV(BackStyle) ""]]
  } {
    return "is back from[b]:[b] $reason [b]s[b]in[u]([u][b]g[b]one\[[join [duration $gonefor "w" "d" "h" "m" "s" "" "" ""] ":"]\][u])[u]"
  }
}
proc rawokreplyText {raw text} {
  if {[get_env RawOKReply] != ""} {
    return [eval return [get_env "RawOKReply"]]
  } {
    return "[c]10 [c]15$text"
  }
}
proc rawerrreplyText {raw text} {
  if {[get_env RawERRReply] != ""} {
    return [eval return [get_env "RawERRReply"]]
  } {
    return "[c]05 [c]14$text"
  }
}
proc banlistheadEcho {} {
  if [string length [get_env "BanListHead"]] {
    return [eval return [get_env "BanListHead"]]
  }
  return "[c]14[c]15[c]00-[c]15[c]14-[c]15[c]00[c]15[c]00[c]15[c]14-[c]15[c]00-[c]15"
}
proc banlistmaskEcho {chan idx mask by time} {
  if {[get_env "BanListMask"] != ""} {
    return [eval return [get_env "BanListMask"]]
  } {
    return "[c]14[c]00 Ban[c]14([c]00$idx[c]14)[c]15 [shade $mask 00 15 14][c]14 banned[c]00([c]15[date $time "%H:%M:%S %D"][c]00)[c]14 by [shade $by 14 15 00]"
  }
}
proc banlistendEcho {chan count} {
  if {[get_env "BanListEnd"] != ""} {
    return [eval return [get_env "BanListEnd"]]
  } {
    return "[c]14[c]15[c]00-[c]15[c]14-[c]15[c]00[c]15[c]14([c]15Bans [shade $chan 15 14 00][c]14\[[c]00$count[c]14\])[c]15[c]00[c]15[c]14-[c]15[c]00-[c]15"
  }
}
proc motdheadEcho {text} {
  if {[get_env "MotdHead"] != ""} {
    return [eval return [get_env "MotdHead"]]
  } {
    return "[c]14[c]15-[c]00[c]15[c]14[c]15[c]00-[c]15[c]14[c]00([c]14MOTD[c]00)[c]14[c]15[c]00-[c]15[c]14[c]15[c]00[c]15-[c]14"
  }
}
proc motdtextEcho {text} {
  if {[get_env "MotdText"] != ""} {
    return [eval return [get_env "MotdText"]]
  } {
    return "[c]14[c]15 $text"
  }
}
proc motdendEcho {text} {
  if {[get_env "MotdEnd"] != ""} {
    return [eval return [get_env "MotdEnd"]]
  } {
    return " "
  }
}
proc ialscancompleteEcho {dest total} {
  if {[get_cookie ENV(IALScanComplete) ""] != ""} {
    return [eval return [get_cookie ENV(IALScanComplete) ""]]
  } {
    echo "[c]14 [c]15Updated IAL for $dest [c]14([c]00$total [c]15nicks added[c]14)"
  }
}
proc servermodeText {chan server mode} {
  if {[get_cookie ENV(ServerMode) ""] != ""} {
    return [eval return [get_cookie ENV(ServerMode)]]
  } {
    return "[c]00*[c]15*[c]14* [shade $server 14 15 00] [c]15sets mode [c]14([c]10$mode[c]14)[c]15 in [c]00$chan"
  }
}
proc servernoticeText {dest server text} {
  if {[get_cookie ENV(ServerNoticeText) ""] != ""} {
    return [eval return [get_cookie ENV(ServerNoticeText) ""]]
  } {
    return "[c]00-[c]14([shade $server 00 15 14][c]14)[c]00-[c][colr notice] $text"
  }
}
proc notifyEcho {nick user host time} {
  return "[c]14\[[c]00[clock format $time -format "%I:%M:%S"][c]14\]: [c]00$nick [c]14([c]15$user[c]14@[c]15$host[c]14)[c]15 is on IRC"
}
proc errorText {text} {
  if [string length [get_env "ErrorText"]] {
    return [eval return [get_env "ErrorText"]]
  }
  return "[c]04[b]*[b]*[c]05*[c]04 Error[c]14:[c]15 $text"
}
proc killedText {nick user host reason} {
  if [string length [get_env "KilledText"]] {
    return [eval return [get_env "KilledText"]]
  }
  return "[c]14*[c]10 You have been [c]11killed[c]10 by [c]11$nick [c]00[b]([b][c]10$user[c]00@[c]10$host[c]00[b])[b] [c]14\[[c]15$reason[c]14\] [c]00:([c]14[atime][c]00)"
}
proc serverchannoticeText {dest server text} {
  if {[get_cookie ENV(ServerChanNoticeText) ""] != ""} {
    return [eval return [get_cookie ENV(ServerChanNoticeText) ""]]
  } {
    return "[c]00:[c]15:[c]14:[shade $dest 00 15 14][c]14:[c]15:[c]00: -[c]14([c]00$server[c]14)[c]00-[c][colr notice] $text"
  }
}
proc nohostnoticeText {dest text} {
  if {[get_cookie ENV(NoHostNoticeText) ""] != ""} {
    return [eval return [get_cookie ENV(NoHostNoticeText) ""]]
  } {
    return "[c]00:[c]15:[c]14: [shade $text 00 15 14]"
  }
}
proc dnsattemptEcho {hostname} {
  if {[get_cookie ENV(DnsAttempt) ""] != ""} {
    return [eval return [get_cookie ENV(DnsAttempt) ""]]
  } {
    return "[c]15 [c]10Attempting to resolve [shade $hostname 00 15 14]"
  }
}
proc dnsresolvedEcho {hostname resolved} {
  if {[get_cookie ENV(DnsResolved) ""] != ""} {
    return [eval return [get_cookie ENV(DnsResolved) ""]]
  } {
    return "[c]11 [c]10Resolved [shade $hostname 14 15 00] [c]10to [shade $resolved 11 15 14]"
  }
}
proc dnsfailedEcho {hostname} {
  if {[get_cookie ENV(DnsFailed) ""] != ""} {
    return [eval return [get_cookie ENV(DnsFailed) ""]]
  } {
    return "[c]11[c]10 Unable to resolve [shade $hostname 14 15 11]"
  }
}
proc dnsqueueHead {total} {
  if [string length [get_env "DnsQueueHead"]] {
    return [eval return [get_env "DnsQueueHead"]]
  }
  return "[c]10 [c]14Hostnames to Resolve[c]00:"
}
proc dnsqueueItem {hostname} {
  if [string length [get_env "DnsQueueItem"]] {
    return [eval return [get_env "DnsQueueItem"]]
  }
  return "  [c]10 [c]15$hostname"
}
proc dnsqueueEnd {total} {
  if [string length [get_env "DnsQueueEnd"]] {
    return [eval return [get_env "DnsQueueEnd"]]
  }
  return "[c]10 [c]14Hostnames[c]11[b]([b][c]00$total[c]11[b])[b]"
}
proc userhostEcho {userhost} {
  if {[get_env "UserHost"] != ""} {
    return [eval return [get_env "UserHost"]]
  } {
    return "[c]11 [c]10[highlight $userhost "=+*@" 11 10]"
  }
}
proc useripEcho {userip} {
  if {[get_env "UserIp"] != ""} {
    return [eval return [get_env "UserIp"]]
  } {
    return "[c]11 [c]10[highlight $userip "=+*@" 11 10]"
  }
}
proc whowashost {nick user host name} {
  if {[get_env "WhoWasHost"] != ""} {
    return [eval return [get_env "WhoWasHost"]]
  }
  return "[c]11> [shade $nick 15 00 15] [c]00([c]14$user[c]00@[c]14$host[c]00) [c]14\[[c]15$name[c]14\]"
}
proc whowasserver {nick server laston} {
  if {[get_env "WhoWasServer"] != ""} {
    return [eval return [get_env "WhoWasServer"]]
  }
  return "[c]11> [shade $nick 15 00 15] [c]14on [c]10$server [c]14[b]([b][c]00$laston[c]14[b])[b]"
}
proc whowasend {nick} {
  if {[get_env "WhoWasEnd"] != ""} {
    return [eval return [get_env "WhoWasEnd"]]
  }
  return " "
}
proc whowasaway {nick awaymsg} {
  if [string length [get_env "WhoWasAway"]] {
    return [eval return [get_env "WhoWasAway"]]
  } {
    return "[c]11> [shade $nick 15 00 15] [c]14away:[c]15 $awaymsg"
  }
}
proc whowasnouser {nick} {
  if {[get_env "WhoWasNoUser"] != ""} {
    return [eval return [get_env "WhoWasNoUser"]]
  }
  return "[c]04> [shade $nick 14 15 14][c]00[b]:[b][c]14 there was no such user."
}
proc whoisTop {nick} {
  if {[get_cookie ENV(WhoisTop) ""] != ""} {
    return [eval return [get_cookie ENV(WhoisTop)]]
  } {
    return "[c]00[c]15-[c]14-[c]05\[[b]\[[c]04\[[b][c]00[u]$nick[u][c]04[b]\][c]05\][b]\][c]14-[c]15-[c]00"
  }
}
proc whoisuserhost {nick user host country} {
  if {[get_cookie ENV(whoisuserhost) ""] != ""} {
    return [eval return [get_cookie ENV(whoisuserhost)]]
  } {
    return "[c]00 [c]15wh[c]14ois [c]15:[c]14 $user[c]00@[c]14$host [c]00([c]14$country[c]00)"
  }
}
proc whoisdnsinfo {nick host ip} {
  if [string length [get_env "whoisdnsinfo"]] {
    return [eval return [get_env "whoisdnsinfo"]]
  }
  return "[c]00 [c]15dn[c]14s   [c]15:[c]14 $host [c]00is[c]14 $ip"
}
proc whoisname {nick name} {
  if {[get_cookie ENV(whoisname) ""] != ""} {
    return [eval return [get_cookie ENV(whoisname)]]
  } {
    return "[c]00 [c]15na[c]14me  [c]15:[c]14 $name"
  }
}
proc whoisserver {nick server server_info} {
  if {[get_cookie ENV(whoisserver) ""] != ""} {
    return [eval return [get_cookie ENV(whoisserver)]]
  } {
    return "[c]00 [c]15se[c]14rver[c]15:[c]14 $server [c]00\[[c]15$server_info[c]00\]"
  }
}
proc whoischans {nick chans} {
  if {[get_cookie ENV(whoischans) ""] != ""} {
    return [eval return [get_cookie ENV(whoischans)]]
  } {
    return "[c]00 [c]15ch[c]14ans [c]15:[c]14 [highlight $chans \"#@+&\" 00 14]"
  }
}
proc whoissignon {nick signon} {
  if {[get_env whoissignon] != ""} {
    return [eval return [get_env whoissignon]]
  } {
    return "[c]00 [c]15si[c]14gnon[c]15:[c]14 [clock format $signon]"
  }
}
proc whoisidle {nick idle} {
  if {[get_cookie ENV(whoisidle) ""] != ""} {
    return [eval return [get_cookie ENV(whoisidle)]]
  } {
    return "[c]00 [c]15id[c]14le  [c]15:[c]14 [duration $idle w d h m s "" "" " "]"
  }
}
proc whoisnosuchnick {nick} {
  if {[get_cookie ENV(whoisnosuchnick) ""] != ""} {
    return [eval return [get_cookie ENV(whoisnosuchnick)]]
  } {
    return "[c]00 [c]15wh[c]14ois [c]15:[c]14 no such user"
  }
}
proc whoisoper {nick} {
  if {[get_cookie ENV(whoisoper) ""] != ""} {
    return [eval return [get_cookie ENV(whoisoper)]]
  } {
    return "[c]00 [c]15ir[c]14cop [c]15:[c]14 $nick is an iRC-op [c]00([c]15+o[c]00)"
  }
}
proc whoisaway {nick awaymsg} {
  if {[get_cookie ENV(whoisaway) ""] != ""} {
    return [eval return [get_cookie ENV(whoisaway) ""]]
  } {
    return "[c]00 [c]15aw[c]14ay  [c]15:[c]14 $awaymsg"
  }
}
proc whoisBottom {nick} {
  if {[get_cookie ENV(WhoisBottom) ""] != ""} {
    return [eval return [get_cookie ENV(WhoisBottom)]]
  } {
    return " "
  }
}
proc modesetEcho {chan mode} {
  if {[get_cookie ENV(ModeSetEcho) ""] != ""} {
    return [eval return [get_cookie ENV(ModeSetEcho) ""]]
  } {
    return "[c]14 [c]10Modes[c]00([c]11$chan[c]00) [c]14+$mode"
  }
}
proc nomodesetEcho {chan} {
  if {[get_cookie ENV(NoModeSetEcho) ""] != ""} {
    return [eval return [get_cookie ENV(NoModeSetEcho) ""]]
  } {
    return "[c]14 [c]10Modes[c]00([c]11$chan[c]00) [c]15\[[c]14no modes set[c]15\]"
  }
}
proc chantopicEcho {chan topic} {
  if [string length [get_env "ChanTopic"]] {
    return [eval return [get_env "ChanTopic"]]
  }
  return "[c]14 [c]10Topic[c]14([c]11$chan[c]14):[c]15 $topic"
}
proc topicbyEcho {chan nick time} {
  if [string length [get_env TopicByEcho]] {
    return [eval return [get_env TopicByEcho]]
  } {
    return "[c]14 [c]10Topic[c]00([c]11$chan[c]00)[c]14 by [shade $nick 00 15 14] [c]10([c]15[clock format $time][c]10)"
  }
}
proc chancreatedEcho {chan time} {
  if {[get_cookie ENV(ChanCreatedEcho) ""] != ""} {
    return [eval return [get_cookie ENV(ChanCreatedEcho) ""]]
  } {
    return "[c]14 [c]10Created[c]00([c]11$chan[c]00)[c]14 [clock format $time]"
  }
}
proc invalidcreationtimeEcho {chan time} {
  if {[get_cookie ENV(InvalidCreationTimeEcho) ""] != ""} {
    return [eval return [get_cookie ENV(InvalidCreationTimeEcho) ""]]
  } {
    return "[c]14 [c]10Created[c]00([c]11$chan[c]00)[c]14 [c]00\[[c]14unknown creation time[c]00\]"
  }
}
proc lusersTop {server users invis opers servers total chans unknown localusers localservers} {
  if {[get_cookie ENV(LusersTop) ""] != ""} {
    return [eval return [get_cookie ENV(LusersTop) ""]]
  } {
    return "[c]13[c]10[c]11-[c]10[c]11-[c]10\[[b]\[[c]11\[[b][c]06Lusers[c]14([shade $server 00 15 14][c]14)[b][c]11\][c]10\][b]\][c]11-[c]10[c]11-[c]10[c]13"
  }
}
proc lusersBody {server users invis opers servers total chans unknown localusers localservers} {
  if {[get_cookie ENV(LusersBody) ""] != ""} {
    return [eval return [get_cookie ENV(LusersBody) ""]]
  } {
    return "[c]13 [c]10Lusers[c]14: [c]15Total[c]14\[[c]00$total[c]14\][c]15 [c]06([c]14Invisible[c]06\[[c]10$invis [c]13([c]11[percent $invis $total "%"][c]13)[c]06\][c]14 Opers[c]06\[[c]10$opers [c]13([c]11[percent $opers $total "%"][c]13)[c]06\]\n[c]13 [c]10Lusers[c]14: [c]15Chans[c]14\[[c]00$chans[c]14\][c]10 on [c]00$servers[c]15 Servers\n[c]13 [c]10Lusers[c]14: [c]15Users/Chan[c]14\[[c]00[format %.1f [div $total ${chans}.0]][c]14\] [c]15Users/Serv[c]14\[[c]00[format %.1f [div $total ${servers}.0]][c]14\]\n[c]13 [c]10Lusers[c]14: [c]15Local Users[c]14\[[c]00$localusers [c]06([c]10[percent $localusers $total "%"][c]06)[c]14\]\n[c]13 [c]10Lusers[c]14: [c]15Local Servers[c]14\[[c]00$localservers [c]06([c]10[percent $localservers $servers "%"][c]06)[c]14\]\n[c]13 [c]10Lusers[c]14: [c]15Unknown Connections[c]14\[[c]00$unknown[c]14\]"
  }
}
proc lusersBottom {server users invis opers servers total chans unknown localusers localservers} {
  if {[get_cookie ENV(LusersBottom) ""] != ""} {
    return [eval return [get_cookie ENV(LusersBottom) ""]]
  } {
    return "[c]13[c]10[c]11-[c]10[c]11-[c]10[c]11-[c]10[c]11-[c]10"
  }
}
proc dcccreateEcho {type nick file size} {
  if {[stu $type] == "GET"} {
    if {[get_env "DCCGetCreate"] != ""} {
      return [eval return [get_env "DCCGetCreate"]]
    } {
      return "[c]04 [shade $nick 00 15 14][c]14 is Sending [shade $file 14 15 00] [c]00[b]([b][c]14[byte_format $size][c]00)[b]"
    }
  } {
    if {[get_env "DCCSendCreate"] != ""} {
      return [eval return [get_env "DCCSendCreate"]]
    } {
      return "[c]04 [c]14Sending [shade $file 14 15 00] [c]00[b]([b][c]14[byte_format $size][c]00[b])[b][c]14 to [shade $nick 00 15 14]"
    }
  }
}
proc dccbeginEcho {type nick file size} {
  if {[stu $type] == "GET"} {
    if {[get_env "DCCGetBegin"] != ""} {
      return [eval return [get_env "DCCGetBegin"]]
    } {
      return "[c]04 [c]14Started recieving [shade $file 14 15 00][c]14 from [shade $nick 00 15 14]"
    }
  } {
    if {[get_env "DCCSendBegin"] != ""} {
      return [eval return [get_env "DCCSendBegin"]]
    } {
      return "[c]04 [c]14Started transfer of [shade $file 14 15 00] to [shade $nick 00 15 14]"
    }
  }
}
proc dcccompleteEcho {type nick file size speed time} {
  if {[stu $type] == "GET"} {
    if {[get_env "DCCGetComplete"] != ""} {
      return [eval return [get_env "DCCGetComplete"]]
    } {
      return "[c]04 [c]14Transfer Complete: [shade $file 14 15 00] [c]00[b]([b][c]14[byte_format $size][c]00)[b][c]14 from [shade $nick 00 15 14] [c]14([c]15[highlight [join [dur $time] ":"] ":" 14 15][c]14) [b]([b][c]00$speed [c]15k[u]/[u]sec[c]14[b])[b]"
    }
  } {
    if {[get_env "DCCSendComplete"] != ""} {
      return [eval return [get_env "DCCSendComplete"]]
    } {
      return "[c]04 [c]14Transfer Complete: [shade $file 14 15 00] [c]00[b]([b][c]14[byte_format $size][c]00)[b][c]14 to [shade $nick 00 15 14] [c]14([c]15[highlight [join [dur $time] ":"] ":" 14 15][c]14) [b]([b][c]00$speed [c]15k[u]/[u]sec[c]14[b])[b]"
    }
  }
}
proc dccrenameEcho {type nick file size renamed} {
  if {[get_env "DCCRename"] != ""} {
    return [eval return [get_env "DCCRename"]]
  } {
    return "[c]04 [c]14Renamed [shade $file 14 15 00] to [shade $renamed 00 15 14]"
  }
}
proc dccerrorEcho {type nick file size errornumber} {
  if {[stu $type] == "SEND"} {
    if {[get_env "DCCSendError"] != ""} {
      return [eval return [get_env "DCCSendError"]]
    } {
      return "[c]05 [c]04Error sending [shade $file 00 15 14][c]04 to [shade $nick 05 15 14] [c]04[b]([b][c]05$errornumber[c]04[b])[b]"
    }
  } {
    if {[get_env "DCCGetError"] != ""} {
      return [eval return [get_env "DCCGetError"]]
    } {
      return "[c]05 [c]04Error recieving [shade $file 00 15 14][c]04 from [shade $nick 05 15 14] [c]04[b]([b][c]05$errornumber[c]04[b])[b]"
    }
  }
}
proc selfchanText {dest text} {
  if {[get_cookie ENV(SelfChanText) ""] != ""} {
    return [eval return [get_cookie ENV(SelfChanText)]]
  } {
    return "[c]15([c]14:[shade [my_nick] 00 15 14][c]14:[c]15)[c][colr selftext] $text"
  }
}
proc selfqueryText {dest text} {
  if {[get_cookie ENV(SelfQueryText) ""] != ""} {
    return [eval return [get_cookie ENV(SelfQueryText)]]
  } {
    return "[c]15([shade [my_nick] 14 15 00][c]15)[c]14:[c][colr selftext] $text"
  }
}
proc selfchanAction {dest text} {
  if {[get_cookie ENV(SelfChanAction) ""] != ""} {
    return [eval return [get_cookie ENV(SelfChanAction) ""]]
  } {
    return "[c]11 [c]15[my_nick][c][colr selfaction] $text"
  }
}
proc selfqueryAction {dest text} {
  if {[get_cookie ENV(SelfQueryAction) ""] != ""} {
    return [eval return [get_cookie ENV(SelfQueryAction) ""]]
  } {
    return "[c]11 [c]15[my_nick][c][colr selfaction] $text"
  }
}
proc selfmsgText {dest text} {
  if {[get_cookie ENV(SelfMsgText) ""] != ""} {
    return [eval return [get_cookie ENV(SelfMsgText)]]
  } {
    return "[c]04>[shade $dest 14 15 00] [c]04>[c]05[b]>[b]>[c][colr selfmsg] $text"
  }
}
proc selfnoticeText {dest text} {
  if {[get_cookie ENV(SelfNoticeText) ""] != ""} {
    return [eval return [get_cookie ENV(SelfNoticeText)]]
  } {
    return "[c]14>[shade $dest 14 15 00] [c]14>[c]15>[c]00>[c][colr selfnotice] $text"
  }  
}
proc selfctcpText {dest type rest} {
  if {[get_cookie ENV(SelfCtcpText) ""] != ""} {
    return [eval return [get_cookie ENV(SelfCtcpText)]]
  } {
    return "[c]02[b]>[b][shade $dest 14 15 00] [c]12>[c]02[b]>[b]>[c]15 $type $rest"
  }  
}
proc selfmodeText {mode usermode} {
  if {[get_cookie ENV(SelfMode) ""] != ""} {
    return [eval return [get_cookie ENV(SelfMode)]]
  } {
    return "[c]10* [c]14User mode changed [c]10([c]14$mode[c]10) [c]11\[[c]14+$usermode[c]11\]"
  }
}
proc selfchatAction {dest text} {
  if {[get_cookie ENV(SelfChatAction) ""] != ""} {
    return [eval return [get_cookie ENV(SelfChatAction) ""]]
  } {
    return "[c]11 [c]15[my_nick][c][colr selfaction] $text"
  }
}
proc selfchatText {dest text} {
  if {[get_cookie ENV(SelfChatText) ""] != ""} {
    return [eval return [get_cookie ENV(SelfChatText) ""]]
  } {
    return "[c]00[b]\[[b][right [shade [my_nick] 14 15 00] 10][c]00[b]\][b][c]14:[c][colr selfchattext] $text"
  }
}
proc ncompify {nick {n ""}} {
  if ![isint $n] { set n [get_tog "Ncomp"] }
  if ![isint $n] { set n 1 }
  switch -- $n {
    "1" { return "$nick[b]:[b]" }
    "2" { return "$nick[u]:[u]" }
    "3" {
      if {[string length $nick] < 2} { return "[b]$nick[b]:" }
      if {[string length $nick] == 2} { return "[b][string index $nick 0][b][u][string index $nick 1][u]:" }
      set a [string index $nick 0]
      set b [string range $nick 1 [expr [string length $nick]-2]]
      set c [string index $nick [expr [string length $nick]-1]]
      return "[b]$a[b]$b[u]$c[u]:"
    }
    "4" {
      if {[string length $nick] < 2} { return "[u]$nick[u]:" }
      if {[string length $nick] == 2} { return "[u][string index $nick 0][u][b][string index $nick 1][b]:" }
      set a [string index $nick 0]
      set b [string range $nick 1 [expr [string length $nick]-2]]
      set c [string index $nick [expr [string length $nick]-1]]
      return "[u]$a[u]$b[b]$c[b]:"
    }
    "5" {
      if {[string length $nick] < 3} { return "[b]$nick[b][u]:[u]" }
      set a [string index $nick 0]
      set b [string range $nick 1 [expr [string length $nick]-2]]
      set c [string index $nick [expr [string length $nick]-1]]
      return "[b]$a[b][u]$b[u][b]$c[b][u]:[u]"
    }
    "6" {
      if {[string length $nick] < 3} { return "[u]$nick[u][b]:[b]" }
      set a [string index $nick 0]
      set b [string range $nick 1 [expr [string length $nick]-2]]
      set c [string index $nick [expr [string length $nick]-1]]
      return "[u]$a[u][b]$b[b][u]$c[u][b]:[b]"
    }
    "7" {
      set out ""
      for {set x 0} {$x < [string length $nick]} {incr x} {
        set y [string index $nick $x]
        set b [random 0 2]
        set c [random 0 1]
        switch -- $b {
          "0" { set z [b] }
          "1" { set z [u] }
          "2" { set z [r] }
        }
        if $c { set y [stu $y] } { set y [stl $y] }
        set out $out$z$y$z
      }
      return "$out:"
    }
    "8" {
      if {[string length $nick] < 3} { return "[u]([u][b]$nick[b][u])[u]:" }
      set a [string index $nick 0]
      set b [string range $nick 1 [expr [string length $nick]-2]]
      set c [string index $nick [expr [string length $nick]-1]]
      return "[u]([u][b]$a[b]$b[b]$c[b][u])[u]:"
    }
    "9" {
      if {[string length $nick] < 2} { return "[b]$nick[b]:" }
      set a [string index $nick 0]
      set b [string range $nick 1 end]
      return "[b]$a[b][u]$b[u]:"
    }
    "10" {
      return "[b]|[b][u]$nick[u][b].[b]"
    }
    "11" {
      set out "[u]$nick[u]"
      set out [replace $out "g" "[u]g[u]"]
      set out [replace $out "j" "[u]j[u]"]
      set out [replace $out "p" "[u]p[u]"]
      set out [replace $out "q" "[u]q[u]"]
      set out [replace $out "y" "[u]y[u]"]
      set out [replace $out "|" "[u]|[u]"]
      set out [replace $out "_" "[u]_[u]"]
      return "[b]\[[b]$out[b]\][b]"
    }
    default { return "$nick[b]:[b]" }
  }
}
proc xwallstyle {list text} {
  if {[get_cookie ENV(XwallStyle) ""] != ""} {
    return [eval return [get_cookie ENV(XwallStyle) ""]]
  } {
    return "[b][u]s[b]Z[u][b]([b]xWall[b])[b]: $text"
  }
}
proc xwallText {list text} {
  if {[get_cookie ENV(XwallEcho) ""] != ""} {
    return [eval return [get_cookie ENV(XwallEcho) ""]]
  } {
    return "[c]14[b]\[[b][c]00[u][b]s[b][c]15Z[u][c]14[b]([b][c]00x[c]15W[c]14a[c]15l[c]00l[c]14[b])\][b]:[c]15 $text"
  }
}
proc wallStyle {chan ops text} {
  if {[get_cookie ENV(WallStyle) ""] != ""} {
    return [eval return [get_cookie ENV(WallStyle) ""]]
  } {
    return "[b]([b]wall/$chan[b])[b]: $text"
  }
}
proc wallEcho {chan ops text} {
  if {[get_cookie ENV(WallEcho) ""] != ""} {
    return [eval return [get_cookie ENV(WallEcho) ""]]
  } {
    return "[c]00-[c]14([c]15ops[c]00/[shade $chan 14 15 00][c]14)[c]00-[c]15 $text"
  }
}
proc defwallopText {nick user host text} {
  if {[get_cookie ENV(DefWallopText) ""] != ""} {
    return [eval return [get_cookie ENV(DefWallopText) ""]]
  } {
    return "[c]06:[b][c]13![b][shade $nick 00 15 14][b][c]13![b][c]06:[c]14 $text"
  }
}
proc serverwallopText {server text} {
  if {[get_cookie ENV(ServerWallopText) ""] != ""} {
    return [eval return [get_cookie ENV(ServerWallopText) ""]]
  } {
    return "[b][c]13![b][shade $server 00 15 14][b][c]13![b][c]14 $text"
  }
}
proc newaliasEcho {file alias script} {
  if {[get_env "NewAlias"] != ""} {
    return [eval return [get_env "NewAlias"]]
  } {
    return "[c]12*[c]02[b]*[b]* [c]12Added alias [c]10[b]\[[b][c]12$alias[c]10[b]\][b][c]12 to [c]14$file"
  }
}
proc keyboundEcho {key script} {
  if {[get_env "KeyBound"] != ""} {
    return [eval return [get_env "KeyBound"]]
  } {
    return "[c]11*[c]10[b]*[b]* Bound key [c]11[b]\[[b][c]10F$key[c]11[b]\][b][c]10 to [c]11([c]10$script[c]11)"
  }
}
proc keyunboundEcho {key} {
  if {[get_env "KeyUnbound"] != ""} {
    return [eval return [get_env "KeyUnbound"]]
  } {
    return "[c]11*[c]10[b]*[b]* Unbound key [c]11[b]\[[b][c]10F$key[c]11[b]\][b]"
  } 
}

####- End(Style Value Returns) -####

proc not_connected {} {
  echo [errEcho [event] "please connect to an IRC server"]
  return 0
}

proc get_xirctog {toggle {default ""}} {
  set x [FALC_config "Preferences\\General" $toggle]
  if [string length $x] { return $x }
  return $default
}
proc get_tog {toggle {default ""}} {
  if {[stl $toggle] == "away_log"} { return "[pwd]/logs/awaymsgs.log" }
  if {[stl $toggle] == "page_log"} { return "[pwd]/logs/pagemsgs.log" }
  if {[stl $toggle] == "personal_log"} { return "[pwd]/logs/self.log" }
  if {[stl $toggle] == "config_file"} { return "[pwd]/sin.ini" }
  return [get_cookie TOG($toggle) $default]
}
proc set_tog {toggle value} {
  set_cookie TOG($toggle) $value
  return 1
}
proc rem_tog {toggle type} {
  set type [stl $type]
  switch -- $type {
    "bool" {
      set tlist [get_cookie BOOL_TOGS]
      set pos [lsearch -exact [stl $tlist] [stl $toggle]]
      if {$pos >= 0} {
        set tlist [lreplace $tlist $pos $pos]
      }
      set_cookie BOOL_TOGS $tlist
    }
    "string" {
      set tlist [get_cookie STRING_TOGS]
      set pos [lsearch -exact [stl $tlist] [stl $toggle]]
      if {$pos >= 0} {
        set tlist [lreplace $tlist $pos $pos]
      }
      set_cookie STRING_TOGS $tlist
    }
    "user" {
      set tlist [get_cookie USER_TOGS]
      set pos [lsearch -exact [stl $tlist] [stl $toggle]]
      if {$pos >= 0} {
        set tlist [lreplace $tlist $pos $pos]
      }
      set_cookie USER_TOGS $tlist
    }
  }
  set_cookie TOG($toggle) ""
}
proc build_tog {toggle value {type "user"}} {
  set type [stl $type]
  switch -- $type {
    "bool" {
      set tlist [get_cookie "BOOL_TOGS"]
      set value [stl $value]
      if {$value != "on"} { set value "off" }
    }
    "string" {
      set tlist [get_cookie "STRING_TOGS"]
    }
    default {
      set type "USER"
      set tlist [get_cookie "USER_TOGS"]
    }
  }
  if ![lfind $tlist $toggle] {
    lappend tlist $toggle
  }
  set_cookie [stu $type]_TOGS $tlist
  if ![string length [get_tog $toggle]] {
    set_tog $toggle $value
  }
  return $value
}
proc tog_type {toggle} {
  if [bool_tog $toggle] { return "bool" }
  if [string_tog $toggle] { return "string" }
  if [user_tog $toggle] { return "user" }
  return ""
}
proc bool_tog {toggle} {
  if [lfind [get_cookie BOOL_TOGS] $toggle] { return 1 }
  return 0
}
proc string_tog {toggle} {
  if [lfind [get_cookie STRING_TOGS] $toggle] { return 1 }
  return 0
}
proc user_tog {toggle} {
  if [lfind [get_cookie USER_TOGS] $toggle] { return 1 }
  return 0
}
proc get_env {key {default ""}} {
  set out [get_cookie ENV($key) $default]
  return $out
}
proc fixchan {chan} {
  set ret_chan ""
  foreach c [channels] {
    if {[stl $c] == [stl $chan]} {
      set ret_chan $c
      break
    }
  }
  if {$ret_chan != ""} {
    return $ret_chan
  } {
    return $chan
  }
}
proc ops {chan} {
  set olist [nicks $chan @*]
  set blarf ""
  foreach o $olist {
    lappend blarf [string trimleft $o "@"]
  }
  return $blarf
}
proc nops {chan} {
  set out ""
  foreach n [nicks $chan] {
    if ![string match "@*" $n] {
      lappend out [string trimleft $n "@+"]
    }
  }
  return $out
}
proc voice {chan} {
  set vlist [nicks $chan +*]
  set blarf ""
  foreach v $vlist {
    lappend blarf [string trimleft $v "+"]
  }
  return $blarf
}
proc novoice {chan} {
  set out ""
  foreach n [nicks $chan] {
    if ![string match "\+*" $n] {
      lappend out [string trimleft $n "@+"]
    }
  }
  return $out
}
proc nnicks {chan} {
  set list [nicks $chan]
  set blarf ""
  foreach l $list {
    lappend blarf [string trimleft $l "@+"]
  }
  catch {unset l list}
  return $blarf
}
proc usercount {channel} {
  set ops [llength [nicks $channel @*]]
  set vcs [llength [nicks $channel +*]]
  set ttl [llength [nicks $channel]]
  return "$ops $vcs $ttl"
}
proc randreplace {string char {igchars ""}} {
  set z ""
  foreach c [split $string ""] {
    set x [random 0 1]
    if {$x && [pos $igchars $c] == -1} {
      set y $char
    } {
      set y $c
    }
    set z $z$y
  }
  return $z
}
proc mask {mask type {screw ""}} {
  set h [lindex [split $mask "@"] 1]
  set nu [lindex [split $mask "@"] 0]
  set dt [split $h "."]
  if ![isip $h] {
    if {[llength $dt] > 2} {
      set d \*.[join [lrange $dt [expr [llength $dt]-2] end] "."]
    } {
      set d $h
    }
  } {
    set d [join [lrange $dt 0 2] "."].\*
  }
  set n [lindex [split $nu "!"] 0]
  set u [lindex [split $nu "!"] 1]
  set u2 [string range $u 1 end]
  switch -- [stl $type] {
    "0" { set out "*!$u@$h" }
    "1" { set out "*!*$u2@$h" }
    "2" { set out "*!*@$h" }
    "3" { set out "*!*$u2@$d" }
    "4" { set out "*!*@$d" }
    "5" { set out $mask }
    "6" { set out "$n!*$u2@$h" }
    "7" { set out "$n!*@$h" }
    "8" { set out "$n!*$u2@$d" }
    "9" { set out "$n!*@$d" }
    default { set out "$n!$u@$h" }
  }
  if ![string length $screw] {
    return $out
  } {
    set out [randreplace $out "?" "!@.*"]
  }
}
proc longip {ip} {
  if ![string match "*.*.*.*" $ip] {
    return [shortip $ip]
  }
  if ![isip $ip] {
    return ""
  }
  global tcl_precision
  set tcl_precision 17
  regexp {([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+)} $ip ipb a b c d
  set aa [expr double($d)+double($c)*pow(256,1)+double($b)*pow(256,2)+double($a)*pow(256,3)]
  set final [format "%10.0f" $aa]
  unset tcl_precision
  return $final
}
proc shortip {int} {
  if [string match "*.*.*.*" $int] {
    return [longip $int]
  }
  if ![isint $int] {
    return ""
  }
  global tcl_precision
  set tcl_precision 17
  if ![regexp {\.} $int] {
    set int ${int}.0
  }
  set float [expr double($int)]
  set a [expr int($float/pow(256,3))]
  set tmp [expr $float-($a*pow(256,3))]
  set b [expr int($tmp/pow(256,2))]
  set tmp [expr $tmp-($b*pow(256,2))]
  set c [expr int($tmp/pow(256,1))]
  set tmp [expr $tmp-($c*pow(256,1))]
  set d [expr int($tmp/pow(256,0))]
  unset tcl_precision
  return $a.$b.$c.$d
}
proc isip {addr} {
  set isip [regexp {([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+)} $addr]
  return $isip
}

proc ischan {chan} {
  set c [string index $chan 0]
  if {$c == "#" || $c == "&"} {
    return 1
  } {
    return 0
  }
}
proc onchan {nick chan} {
  set ret 0
  set nick [stl $nick]
  foreach n [stl [nicks $chan]] {
    if {$nick == [string trimleft $n "@+"]} {
      set ret 1
      break
    }
  }
  return $ret
}
proc com_chans {user} {
  set ret_list ""
  foreach c [channels] {
    if [onchan $user $c] { lappend ret_list $c }
  }
  return $ret_list
}
proc get_chan_key {mode} {
  set m [lindex $mode 0]
  if {[pos $m "k"] == -1} { return "" }
  if {[pos $m "l"] == -1} { return [lindex $mode 1] }
  if {[pos $m "l"] > [pos $m "k"]} { return [lindex $mode 1] } { return [lindex $mode 2] }
}
proc get_chan_lim {mode} {
  set m [lindex $mode 0]
  if {[pos $m "l"] == -1} { return "" }
  if {[pos $m "k"] == -1} { return [lindex $mode 1] }
  if {[pos $m "k"] > [pos $m "l"]} { return [lindex $mode 1] } { return [lindex $mode 2] }
}
proc c {} { return  }
proc b {} { return  }
proc r {} { return  }
proc u {} { return  }
proc o {} { return  }
proc uptime {} { return [expr [clock clicks]/1000] }
proc scriptUptime {} {
  global sin_zero
  if ![info exists sin_zero(load_start)] { set sin_zero(load_start) [clock clicks] }
  set dif [expr ([clock clicks]-$sin_zero(load_start))/1000.0]
  return $dif
}
proc duration {time {week_type "wk"} {day_type "day"} {hour_type "hr"} {min_type "min"} {sec_type "sec"} {plural "s"} {seperator1 " "} {seperator2 " "}} {
  set week ""; set day ""; set hour ""; set min ""; set secs ""
  set time [expr abs($time)]
  if {$time == 0} { return "0$seperator1$sec_type$plural" }
  if {$time >= 604800} {
    set week [expr int($time/604800)]
    set time [expr $time-(604800*$week)]
    if {$week == 1} { set week $week$seperator1$week_type } { set week $week$seperator1$week_type$plural }
  }
  if {$time >= 86400} {
    set day [expr int($time/86400)]
    set time [expr $time-(86400*$day)]
    if {$day == 1} { set day $day$seperator1$day_type } { set day $day$seperator1$day_type$plural }
  }
  if {$time >= 3600} {
    set hour [expr int($time/3600)]
    set time [expr $time-(3600*$hour)]
    if {$hour == 1} { set hour $hour$seperator1$hour_type } { set hour $hour$seperator1$hour_type$plural }
  }
  if {$time >= 60} {
    set min [expr int($time/60)]
    set time [expr $time-(60*$min)]
    if {$min == 1} { set min $min$seperator1$min_type } { set min $min$seperator1$min_type$plural }
  }
  if {$time != 0} { set secs $time }
  if {$secs == 1} { set secs $secs$seperator1$sec_type } elseif {$time != 0} { set secs $secs$seperator1$sec_type$plural }
  if {[string length $week] && [string length [join $day$hour$min$secs]]} { set week $week$seperator2 }
  if {[string length $day] && [string length [join $hour$min$secs]]} { set day $day$seperator2 }
  if {[string length $hour] && [string length [join $min$secs]]} { set hour $hour$seperator2 }
  if {[string length $min] && [string length [join $secs]]} { set min $min$seperator2 }
  set conv "$week$day$hour$min$secs"
  unset week day hour min secs
  return $conv
}
proc leadzero {numeric {numb 1}} {
  return [right $numeric $numb "0"]
}
proc leadspace {string {char_spec ""}} {
  if ![string length $char_spec] { return " $string" }
  set out " $string"
  for {set x 0} {$x < [string length $char_spec]} {incr x} {
    if ![string compare [string index $string 0] [string index $char_spec $x]] {
      set out $string
      break
    }
  }
  return $out
}
proc dur {time} {
  set time [expr abs($time)]
  if {$time >= 3600} {
    set hour [expr int($time/3600)]
    set time [expr $time-(3600*$hour)]
    set hour [leadzero $hour 2]
  } {
    set hour 00
  }
  if {$time >= 60} {
    set min [expr int($time/60)]
    set time [expr $time-(60*$min)]
    set min [leadzero $min 2]
  } {
    set min 00
  }
  if {$time > 0} {
    set secs [leadzero $time 2]
  } {
    set secs 00
  }
  return "$hour $min $secs"
}
proc online {} {
  global USER_INFO
  if ![connected] {
    return 0
  }
  if ![info exists USER_INFO(online)] {
    set USER_INFO(online) [clock seconds]
  }
  return [expr [clock seconds]-$USER_INFO(online)]
}
proc signontime {} {
  global USER_INFO
  if ![connected] { return 0 }
  if ![info exists USER_INFO(online)] {
    set USER_INFO(online) [clock seconds]
  }
  return $USER_INFO(online)
}
proc lag {} {
  global USER_INFO
  if ![info exists USER_INFO(lagmeter)] {
    set USER_INFO(lagmeter) 0.000
  }
  return $USER_INFO(lagmeter)
}
proc atime {{am "am"} {pm "pm"} {secs 0} {sep ":"}} {
  set h [clock format [clock seconds] -format %I]
  set m [clock format [clock seconds] -format %M]
  set p [clock format [clock seconds] -format %p]
  if {$p == "PM"} {
    set p $pm
  } {
    set p $am
  }
  if $secs {
    set s [clock format [clock seconds] -format %S]
    return ${h}${sep}${m}${sep}${s}$p
  } {
    return ${h}${sep}${m}$p
  }
}
proc date {{date ""} {formats ""}} {
  if {$formats == ""} {
    if {$date == ""} {
      return [clock format [clock seconds]]
    } {
      return [clock format $date]
    }
  } {
    if {$date == ""} {
      return [clock format [clock seconds] -format $formats]
    } {
      return [clock format $date -format $formats]
    }
  }
}
proc lfind {list val} {
  set ret 0
  foreach l $list {
    if {[stl $l] == [stl $val]} { set ret 1; break }
  }
  return $ret
}
proc lpos {list val} {
  return [lsearch -exact [stl $list] [stl $val]]
}
proc chr {numb} {
  if [isint $numb] {
    return [format %c $numb]
  } {
    return ""
  }
}
proc asc {char} {
  if {$char == ""} {
    return ""
  }
  scan $char "%c" asc
  return $asc
}
proc stl {string} {
  return [string tolower $string]
}
proc stu {string} {
  return [string toupper $string]
}
proc pos {string char} {
  return [string first $char $string]
}
proc isin {string char} {
  if {[string first $char $string] >= 0} { return 1 } { return 0 }
}
proc replace {string val1 val2} {
  regsub -all -- {\\} $val1 {\\\\} val1
  regsub -all -- {\[} $val1 {\[} val1
  regsub -all -- {\]} $val1 {\]} val1
  regsub -all -- {\(} $val1 {\(} val1
  regsub -all -- {\)} $val1 {\)} val1
  regsub -all -- {\^} $val1 \\\^ val1
  regsub -all -- {\+} $val1 {\+} val1
  regsub -all -- {\*} $val1 {\*} val1
  regsub -all -- {\?} $val1 {\?} val1
  regsub -all -- {\.} $val1 {\.} val1
  regsub -all -- {\|} $val1 {\|} val1
  regsub -all -- "&" $val1 {\\\&} val1
  regsub -all -- {\\} $val2 {\\\\} val2
  regsub -all -- {\?} $val2 {\?} val2
  regsub -all -- "&" $val2 {\\\&} val2
  regsub -all -- {\^} $string \^ string
  regsub -all -- $val1 $string $val2 string
  return $string
}
proc code_strip {string} {
  set string [c_strip $string]
  set string [replace $string [b] ""]
  set string [replace $string [r] ""]
  set string [replace $string [o] ""]
  set string [replace $string [u] ""]
}
proc c_strip {string} {
  if {[pos $string [c]] != -1} {
    set reps "[c]"
    set 2col 0
    set colcnt 0
    set pos [pos $string [c]]
    for {set x [expr $pos+1]} {$x <= [expr $pos+5]} {incr x} {
      set s [string index $string $x]
      if [isint $s] { incr colcnt }
      if {$s == "," && [isint [string index $string [expr $x+1]]]} { set colcnt 0; set 2col 0 }
      if {(![isint $s] || $2col) && $s != ","} { break }
      if {$colcnt >= 2} { set 2col 1 }
      set reps ${reps}${s}
    }
    regsub -- $reps $string "" final
    if {[pos $final [c]] != -1} {
      set final [c_strip $final]
    } {
      return $final
    }
  } {
    return $string
  }
}
proc highlight {string chars h_col def_col} {
  foreach c [split $chars ""] {
    set string [replace $string $c "[c]$h_col$c[c]$def_col"]
  }
  return $string
}
proc left {text spaces {chartype " "} {chop 0}} {
  set ntmp [code_strip $text]
  set ntmp [strpchrs $ntmp 0 31]
  if {[string length $ntmp] >= $spaces && !$chop} {
    return $text
  } elseif {[string length $ntmp] >= $spaces} {
    return [string range $text 0 [expr $spaces-1]]
  }
  set x [expr $spaces-[string length $ntmp]]
  if {$x > 0} {
    set spaces [repeat $chartype $x]
  } {
    set spaces ""
  }
  set text $text$spaces
  return $text
}
proc right {text spaces {chartype " "}} {
  set ntmp [code_strip $text]
  set ntmp [strpchrs $ntmp 0 31]
  if {[string length $ntmp] >= $spaces} { return $text }
  set x [expr $spaces-[string length $ntmp]]
  if {$x > 0} {
    set spaces [repeat $chartype $x]
  } {
    set spaces ""
  }
  set text $spaces$text
  return $text
}
proc center {text spaces {chartype " "}} {
  set ntmp [code_strip $text]
  set ntmp [strpchrs $ntmp 0 31]
  if {[string length $ntmp] >= $spaces} { return $text }
  set x [expr $spaces-[string length $ntmp]]
  set spcright [expr $x/2]
  set spcleft [expr $x-$spcright]
  if {$spcright > 0} {
    set rspaces [repeat $chartype $spcright]
  } {
    set rspaces ""
  }
  if {$spcleft > 0} {
    set lspaces [repeat $chartype $spcleft]
  } {
    set lspaces ""
  }
  set text $lspaces$text$rspaces
  return $text  
}
proc strpchrs {string asc1 asc2} {
  for {set x $asc1} {$x <= $asc2} {incr x} {
    set string [replace $string [chr $x] ""]
  }
  return $string
}
proc shade {string col1 col2 col3} {
  if {[string length $string] == 1} {
    return "[c]$col1$string"
  }
  if {[string length $string] == 2} {
    return "[c]$col1$string"
  }
  if {[string length $string] == 3} {
    set chr(1) [string index $string 0]; set chr(2) [string index $string 1]; set chr(3) [string index $string 2]
    return "[c]$col1$chr(1)[c]$col2$chr(2)[c]$col1$chr(3)"
  }
  if {[string length $string] == 4} {
    set chr(1) [string index $string 0]; set chr(2) [string index $string 1]; set chr(3) [string index $string 2]; set chr(4) [string index $string 3]
    return "[c]$col1$chr(1)[c]$col2$chr(2)$chr(3)[c]$col1$chr(4)"
  }
  if {[string length $string] == 5} {
    set chr(1) [string index $string 0]
    set chr(2) [string index $string 1]
    set chr(3) [string index $string 2]
    set chr(4) [string index $string 3]
    set chr(5) [string index $string 4]
    return "[c]$col1$chr(1)[c]$col2$chr(2)[c]$col3$chr(3)[c]$col2$chr(4)[c]$col1$chr(5)"
  }
  if {[string length $string] > 5} {
    set max [string length $string]
    for {set x 0} {$x < $max} {incr x} {
      set chr([expr $x+1]) [string index $string $x]
    }
    set mid ""
    set end [expr $max-3]
    for {set x 4} {$x <= $end} {incr x} {
      set mid $mid$chr($x)
    }
    set string "[c]$col1$chr(1)[c]$col2$chr(2)[c]$col3$chr(3)$mid[c]$col3$chr([expr $max-2])[c]$col2$chr([expr $max-1])[c]$col1$chr($max)"
    return $string
  }
}
proc pad {string l {r ""}} {
  if ![string length $string] { return "" }
  if ![string length $r] { set r $l }
  return "${l}${string}${r}"
}
proc isalphanumeric {chr} {
  if ![string length $chr] { return 0 }
  if {[string trim [stl $chr] "abcdefghijklmnopqrstuvwxyz1234567890"] == ""} {
    return 1
  } {
    return 0
  }
}
proc ischar {chr} {
  if ![string length $chr] { return 0 }
  if {[string trim [stl $chr] "abcdefghijklmnopqrstuvwxyz"] == ""} {
    return 1
  } {
    return 0
  }
}
proc isint {num} {
  if [catch {expr $num-0} err] {
    return 0
  }
  if ![string length $num] { return 0 }
  if ![string length [string trim $num 1234567890]] {
    return 1
  } {
    return 0
  }
}
proc hugeint {int} {
  if ![string length $int] { return 0 }
  if [string length [string trim $int 1234567890]] { return 0 }
  if [catch {expr $int-0} err] {
    return 1
  } {
    return 0
  }
}
proc sort {string} {
  return [join [lsort -ascii [split $string ""]] ""]
}
proc percent {number total symb} {
  if {[isint $number] && [isint $total]} {
    if {$total == 0} {
      return "0$symb"
    }
    return [format %.2f [expr ($number/$total.0)*100]]$symb
  }
  return 0
}

####- End(Number Related Procedures) -####

proc country_parse {host} {
  global extra_info
  set cntry [lindex [split $host "."] end]
  if ![info exists extra_info(countries)] { return $cntry }
  foreach a $extra_info(countries) {
    set ct [lindex $a 0]
    if ![strcmpi $cntry $ct] { set cntry [join [lrange $a 1 end]]; break }
  }
  return $cntry
}

# DCC Error Parser - Thanks to David G. for the list of RAW Numeric Socket Errors
proc dcc_parse {error} {
  if ![strcmpi $error "-1"] { return "Transfer Aborted." }
  if ![isint $error] { return $error }
  switch -- $error {
    "10047" { set out "Addresses in the specified family cannot be used with this socket." }
    "10048" { set out "The specified address is already in use." }
    "10049" { set out "The specified address is not available from the local machine." }
    "10051" { set out "The network cannot be reached from this host at this time." }
    "10055" { set out "No buffer space is available.  The socket cannot be connected." }
    "10060" { set out "Attempt to connect timed out without establishing a connection." }
    "10061" { set out "The attempt to connect was forcefully rejected." }
    "10065" { set out "No route to host" }
    default { set out $error }
  }
  return $out
}

####- Parse/set style info -####

#- Load in style files for parsing
proc load_style {style_file} {
  if ![file exists $style_file] {
    return 0
  }
  set x [open $style_file r]
  while {![eof $x]} {
    set infofile [read $x]
    foreach info [split $infofile "\n"] {
      set pos [pos $info "="]
      if {$pos != -1} {
        set name [join [string range $info 0 [expr $pos-1]]]
        set value [string range $info [expr $pos+1] end]
        if {$name != "" && $value != ""} {
          set_cookie ENV($name) $value
        }
      }
    }
  }
  catch {close $x}
  return 1
}
proc away {} {
  global AWAY_INFO
  if ![info exists AWAY_INFO(away)] { return 0 }
  return $AWAY_INFO(away)
}
proc modmode {mode mode_change} {
  set add_mode 0; set sub_mode 0
  set mode_change [stl $mode_change]
  set mode_tmp [stl $mode]
  for {set x 0} {$x < [string length $mode_change]} {incr x} {
    set s [string index $mode_change $x]
    if {$add_mode && $s != "+" && $s != "-"} { set mode_tmp $mode_tmp$s }
    if {$sub_mode && $s != "-" && $s != "+"} { set mode_tmp [replace $mode_tmp $s ""] }
    if {$s == "-"} { set sub_mode 1; set add_mode 0 }
    if {$s == "+"} { set add_mode 1; set sub_mode 0 }
  }
  set mode_tmp [sort $mode_tmp]
}
set loadVers [get_cookie VERSION]
set start_type ""
if ![string length $loadVers] {
  set start_type "firstload"
}
if {[string length $loadVers] && [string compare $loadVers $sin_zero(truevers)] != 0} {
  set start_type "oldvers"
  rem_tog "Ident" "string"
  rem_tog "Identd" "bool"
  rem_tog "Version" "string"
  rem_tog "AltJoin" "bool"
  rem_tog "AltPart" "bool"
  rem_tog "AltQuit" "bool"
  rem_tog "Names" "bool"
  rem_tog "Away_Log" "string"
  rem_tog "Page_Log" "string"
  rem_tog "Personal_Log" "string"
  rem_tog "Config_File" "string"
  rem_tog "Kick_Msg1" "string"
  rem_tog "Kick_Msg2" "string"
  rem_tog "Kick_Msg3" "string"
  rem_tog "Kick_Msg4" "string"
}
switch -- $start_type {
  "firstload" {
    echo "[c]00:[c]15\[[c]14: [c]00S[c]15in[c]14([c]00zero[c]14)[c]15 has been loaded for the first time..." status
    echo "      [c]15for help with Sin(zero) commands use /help" status
    echo "      [c]15to config [c]15Sin[c]14([c]00zero[c]14)[c]15 be sure to use /set [c]14:[c]15\][c]00:" status
    ascii_logo status ""
    set_cookie VERSION $sin_zero(truevers)
    if [info exists sin_zero(truevers)] { set Aaboutvers $sin_zero(truevers) } { set Aaboutvers [get_cookie Version "NULL"] }
    msgbox "About Sin(zero) IRC script" "Sin(zero) (v$Aaboutvers) credits:\n \nAuthor:\n... Ian D. E. (phAge)\n \nFalcon DLL Creator:\n... David Gravereaux (thanks for the library :)\n \n   Script Testers:\n   ... Puppet\n   ... badtoyz\n   ... Flecko\n   ... Illusion\n   ... Wintermute\n   ... ryan\n   ... Josh"
    unset Aaboutvers
  }
  "oldvers" {
    echo "[c]00:[c]15\[[c]14:[c]15 Old version of [c]00S[c]15in[c]14([c]00zero[c]14)[c]15 detected..." status
    echo "     [c]14Some toggles and/or styles may be invalid. [c]14:[c]15\][c]00:" status
    set_cookie VERSION $sin_zero(truevers)
    if [info exists sin_zero(truevers)] { set Aaboutvers $sin_zero(truevers) } { set Aaboutvers [get_cookie Version "NULL"] }
    msgbox "About Sin(zero) IRC script" "Sin(zero) (v$Aaboutvers) credits:\n \nAuthor:\n... Ian D. E. (phAge)\n \nFalcon DLL Creator:\n... David Gravereaux (thanks for the library :)\n \n   Script Testers:\n   ... Puppet\n   ... badtoyz\n   ... Flecko\n   ... Illusion\n   ... Wintermute\n   ... ryan\n   ... Josh"
    unset Aaboutvers
  }
}
catch {unset start_type loadVers}
szaddhelp "+bind" "/+bind \[F\]<N> <script>" "Binds Function key N (F<N>) to perform <script> when it is pressed." "/bind" "-BIND,ALIAS"
szaddhelp "-bind" "/-bind \[F\]<N>" "Unbinds Function key N (F<N>)." "" "+BIND,ALIAS"
szaddhelp "//" "//<command> \[args\]" "Evaluates the command line and all parameters passed with it.  Ie: //echo \[my_nick\] would display your nickname." "/test" "TEST"
szaddhelp "/." "/.<command> \[args\]" "This command will allow <command> to be processed without output display.  This may not always work as some output is displayed after <command> is processed, such as /.ignore -t... (The initial ignore notice will not be displayed, but when the ignore is removed, the output will be shown)." "" ""
szaddhelp "aban" "/aban <handle> <mask> \[channel\]" "Auto-bans anyone with a nick!user@host that matches <mask> on join." "/adduser <handle> <mask> 5 \[channel\]" "ADDUSER"
szaddhelp "about" "/about" "Displays basic information about the script." "" ""
szaddhelp "actcp" "/actcp <ctcp_type> \[ctcp_args\]" "Performs a /ctcp of <ctcp_type> on all of the channels you are on" "" "CTCP"
szaddhelp "action" "/action <action>" "Perform an action in the currently active channel." "/me" "AME,ME"
szaddhelp "addons" "/addons" "Lists currently loaded addons.  To install an addon for Sin(zero) simply place that addon in the \"addons.sz\" directory." "" ""
szaddhelp "adduser" "/adduser <handle> <mask> <flags|numeric> \[channel\]" "Adds a user to the userlist for \[channel\].  If flags are specified, they must contain any combonation of the following: o) auto-op user on join; p) protect user; v) auto-voice user on join; k) auto-kick user on join; b) auto-ban user on join. If \[channel\] is not specified, user is added to userlist for all channels." "/aop,/avoice,/protect,/akick,/aban,/akb" "REMUSER,AOP,AVOICE,PROTECT,AKICK,ABAN,AKB"
szaddhelp "akb" "/akb <handle> <mask> \[channel\]" "Auto-kickbans anyone with a nick!user@host that matches <mask> on join." "/adduser <handle> <mask> 6 \[channel\]" "ADDUSER"
szaddhelp "akick" "/akick <handle> <mask> \[channel\]" "Auto-kicks anyone with a nick!user@host that matches <mask> on join." "/adduser <handle> <mask> 4 \[channel\]" "ADDUSER"
szaddhelp "alias" "/alias \[-c\] <name> <script>" "Creates a custom made alias which is then stored in the addons.sz directory in a file called aliases.sin so the custom made aliases will be permenant.  By default, \"; complete\" is appended to an alias to stop the processing of the alias after that script, if you do not wish for this to be appended, specify the -c flag." "" "BIND"
szaddhelp "ame" "/ame <action>" "Performs an action in all channels you are on." "" "ACTION,ME"
szaddhelp "amode" "/amode <mode>" "Sets a mode of <mode> for all channels you are on." "" "MODE"
szaddhelp "amsg" "/amsg <text>" "Sends a message of <text> to all channels you are on." "" "MSG,PRIVMSG"
szaddhelp "anot" "/anot <notice>" "Sends a notice of <notice> to all channels you are on." "" "NOTICE,NOT,N"
szaddhelp "aop" "/aop <handle> <mask> \[channel\]" "Auto-ops anyone with a nick!user@host that matches <mask> on join." "/adduser <handle> <mask> 2 \[channel\]" "ADDUSER"
szaddhelp "asound" "/asound <sound|ON|OFF>" "Plays <sound> on all channels you are on.  If <sound> equals \"off\" or \"on\", the Sound_System is turned off/on respectively." "" "SOUND,SOUND_SYSTEM"
szaddhelp "avoice" "/avoice <handle> <mask> \[channel\]" "Auto-voices anyone with a nick!user@host that matches <mask> on join." "/adduser <handle> <mask> 1 \[channel\]" "ADDUSER"
szaddhelp "away" "/away \[reason\]" "Flags you being away with a reason of \[reason\].  If \[reason\] is not specified, the toggle Default_Away_Message is used instead." "" "BACK,AWAY_SYSTEM"
szaddhelp "awaylog" "/awaylog \[erase\]" "Opens the away log with the program specified in Default_Text_Viewer.  If \[erase\] is specified, awaylog is deleted and recreated as a blank file." "" "PAGELOG"
szaddhelp "b" "/b \[-t<TIME_IN_SECONDS>\] \[channel\] <nick|mask> \[type\]" "Bans <nick|mask> from \[channel\].  If \[channel\] is not specified, the currently active channel is used.  If the -t flag is specified, <nick|mask> is banned for <TIME_IN_SECONDS> seconds.  If \[type\] is specified, a mask of \[type\] is applied to <nick|mask> (note: \[type\] must be an integer from 0 to 9)." "/ban" "BAN,KICKBAN"
szaddhelp "back" "/back \[reason\]" "Flags you no longer being away." "" "AWAY,AWAY_SYSTEM"
szaddhelp "ban" "/ban \[-screw\] \[-t<TIME_IN_SECONDS>\] \[channel\] <nick|mask> \[type\]" "Bans <nick|mask> from \[channel\].  If \[channel\] is not specified, the currently active channel is used.  If the -t flag is specified, <nick|mask> is banned for <TIME_IN_SECONDS> seconds.  If \[type\] is specified, a mask of \[type\] is applied to <nick|mask> (note: \[type\] must be an integer from 0 to 9)." "/b" "B,KICKBAN"
szaddhelp "banlist" "/banlist \[channel\] \[index\]" "Displays a channel's banlist in the channel.  If you are not currently in \[channel\], banlist is displayed in status.  If \[index\] is specified, more details are shown regarding the ban referred to by \[index\]." "/bans" "BANS"
szaddhelp "bans" "/bans \[channel\] \[index\]" "Displays a channel's banlist in the channel.  If you are not currently in \[channel\], banlist is displayed in status.  If \[index\] is specified, more details are shown regarding the ban referred to by \[index\]." "/banlist" "BANLIST"
szaddhelp "bind" "/bind \[F\]<N> <script>" "Binds Function key N (F<N>) to perform <script> when it is pressed.  If a previously bound key is bound again, changes will not take affect until the script is reloaded" "/+bind" "+BIND,-BIND,ALIAS"
szaddhelp "binds" "/binds" "Lists the currently bound function keys and the scripts they are bound to." "" "+BIND,-BIND"
szaddhelp "bk" "/bk \[-t<TIME_IN_SECONDS>\] \[channel\] <nick|mask> \[type\] \[reason\]" "Bans <nick|mask> from \[channel\] using applying a mask type of \[type\] then kicks <nick|mask> from \[channel\].  If no channel is specified, the current channel is used.  If the -t flag is specified, <nick|mask> is banned for <TIME_IN_SECONDS> seconds." "/kickban,/kb" "KICKBAN,KB,KICK,BAN"
szaddhelp "block" "/block \[-r\] <mask>" "Prevents any processing of any event (raw or otherwise) from an origin that matches <mask>.  Block can also be used to block server responses (a mask of *!*@<servername> should do the trick).  If the -r flag is specified, <mask> is removed from the list of blocked masks." "" "IGNORE"
szaddhelp "cdop" "/cdop <channel> <nick1>\[ <nick2> .. <nickN>\]" "Deops (mode -o) the specified nick(s) in <channel>." "/mode <channel> -o <nick>" "COP"
szaddhelp "cdvc" "/cdvc <channel> <nick1>\[ <nick2> .. <nickN>\]" "Devoices (mode -v) the specified nick(s) in <channel>." "/mode <channel> -v <nick>" "CVC"
szaddhelp "chat" "/chat <nickname>\[,<nickname2>,..<nicknameN>\]" "Sends a DCC Chat request to <nickname1>\[,<nickname2>,..<nicknameN>\]." "/dcc chat" "SEND"
szaddhelp "clear" "/clear" "Clears the current buffer of all text." "" "CLEARALL"
szaddhelp "clearall" "/clearall" "Clears the text from all buffers." "" "CLEAR"
szaddhelp "clonescan" "/clonescan \[desination\]" "Performs a scan of users to determine which ones are clones" "/scan clone" "OPERSCAN,IALSCAN"
szaddhelp "ctcp" "/ctcp <destination> <type> \[args\]" "Performs a CTCP (client to client protocal) request of <type> on <destination>." "" "PAGE,PING,VER,CTCPR"
szaddhelp "ctcpr" "/ctcpr <target> <type> \[args\]" "Sends a CTCP Reply of <type> to <target>.  \[args\] is any additional text you wish to send with the reply." "" "CTCP"
szaddhelp "cycle" "/cycle \[channel1,channel2,..channelN\]" "Parts \[channel1,channel2,..channelN\] then rejoins those channels previously parted.  If no channels are specified, the current channel is used.  If the status window is the current window, /cycleserver is executed." "" "CYCLESERVER,JOIN,PART"
szaddhelp "cycleserver" "/cycleserver" "Disconnects then re-connects to the server you are currently connected to." "" "QUIT,SERVER"
szaddhelp "dcc" "/dcc \[ SEND <nick> <filename>| LIST \]" "Attempts a DCC Transfer" "" ""
szaddhelp "dns" "/dns \[^\]<hostname1>\[ \[^\]<hostname2> .. \[^\]<hostnameN>\] || /dns <nickname1>\[ <nickname2> .. <nicknameN>\]" "Peforms a lookup on the specified hostname(s) or nickname(s).  If an argument is prepended with ^, the rest of that argument is assumed to be a hostname, even if it doesn't match a *.* pattern (useful to perform a lookup of \"localhost\")." "/nslookup,/lookup" "NSLOOKUP,LOOKUP"
szaddhelp "dnsqueue" "/dnsqueue" "Displays a list of hostnames that XiRCON is currently resolving, or is attempting to resolve.  Notice that this command only displays those hostnames that were looked up via the /nslookup, /lookup, or /dns commands." "/nsqueue,/lookupqueue" "NSQUEUE,LOOKUPQUEUE"
szaddhelp "dop" "/dop <nick1>\[ <nick2> .. <nickN>\]" "Deops (mode -o) the specified nick(s) in the current channel." "/mode <channel> -o <nick>" "OP"
szaddhelp "dvc" "/dvc <nick1>\[ <nick2> .. <nickN>\]" "Devoices (mode -v) the specified nick(s) in the current channel." "/mode <channel> -v <nick>" "VC"
szaddhelp "echo" "/echo <text>" "Echos <text> to the current window buffer" "" ""
szaddhelp "exec" "/exec <filename> \[arg1 arg2 .. argN\]" "Executes <filename> with any other arguments specified.  /Exec utilizes the exec procedure and will only execute programs that exec is capable of." "" ""
szaddhelp "flood" "/flood" "Allows the user to customize the number of msgs in a given number of seconds for each of the three flood_types to be activated.  This gives complete control of the flood protection to the user." "" "FLOOD PROTECTION"
szaddhelp "flood protection" "" "To set up the Flood Protection, you need to do two things.\n[c]15    First:\n[c]15 \n[c]15    /set Flood_Prot on\n[c]15 \n[c]15    Secondly:\n[c]15 \n[c]15    /set Flood_Type <weak|mild|strong>\n[c]15 \n[c]15    Choosing the argument of \"weak\" allows the following before an ignore is placed on the user:\n[c]15 \n[c]15    5 Public Messages every 10 seconds   (Basically: 1 Public Message every 2 seconds).\n[c]15    5 Private Messages every 15 seconds  (Basically: 1 Private Message every 3 seconds).\n[c]15    5 CTCP Requests every 30 seconds     (Basically: 1 CTCP Request every 6 seconds).\n[c]15 \n[c]15    Choosing the argument of \"mild\" allows the following before an ignore is placed on the user:\n[c]15 \n[c]15    5 Public Messages every 20 seconds   (Basically: 1 Public Message every 4 seconds).\n[c]15    5 Private Messages every 20 seconds  (Basically: 1 Private Message every 4 seconds).\n[c]15    5 CTCP Requests every 45 seconds     (Basically: 1 CTCP Request every 9 seconds).\n[c]15 \n[c]15    Choosing the argument of \"strong\" allows the following before an ignore is placed on the user:\n[c]15 \n[c]15    5 Public Messages every 30 seconds   (Basically: 1 Public Message every 6 seconds).\n[c]15    6 Private Messages every 30 seconds  (Basically: 1 Private Message every 5 seconds).\n[c]15    5 CTCP Requests every 60 seconds     (Basically: 1 CTCP Request every 12 seconds).\n[c]15 \n" "" "FLOOD"
szaddhelp "help" "/help \[topic\]" "Displays help on \[topic\].  If \[topic\] is not specified, /help displays all topics available.  Wildcards may be used in \[topic\] to display all topics that match the pattern." "" ""
szaddhelp "hop" "/hop <partlist> <joinlist>" "Parts all channels specified in <partlist> (seperated by ','), and then joins all channels specified in <joinlist> (also seperated by ',')." "" "CYCLE"
szaddhelp "ialscan" "/ialscan \[destination\]" "Performs a scan of users to add their user and host names to the IAL" "/scan ial" "OPERSCAN,CLONESCAN"
szaddhelp "ignore" "/ignore \[-arupncdit<TIME_IN_SECONDS>\] <nick|mask> \[type\]" "Ignores specified events from <nick|mask>.  The events to ignore are specified by the -flags.  Each flag performs the following function: -a ignores ALL information <nick|mask> sends to you, -r removes the ignored <nick|mask>, -u ignores all public channel messages from <nick|mask>, -p ignores all private messages from <nick|mask>, -n ignores all notices from <nick|mask>, -c ignores all ctcps from <nick|mask>, -d ignores all DCCs from <nick|mask>, -i ignores all invites from <nick|mask>, -t ignores <nick|mask> for the specified amount of <TIME> in seconds." "" "IGNORES"
szaddhelp "ignores" "/ignores" "Lists all masks currently in the ignore lists and the events for which their ignored." "" "IGNORE"
szaddhelp "j" "/j <channel1>\[,<channel2>,..<channelN>\] \[<channelkey1>,<channelkey2>,..<channelkeyN>\]" "Joins the specified channel(s)." "/join" "JOIN,PART,CYCLE"
szaddhelp "join" "/join <channel1>\[,<channel2>,..<channelN>\] \[<channelkey1>,<channelkey2>,..<channelkeyN>\]" "Joins the specified channel(s)." "/j" "J,PART,CYCLE"
szaddhelp "k" "/k \[channel\] <nick|mask> \[reason\]" "Kicks <nick|mask> off of \[channel\] with a reason of \[reason\].  If no channel is specified, the current channel is used.  If no reason is specified, the toggle Default_Kick_Message is used." "/kick" "KICK,BAN"
szaddhelp "kb" "/kb \[-t<TIME_IN_SECONDS>\] \[channel\] <nick|mask> \[type\] \[reason\]" "Bans <nick|mask> from \[channel\] using applying a mask type of \[type\] then kicks <nick|mask> from \[channel\].  If no channel is specified, the current channel is used.  If the -t flag is specified, <nick|mask> is banned for <TIME_IN_SECONDS> seconds." "/kickban,/bk" "KICKBAN,BK,KICK,BAN"
szaddhelp "kick" "/kick \[channel\] <nick|mask> \[reason\]" "Kicks <nick|mask> off of \[channel\] with a reason of \[reason\].  If no channel is specified, the current channel is used.  If no reason is specified, the toggle Default_Kick_Message is used." "/k" "K,BAN"
szaddhelp "kickban" "/kickban \[-t<TIME_IN_SECONDS>\] \[channel\] <nick|mask> \[type\] \[reason\]" "Bans <nick|mask> from \[channel\] using applying a mask type of \[type\] then kicks <nick|mask> from \[channel\].  If no channel is specified, the current channel is used.  If the -t flag is specified, <nick|mask> is banned for <TIME_IN_SECONDS> seconds." "/kb,/bk" "KB,BK,KICK,BAN"
szaddhelp "kill" "/kill <nickname> <reason>" "Kills the connection between <nickname> and the IRC network.  This an IRCop command." "" "OPER"
szaddhelp "lookup" "/lookup \[^\]<hostname1>\[ \[^\]<hostname2> .. \[^\]<hostnameN>\] || /lookup <nickname1>\[ <nickname2> .. <nicknameN>\]" "Peforms a lookup on the specified hostname(s) or nickname(s).  If an argument is prepended with ^, the rest of that argument is assumed to be a hostname, even if it doesn't match a *.* pattern (useful to perform a lookup of \"localhost\")." "/nslookup,/dns" "NSLOOKUP,DNS"
szaddhelp "lookupqueue" "/lookupqueue" "Displays a list of hostnames that XiRCON is currently resolving, or is attempting to resolve.  Notice that this command only displays those hostnames that were looked up via the /nslookup, /lookup, or /dns commands." "/nsqueue,/dnsqueue" "NSQUEUE,DNSQUEUE"
szaddhelp "mass" "/mass <command> \[channel\]" "Performs the specified command on all users in \[channel\].  <command> may be specified as either op, deop, voice, devoice, or kick" "" "MASSOP,MASSDOP,MASSVC,MASSDVC,MASSKICK"
szaddhelp "massdop" "/massdop \[channel\]" "Deops all operators, except for yourself, in \[channel\]." "/mass dop" "MASS,MASSOP"
szaddhelp "massdvc" "/massdvc \[channel\]" "Devoices all voiced users, except for yourself, in \[channel\]." "/mass dvc" "MASS,MASSVC"
szaddhelp "massop" "/massop \[channel\]" "Ops all non-operators in \[channel\]." "/mass op" "MASS,MASSDOP"
szaddhelp "massvc" "/massvc \[channel\]" "Voices all non-voiced users in \[channel\]." "/mass vc" "MASS,MASSDVC"
szaddhelp "masskick" "/masskick \[channel\]" "Kicks all users, except for yourself, out of \[channel\]." "/mass kick" "MASS"
szaddhelp "me" "/me <action>" "Perform an action in the currently active channel." "/action" "ACTION,AME"
szaddhelp "mode" "/mode \[channel|nick\] <mode>" "Sets <mode> in \[channel\] or on \[nick\].  If neither nickname or channel is specified, <mode> is set on the current channel or on yourself." "" "AMODE"
szaddhelp "msg" "/msg <destination> <message>" "Sends a PRIVMSG of <message> to <destination>.  If <desination> is prefixed with a \"=\" and you currently have a DCC chat session open with <destination> then <message> is sent as a DCC chat message." "/privmsg" "PRIVMSG"
szaddhelp "n" "/n <destination> <notice>" "Sends a NOTICE of <notice> to <destination>." "/not,/notice" "NOT,NOTICE"
szaddhelp "names" "/names \[destination\]" "Returns the nicknames of all users in \[destination\].  If \[destination\] is not specified, names defaults to the currently active channel.  If the currently active window is the status window, \[destination\] is set as the server you are currently connected to." "" "WHO"
szaddhelp "newserver" "/newserver \[servername \[port\]\]" "Creates another status window linked to \[servername\].  \[servername\] may also be an index number from the serverlist.  If \[servername\] is omitted, the server list is displayed." "" "SERV"
szaddhelp "not" "/not <destination> <notice>" "Sends a NOTICE of <notice> to <destination>." "/n,/notice" "N,NOTICE"
szaddhelp "notice" "/notice <destination> <notice>" "Sends a NOTICE of <notice> to <destination>." "/n,/not" "N,NOT"
szaddhelp "nslookup" "/nslookup \[^\]<hostname1>\[ \[^\]<hostname2> .. \[^\]<hostnameN>\] || /nslookup <nickname1>\[ <nickname2> .. <nicknameN>\]" "Peforms a lookup on the specified hostname(s) or nickname(s).  If an argument is prepended with ^, the rest of that argument is assumed to be a hostname, even if it doesn't match a *.* pattern (useful to perform a lookup of \"localhost\")." "/dns,/lookup" "DNS,LOOKUP"
szaddhelp "nsqueue" "/nsqueue" "Displays a list of hostnames that XiRCON is currently resolving, or is attempting to resolve.  Notice that this command only displays those hostnames that were looked up via the /nslookup, /lookup, or /dns commands." "/dnsqueue,/lookupqueue" "DNSQUEUE,LOOKUPQUEUE"
szaddhelp "op" "/op <nick1>\[ <nick2> .. <nickN>\]" "Ops (mode +o) the specified nick(s) in the current channel." "/mode <channel> +o <nick>" "DOP"
szaddhelp "cop" "/cop <channel> <nick1>\[ <nick2> .. <nickN>\]" "Ops (mode +o) the specified nick(s) in <channel>." "/mode <channel> +o <nick>" "CDOP"
szaddhelp "oper" "/oper <username> <password>" "Basic IRC command to give yourself IRCop Status (usermode +o)." "" ""
szaddhelp "operscan" "/operscan \[destination\]" "Performs a scan of users to determine which ones are IRCops" "/scan oper" "CLONESCAN,IALSCAN"
szaddhelp "p" "/p \[destination\]" "Sends a CTCP PING request to \[destination\].  If \[destination\] is not specified, then the active query, channel, or chat is used as the target of the command." "/ping,/ctcp <destination> PING" "PING,CTCP"
szaddhelp "page" "/page \[destination\] \[reason\]" "Sends a CTCP PAGE request to \[destination\].  If \[destination\] is not specified then the active query, channel, or chat is used as the target of the command.  The CTCP PAGE request is generally script oriented and does not always produce a result." "/ctcp <destination> PAGE" "CTCP"
szaddhelp "pagelog" "/pagelog \[erase\]" "Opens the pager log with the program specified in Default_Text_Viewer.  If \[erase\] is specified, pagelog is deleted and recreated as a blank file." "" "AWAYLOG"
szaddhelp "part" "/part \[channel1,channel2,..channelN\]" "Parts the specified channels.  If no channels are specified, the currently active channel will become the target of the command." "" "JOIN"
szaddhelp "partall" "/partall" "Parts all channels you are currently in." "/part <chan1>,<chan2>.." "PART"
szaddhelp "ping" "/ping \[destination\]" "Sends a CTCP PING request to \[destination\].  If \[destination\] is not specified, then the active query, channel, or chat is used as the target of the command." "/p,/ctcp <destination> PING" "P,CTCP"
szaddhelp "privmsg" "/privmsg <destination> <message>" "Sends a PRIVMSG of <message> to <destination>." "/msg" "MSG"
szaddhelp "protect" "/protect <handle> <mask> \[channel\]" "Protects anyone with a nick!user@host that matches <mask> on \[channel\] from deops, kicks, and bans." "/adduser <handle> <mask> 3 \[channel\]" "ADDUSER"
szaddhelp "quit" "/quit \[reason\]" "Disconnects you from the server to which you are currently connected.  If \[reason\] is not specified and the filename sin0.quit exists, a random line from that file is chosen as the quit message (%s is substituted with the current sin(zero) version); otherwise, the default quit message defined in your Style File is used." "" "SERVER"
szaddhelp "quote" "/quote <command> \[args\]" "Sends <command> directly to the server without being processed by either XiRCON or Sin(zero)." "/raw" "RAW"
szaddhelp "randnick" "/randnick" "Changes your nickname to a string of 10 random characters." "" ""
szaddhelp "raw" "/raw <command> \[args\]" "Sends <command> directly to the server without being processed by either XiRCON or Sin(zero)." "/quote" "QUOTE"
szaddhelp "rdisp" "/rdisp \[channel\] \[lines\]" "Redisplays the last \[lines\] lines from \[channel\].  If \[channel\] is omitted, the current channel is used, and if \[lines\] is omitted, rdisp displays the last fifty lines of text.  Notice: your text is not included in the rdisp spool." "" "SAID,TSEARCH"
szaddhelp "remuser" "/remuser <handle>" "Removes <handle> from the userlist." "" "ADDUSER"
szaddhelp "rnick" "/rnick <nickname> \[times\]" "Attempts to regain <nickname> if it is in use on an IRC server.  If \[times\] is specified, rnick will only make \[times\] attempt(s).  Each attempt is set on a 60 second delay.  If \[times\] is not specified, rnick will try indefinately until the nickname is attained." "" ""
szaddhelp "s" "/s <sound>" "Plays <sound> in the currently active channel or query." "/sound" "SOUND"
szaddhelp "said" "/said  \[channel\] <nick>" "Displays all text <nick> has privmsg'd to \[channel\].  If \[channel\] is omitted, the current channel is used." "" "RDISP,TSEARCH"
szaddhelp "say" "/say <text>" "Sends <text> to the currently active channel, query, or dcc chat" "" "ECHO,PRIVMSG,MSG"
szaddhelp "sb" "/sb \[-t<seconds>\] \[channel\] <nick> \[mask_type\]" "Performs a screw ban on <nick> in \[channel\]" "/ban -screw,/screwban" "SCREWBAN,BAN"
szaddhelp "scan" "/scan <oper|clone|ial> \[destination\]" "Performs a scan of all users to determine which are opers, which are clones, or to gather their usernames and hostnames for the IAL." "/ialscan,/clonescan,/operscan" "IALSCAN,CLONESCAN,OPERSCAN"
szaddhelp "screwban" "/screwban \[-t<seconds>\] \[channel\] <nick> \[mask_type\]" "Performs a screw ban on <nick> in \[channel\]" "/ban -screw,/sb" "SB,BAN"
szaddhelp "send" "/send <nickname1>\[,<nickname2>,..<nicknameN>\] <filename>" "Sends <filename> to the specified recipients using DCC SEND protocal." "/dcc send" "CHAT"
szaddhelp "serv" "/serv <ADD|REM|LIST> \[server\] \[port\]" "Allows to add or remove servers from the serverlist or list all servers currently in the serverlist" "" "SERVLIST"
szaddhelp "server" "/server \[servername \[port\]\]" "Connects you to the specified IRC \[servername\].  \[servername\] may also be an index from the serverlist.  If \[servername\] is omitted, the server list is displayed." "" "QUIT,CYCLESERVER,SERV"
szaddhelp "servlist" "/servlist" "Lists all servers currently in the serverlist" "/serv LIST" "SERV"
szaddhelp "set" "/set <togglename> \[value\]" "Sets <togglename> with the specified value.  If no value is specified, the current setting for <togglename> is displayed" "/tog" "TOG"
szaddhelp "sinquote" "/sinquote \[index\]" "Displays a quote from the \$sin_zero(quotes) variable.  If index is specified, the selected quote will be displayed.  If index is not specified, an arbitrary quote will be displayed." "" ""
szaddhelp "sound" "/sound <sound>" "Plays <sound> in the currently active channel or query." "/s" "S,SPLAY"
szaddhelp "splay" "/splay <sound>" "Plays <sound> locally only.  No other users will see or hear this sound being played." "" "SOUND"
szaddhelp "style" "/style <sin(zero) style file>" "Updates the text styles of Sin(zero) specified in <style file>" "" ""
szaddhelp "sv" "/sv" "Displays your current version information on Sin(zero) as a plain text PRIVMSG." "" ""
szaddhelp "test" "/test <statment> \[args\]" "Executes <statement> as if it were a TCL command and returns the results" "//" "//"
szaddhelp "timer" "/timer\[N\] <repititions> <delay_in_seconds> <command_to_repeat>" "Repeats <command_to_repeat> <repititions> times with a delay of <delay_in_seconds> seconds.  If <repititions> is set to 0, the timer will repeat indefinately or until you type /timer\[N\] off.  If <repititions> is specified as \"off\" then timerN is turned off.  If \[N\] is specified and no other parameters are sent to the command, the status of timerN is displayed." "" ""
szaddhelp "tog" "/tog <togglename> \[value\]" "Sets <togglename> with the specified value.  If no value is specified, the current setting for <togglename> is displayed" "/set" "SET"
szaddhelp "top" "/top \[channel\]" "Changes the topic of \[channel\] by use of the built in XiRCON dialog window (prompt).  If \[channel\] is not specified, the currently active channel is assumed." "" ""
szaddhelp "tsearch" "/tsearch \[channel\] <text>" "Searches \[channel\] text for <text>.  If <text> is found, the entire line is buffered to the TSearch Window.  If \[channel\] is omitted, the currently active channel is assumed." "" "SAID,RDISP"
szaddhelp "umode" "/umode <mode>" "Sets <mode> for your usermode." "/mode <nick> <mode>" "MODE"
szaddhelp "um" "/um <mode>" "Sets <mode> for your usermode." "/mode <nick> <mode>" "MODE"
szaddhelp "unset" "/unset <toggle1> \[<toggle2> .. <toggleN>\]" "Unsets the specified togglenames by replacing their values with \\001none\\001" "/untog" "UNTOG,SET"
szaddhelp "untog" "/untog <toggle1> \[<toggle2> .. <toggleN>\]" "Unsets the specified togglenames by replacing their values with \\001none\\001" "/unset" "TOG,UNSET"
szaddhelp "userlist" "/userlist" "Lists all users in the userlist." "" "ADDUSER,REMUSER"
szaddhelp "vc" "/vc <nick1>\[ <nick2> .. <nickN>\]" "Voices (mode +v) the specified nick(s) in the current channel." "/mode <channel> +v <nick>" "DVC"
szaddhelp "cvc" "/cvc <channel> <nick1>\[ <nick2> .. <nickN>\]" "Voices (mode +v) the specified nick(s) in <channel>." "/mode <channel> +v <nick>" "CDVC"
szaddhelp "ver" "/ver \[destination\]" "Sends a CTCP VERSION request to \[destination\].  If \[destination\] is not specified, the active query, channel, or chat will become the target of the command." "/ctcp <destination> VERSION" "CTCP"
szaddhelp "view" "/view <text file>" "Opens <text file> using the program specified in the toggle 'Default_Text_Viewer'" "" ""
szaddhelp "w" "/w <nickname1>\[,<nickname2>,..<nicknameN>\]" "Performs a whois lookup on the specified nicknames." "/whois" "WHOIS,WHO"
szaddhelp "wall" "/wall \[channel\] <text>" "Sends a NOTICE to all ops in \[channel\], the notice usually has header information to inform the operators that the notice is going only to the ops on that channel.  If \[channel\] is not specified, the currently active channel is used." "" "NOTICE"
szaddhelp "wallops" "/wallops <text>" "Performs a WALLOPS with <text>.  Wallops is a standard IRC command to send a message to all users who have a usermode of +w." "" "OPER"
szaddhelp "who" "/who \[pattern\]" "Performs a WHO on \[pattern\].  If \[pattern\] is not specified, the currently active channel or the server you are currently on becomes the target of the command." "" "NAMES,WHOIS"
szaddhelp "whois" "/whois \[-t\] <nickname1>\[,<nickname2>,..<nicknameN>\] | /whois <@hostname>" "Performs a whois lookup on the specified nickname(s).  If -t is specified, the whois replied is dumped to the active query/chat/channel.  If \"@\" is used, a whois domain lookup is done, in this case both the \"@\" character and the hostname must be specified." "/w" "W,WHO"
szaddhelp "xwall" "/xwall <text>" "Sends an xwall notice to all users in the Xwall_List.  To change the Xwall_List use /set Xwall_List <nick1>\[,<nick2>,..<nickN>\]." "" "WALL"
szaddhelp "away system" "" "The Sin(zero) away system uses both Away and Page Logging features both of which can be disabled, and both log files can be specified.  The file to be played when a CTCP PAGE request is sent is also configurable." "" "Toggles: Away_Logging, Away_Log, Paging, Page_File, and Page_Log"
szaddhelp "sound system" "" "The Sin(zero) sound system allows for users to specify a default sound directory and allows recursive searching for a file in that directory.  Upon a CTCP SOUND request, the requested sound is first searched for in XiRCON's working directory, if the sound is not found there, it is then searched for in the default sound directory, and if it is not found at that location a recursive search through all subdirectories of the default sound directory are searched." "" "Toggles: SoundDir, Sound_System, and Sound_Recursion"

proc toggle_menu {o} {
  global sin_zero
  menu $o "Toggles->Settings.." { /set }
  menu $o "Toggles->"
  menu $o "Toggles->Save.." {
    set fname [prompt "Save Toggles..." "Save toggles to:" "[pwd]/mytogs.tog"]
    if {$fname != ""} {
      /togsave $fname
    }
    unset fname
  }
  menu $o "Toggles->Load.." {
    set fname [prompt "Load Toggles..." "Load toggles from:" "[pwd]/mytogs.tog"]
    if [file exists $fname] {
      /togload $fname
    }
  }
}
####- User Menus -####
#- Status
menu status "*L&users" { /lusers }
menu status "&Motd" { /motd }
menu status "&Join->#AntiSocial" { /join #AntiSocial }
menu status "&Join->#XiRCON" { /join #XiRCON }
menu status "&Join->#linux" { /join #linux }
menu status "&Join->" { }
menu status "&Join->?" { set j [prompt "Join..." "Enter Channel Name" ""]; if {$j != ""} { /join $j }; unset j }
menu status "&Part->?" { set p [prompt "Part..." "Enter Channel Name" ""]; if {$p != ""} { /part $p }; unset p }
menu status "&Part->&All" { /partall }
menu status "&List" { /list }
menu status "" { }
toggle_menu status

#- Channel
menu channel "*&Chan Info" { show_props channel [channel] }
menu channel "" { }
menu channel "&Scans->&Oper" { /scan oper [channel] }
menu channel "&Scans->&Clone" { /scan clone [channel] }
menu channel "&Update IAL" { /scan ial [channel] }
menu channel ""
menu channel "Info->Rdisp" { /rdisp [channel] }
menu channel "Info->Tsearch" { set search [prompt "Enter Search String" "Search String:" ""]; if [string length $search] { /tsearch [channel] $search }; unset search }
menu channel ""
menu channel "Away->&away" { set reason [prompt "Away" "Enter reason:" [get_tog "Default_Away_Message"]]; if [string length $reason] { /away $reason } }
menu channel "Away->&back" { /back }
menu channel "Away->"
menu channel "Away->&log->&view" { /awaylog view }
menu channel "Away->&log->&erase" { /awaylog erase }
menu channel ""
toggle_menu channel
menu channel ""
menu channel "&Quote" { /sinquote }

#- Users
menu users "*&Whois" { /whois [join [args] ","] }
menu users "&Query" { /query [join [args] ","] }
menu users "" { }
menu users "Control->Op" { /op [join [args]] }
menu users "Control->Dop" { /dop [join [args]] }
menu users "Control->" { }
menu users "Control->Voice" { /vc [join [args]] }
menu users "Control->Devoice" { /dvc [join [args]] }
menu users "Control->" { }
menu users "Control->Kick->Default" { /kick [lindex [args] 0] }
menu users "Control->Kick->?" { set km [prompt "Kick Msg" "Enter kick message:" ""]; if {$km != ""} { /kick [lindex [args] 0] $km }; unset km }
menu users "Control->Ban->-nick!user@host-" { set b_type 5; /ban [lindex [args] 0] $b_type; unset b_type }
menu users "Control->Ban->-*!user@host-" { set b_type 0; /ban [lindex [args] 0] $b_type; unset b_type }
menu users "Control->Ban->-*!*ser@host-" { set b_type 1; /ban [lindex [args] 0] $b_type; unset b_type }
menu users "Control->Ban->-*!*@host-" { set b_type 2; /ban [lindex [args] 0] $b_type; unset b_type }
menu users "Control->Ban->-*!*ser@*.domain-" { set b_type 3; /ban [lindex [args] 0] $b_type; unset b_type }
menu users "Control->Ban->-*!*@*.domain-" { set b_type 4; /ban [lindex [args] 0] $b_type; unset b_type }
menu users "Control->Ban->-nick!*ser@host-" { set b_type 6; /ban [lindex [args] 0] $b_type; unset b_type }
menu users "Control->Ban->-nick!*@host-" { set b_type 7; /ban [lindex [args] 0] $b_type; unset b_type }
menu users "Control->Ban->-nick!*ser@*.domain-" { set b_type 8; /ban [lindex [args] 0] $b_type; unset b_type }
menu users "Control->Ban->-nick!*@*.domain-" { set b_type 9; /ban [lindex [args] 0] $b_type; unset b_type }
menu users "Control->Ban->"
menu users "Control->Ban->ScrewBan" { /screwban [lindex [args] 0] }
menu users "Control->KickBan" { /kickban [channel] [lindex [args] 0] 3 }
menu users "" { }
menu users "CTCP->Ping" { /ping [join [args] ","] }
menu users "CTCP->Version" { /ver [join [args] ","] }
menu users "CTCP->Page" { /page [join [args] ","] }
menu users "CTCP->Finger" { /ctcp [join [args] ","] finger }
menu users "CTCP->" { }
menu users "CTCP->?" { set ctcp [prompt "CTCP" "Enter CTCP type" ""]; if [string length $ctcp] { /ctcp [join [args] ","] $ctcp } }
menu users "DCC->Chat" { /dcc chat [join [args] ","] }
menu users "DCC->Send" { /dcc send [join [args] ","] }
menu users "DCC->TSend" { /tdcc send [join [args] ","] }
menu users "" { }
menu users "xWall->Add" {
  set fin ""
  if {[get_tog "Xwall_List"] == "" || [stl [get_tog "Xwall_List"]] == "\001none\001"} {
    set fin [join [args] ","]
    /set Xwall_List $fin
  } {
    set fir [get_tog "Xwall_List"]
    set tmp ""
    foreach a [join [args]] {
      if ![lfind [split $fir ","] $a] {
        lappend tmp $a
      }
    }
    if {$tmp != ""} {
      set fin $fir,[join $tmp ","]
      /set Xwall_List $fin
    }
    unset fir tmp
  }
  unset fin
}
menu users "xWall->Remove" {
  set cur [get_tog "Xwall_List"]
  if {$cur != "" && [stl $cur] != "\001none\001"} {
    set tmp ""
    foreach c [split $cur ","] {
      if ![lfind [join [args]] $c] {
        lappend tmp $c
      }
    }
    set tmp [join $tmp ","]
    if {$tmp == ""} {
      /unset Xwall_List
    } {
      /set Xwall_List $tmp
    }
    unset tmp
  }
  unset cur
}
menu users "xWall->" { }
menu users "xWall->Current List" { /set Xwall_List }
menu users "xWall->Clear List" { /unset Xwall_List }
menu users ""
menu users "Said" { /said [channel] [lindex [args] 0] }

#- Query

menu query "*&Whois" { /whois [query] }
menu query "Userhost" { /userhost [query] }
menu query "DNS" { /nslookup [query] }
menu query "" { }
menu query "CTCP->Ping" { /ping [query] }
menu query "CTCP->Version" { /ver [query] }
menu query "CTCP->Page" { /page [query] }
menu query "CTCP->Finger" { /ctcp [query] finger }
menu query "CTCP->" { }
menu query "CTCP->?" { set ctcp [prompt "CTCP" "Enter CTCP type" ""]; if {$ctcp != ""} { /ctcp [query] $ctcp } }
menu query "DCC->Chat" { /dcc chat [query] }
menu query "DCC->Send" { /dcc send [query] }
menu query "DCC->TSend" { /tdcc send [query] }
menu query "" { }
toggle_menu "query"
menu query "" { }
menu query "&Quote" { /sinquote }

#- DCC

menu chat "*&Whois" { /whois [chat] }
menu chat ""
menu chat "Send" { /dcc send [chat] }

if {[info exists sin_zero(FALC_LOAD)] && $sin_zero(FALC_LOAD)} {
  set sin_zero(version) "$sin_zero(version) +[b]([b][u]f[b]al[b]c[u]/[FALC_ver][b])[b]"
}

####- Addon Sourcing -####

if ![file exist [pwd]/addons.sz] {
  file mkdir [pwd]/addons.sz
}
set ADDON_LIST ""
set add_load [clock clicks]
set addons 0
foreach t "{*.sin} {*.tcl}" {
  foreach f [glob -nocomplain "[pwd]/addons.sz/$t"] {
    if {![string compare [stl [file tail $f]] "cryption.sin"] || ![string compare [stl [file tail $f]] "cryption.tcl"]} {
      catch {file rename $f ${f}.old}
    } {
      incr addons
      source $f
      lappend ADDON_LIST $f
      set_cookie ADDON([file tail $f]) [file mtime $f]
    }
  }
  if {$addons != 0} {
    echo "[c]14<[c]00\[[c]15([c]14$addons[c]15)[c]14:[c]15 Addons[c]14([c]00$t[c]14)[c]15 sourced in [c]14[expr ([clock clicks]-$add_load)/1000.0] secs[c]00\][c]14>" status
  }
  set add_load [clock clicks]
  set addons 0
}
set A_LIST [get_cookie ADDONS]
foreach a $A_LIST { if ![lfind $ADDON_LIST $a] { set_cookie ADDON($a) "" } }
set_cookie ADDONS $ADDON_LIST
catch {unset a}
unset A_LIST
#set dummyLoaded 1
if [info exists f] { unset f }
if [info exists t] { unset t }
unset addons add_load

####- End(Addon Sourcing) -####


####- Event Hooks -####

for {set x 0} {$x <= 999} {incr x} {
  on $x { if [isblocked [nick] [user] [host]] { complete; return } }
}
on privmsg { if [isblocked [nick] [user] [host]] { complete; return } }
on mode { if [isblocked [nick] [user] [host]] { complete; return } }
on topic { if [isblocked [nick] [user] [host]] { complete; return } }
on ctcp { if [isblocked [nick] [user] [host]] { complete; return } }
on ctcp_reply { if [isblocked [nick] [user] [host]] { complete; return } }
on wallops { if [isblocked [nick] [user] [host]] { complete; return } }
on notice { if [isblocked [nick] [user] [host]] { complete; return } }
on join { if [isblocked [nick] [user] [host]] { complete; return } }
on part { if [isblocked [nick] [user] [host]] { complete; return } }
on kick { if [isblocked [nick] [user] [host]] { complete; return } }
on quit { if [isblocked [nick] [user] [host]] { complete; return } }
on nick { if [isblocked [nick] [user] [host]] { complete; return } }
on error { if [isblocked [nick] [user] [host]] { complete; return } }
on kill { if [isblocked [nick] [user] [host]] { complete; return } }

on 001 { set USER_INFO(server) [host]; complete }
on 002 { complete }
on 003 { complete }
on 004 { complete }
on 364 { complete }
on 365 { complete }
on 367 {
  set chan [lindex [args] 1]
  if ![info exists BLOCK_BAN_LIST([stl $chan])] {
    if ![info exists BAN_LIST_COUNT([stl $chan])] {
      set BAN_LIST_COUNT([stl $chan]) 1
      if [window exists channel $chan] {
        echo [banlistheadEcho] channel $chan
      } {
        echo [banlistheadEcho] status
      }
    } {
      incr BAN_LIST_COUNT([stl $chan])
    }
    set mask [lindex [args] 2]
    set by [lindex [args] 3]
    set time [lindex [args] 4]
    if [info exists RETR_BAN_LIST([stl $chan])] {
      if {$RETR_BAN_LIST([stl $chan]) != 0 && $RETR_BAN_LIST([stl $chan]) == $BAN_LIST_COUNT([stl $chan])} {
        if [onchan [my_nick] $chan] {
          echo [banlistmaskEcho $chan $BAN_LIST_COUNT([stl $chan]) $mask $by $time] channel $chan
        } {
          echo [banlistmaskEcho $chan $BAN_LIST_COUNT([stl $chan]) $mask $by $time] status
        }
      } elseif !$RETR_BAN_LIST([stl $chan]) {
        if [onchan [my_nick] $chan] {
          echo [banlistmaskEcho $chan $BAN_LIST_COUNT([stl $chan]) $mask $by $time] channel $chan
        } {
          echo [banlistmaskEcho $chan $BAN_LIST_COUNT([stl $chan]) $mask $by $time] status
        }
      }
    } {
      echo [banlistmaskEcho $chan $BAN_LIST_COUNT([stl $chan]) $mask $by $time] status
    }
    unset mask by time
  }
  unset chan
  complete
}
on 368 {
  set chan [lindex [args] 1]
  if ![info exists BAN_LIST_COUNT([stl $chan])] {
    set BAN_LIST_COUNT([stl $chan]) 0
  }
  if {[info exists BLOCK_BAN_LIST([stl $chan])]} {
    unset BLOCK_BAN_LIST([stl $chan])
  } {
    if [info exists RETR_BAN_LIST([stl $chan])] {
      if !$RETR_BAN_LIST([stl $chan]) {
        if [onchan [my_nick] $chan] {
          echo [banlistendEcho $chan $BAN_LIST_COUNT([stl $chan])] channel $chan
        } {
          echo [banlistendEcho $chan $BAN_LIST_COUNT([stl $chan])] status
        }
      }
      unset RETR_BAN_LIST([stl $chan])
    } {
      echo [banlistendEcho $chan $BAN_LIST_COUNT([stl $chan])] status
    }
  }
  unset BAN_LIST_COUNT chan
  complete
}
on 341 {
  echo [invitingEcho [lindex [args] 1] [lindex [args] 2]] status
  complete
}
on invite {
  if ![isignored [nick]![user]@[host] invite] {
    echo [invitedEcho [nick] [lindex [args] 1]]
  }
  complete
}
on 321 { complete }
on 322 { complete }
on 323 { complete }
on 375 {
  set motdval [stl [get_tog Motd]]
  if {[string range $motdval 0 5] != "ignore" && [string range $motdval 0 4] != "never"} {
    echo [motdheadEcho [join [lrange [args] 1 end]]] status
  }
  unset motdval
  complete
}
on 372 {
  set motdval [stl [get_tog Motd]]
  if {[string range $motdval 0 5] != "ignore" && [string range $motdval 0 4] != "never"} {
    if ![strcmpi [string range $motdval 0 5] "update"] {
      if ![info exists MOTD_FIRST_LINE] {
        set MOTD_FIRST_LINE 1
        set MOTD_TIME [join [lrange [args] 1 end]]
        set_cookie MOTDTMP $MOTD_TIME
        unset MOTD_TIME
      }
      if {([strcmp [get_cookie MOTDTMP] [get_cookie MOTD([serv])]] != 0) || ![string length [get_cookie "MOTDTMP"]]} {
        if ![info exists MOTD_LINE_SPOOL] { set MOTD_LINE_SPOOL ""; lappend MOTD_LINE_SPOOL [motdtextEcho [join [lrange [args] 1 end]]] } { lappend MOTD_LINE_SPOOL [join [lrange [args] 1 end]] }
      }
    } {
      if ![info exists MOTD_LINE_SPOOL] { set MOTD_LINE_SPOOL ""; lappend MOTD_LINE_SPOOL [motdtextEcho [join [lrange [args] 1 end]]] } { lappend MOTD_LINE_SPOOL [motdtextEcho [join [lrange [args] 1 end]]] }
    }
  }
  unset motdval
  complete
}
on 378 {
  set motdval [stl [get_tog Motd]]
  if {[string range $motdval 0 5] != "ignore" && [string range $motdval 0 4] != "never"} {
    if ![strcmpi [string range $motdval 0 5] "update"] {
      if ![info exists MOTD_FIRST_LINE] {
        set MOTD_FIRST_LINE 1
        set MOTD_TIME [join [lrange [args] 1 end]]
        set_cookie MOTDTMP $MOTD_TIME
        unset MOTD_TIME
      }
      if {([strcmp [get_cookie MOTDTMP] [get_cookie MOTD([serv])]] != 0) || ![string length [get_cookie "MOTDTMP"]]} {
        if ![info exists MOTD_LINE_SPOOL] { set MOTD_LINE_SPOOL ""; lappend MOTD_LINE_SPOOL [motdtextEcho [join [lrange [args] 1 end]]] } { lappend MOTD_LINE_SPOOL [join [lrange [args] 1 end]] }
      }
    } {
      if ![info exists MOTD_LINE_SPOOL] { set MOTD_LINE_SPOOL ""; lappend MOTD_LINE_SPOOL [motdtextEcho [join [lrange [args] 1 end]]] } { lappend MOTD_LINE_SPOOL [motdtextEcho [join [lrange [args] 1 end]]] }
    }
  }
  unset motdval
  complete
}
on 376 {
  set motdval [stl [get_tog Motd]]
  if [info exists MOTD_FIRST_LINE] { unset MOTD_FIRST_LINE }
  if {[string range $motdval 0 5] != "ignore" && [string range $motdval 0 4] != "never"} {
    if {[string range $motdval 0 5] == "update"} {
      if {[get_cookie MOTDTMP] != ""} {
        set_cookie MOTD([serv]) [get_cookie MOTDTMP]
      }
      set_cookie MOTDTMP ""
    }
    if [info exists MOTD_LINE_SPOOL] {
      foreach motdLine $MOTD_LINE_SPOOL { echo $motdLine status; FALC_yield }
      if [info exists motdLine] { unset motdLine }
      if [info exists MOTD_LINE_SPOOL] { unset MOTD_LINE_SPOOL }
    }
    echo [motdendEcho [join [lrange [args] 1 end]]] status
  }
  unset motdval
  complete
}
on 381 { echo [nowircopEcho] status; complete }
on 353 {
  set dest [lindex [args] 2]
  set nlist [join [lrange [args] 3 end]]
  set nlist [replace $nlist "\{" "\\\{"]
  set nlist [replace $nlist "\}" "\\\}"]
  if ![info exists NAMES_SPOOL([stl $dest])] { set NAMES_SPOOL([stl $dest]) "" }
  foreach n $nlist { lappend NAMES_SPOOL([stl $dest]) $n }
  if [info exists dest] { unset dest }; if [info exists nlist] { unset nlist }; if [info exists n] { unset n }
  complete
}
on 366 {
  if ![info exists on366dest] { set on366dest [lindex [args] 1] }
  if {[info exists KICK_TRAQ([stl [lindex [args] 1]])] && [info exists KICK_TRAQ(DO_MENU)]} {
    set KICK_TRAQ(.) [lindex [args] 1]
    set niq [lindex [split $KICK_TRAQ([stl [lindex [args] 1]]) ","] 0]
    set c_time [lindex [split $KICK_TRAQ([stl [lindex [args] 1]]) ","] 1]
    echo [kick_menu $niq [lindex [args] 1]]
    unset KICK_TRAQ(DO_MENU)
  }
  if [info exists SYNC_TIME([stl [lindex [args] 1]])] {
    set synctime [expr ([clock clicks]-$SYNC_TIME([stl [lindex [args] 1]]))/1000.0]
    set 366sync [synctimeEcho [lindex [args] 1] $synctime]
    if [window exists channel [lindex [args] 1]] {
      echo $366sync channel [lindex [args] 1]
    } {
      echo $366sync status
    }
    unset SYNC_TIME([stl [lindex [args] 1]]) synctime 366sync
  }
  if [info exists NAMES_SPOOL([stl [lindex [args] 1]])] {
    set on366spool $NAMES_SPOOL([stl [lindex [args] 1]])
    set max [llength $on366spool]
    if [window exists channel [lindex [args] 1]] {
      set namesuseChan 1
    } {
      set namesuseChan 0
    }
    if $namesuseChan {
      echo [namesuserCount [lindex [args] 1] $max] channel [lindex [args] 1]
    } {
      echo [namesuserCount [lindex [args] 1] $max] status
    }
    set on366out ""
    set on366cnt 0
    foreach on366n $on366spool {
      incr on366cnt
      lappend on366out [nameselementText $on366n]
      if {$on366cnt >= 6} {
        if $namesuseChan {
          echo [namesmainText [lindex [args] 1] [join $on366out]] channel [lindex [args] 1]
        } {
          echo [namesmainText [lindex [args] 1] [join $on366out]] status
        }
        set on366out ""
        set on366cnt 0
        FALC_yield
      }
    }
    if {[info exists on366out] && [string length $on366out]} {
      if [window exists channel [lindex [args] 1]] {
        echo [namesmainText [lindex [args] 1] [join $on366out]] channel [lindex [args] 1]
      } {
        echo [namesmainText [lindex [args] 1] [join $on366out]] status
      }
      if [info exists on366n] { unset on366n }
    }
    if [info exists on366spool] { unset on366spool }
    if [info exists on366out] { unset on366out }
    if [info exists NAMES_SPOOL([stl [lindex [args] 1]])] { unset NAMES_SPOOL([stl [lindex [args] 1]]) }
    if [info exists max] { unset max }
  }
  complete
}
on 324 {
  set chan [fixchan [lindex [args] 1]]
  set mode [string trimleft [lindex [args] 2] "+"]
  set modes [string trimleft [join [lrange [args] 2 end]] "+"]
  set CHAN_INFO([stl $chan]:mode) [sort $mode]
  if {[pos $mode "k"] == -1 && [pos $mode "l"] == -1} {
    set CHAN_INFO([stl $chan]:key) ""
    set CHAN_INFO([stl $chan]:lim) ""
  }
  if {[pos $mode "k"] != -1 && [pos $mode "l"] == -1} {
    set CHAN_INFO([stl $chan]:key) [lindex [args] 3]
    set CHAN_INFO([stl $chan]:lim) ""
  }
  if {[pos $mode "k"] == -1 && [pos $mode "l"] != -1} {
    set CHAN_INFO([stl $chan]:lim) [lindex [args] 3]
    set CHAN_INFO([stl $chan]:key) ""
  }
  if {[pos $mode "k"] != -1 && [pos $mode "l"] != -1} {
    if {[pos $mode "k"] > [pos $mode "l"]} {
      set CHAN_INFO([stl $chan]:lim) [lindex [args] 3]
      set CHAN_INFO([stl $chan]:key) [lindex [args] 4]
    } {
      set CHAN_INFO([stl $chan]:key) [lindex [args] 3]
      set CHAN_INFO([stl $chan]:lim) [lindex [args] 4]
    }
  }
  window set_title [chanWindow $chan $CHAN_INFO([stl $chan]:mode) $CHAN_INFO([stl $chan]:key) $CHAN_INFO([stl $chan]:lim) [topic $chan]] channel $chan
  unset chan mode modes
  complete
}
on 329 {
  set chan [fixchan [lindex [args] 1]]
  set when [lindex [args] 2]
  if {$when < 1000000} {
    set out [invalidcreationtimeEcho $chan $when]
    if [window exists channel $chan] {
      echo $out channel $chan
    } {
      echo $out status
    }
  } {
    set out [chancreatedEcho $chan $when]
    if [window exists channel $chan] {
      echo $out channel $chan
    } {
      echo $out status
    }
  }
  unset out when chan
  complete
}
on 332 {
  set chan [fixchan [lindex [args] 1]]
  set topic [lindex [args] 2]
  set CHAN_INFO([stl $chan]:topic) $topic
  window set_title [chanWindow $chan [mode $chan] [get_chan_key [mode $chan]] [get_chan_lim [mode $chan]] $CHAN_INFO([stl $chan]:topic)] channel $chan
  if [window exists channel $chan] {
    echo [chantopicEcho $chan $topic] channel $chan
  } {
    echo [chantopicEcho $chan $topic] status
  }
  unset chan topic
  complete
}
on 333 {
  set chan [fixchan [lindex [args] 1]]
  set nick [lindex [args] 2]
  set when [lindex [args] 3]
  if ![isint $when] { set when 0 }
  set out [topicbyEcho $chan $nick $when]
  if [window exists channel $chan] {
    echo $out channel $chan
  } {
    echo $out status
  }
  unset out nick chan when
  complete
}
on 243 {
  set o [lindex [args] 1]
  set host [lindex [args] 2]
  set user [lindex [args] 4]
  if [info exists STATS_O($user)] {
    lappend STATS_O($user) "$o $host"
  } {
    set STATS_O($user) ""
    lappend STATS_O($user) "$o $host"
  }
  complete
}
on 219 {
  set t [lindex [args] 1]
  switch -- [stl $t] {
    "o" {
      if [info exists STATS_O] {
        set cnt 0
        set ul [lsort [array names STATS_O]]
        echo [olistHead] status
        foreach u $ul {
          set hl $STATS_O($u)
          set ho [lindex $hl 0]
          set o [lindex $ho 0]
          set h [lindex $ho 1]
          echo [olistUser $u $h $o] status
          incr cnt
          if {[llength $hl] > 1} {
            for {set x 1} {$x < [llength $hl]} {incr x} {
              incr cnt
              set ho [lindex $hl $x]
              set o [lindex $ho 0]
              set h [lindex $ho 1]
              echo [olistUserx $u $h $o] status
            }
          }
          unset u h hl ho
        }
        echo [olistEnd [llength $ul] $cnt] status
        unset STATS_O ul cnt
        complete
      }
    }
  }
}
on 251 {
  set ilist [lindex [args] 1]
  set ncnt 0
  foreach a $ilist {
    if [isint $a] {
      switch -- $ncnt {
        "0" { set lusers(users) $a; incr ncnt }
        "1" { set lusers(invis) $a; incr ncnt }
        "2" { set lusers(servs) $a; incr ncnt }
      }
    }
    unset a
  }
  unset ilist ncnt
  set lusers(opers) 0; set lusers(chans) 0; set lusers(clnts) 0; set lusers(lserv) 0; set lusers(unknw) 0
  if ![string length $lusers(users)] { set lusers(users) 0 }; if ![string length $lusers(invis)] { set lusers(invis) 0 }; if ![string length $lusers(servs)] { set lusers(servs) 0 }
  complete
}
on 252 {
  set lusers(opers) [lindex [args] 1]
  complete
}
on 253 {
  set lusers(unknw) [lindex [args] 1]
  complete
}
on 254 {
  set lusers(chans) [lindex [args] 1]
  complete
}
on 255 {
  set ilist [lindex [args] 1]
  set ncnt 0
  foreach a $ilist {
    if [isint $a] {
      switch -- $ncnt {
        "0" { set lusers(clnts) $a; incr ncnt }
        "1" { set lusers(lserv) $a; incr ncnt }
      }
    }
    unset a
  }
  unset ilist ncnt
  if ![string length $lusers(clnts)] { set clnts 0 } { set clnts $lusers(clnts) }
  if ![string length $lusers(lserv)] { set lserv 0 } { set lserv $lusers(lserv) }
  set invis $lusers(invis); set users $lusers(users); set opers $lusers(opers); set total [expr $users+$invis]
  set chans $lusers(chans); set servs $lusers(servs); set unknown $lusers(unknw)
  echo [lusersTop [host] $users $invis $opers $servs $total $chans $unknown $clnts $lserv] status; echo [lusersBody [host] $users $invis $opers $servs $total $chans $unknown $clnts $lserv] status; echo [lusersBottom [host] $users $invis $opers $servs $total $chans $unknown $clnts $lserv] status
  unset lusers users invis opers total chans servs unknown; complete
}
on 305 { set AWAY_INFO(away) 0; complete }
on 306 { set AWAY_INFO(away) 1; complete }
on 352 {
  if [info exists CLONE_SCAN(chk)] {
    set user [lindex [args] 2]; set host [lindex [args] 3]; set nick [lindex [args] 5]
    if ![info exists CLONE_HOSTS([stl $host])] { set CLONE_HOSTS([stl $host]) $host }
    if ![info exists CLONE_COUNT([stl $host])] { set CLONE_COUNT([stl $host]) 1 } { incr CLONE_COUNT([stl $host]) }
    if ![info exists CLONE_USER([stl $host]?$user)] { set CLONE_USER([stl $host]?$user) 1 } { incr CLONE_USER([stl $host]?$user) }
    if ![info exists CLONE_USER($user@[stl $host])] { set CLONE_USER($user@[stl $host]) $nick } { set CLONE_USER($user@[stl $host]) $CLONE_USER($user@[stl $host]),$nick }
  } elseif [info exists OPER_SCAN(chk)] {
    set user [lindex [args] 2]; set host [lindex [args] 3]
    set nick [lindex [args] 5]; set modes [lindex [args] 6]
    if {[pos $modes "*"] != -1} { set OPER_FOUND($nick) $user@$host }
  } elseif [info exists IAL_SCAN(chk)] {
    set nick [lindex [args] 5]; set user [lindex [args] 2]
    set host [lindex [args] 3]
    if ![info exists IAL_SCAN(count)] { set IAL_SCAN(count) 1 } {  incr IAL_SCAN(count) }
    add_ial $nick $user $host
  } {
    if ![info exists WHO_LIST(count)] { set WHO_LIST(count) 1 } { incr WHO_LIST(count) }
    set chan [lindex [args] 1]; set nick [lindex [args] 5]; set user [lindex [args] 2]; set host [lindex [args] 3]; set modes [lindex [args] 6]
    set hops [string range [lindex [args] 7] 0 [expr [pos [lindex [args] 7] " "]-1]]; set ircname [string range [lindex [args] 7] [expr [pos [lindex [args] 7] " "]+1] end]
    echo [wholistEcho $chan $nick $user $host $hops $modes $ircname] status
  }
  complete
}
on 315 {
  if [info exists CLONE_SCAN(chk)] {
    set c_found 0
    echo [cloneheader $CLONE_SCAN(chk)]
    foreach c [array names CLONE_HOSTS] {
      if {$CLONE_COUNT($c) > 1} {
        if {$c_found == 0} {
          set c_found 1
        }
        set c_host $CLONE_HOSTS($c)
        set clones $CLONE_COUNT($c)
        echo [clonemajorline $CLONE_SCAN(chk) $c_host $clones]
        foreach mc [array names CLONE_USER] {
          set i [split $mc "?"]; set host [lindex $i 0]
          if {$host == [stl $c_host]} { set m_clones $CLONE_USER($host?[lindex $i 1]); echo [cloneminorline $CLONE_SCAN(chk) [lindex $i 1] $c_host $m_clones $CLONE_USER([lindex $i 1]@[stl $c_host])] }
        }
      }
    }
    if !$c_found { echo [noclonesdetected $CLONE_SCAN(chk)] }
    echo [clonefooter $CLONE_SCAN(chk)]
    catch {unset CLONE_COUNT CLONE_USER CLONE_HOSTS CLONE_SCAN(chk) host mc c_host clones c c_found}
  } elseif [info exists OPER_SCAN(chk)] {
    echo [operscanheader $OPER_SCAN(chk) [llength [array names OPER_FOUND]]]
    set o_found 0
    foreach o [array names OPER_FOUND] { set o_found 1; set user [lindex [split $OPER_FOUND($o) "@"] 0]; set host [lindex [split $OPER_FOUND($o) "@"] 1]; echo [operlist $OPER_SCAN(chk) $o $user $host] }
    if !$o_found { echo [noopersdetected $OPER_SCAN(chk)] }
    echo [operscanfooter $OPER_SCAN(chk) [llength [array names OPER_FOUND]]]
    catch {unset OPER_SCAN OPER_FOUND o_found user o host}
  } elseif [info exists IAL_SCAN(chk)] {
    if ![info exists IAL_SCAN(count)] { set IAL_SCAN(count) 0 }
    if ![info exists IAL_SCAN(chk)] { set IAL_SCAN(chk) "\001#unknown_channel_name\001" }
    echo [ialscancompleteEcho $IAL_SCAN(chk) $IAL_SCAN(count)]
    catch {unset IAL_SCAN}
  } {
    set pattern [lindex [args] 1]
    if ![info exists WHO_LIST(count)] { set WHO_LIST(count) 0 }
    echo [whoendEcho $pattern $WHO_LIST(count)] status
    unset WHO_LIST
  }
  complete
}
on 221 {
  set m_list [lindex [args] 1]
  set m_list [string trimleft $m_list "+"]
  set m_list [sort $m_list]
  set USER_INFO(modes) $m_list
}
on 302 {
  set split [lindex [args] 1]
  set split [replace $split "\{" "\\\{"]
  set split [replace $split "\}" "\\\}"]
  foreach s $split {
    set nick [lindex [split $s "="] 0]
    set nick [string trimright $nick "+*-"]
    set userhost [string trimleft [lindex [split $s "="] 1] "+-*"]
    set user [lindex [split $userhost "@"] 0]
    set host [lindex [split $userhost "@"] 1]
    if {[info exists UHOST_NICK_OWNED] && ![strcmpi $UHOST_NICK_OWNED $nick]} {
      echo [nickownedbyEcho $nick $user $host] status
      unset UHOST_NICK_OWNED
      complete
    }
    if {[info exists DNS_GETHOST] && [lfind $DNS_GETHOST $nick]} {
      set DNS_GETHOST [lreplace $DNS_GETHOST [lpos $DNS_GETHOST $nick] [lpos $DNS_GETHOST $nick]]
      if ![info exists DNS_LIST] {
        set DNS_LIST ""
      }
      if ![lfind $DNS_LIST $host] {
        lappend DNS_LIST $host
        echo [dnsattemptEcho $host]
        lookup $host
      }
      complete
    }
    if {[info exists BAN_LOOKUP] && [lfind $BAN_LOOKUP $nick]} {
      set BAN_LOOKUP [lreplace $BAN_LOOKUP [lpos $BAN_LOOKUP $nick] [lpos $BAN_LOOKUP $nick]]
      if [info exists BAN_CHANS([stl $nick])] {
        set chan [lindex [split $BAN_CHANS([stl $nick]) ","] 0]
        set type [lindex [split $BAN_CHANS([stl $nick]) ","] 1]
        set ban_time [lindex [split $BAN_CHANS([stl $nick]) ","] 2]
        set screw_ban [lindex [split $BAN_CHANS([stl $nick]) ","] 3]
        if ![isint $ban_time] { set ban_time 0 }
        if {$chan != ""} {
          if {$type == ""} { set type 3 }
          /quote MODE $chan +b [mask $nick!$user@$host $type $screw_ban]
          if {$ban_time != 0} {
            /timer -s 1 $ban_time /quote MODE $chan -b [mask $nick!$user@$host $type $screw_ban]
          }
        }
        if [info exists KICK_PENDING_UHOST([stl $nick])] {
          set KICK_PENDING_BAN([stl [mask $nick!$user@$host $type]]) $nick
          unset KICK_PENDING_UHOST([stl $nick])
        }
        catch {unset chan type BAN_CHANS([stl $nick]) ban_time}
      }
      complete
    }
    if [info exists USERHOST([stl $nick])] {
      echo [userhostEcho $s] status
      unset USERHOST([stl $nick])
      complete
    }
    if [info exists USERIP([stl $nick])] {
      echo [useripEcho $s] status
      unset USERIP([stl $nick])
      complete
    }
    if [info exists IGNORE_HOST([stl $nick])] {
      set type [lindex $IGNORE_HOST([stl $nick]) 0]
      set flags [lindex $IGNORE_HOST([stl $nick]) 1]
      unset IGNORE_HOST([stl $nick])
      /ignore -$flags $nick!$userhost $type
      if [info exists flags] { unset flags }
      if [info exists type] { unset type }
    }
    unset nick userhost user host
  }
  complete
}
on 307 {
  set split [lindex [args] 1]
  foreach s $split {
    set nick [lindex [split $s "="] 0]
    set nick [string trimright $nick "+*-"]
    if [info exists USERIP([stl $nick])] {
      unset USERIP([stl $nick])
    }
    echo [useripEcho $s] status
  }
  complete
}
on 301 {
  set nick [lindex [args] 1]
  if [info exists WHOIS([stl $nick])] {
    set WHOIS([stl $nick]:away) [lindex [args] 2]
  } elseif [info exists WHOWAS([stl $nick])] {
    echo [whowasaway $nick [lindex [args] 2]]
  } {
    set block 0
    if [info exists AWAY_SPOOL([stl $nick])] {
      if ![strcmpi [lindex [args] 2] $AWAY_SPOOL([stl $nick])] { set block 1 } { set AWAY_SPOOL([stl $nick]) [lindex [args] 2] }
    } {
      set AWAY_SPOOL([stl $nick]) [lindex [args] 2]
    }
    if !$block { echo [userisawayEcho $nick [lindex [args] 2]] }; unset block
  }
  complete
}
on 311 {
  set nick [lindex [args] 1]
  if [info exists WHOIS([stl $nick])] {
    set WHOIS([stl $nick]:nick) $nick
    set WHOIS([stl $nick]:user) [lindex [args] 2]
    set WHOIS([stl $nick]:host) [lindex [args] 3]
    set WHOIS([stl $nick]:name) [join [lrange [args] 5 end]]
    if [isip $WHOIS([stl $nick]:host)] { set x "IP Address" } { set x [country_parse $WHOIS([stl $nick]:host)] }
    set WHOIS([stl $nick]:cntry) $x
    unset x
    if [tog_on "Lookup_On_Whois"] { set WHOIS_DNS_LOOKUP([stl $WHOIS([stl $nick]:host)]) $nick; lookup $WHOIS([stl $nick]:host) }
  }
  complete
}
on 312 {
  set nick [lindex [args] 1]
  if [info exists WHOIS([stl $nick])] {
    set WHOIS([stl $nick]:server) [lindex [args] 2]
    set WHOIS([stl $nick]:server_info) [join [lrange [args] 3 end]]
  } elseif [info exists WHOWAS([stl $nick])] {
    echo [whowasserver $nick [lindex [args] 2] [lindex [args] 3]]
  }
  complete
}
on 313 {
  set nick [lindex [args] 1]
  if [info exists WHOIS([stl $nick])] {
    set WHOIS([stl $nick]:ircop) 1
  }
  complete
}
proc whoisprotected {nick} {
  if [string length [get_env "WhoisProtected"]] {
    return [eval return [get_env "WhoisProtected"]]
  }
  return "[c]00 [c]15pr[c]14otected[c]15:[c]14 $nick is protected"
}
on 316 {
  set nick [lindex [args] 1]
  if [info exists WHOIS([stl $nick])] {
    set WHOIS([stl $nick]:prot) 1
  }
  unset nick
  complete; return
}
on 317 {
  set nick [lindex [args] 1]
  if [info exists WHOIS([stl $nick])] {
    set WHOIS([stl $nick]:idle) [lindex [args] 2]
    if [isint [lindex [args] 3]] {
      set WHOIS([stl $nick]:signon) [lindex [args] 3]
    }
  }
  complete
}
on 318 {
  set nicks [lindex [args] 1]
  if [tog_on "Active_Window_Whois"] {
    set d1 [window_type]
    set d2 [window_name]
  } {
    set d1 "status"
    set d2 ""
  }
  foreach nick [split $nicks ","] {
    if [info exists WHOIS([stl $nick])] {
      if ![info exists WHOIS([stl $nick]:no_such_user)] {
        if ![info exists WHOIS([stl $nick]:nick)] { set WHOIS([stl $nick]:nick) $nick }
        if ![info exists WHOIS([stl $nick]:user)] { set WHOIS([stl $nick]:user) "" }
        if ![info exists WHOIS([stl $nick]:host)] { set WHOIS([stl $nick]:host) "" }
        if ![info exists WHOIS([stl $nick]:cntry)] { set WHOIS([stl $nick]:cntry) "United States of America" }
        if [info exists WHOIS_DNS_LOOKUP([stl $WHOIS([stl $nick]:host)])] { complete; return }
        if [info exists WHOIS([stl $nick]:pubout)] { set pub 1; unset WHOIS([stl $nick]:pubout) } { set pub 0 }
        if !$pub {
          echo [whoisTop $WHOIS([stl $nick]:nick)] $d1 $d2
          echo [whoisuserhost $WHOIS([stl $nick]:nick) $WHOIS([stl $nick]:user) $WHOIS([stl $nick]:host) $WHOIS([stl $nick]:cntry)] $d1 $d2
        } {
          say "[b]\[[b]WHOIS($nick)[b]\]:[b] $nick ($WHOIS([stl $nick]:user)@$WHOIS([stl $nick]:host)) \[$WHOIS([stl $nick]:cntry)\]:"
        }
        if [info exists WHOIS([stl $nick]:name)] {
          if !$pub {
            echo [whoisname $WHOIS([stl $nick]:nick) $WHOIS([stl $nick]:name)] $d1 $d2
          } {
            say "[b]\[[b]NAME.($nick)[b]\]:[b] $WHOIS([stl $nick]:name)"
          }
          unset WHOIS([stl $nick]:name)
        }
        if [info exists WHOIS([stl $nick]:away)] {
          if !$pub {
            echo [whoisaway $WHOIS([stl $nick]:nick) $WHOIS([stl $nick]:away)] $d1 $d2
          } {
            say "[b]\[[b]AWAY.($nick)[b]\]:[b] $WHOIS([stl $nick]:away)"
          }
          catch {unset WHOIS([stl $nick]:away)}
        }
        if [info exists WHOIS([stl $nick]:chans)] {
          if !$pub {
            echo [whoischans $WHOIS([stl $nick]:nick) $WHOIS([stl $nick]:chans)] $d1 $d2
          } {
            say "[b]\[[b]CHANS($nick)[b]\]:[b] $WHOIS([stl $nick]:chans)"
          }
          unset WHOIS([stl $nick]:chans)
        }
        if [info exists WHOIS([stl $nick]:ircop)] {
          if !$pub {
            echo [whoisoper $WHOIS([stl $nick]:nick)] $d1 $d2
          } {
            say "[b]\[[b]IRCOP($nick)[b]\]:[b] is an IRCop"
          }
          unset WHOIS([stl $nick]:ircop)
        }
        if [info exists WHOIS([stl $nick]:server)] {
          if ![info exists WHOIS([stl $nick]:server_info)] { set WHOIS([stl $nick]:server_info) "" }
          if !$pub {
            echo [whoisserver $WHOIS([stl $nick]:nick) $WHOIS([stl $nick]:server) $WHOIS([stl $nick]:server_info)] $d1 $d2
          } {
            say "[b]\[[b]SERVR($nick)[b]\]:[b] $WHOIS([stl $nick]:server) $WHOIS([stl $nick]:server_info)"
          }
          unset WHOIS([stl $nick]:server); unset WHOIS([stl $nick]:server_info)
        }
        if [info exists WHOIS([stl $nick]:prot)] {
          if !$pub {
            echo [whoisprotected $WHOIS([stl $nick]:nick)] $d1 $d2
          } {
            say "[b]\[[b]PROT.($nick)[b]\]:[b] $WHOIS([stl $nick]:nick) is protected"
          }
        }
        if [info exists WHOIS([stl $nick]:idle)] {
          if !$pub {
            echo [whoisidle $WHOIS([stl $nick]:nick) $WHOIS([stl $nick]:idle)] $d1 $d2
          } {
            say "[b]\[[b]IDLE.($nick)[b]\]:[b] [duration $WHOIS([stl $nick]:idle) "wk" "day" "hr" "min" "sec" "s" " " " "]"
          }
          unset WHOIS([stl $nick]:idle)
        }
        if [info exists WHOIS([stl $nick]:signon)] {
          if [isint $WHOIS([stl $nick]:signon)] {
            if !$pub {
              echo [whoissignon $WHOIS([stl $nick]:nick) $WHOIS([stl $nick]:signon)] $d1 $d2
            } {
              say "[b]\[[b]LOGON($nick)[b]\]:[b] [clock format $WHOIS([stl $nick]:signon)]"
            }
          }
          unset WHOIS([stl $nick]:signon)
        }
        if !$pub {
          echo [whoisBottom $WHOIS([stl $nick]:nick)] $d1 $d2
        }
        unset WHOIS([stl $nick]:nick) pub WHOIS([stl $nick]:user) WHOIS([stl $nick]:host) WHOIS([stl $nick]) WHOIS([stl $nick]:cntry)
      } {
        echo [whoisTop $WHOIS([stl $nick]:nick)] $d1 $d2
        echo [whoisnosuchnick $WHOIS([stl $nick]:nick)] $d1 $d2
        echo [whoisBottom $WHOIS([stl $nick]:nick)] $d1 $d2
        /whowas $nick
        unset WHOIS([stl $nick]:nick)
        unset WHOIS([stl $nick]:no_such_user)
        unset WHOIS([stl $nick])
      }
    }
  }
  unset d1 d2
  complete
}
on 319 {
  set nick [lindex [args] 1]
  if [info exists WHOIS([stl $nick])] {
    set WHOIS([stl $nick]:chans) [join [lrange [args] 2 end]]
  }
  complete
}
on 314 {
  set nick [lindex [args] 1]
  set user [lindex [args] 2]
  set host [lindex [args] 3]
  set name [lindex [args] 5]
  echo [whowashost $nick $user $host $name]
  complete
}
on 369 {
  set nick [lindex [args] 1]
  echo [whowasend $nick]
  if [info exists WHOWAS([stl $nick])] { unset WHOWAS([stl $nick]) }
  complete
}
on 401 {
  set nick [lindex [args] 1]
  if [info exists WHOIS([stl $nick])] {
    set WHOIS([stl $nick]:nick) $nick
    set WHOIS([stl $nick]:no_such_user) 1
  } elseif [info exists XWALL_TARGET([stl $nick])] {
    unset XWALL_TARGET([stl $nick])
  } elseif [info exists USERHOST([stl $nick])] {
    echo [nosuchnickEcho $nick]
  } elseif {[info exists NO_SUCH_USER_FAILSAFE([stl $nick])] && ![strcmpi $NO_SUCH_USER_FAILSAFE([stl $nick]) $nick]} {
    echo [nosuchnickEcho $nick]
    unset NO_SUCH_USER_FAILSAFE([stl $nick])
  }
  complete
}
on 403 {
  echo [nosuchnickEcho [lindex [args] 1]]
  complete
}
on 404 {
  set chan [lindex [args] 1]
  if ![onchan [my_nick] $chan] {
    set reason 0
  } {
    if {[pos [lindex [mode $chan] 0] "m"] != -1} {
      set reason 1
    } {
      set reason 2
    }
  }
  set out [cannotsendtochanEcho $chan $reason]
  if [window exists channel $chan] {
    echo $out channel $chan
  } {
    echo $out status
  }
  unset out chan reason
  complete
}
on 406 {
  set nick [lindex [args] 1]
  echo [whowasnouser $nick]
  complete
}
on 421 {
  set cmd [lindex [args] 1]
  echo [unknowncommandEcho $cmd]
  unset cmd
  complete
}
on 432 {
  echo [erroneusnickEcho [lindex [args] 1]]
  complete
}
on 433 {
  set g_nick [lindex [args] 1]
  if {[info exists REGAIN_NICK_START] && ![strcmpi $g_nick $REGAIN_NICK_START]} {
    complete; return
  } elseif {[info exists REGAIN_NICK] && ![strcmpi $g_nick $REGAIN_NICK]} {
    set REGAIN_NICK_TIMER 0
    set REGAIN_NICK_CYCLES 0
    set REGAIN_NICK_START $g_nick
    if ![info exists REGAIN_NICK_TIMES] { set REGAIN_NICK_TIME 60 }
    unset REGAIN_NICK
    echo [regainnickEcho $g_nick]
  } {
    echo [nickinuseEcho $g_nick]
    if ![connected] {
      set UHOST_NICK_OWNED [stl $g_nick]
    }
  }
  complete
}
on 436 { echo [join [args]] }
on 441 {
  set nick [lindex [args] 1]
  set chan [lindex [args] 2]
  if [window exists channel $chan] {
    echo [usernotonchanEcho $nick $chan] channel $chan
  } {
    echo [usernotonchanEcho $nick $chan] status
  }
  unset nick chan
  complete
}
on 461 {
  set cmd [lindex [args] 1]
  echo [notenoughparmsEcho $cmd]
  unset cmd
  complete
}
on 482 {
  if [window exists channel [lindex [args] 1]] {
    echo [notchanopEcho [lindex [args] 1]] channel [lindex [args] 1]
  } {
    echo [notchanopEcho [lindex [args] 1]] status
  }
  complete
}
on pong {
  if {[string range [lindex [args] 1] 0 7] == "LAGMETER"} {
    set tmp [string range [lindex [args] 1] 8 end]
    if [isint $tmp] {
      set tmp [expr ([clock clicks]-$tmp)/1000.0]
      set USER_INFO(lagmeter) $tmp
    } {
      set USER_INFO(lagmeter) 0.000
    }
    unset tmp
  }
}
on error {
  echo [errorText [join [args]]] status
  complete
}
on kill {
  echo [killedText [nick] [user] [host] [lindex [args] 1]] status
  complete
}
on notify {
  if [tog_on "Beep_On_Notify"] { beep }
  echo [notifyEcho [nick] [user] [host] [args]]
  complete
}
on mode+b {
  set chan [lindex [args] 0]
  set bmask [lindex [args] 1]
  if [info exists KICK_PENDING_BAN([stl $bmask])] {
    if [info exists KICK_BAN_REASON([stl $bmask])] {
      set reason $KICK_BAN_REASON([stl $bmask])
      unset KICK_BAN_REASON([stl $bmask])
    } {
      set reason [get_tog "KickBan_Msg"]
    }
    if {$reason == "\001none\001" || $reason == ""} {
      set reason [my_nick]
    }
    /kick $chan $KICK_PENDING_BAN([stl $bmask]) $reason
    unset KICK_PENDING_BAN([stl $bmask])
  } elseif {[nick] != [my_nick]} {
    regsub -all {\|} $bmask \\\| btmp
    regsub -all {\{} $btmp \\\{ btmp
    regsub -all {\}} $btmp \\\} btmp
    regsub -all {\[} $btmp \\\[ btmp
    regsub -all {\]} $btmp \\\] btmp
    regsub -all {\^} $btmp \\\^ btmp
    if {([string match $btmp [my_nick]![my_user]@[my_host]] || [string match $btmp [my_nick]![get_ial [my_nick]]]) && [get_tog "Self_Ban_Protection"] == "on"} {
      /quote KICK $chan [nick] :[b]s[b]in[u]([u]ban protection[u])[u]
    } elseif [isin [getlevel [userfile] [gethand [userfile] $bmask] $chan] "p"] {
      /quote MODE $chan -ob [nick] $bmask
    }
  }
}
on mode-o {
  set chan [lindex [args] 0]
  set nick [lindex [args] 1]
  if {[strcmpi [nick] [my_nick]] != 0} {
    set uhost [get_ial $nick]
    if ![string length $uhost] { set uhost "*@*" }
    set lev [getlevel [userfile] [gethand [userfile] ${nick}!$uhost] $chan]
    if {[isin $lev "o"] || [isin $lev "p"] && [strcmpi [nick] $nick] != 0} {
      if [lfind [ops $chan] [nick]] {
        set mode "+o-o $nick [nick]"
      } {
        set mode "+o [nick]"
      }
      /quote MODE $chan $mode
    }
    unset lev
  }
}
on mode {
  set chan [lindex [args] 0]
  set mode [join [lrange [args] 1 end]]
  if [ischan $chan] {
    set chan [fixchan $chan]
    set mmode [lindex $mode 0]
    set mmode [replace $mmode "v" ""]
    set mmode [replace $mmode "o" ""]
    set mmode [replace $mmode "b" ""]
    set mmode [modmode [lindex [mode $chan] 0] $mmode]
    set CHAN_INFO([stl $chan]:mode) $mmode
    if {[nick] != ""} {
      set out [defmodeText $chan [nick] [user] [host] $mode]
      echo $out channel $chan
    } {
      set out [servermodeText $chan [host] $mode]
      echo $out channel $chan
    }
    window set_title [chanWindow $chan $CHAN_INFO([stl $chan]:mode) $CHAN_INFO([stl $chan]:key) $CHAN_INFO([stl $chan]:lim) [topic $chan]] channel $chan
  } {
    set USER_INFO(modes) [modmode $USER_INFO(modes) $mode]
    set out [selfmodeText $mode $USER_INFO(modes)]
    window set_title [statusWindow [my_nick] $USER_INFO(modes)] status
    echo $out status
  }
}
on mode+k {
  set chan [lindex [args] 0]
  set key [join [lrange [args] 1 end]]
  set CHAN_INFO([stl $chan]:key) $key
  window set_title [chanWindow $chan $CHAN_INFO([stl $chan]:mode) $key $CHAN_INFO([stl $chan]:lim) [topic $chan]] channel $chan
}
on mode-k {
  set chan [lindex [args] 0]
  set CHAN_INFO([stl $chan]:key) ""
  window set_title [chanWindow $chan $CHAN_INFO([stl $chan]:mode) "" $CHAN_INFO([stl $chan]:lim) [topic $chan]] channel $chan
}
on mode+l {
  set chan [lindex [args] 0]
  set lim [lindex [args] 1]
  set CHAN_INFO([stl $chan]:lim) $lim
  window set_title [chanWindow $chan $CHAN_INFO([stl $chan]:mode) $CHAN_INFO([stl $chan]:key) $lim [topic $chan]] channel $chan
}
on mode-l {
  set chan [lindex [args] 0]
  set CHAN_INFO($chan:lim) ""
  window set_title [chanWindow $chan $CHAN_INFO([stl $chan]:mode) $CHAN_INFO([stl $chan]:key) "" [topic $chan]] channel $chan
}
on topic {
  set chan [fixchan [lindex [args] 0]]
  set topic [join [lrange [args] 1 end]]
  set CHAN_INFO([stl $chan]:topic) $topic
  echo [deftopicText $chan [nick] [user] [host] $topic] channel $chan
  window set_title [chanWindow $chan $CHAN_INFO([stl $chan]:mode) $CHAN_INFO([stl $chan]:key) $CHAN_INFO([stl $chan]:lim) $CHAN_INFO([stl $chan]:topic)] channel $chan
  complete
}
on privmsg {
  set dest [lindex [args] 0]
  set text [join [lrange [args] 1 end]]
  set texthigh 0
  set list [get_tog "Highlight"]
  set nik_list [get_tog "Highlight_Nicks"]
  if ![strcmpi [get_tog "Beep_On_Highlight"] "on"] { set bonh 1 } { set bonh 0 }
  if [string match "*[stl [my_nick]]*" [stl $text]] {
    set texthigh 1
    if $bonh { beep }
  } {
    if {[lfind $nik_list [nick]] && [ischan $dest]} { set texthigh 1; if $bonh { beep } }
    if {[string compare [stl $list] "\001none\001"] != 0 && [string length $list]} {
      foreach i $list { if [string match "*[stl $i]*" [stl $text]] { set texthigh 1; if $bonh { beep }; break } }
    }
  }
  if [info exists i] { unset i }
  unset list bonh
  if {[ischan $dest] && [onchan [my_nick] $dest]} {
    if [isignored [nick]![user]@[host] public] {
      complete; return
    }
    if [string length [flood_setting]] {
      if ![info exists FLOOD_SPOOL(chan:[user]@[host])] {
        set FLOOD_SPOOL(chan:[user]@[host]) 1
        set tm_info [get_cookie "FP[flood_setting]"]
        set del [lindex [split $tm_info ","] 1]
        if ![isint $del] { set del 20 }
        sStartTimer 1 $del "deFlood chan:[user]@[host]"
      } {
        if {$FLOOD_SPOOL(chan:[user]@[host]) > [lindex [split [get_cookie "FP[flood_setting]"] ","] 0]} {
          echo [chanfloodText [nick] [user] [host] $dest]
          /ignore -upnct15 [mask "[nick]![user]@[host]" 1]
          complete; return
        } {
          incr FLOOD_SPOOL(chan:[user]@[host]) 1
        }
      }
    }
    set chan [fixchan $dest]
    if {![string compare [string range $text 0 4] ".\004:\004."] && ![string compare [stl [get_tog "Auto_Decrypt"]] "on"]} {
      set key [get_tog "Crypt_Key"]
      set dest [lindex [args] 0]
      echo [defautodecrypted $dest [nick] [user] [host] [decrypt [string range $text 5 end] $key]] channel $dest
      unset key dest chan text
      complete; return
    }
    set BASECOLOR "[c][colr text]"
    if $texthigh {
      set out [highlightText $dest [nick] [user] [host] $text]
    } {
      set out [defchanText $dest [nick] [user] [host] $text]
    }
    set d1 "channel"; set d2 $dest
    if ![info exists SAID_SPOOL([stl $dest]:[stl [nick]])] {
      set SAID_SPOOL([stl $dest]:[stl [nick]]) $out
    } {
      set SAID_SPOOL([stl $dest]:[stl [nick]]) "$SAID_SPOOL([stl $dest]:[stl [nick]])\n$out"
    }
    if ![info exists RDISP_SPOOL([stl $dest])] { set RDISP_SPOOL([stl $dest]) 1 } elseif {$RDISP_SPOOL([stl $dest]) < 50} { incr RDISP_SPOOL([stl $dest]) }
    set ad 0
    for {set x 0} {$x < 50} {incr x} {
      if ![info exists RDISP_SPOOL([stl $dest]:${x})] {
        set RDISP_SPOOL([stl $dest]:${x}) $out; set ad 1; break
      }
    }
    unset x
    if !$ad {
      for {set x 0} {$x < 49} {incr x} {
        set RDISP_SPOOL([stl $dest]:${x}) $RDISP_SPOOL([stl $dest]:[expr $x+1])
      }
      set RDISP_SPOOL([stl $dest]:49) $out
      unset x
    }
    unset ad
  } {
    if [isignored [nick]![user]@[host] private] {
      complete; return
    }
    if [string length [flood_setting]] {
      if ![info exists FLOOD_SPOOL(priv:[user]@[host])] {
        set FLOOD_SPOOL(priv:[user]@[host]) 1
        set tm_info [get_cookie "FQ[flood_setting]"]
        set del [lindex [split $tm_info ","] 1]
        if ![isint $del] { set del 20 }
        sStartTimer 1 $del "deFlood priv:[user]@[host]"
      } {
        if {$FLOOD_SPOOL(priv:[user]@[host]) > [lindex [split [get_cookie "FQ[flood_setting]"] ","] 0]} {
          echo [privfloodText [nick] [user] [host]]
          /ignore -pnct15 [mask "[nick]![user]@[host]" 1]
          complete; return
        } {
          incr FLOOD_SPOOL(priv:[user]@[host]) 1
        }
      }
    }
    if {![string compare [string range $text 0 4] ".\004:\004."] && ![string compare [stl [get_tog "Auto_Decrypt"]] "on"]} {
      set key [get_tog "Crypt_Key"]
      set dest [lindex [args] 0]
      if {![window exists query [nick]] && [string compare [stl [get_tog "Query"]] "off"] != 0} { /query [nick] }
      if [window exists query [nick]] { echo [defqueryautodecrypted $dest [nick] [user] [host] [decrypt [string range $text 5 end] $key]] query [nick] } { echo [defnoqueryautodecrypted $dest [nick] [user] [host] [decrypt [string range $text 5 end] $key]] }
      unset dest key text
      complete; return
    }
    if [string length [nick]] {
      if [info exists TAB_CYC] { if ![lfind $TAB_CYC [nick]] { lappend TAB_CYC [stl [nick]] } } { set TAB_CYC [stl [nick]] }
      if [info exists TAB_REP] {
        set mx [get_tog "Max_Tab"]
        if {[isint $mx] && [llength [array names TAB_REP]] >= $mx} {
          set rem [lindex $TAB_CYC 0]
          set TAB_CYC [lreplace $TAB_CYC 0 0]
          if [info exists TAB_REP($rem)] { unset TAB_REP($rem) }
        }
      }
      set TAB_IDX [nick]
      set TAB_REP([stl [nick]]) "/msg [nick] "
    }
    if {[away] && ![string compare [stl [get_tog "Away_Logging"]] "on"] && [string compare [stl [nick]] [stl [my_nick]]] != 0 && [string length [nick]]} {
      if ![info exists AWAY_INFO(msgs)] { set AWAY_INFO(msgs) 1 } { incr AWAY_INFO(msgs) }
      hand_log "PRIVMSG" $AWAY_INFO(msgs) $dest [nick] [user] [host] $text
      if ![info exists AWAY_NICKS([stl [user]@[host]])] {
        set not [awaynoticestyle $AWAY_INFO(msgs) $dest [nick] [user] [host] $text]
        if [string length $not] { /quote NOTICE [nick] :$not }
        unset not
      }
      set AWAY_NICKS([stl [user]@[host]]) 1
    }
    if {[stl [get_tog Query]] != "off" && ![window exists query [nick]]} { /query [nick] }
    if [window exists query [nick]] {
      set BASECOLOR "[c][colr querytext]"
      if $texthigh {
        set out [highlightText $dest [nick] [user] [host] $text]
      } {
        set out [defqueryText $dest [nick] [user] [host] $text]
      }
      set d1 "query"; set d2 [nick]
      window set_title [queryWindow [nick] [user] [host]] query [nick]
    } {
      set BASECOLOR "[c][colr noquerytext]"
      if $texthigh {
        set out [highlightnoqueryText $dest [nick] [user] [host] $text]
      } {
        set out [defnoqueryText $dest [nick] [user] [host] $text]
      }
      set d1 [window_type]; set d2 [window_name]
    }
    if ![string compare [stl [get_tog "Beep_On_Text"]] "on"] { beep }
  }
  echo $out $d1 $d2
  unset dest text out BASECOLOR d1 d2 texthigh
}
on join {
  set chan [lindex [args] 0]
  if ![string compare [stl [nick]] [stl [my_nick]]] {
    set BLOCK_BAN_LIST([stl $chan]) 1
    if {[stl [get_tog "Personal_Logging"]] == "on"} {
      set x [replace [get_tog "Personal_Log"] "\\" "/"]
      if ![file exists [dirname $x]] {
        file mkdir [dirname $x]
      }
      if ![file exists $x] {
        filebuild $x
      }
      set f [open $x a]
      puts $f "\[[atime "am" "pm"]:[adate]\] You joined $chan on [serv]"
      catch {flush $f}; catch {close $f}
      unset f x
    }
    set CHAN_INFO([stl $chan]:mode) ""
    set CHAN_INFO([stl $chan]:key) ""
    set CHAN_INFO([stl $chan]:lim) ""
    set CHAN_INFO([stl $chan]:topic) ""
    if [tog_on "Auto_IALScan"] { /scan IAL $chan }
  }
  set chan [fixchan $chan]
  set hand [gethand [userfile] [nick]![user]@[host]]
  if [string length $hand] {
    set flags [getlevel [userfile] $hand $chan]
    if [isin $flags "b"] { /quote MODE $chan -o+b [nick] [mask [nick]![user]@[host] 3] }
    if [isin $flags "k"] { /quote KICK $chan [nick] :[b]S[b]in[u]([u][b]a[b]uto-[b]k[b]ick[u])[u] }
    if [isin $flags "o"] { /quote MODE $chan +o [nick] }
    if [isin $flags "v"] { /quote MODE $chan +v [nick] }
    unset flags
  }
  unset hand
  set out [defjoinText $chan [nick] [user] [host]]
  if {[window exists channel $chan] && [stl [get_tog "JoinsInChan"]] == "on"} {
    echo $out channel $chan
  } {
    if {[stl [nick]] != [stl [my_nick]]} {
      echo $out status
    }
  }
  unset out chan
}
on part {
  set chan [lindex [args] 0]
  set chan [fixchan $chan]
  set msg [lindex [args] 1]
  set out [defpartText $chan [nick] [user] [host] $msg]
  if {[stl [nick]] == [stl [my_nick]]} {
    set CHAN_INFO([stl $chan]:mode) ""
    set CHAN_INFO([stl $chan]:key) ""
    set CHAN_INFO([stl $chan]:lim) ""
    set CHAN_INFO([stl $chan]:topic) ""
    unset CHAN_INFO([stl $chan]:mode) CHAN_INFO([stl $chan]:key) CHAN_INFO([stl $chan]:lim) CHAN_INFO([stl $chan]:topic)
    if {[stl [get_tog "Personal_Logging"]] == "on"} {
      set x [replace [get_tog "Personal_Log"] "\\" "/"]
      if ![file exists [dirname $x]] {
        file mkdir [dirname $x]
      }
      if ![file exists $x] {
        filebuild $x
      }
      set f [open $x a]
      puts $f "\[[atime "am" "pm"]:[adate]\] You parted $chan on [serv]"
      catch {flush $f}; catch {close $f}
      unset f x
    }
  }
  if {[window exists channel $chan] && [stl [get_tog "PartsInChan"]] == "on"} {
    echo $out channel $chan
  } {
    if {[stl [nick]] != [stl [my_nick]]} {
      echo $out status
    }
  }
  unset out chan
}
on quit {
  set q_msg [join [args]]
  set q_msg $q_msg[o]
  set BASECOLOR "[c][colr quit]"
  if {[stl [nick]] == [stl [my_nick]]} {
    if [info exists CHAN_INFO] { unset CHAN_INFO }
    if [info exists IAL] { unset IAL }
    if {[stl [get_tog "Personal_Logging"]] == "on"} {
      set x [get_tog "Personal_Log"]
      if ![file exists [dirname $x]] {
        file mkdir [dirname $x]
      }
      if ![file exists $x] {
        filebuild $x
      }
      set f [open $x a]
      puts $f "\[[atime "am" "pm"]:[adate]\] You signed off of [serv]"
      catch {flush $f}; catch {close $f}
      unset f x
    }
  }
  set out [defquitText [nick] [user] [host] $q_msg]
  if [tog_on "QuitsInChan"] {
    foreach c [com_chans [nick]] {
      echo $out channel $c
      unset c
    }
    if ![string length [com_chans [nick]]] {
      echo $out status
    }
  } {
    echo $out status
  }
  if [window exists query [nick]] { echo $out query [nick] }
  unset q_msg out BASECOLOR
}
on nick {
  set newnick [lindex [args] 0]
  if [window exists query [nick]] {
    window set_title [queryWindow $newnick [user] [host]] query [nick]
  }
  if {[nick] != [my_nick]} {
    set out [defnickText [nick] [user] [host] $newnick]
  } {
    if [info exists REGAIN_NICK_START] {
      if ![strcmpi $REGAIN_NICK_START $newnick] {
        echo [regainnickfinEcho $newnick "obtained nickname"]
        unset REGAIN_NICK_START REGAIN_NICK_TIMER REGAIN_NICK_TIMES REGAIN_NICK_CYCLES
      }
    } elseif [info exists REGAIN_NICK] {
      if ![strcmpi $REGAIN_NICK $newnick] {
        echo [regainnickfinEcho $newnick "obtained nickname"]
        unset REGAIN_NICK REGAIN_NICK_TIMES
      }
    }
    if ![info exists USER_INFO(modes)] { set USER_INFO(modes) [mode] }
    window set_title [statusWindow $newnick $USER_INFO(modes)] status
    set out [selfnickText [nick] [user] [host] $newnick]
    if {[stl [get_tog "Personal_Logging"]] == "on"} {
      set x [get_tog "Personal_Log"]
      if ![file exists [dirname $x]] {
        file mkdir [dirname $x]
      }
      if ![file exists $x] {
        filebuild $x
      }
      set f [open $x a]
      puts $f "\[[atime "am" "pm"]:[adate]\] You changed your nick from [nick] to $newnick on [serv]"
      catch {flush $f}; catch {close $f}
      unset f x
    }
  }
  if {[com_chans [nick]] != ""} {
    foreach c [com_chans [nick]] {
      echo $out channel $c
    }
  } {
    echo $out status
  }
  unset newnick out
}
on kick {
  set dest [lindex [args] 0]
  set dest [fixchan $dest]
  set knick [lindex [args] 1]
  set reason [join [lrange [args] 2 end]]
  set BASECOLOR "[c][colr kick]"
  echo [defkickText $dest [nick] [user] [host] $knick $reason] channel $dest
  if ![string compare [stl $knick] [stl [my_nick]]] {
    echo [selfkickText $dest [nick] [user] [host] $knick $reason] status
    if {[string compare [stl [nick]] [stl [my_nick]]] != 0} {
      set KICK_TRAQ([stl $dest]) "[nick],[clock seconds]"
      set KICK_TRAQ(DO_MENU) 1
    }
    if {[stl [get_tog "Personal_Logging"]] == "on"} {
      set x [get_tog "Personal_Log"]
      if ![file exists [dirname $x]] {
        file mkdir [dirname $x]
      }
      if ![file exists $x] {
        filebuild [get_tog "Personal_Log"]
      }
      set f [open $x a]
      puts $f "\[[atime "am" "pm"]:[adate]\] You were kicked from $dest by [nick] ($reason) on [serv]"
      catch {flush $f}; catch {close $f}
      unset f x
    }
  } elseif {[string compare [stl [nick]] [stl [my_nick]]] != 0} {
    set uhost [get_ial $knick]
    if ![string length $uhost] { set uhost "*@*" }
    set lev [getlevel [userfile] [gethand [userfile] ${knick}!$uhost] $dest]
    if {[isin $lev "p"] && [string compare [stl $knick] [stl [nick]]] != 0} {
      /quote KICK $dest [nick] :[b]s[b]in[u]([u]$knick is [b]pro[b]tected[u])[u]
    }
    unset lev
  }
  unset dest knick reason BASECOLOR
}
on notice {
  if [isignored [nick]![user]@[host] notice] { complete; return }
  set BASECOLOR "[c][colr notice]"
  set dest [lindex [args] 0]  
  set text [lindex [args] 1]
  if ![string compare [string index $dest 0] "@"] {
    set dest [string range $dest 1 end]
    set dest [fixchan $dest]
    if [onchan [my_nick] $dest] {
      echo [wallchopsText $dest [nick] [user] [host] $text] channel $dest
    } {
      echo [wallchopsText $dest [nick] [user] [host] $text] status
    }
    unset text dest
    if [string length [flood_setting]] {
      if ![info exists FLOOD_SPOOL(chan:[user]@[host])] {
        set FLOOD_SPOOL(chan:[user]@[host]) 1
        set tm_info [get_cookie "FP[flood_setting]"]
        set del [lindex [split $tm_info ","] 1]
        if ![isint $del] { set del 20 }
        sStartTimer 1 $del "deFlood chan:[user]@[host]"
      } {
        if {$FLOOD_SPOOL(chan:[user]@[host]) > [lindex [split [get_cookie "FP[flood_setting]"] ","] 0]} {
          echo [chanfloodText [nick] [user] [host] $dest]
          /ignore -unpct15 [mask "[nick]![user]@[host]" 1]
          complete; return
        } {
          incr FLOOD_SPOOL(chan:[user]@[host]) 1
        }
      }
    }
  } {
    set d1 ""; set d2 ""
    if [ischan $dest] {
      if [string length [flood_setting]] {
        if ![info exists FLOOD_SPOOL(chan:[user]@[host])] {
          set FLOOD_SPOOL(chan:[user]@[host]) 1
          set tm_info [get_cookie "FP[flood_setting]"]
          set del [lindex [split $tm_info ","] 1]
          if ![isint $del] { set del 20 }
          sStartTimer 1 $del "deFlood chan:[user]@[host]"
        } {
          if {$FLOOD_SPOOL(chan:[user]@[host]) > [lindex [split [get_cookie "FP[flood_setting]"] ","] 0]} {
            echo [chanfloodText [nick] [user] [host] $dest]
            /ignore -unpct15 [mask "[nick]![user]@[host]" 1]
            complete; return
          } {
            incr FLOOD_SPOOL(chan:[user]@[host]) 1
          }
        }
      }
      set dest [fixchan $dest]
      set d1 channel; set d2 $dest
      if [string length [nick]] {
        set out [channoticeText $dest [nick] [user] [host] $text]
      } {
        if [string length [host]] { set out [serverchannoticeText $dest [host] $text] } { set out [nohostnoticeText $dest $text] }
      }
    } {
      if [string length [flood_setting]] {
        if ![info exists FLOOD_SPOOL(priv:[user]@[host])] {
          set FLOOD_SPOOL(priv:[user]@[host]) 1
          set tm_info [get_cookie "FQ[flood_setting]"]
          set del [lindex [split $tm_info ","] 1]
          if ![isint $del] { set del 20 }
          sStartTimer 1 $del "deFlood priv:[user]@[host]"
        } {
          if {$FLOOD_SPOOL(priv:[user]@[host]) > [lindex [split [get_cookie "FQ[flood_setting]"] ","] 0]} {
            echo [privfloodText [nick] [user] [host]]
            /ignore -unpct15 [mask "[nick]![user]@[host]" 1]
            complete; return
          } {
            incr FLOOD_SPOOL(priv:[user]@[host]) 1
          }
        }
      }
      if {[pos $text "#"] > -1 || ([pos $text "&"] > -1 && [pos $text "#"] == -1)} {
        set idx [pos $text "#"]; set lead "#"
        if {$idx < 0} { set idx [pos $text "&"]; set lead "&" }
        set ch ""
        set brk 0
        while {!$brk} {
          incr idx
          set y [string index $text $idx]
          if [isalphanumeric $y] { set ch ${ch}${y} } { set brk 1 }
        }
        set ch "${lead}${ch}"
        if [lfind [channels] $ch] {
          echo [defnoticeText $dest [nick] [user] [host] $text] channel $ch
          complete; return
        }
      }
      if {[away] && [stl [get_tog "Away_Logging"]] == "on" && [stl [nick]] != [stl [my_nick]] && [string length [nick]]} {
        if ![info exists AWAY_INFO(msgs)] { set AWAY_INFO(msgs) 1 } { incr AWAY_INFO(msgs) }
        hand_log "NOTICE" $AWAY_INFO(msgs) $dest [nick] [user] [host] $text
        set not [awaynoticestyle $AWAY_INFO(msgs) $dest [nick] [user] [host] $text]
        if ![info exists AWAY_NICKS([stl [user]@[host]])] {
          set not [awaynoticestyle $AWAY_INFO(msgs) $dest [nick] [user] [host] $text]
          if [string length $not] { /quote NOTICE [nick] :$not }
          unset not
        }
        set AWAY_NICKS([stl [user]@[host]]) 1
      }
      if {[nick] != ""} {
        set d1 [window_type]; set d2 [window_name]
        set out [defnoticeText $dest [nick] [user] [host] $text]
      } {
        set d1 status; set d2 ""
        if {[host] != ""} {
          set out [servernoticeText $dest [host] $text]
        } {
          set out [nohostnoticeText $dest $text]
        }
      }
    }
    echo $out $d1 $d2
    unset out d1 d2 dest text
  }
  unset BASECOLOR
}
on ctcp {
  set dest [lindex [args] 0]
  set type [lindex [args] 1]
  set rest [string range [join [args]] [expr [string length "$dest $type"]+1] end]
  set type [string toupper $type]
  set reply ""
  if {![strcmpi $type "ACTION"] && ![string length [replace $rest " " ""]]} { complete; return }
  if {[string compare $type "ACTION"] != 0 && [string compare $type "DCC"] != 0} {
    if [isignored [nick]![user]@[host] ctcp] { complete; return }
    if [string length [flood_setting]] {
      if ![info exists FLOOD_SPOOL(ctcp:[user]@[host])] {
        set FLOOD_SPOOL(ctcp:[user]@[host]) 1
        set tm_info [get_cookie "FC[flood_setting]"]
        set del [lindex [split $tm_info ","] 1]
        if ![isint $del] { set del 20 }
        sStartTimer 1 $del "deFlood ctcp:[user]@[host]"
      } {
        if {$FLOOD_SPOOL(ctcp:[user]@[host]) > [lindex [split [get_cookie "FC[flood_setting]"] ","] 0]} {
          echo [ctcpfloodText [nick] [user] [host]]
          /ignore -npcdt15 [mask "[nick]![user]@[host]" 1]
          complete; return
        } {
          incr FLOOD_SPOOL(ctcp:[user]@[host]) 1
        }
      }
    }
  } elseif ![string compare $type "DCC"] {
    if [isignored [nick]![user]@[host] dcc] { complete; return }
    if [string length [flood_setting]] {
      if ![info exists FLOOD_SPOOL(ctcp:[user]@[host])] {
        set FLOOD_SPOOL(ctcp:[user]@[host]) 1
        set tm_info [get_cookie "FC[flood_setting]"]
        set del [lindex [split $tm_info ","] 1]
        if ![isint $del] { set del 20 }
        sStartTimer 1 $del "deFlood ctcp:[user]@[host]"
      } {
        if {$FLOOD_SPOOL(ctcp:[user]@[host]) > [lindex [split [get_cookie "FC[flood_setting]"] ","] 0]} {
          echo [ctcpfloodText [nick] [user] [host]]
          /ignore -npcdt15 [mask "[nick]![user]@[host]" 1]
          complete; return
        } {
          incr FLOOD_SPOOL(ctcp:[user]@[host]) 1
        }
      }
    }
  } elseif ![string compare $type "ACTION"] {
    if [ischan $dest] {
      if [isignored [nick]![user]@[host] public] { complete; return }
      if [string length [flood_setting]] {
        if ![info exists FLOOD_SPOOL(chan:[user]@[host])] {
          set FLOOD_SPOOL(chan:[user]@[host]) 1
          set tm_info [get_cookie "FP[flood_setting]"]
          set del [lindex [split $tm_info ","] 1]
          if ![isint $del] { set del 20 }
          sStartTimer 1 $del "deFlood chan:[user]@[host]"
        } {
          if {$FLOOD_SPOOL(chan:[user]@[host]) > [lindex [split [get_cookie "FP[flood_setting]"] ","] 0]} {
            echo [chanfloodText [nick] [user] [host] $dest]
            /ignore -unpct15 [mask "[nick]![user]@[host]" 1]
            complete; return
          } {
            incr FLOOD_SPOOL(chan:[user]@[host]) 1
          }
        }
      }
    } {
      if [isignored [nick]![user]@[host] private] { complete; return }
      if [string length [flood_setting]] {
        if ![info exists FLOOD_SPOOL(priv:[user]@[host])] {
          set FLOOD_SPOOL(priv:[user]@[host]) 1
          set tm_info [get_cookie "FQ[flood_setting]"]
          set del [lindex [split $tm_info ","] 1]
          if ![isint $del] { set del 20 }
          sStartTimer 1 $del "deFlood priv:[user]@[host]"
        } {
          if {$FLOOD_SPOOL(priv:[user]@[host]) > [lindex [split [get_cookie "FQ[flood_setting]"] ","] 0]} {
            echo [privfloodText [nick] [user] [host]]
            /ignore -unpct15 [mask "[nick]![user]@[host]" 1]
            complete; return
          } {
            incr FLOOD_SPOOL(priv:[user]@[host]) 1
          }
        }
      }
    }
    set rest [replace $rest "[o]" "[o][c][colr action]"]
  }
  if {($type != "PAGE" && $type != "ACTION" && $type != "DCC" && [stl [get_tog "Cloak_CTCP"]] != "on" && $type != "SOUND") || ($type == "SOUND" && [stl [get_tog "Sound_System"]] == "off")} {
    if [ischan $dest] {
      echo [chanctcpText $dest [nick] [user] [host] $type $rest] channel $dest
    } {
      echo [defctcpText $dest [nick] [user] [host] $type $rest]
    }
    if {[strcmpi $type "sound"] != 0 && ![strcmpi [get_tog "Auto_CTCP"] "on"] && [strcmpi [nick] [my_nick]] != 0} {
      if ![strcmpi $type "ping"] { set peices [clock clicks] } { set peices "" }
      if ![string length $rest] { /quote PRIVMSG [nick] :\001${type}\001 } { /quote PRIVMSG [nick] :\001${type} $peices\001 }
      echo [selfctcpText [nick] $type $peices]
      unset peices
    }
  }
  if {[stl [get_tog "Cloak_CTCP"]] == "on" && $type != "ACTION" && $type != "DCC"} {
    if [ischan $dest] {
      echo [chanctcpText $dest [nick] [user] [host] $type $rest] status
    } {
      echo [defctcpText $dest [nick] [user] [host] $type $rest] status
    }
    complete
    return
  }
  if {$type == "DCC" && [stl [get_tog "Cloak_DCC"]] == "on"} {
    if [ischan $dest] {
      echo [chanctcpText $dest [nick] [user] [host] $type $rest] status
    } {
      echo [defctcpText $dest [nick] [user] [host] $type $rest] status
    }
    complete
    return
  }
  set tmp $rest
  set tmp [replace $tmp "\{" "\\\{"]
  set tmp [replace $tmp "\}" "\\\}"]
  set tmp [replace $tmp "\"" "\\\""]
  set sub_type [stu [lindex $tmp 0]]
  if {$type != "DCC" || ($type == "DCC" && $sub_type != "CHAT" && $sub_type != "SEND" && $sub_type != "TSEND" && $sub_type != "ACCEPT" && $sub_type != "RESUME")} {
    switch -- $type {
      "DCC" {
        echo [defctcpText $dest [nick] [user] [host] $type $rest]
        set reply ""
      }
      "VERSION" {
        if [info exists sin_zero(version)] {
          set reply $sin_zero(version)
        } {
          set reply "Sin[b]([b]zero[u]/[u]2.3[b])[b]
        }
      }
      "TIME" {
        set m [clock format [clock seconds] -format %H]
        if {$m >= 12} { set m "afternoon" } { set m "morning" }
        set d [clock format [clock seconds] -format %A]
        set reply "$d $m [clock format [clock seconds] -format "%B %d %Y - %r"]"
        unset d m
      }
      "PING" {
        set reply $rest
      }
      "FINGER" {
        set reply "[my_nick] ([info hostname]): $sin_zero(version)"
      }
      "CLIENTINFO" {
        set reply "Sin[b]([b]zero[u]/[u]$sin_zero(truevers)[b]) \[[b]$sin_zero(b_date)[b]\][b]"
      }
      "PAGE" {
        if {[stl [get_tog "Paging"]] == "on"} {
          if ![string length [join $rest]] {
            set p_reason "[b]no reason[b]"
          } {
            set p_reason $rest
          }
          set pfile [get_tog "Page_File"]
          set pfile [filefix $pfile]
          set sdir [replace [get_tog "SoundDir"] "\\" "/"]
          if {[string range $sdir end end] != "/"} {
            set sdir $sdir/
          }
          echo [pagerView $dest [nick] [user] [host] $p_reason]
          if {[window state main] == "minimize"} { window restore main }
          window focus main
          if [file exists $pfile] {
            mmplay $pfile
          } elseif [file exists [pwd]/$pfile] {
            mmplay [pwd]/$pfile
          } elseif [file exists $sdir$pfile] {
            mmplay $sdir$pfile
          } {
            beep
          }
          set x [get_tog "Page_Log"] 
          if ![file exists [dirname $x]] {
            file mkdir [dirname $x]
          }
          if ![file exists $x] {
            filebuild $x
          }
          set f $x
          set x [open $f a+]
          if [string length [join $rest]] {
            set end " \[$rest\]"
          } {
            set end ""
          }
          puts $x "- \[[atime "am" "pm" 1]\] PAGE($dest)>> [nick] ([user]@[host])$end -"
          catch {flush $x}
          catch {close $x}
          catch {unset x f end p_reason}
          complete; return
        } {
          if [ischan $dest] {
            echo [chanctcpText $dest [nick] [user] [host] $type $rest] channel $dest
          } {
            echo [defctcpText $dest [nick] [user] [host] $type $rest]
          }
        }
      }
      "ACTION" {
        if [string length $rest] {
        set BASECOLOR "[c][colr action]"
        if ![ischan $dest] {
          if {[away] && [stl [get_tog "Away_Logging"]] == "on" && [stl [nick]] != [stl [my_nick]]} {
            if ![file exists [dirname [get_tog "Away_Log"]]] {
              file mkdir [file dirname [get_tog "Away_Log"]]
            }
            if ![file exists [get_tog "Away_Log"]] {
              filebuild [get_tog "Away_Log"]
            }
            if ![info exists AWAY_INFO(msgs)] {
              set AWAY_INFO(msgs) 1
            } {
              incr AWAY_INFO(msgs)
            }
            hand_log "ACTION" $AWAY_INFO(msgs) $dest [nick] [user] [host] $rest
            set not [awaynoticestyle $AWAY_INFO(msgs) $dest [nick] [user] [host] $rest]
            if [string length $not] { /quote NOTICE [nick] :$not }
            unset not
          }
          if {![strcmpi [get_tog Query] "on"] && ![window exists query [nick]]} { /query [nick] }
          if [window exists query [nick]] {
            set d1 "query"; set d2 [nick]
            set out [defqueryAction $dest [nick] [user] [host] $rest]
          } {
            set d1 [window_type]; set d2 [window_name]
            set out [defnoqueryAction $dest [nick] [user] [host] $rest]
          }
        } {
          set d1 "channel"; set d2 $dest
          set out [defchanAction $dest [nick] [user] [host] $rest]
        }
        echo $out $d1 $d2
        unset BASECOLOR
        } {
          if [ischan $dest] {
            echo [chanctcpText $dest [nick] [user] [host] "ACTION" ""]
          } {
            echo [defctcpText $dest [nick] [user] [host] "ACTION" ""]
          }
        }
        set reply ""
      }
      "SOUND" {
        if {[string compare [stl [get_tog "Sound_System"]] "off"] != 0} {
          set text ""
          set sound ""
          if {[llength $rest] > 1} {
            set sound [lindex $rest 0]
            set text [join [lrange $rest 1 end]]
          } {
            set sound $rest
            set text ""
          }
          if [string length $sound] {
          set sound [replace $sound "\\" "/"]
          if {[pos $sound "/"] != -1} {
            set sound [string range $sound [expr [string last "/" $sound]+1] end]
          }
          if {[ischan $dest] && $text != ""} {
            set soundproc "defchantextSound"
            set d1 "channel"
            set d2 $dest
          } elseif [ischan $dest] {
            set soundproc "defchannotextSound"
            set d1 "channel"
            set d2 $dest
          }
          if {![ischan $dest] && [string length [join $text]]} {
            if {[stl [get_tog "Query"]] != "off"} {
              if ![window exists query [nick]] {
                /query [nick]
              }
              set soundproc "defquerytextSound"
              set d1 "query"
              set d2 [nick]
            } elseif [window exists query [nick]] {
              set soundproc "defquerytextSound"
              set d1 "query"
              set d2 [nick]
            } {
              set soundproc "defnoquerytextSound"
              set d1 [window_type]
              set d2 [window_name]
            }
          } elseif ![ischan $dest] {
            if {[stl [get_tog "Query"]] != "off"} {
              if ![window exists query [nick]] {
                /query [nick]
              }
              set soundproc "defquerynotextSound"
              set d1 "query"
              set d2 [nick]
            } elseif [window exists query [nick]] {
              set soundproc "defquerynotextSound"
              set d1 "query"
              set d2 [nick]
            } {
              set soundproc "defnoquerynotextSound"
              set d1 [window_type]
              set d2 [window_name]
            }
          }
          if [string length [join $text]] {
            echo [$soundproc $dest [nick] [user] [host] $sound $text] $d1 $d2
          } {
            echo [$soundproc $dest [nick] [user] [host] $sound] $d1 $d2
          }
          if [file exists [pwd]/$sound] {
            mmplay [pwd]/$sound
          } {
            set soundDir [replace [get_tog "SoundDir"] "\\" "/"]
            if ![file isdir $soundDir] { set soundDir "[pwd]/" }
            if {[string index $soundDir [expr [string length $soundDir]-1]] != "/"} {
              set soundDir $soundDir/
            }
            if [file exists $soundDir$sound] {
              mmplay $soundDir$sound
            } elseif {[stl [get_tog "Sound_Recursion"]] == "on"} {
              set fsound [filefind $sound 1 $soundDir]
              if {$fsound != ""} {
                mmplay $fsound
              }
              unset fsound
            }
            unset soundDir
          }
          unset sound soundproc text d1 d2
          } {
            if [ischan $dest] {
              echo [chanctcpText $dest [nick] [user] [host] "SOUND" ""]
            } {
              echo [defctcpText $dest [nick] [user] [host] "SOUND" ""]
            }
          }
        }
        set reply ""
      }
      default {
        set reply ""
      }
    }
    if {$reply != ""} {
      /quote NOTICE [nick] :\001$type $reply\001
    }
  }
  unset dest type rest reply sub_type
}
on ctcp_reply {
  if [isignored [nick]![user]@[host] ctcp] {
    complete; return
  }
  set dest [lindex [args] 0]
  set type [lindex [args] 1]
  set rest [join [lrange [args] 2 end]]
  set reply ""
  if {$type == "PING"} {
    if [string length $rest] {
      set 1 ""; set 2 ""
      set pos [pos $rest " "]
      if {$pos > 0} {
        set 1 [string range $rest 0 [expr $pos-1]]
      } {
        set 1 [string range $rest 0 end]
      }
      set 2 [replace $1 "\[" "\\\["]
      set 2 [replace $2 "\]" "\\\]"]
      if [string length [string trim $2 "1234567890"]] {
        set reply $rest
      } {
        if [isint $1] {
          set r [expr ([clock clicks]-$1)/1000.0]
          set reply [duration $r "wk" "day" "hr" "min" "sec" "s" " " " "]
        } {
          set reply $rest
        }
      }
    } {
      set reply $rest
    }
  } {
    set reply $rest
  }
  echo [defctcpreplyText $dest [nick] [user] [host] $type $reply]
  unset dest type rest reply
}
on wallops {
  set text [join [args]]
  if {[nick] != ""} {
    echo [defwallopText [nick] [user] [host] $text] status
  } {
    echo [serverwallopText [host] $text] status
  }
  unset text
}
on chat_accept {
  if {[user] != "" || [host] != ""} {
    window set_title [chatuserhostWindow [nick] [user] [host]] chat [nick]
  } {
    window set_title [chatWindow [nick]] chat [nick]
  }
}
on chat_connect {
  if {[user] != "" || [host] != ""} {
    if {[window get_title chat [nick]] != [chatuserhostWindow [nick] [user] [host]]} {
      window set_title [chatuserhostWindow [nick] [user] [host]] chat [nick]
    }
  } {
    if {[window get_title chat [nick]] != [chatWindow [nick]]} {
      window set_title [chatWindow [nick]] chat [nick]
    }
  }
}
on chat_text {
  set dccChattext [join [args]]
  if ![strcmpi [string range $dccChattext 0 6] "\001ACTION"] {
    set dccChattext [string range $dccChattext 8 [expr [string length $dccChattext]-2]]
    set BASECOLOR "[c][colr action]"
    echo [defchatAction [nick] $dccChattext] chat [nick]
  } {
    set BASECOLOR "[c][colr text]"
    echo [defchatText [nick] $dccChattext] chat [nick]
  }
  if {[string length [user]] || [string length [host]]} {
    set chat_window [chatuserhostWindow [nick] [user] [host]]
    if {$chat_window != [window get_title chat [nick]]} {
      window set_title $chat_window chat [nick]
    }
  } {
    set chat_window [chatWindow [nick]]
    if {$chat_window != [window get_title chat [nick]]} {
      window set_title $chat_window chat [nick]
    }
  }
  if [info exists dccChattext] { unset dccChattext }
  if [info exists chat_window] { unset chat_window }
  if [info exists BASECOLOR] { unset BASECOLOR }
}
on chat_send {
  set text [join [args]]
  if {[string toupper [string range $text 0 6]] == "\001ACTION"} {
    set text [string range $text 8 [expr [string length $text]-2]]
    set BASECOLOR "[c][colr selfaction]"
    echo [selfchatAction [nick] $text] chat [nick]
  } {
    set BASECOLOR "[c][colr selfchattext]"
    echo [selfchatText [nick] $text] chat [nick]
  }
  if {[string length [user]] || [string length [host]]} {
    set chat_window [chatuserhostWindow [nick] [user] [host]]
    if {$chat_window != [window get_title chat [nick]]} {
      window set_title [chatuserhostWindow [nick] [user] [host]] chat [nick]
    }
  } {
    set chat_window [chatWindow [nick]]
    if {$chat_window != [window get_title chat [nick]]} {
      window set_title [chatWindow [nick]] chat [nick]
    }
  }
  unset text chat_window BASECOLOR
}
on chat_disconnect {
  if ![strcmpi [get_tog "Auto_Close_Chats"] "on"] {
    window close chat [nick]
  }
  if {[window exists chat [nick]]} {
    window set_title [chatunconnectedWindow [nick]] chat [nick]
  }
}
on dcc_create {
  set type [lindex [args] 0]
  set nick [lindex [args] 1]
  set file [file tail [lindex [args] 2]]
  set size [lindex [args] 3]
  echo [dcccreateEcho $type $nick $file $size] status
  unset type nick file size
  complete
}
on dcc_begin {
  set type [lindex [args] 0]
  set nick [lindex [args] 1]
  set file [file tail [lindex [args] 2]]
  set size [lindex [args] 3]
  echo [dccbeginEcho $type $nick $file $size] status
  unset type nick file size
  complete
}
on dcc_rename {
  set type [lindex [args] 0]
  set nick [lindex [args] 1]
  set file [file tail [lindex [args] 2]]
  set size [lindex [args] 3]
  set rename [lindex [args] 4]
  echo [dccrenameEcho $type $nick $file $size $rename] status
  unset type nick file size rename
  complete
}
on dcc_complete {
  set type [lindex [args] 0]
  set nick [lindex [args] 1]
  set file [file tail [lindex [args] 2]]
  set size [lindex [args] 3]
  set speed [lindex [args] 4]
  set time [lindex [args] 5]
  echo [dcccompleteEcho $type $nick $file $size $speed $time] status
  unset type nick file size speed time
  complete
}
on dcc_error {
  set type [lindex [args] 0]
  set nick [lindex [args] 1]
  set file [file tail [lindex [args] 2]]
  set size [lindex [args] 3]
  set errn [join [lrange [args] 4 end]]
  echo [dccerrorEcho $type $nick $file $size $errn] status
  unset nick type file size errn
  complete
}
on disconnect {
  set USER_INFO(modes) ""
  set USER_INFO(online) 0
  foreach c [channels] { window set_title [chanunconnectedWindow $c] channel $c }
  
}
on connect {
  set USER_INFO(modes) ""
  set USER_INFO(online) [clock seconds]
  if [info exists UHOST_NICK_OWNED] {
    /quote USERHOST $UHOST_NICK_OWNED
  }
  if [tog_on "UserModes"] { /quote MODE [my_nick] [get_tog "UserModes"] }
  if {[string length [get_tog "Auto_Join"]] && [strcmpi [get_tog "Auto_Join"] "\001none\001"] != 0} {
    set chans [join [get_tog "Auto_Join"] ","]
    set chanlist ""
    foreach c [split $chans ","] {
      if ![window exists channel $c] {
        lappend chanlist $c
      }
    }
    if {$chanlist != ""} {
      /join [join $chanlist ","]
    }
    unset chans chanlist
  }
  if ![strcmpi [get_tog "Personal_Logging"] "on"] {
    set x [get_tog "Personal_Log"] 
    if ![file exists [dirname $x]] {
      file mkdir [dirname $x]
    }
    if ![file exists $x] {
      filebuild $x
    }
    set f [open $x a]
    puts $f "\[[atime "am" "pm"]:[adate]\] You signed on to [serv]"
    catch {flush $f}; catch {close $f}
    unset f x
  }
}
proc stylemodifiedEcho {filename} {
  return "[c]00<[c]14\[[c]15$filename style has been modified since it was last /style'd[c]14\][c]00>"
}
proc addonmodifiedEcho {filename} {
  return "[c]00<[c]14\[[c]15[file tail $filename] addon has been modified, Sin(zero) needs to be reloaded. [c]14\][c]00>"
}
proc autostylingEcho {filename} {
  return "[c]14>[c]15>[c]00>[c]15 Auto-reloading Style file $filename [c]14.[c]15.[c]00."
}
on timer {
  if [info exists ADDON_LIST] {
    foreach a $ADDON_LIST {
      if [file exists $a] {
        if [string length [set mtmp [get_cookie ADDON([file tail $a])]]] {
          if {[string compare $mtmp [file mtime $a]] != 0} {
            set_cookie ADDON([file tail $a]) [file mtime $a]
            echo [addonmodifiedEcho $a]
          }
        }
      } {
        set_cookie ADDON([file tail $a]) ""
      }
    }
  }
  if [string length [get_cookie STYLE_NAME]] {
    if [string length [get_cookie STYLE_MODT]] {
      set stName [get_cookie STYLE_NAME]
      set stModt [get_cookie STYLE_MODT]
      if ![string compare [stl $stName] [stl [file tail $stName]]] { set stName "[pwd]/${stName}" }
      if [file exists $stName] {
        if {[string compare $stModt [file mtime $stName]] != 0} {
          set_cookie STYLE_MODT [file mtime $stName]
          if {[string compare $mtmp [file mtime $a]] != 0} {
            echo [stylemodifiedEcho $stName]
            if ![string compare [stl [get_tog "AutoReLoad_styles"]] "on"] { echo [autostylingEcho $stName]; /style $stName }
          } {
            set rl [FALC_askbox -t "Reload Style: [file tail $stName]" -b ok_cancel -d ok -i question "[file tail $stName] style has been modified.\n\tReload?"]
            switch -- [stl $rl] {
              "ok" { /style [get_cookie "STYLE_NAME"] }
            }
          }
        }
      }
    }
  }
  if [info exists REGAIN_NICK_START] {
    if ![info exists REGAIN_NICK_TIMER] { set REGAIN_NICK_TIMER 0 }
    incr REGAIN_NICK_TIMER
    if {$REGAIN_NICK_TIMER >= 60} {
      if ![info exists REGAIN_NICK_TIMES] { set REGAIN_NICK_TIMES 60 }
      if {$REGAIN_NICK_TIMES >= 0} {
        if ![info exists REGAIN_NICK_CYCLES] { set REGAIN_NICK_CYCLES 0 }
        incr REGAIN_NICK_CYCLES
        /quote NICK :$REGAIN_NICK_START
        if {$REGAIN_NICK_CYCLES >= $REGAIN_NICK_TIMES} { echo [regainnickfinEcho $REGAIN_NICK_START "timer ended"]; unset REGAIN_NICK_START REGAIN_NICK_TIMER REGAIN_NICK_TIMES REGAIN_NICK_CYCLES } { set REGAIN_NICK_TIMER 0 }
      } {
        /quote NICK :$REGAIN_NICK_START
        set REGAIN_NICK_TIMER 0
      }
    }
  }
  if [info exists SCRIPT_TIMERS] {
    foreach a [array names SCRIPT_TIMERS] {
      set p [split $SCRIPT_TIMER_INFO($a) ","]
      set r [lindex $p 0]
      set d [lindex $p 1]
      set tr [lindex $p 2]
      set td [lindex $p 3]
      if {$td >= $d} {
        set cmd $SCRIPT_TIMERS($a)
        catch {eval $cmd}
        unset cmd
        incr tr
        if {$tr >= $r && $r != 0} { sKillTimer $a }
        set td 0
      }
      incr td
      set SCRIPT_TIMER_INFO(${a}) "${r},${d},${tr},${td}"
      unset p r d tr td
    }
  }
  if [info exists TIMERS] {
    foreach a [array names TIMERS] {
      if [info exists TIMER_INF($a)] {
        set parts [split $TIMER_INF($a) ","]
        set rep [lindex $parts 0]
        set del [lindex $parts 1]
        set t_rep [lindex $parts 2]
        set t_del [lindex $parts 3]
        if {$t_del >= $del} {
          set cmd [string range $TIMERS($a) [expr [pos $TIMERS($a) ","]+1] end]
          catch {$cmd}
          unset cmd
          incr t_rep
          if {$t_rep >= $rep && $rep != 0} {
            /timer$a off
          }
          set t_del 0
        }
        incr t_del
        set TIMER_INF($a) $rep,$del,$t_rep,$t_del
        unset parts rep del t_rep t_del
      }
    }
  }
  if [connected] {
    if ![info exists USER_INFO(idle)] { set USER_INFO(idle) 0 } { incr USER_INFO(idle) }
    if {[stl [get_tog "AutoAway"]] == "on" && ![away]} {
      if [isint [get_tog "AutoAwaySeconds"]] {
        if {[idle] >= [get_tog "AutoAwaySeconds"]} {
          /away [u]([u][b]a[b]uto-[b]a[b]way [duration [get_tog "AutoAwaySeconds"] "w" "d" "h" "m" "s" "" "" " "] idle[u])[u]
        }
      }
    }
    if ![info exists USER_INFO(modes)] { set USER_INFO(modes) [mode] }
    set status_window [statusWindow [my_nick] $USER_INFO(modes)]
    if {$status_window != [window get_title status]} {
      window set_title $status_window status
    }
    set window_type "connected"
  } {
    if ![info exists USER_INFO(idle)] { set USER_INFO(idle) 0 }
    if {$USER_INFO(idle) > 0} { set USER_INFO(idle) 0 }
    set status_window [statusunconnectedWindow]
    if {[strcmp $status_window [window get_title status]] != 0} {
      window set_title $status_window status
    }
    set window_type "unconnected"
  }
  if ![info exists env(sin_load)] { set env(sin_load) [clock clicks]; set sin_zero(load) [clock clicks] }
  if ![info exists sin_zero(load)] { set env(sin_load) [clock clicks]; set sin_zero(load) [clock clicks] }
  if {$env(sin_load) == $sin_zero(load)} {
    set main_window [mainWindow $window_type]
    if {$main_window != [window get_title main]} {
      window set_title $main_window main
    }
    unset main_window
  }
  unset window_type status_window
}
on lookup {
  set host [lindex [args] 0]
  set reslv [lindex [args] 1]
  if {[info exist DNS_LIST] && [lpos $DNS_LIST $host] != -1} {
    if [string length $reslv] {
      echo [dnsresolvedEcho $host $reslv]
    } {
      echo [dnsfailedEcho $host]
    }
    set DNS_LIST [lreplace $DNS_LIST [lpos $DNS_LIST $host] [lpos $DNS_LIST $host]]
    unset host reslv
    complete
  } elseif [info exists WHOIS_DNS_LOOKUP([stl $host])] {
    if [tog_on "Active_Window_Whois"] {
      set d1 [window_type]
      set d2 [window_name]
    } {
      set d1 "status"
      set d2 ""
    }
    if ![isip $host] {
      if ![string length $reslv] { set extra "Invalid Hostname!" } { set extra "IP - $reslv" }
    } {
      if ![string length $reslv] { set extra "IP - $host" } { set extra "Host - $reslv" }
    }
    set nick $WHOIS_DNS_LOOKUP([stl $host])
    if ![info exists WHOIS([stl $nick]:nick)] { set WHOIS([stl $nick]:nick) $nick }
    if ![info exists WHOIS([stl $nick]:user)] { set WHOIS([stl $nick]:user) "user" }
    if ![info exists WHOIS([stl $nick]:host)] { set WHOIS([stl $nick]:host) "localhost" }
    if ![info exists WHOIS([stl $nick]:cntry)] { set WHOIS([stl $nick]:cntry) "United States of America" }
    echo [whoisTop $nick] $d1 $d2
    echo [whoisuserhost $nick $WHOIS([stl $nick]:user) $WHOIS([stl $nick]:host) $WHOIS([stl $nick]:cntry)] $d1 $d2
    echo [whoisdnsinfo $nick $host $reslv] $d1 $d2
    if [info exists WHOIS([stl $nick]:name)] {
      echo [whoisname $nick $WHOIS([stl $nick]:name)] $d1 $d2
      unset WHOIS([stl $nick]:name)
    }
    if [info exists WHOIS([stl $nick]:away)] {
      echo [whoisaway $nick $WHOIS([stl $nick]:away)] $d1 $d2
      catch {unset WHOIS([stl $nick]:away)}
    }
    if [info exists WHOIS([stl $nick]:chans)] {
      echo [whoischans $nick $WHOIS([stl $nick]:chans)] $d1 $d2
      unset WHOIS([stl $nick]:chans)
    }
    if [info exists WHOIS([stl $nick]:ircop)] {
      echo [whoisoper $nick] $d1 $d2
      unset WHOIS([stl $nick]:ircop)
    }
    if [info exists WHOIS([stl $nick]:server)] {
      if ![info exists WHOIS([stl $nick]:server_info)] { set WHOIS([stl $nick]:server_info) "" }
      echo [whoisserver $nick $WHOIS([stl $nick]:server) $WHOIS([stl $nick]:server_info)] $d1 $d2
      unset WHOIS([stl $nick]:server); unset WHOIS([stl $nick]:server_info)
    }
    if [info exists WHOIS([stl $nick]:idle)] {
      echo [whoisidle $nick $WHOIS([stl $nick]:idle)] $d1 $d2
      unset WHOIS([stl $nick]:idle)
    }
    if [info exists WHOIS([stl $nick]:signon)] {
      if [isint $WHOIS([stl $nick]:signon)] {
        echo [whoissignon $nick $WHOIS([stl $nick]:signon)] $d1 $d2
      }
      unset WHOIS([stl $nick]:signon)
    }
    echo [whoisBottom $WHOIS([stl $nick]:nick)] $d1 $d2
    unset WHOIS([stl $nick]:nick) WHOIS([stl $nick]:user) WHOIS([stl $nick]:host) WHOIS([stl $nick]) WHOIS([stl $nick]:cntry) d1 d2
    unset WHOIS_DNS_LOOKUP([stl $host])
  }
}
on unload {
  if [info exists env(sin_load)] { unset env(sin_load) }
  if {[info exists AWAY_INFO(away)] && $AWAY_INFO(away)} {
    if [info exists AWAY_INFO(reason)] {
      set reason [replace $AWAY_INFO(reason) "\{" "\\{"]
      set reason [replace reason "\}" "\\}"]
    } {
      set reason ""
    }
    if ![info exists AWAY_INFO(at)] {
      set AWAY_INFO(at) [clock seconds]
    }
    if ![info exists AWAY_INFO(msgs)] {
      set AWAY_INFO(msgs) 0
    }
    set_cookie tmp.away.[lindex [server] 0] "[list $AWAY_INFO(reason)] [list $AWAY_INFO(at)] [list $AWAY_INFO(msgs)]"
    unset reason
  } {
    set_cookie tmp.away.[lindex [server] 0] ""
  }
  if [info exists USER_INFO] {
    set_cookie tmp.serv.[lindex [server] 0] $USER_INFO(server)
    set_cookie tmp.online.[lindex [server] 0] $USER_INFO(online)
    set_cookie tmp.modes.[lindex [server] 0] $USER_INFO(modes)
  }
  foreach c [channels] { window set_title "" channel $c; unset c }
  foreach q [queries] { window set_title "" query $q; unset q }
  window set_title "" status
  window set_title "" main
}


####- IAL -####
on privmsg {
  if {[nick] != "" && [ischan [lindex [args] 0]]} { add_ial [nick] [user] [host] }
}
on notice {
  if {[nick] != "" && [ischan [lindex [args] 0]]} { add_ial [nick] [user] [host] }
}
on mode {
  if {[nick] != ""} { add_ial [nick] [user] [host] }
}
on join {
  if {[nick] != ""} { add_ial [nick] [user] [host] }
}
on part {
  if {[nick] != ""} {
    if {[com_chans [nick]] == ""} { rem_ial [nick] } { add_ial [nick] [user] [host] }
  }
}
on nick {
  if {[nick] != ""} {
    set new_nick [lindex [args] 0]
    add_ial $new_nick [user] [host]
    rem_ial [nick]
  }
}
on kick {
  if {[nick] != ""} {
    set knick [lindex [args] 1]
    add_ial [nick] [user] [host]
    if {[com_chans $knick] == ""} { rem_ial $knick }
  }
}
on quit {
  if {[nick] != ""} { rem_ial [nick] }
}
on topic {
  if {[nick] != ""} { add_ial [nick] [user] [host] }
}
on ctcp {
  if {[com_chans [nick]] != ""} { add_ial [nick] [user] [host] }
}
on ctcp_reply {
  if {[com_chans [nick]] != ""} { add_ial [nick] [user] [host] }
}
on privmsg { complete }
on ctcp {
  set type [lindex [args] 1]
  set rest [join [lrange [args] 2 end]]
  set tmp $rest
  set tmp [replace $tmp "\{" "\\\{"]
  set tmp [replace $tmp "\}" "\\\}"]
  set tmp [replace $tmp "\"" "\\\""]
  set sub_type [stu [lindex $tmp 0]]
  if {$type != "DCC" || ($type == "DCC" && $sub_type != "CHAT" && $sub_type != "SEND" && $sub_type != "TSEND" && $sub_type != "ACCEPT" && $sub_type != "RESUME")} {
    complete
  }
  unset type rest sub_type
}
on ctcp_reply { complete }
on chat_text { complete }
on chat_send { complete }
on chat_connect { complete }
on chat_accept { complete }
on chat_disconnect { complete }
on notice { complete }
on mode { complete }
on join { complete }
on part { complete }
on kick { complete }
on quit { complete }
on nick { complete }
on load { complete }
on unload { complete }
on 221 { complete }
on wallops { complete }

for {set x 0} {$x < 400} {incr x} {
  on $x {
    if {[stl [lindex [args] 0]] == [stl [my_nick]]} {
      set misceventOut [rawokreplyText [event] [join [lrange [args] 1 end]]]
    } {
      set misceventOut [rawokreplyText [event] [join [args]]]
    }
    echo $misceventOut status
    unset misceventOut
    complete
  }
}
for {set x 400} {$x < 800} {incr x} {
  on $x {
    if {[stl [lindex [args] 0]] == [stl [my_nick]]} {
      set out [rawerrreplyText [event] [join [lrange [args] 1 end]]]
    } {
      set out [rawerrreplyText [event] [join [args]]]
    }
    echo $out status
    unset out
    complete
  }
}
if [info exists x] { unset x }

####- User Aliases -####

alias about {
  if [info exists sin_zero(truevers)] { set Aaboutvers $sin_zero(truevers) } { set Aaboutvers [get_cookie Version "NULL"] }
  msgbox "About Sin(zero) IRC script" "Sin(zero) (v$Aaboutvers) credits:\n \nAuthor:\n... Ian D. E. (phAge)\n \nFalcon DLL Creator:\n... David Gravereaux (thanks for the library :)\n \n   Script Testers:\n   ... Puppet\n   ... badtoyz\n   ... Flecko\n   ... Illusion\n   ... Wintermute\n   ... ryan\n   ... Josh"
  idle 0
  unset Aaboutvers
  complete
}
alias help {
  set Ahelptop [join [args]]
  if [connected] { /query .HELP }
  if [window exists query ".HELP"] {
    if [info exists sin_zero(truevers)] { set v $sin_zero(truevers) } { set v "2.xx" }
    window set_title "Sin(zero/${v}) Help" query .HELP
    unset v
    set Ahelpd1 "query"; set Ahelpd2 ".HELP"
  } {
    set Ahelpd1 [window_type]; set Ahelpd2 [window_name]
  }
  if ![string length $Ahelptop] {
    help_parse $Ahelpd1 $Ahelpd2
  } {
    if ![info exists HELP_INFO([stu $Ahelptop])] {
      if {[string range $Ahelptop end end] != "*"} {
        set Ahelptop $Ahelptop*
      }
      help_parse $Ahelpd1 $Ahelpd2 [stu $Ahelptop]
    } {
      set Ahelphline $HELP_INFO([stu $Ahelptop]); set Ahelpcmd [lindex $Ahelphline 0]
      set Ahelpuse [lindex $Ahelphline 1]; set Ahelpdesc [lindex $Ahelphline 2]
      set Ahelpalt [lindex $Ahelphline 3]; set Ahelpalso [lindex $Ahelphline 4]
      echo [helpheadEcho [lindex $Ahelphline 0]] $Ahelpd1 $Ahelpd2
      if [string length $Ahelpuse] { echo [helpusageEcho $Ahelpcmd $Ahelpuse] $Ahelpd1 $Ahelpd2 }
      if [string length $Ahelpdesc] { echo [helpdescriptionEcho $Ahelpcmd $Ahelpdesc] $Ahelpd1 $Ahelpd2 }
      if [string length $Ahelpalt] { echo [helpalternatesEcho $Ahelpcmd $Ahelpalt] $Ahelpd1 $Ahelpd2 }
      if [string length $Ahelpalso] { echo [helpseealsoEcho $Ahelpcmd $Ahelpalso] $Ahelpd1 $Ahelpd2 }
      echo [helpendEcho $Ahelpcmd] $Ahelpd1 $Ahelpd2
      unset Ahelpalso Ahelpalt Ahelpuse Ahelpdesc Ahelphline
    }
  }
  idle 0
  unset Ahelptop Ahelpd1 Ahelpd2
  complete
}
alias .* {
  set sin_zero(show_output) 0
  set Asilentcmd [string trimleft [lindex [args] 0] "."]
  /$Asilentcmd [join [lrange [args] 1 end]]
  set sin_zero(show_output) 1
  unset Asilentcmd
  complete
}
alias /* {
  set Aevalcmd [join [args]]
  if ![strcmpi [string index $Aevalcmd 0] "/"] { set Aevalcmd /[string trimleft $Aevalcmd "/"] }
  catch {eval $Aevalcmd}
  unset Aevalcmd
  idle 0
  complete
}
alias cop {
  set oplist ""
  set opcnt 0
  set chan [lindex [args] 0]
  set nlist [string range [args] [expr [string length $chan]+1] end]
  set a ""
  foreach a $nlist {
    lappend oplist $a
    incr opcnt
    if {$opcnt == 4} {
      /quote MODE $chan +oooo [join $oplist]
      set opcnt 0
      set oplist ""
    }
  }
  if {$oplist != ""} {
    /quote MODE $chan +[repeat "o" $opcnt] [join $oplist]
    set oplist ""
    set opcnt 0
  }
  unset oplist opcnt a nlist chan
  idle 0
  complete
}
alias cdop {
  set oplist ""
  set opcnt 0
  set chan [lindex [args] 0]
  set nlist [string range [args] [expr [string length $chan]+1] end]
  set a ""
  foreach a $nlist {
    lappend oplist $a
    incr opcnt
    if {$opcnt == 4} {
      /quote MODE $chan -oooo [join $oplist]
      set opcnt 0
      set oplist ""
    }
  }
  if [string length [join $oplist]] {
    /quote MODE $chan -[repeat "o" $opcnt] [join $oplist]
    set oplist ""
    set opcnt 0
  }
  unset oplist opcnt a chan nlist
  idle 0
  complete
}
alias cdvc {
  set vlist ""
  set vcnt 0
  set chan [lindex [args] 0]
  set nlist [string range [args] [expr [string length $chan]+1] end]
  set a ""
  foreach a $nlist {
    lappend vlist $a
    incr vcnt
    if {$vcnt == 4} {
      /quote MODE $chan -vvvv [join $vlist]
      set vcnt 0
      set vlist ""
    }
  }
  if {$vlist != ""} {
    /quote MODE $chan -[repeat "v" $vcnt] [join $vlist]
    set vlist ""
    set vcnt 0
  }
  unset vlist vcnt a nlist chan
  idle 0
  complete
}
alias cvc {
  set vlist ""
  set vcnt 0
  set chan [lindex [args] 0]
  set nlist [string range [args] [expr [string length $chan]+1] end]
  set a ""
  foreach a $nlist {
    lappend vlist $a
    incr vcnt
    if {$vcnt == 4} {
      /quote MODE $chan +vvvv [join $vlist]
      set vcnt 0
      set vlist ""
    }
  }
  if [string length $vlist] {
    /quote MODE $chan +[repeat "v" $vcnt] [join $vlist]
    set vlist ""
    set vcnt 0
  }
  unset vlist vcnt a nlist chan
  idle 0
  complete
}
alias mass {
  set type [lindex [args] 0]
  set dest [lindex [args] 1]
  if {[stu $type] == "DEOP"} { set type "DOP" }
  if {[stu $type] == "DEVOICE"} { set type "DVC" }
  if {[stu $type] == "VOICE"} { set type "VC" }
  if {$dest == ""} {
    set dest [channel]
    if {$dest == ""} {
      echo [errEcho "Mass" "usage: /mass <type> \[channel\]"]
      complete; return
    }
  }
  if ![onchan [my_nick] $dest] {
    echo [errEcho "Mass" "you are not on $dest"
    complete; return
  }
  switch -- [stu $type] {
    "OP" {
      set nicks [nops $dest]
      /cop $dest $nicks
    }
    "DOP" {
      set nicks [ops $dest]
      set pos [lsearch -exact [stl $nicks] [stl [my_nick]]]
      if {$pos != -1} { set nicks [lreplace $nicks $pos $pos] }
      /cdop $dest $nicks
    }
    "VC" {
      set nicks [nnicks $dest]
      /cvc $dest $nicks
    }
    "DVC" {
      set nicks [novoice $dest]
      set pos [lsearch -exact [stl $nicks] [stl [my_nick]]]
      if {$pos != -1} { set nicks [lreplace $nicks $pos $pos] }
      /cdvc $dest $nicks
    }
    "KICK" {
      set nicks [nnicks $dest]
      set pos [lsearch -exact [stl $nicks] [stl [my_nick]]]
      if {$pos != -1} { set nicks [lreplace $nicks $pos $pos] }
      foreach n $nicks { /kick $dest $nick [u]s[b]Z[b][u]([b]m[b]ass-[b]k[b]ick) }
    }
  }
  idle 0
  complete
}
alias sound {
  if ![connected] {
    not_connected
    complete; return
  }
  if {[window_type] != "channel" && [window_type] != "query"} {
    echo [errEcho Sound "/sound must be used in a channel or query window"]
    complete; return
  }
  set sound [lindex [args] 0]
  if ![string length $sound] {
    set sval [stl [get_tog "Sound_System"]]
    if {$sval != "on"} { set sval "off" }
    echo [togbool${sval}Echo "Sound_System"]
    unset sval
    complete; return
  }
  if ![strcmpi $sound "stop"] {
    mmstop all
  } elseif ![strcmpi $sound "off"] {
    set_tog "Sound_System" "off"
    echo [togbooloffEcho "Sound_System"]
  } elseif ![strcmpi $sound "on"] {
    set_tog "Sound_System" "on"
    echo [togboolonEcho "Sound_System"]
  } {
    set text [join [lrange [args] 1 end]]
    set sdir [replace [get_tog "SoundDir"] "\\" "/"]
    if {[string range $sdir end end] != "/"} {
      set sdir $sdir/
    }
    if {[dirname $sound] != "."} {
      set sound [replace $sound "\\" "/"]
      mmplay $sound
    } elseif [file exists [pwd]/$sound] {
      mmplay [pwd]/$sound
    } elseif [file exists $sdir$sound] {
      mmplay $sdir$sound
    } elseif {[stl [get_tog "Sound_Recursion"]] == "on"} {
      set fsound [filefind [file tail $sound] 1 $sdir]
      if [string length $fsound] { mmplay $fsound }
      unset fsound
    }
    set play_sound [file tail $sound]
    if ![ischan [window_name]] { set NO_SUCH_USER_FAILSAFE([stl [window_name]]) [stl [window_name]] }
    if ![strcmpi [window_type] "chat"] {
      if ![string length $text] {
        putdcc [window_name] "\001SOUND $play_sound\001"
        echo [selfsoundnotextEcho [window_name] $play_sound] chat [window_name]
      } {
        putdcc [window_name] "\001SOUND $play_sound $text\001"
        echo [selfsoundtextEcho [window_name] $play_sound $text] chat [window_name]
      }
    } {
      if ![string length $text] {
        /quote PRIVMSG [window_name] :\001SOUND $play_sound\001
        echo [selfsoundnotextEcho [window_name] $play_sound] [window_type] [window_name]
      } {
        /quote PRIVMSG [window_name] :\001SOUND $play_sound $text\001
        echo [selfsoundtextEcho [window_name] $play_sound $text] [window_type] [window_name]
      }
    }
    unset text play_sound sdir
  }
  unset sound
  idle 0
  complete
}
alias splay {
  set sound [join [args]]
  if ![string length $sound] {
    echo [errEcho Splay "usage: /splay <SOUND|off|stop>"]
    complete; return
  }
  if {[stl $sound] == "stop"} {
    mmstop all
  } elseif {[stl $sound] == "off"} {
    set_tog "Sound_System" "off"
    echo [togbooloffEcho "Sound_System"]
  } elseif {[stl $sound] == "on"} {
    set_tog "Sound_System" "on"
    echo [togboolonEcho "Sound_System"]
  } {
    set sdir [replace [get_tog "SoundDir"] "\\" "/"]
    if {[string range $sdir end end] != "/"} {
      set sdir $sdir/
    }
    if {[dirname $sound] != "."} {
      set sound [replace $sound "\\" "/"]
      mmplay $sound
    } elseif [file exists [pwd]/$sound] {
      mmplay [pwd]/$sound
    } elseif [file exists $sdir$sound] {
      mmplay $sdir$sound
    } elseif {[stl [get_tog "Sound_Recursion"]] == "on"} {
      set fsound [filefind [file tail $sound] 1 $sdir]
      if {$fsound != ""} {
        mmplay $fsound
      }
    }
  }
  idle 0
  complete
}
alias clearall {
  set c ""; set q ""
  foreach c [channels] { window clear channel $c }
  foreach q [queries] { window clear query $q }
  foreach c [chats] { window clear chat $c }
  window clear status
  unset c q
  idle 0
  complete
}
alias play {
  set args [args]
  set f ""
  set gT 0
  set fB 0
  set flags ""
  set time 0
  foreach a $args {
    if $fB {
      lappend f $a
    } elseif $gT {
      if [isint $a] { set time $a } { lappend f $a; set gT 0; set fB 1 }
    } elseif ![strcmp [string index $a 0] "-"] {
      set ftmp [string trimleft $a "-"]
      if ![string length $ftmp] { set fB 1 } { set flags "${flags}${ftmp}" }
      if ![strcmpi $ftmp "t"] { set gT 1 }
    } {
      set fB 1
      lappend f $a
    }
  }
  if {$time > 0} { set flags [replace $flags "t" "t${time}"] }
  set f [join $f]
  set f [replace $f "\\" "/"]
  if {[file exists $f] && ![file isdir $f]} {
    if [isin [stl $flags] "e"] { set eval 1 } { set eval 0 }
    if [isin [stl $flags] "t"] {
      set tid [pos [stl $flags] "t"]
      set n [string index $flags [expr $tid+1]]
      set idX 2
      set x 0
      while {[isint $x]} {
        set x [string index $flags [expr $tid+$idX]]
        if [isint $x] { set n "${n}${x}" }
      }
      set timd $n
    } {
      set timd 0
    }
    if ![catch {open $f "r"} f_buff] {
      if $timd { set multiplier 1 }
      while {![eof $f_buff]} {
        gets $f_buff n
        if [string length [replace $n " " ""]] {
          if $timd {
            if $eval {
              set cmd $n
              if {[strcmpi [string index $cmd 0] "/"] != 0} { set cmd "/${cmd}" }
            } {
              switch -- [window_type] {
                "status" { set cmd "/echo $n" }
                "channel" { set cmd "/msg [channel] $n" }
                "query" { set cmd "/msg [query] $n" }
                "chat" { set cmd "/msg =[chat] $n" }
                default { set cmd "/echo $n" }
              }
            }
            sStartTimer 1 [expr ${timd}*$multiplier] $cmd
            incr multiplier
          } elseif $eval {
            if {[strcmpi [string index $n 0] "/"] != 0} { set n "/${n}" }
            $n
          } {
            switch -- [window_type] {
              "status" { set cmd "/echo $n" }
              "channel" { set cmd "/msg [channel] $n" }
              "query" { set cmd "/msg [query] $n" }
              "chat" { set cmd "/msg =[chat] $n" }
              default { set cmd "/echo $n" }
            }
            $cmd
          }
        }
      }
      catch {close $f_buff}
    }
  } {
    echo [errEcho "Play" "invalid filename: $f"]
  }
  complete
}
alias flood {
  if {[info exists sin_zero(FALC_LOAD)] && $sin_zero(FALC_LOAD)} {
    set content ""
    foreach flood_types "P Q C" {
      if ![strcmpi $flood_types "p"] {
        set type "PUBLIC"
      } elseif ![strcmpi $flood_types "q"] {
        set type "PRIVATE"
      } {
        set type "CTCP"
      }
      set dw1 [lindex [split [get_cookie "F[stu $flood_types]W"] ","] 0]; set dw2 [lindex [split [get_cookie "F[stu $flood_types]W"] ","] 1]
      set dm1 [lindex [split [get_cookie "F[stu $flood_types]M"] ","] 0]; set dm2 [lindex [split [get_cookie "F[stu $flood_types]M"] ","] 1]
      set ds1 [lindex [split [get_cookie "F[stu $flood_types]S"] ","] 0]; set ds2 [lindex [split [get_cookie "F[stu $flood_types]S"] ","] 1]
      lappend content [list label lbl 10 15 25 12 "Weak:"]
      lappend content [list edit w_msg 15 25 15 12 $dw1]
      lappend content [list label lbl 35 25 25 12 "msgs in"]
      lappend content [list edit w_sec 65 25 15 12 $dw2]
      lappend content [list label lbl 85 25 15 12 "secs"]
      lappend content [list label lbl 10 45 25 12 "Mild"]
      lappend content [list edit m_msg 15 55 15 12 $dm1]
      lappend content [list label lbl 35 55 25 12 "msgs in"]
      lappend content [list edit m_sec 65 55 15 12 $dm2]
      lappend content [list label lbl 85 55 15 12 "secs"]
      lappend content [list label lbl 10 75 25 12 "Strong"]
      lappend content [list edit s_msg 15 85 15 12 $ds1]
      lappend content [list label lbl 35 85 25 12 "msgs in"]
      lappend content [list edit s_sec 65 85 15 12 $ds2]
      lappend content [list label lbl 85 85 15 12 "secs"]
      set out [FALC_dialog -t "Flood Settings - $type" 160 100 $content]
      if ![string length $out] { break }
      set w1 [lindex [lindex $out 0] 1]; set w2 [lindex [lindex $out 1] 1]
      set m1 [lindex [lindex $out 2] 1]; set m2 [lindex [lindex $out 3] 1]
      set s1 [lindex [lindex $out 4] 1]; set s2 [lindex [lindex $out 5] 1]
      if [isint $w1] { set fw1 $w1 } { set fw1 $dw1 }; if [isint $w2] { set fw2 $w2 } { set fw2 $dw2 }
      if [isint $m1] { set fm1 $m1 } { set fm1 $dm1 }; if [isint $m2] { set fm2 $m2 } { set fm2 $dm2 }
      if [isint $s1] { set fs1 $s1 } { set fs1 $ds1 }; if [isint $s2] { set fs2 $s2 } { set fs2 $ds2 }
      set_cookie "F[stu $flood_types]W" "${fw1},${fw2}"
      set_cookie "F[stu $flood_types]M" "${fm1},${fm2}"
      set_cookie "F[stu $flood_types]S" "${fs1},${fs2}"
      set content ""
      unset fs1 fs2 fm1 fm2 fw1 fw2 dm1 dm2 dw1 dw2 ds1 ds2 s1 s2 m1 m2 w1 w2
    }
    unset content out type flood_types
  } {
    echo [errEcho "Flood" "this alias requires that the falcon.dll library be present and properly loaded in order to run."]
  }
  complete
}
alias view {
  set view [get_tog "Default_Text_Viewer"]
  if {[string length [args]] && [string compare [stl $view] "\001none\001"] != 0} {
    /exec $view [join [args]]
  } elseif {[info exists sin_zero(FALC_LOAD)] && $sin_zero(FALC_LOAD)} {
    set f_name [FALC_fileopen -t "Choose a text file" -d [pwd] -f "Text Files (*.txt)|*.txt|HTML Files (*.htm*)|*.htm*|Perl Files (*.pl)|*.pl|C Files (*.c)|*.c|TCL Files (*.tcl)|*.tcl|Sin Style Files (*.szs)|*.szs|All Files (*.*)|*.*"]
    if [string length $f_name] { /exec $view $f_name } { /exec $view }
  } {
    /exec $view
  }
  idle 0
  complete
}
alias style {
  set fname [join [args]]
  set pre_load [clock clicks]
  if ![string length $fname] { echo [errEcho "Style" "usage: /style <style filename>"]; complete; return }
  if [load_style $fname] {
    set load_time [expr ([clock clicks]-$pre_load)/1000.0]
    echo "[c]00<[c]14\[[c]15Loaded Style[c]14[u]:[u] [c]15$fname in $load_time secs[c]14\][c]00>"
    set_cookie STYLE_NAME $fname
    set_cookie STYLE_MODT [file mtime $fname]
    unset load_time
  } {
    echo [errEcho "Style" "unable to load $fname"]
  }
  unset pre_load
  idle 0
  complete
}
alias privmsg {
  if ![connected] {
    not_connected
    complete
    return
  }
  set dest [string range [raw_args] 0 [expr [pos [raw_args] " "]-1]]
  if {[string compare [string index $dest 0] "="] != 0 || (![string compare [string index $dest 0] "="] && ![window exists chat [string range $dest 1 end]])} {
    set text [string range [raw_args] [expr [string length $dest]+1] [string length [raw_args]]]
    if ![string length $dest] { echo [errEcho "Privmsg" "no target specified"]; complete; return }
    if ![string compare [stu $dest] ".HELP"] { /help $text; complete; return }
    if ![string compare [stu $dest] ".TOGGLES"] { /set $text; complete; return }
    if ![string compare [stu $dest] ".WHOIS"] { /whois @$text; complete; return }
    if ![string length [ascreplace $text 32 32]] { echo [errEcho "Privmsg" "no text to send"]; complete; return }
    set findest ""
    foreach d [split $dest ","] {
        if [ischan $d] {
          if [onchan [my_nick] $d] {
            set BASECOLOR "[c][colr selftext]"; set out_type "selfchanText"; set d1 "channel"; set d2 $d
            if {[string index $text [expr [pos $text " "]-1]] == "[string index [get_tog Ncomp_Char] 0]" && [stl [get_tog "Auto_NComp"]] == "on"} {
              set n_list [lsort -ascii [nnicks $d]]
              set n_comp [fix4match [string range $text 0 [expr [pos $text " "]-2]]]
              set n_comp [replace $n_comp "*" "\*"]
              set stl_comp "[stl $n_comp]*"
              set n_out ""
              if {[string compare $stl_comp "*"] != 0} {
                foreach n $n_list { if [string match $stl_comp [stl $n]] { set n_out $n; break } }
                if [string length $n_out] { regsub -- "$n_comp[string index [get_tog Ncomp_Char] 0]" $text [ncompify $n_out] text }
              }
            }
          } {
            set BASECOLOR "[c][colr selfmsg]"; set out_type "selfmsgText"; set d1 [window_type]; set d2 [window_name]
          }
        } {
          set NO_SUCH_USER_FAILSAFE([stl $d]) [stl $d]
          if [window exists query $d] {
            set BASECOLOR "[c][colr selftext]"; set out_type "selfqueryText"; set d1 "query"; set d2 $d
          } {
            set out_type "selfmsgText"; set BASECOLOR "[c][colr selfmsg]"; set d1 [window_type]; set d2 [window_name]
          }
        }
        echo [$out_type $d $text] $d1 $d2
        lappend findest $d
      }
    set findest [join $findest ","]
    /quote PRIVMSG $findest :$text
    unset findest text
    idle 0
    complete
  }
}
alias query { if {[llength [args]] > 1} { /privmsg [lindex [args] 0] [join [lrange [args] 1 end]] } }
alias action {
  if ![connected] {
    not_connected
    complete
    return
  }
  if {[window_type] != "chat"} {
    if {[window_type] != "channel" && [window_type] != "query"} {
      echo [errEcho "Action" "invalid window type"]
      complete; return
    }
    set BASECOLOR "[c][colr selfaction]"
    set dest [window_name]
    set text [join [args]]
    if ![string length $text] {
      echo [errEcho Action "usage: /action <text>"]
      complete; return
    }
    /quote PRIVMSG $dest :\001ACTION $text\001
    if [ischan $dest] {
      set text [replace $text "[o]" "[o][c][colr selfaction]"]
      set out [selfchanAction $dest $text]
    } {
      set text [replace $text "[o]" "[o][c][colr selfaction]"]
      set out [selfqueryAction $dest $text]
    }
    echo $out [window_type] [window_name]
    unset dest text out BASECOLOR
    idle 0
    complete
  }
}
alias notice {
  if ![connected] {
    not_connected
    complete
    return
  }
  set BASECOLOR "[c][colr notice]"
  set dest [string range [raw_args] 0 [expr [pos [raw_args] " "]-1]]
  foreach d [split $dest ","] { if ![ischan $d] { set NO_SUCH_USER_FAILSAFE([stl $d]) [stl $d] } }
  set text [string range [raw_args] [expr [string length $dest]+1] [string length [raw_args]]]
  if {![string length $text] || ![string length $dest]} {
    echo [errEcho Notice "usage: /notice <target> <text>"]
    complete; return
  }
  /quote NOTICE $dest :$text
  set out [selfnoticeText $dest $text]
  echo $out [window_type] [window_name]
  unset out dest text BASECOLOR
  idle 0
  complete
}
alias amsg {
  if ![connected] {
    not_connected
    complete
    return
  }
  set BASECOLOR "[c][colr selftext]"
  set text [join [args]]
  if {[channels] == "" || $text == ""} {
    echo [errEcho "Amsg" "usage: /amsg <text>"]
    complete; return
  }
  foreach c [channels] { echo [selfchanText $c $text] channel $c }
  set tmp ""
  set clist ""
  set cnt 0
  foreach c [channels] {
    incr cnt
    lappend tmp $c
    if {$cnt >= 10} {
      lappend clist [join $tmp ","]
      set tmp ""
      set cnt 0
    }
  }
  if {$tmp != ""} {
    lappend clist [join $tmp ","]
    set tmp ""
    set cnt 0
  }
  foreach c $clist {
    /quote PRIVMSG $c :$text
  }
  unset tmp clist c cnt text BASECOLOR
  idle 0
  complete
}
alias ame {
  if ![connected] {
    not_connected
    complete
    return
  }
  set BASECOLOR "[c][colr selfaction]"
  set text [join [args]]
  if {[channels] == "" || $text == ""} {
    echo [errEcho "Ame" "usage: /ame <text>"]
    complete; return
  }
  foreach c [channels] { echo [selfchanAction $c $text] channel $c }
  set tmp ""
  set clist ""
  set cnt 0
  foreach c [channels] {
    incr cnt
    lappend tmp $c
    if {$cnt >= 10} {
      lappend clist [join $tmp ","]
      set tmp ""
      set cnt 0
    }
  }
  if {$tmp != ""} {
    lappend clist [join $tmp ","]
    set tmp ""
    set cnt 0
  }
  foreach c $clist {
    /quote PRIVMSG $c :\001ACTION $text\001
  }
  unset tmp clist c cnt text BASECOLOR
  idle 0
  complete
}
alias anot {
  if ![connected] {
    not_connected
    complete
    return
  }
  set BASECOLOR "[c][colr notice]"
  set text [join [args]]
  if {[channels] == "" || $text == ""} {
    echo [errEcho "Anot" "usage: /anot <text>"]
    complete; return
  }
  foreach c [channels] { echo [channoticeText $c [my_nick] [my_user] [my_host] $text] channel $c }
  set tmp ""
  set clist ""
  set cnt 0
  foreach c [channels] {
    incr cnt
    lappend tmp $c
    if {$cnt >= 10} {
      lappend clist [join $tmp ","]
      set tmp ""
      set cnt 0
    }
  }
  if {$tmp != ""} {
    lappend clist [join $tmp ","]
    set tmp ""
    set cnt 0
  }
  foreach c $clist {
    /quote NOTICE $c :$text
  }
  unset tmp clist c cnt text BASECOLOR
  idle 0
  complete
}
alias amode {
  if ![connected] {
    not_connected
    complete
    return
  }
  set text [join [args]]
  if {[channels] == "" || $text == ""} {
    echo [errEcho "Amode" "usage: /amode <mode>"]
    complete; return
  }
  foreach c [channels] {
    /quote MODE $c $text
  }
  unset text c
  idle 0
  complete
}
alias asound {
  if ![connected] {
    not_connected
    complete
    return
  }
  set sound [lindex [args] 0]
  set text [join [lrange [args] 1 end]]
  if {[channels] == "" || $sound == ""} {
    echo [errEcho "Asound" "usage: /asound <sound> \[text\]"]
    complete; return
  }
  /splay $sound
  foreach c [channels] {
    if {$text != ""} {
      echo [selfsoundtextEcho $c $sound $text] channel $c
    } {
      echo [selfsoundnotextEcho $c $sound] channel $c
    }
  }
  set tmp ""
  set clist ""
  set cnt 0
  foreach c [channels] {
    incr cnt
    lappend tmp $c
    if {$cnt >= 10} {
      lappend clist [join $tmp ","]
      set tmp ""
      set cnt 0
    }
  }
  if {$tmp != ""} {
    lappend clist [join $tmp ","]
    set tmp ""
    set cnt 0
  }
  foreach c $clist {
    if {$text != ""} {
      /quote PRIVMSG $c :\001SOUND $sound $text\001
    } {
      /quote PRIVMSG $c :\001SOUND $sound\001
    }
  }
  unset tmp clist c cnt text sound
  idle 0
  complete
}
alias actcp {
  if ![connected] {
    not_connected
    complete
    return
  }
  set type [lindex [args] 0]
  set text [join [lrange [args] 1 end]]
  if {[channels] == "" || $type == ""} {
    echo [errEcho "Actcp" "usage: /actcp <type> \[text\]"]
    complete; return
  }
  set type [stu $type]
  if {$type == "PING"} { set text "[clock seconds] [clock clicks]" }
  foreach c [channels] { echo [chanctcpText $c [my_nick] [my_user] [my_host] $type $text] channel $c }
  set tmp ""
  set clist ""
  set cnt 0
  foreach c [channels] {
    incr cnt
    lappend tmp $c
    if {$cnt >= 10} {
      lappend clist [join $tmp ","]
      set tmp ""
      set cnt 0
    }
  }
  if {$tmp != ""} {
    lappend clist [join $tmp ","]
    set tmp ""
    set cnt 0
  }
  foreach c $clist {
    if {$text != ""} {
      /quote PRIVMSG $c :\001$type $text\001
    } {
      /quote PRIVMSG $c :\001$type\001
    }
  }
  unset tmp clist c cnt text type
  idle 0
  complete
}
alias wall {
  if ![connected] {
    not_connected
    complete
    return
  }
  if {[window_type] == "status"} { /wallops [join [args]]; complete; return }
  if [ischan [lindex [args] 0]] {
    set dest [lindex [args] 0]
    set text [join [lrange [args] 1 end]]
  } {
    set dest [channel]
    set text [join [args]]
  }
  if {$dest == ""} {
    echo [errEcho Wall "invalid window for /wall"]
    complete; return
  }
  set oplist [ops $dest]
  set pos [lsearch -exact [stl $oplist] [stl [my_nick]]]
  set oplist [lreplace $oplist $pos $pos]
  set opsend ""
  set cnt 0
  set tmp ""
  foreach o $oplist {
    incr cnt
    lappend tmp $o
    if {$cnt >= 10} {
      lappend opsend [join $tmp ","]
      set tmp ""
      set cnt 0
    }
  }
  if {$tmp != ""} {
    lappend opsend [join $tmp ","]
    set tmp ""
    set cnt 0
  }
  foreach opgrp $opsend {
    set out [wallStyle $dest $opgrp $text]
    /quote NOTICE $opgrp :$out
  }
  if {$oplist == ""} {
    echo [errEcho Wall "no other ops detected on $dest"]
    complete; return
  }
  echo [wallEcho $dest $oplist $text] channel $dest
  unset dest oplist text out pos
  idle 0
  complete
}
alias wallchops {
  set dest [lindex [args] 0]
  set text [join [lrange [args] 1 end]]
  if ![ischan $dest] {
    set dest [channel]
    set text [join [args]]
  }
  if {$dest != "" && $text != ""} {
    /quote WALLCHOPS $dest :[wallStyle $dest [ops $dest] $text]
    echo [wallEcho $dest [ops $dest] $text] channel $dest
  } {
    echo [errEcho "Wallchops" "usage: /wallchops \[channel\] <text>"]
  }
  unset dest text
  idle 0
  complete
}
alias xwall {
  set xlist [get_tog "Xwall_List"]
  set text [join [args]]
  if {$text == ""} {
    echo [errEcho "Xwall" "usage: /xwall <text>"]
    complete; return
  }
  if {$xlist != "" && [stl $xlist] != "\001none\001"} {
    set globout [xwallstyle $xlist $text]
    echo [xwallText $xlist $text]
    set xlist [split $xlist ","]
    set xmax ""
    set xcnt 0
    foreach x $xlist {
      set XWALL_TARGET([stl $x]) 1
      incr xcnt
      lappend xmax $x
      if {$xcnt >= 10} {
        /quote NOTICE [join $xmax ","] :$globout
        set xmax ""
        set xcnt 0
      }
    }
    if {$xmax != ""} {
      /quote NOTICE [join $xmax ","] :$globout
      set xmax ""
      set xcnt 0
    }
    unset xmax x xcnt globout
  } {
    echo [errEcho "Xwall" "there are no users in your Xwall_List (/set Xwall_List)"]
  }
  idle 0
  complete
}
alias wallops {
  if ![connected] {
    not_connected
    complete
    return
  }
  set text [join [args]]
  if ![string length $text] {
    echo [errEcho "Wallops" "usage: /wallops <text>"]
    complete; return
  }
  /quote WALLOPS :$text
  unset text
  idle 0
  complete
}
alias kill {
  if ![connected] {
    not_connected
    complete
    return
  }
  set who [lindex [args] 0]
  set msg [join [lrange [args] 1 end]]
  /quote KILL $who :$msg
  idle 0
  complete
}
alias oper {
  if ![connected] {
    not_connected
    complete
    return
  }
  set opernick [lindex [args] 0]
  set operpass [lindex [args] 1]
  if {![string length $opernick] || ![string length $operpass]} {
    echo [errEcho Oper "usage: /oper <user> <pass>"]
  } {
    /quote OPER $opernick $operpass
  }
  unset operpass opernick
  idle 0
  complete
}
proc log {} { set x [get_tog Away_Logging]; if ![string compare [stl $x] "on"] { return "on" } { return "off" } }
proc page {} { set x [get_tog Paging]; if ![string compare [stl $x] "on"] { return "on" } { return "off" } }
proc email {} { return [get_tog "Email_Address"] }
alias away {
  if ![connected] {
    not_connected
    complete
    return
  }
  set reason [join [args]]
  if {$reason == ""} {
    set reason [get_tog "Default_Away_Message"]
    if {![string length $reason] || ![string compare [stl $reason] "\001none\001"]} {
      set reason "[b]a[b]wa[b]y[b]"
    }
  }
  set AWAY_INFO(away) 1
  set AWAY_INFO(at) [clock seconds]
  set AWAY_INFO(reason) $reason
  set AWAY_INFO(msgs) 0
  if [string length [channels]] {
    /ame [awaystyle $reason [log] [page] [email]]
  } {
    echo [selfchanAction "" [awaystyle $reason [log] [page] [email]]]
  }
  /quote AWAY :[awaytext $reason [log] [page] [email]]
  set x [get_tog "Away_Log"]
  if ![file exists [dirname $x]] {
    file mkdir [dirname $x]
  }
  if ![file exists $x] {
    filebuild $x
  }
  set x [open $x a]
  set out [awaylogStyle AWAY 0 "" [my_nick] [my_user] [my_host] $reason]
  puts $x $out
  catch {flush $x}
  catch {close $x}
  unset x out reason
  complete
}
alias back {
  if ![connected] {
    not_connected
    complete
    return
  }
  if {![info exists AWAY_INFO] || !$AWAY_INFO(away)} {
    echo [errEcho Back "you are not flagged away"]
    complete; return
  }
  set reason [join [args]]
  if {$reason == ""} {
    set reason [get_tog "Default_Back_Message"]
  }
  if ![info exists AWAY_INFO(msgs)] {
    set AWAY_INFO(msgs) 0
  }
  set origmsg $AWAY_INFO(reason)
  if ![isint $AWAY_INFO(at)] {
    set AWAY_INFO(at) [clock seconds]
  }
  set gonefor [expr [clock seconds]-$AWAY_INFO(at)]
  if [string length [channels]] {
    /ame [backstyle $origmsg $reason $gonefor]
  } {
    echo [selfchanAction "" [backstyle $origmsg $reason $gonefor]]
  }
  /quote AWAY
  set x [get_tog "Away_Log"]
  if ![file exists [dirname $x]] {
    file mkdir [dirname $x]
  }
  if ![file exists $x] {
    filebuild $x
  }
  set x [open $x a]
  set out [awaylogStyle BACK $AWAY_INFO(msgs) "" [my_nick] [my_user] [my_host] $reason]
  puts $x $out
  catch {flush $x}
  catch {close $x}
  echo [awayinfoEcho $origmsg $reason $gonefor $AWAY_INFO(msgs)]
  unset x out reason AWAY_INFO origmsg gonefor
  if [info exists AWAY_NICKS] { unset AWAY_NICKS }
  complete
}
alias hop {
  set partlist [lindex [args] 0]
  set joinlist [lindex [args] 1]
  set fin ""
  foreach d [split $joinlist ","] {
    if ![ischan $d] { set d "#$d" }
    if {$fin == ""} { set fin $d } { set fin "${fin},$d" }
    set SYNC_TIME([stl $d]) [clock clicks]
  }
  set joinlist $fin
  set fin ""
  foreach d [split $partlist ","] {
    if ![ischan $d] { set d "#$d" }
    if [onchan [my_nick] $d] {
      if {$fin == ""} { set fin $d } { set fin "${fin},$d" }
    }
  }
  set partlist $fin
  if {$partlist != ""} { /quote PART $partlist }
  if {$joinlist != ""} { /quote JOIN $joinlist }
  complete
}
alias cycle {
  if ![connected] {
    not_connected
    complete
    return
  }
  set dest [lindex [args] 0]
  if {$dest == ""} {
    set dest [channel]
  }
  if {$dest == "" && [window_type] == "status"} {
    /cycleserver
    complete; return
  }
  set dest [split $dest ","]
  set fin ""
  foreach d $dest {
    if ![ischan $d] {
      set d #$d
    }
    set failed 0
    if ![onchan [my_nick] $d] {
      echo [errEcho cycle "you're not on $d, unable to cycle"]
      set failed 1
    }
    if {[pos [lindex [mode $d] 0] "i"] != -1} {
      echo [errEcho cycle "$d is invite only (+i), unable to cycle"]
      set failed 1
    }
    set chan_lim [get_chan_lim [mode $d]]
    if {$chan_lim == ""} { set chan_lim 0 }
    if {$chan_lim != 0 && $chan_lim < [llength [nicks $dest]]} {
      echo [errEcho cycle "$dest has a limit (+l) of $chan_lim, unable to cycle"]
      set failed 1
    }
    set chan_key([stl $d]) [get_chan_key [mode $d]]
    if !$failed {
      set SYNC_TIME([stl $d]) [clock clicks]
      if {$fin == ""} { set fin $d } { set fin "${fin},$d" }
    }
  }
  set dest $fin
  if {$fin != ""} { /quote PART $dest }
  set key_list ""
  set dest [split $dest ","]
  foreach d $dest {
    if [info exists chan_key([stl $d])] {
      set key_list "$key_list$chan_key([stl $d])"
    }
    set key_list "${key_list},"
  }
  set dest [join $dest ","]
  if {$dest != ""} {
    if {[join [split $key_list ","] ""] == ""} {
      /quote JOIN $dest
    } {
      /quote JOIN $dest $key_list
    }
  }
  unset chan_key chan_lim key_list dest d fin
  idle 0
  complete
}
alias join {
  if ![connected] { not_connected; complete; return }
  set chan [lindex [args] 0]; set rest [join [lrange [args] 1 end]]
  if {[pos $chan ","] != -1} {
    set c_list ""; foreach c [split $chan ","] { if ![ischan $c] { set c #$c }; set SYNC_TIME([stl $c]) [clock clicks]; if {$c_list == ""} { set c_list $c } { set c_list "$c_list,$c" } }; set chan $c_list
  } {
    if ![ischan $chan] { set chan #$chan }
    set SYNC_TIME([stl $chan]) [clock clicks]
  }
  if {$rest == ""} { /quote JOIN $chan } { /quote JOIN $chan $rest }; unset chan rest; idle 0
  complete
}
alias part {
  if ![connected] {
    not_connected
    complete
    return
  }
  set chan [lindex [args] 0]
  set rest [join [lrange [args] 1 end]]
  if ![string length $chan] { set chan [channel] }
  if [string length $chan] {
    if {[pos $chan ","] != -1} {
      set c_list ""
      foreach c [split $chan ","] {
        if ![ischan $c] {
          set c #$c
        }
        if ![string length $c_list] {
          set c_list $c
        } {
          set c_list "$c_list,$c"
        }
      }
      set chan $c_list
    } {
      if ![ischan $chan] {
        if [lfind [channels] "#${chan}"] {
          set chan "#${chan}"
        } elseif [lfind [channels] "&${chan}"] {
          set chan "&${chan}"
        } elseif [string length [channel]] {
          set chan [channel]
          set rest [join [args]]
        } {
          echo [errEcho "Part" "usage: /part \[channel\] \[part message\]"]; complete; return
        }
      }
    }
    if ![string length $rest] { /quote PART $chan } { /quote PART $chan :$rest }
  }
  unset chan rest
  idle 0
  complete
}
alias partall {
  set idx 0
  set tmp ""
  set c ""
  set part_msg [join [args]]
  foreach c [channels] {
    incr idx
    lappend tmp $c
    if {$idx >= 10} {
      if [string length $part_msg] {
        /quote PART [join $tmp ","] :$part_msg
      } {
        /quote PART [join $tmp ","]
      }
      set idx 0
      set tmp ""
    }
  }
  if {$tmp != ""} {
    if [string length $part_msg] {
      /quote PART [join $tmp ","] :$part_msg
    } {
      /quote PART [join $tmp ","]
    }
  }
  unset tmp idx c
  idle 0
  complete
}
alias quit {
  set reason [join [args]]
  if ![string length $reason] {
    if ![file exists "[pwd]/sin0.quit"] {
      set reason [defquitMsg]
      if ![string length $reason] {
        set reason "[my_nick]: signing off -[b]s[b]\[[b]z[b]\]-"
      }
    } {
      set reason [line "[pwd]/sin0.quit" "r"]
      if ![string length $reason] {
        set reason "[my_nick]: signing off -[b]s[b]\[[b]z[b]\]-"
      } else {
        if [info exists sin_zero(truevers)] { set ver $sin_zero(truevers) } { set ver "2.xx" }
        set reason [replace $reason "%s" "Sin[b]([b]zero[u]/[u]${ver}[b])[b]"]
        unset ver
      }
    }
    /quit $reason
  } {
    if ![strcmpi [get_tog "Stats_On_Quit"] "on"] {
      set dtime [clock seconds]
      set otime [expr [clock seconds]-[online]]
      echo [quitinfoText $otime $dtime]
      unset dtime otime
    }
    foreach c [channels] { echo [defquitText [my_nick] [my_user] [my_host] $reason] channel $c }
    echo [defquitText [my_nick] [my_user] [my_host] $reason] status
  }
}
proc quitinfoText {signon signoff} {
  if [string length [get_env "QuitInfo"]] {
    return [eval return [get_env "QuitInfo"]]
  }
  return "[c]10 [c]11Connected[c]15   : [clock format $signon]\n[c]10 [c]11Disconnected[c]15: [clock format $signoff]\n[c]10 [c]11Online[c]15      : [duration [online]]"
}
alias server {
  if ![string length [join [args]]] {
    /servlist
    complete; return
  }
  set server [lindex [args] 0]
  if [isint $server] {
    set serv [readini [userfile] "Servers" $server]
    if [string length $serv] {
      unset server
      /server $serv
      unset serv
      complete
    } {
      echo [errEcho "Server" "invalid server index: $server"]
      unset server
      complete; return
    }
  } {
    if [connected] {
      /quote QUIT :[b]s[b]in([b]s[b]erver [b]c[b]hange)
    }
  }
}
alias newserver {
  if ![string length [join [args]]] {
    /servlist
    complete; return
  }
  set server [lindex [args] 0]
  if [isint $server] {
    set serv [readini [userfile] "Servers" $server]
    if [string length $serv] {
      unset server
      /newserver $serv
      unset serv
      complete
    } {
      echo [errEcho "Newserver" "invalid server index: $server"]
      unset server
      complete; return
    }
  }
}
alias serv {
  set cmd [lindex [args] 0]
  set serv [lindex [args] 1]
  set port [lindex [args] 2]
  if [string length $cmd] {
    switch -- [stu $cmd] {
      "ADD" {
        if [string length $serv] {
          if ![string length $port] { set port "6667" }
          set conf [userfile]
          set x 1
          while {[string length [readini $conf "Servers" $x]]} { incr x }
          if [writeini $conf "Servers" $x "$serv:$port"] {
            echo [servlistAdd $x $serv $port]
          }
        } {
          echo [errEcho "Serv" "usage: /serv add <server> \[port\]"]
        }
      }
      "REM" {
        if [string length $serv] {
          set conf [userfile]
          set s [readini $conf "Servers" $serv]
          if [string length $s] {
            set pos [pos $s ":"]
            if {$pos == -1} {
              set server $s; set port 6667
            } {
              set server [string range $s 0 [expr $pos-1]]
              set port [string range $s [expr $pos+1] end]
            }
            if {$port == ""} { set port 6667 }
            remini $conf "Servers" $serv
            echo [servlistRem $serv $server $port]
          } {
            echo [errEcho "Serv" "no such index: $serv"]
          }
        } {
          echo [errEcho "Serv" "usage: /serv rem <idx>"]
        }        
      }
      "LIST" {
        set conf [userfile]
        set list [readini $conf "Servers"]
        if [string length [replace $list " " ""]] {
          echo [servlistTop]
          foreach s [split $list "\n"] {
            set pos [pos $s "="]
            if {$pos != -1} {
              set idx [string range $s 0 [expr $pos-1]]
              set servport [string range $s [expr $pos+1] end]
              set pos [pos $servport ":"]
              if {$pos == -1} {
                set server $servport; set port 6667
              } {
                set server [string range $servport 0 [expr $pos-1]]
                set port [string range $servport [expr $pos+1] end]
              }
              if {$port == ""} { set port 6667 }
              echo [servlistItem $idx $server $port]
            }
          }
          echo [servlistEnd]
        } {
          echo [errEcho "Serv" "no servers in server list"]
        }
      }
      default {
        echo [errEcho "Serv" "uknown option: $cmd"]
      }
    }
  } {
    echo [errEcho "Serv" "usage: /serv <ADD|REM|LIST> \[server\] \[port\]"]
  }
  complete
}
alias cycleserver {
  if ![connected] {
    not_connected
    complete
    return
  }
  /server [server]
  complete
}
alias topic {
  set chan [lindex [args] 0]
  set topic [join [lrange [args] 1 end]]
  if {![ischan $chan] && [string length [channel]]} {
    set chan [channel]
    set topic [join [args]]
  } elseif ![ischan $chan] {
    echo [errEcho "Topic" "usage: /topic \[channel\] <topic>"]
    unset chan topic
    complete; return
  }
  if ![string length $topic] { /quote TOPIC $chan } { /quote TOPIC $chan :$topic }
  complete
}
alias top {
  set chan [lindex [args] 0]
  if ![ischan $chan] { set chan [channel] }
  if [string length $chan] {
    set topic [topic $chan]
    set nt [prompt "Topic: $chan" "Enter a new Topic:" $topic]
    if [string length $nt] {
      /quote TOPIC $chan :$nt
    }
    unset topic nt
  } {
    echo [errEcho "Top" "usage: /top \[channel\]"]
  }
  unset chan
  complete
}
alias mode {
  if ![connected] {
    not_connected
    complete
    return
  }
  set dest [lindex [args] 0]
  if {$dest == ""} {
    if {[window_type] == "channel"} {
      set dest [channel]
    } {
      set dest [my_nick]
    }
  }
  set mode [join [lrange [args] 1 end]]
  if {[ischan $dest] || $dest == [my_nick]} {
    if {$mode != ""} {
      /quote MODE $dest $mode
    } {
      /quote MODE $dest
    }
  } {
    set m [string index $dest 0]
    if {$m == "+" || $m == "-"} {
      set mode [join [args]]
      if {[channel] != ""} {
        if {$mode != ""} {
          /quote MODE [channel] $mode
        } {
          /quote MODE [channel]
        }
      } {
        if {$mode != ""} {
          /quote MODE [my_nick] $mode
        } {
          /quote MODE [my_nick]
        }
      }
    } {
      if {$dest == ""} { set dest [channel] }
      if {$mode != ""} {
        /quote MODE $dest $mode
      } {
        /quote MODE $dest
      }
    }
  }
  unset dest mode
  idle 0
  complete
}
alias rnick {
  set nick [lindex [args] 0]
  set giveup [lindex [args] 1]
  if [info exists REGAIN_NICK_START] { unset REGAIN_NICK_START }
  if [info exists REGAIN_NICK_CYCLES] { unset REGAIN_NICK_CYCLES }
  if [info exists REGAIN_NICK_TIMER] { unset REGAIN_NICK_TIMER }
  if [info exists REGAIN_NICK_TIMES] { unset REGAIN_NICK_TIMES }
  if ![string length $nick] {
    echo [errEcho "Rnick" "usage: /rnick <nick> \[times\]"]
    unset nick giveup
    complete; return
  }
  if ![string length $giveup] { set giveup -1 }
  set REGAIN_NICK $nick
  set REGAIN_NICK_TIMES $giveup
  /quote NICK :$nick
  unset nick giveup
  complete
}
alias randnick {
  set niq [randascii 10]
  /quote NICK $niq
  complete
}
alias banlist {
  set dest [lindex [args] 0]
  set idx [lindex [args] 1]
  if ![ischan $dest] {
    set dest [channel]
    set idx [lindex [args] 0]
  }
  if [string length $dest] {
    if {![isint $idx] || ![string length $idx]} { set idx 0 }
    set RETR_BAN_LIST([stl $dest]) $idx
    /quote MODE $dest +b
  } {
    echo [errEcho "Banlist" "usage: /banlist \[channel\]"]
  }
  idle 0
  complete
}
alias ctcp {
  if ![connected] {
    not_connected
    complete
    return
  }
  set dest [lindex [args] 0]
  set type [lindex [args] 1]
  set rest [join [lrange [args] 2 end]]
  if [string length $type] {
    foreach d [split $dest ","] { if ![ischan $d] { set NO_SUCH_USER_FAILSAFE([stl $d]) [stl $d] } }
    set type [string toupper $type]
    if {$type == "PING"} {
      set rest [clock clicks]
    }
    if [string length $rest] {
      /quote PRIVMSG $dest :\001$type $rest\001
    } {
      /quote PRIVMSG $dest :\001$type\001
    }
    echo [selfctcpText $dest $type $rest]
  } {
    echo [errEcho "Ctcp" "Usage: /ctcp <target> <type> \[args\]"]
  }
  unset dest type rest
  idle 0
  complete
}
alias ctcpr {
  if ![connected] {
    not_connected
    complete
    return
  }
  set dest [lindex [args] 0]
  set type [lindex [args] 1]
  set rest [join [lrange [args] 2 end]]
  if {[llength [join [args]]] >= 2} {
    if {$rest != ""} {
      /quote NOTICE $dest :\001$type $rest\001
    } {
      /quote NOTICE $dest :\001$type\001
    }
    echo [selfctcpText $dest $type $rest]
  } {
    echo [errEcho "Ctcpr" "Usage: /ctcpr <target> <type> \[args\]"]
  }
  idle 0
  complete
}
alias who {
  if ![connected] {
    not_connected
    complete; return
  }
  set who_patt [join [args]]
  if {$who_patt == ""} {
    switch -- [window_type] {
      "channel" { set who_patt [channel] }
      "stauts" { set who_patt [serv] }
      "query" { set who_patt [query] }
      "chat" { set who_patt [chat] }
      default {
        echo [errEcho Who "no target specified"]
        complete; return
      }
    }
  }
  /quote WHO $who_patt
  idle 0
  complete
}
alias userhost {
  if ![connected] {
    not_connected
    complete; return
  }
  set nick [join [args]]
  set nick [replace $nick "\{" "\\\{"]
  set nick [replace $nick "\}" "\\\}"]
  foreach n $nick {
    set USERHOST([stl $n]) 1
  }
  /quote USERHOST [join $nick]
  idle 0
  complete
}
alias userip {
  if ![connected] {
    not_connected
    complete; return
  }
  set nick [join [args]]
  foreach n $nick {
    set USERIP([stl $n]) 1
  }
  /quote USERIP $nick
  idle 0
  complete
}
proc readwhois {sock} {
  if [eof $sock] { catch {close $sock} }
  if [window exists query .WHOIS] { set d1 "query"; set d2 ".WHOIS" } { set d1 "status"; set d2 "" }
  echo [read $sock] $d1 $d2
}
alias whois {
  if ![connected] {
    not_connected
    complete
    return
  }
  set whois [lindex [args] 0]
  if {[isin $whois "?"] || [isin $whois "*"]} { /who [join [args]]; complete; return }
  set WHOIS_OUT 0
  if ![string compare [string index $whois 0] "@"] {
    set host [string range $whois 1 end]
    set wsrv [lindex [args] 1]
    if ![string length $wsrv] { set wsrv "whois.internic.net" }
    if ![catch {socket -async $wsrv 43} wSock] {
      if ![catch {puts $wSock "$host"}] {
        if [catch {flush $wSock}] {
          echo [errEcho "Whois Lookup" "unable to communicate with $wsrv"]
          catch {close $wSock}
        } {
          if [connected] { /query .WHOIS; window set_title "Whois Domain Lookup: $host" query .WHOIS }
          fileevent $wSock readable "readwhois $wSock"
        }
        unset wSock
      } {
        echo [errEcho "Whois Lookup" "unable to communicate with $wsrv"]
      }
    } {
      echo [errEcho "Whois Lookup" "unable to contact $wsrv"]
    }
    complete; return
  }
  set rest [join [lrange [args] 1 end]]
  if ![strcmpi $whois "-t"] { set whois [lindex [args] 1]; set rest ""; set WHOIS_OUT 1 }
  if ![string length $whois] {
    switch -- [window_type] {
      "channel" { set whois [join [lrange [nnicks [channel]] 0 3] ","] }
      "query" { set whois [query] }
      default {
        echo [errEcho "Whois" "usage: /whois <nick1>\[,<nick2>..\]"]
        complete; return
      }
    }
  }
  if {[pos $whois ","] != -1} {
    foreach w [split $whois ","] {
      set WHOIS([stl $w]) 1
      if $WHOIS_OUT { set WHOIS([stl $w]:pubout) 1 }
    }
  } {
    set WHOIS([stl $whois]) 1
    if $WHOIS_OUT { set WHOIS([stl $whois]:pubout) 1 }
  }
  if ![string length $rest] {
    /quote WHOIS $whois
  } {
    /quote WHOIS $whois $rest
  }
  catch {unset whois rest w}
  idle 0
  complete
}
alias whowas {
  if ![connected] {
    not_connected
    complete
    return
  }
  set whois [lindex [args] 0] 
  set rest [join [lrange [args] 1 end]]
  if {$whois == ""} {
    echo [errEcho "Whowas" "usage: /whowas <nick1>\[,<nick2>..<nickN>\]"]
    complete; return
  }
  if {[pos $whois ","] != -1} {
    foreach w [split $whois ","] {
      set WHOWAS([stl $w]) 1
    }
  } {
    set WHOWAS([stl $whois]) 1
  }
  if {$rest == ""} {
    /quote WHOWAS $whois
  } {
    /quote WHOWAS $whois $rest
  }
  catch {unset whois rest w}
  idle 0
  complete
}
alias scan {
  if ![connected] {
    not_connected
    complete
    return
  }
  set dest [lindex [args] 1]
  set type [lindex [args] 0]
  if {$dest == ""} {
    switch -- [window_type] {
      "channel" { set dest [channel] }
      "status" { set dest [serv] }
      default {
        echo [errEcho Scan "no target specified"]
        complete; return
      }
    }
  }
  switch -- [stl $type] {
    "clone" { set CLONE_SCAN(chk) $dest }
    "oper" { set OPER_SCAN(chk) $dest }
    "ial" { set IAL_SCAN(chk) $dest }
    default {
      echo [errEcho "Scan" "usage: /scan <oper|clone|ial> <target>"]
      complete; return
    }
  }
  /quote WHO $dest
  idle 0
  complete
}
alias names {
  if {[join [args]] == ""} {
    switch -- [window_type] {
      "channel" { set dest [channel] }
      "status" { set dest [serv] }
      default {
        echo [errEcho Names "no target specified"]
        complete; return
      }
    }
    /quote NAMES $dest
    unset dest
  } {
    /quote NAMES [join [args]]
  }
  idle 0
  complete
}
alias nsqueue {
  if {[info exists DNS_LIST] && [string length $DNS_LIST]} {
    echo [dnsqueueHead [llength $DNS_LIST]]
    foreach e $DNS_LIST {
      echo [dnsqueueItem $e]
    }
    echo [dnsqueueEnd [llength $DNS_LIST]]
  } {
    echo [errEcho "Nsqueue" "no hostnames to resolve."]
  }
  complete
}
alias nslookup {
  set hostnames [join [args]]
  set USERHOST_QUEUE ""
  foreach hostname $hostnames {
    if {[string match *.* $hostname] || ![strcmp [string index $hostname 0] "^"]} {
      if ![strcmp [string index $hostname 0] "^"] { set hostname [string range $hostname 1 end] }
      if ![info exists DNS_LIST] {
        set DNS_LIST ""
      }
      if ![lfind $DNS_LIST $hostname] {
        lappend DNS_LIST $hostname
        echo [dnsattemptEcho $hostname]
        lookup $hostname
      }
    } {
      if {[get_ial $hostname] != ""} {
        set host [lindex [split $IAL([stl $hostname]) "@"] 1]
        echo [dnsattemptEcho $host]
        if ![info exists DNS_LIST] {
          set DNS_LIST ""
        }
        if ![lfind $DNS_LIST $host] {
          lappend DNS_LIST $host
          lookup $host
        }
      } { 
        if ![info exists DNS_GETHOST] {
          set DNS_GETHOST $hostname
        } {
          lappend DNS_GETHOST $hostname
        }
        lappend USERHOST_QUEUE $hostname
      }
    }
  }
  if [string length $USERHOST_QUEUE] {
    /quote USERHOST $USERHOST_QUEUE
  }
  catch {unset USERHOST_QUEUE}
  idle 0
  complete
}
alias rdisp {
  set ch [lindex [args] 0]
  set li [lindex [args] 1]
  if {![ischan $ch] && [string length $ch]} {
    if [isint $ch] {
      set li $ch
      set ch [channel]
    } {
      set ch "#${ch}"
    }
  }
  if ![string length $ch] { set ch [channel] }
  if ![string length $ch] {
    echo [errEcho "Rdisp" "usage: /rdisp \[channel\] \[lines\]"]
    unset ch li
    complete; return
  }
  if [info exists RDISP_SPOOL([stl $ch])] {
    if ![isint $li] { set li $RDISP_SPOOL([stl $ch]) }
    if {$li > $RDISP_SPOOL([stl $ch])} { set li $RDISP_SPOOL([stl $ch]) }
    if [connected] { /query .RDISP; window set_title "Sin(zero) - Rdisp $ch" query .RDISP }
    if [window exists query ".RDISP"] { set d1 "query"; set d2 ".RDISP" } elseif [window exists channel $ch] { set d1 "channel"; set d2 $ch } { set d1 "status"; set d2 "" }
    echo [rdispHead $ch $li] $d1 $d2
    for {set x [expr $RDISP_SPOOL([stl $ch])-$li]} {$x < $RDISP_SPOOL([stl $ch])} {incr x} {
      if [info exists RDISP_SPOOL([stl $ch]:${x})] {
        echo [rdispEcho $RDISP_SPOOL([stl $ch]:${x})] $d1 $d2
      }
    }
    echo [rdispEnd $ch $li] $d1 $d2
    unset x d1 d2
  } {
    echo [errEcho "Rdisp" "no lines found for $ch"]
  }
  unset ch li
  complete
}
alias tsearch {
  set ch [lindex [args] 0]
  set text [lrange [args] 1 end]
  if ![string length $ch] {
    echo [errEcho "Tsearch" "usage: /tsearch \[channel\] <text>"]
    unset ch text
    complete; return
  }
  if {![ischan $ch] && [strcmpi $ch "*"] != 0} {
    lappend ch $text
    set text $ch
    set ch [channel]
  }
  if ![string length $ch] {
    echo [errEcho "Tsearch" "usage: /tsearch \[channel\] <text>"]
    unset ch text
  }
  if ![info exists SAID_SPOOL] {
    echo [errEcho "Tsearch" "no text has been spooled."]
    unset ch text 
    complete; return
  }
  set text [string trimright [join $text] " "]
  set tmp 0
  foreach a [array names SAID_SPOOL] { if [string match "[stl $ch]:*" [stl $a]] { set tmp 1; unset a; break }; unset a }
  if !$tmp { echo [errEcho "Tsearch" "no text from $ch has been spooled"]; unset tmp; complete; return }
  unset tmp
  if [connected] { /query .TSEARCH; window set_title "Sin(zero) - Tsearch $text ($ch)" query .TSEARCH }
  if [window exists query .TSEARCH] { set d1 "query"; set d2 ".TSEARCH" } { set d1 "status"; set d2 "" }
  echo [tsearchHead $ch $text] $d1 $d2
  set match 0
  set list [lsort [array names SAID_SPOOL]]
  foreach a $list {
    if ![strcmpi $ch "*"] { set x 1 } { set x [string match "[stl $ch]:*" $a] }
    if $x {
      set chan [lindex [split $a ":"] 0]
      foreach l [split $SAID_SPOOL($a) "\n"] {
        if [string match "*[stl $text]*" [stl $l]] {
          echo [tsearchEcho $chan $l] $d1 $d2
          incr match
        }
        unset l
      }
      unset chan
    }
    unset a x
  }
  echo [tsearchEnd $ch $text $match] $d1 $d2
  unset match d1 d2 ch text list
  complete
}
alias said {
  set ch [lindex [args] 0]
  set ni [lindex [args] 1]
  if ![ischan $ch] {
    if [string length [channel]] {
      set ni $ch
      set ch [channel]
    } {
      echo [errEcho "Said" "usage: /said \[channel\] <nick>"]
      complete; return
    }
  }
  if ![string length [replace $ni " " ""]] {
    echo [errEcho "Said" "usage: /said \[channel\] <nick>"]
    complete; return
  }
  if ![info exists SAID_SPOOL([stl $ch]:[stl $ni])] {
    echo [errEcho "Said" "no text from $ni on $ch has been spooled"]
  } {
    if [connected] { /query .SAID; window set_title "Sin(zero) - Said $ni on $ch" query .SAID }
    if [window exists query .SAID] {
      set d1 "query"; set d2 ".SAID"
    } {
      set d1 "status"; set d2 ""
    }
    echo $SAID_SPOOL([stl $ch]:[stl $ni]) $d1 $d2
  }
  complete
}
alias sinquote {
  set idx [lindex [args] 0]
  if ![isint $idx] { set idx -1 }
  switch -- [stl [window_type]] {
    "query" { set valid_win 1 }
    "chat" { set valid_win 1 }
    "channel" { set valid_win 1 }
    default { set valid_win 0 }
  }
  if $valid_win {
    if [info exists sin_zero(quotes)] {
      if {$idx > [llength $sin_zero(quotes)]} { set idx -1 }
      if {$idx < 0} {
        set quote [randitem $sin_zero(quotes)]
      } {
        set quote [lindex $sin_zero(quotes) [expr $idx-1]]
      }
    } {
      set quote "/say %s: Take It Like A Man"
    }
    if [info exists sin_zero(truevers)] { set ver $sin_zero(truevers) } { set ver "2.xx" }
    set quote [replace $quote "%s" "Sin[b]([b]zero[u]/[u]${ver}[b])[b]"]
    unset ver
    $quote
  }
  unset valid_win quote idx
  idle 0
  complete
}
alias exec {
  set cmdline ""
  for {set x 0} {$x < [llength [args]]} {incr x} {
    if ![string length $cmdline] {
      set cmdline "\[lindex \[args\] $x\]"
    } {
      set cmdline "$cmdline \[lindex \[args\] $x\]"
    }
  }
  if {[catch {eval "exec $cmdline &"}]} {
    echo [errEcho Exec "unable to execute [join [args]]"]
  }
  idle 0
  complete
}
alias run {
  if {![info exists sin_zero(FALC_LOAD)] || !$sin_zero(FALC_LOAD)} {
    echo [errEcho "Run" "this alias requires Falcon.DLL which was not properly loaded."]
    complete; return
  }
  set cmd [lindex [args] 0]
  set parms [join [lrange [args] 1 end]]
  set cmd [replace $cmd "\\" "\\\\"]
  set parms [replace $parms "\\" "\\\\"]
  if [string length $parms] {
    if {[catch {eval "FALC_shell -v open -p $parms -s norm $cmd"}]} { echo [errEcho Run "unable to execute $cmd \[$parms\]"] }
  } {
    if {[catch {eval "FALC_shell -v open -s norm $cmd"}]} { echo [errEcho Run "unable to execute $cmd"] }
  }
  unset cmd parms
  idle 0
  complete  
}
alias explore {
  if {![info exists sin_zero(FALC_LOAD)] || !$sin_zero(FALC_LOAD)} {
    echo [errEcho "Explore" "this alias requires Falcon.DLL which was not properly loaded."]
    complete; return
  }
  set cmdline [join [args]]
  if {[catch {FALC_shell -v explore -s norm $cmdline}]} { echo [errEcho Explore "unable to explore [join [args]]"] }
  idle 0
  complete  
}
alias say {
  if ![connected] {
    not_connected
    complete
    return
  }
  set alias_say_text [join [args]]
  switch -- [stl [window_type]] {
    "chat" { /msg =[window_name] $alias_say_text }
    "query" { /msg [window_name] $alias_say_text }
    "channel" { /msg [window_name] $alias_say_text }
    default { echo [errEcho "Say" "invalid window specifications."] }
  }
  unset alias_say_text
  idle 0
  complete
}
alias echo {
  echo [join [args]]
  idle 0
  complete
}
alias tog {
  if {[info exists sin_zero(FALC_LOAD)] && $sin_zero(FALC_LOAD)} {
    if ![string length [args]] {
      set bs [lsort [get_cookie BOOL_TOGS]]; set b_tmp ""
      set bool_out(0) ""; set bool_out(1) ""; set x 0; set longest [longest $bs 1]
      foreach b $bs { lappend bool_out($x) $b; if {$x == 1} { set x 0 } { incr x } }
      set l1 [longest $bool_out(0) 1]; set l2 [longest $bool_out(1) 1]; set x 0
      foreach b $bool_out(0) { lappend b_tmp [list check -v [get_tog $b] chk[expr $x+1] 1 [expr $x*15] [expr $l1*5] 12 $b]; incr x }
      set y $x; set x 0
      foreach b $bool_out(1) { lappend b_tmp [list check -v [get_tog $b] chk${y} [expr $l1*6+5] [expr $x*15] [expr $l1*5] 12 $b]; incr y; incr x }
      set winWidth [expr $l1*6+$l2*6]; set winHeight [expr 15*[llength $bool_out(0)]]
      set out [FALC_dialog -t "Boolean Toggles" $winWidth $winHeight $b_tmp]
      if [string length $out] { set x 0; foreach b $bool_out(0) { set val [lindex [lindex $out $x] 1]; if {$val == 1} { set val "on" } { set val "off" }; set_tog $b $val; incr x }; foreach b $bool_out(1) { set val [lindex [lindex $out $x] 1]; if {$val == 1} { set val "on" } { set val "off" }; set_tog $b $val; incr x } } { catch {unset out b bool_out x y b_tmp winWidth winHeight longest bs}; complete; return }
      catch {unset b bool_out x l1 l2 longest bs b_tmp out}
      set ss [lsort [get_cookie STRING_TOGS]]; set x 0; set y 0; set l1 [longest $ss 1]
      foreach s $ss {
        if ![info exists s_tmp($y)] { set s_tmp($y) "" }
        lappend s_tmp($y) [list label lbl 5 [expr $x*15] [expr $l1*5] 12 $s]
        lappend s_tmp($y) [list edit edt[expr $x+1] [expr $l1*5] [expr $x*15] [expr $l1*5] 12 [get_tog $s]]
        incr x
        if {$x >= 15} { set x 0; incr y }
      }
      set y 0
      foreach a [array names s_tmp] {
        set out [FALC_dialog -t "String Toggles: Page [expr $a+1] of [expr [lindex [lsort -integer [array names s_tmp]] end]+1]" $winWidth $winHeight $s_tmp($a)]
        if ![string length $out] {
          catch {unset s_tmp out ss s x y}
          complete; return
        } {
          for {set x 0} {$x < [llength $out]} {incr x} {
            set vt [lindex [lindex $out $x] 1]
            if ![string length $vt] { set vt "\001none\001" }
            set_tog [lindex $ss $y] $vt
            incr y
            unset vt
          }
          unset out
        }
      }
      catch {unset s_tmp u x y s ss};  set ss [lsort [get_cookie USER_TOGS]]; set x 0; set y 0; set l1 [longest $ss 1]
      foreach s $ss {
        if ![info exists s_tmp($y)] { set s_tmp($y) "" }
        if ![info exists s_tmpb($y)] { set s_tmpb($y) "" }
        lappend s_tmp($y) [list label lbl 5 [expr $x*15] [expr $l1*5] 12 $s]
        lappend s_tmp($y) [list edit edt[expr $x+1] [expr $l1*5] [expr $x*15] [expr $l1*5] 12 [get_tog $s]]
        incr x
        if {$x >= 15} { set x 0; incr y }
      }
      set y 0
      foreach a [array names s_tmp] {
        set out [FALC_dialog -t "User Toggles: Page [expr $a+1] of [expr [lindex [lsort -integer [array names s_tmp]] end]+1]" $winWidth $winHeight $s_tmp($a)]
        if ![string length $out] {
          catch {unset out s_tmp ss x y l1}
          complete; return
        } {
          for {set x 0} {$x < [llength $out]} {incr x} {
            set_tog [lindex $ss $y]  [lindex [lindex $out $x] 1]
            incr y
          }
        }
      }
      catch {unset winWidth winHeight s_tmp ss s}
    } {
      set tog [lindex [args] 0]
      set val [join [lrange [args] 1 end]]
      if ![string length $val] {
        set val [get_tog $tog]
        if ![string length $val] {
          set val_tmp $tog
          set tmp_char [string index $val_tmp [expr [string length $val_tmp]-1]]
          if {![cmpchar $tmp_char "*"] && ![cmpchar $tmp_char "?"]} { set val_tmp "${val_tmp}*" }
          set u_tmp ""; set s_tmp ""; set b_tmp ""; set cnt 0
          foreach b [get_cookie "BOOL_TOGS"] { if [string match [stl $val_tmp] [stl $b]] { if !$cnt { set cnt 1 }; lappend b_tmp $b } }
          foreach s [get_cookie "STRING_TOGS"] { if [string match [stl $val_tmp] [stl $s]] { if !$cnt { set cnt 1 }; lappend s_tmp $s } }
          foreach u [get_cookie "USER_TOGS"] { if [string match [stl $val_tmp] [stl $u]] { if !$cnt { set cnt 1 }; lappend u_tmp $u } }
          if $cnt {
            set outp ""
            set cnt 1
            set val_list ""; set tog_list ""
            foreach b $b_tmp { set val [get_tog $b]; lappend tog_list $b; lappend val_list $val }
            foreach s $s_tmp { set val [get_tog $s]; lappend tog_list $s; lappend val_list $val }
            foreach u $u_tmp { set val [get_tog $u]; lappend tog_list $u; lappend val_list $val }
            set long_val [longest $val_list 1]
            set long_tog [longest $tog_list 1]
            if {$long_val == 1} { incr long_val }
            if {$long_tog == 1} { incr long_tog }
            for {set x 0} {$x<[llength $tog_list]} {incr x} {
              set tog [lindex $tog_list $x]; set val [lindex $val_list $x]
              if ![string compare [stl [tog_type $tog]] "bool"] {
                lappend outp [list check -v $val chk1 5 [expr $cnt*12] [expr $long_tog*6] 12 $tog]
              } {
                lappend outp [list label lbl1 5 [expr $cnt*12] [expr $long_tog*6] 12 $tog]
                lappend outp [list edit edt1 [expr $long_tog*6+5] [expr $cnt*12] [expr $long_val*6] 12 $val]
              }
              incr cnt
            }
            set out [FALC_dialog -t "Set Toggle Value" [expr $long_tog*6+$long_val*6+20] [expr $cnt*12+20] $outp]
            if [string length $out] {
              set val_list ""
              foreach i $out { lappend val_list [lindex $i 1] }
              for {set x 0} {$x<[llength $tog_list]} {incr x} {
                set v_tmp_a [lindex $val_list $x]
                set t_tmp_a [lindex $tog_list $x]
                if ![strcmpi [tog_type $t_tmp_a] "bool"] { if ![strcmpi $v_tmp_a "1"] { set v_tmp_a "on" } { set v_tmp_a "off" } }
                set_tog $t_tmp_a $v_tmp_a
                unset t_tmp_a v_tmp_a
              }
            }
            catch {unset u_tmp u}
            catch {unset s_tmp s}
            catch {unset b_tmp b}
            catch {val out outp lngst long_val long_tog x tog_list val_list}
            complete; return
          } {
            set val "\001none\001"
          }
          catch {unset u_tmp u}
          catch {unset s_tmp s}
          catch {unset b_tmp b}
          catch {val out outp lngst long_val long_tog x tog_list val_list}
        }
        if ![string compare [stl [tog_type $tog]] "bool"] {
          set outp ""
          lappend outp [list check -v $val chk1 5 5 [expr [string length $tog]*6] 12 $tog]
        } {
          set outp ""
          lappend outp [list label lbl1 5 5 [expr [string length $tog]*6] 12 $tog]
          lappend outp [list edit edt1 [expr [string length $tog]*6+5] 5 [expr [string length $val]*6] 12 $val]
        }
        set out [FALC_dialog -t "Set Toggle Value" [expr [string length $tog]*6+[string length $val]*6+20] 20 $outp]
        if [string length $out] {
          set v_tmp_a [lindex [lindex $out 0] 1]
          if ![strcmpi [tog_type $tog] "bool"] { if ![strcmpi $v_tmp_a "1"] { set v_tmp_a "on" } { set v_tmp_a "off" } }
          set_tog $tog $v_tmp_a
          unset v_tmp_a
        }
        catch {unset out tog val outp}
      } {
        if ![string length [tog_type $tog]] {
          build_tog $tog $val "user"
          echo [togusersEcho $tog $val]
        } elseif ![string compare [tog_type $tog] "bool"] {
          if {[string compare $val "on"] != 0} { set val "off" }
          set_tog $tog $val
          echo [togbool[stl ${val}]Echo $tog]
        } {
          set_tog $tog $val
          echo [tog[tog_type $tog]sEcho $tog $val]
        }
      }
    }
  } {
    set tog [lindex [args] 0]
    set value [join [lrange [args] 1 end]]
    if ![string length $tog] {
      if [connected] { /query .TOGGLES; window set_title "Sin(zero) - Toggles" query .TOGGLES }
      if ![window exists query .TOGGLES] { set d1 "status"; set d2 "" } { set d1 "query"; set d2 ".TOGGLES" }
      echo [toglistTop] $d1 $d2
      set b_list [lsort [get_cookie BOOL_TOGS]]
      set dmp ""
      set tmp ""
      foreach b $b_list {
        lappend tmp $b
        if {[llength $tmp] == 2} {
          set t1 [lindex $tmp 0]
          set t2 [lindex $tmp 1]
          set v1 [stl [get_tog $t1]]
          set v2 [stl [get_tog $t2]]
          echo [togbool${v1}${v2}Echo $t1 $t2] $d1 $d2
          set tmp ""
          FALC_yield
        }
      }
      if [string length $tmp] {
        set t1 [lindex $tmp 0]
        set v1 [stl [get_tog $t1]]
        echo [togbool${v1}Echo $t1] $d1 $d2
        set tmp ""
      }
      echo [toglistTop] $d1 $d2
      foreach s [lsort [get_cookie STRING_TOGS]] { echo [togstringsEcho $s [get_tog $s]] $d1 $d2; FALC_yield }
      foreach s [lsort [get_cookie USER_TOGS]] { echo [togstringsEcho $s [get_tog $s]] $d1 $d2; FALC_yield }
      echo [toglistBottom] $d1 $d2
      unset s b b_list dmp tmp
    } {
      set type [tog_type $tog]
      if [string length $type] {
        if ![string length $value] {
          switch -- [stl $type] {
            "bool" { if {[stl [get_tog $tog]] == "on"} { echo [togboolonEcho $tog] } { echo [togbooloffEcho $tog] } }
            "string" { echo [togstringsEcho $tog [get_tog $tog]] }
            "user" { echo [togusersEcho $tog [get_tog $tog]] }
          }
        } {
          if [bool_tog $tog] {
            set value [stl $value]
            if {[string compare $value "on"] != 0} { set value "off" }
            set_tog $tog $value
            echo [togbool${value}Echo $tog]
          } {
            set_tog $tog $value
            if [string_tog $tog] { echo [togstringsEcho $tog $value] } { echo [togusersEcho $tog $value] }
          }
        }
      } {
        if ![string length $value] {
          set tog_tmp [stl $tog]
          if {[string compare [string index $tog_tmp [expr [string length $tog_tmp]-1]] "*"] != 0} { set tog_tmp "${tog_tmp}*" }
          set b_list ""; set s_list ""; set u_list ""; set f 0; set u ""; set b ""; set s ""
          foreach b [get_cookie BOOL_TOGS ""] { if [string match $tog_tmp [stl $b]] { lappend b_list $b; if !$f { set f 1 } } }
          foreach s [get_cookie STRING_TOGS ""] { if [string match $tog_tmp [stl $s]] { lappend s_list $s; if !$f {set f 1 } } }
          foreach u [get_cookie USER_TOGS ""] { if [string match $tog_tmp [stl $u]] { lappend u_list $u; if !$f {set f 1 } } }
          if !$f {
            echo [errEcho "Tog" "no such toggle: $tog"]
          } {
            if [connected] { /query .TOGGLES; window set_title "Sin(zero) - Toggles" query .TOGGLES; set d1 "query"; set d2 ".TOGGLES" } { set d1 [window_type]; set d2 [window_name] }
            if [string length $b_list] { foreach b $b_list { if ![string compare [stl [get_tog $b]] "on"] { echo [togboolonEcho $b] $d1 $d2 } { echo [togbooloffEcho $b] $d1 $d2 } } }
            if [string length $s_list] { foreach s $s_list { echo [togstringsEcho $s [get_tog $s]] $d1 $d2 } }
            if [string length $u_list] { foreach u $u_list { echo [togusersEcho $u [get_tog $u]] $d1 $d2 } }
            unset d1 d2
          }
          unset b b_list s s_list u u_list f
        } {
          build_tog $tog $value "user"
          echo [togusersEcho $tog $value]
        }
      }
    }
    unset tog value
  }
  complete
}
alias untog {
  set tognames [join [args]]
  if [string length $tognames] {
    foreach t $tognames {
      switch -- [stl [tog_type $t]] {
        "bool" { set_tog $t "off"; echo [togbooloffEcho $t] }
        "string" { set_tog $t "\001none\001"; echo [togstringsEcho $t [get_tog $t]] }
        "user" {
          set T_LIST [get_cookie USER_TOGS]
          set pos [lsearch -exact [stl $T_LIST] [stl $t]]
          set T_LIST [lreplace $T_LIST $pos $pos]
          set_cookie USER_TOGS $T_LIST
          unset T_LIST
          set_tog $t ""; echo [togusersEcho $t ""]
        }
        default { echo [errEcho "Untog" "no such toggle $t"] }
      }
    }
  } {
    echo [errEcho "Untog" "usage: /untog <tog1> \[<tog2> <tog3>..<togN>\]"]
  }
  complete
}
alias togsave {
  set file [join [args]]
  set comment "#* Toggle Settings Save File for Sin(zero) *#\n#* Created [join [date]]*#"
  if ![string length $file] {
    if {![info exists sin_zero(FALC_LOAD)] || !$sin_zero(FALC_LOAD)} {
      set file "mytogs.tog" 
    } {
      set file [FALC_fileopen -t "Select a file" -s -d [pwd] -f "Toggle Files (*.tog)|*.tog"]
      if ![string length $file] { complete; return }
      if ![string length [file extension $file]] { set file "${file}.tog" }
    }
  }
  set x [open $file w]
  if {$comment != ""} { puts $x "${comment}\n" }
  set bools [lsort [get_cookie BOOL_TOGS]]
  set strings [lsort [get_cookie STRING_TOGS]]
  set users [lsort [get_cookie USER_TOGS]]
  set b ""; set s ""; set u ""
  foreach b $bools {
    puts $x "$b=[get_tog $b]"
  }
  foreach s $strings {
    puts $x "$s=[get_tog $s]"
  }
  foreach u $users {
    puts $x "$u=[get_tog $u]"
  }
  catch {flush $x}
  catch {close $x}
  echo [togsaveEcho $file]
  unset bools strings users b s u x
  idle 0
  complete
}
alias togload {
  set file [lindex [args] 0]
  if ![string length $file] {
    if {![info exists sin_zero(FALC_LOAD)] || !$sin_zero(FALC_LOAD)} {
      set file "mytogs.tog" 
    } {
      set file [FALC_fileopen -t "Select a file" -d [pwd] -f "Toggle Files (*.tog)|*.tog"]
      if ![string length $file] { complete; return }
      if ![string length [file extension $file]] { set file "${file}.tog" }
    }
  }
  if [file exists $file] {
    set x [open $file r]
    while {![eof $x]} {
      set buff [read $x]
      foreach t [split $buff "\n"] {
        if {[string index $t 0] != "#" && [string length [join $t]]} {
          set pos [pos $t "="]
          if {$pos > 0} {
            set tog [string range $t 0 [expr $pos-1]]
            set val [string range $t [expr $pos+1] end]
            if {[tog_type $tog] == ""} {
              build_tog $tog $val "user"
            } {
              set_tog $tog $val
            }
          }
        }
      }
    }
    echo [togloadEcho $file]
  } {
    echo [errEcho "Togload" "no such file: $file"]
  }
  idle 0
  complete
}
alias addons {
  foreach a $ADDON_LIST {
    echo [addonEcho $a [file size $a]]
  }
  idle 0
  complete
}
alias test {
  catch {eval [join [args]]} err
  echo $err
  unset err
  idle 0
  complete
}
alias whoami {
  echo [whoamistart]
  if [connected] {
    echo [whoamiuserhost]
    echo [whoamiserver]
    echo [whoamionline]
  }
  if [away] {
    echo [whoamiaway $AWAY_INFO(reason)]
  }
  echo [whoamilocal]
  echo [whoamiend]
  complete
}
proc dcclistHead {} {
  return "[c]09#  [c]15 [c]09T[c]03ype  [c]15 [c]09N[c]03ick      [c]15 [c]09P[c]03ercent [c]09C[c]03omplete        [c]15 [c]09K[c]03/s   [c]15 [c]09F[c]03ile\n[c]14[c]15[c]00[c]15[c]14[c]15[c]00[c]15[c]14[c]15[c]00[c]15[c]14[c]15[c]00[c]15[c]14[c]15[c]00[c]15[c]14[c]15[c]00[c]15[c]14"
}
proc dcclistItem {idx type nick file pos size percent elapsed remaining startime speed} {
  return "[c]15#[left $idx 2] [left $type 4]    [left $nick 10]  [left "[repeat "" [expr round([string trimright $percent "%"]/100.0*15)]] $percent" 25] [left $speed 7] $file"
}

alias dcc {
  set type [stu [lindex [args] 0]]
  set fwho [lindex [args] 1]
  set fname [join [lrange [args] 2 end]]
  if ![string length $type] { set type "LIST" }
  if {![string compare $type "SEND"] && [string length $fwho] && [string length $fname]} {
    if {[string index $fname 0] == "~"} { set fname "[pwd]/$fname" }
    if ![file exists $fname] {
      echo [errEcho "DCC" "file $fname does not exist."]
      complete; return
    }
    set fname [replace $fname "\\" "/"]
    set fsize [file size $fname]
    set fname [file tail $fname]
    /quote NOTICE $fwho :Requesting DCC transfer of $fname ([byte_format $fsize])...
    unset fsize
  } elseif {![string compare $type "CHAT"] && [string length $fwho] && ![window exists chat $fwho]} {
    /quote NOTICE $fwho :Requesting DCC chat...
  } elseif ![string compare $type "LIST"] {
    set count [dcc_count]
    echo [dcclistHead]
    if {$count > 0} {
      for {set x 0} {$x < $count} {incr x} {
        set info [dcc_info $x]
        set type [lindex $info 0]
        set clock_time [lindex $info 1]
        set nick [lindex $info 2]
        set file [lindex $info 3]
        set cur_pos [lindex $info 4]
        set total_size [lindex $info 5]
        set elapsed [lindex $info 6]
        set remaining [lindex $info 7]
        set speed [lindex $info 8]
        set per [percent $cur_pos $total_size "%"]
        echo [dcclistItem [expr $x+1] $type $nick $file $cur_pos $total_size $per $elapsed $remaining $clock_time $speed]
        unset info type clock_time nick file cur_pos total_size elapsed remaining speed per
      }
    }
    complete; return
  } elseif {[string compare $type "GET"] != 0 && [string compare $type "SEND"] != 0 && [string compare $type "CHAT"] != 0} {
    echo [errEcho "DCC" "usage: /dcc <chat|send|get> <nickname1>\[,<nickname2>,..<nicknameN>\] \[file\]"]
    complete; return
  }
  idle 0
  unset type fwho fname
}
alias tdcc {
  if ![string length [join [args]]] {
    echo [errEcho "tDCC" "usage: /tdcc SEND <nickname1>\[,<nickname2>,..<nicknameN>\] \[file\]"]
    complete; return
  }
  set type [stu [lindex [args] 0]]
  set fwho [lindex [args] 1]
  set fname [join [lrange [args] 2 end]]
  if {$type != "SEND"} {
    unset type fwho fname
    echo [errEcho "tDCC" "usage: /tdcc SEND <nickname1>\[,<nickname2>,..<nicknameN>\] \[file\]"]
    complete; return
  }
  if {$fwho != "" && $fname != ""} {
    if {[string index $fname 0] == "~"} { set fname "[pwd]/$fname" }
    if ![file exists $fname] {
      echo [errEcho "tDCC" "file $fname does not exist."]
      complete; return
    }
    set fname [replace $fname "\\" "/"]
    set fsize [file size $fname]
    set fname [file tail $fname]
    /quote NOTICE $fwho :Requesting tDCC transfer of $fname ($fsize bytes)...
    unset fsize
  }
  idle 0
  unset type fwho fname
}
alias ban {
  set ban_time ""
  set SCREW_BAN ""
  set x 0
  foreach a [args] {
    if ![string compare [string index $a 0] "-"] {
      if ![string compare [stl $a] "-screw"] {
        set SCREW_BAN "screw"
      } elseif ![string compare [stl [string range $a 0 1]] "-t"] {
        set t [stl [string range $a 2 end]]
        set t [string trim $t "abcdefghijklmnopqrstuvwxyz"]
        if [isint $t] {
          set ban_time $t
        }
        unset t
      }
      incr x
    }
  }
  set chan [lindex [args] $x]
  set nick [lindex [args] [expr $x+1]]
  set type [lindex [args] [expr $x+2]]
  if ![string length $chan] {
    echo [errEcho "Ban" "usage: /ban \[-t<seconds>\] \[channel\] <nick> \[mask_type\]"]
    complete; return
  }
  if [ischan $chan] {
    if ![string length $nick] {
      echo [errEcho "Ban" "usage: /ban -t<seconds> \[channel\] <nick> \[mask_type\]"]
      complete; return
    }
    if ![string length $type] { set type 3 }
  } {
    if ![string length [channel]] {
      echo [errEcho "Ban" "usage: /ban -t<seconds> \[channel\] <nick> \[mask_type\]"]
      complete; return
    }
    set type $nick
    set nick $chan
    set chan [channel]
    if ![string length $type] { set type 3 }
  }
  if ![string match "*!*@*" $nick] {
    set ial [get_ial $nick]
    if {$ial != ""} {
      set msk [mask $nick!$ial $type $SCREW_BAN]
      /quote MODE $chan +b $msk
      if [string length $ban_time] {
        /timer -s 1 $ban_time /quote MODE $chan -b $msk
      }
      unset msk
    } {
      if ![info exists BAN_LOOKUP] {
        set BAN_LOOKUP $nick
      } {
        lappend BAN_LOOKUP $nick
      }
      if {$ban_time == ""} { set ban_time 0}
      set BAN_CHANS([stl $nick]) $chan,$type,$ban_time,$SCREW_BAN
      /quote USERHOST $nick
    }
    catch {unset ial}
  } {
    set msk [mask $nick $type $SCREW_BAN]
    /quote MODE $chan +b $msk
    if [string length $ban_time] {
      /timer -s 1 $ban_time /quote MODE $chan -b $msk
    }
  }
  catch {unset chan nick type ban_time}
  if [info exists SCREW_BAN] { unset SCREW_BAN }
  idle 0
  complete
}
alias kick {
  set dest [lindex [args] 0]
  set nick [lindex [args] 1]
  set reason [join [lrange [args] 2 end]]
  if ![ischan $dest] {
    set nick $dest
    set reason [join [lrange [args] 1 end]]
    if {[channel] == ""} {
      echo [errEcho "Kick" "usage: /kick \[channel\] <nick> \[reason\]"]
      complete; return
    }
    set dest [channel]
  }
  if {$reason == ""} {
    set reason [get_tog "Default_Kick_Message"]
    if {$reason == "\001none\001"} {
      set reason [my_nick]
    }
  }
  if {$dest == "" || $nick == ""} {
    echo [errEcho "Kick" "usage: /kick \[channel\] <nick> \[reason\]"]
    complete; return
  }
  if ![string match *!*@* $nick] {
    if {[string range $nick end end] == ":"} {
      set n_list [nnicks $dest]
      set n_lst [string trimright $nick ":"]
      set n_comp ""
      set n ""
      foreach n $n_list {
        if [string match [stl $n_lst]* [stl $n]] {
          set n_comp $n
          break
        }
      }
      if {$n_comp != ""} {
        set nick $n_comp
      } {
        set nick n_lst
      }
      unset n_comp n_lst n
    }
    /quote KICK $dest $nick :$reason
  } {
    set ial_comp [array names IAL]
    if {$ial_comp != ""} {
      set ial_hit 0
      foreach a $ial_comp {
        if {[string match [stl $nick] [stl $a!$IAL($a)]] && [onchan $a $dest] && [stl $a] != [stl [my_nick]]} {
          /quote KICK $dest $a :$reason
          set ial_hit 1
        }
      }
      if !$ial_hit {
        echo [errEcho "Kick" "no users in the IAL matched $nick"]
      }
    } {
      echo [errEcho "Kick" "no users in the IAL"]
    }
    catch {unset ial_hit ial_comp a}
  }
  catch {unset nick dest reason}
  idle 0
  complete
}
alias kickban {
  set arg1 [lindex [args] 0]
  set arg2 [lindex [args] 1]
  set arg3 [lindex [args] 2]
  set arg4 [lindex [args] 3]
  if ![strcmp [string index $arg1 0] "-"] {
    set flags $arg1
    set dest $arg2
    set nick $arg3
    set type $arg4
    set reason [join [lrange [args] 4 end]]
  } {
    set flags ""
    set dest $arg1
    set nick $arg2
    set type $arg3
    set reason [join [lrange [args] 3 end]]
  }
  if ![ischan $dest] {
    if {[channel] == ""} {
      echo [errEcho "Kickban" "usage: /kickban \[-t<TIME>\] \[channel\] <nick|mask> \[type\]"]
      complete; return
    }
    if [string length $flags] { set reason [join [lrange [args] 3 end]] } { set reason [join [lrange [args] 2 end]] }
    set type $nick
    set nick $dest
    set dest [channel]
  }
  if {![string length $dest] || ![string length $nick]} {
    echo [errEcho "Kickban" "usage: /kickban \[-t<TIME>\] \[channel\] <nick|mask> \[type\]"]
    complete; return
  }
  if ![string length $type] { set type 5 }
  if ![isint $type] {
    if [string length $flags] { set reason [join [lrange [args] 2 end]] } { set reason [join [lrange [args] 1 end]] }
    set type 5
  }
  if [string length $reason] {
    set KICKBANREASON([stl $nick]) $reason
  } {
    set KICKBANREASON([stl $nick]) [get_tog "KickBan_Msg"]
  }
  if [string length $flags] {
    /kbnxo $flags $dest $nick $type
  } {
    /kbnxo $dest $nick $type
  }
  unset arg1 arg2 arg3 arg4
  idle 0
  complete
}
alias kbnxo {
  set chan [lindex [args] 0]
  set nick [lindex [args] 1]
  set type [lindex [args] 2]
  set ban_time ""
  if ![string length $chan] { complete; return }
  if [ischan $chan] {
    if ![string length $nick] { complete; return }
    if {$type == ""} { set type 3 }
  } elseif {[string index $chan 0] == "-"} {
    set flags [string range $chan 1 end]
    if ![ischan $nick] {
      set chan [channel]
      set type [lindex [args] 2]
    } {
      set chan $nick
      set nick $type
      set type [lindex [args] 3]
    }
    if {$chan == "" || $nick == ""} { complete; return }
    if {$type == ""} { set type 3 }
    if {[pos $flags "t"] != -1} {
      set pos [pos $flags "t"]
      set cnt [expr $pos+1]
      set x [string index $flags $cnt]
      set n ""
      while {[isint $x]} {
        set n $n$x
        incr cnt
        set x [string index $flags $cnt]
      }
      if {$n != ""} {
        set ban_time $n
      }
      unset x n pos
    }
  } {
    if {[channel] == ""} { complete; return }
    set type $nick
    set nick $chan
    set chan [channel]
    if {$type == ""} { set type 3 }
  }
  if ![string match "*!*@*" $nick] {
    set ial [get_ial $nick]
    if {$ial != ""} {
      set KICK_PENDING_BAN([stl [mask $nick!$ial $type]]) $nick
      if [info exists KICKBANREASON([stl $nick])] {
        set KICK_BAN_REASON([stl [mask $nick!$ial $type]]) $KICKBANREASON([stl $nick])
      } {
        set KICK_BAN_REASON([stl [mask $nick!$ial $type]]) [get_tog "KickBan_Msg"]
      }
      /quote MODE $chan +b [mask $nick!$ial $type]
      if {$ban_time != ""} { /timer -s 1 $ban_time /quote MODE $chan -b [mask $nick!$ial $type] }
    } {
      if ![info exists BAN_LOOKUP] {
        set BAN_LOOKUP $nick
      } {
        lappend BAN_LOOKUP $nick
      }
      set KICK_PENDING_UHOST([stl $nick]) 1
      if {$ban_time == ""} { set ban_time 0}
      set BAN_CHANS([stl $nick]) $chan,$type,$ban_time
      /quote USERHOST $nick
    }
    unset ial
  } {
    set KICK_PENDING_BAN([stl [mask $nick $type]]) $nick
    if [info exists KICKBANREASON([stl $nick])] {
      set KICK_BAN_REASON([stl [mask $nick $type]]) $KICKBANREASON([stl $nick])
    } {
      set KICK_BAN_REASON([stl [mask $nick $type]]) [get_tog "KickBan_Msg"]
    }
    /quote MODE $chan +b [mask $nick $type]
    if {$ban_time != ""} { /timer -s 1 $ban_time /quote MODE $chan -b [mask $nick $type] }
  }
  if [info exists KICKBANREASON([stl $nick])] { unset KICKBANREASON([stl $nick]) }
  unset chan nick type ban_time
  complete
}
alias block {
  set mask [lindex [args] 0]
  if ![strcmpi $mask "-r"] {
    set mask [lindex [args] 1]
    if ![string match "*!*@*" $mask] {
      echo [errEcho "Block" "usage: /block -r <mask>"]
      complete; return
    }
    rem_block $mask
  } {
    if ![string match "*!*@*" $mask] {
      echo [errEcho "Block" "usage: /block \[-r\] <mask>"]
      complete; return
    }
    add_block $mask
  }
  complete
}
alias blocks {
  set b_list [get_cookie BLOCKS]
  if [string length $b_list] {
    foreach b $b_list { echo [listblockEcho $b] }
    unset b
  } {
    echo [errEcho "Blocks" "no masks have been blocked"]
  }
  unset b_list
  complete
}
alias ignore {
  set TIMED_IGNORE 0
  if {[string index [lindex [args] 0] 0] == "-"} {
    set flags [stl [string range [lindex [args] 0] 1 end]]
    set iwho [lindex [args] 1]
    set type [lindex [args] 2]
  } {
    set iwho [lindex [args] 0]
    set type [lindex [args] 1]
    set flags "a"
  }
  if {$iwho == ""} {
    echo [errEcho "Ignore" "usage: /ignore \[-arupncdit<TIME>\] <nick|mask|idx> \[MASK_TYPE\]"]
    complete; return
  }
  if ![string match *!*@* $iwho] {
    set ial [get_ial $iwho]
    if {$ial != ""} {
      set iwho $iwho!$ial
    } {
      if {$type == ""} {
        set orgwho $iwho
        set iwho $iwho!*@*
      } {
        if [connected] {
          set IGNORE_HOST([stl $iwho]) "$type $flags"
          /quote USERHOST $iwho
          complete
          return
        } {
          set orgwho $iwho
          set iwho $iwho!*@*
        }
      }
    }
    unset ial
  }
  if {$type != ""} {
    set iwho [mask $iwho $type]
  }
  set tloc [pos $flags "t"]
  if {$tloc != -1} {
    set igtime ""
    for {set x [expr $tloc+1]} {$x <= [expr [string length $flags]-1]} {incr x} {
      set t [string index $flags $x]
      if [isint $t] {
        set igtime $igtime$t
      } {
        break
      }
    }
    if ![string length $igtime] {
      echo [errEcho "Ignore" "usage: /ignore -t<TIME> <nick|mask> \[MASK_TYPE\]"]
      complete
      return
    } {
      /timer -s 1 $igtime /ignore -r $iwho
      set TIMED_IGNORE 1
    }
  }
  if {[pos $flags "r"] != -1} {
    set flags "r"
    set fout "REMOVE"
  } {
    if {[pos $flags "a"] != -1} {
      set flags "a"
      set fout "ctcp dcc invite notice private public"
    } {
      set fout ""
      if {[pos $flags "d"] != -1} {
        lappend fout "dcc"
      }
      if {[pos $flags "i"] != -1} {
        lappend fout "invite"
      }
      if {[pos $flags "c"] != -1} {
        lappend fout "ctcp"
      }
      if {[pos $flags "u"] != -1} {
        lappend fout "public"
      }
      if {[pos $flags "p"] != -1} {
        lappend fout "private"
      }
      if {[pos $flags "n"] != -1} {
        lappend fout "notice"
      }
      if {[pos $flags "t"] != -1 && [pos $flags "n"] == -1 && [pos $flags "p"] == -1 && [pos $flags "u"] == -1 && [pos $flags "c"] == -1 && [pos $flags "i"] == -1 && [pos $flags "d"] == -1} {
        set fout "ctcp dcc invite notice private public"
      }
    }
    set fout [lsort -ascii $fout]
  }
  if {$iwho == ""} {
    echo [errEcho "Ignore" "usage: /ignore \[-aupncit<TIME>r\] <nick|mask|idx> \[MASK_TYPE\]"]
    complete
    return
  }
  set cur_info [get_cookie IGNORE($iwho)]
  if {$fout != "REMOVE"} {
    if {$cur_info == ""} {
      if ![info exists igtime] { set igtime 0 }
      addignore $iwho $fout $TIMED_IGNORE $igtime
    } {
      if ![info exists igtime] { set igtime 0 }
      updignore $iwho $cur_info $fout $TIMED_IGNORE $igtime
    }
    unset cur_info
  } {
    if {[info exists orgwho] && [isint $orgwho]} {
      remignore $orgwho
      unset orgwho
    } {
      remignore $iwho
    }
  }
  unset flags iwho type TIMED_IGNORE
  idle 0
  complete
}
alias ignores {
  set ig_list [get_cookie IGNORES]
  if {$ig_list != ""} {
    foreach i $ig_list {
      echo [ignorelistEcho $i [get_cookie IGNORE($i)]]
    }
  } {
    echo [errEcho Ignores "no users are currently ignored"]
  }
  idle 0
  complete
}
alias timer* {
  set cmd [lindex [args] 0]
  set id [string range $cmd 5 end]
  if {[stu $id] == "S"} {
    if {[stu [lindex [args] 1]] == "OFF" || [stu [lindex [args] 1]] == "STOP"} {
      if {[array names TIMERS] != ""} {
        echo [killalltimersEcho]
        unset TIMERS TIMER_INF
      } {
        echo [errEcho "Timers" "no active timers"]
      }
    } {
      if [string length [array names TIMERS]] {
        foreach a [lsort -integer [array names TIMERS]] {
          set info [timer_status $a]
          set reps [lindex $info 0]
          set delay [lindex $info 1]
          set silent [lindex $info 2]
          set cmd [lindex $info 3]
          if {$silent && $reps == 0} {
            echo [timerinfisilentstatusEcho $a $reps $delay $cmd]
          } elseif {$silent} {
            echo [timersilentstatusEcho $a $reps $delay $cmd]
          } elseif {$reps == 0} {
            echo [timerinfistatusEcho $a $reps $delay $cmd]
          } {
            echo [timerstatusEcho $a $reps $delay $cmd]
          }
        }
      } {
        echo [errEcho "Timers" "no active timers"]
      }
    }
  } {
    if ![string length $id] {
      set id [avail_timer]
    }
    if ![isint $id] {
      set id [avail_timer]
    }
    set reps [lindex [args] 1]
    set delay [lindex [args] 2]
    set cmd [join [lrange [args] 3 end]]
    if [string match "-S*" [stu $reps]] {
      set reps $delay
      set delay [lindex [args] 3]
      set cmd [join [lrange [args] 4 end]]
      set RUNNING_SILENT 1
    } {
      set RUNNING_SILENT 0
    }
    if {![string compare [stu $reps] "OFF"] || ![string compare [stu $reps] "STOP"]} {
      set x [kill_timer $id]
      if {$x == 1} {
        echo [killtimerEcho $id]
      } elseif {$x == 0} {
        echo [errEcho "Timer" "Timer($id) is not active"]
      }
      catch {unset x}
    } {
      if {![string length $reps] || ![string length $delay] || ![string length $cmd]} {
        if [info exists TIMERS($id)] {
          set info [timer_status $a]
          set reps [lindex $info 0]
          set delay [lindex $info 1]
          set silent [lindex $info 2]
          set cmd [lindex $info 3]
          if {$silent && $reps == 0} {
            echo [timerinfisilentstatusEcho $a $reps $delay $cmd]
          } elseif {$silent} {
            echo [timersilentstatusEcho $a $reps $delay $cmd]
          } elseif {$reps == 0} {
            echo [timerinfistatusEcho $a $reps $delay $cmd]
          } {
            echo [timerstatusEcho $a $reps $delay $cmd]
          }
        } {
          echo [errEcho "Timer" "Timer($id) is not active"]
        }
      } {
        start_timer $id $reps $delay $cmd $RUNNING_SILENT
        if !$RUNNING_SILENT {
          if {$reps != 0} {
            echo [starttimerEcho $id $reps $delay $cmd]
          } {
            echo [startinfitimerEcho $id $reps $delay $cmd]
          }
        }
        catch {unset idx reps delay cmd RUNNING_SILENT}
      }
    }
  }
  idle 0
  complete
}
alias alias {
  set aname [lindex [args] 0]
  if ![strcmpi $aname "-c"] {
    set aname [lindex [args] 1]
    set script [join [lrange [args] 2 end]]
  } {
    set script [join [lrange [args] 1 end]]
    set script "${script}; complete"
  }
  set aname [string trimleft $aname "/"]
  if {![string length $aname] || ![string length $script]} {
    echo [errEcho "Alias" "usage: /alias <alias> <script>"]
    complete; return
  }
  alias $aname $script
  if ![file exists [pwd]/addons.sz/aliases.sin] { filebuild [pwd]/addons.sz/aliases.sin }
  set x [open [pwd]/addons.sz/aliases.sin a]
  puts $x "\nalias $aname \{ $script \}"
  flush $x; close $x
  echo [newaliasEcho [pwd]/addons.sz/aliases.sin $aname $script]
  unset aname script x
  idle 0
  complete
}
alias +bind {
  set key [stl [lindex [args] 0]]
  set script [join [lrange [args] 1 end]]
  set key [string trim $key "+-abcdefghijklmnopqrstuvwxyz"]
  if {[string length $key] > 1} {
    set key [string range $key 0 1]
  }
  if ![isint $key] {
    echo [errEcho "+Bind" "usage: /+bind \[F\]<#> <script>"]
    complete; return
  }
  if {$key < 1 || $key > 12} {
    echo [errEcho "+Bind" "key value must be between 1 and 12"]
    complete; return
  }
  if ![lfind [get_cookie BINDS] $key] {
    set_cookie "BINDS" "[get_cookie BINDS] $key"
  }
  set_cookie BIND($key) $script
  echo [keyboundEcho $key $script]
  unset key script
  idle 0
  complete
}
alias -bind {
  set key [stl [lindex [args] 0]]
  set key [string trim $key "+-abcdefghijklmnopqrstuvwxyz"]
  if [isint $key] {
    if {$key < 1 || $key > 12} {
      echo [errEcho "-Bind" "key value must be between 1 and 12"]
      complete; return
    }
    set_cookie BIND($key) ""
    if [lfind [get_cookie BINDS] $key] {
      set pos [lsearch -exact [get_cookie BINDS] $key]
      if {$pos >= 0} { set_cookie BINDS [lreplace [get_cookie BINDS] $pos $pos] }
      unset pos
    }
    echo [keyunboundEcho $key]
  } {
    echo [errEcho "-Bind" "usage: /-bind \[F\]<#>"]
  }
  unset key
  idle 0
  complete
}
alias binds {
  if {[get_cookie BINDS] == ""} {
    echo [errEcho "Binds" "no Function keys are bound"]
    complete; return
  }
  foreach b [lsort -integer [get_cookie "BINDS"]] {
    echo [keyboundEcho $b [get_cookie BIND($b)]]
  }
  idle 0
  complete
}
alias pagelog {
  set cmd [lindex [args] 0]
  set tval [get_tog Page_Log]
  if {[string compare [stl $cmd] "erase"] != 0} { set cmd "view" }
  switch -- [stl $cmd] {
    "view" {
      if {[string compare [stl $tval] "\001none\001"] != 0 && [string length $tval]} {
        /view $tval
      } {
        echo [errEcho "Pagelog" "no file specified as an away log"]
      }
    }
    "erase" {
      if {[string compare $tval "\001none\001"] != 0 && [string length $tval]} {
        filebuild $tval
      } {
        echo [errEcho "Pagelog" "no file specified as an away log"]
      }
    }
  }
  unset tval cmd
  idle 0
  complete
}
alias awaylog {
  set cmd [lindex [args] 0]
  set tval [get_tog Away_Log]
  if {[string compare [stl $cmd] "erase"] != 0} { set cmd "view" }
  switch -- [stl $cmd] {
    "view" {
      if {[string compare [stl $tval] "\001none\001"] != 0 && [string length $tval]} {
        /view $tval
      } {
        echo [errEcho "Awaylog" "no file specified as an away log"]
      }
    }
    "erase" {
      if {[string compare $tval "\001none\001"] != 0 && [string length $tval]} {
        filebuild $tval
      } {
        echo [errEcho "Awaylog" "no file specified as an away log"]
      }
    }
  }
  unset cmd tval
  idle 0
  complete
}
alias ping {
  set dest [join [args]]
  if {![string length $dest] && ([channel] != "" || [query] != "" || [chat] != "")} {  set dest [window_name] }
  if {$dest != ""} {  /ctcp $dest PING } { echo [errEcho "Ping" "no target specified"] }
  complete
}
alias ver {
  set dest [join [args]]
  if {$dest == "" && ([channel] != "" || [query] != "" || [chat] != "")} {  set dest [window_name] }
  if {$dest != ""} {  /ctcp $dest VERSION } { echo [errEcho "Ver" "no target specified"] }
  complete
}
alias page {
  set dest [lindex [args] 0]
  set reason [join [lrange [args] 1 end]]
  if {$dest == "" && ([channel] != "" || [query] != "" || [chat] != "")} {  set dest [window_name] }
  if {$dest != ""} {
    /ctcp $dest [join "PAGE $reason"]
  } {
    echo [errEcho "Page" "no target specified"]
  }
  complete
}
alias umode {
  /mode [my_nick] [join [args]]
  complete
}
alias adduser {
  set hand [lindex [args] 0]
  set mask [lindex [args] 1]
  set flag_mode [lindex [args] 2]
  set chan [lindex [args] 3]
  if {[string length $hand] && [string length $mask] && [string length $flag_mode]} {
    if ![string length $chan] { set chan "*" }
    if {![ischan $chan] && ![string compare $chan "*"]} { set chan "#${chan}" }
    if [isint $flag_mode] { set t "bin" } { set t "flg" }
    switch -- $t {
      "bin" {
        set lev $flag_mode
        if {$lev < 1 || $lev > 31} { echo [errEcho "Adduser" "numeric must be between the range of 1 and 31"]; complete; return }
      }
      default {
        set flag_mode [stl $flag_mode]
        set lev 0
        if [isin $flag_mode "k"] { incr lev 1 }
        if [isin $flag_mode "b"] { incr lev 2 }
        if [isin $flag_mode "v"] { incr lev 4 }
        if [isin $flag_mode "p"] { incr lev 8 }
        if [isin $flag_mode "o"] { incr lev 16 }
        if {$lev < 1} { echo [errEcho "Adduser" "flags must be \"opvkb\"."]; complete; return }
      }
    }
    set flag [umode2fstring $lev]
    if [isin $flag "k"] { echo [akickAdd $hand $mask $chan] }
    if [isin $flag "b"] { echo [abanAdd $hand $mask $chan] }
    if [isin $flag "v"] { echo [avoiceAdd $hand $mask $chan] }
    if [isin $flag "p"] { echo [protectAdd $hand $mask $chan] }
    if [isin $flag "o"] { echo [aopAdd $hand $mask $chan] }
    set userf [userfile]
    if ![writeini $userf "users" $hand "$mask,$lev,$chan"] { echo [errEcho "Adduser" "unable to write to ini file \"sin.ini\""] }
    unset userf lev
  } {
    echo [errEcho "Adduser" "usage: /adduser <handle> <hostmask> <flags/numeric> \[channel\]"]
  }
  unset hand mask flag_mode chan
  complete
}
alias remuser {
  set hand [lindex [args] 0]
  set userf [userfile]
  if [string length $hand] {
    if [string length [readini $userf "users" $hand]] {
      set mask [getmask $userf $hand]
      remini $userf "users" $hand
      echo [userRem $hand $mask]
      unset mask
    } {
      echo [errEcho "Remuser" "no such user: $hand"]
    }
  } {
    echo [errEcho "Remuser" "usage: /remuser <handle>"]
  }
  unset hand userf
  complete
}
alias userlist {
  set buf [readini [userfile] "Users"]
  set b [split $buf "\n"]
  set max [llength $b]
  if {$max != 0} {
    echo [userlistTop]
    for {set x 0} {$x < $max} {incr x} {
      set u [lindex $b $x]
      set pos [pos $u "="]
      if {$pos != -1} {
        set h [string range $u 0 [expr $pos-1]]
        set r [string range $u [expr $pos+1] end]
        set pos [pos $r ","]
        if {$pos != -1} {
          set m [string range $r 0 [expr $pos-1]]
          set r [string range $r [expr $pos+1] end]
          set l [umode2fstring [string range $r 0 [expr [pos $r ","]-1]]]
          set c [string range $r [expr [pos $r ","]+1] end]
          set l [split $l ""]
          set l [join $l ","]
          echo [userlistItem $h $m $l $c]
          unset m l c
        }
        unset h r
      }
      unset pos u
    }
    echo [userlistEnd]
  } {
    echo [errEcho "Userlist" "no users found in the userlist."]
  }
  unset max b buf
  complete
}
alias aop {
  set h [lindex [args] 0]
  set m [lindex [args] 1]
  set c [lindex [args] 2]
  /adduser $h $m 16 $c
  complete
}
alias avoice {
  set h [lindex [args] 0]
  set m [lindex [args] 1]
  set c [lindex [args] 2]
  /adduser $h $m 4 $c
  complete
}
alias protect {
  set h [lindex [args] 0]
  set m [lindex [args] 1]
  set c [lindex [args] 2]
  /adduser $h $m 8 $c
  complete
}
alias akick {
  set h [lindex [args] 0]
  set m [lindex [args] 1]
  set c [lindex [args] 2]
  /adduser $h $m 1 $c
  complete
}
alias aban {
  set h [lindex [args] 0]
  set m [lindex [args] 1]
  set c [lindex [args] 2]
  /adduser $h $m 2 $c
  complete
}
alias akb {
  set h [lindex [args] 0]
  set m [lindex [args] 1]
  set c [lindex [args] 2]
  /adduser $h $m 3 $c
  complete
}
alias status {
  set page [lindex [args] 0]
  if ![isint $page] { set page 0 }
  if {$page < 0} { set page 0 }
  if {$page > 4} { set page 4 }
  if {[stl [window state status]] == "minimize"} {
    window restore status
  }
  status_page $page
  complete
}
alias scripts {
  foreach s [scripts] {
    set size [file size $s]
    echo [scriptEcho $s $size]
  }
  complete
}
proc scriptEcho {file size} {
  if [string length [get_env "ScriptEcho"]] {
    return [eval return [get_env "ScriptEcho"]]
  } {
    return "[c]14<[c]00\[[c]15Script[c]14:[c]15 [file tail $file] [c]00[b]([b][c]15[byte_format $size][c]00[b])[b]\][c]14>"
  }
}

#Alternate Aliases
alias notes { /view notes.txt; complete }
alias msg { /privmsg [join [args]]; complete }
alias deluser { /remuser [join [args]]; complete }
alias servers { /serv list; complete }
alias servlist { /serv list; complete }
alias me { /action [join [args]]; complete }
alias not { /notice [join [args]]; complete }
alias n { /notice [join [args]]; complete }
alias m { /msg [join [args]]; complete }
alias bans { /banlist [join [args]]; complete }
alias um { /umode [join [args]]; complete }
alias j { /join [join [args]]; complete }
alias dop { /cdop [channel] [join [args]]; complete }
alias op { /cop [channel] [join [args]]; complete }
alias vc { /cvc [channel] [join [args]]; complete }
alias dvc { /cdvc [channel] [join [args]]; complete }
alias p { /ping [join [args]]; complete }
alias w { /whois [join [args]]; complete }
alias wi { /whois [join [args]]; complete }
alias ww { /whowas [join [args]]; complete }
alias uh { /userhost [join [args]]; complete }
alias ui { /userip [join [args]]; complete }
alias clonescan { /scan clone [join [args]]; complete }
alias operscan { /scan oper [join [args]]; complete }
alias ialscan { /scan ial [join [args]]; complete }
alias clones { /scan clone [join [args]]; complete }
alias opers { /scan oper [join [args]]; complete }
alias set { /tog [join [args]]; complete }
alias unset { /untog [join [args]]; complete }
alias chat { /dcc chat [join [args]]; complete }
alias send { /dcc send [join [args]]; complete }
alias tsend { /tdcc send [join [args]]; complete }
alias dns { /nslookup [join [args]]; complete }
alias lookup { /nslookup [join [args]]; complete }
alias dnsqueue { /nsqueue; complete }
alias lookupqueue { /nsqueue; complete }
alias b { /ban [join [args]]; complete }
alias k { /kick [join [args]]; complete }
alias kb { /kickban [join [args]]; complete }
alias sb { /screwban [join [args]]; complete }
alias bk { /kickban [join [args]]; complete }
alias s {
  set params [join [args]]
  if ![string length $params] {
    if {[info exists sin_zero(FALC_LOAD)] && $sin_zero(FALC_LOAD)} {
      set file [FALC_fileopen -t "Select a Sound" -d [get_tog SoundDir] -f "Wave (*.wav)|*.wav|Midi (*.mid)|*.mid|All files (*.*)|*.*"]
      if [string length $file] { /sound $file } { /sound }
      unset file
    } {
      /sound
    }
  } {
    /sound [join [args]]
  }
  unset params
  complete
}
alias screwban { /ban -screw [join [args]]; complete }
alias massop { /mass op [join [args]]; complete }
alias massdop { /mass dop [join [args]]; complete }
alias massvc { /mass vc [join [args]]; complete }
alias massdvc { /mass dvc [join [args]]; complete }
alias masskick { /mass kick [join [args]]; complete }
alias bind { /+bind [join [args]]; complete }

hotkey TAB {
  set tx [input get_text]
  if {[pos $tx " "] >= 0} {
    set tx [replace $tx "\"" "\\\""]
    set tx [replace $tx "\\" "\\\\"]
    set tx [string trimleft $tx " "]
    set p [expr [pos $tx " "]-1]
    if {$p < 0} { set p [expr [string length $tx]-1] }
    set t1 [string range $tx 0 $p]
    if {![strcmpi $t1 "/view"] || ![strcmpi $t1 "/dcc"] || ![strcmpi $t1 "/edit"] || ![strcmpi $t1 "/style"] || ![strcmpi $t1 "/play"] || ![strcmpi $t1 "/send"] || ![strcmpi $t1 "/run"] || ![strcmpi $t1 "/tsend"]} {
      set p [string last " " $tx]
      if {$p < 0} { set p 0 }
      set gl [string range $tx $p end]
      set gl [string trim $gl " "]
      set gl [replace $gl "\\\\" "/"]
      set gl [replace $gl "\{" ""]
      set gl [replace $gl "\}" ""]
      set glob [glob -nocomplain ${gl}*]
      set file ""
      if [string length $glob] { set file [lindex $glob 0] }
      if [string length $file] {
        if [file isdir $file] { set file "${file}/" }
        set file [replace $file "/" "\\"]
        set tx "[string range $tx 0 $p]${file}"
        set tx [string trim $tx " "]
        input set_text $tx
        input set_sel_start [string length $tx]
        input set_sel_length 0
      }
    } {
      set p [expr [string last " " $tx]+1]
      if {$p < 0} { set p 0 }
      set b [string range $tx $p end]
      set out ""
      if {![strcmpi [string index $b 0] "#"] || ![strcmpi [string index $b 0] "&"]} {
        foreach c [channels] {
          if [string match [fix4match [stl $b]]* [stl $c]] { set out "$c "; break }
        }
      } {
        if [string length [channel]] {
          set niqs [nnicks [channel]]
          foreach n $niqs { if {[string match [fix4match [stl $b]]* [stl $n]]} { set out "$n "; break } }
        }
      }
      if [string length $out] {
        set tx "[string range $tx 0 [expr $p-1]]${out}"
        set tx [string trim $tx " "]
        input set_text $tx
        input set_sel_start [string length $tx]
        input set_sel_length 0
      }
    }
  } {
    if [info exists TAB_REP] {
      if ![info exists TAB_IDX] { set TAB_IDX [lindex [lsort -ascii [array names TAB_REP]] 0] }
      set text [input get_text]; set text [replace $text "\"" "\\\""]; set text [replace $text "\{" "\\\{"]; set text [replace $text "\}" "\\\}"]
      set text [join $text]; set f 0
      if {[string length $text] && [string index $text 0] != "/"} { foreach n [lsort -ascii [array names TAB_REP]] { if [string match [fix4match [stl $text]]* $n] { set TAB_IDX $n; set f 1; break } } }
      if !$f { set pos [lsearch -exact [stl [lsort -ascii [array names TAB_REP]]] [stl $TAB_IDX]]; incr pos; if {$pos > [expr [llength [array names TAB_REP]]-1]} { set pos 0 }; set TAB_IDX [lindex [lsort -ascii [array names TAB_REP]] $pos] }
      set out $TAB_REP($TAB_IDX); input set_text $out; input set_sel_start [string length $out]; input set_sel_length 0
      unset f out
    }
  }
  unset tx
  complete
}

hotkey control+1 {
  if {[info exists KICK_TRAQ(.)] && [info exists KICK_TRAQ([stl $KICK_TRAQ(.)])]} {
    set nick [lindex [split $KICK_TRAQ([stl $KICK_TRAQ(.)]) ","] 0]
    /quote KICK $KICK_TRAQ(.) $nick :[b]s[b]in-[b]z[b]ero[u]([u]kick-de[b]fens[b]e[u])[u]
  }
}
hotkey control+2 {
  if {[info exists KICK_TRAQ(.)] && [info exists KICK_TRAQ([stl $KICK_TRAQ(.)])]} {
    set nick [lindex [split $KICK_TRAQ([stl $KICK_TRAQ(.)]) ","] 0]
    if [lfind [ops $KICK_TRAQ(.)] $nick] { /quote MODE $KICK_TRAQ(.) -o $nick }
    /ban $KICK_TRAQ(.) $nick 3
  }
}
hotkey control+3 {
  if {[info exists KICK_TRAQ(.)] && [info exists KICK_TRAQ([stl $KICK_TRAQ(.)])]} {
    set nick [lindex [split $KICK_TRAQ([stl $KICK_TRAQ(.)]) ","] 0]
    if [lfind [ops $KICK_TRAQ(.)] $nick] { /quote MODE $KICK_TRAQ(.) -o $nick }
    /kickban $KICK_TRAQ(.) $nick 3
  }
}
hotkey F1 { set f [get_cookie BIND(1)]; if [string length $f] { catch {eval $f}; complete } }
hotkey F2 { set f [get_cookie BIND(2)]; if [string length $f] { catch {eval $f}; complete } }
hotkey F3 { set f [get_cookie BIND(3)]; if [string length $f] { catch {eval $f}; complete } }
hotkey F4 { set f [get_cookie BIND(4)]; if [string length $f] { catch {eval $f}; complete } }
hotkey F5 { set f [get_cookie BIND(5)]; if [string length $f] { catch {eval $f}; complete } }
hotkey F6 { set f [get_cookie BIND(6)]; if [string length $f] { catch {eval $f}; complete } }
hotkey F7 { set f [get_cookie BIND(7)]; if [string length $f] { catch {eval $f}; complete } }
hotkey F8 { set f [get_cookie BIND(8)]; if [string length $f] { catch {eval $f}; complete } }
hotkey F9 { set f [get_cookie BIND(9)]; if [string length $f] { catch {eval $f}; complete } }
hotkey F10 { set f [get_cookie BIND(10)]; if [string length $f] { catch {eval $f}; complete } }
hotkey F11 { set f [get_cookie BIND(11)]; if [string length $f] { catch {eval $f}; complete } }
hotkey F12 { set f [get_cookie BIND(12)]; if [string length $f] { catch {eval $f}; complete } }
hotkey a { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+a { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey b { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+b { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey c { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+c { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey d { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+d { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey e { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+e { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey f { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+f { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey g { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+g { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey h { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+h { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey i { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+i { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey j { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+j { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey k { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+k { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey l { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+l { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey m { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+m { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey n { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+n { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey o { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+o { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey p { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+p { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey q { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+q { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey r { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+r { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey s { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+s { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey t { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+t { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey u { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+u { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey v { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+v { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey w { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+w { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey x { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+x { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey y { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+y { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey z { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey shift+z { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey 1 { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey 2 { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey 3 { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey 4 { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey 5 { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey 6 { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey 7 { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey 8 { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey 9 { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey 0 { if {[tog_on "Back_On_Keypress"] && [away]} { /back } }
hotkey alt+k {
  set curpos [input get_sel_start]
  set txt [input get_text]
  if {$curpos > 0} {
    set t1 "[string range $txt 0 [expr $curpos-1]]\x1B\["
  } {
    set t1 "\x1B\["
  }
  if {$curpos < [string length $txt]} {
    set t2 [string range $txt $curpos end]
  } {
    set t2 ""
  }
  input set_text "${t1}${t2}"
  input set_sel_start [expr $curpos+2]
  complete
}
alias sv {
  if {[string length [channel]] || [string length [query]]} {
    if ![info exists sin_zero(version)] { set rep "Sin[b]([b]zero[u]/[u]unknown[b])[b]" } { set rep $sin_zero(version) }
    say $rep
    unset rep
  } elseif [string length [chat]] {
    if ![info exists sin_zero(version)] { set rep "Sin[b]([b]zero[u]/[u]unknown[b])[b]" } { set rep $sin_zero(version) }
    /msg =[chat] $rep
    unset rep
  }
  complete
}
alias cryptmsg {
  if ![connected] {
    not_connected
    complete
    return
  }
  set dest [lindex [args] 0]
  set msg [join [lrange [args] 1 end]]
  if {[string length $msg] && [string length $dest]} {
    set key [get_tog "Crypt_Key"]
    if {![string length $key] || ![string compare [stl $key] "\001none\001"]} { set key "abcd" }
    if ![string compare [stl [get_tog Show_Decrypted]] "on"] {
      if [ischan $dest] {
        if [window exists channel $dest] {
          echo [selfchanencrypted $dest $msg] channel $dest
        } {
          echo [selfmsgencrypted $dest $msg]
        }
      } {
        if [window exists query $dest] {
          echo [selfqueryencrypted $dest $msg] query $dest
        } {
          echo [selfmsgencrypted $dest $msg]
        }
      }
      /quote PRIVMSG $dest :.\004:\004.[encrypt $msg $key]
    } {
      /privmsg $dest .\004:\004.[encrypt $msg $key]
    }
    unset key
  }
  idle 0
  complete
}
alias cryptsay {
  if ![connected] {
    not_connected
    complete
    return
  }
  set key [get_tog "Crypt_Key"]
  if {![string length $key] || ![string compare [stl $key] "\001none\001"]} { set key "abcd" }
  set text [join [args]]
  switch -- [stl [window_type]] {
    "query" { /cryptmsg [window_name] $text }
    "channel" { /cryptmsg [window_name] $text }
    default { echo [errEcho "Cryptsay" "invalid window specifications."] }
  }
  catch {unset text}
  idle 0
  complete
}
alias colors {
  set out ""
  for {set x 0} {$x<16} {incr x} {
    set y [leadzero $x 2]
    set out "${out}[c]${y},${y}\ \ "
  }
  echo $out
  unset y x out
  complete
}
alias ncomp {
  echo "[c]11Displaying all Ncomp styles with their coresponding values:"
  for {set x 1} {$x < 12} {incr x} { echo "[c]10\[[right $x 2]\]: [ncompify "phAge" $x] text" }
  complete
}
