####################################
#
#  script examples for falcon.dll
#
####################################
#      ver 1.51
####################################


#### Copy/Paste between these markers to 
#### build your own script using Falcon.

#### START of bare-bones minimum Falcon script ####

on load {
  set filename falc_151.tcl

  if {[set idx [lsearch [scripts] "*\\$filename"]]== -1} {
    error "Unable to find path for $filename"
  } else {
    regexp -nocase (.*)\\$filename\$ [lindex [scripts] $idx] a scriptDir
    unset a
    load $scriptDir/falcon.dll

    if {[set ver [FALC_ver]] < 1.51} {
      error "falcon.dll is v$ver. This script needs at least version 1.51 of falcon."
    }

  }
}

# This is used for falcon's internal notifier.
# Have this in !ALL! scripts using falcon.
on timer {
  if {[llength [info commands FALC_update]]} { FALC_update }
}

#### END of bare-bones minimum falcon.dll script ####



# Place the path to your favorite text editor here:
set MyEditor notepad



menu status ""
menu status "Falcon->Run a file..." {
  if {[set file [FALC_fileopen -m -t "Run a file" -d "%SystemDrive%" \
      -f "Executables (*.exe\;*.cmd\;*.bat\;*.lnk)|*.exe\;*.cmd\;*.bat\;*.lnk|WinWord Files (*.doc\;*.rtf)|*.doc\;*.rtf|Text Files (*.txt\;*.asc\;*.bak)|*.txt\;*.asc\;*.bak|All Files (*.*)|*.*"]]!=""} {
    FALC_shell $file
  }
}
menu status "Falcon->Edit a file..." {
  if {[set file [FALC_fileopen -m \
      -f "Text Files (*.txt\;*.asc\;*.bak)|*.txt\;*.asc\;*.bak|Tcl Source (*.tcl)|*.tcl|All Files (*.*)|*.*"]]!=""} {
    FALC_shell -p $file -s norm $MyEditor 
  }
}

menu status "Falcon->Run Explorer" {
  FALC_shell -v explore [pwd]
}

menu status "Falcon->Goto Console" { 
  FALC_shell $env(ComSpec)
}

if {[file exist xircon.hlp] && [file exist xircon.cnt]} {
  menu status "Falcon->"
  menu status "Falcon->XiRCON Tcl Helpfile" {
    FALC_winhelp Xircon.hlp finder
  }
}

menu status "Falcon->"

menu status "Falcon->FALC_askbox sample" {
  switch [FALC_askbox -i question -b yes_no \
      -d yes "Do you like IRC?"] {
    "yes" { echo "Damn right! me too." status }
    "no" { echo "You're lame." status }
  }
}

menu status "Falcon->FALC_dialog example" {
  set ItemsList [list]
  lappend ItemsList [list label lbl1 5 15 20 10 "Host:"]
  lappend ItemsList [list edit POPhost 25 13 104 12 [get_cookie POPhost "mail.rutgers.edu"]]
  lappend ItemsList [list label lbl2 5 30 20 10 "User:"]
  lappend ItemsList [list edit POPuser 25 28 104 12 [get_cookie POPuser "sammy1"]]
  lappend ItemsList [list label lbl3 5 45 20 10 "Pass:"]
  lappend ItemsList [list edit POPpass 25 43 104 12 [get_cookie POPpass "lalala"]]
  lappend ItemsList [list check -v [get_cookie POPautochk 0] POPautochk 14 62 70 10 "autocheck every:"]
  lappend ItemsList [list edit POPautotime 84 60 14 12 [get_cookie POPautotime "5"]]
  lappend ItemsList [list label lbl4 100 63 30 10 "minutes"]
  set POPoptions [list "Display All" "Display From and Subject" "Display Count"]
  lappend ItemsList [list combo -x -s [get_cookie POPoption 0] POPoption 15 80 118 67 $POPoptions]

  if [llength [set answer [FALC_dialog -t "POP3 Email Checker" 146 104 $ItemsList]]] {
    foreach control $answer {
      set_cookie [lindex $control 0] [lindex $control 1]
    }
    echo "*** Updated \a96-=\[\a9CEXAMPLE\a96\]=-[color default] POP3 Email Checker" status
  }
  unset ItemsList POPoptions

}

alias run {
  if {[llength [args]]>0} {
    FALC_shell -v open -s norm [raw_args] 
  } else {
    if {[set file [FALC_fileopen -t "Run What File?"]]} {
      FALC_shell -v open -s norm $file
      unset file
    }
  }
  complete
}

alias play {
  if {[llength [args]]>0} {
    set fhnd [open [join [args]]]
  } else {
    if {[set file [FALC_fileopen -t "Select a file for Playback" -d [pwd] -f "All Files|*.*|Text File|*.txt\;*.asc|Tcl source|*.tcl"]]!=""} {
      set fhnd [open $file]
      unset file
    } else {
      complete
    }
  }
  if [FALC_wmatch [window type] status] {
    while {![eof $fhnd]} {
      set line [gets $fhnd]
      if { $line == "" } { set line " " }
      echo $line status
    }
  } else {
    while {![eof $fhnd]} {
      set line [gets $fhnd]
      if { $line == "" } { set line " " }
      say $line
    }
  }
  complete
}

alias email {
  if {[llength [args]]>1} {
    set addr [lindex [args] 0]
    set subj [lrange [args] 1 end]
    FALC_shell mailto:$addr?subject=$subj
  } else {
    echo "Usage: \aFC/email \aF9<address> \aF6<subject>"
  }
  complete
}

#alias telnet {
#  if {[llength [args]]>1} {
#    set data [split [lindex [args] 0] :]
#    set longIP [FALC_ip2long [lindex $data 0]]
#    set port [FALC_port [lindex $data 1]]
#    /raw privmsg [my_nick] :\001DCC chat chat $longIP $port\001
#    if [info exist data] { unset data }
#    if [info exist longIP] { unset longIP }
#    if [info exist port] { unset port }
#  } else {
#    echo "Usage: \aFC/telnet \aF9<IP>:<Port|Service>
#  }
#  complete
#}

alias HELP {
  if [llength [args]] {
    FALC_winhelp Xircon.hlp partialkey [raw_args]
  } else {
    FALC_winhelp Xircon.hlp finder
  }
  complete
}


# I added the 'f' to 'tcl' so it wouldn't collide if this script
# is loaded with others.
alias ftcl { 
  if { [catch { eval [raw_args] } msg] } { 
    echo "[color error]Error executing TCL command \"[raw_args]\" :"
    echo "[color error]$msg"
    unset msg
  }
  complete
}


# The following 2 procedures are an example of how to 
# offer video conferencing from IRC with NetMeeting. 
# This is only an experiment.

alias video {
  if {[llength [args]]==1} {
    /ctcp [lindex [args] 0] h.323 [my_ip]
  } else {
    echo "\aFC/video\aF0 sends a CTCP request to \aF9<nick>\aF0 for a video conference. Have NetMeeting or other H.323 conferencing program listening. You don't need to be on an ILS server."
    echo "Usage: \aFC/video \aF9<nick>"
  }
  complete
}

on CTCP {
  set orig [nick]
  set dest [lindex [args] 0]
  set cmd [lindex [args] 1]
  set addr [lindex [args] 2]

  if [FALC_wmatch $dest [my_nick]]&&[FALC_wmatch $cmd h.323] {

    if {[FALC_askbox -i question -b yes_no \
          -d no "$nick ($addr) would like to conference you.\n\nDo you accept?"]=="yes"} {
      set fhnd [open $scriptDir/video/$orig.cnf w]
      puts $fhnd "\[ConferenceShortcut\]"
      puts $fhnd "ConfName=$orig"
      puts $fhnd "Address=$addr"
      puts $fhnd "CallFlags=65543"
      puts $fhnd "Transport=1"
      close $fhnd
      FALC_shell -v open $scriptDir/video/$orig.cnf
      /raw notice $orig :\001h.323 [my_nick] is attempting to conference you at $addr\001
    } else {
      /raw notice $orig :\001h.323 I'm sorry, but I have chosen not to accept.\001
    }
    complete
  }
}