/* forward reference, so we can define it later */
struct Tcl_Event;

typedef int (Tcl_EventProc) (Tcl_Interp *interp, Tcl_Event *evPtr, int flags);

/*
 * The following structure defines a generic event for the Tcl event
 * system.  These are the things that are queued in calls to Falc_QueueEvent
 * and serviced later by Falc_DoOneEvent.  There can be many different
 * kinds of events with different fields, corresponding to window events,
 * timer events, etc.  The structure for a particular event consists of
 * a Tcl_Event header followed by additional information specific to that
 * event.
 */
struct Tcl_Event {
  Tcl_EventProc *proc;        /* Procedure to call to service this event. */
  struct Tcl_Event *nextPtr;  /* Next in list of pending events, or NULL. */
};

/*
 * Positions to pass to Falc_QueueEvent:
 */
typedef enum {
    FALC_QUEUE_TAIL, FALC_QUEUE_HEAD, FALC_QUEUE_MARK
} Falc_QueuePosition;


/*
 * Flag values to pass to Falc_DoOneEvent to disable searches
 * for some kinds of events:
 */
#define FALC_DONT_WAIT       (1<<1)
#define FALC_DDE_EVENTS      (1<<2)
#define FALC_ALL_EVENTS      (~FALC_DONT_WAIT)

/* Prototypes */
extern char * Falc_DoFileName (char orgFile[]);
extern BOOL Falc_IsNumeric (char *text);
extern int Falc_GetBoolean(Tcl_Interp *interp, char *string, int *boolPtr);
extern int Falc_GetInt(Tcl_Interp *interp, char *string, int *intPtr);
extern int Falc_GetShort(Tcl_Interp *interp, char *string, short *i16Ptr);
extern char * Falc_Merge(int argc, char **argv);
extern Tcl_FreeProc Falc_freeProc;
extern HWND Falc_GetXiRChWnd(Tcl_Interp *interp);
extern int Falc_DoOneEvent(Tcl_Interp *interp, int flags);
extern void Falc_QueueEvent(Tcl_Event *evPtr, Falc_QueuePosition position);
extern int Falc_FindElement(Tcl_Interp *interp, register char *list, char **elementPtr, char **nextPtr, int *sizePtr, int *bracePtr);
extern void Falc_CopyAndCollapse(int count, register char *src, register char *dst);
