
#include "falcon.h"
#include "util.h"

extern dyn_AppendResult Tcl_AppendResult;

typedef struct {
  Tcl_Event header;
  char *msg;
} PanicEvent;

Tcl_EventProc PanicEventProc;

/*
 *--------------------------------------------------------------
 *
 * PanicEventProc --
 *
 *  This procedure is called internaly when an error occures and
 *  the current function doesn't have access to the interp to
 *  provide the error.
 *
 * Results:
 *  unknown.
 *
 * Side effects:
 *  unknown.
 *
 *--------------------------------------------------------------
 */

void FALC_panic (char *msg) {
 register PanicEvent *pPtr;
 int length;

  pPtr = (PanicEvent *) xmalloc (sizeof(PanicEvent));
  pPtr->header.proc = PanicEventProc;
  length = strlen(msg)+1;
  pPtr->msg = (char *) xmalloc(length);
  memcpy(pPtr->msg,msg,length);
  Falc_QueueEvent((Tcl_Event *)pPtr, FALC_QUEUE_HEAD);
}
/*
 *--------------------------------------------------------------
 *
 * PanicEventProc --
 *
 *  This is the procedure that's called when a Panic event has been
 *  registered with Falc_QueueEvent() and the notifier now has 
 *  the interpreter and its time to handle the event.
 *
 * Results:
 *  unknown.
 *
 * Side effects:
 *  unknown.
 *
 *--------------------------------------------------------------
 */
static int PanicEventProc (Tcl_Interp *interp, Tcl_Event *evPtr, int flags) {
 register PanicEvent *panic = (PanicEvent *) evPtr;

  Tcl_AppendResult(interp, panic->msg, (char *)NULL);
  xfree(panic->msg);
  xfree(panic);
  return TCL_ERROR;
}