/*************************************************************
 ** main.cpp --  main file for the Falcon DLL Extension v1.50
 **
 ** Abstract: This code adds additional functions to XiRCON 
 **           1.0B4 [www.xircon.com].  See the readme.txt for 
 **           more info on what this does.
 **
 ** Copyrights:
 **   This software (source code and compiled DLL) contains code made 
 **   available by {David Gravereaux, herin, known as the "author"} 
 **   on an AS IS basis.  Any one receiving the module is considered 
 **   to be licensed under the author's copyrights to use the provided 
 **   source code in any way he or she deems fit, including copying it, 
 **   compiling it, modifying it, and redistributing it, with or without 
 **   modifications. No license under any of the author's patents or 
 **   patent applications is to be implied from this copyright license.
 **
 **   A user of the module should understand that the author can 
 **   provide technical support for the module, but it is not gauranteed
 **   and will not be responsible for any consequences of use of the 
 **   program. Even if your computer turns green and gets a sinus infection.
 **
 **   Any notices, including this one, are not to be removed from the
 **   module without the prior written consent of the author.
 **
 **   Some code was taken from other sources. They are:
 **     1) Match.cpp is a verbatim adaptation of eggdrop's match.c 
 **        by Chris Fuller.
 **     2) dde.cpp was based heavily on dde11.c by Ken Corey
 **        and the tk8.1a1 release (c)1996-98 Sun MicroSystems Labs.
 **     3) Although, now, my code doesn't resemble code from the xircsdk,
 **        credit should go to Nate Lewis. For whom I could not have 
 **        started programming extensions for XiRC.
 **     4) tknt40r3 source code by Gordon Chaffee and Lawrence A. Rowe
 **        of UC Berkeley for the FALC_winhelp and FALC_askbox commands.
 **
 ** Author: David Gravereaux   mailto:davygrvy@bigfoot.com 
 **         (c)1998 Tomahawk Software Group
 **
 ** Note: All mentions of XiRCON are Copyright 
 **       (c) 1996-97 by Mark Hanson - All Rights Reserved.
 *************************************************************/

#include "falcon.h"
#include "util.h"
#include "main.h"

#define FALCVER "1.51"

#if defined(_MSC_VER)
# define DllEntryPoint DllMain
#elif defined(__BORLANDC__)
# include <ctype.h>
#endif


/* Globals */
HINSTANCE hInstance;
HMODULE hXircTcl;
BOOL InXiRCON=TRUE;
int refcount=0;
#if defined(CMD_ISIP)||defined(CMD_IP2LONG)||defined(CMD_LONG2IP)||defined(CMD_PORT)
extern FALC_SOCK winSock;
#endif
#ifdef CMD_DDE
BOOL DDEMaster = FALSE;
//extern char *dde_scriptname;
//extern DWORD ddeClientInstance;
#endif

/*
 *   function pointers for the functions 
 *   we'll need to call in XiRCON/tclsh.
 *   the commented ones are not in use,
 *   but are available. why waste memory ;)
 */
dyn_AppendElement Tcl_AppendElement;
dyn_AppendResult Tcl_AppendResult;
dyn_CreateCommand Tcl_CreateCommand;
/* dyn_CreateInterp Tcl_CreateInterp; */
/* dyn_DeleteCommand Tcl_DeleteCommand; */
/* dyn_DeleteInterp Tcl_DeleteInterp; */
dyn_DoOneEvent Tcl_DoOneEvent;
/* dyn_Eval Tcl_Eval; */
/* dyn_EvalFile Tcl_EvalFile; */
/* dyn_GetVar Tcl_GetVar; */
dyn_GlobalEval Tcl_GlobalEval;
dyn_ResetResult Tcl_ResetResult;
/* dyn_SetResult Tcl_SetResult */

/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *  This wrapper function is used by Windows to invoke the
 *  initialization code for the DLL.  If we are compiling
 *  with Visual C++, this routine will be, properly, renamed 
 *  to DllMain.
 *
 * Results:
 *  Returns a success code
 *
 * Side effects:
 *  None.
 *
 *----------------------------------------------------------------------
 */
BOOL WINAPI DllEntryPoint(HINSTANCE hInst, ULONG ulReason, LPVOID lpReserved) {
  switch(ulReason) {
  case DLL_PROCESS_ATTACH:
    refcount++;
    if(refcount==1) {
      hInstance=hInst; /* save instance handle */

      hXircTcl=GetModuleHandle("xtcl.dll");

      if (hXircTcl > (HMODULE) HINSTANCE_ERROR) {
        Tcl_AppendElement = (dyn_AppendElement) GetProcAddress(hXircTcl,"_Tcl_AppendElement");
        Tcl_AppendResult = (dyn_AppendResult) GetProcAddress(hXircTcl,"_Tcl_AppendResult");
        Tcl_CreateCommand = (dyn_CreateCommand) GetProcAddress(hXircTcl,"_Tcl_CreateCommand");
        /* Tcl_CreateInterp = (dyn_CreateInterp) GetProcAddress(hXircTcl,"_Tcl_CreateInterp"); */
        /* Tcl_DeleteCommand = (dyn_DeleteCommand) GetProcAddress(hXircTcl,"_Tcl_DeleteCommand"); */
        /* Tcl_DeleteInterp = (dyn_DeleteInterp) GetProcAddress(hXircTcl,"_Tcl_DeleteInterp"); */
        Tcl_DoOneEvent = (dyn_DoOneEvent) GetProcAddress(hXircTcl,"_Tcl_DoOneEvent");
        /* Tcl_Eval = (dyn_Eval) GetProcAddress(hXircTcl,"_Tcl_Eval"); */
        /* Tcl_EvalFile = (dyn_EvalFile) GetProcAddress(hXircTcl,"_Tcl_EvalFile"); */
        /* Tcl_GetVar = (dyn_GetVar) GetProcAddress(hXircTcl,"_Tcl_GetVar"); */
        Tcl_GlobalEval = (dyn_GlobalEval) GetProcAddress(hXircTcl,"_Tcl_GlobalEval");
        Tcl_ResetResult = (dyn_ResetResult) GetProcAddress(hXircTcl,"_Tcl_ResetResult");
        /* Tcl_SetResult = (dyn_SetResult) GetProcAddress(hXircTcl,"_Tcl_SetResult"); */

        // test if getting function pointers succeeded
        if (
          (Tcl_AppendElement == NULL) ||
          (Tcl_AppendResult == NULL) ||
          (Tcl_CreateCommand == NULL) ||
          /* (Tcl_CreateInterp == NULL) || */
          /* (Tcl_DeleteCommand == NULL) || */
          /* (Tcl_DeleteInterp == NULL) || */
          (Tcl_DoOneEvent == NULL) ||
          /* (Tcl_Eval == NULL) || */
          /* (Tcl_EvalFile == NULL) || */
          /* (Tcl_GetVar == NULL) || */
          (Tcl_GlobalEval == NULL)
          /* Don't test for ResetResult or SetResult */
           ) {
          MessageBox(NULL,
              "Couldn't find all the needed functions within XiRCON.",
              DEFTITLE,
              MB_OK|MB_ICONSTOP|MB_SETFOREGROUND);
          return FALSE; // UNsuccessful load!!
        }
      } else {
        MessageBox(NULL,
            "Couldn't locate the proper XiRCON module! Xtcl.dll not found loaded in memory.",
            DEFTITLE,
            MB_OK|MB_ICONSTOP|MB_SETFOREGROUND);
        return FALSE; /* UNsuccessful load!! */
      }

      // add init procedures here
#if defined(CMD_ISIP)||defined(CMD_IP2LONG)||defined(CMD_LONG2IP)||defined(CMD_PORT)
      InitSockets();  // located in Sockets.cpp
#endif
#ifdef CMD_DDE
      StartDDEServer();
      DDEMaster = TRUE;
#endif
    }
    break;

  case DLL_THREAD_ATTACH:
    // unhandled
    break;

  case DLL_PROCESS_DETACH:
    refcount--;

    if (!refcount) {
      // add exit procedures here

#if defined(CMD_ISIP)||defined(CMD_IP2LONG)||defined(CMD_LONG2IP)||defined(CMD_SERV)
      if(winSock.hInstance) {
        winSock.WSACleanup();
        FreeLibrary(winSock.hInstance);
      };
#endif

#ifdef CMD_DDE
      UninitializeDDE();
#endif

    }
    break;

  case DLL_THREAD_DETACH:
    // unhandled
    break;

  }
  return TRUE; /* successful load */
}

/*
 *----------------------------------------------------------------------
 *
 * Falcon_Init --
 *  the callback for initializing the DLL from Tcl
 *
 * Results:
 *  returns TCL_OK
 *
 * Side effects:
 *  none known.
 *
 *----------------------------------------------------------------------
 */
extern "C" DllExport 
int Falcon_Init(Tcl_Interp *interp) {

  Tcl_CreateCommand(interp,"FALC_ver",CmdFalconVersion,NULL,NULL);
#ifdef CMD_INI
  Tcl_CreateCommand(interp,"FALC_ini",CmdIni,NULL,NULL);
#endif
#ifdef CMD_WMATCH
  Tcl_CreateCommand(interp,"FALC_wmatch",CmdWild_match,NULL,NULL);
#endif
#ifdef CMD_HMATCH
  Tcl_CreateCommand(interp,"FALC_hmatch",CmdHost_match,NULL,NULL);
#endif
#ifdef CMD_FILEOPEN
  Tcl_CreateCommand(interp,"FALC_fileopen",Cmdfile_open,NULL,NULL);
#endif
#ifdef CMD_SHELL
  Tcl_CreateCommand(interp,"FALC_shell",CmdShell,NULL,NULL);
#endif
#ifdef CMD_ASKBOX
  Tcl_CreateCommand(interp,"FALC_askbox",CmdAskBox,NULL,NULL);
#endif
#ifdef CMD_ISIP
  if(winSock.hInstance){
    Tcl_CreateCommand(interp,"FALC_isip",CmdIsip,NULL,NULL);
  };
#endif
#ifdef CMD_IP2LONG
  if(winSock.hInstance){
    Tcl_CreateCommand(interp,"FALC_ip2long",CmdIp2Long,NULL,NULL);
  };
#endif
#ifdef CMD_LONG2IP
  if(winSock.hInstance){
    Tcl_CreateCommand(interp,"FALC_long2ip",CmdLong2Ip,NULL,NULL);
  };
#endif
#ifdef CMD_PORT
  if(winSock.hInstance){
    Tcl_CreateCommand(interp,"FALC_port",CmdPort,NULL,NULL);
  };
#endif
#ifdef CMD_WINHLP
  Tcl_CreateCommand(interp,"FALC_winhelp",CmdWinHelp,NULL,NULL);
#endif
#ifdef CMD_DDE
  Tcl_CreateCommand(interp,"FALC_dde",CmdDde,NULL,NULL);
  if (DDEMaster) {
    DDEMaster = FALSE;
    Tcl_CreateCommand(interp,"FALC_ddeserv",CmdDdeServ,NULL,NULL);
    Tcl_CreateCommand(interp,"FALC_update",CmdFalconUpdate,NULL,NULL);
  }
#endif
#ifdef CMD_CONFIG
  Tcl_CreateCommand(interp,"FALC_config",CmdConfig,NULL,NULL);
#endif
#ifdef CMD_TOGGLE
  Tcl_CreateCommand(interp,"FALC_toggle",CmdToggle,NULL,NULL);
#endif
#ifdef CMD_FALCONDBG
  Tcl_CreateCommand(interp,"FALC_debug",CmdFalconDebug,NULL,NULL);
#endif
#ifdef CMD_YIELD
  Tcl_CreateCommand(interp,"FALC_yield",CmdYield,NULL,NULL);
#endif
#ifdef CMD_IAL
  Tcl_CreateCommand(interp,"FALC_ial",CmdIAL,NULL,NULL);
#endif
#ifdef CMD_DIALOG
  Tcl_CreateCommand(interp,"FALC_dialog",CmdDialog,NULL,NULL);
#endif
#ifdef CMD_LISTBOX
  Tcl_CreateCommand(interp,"FALC_listbox",CmdListBox,NULL,NULL);
#endif
  return TCL_OK;
}

/*
 *----------------------------------------------------------------------
 *
 * CmdFalconDebug --
 *
 *  displays some silly debug info in the interpreter for Tclsh
 *  or the current window in XiRC.
 *
 * Results:
 *  None.
 *
 * Side effects:
 *  None.
 *
 *----------------------------------------------------------------------
 */
#ifdef CMD_FALCONDBG
int CmdFalconDebug(ClientData clientData,
                   Tcl_Interp *interp,int argc,char *argv[]) {
 extern FALC_SOCK winSock;
 extern WSADATA wsaData;
 auto char buff1[100];
 auto int i;
 auto char *sh_cmd="puts",*XiRC_cmd="echo",*cmd;

  if(InXiRCON){
    cmd=XiRC_cmd;
  } else {
    cmd=sh_cmd;
  };

  sprintf(buff1,"%s \"argc = %d\"",cmd,argc);
  Tcl_GlobalEval(interp,buff1);

  for(i=1;i<argc;i++){
    sprintf(buff1,"%s \"argv\\[%d\\] = %s\"",cmd,i,argv[i]);
    Tcl_GlobalEval(interp,buff1);
  }

  if(argc<2){
    sprintf(buff1,"%s \"hInstance(module handle) is %lx\"",cmd,(long)hInstance);
    Tcl_GlobalEval(interp,buff1);
    sprintf(buff1,"%s \"winSock.hInstance is @ %lx\"",cmd,(long)winSock.hInstance);
    Tcl_GlobalEval(interp,buff1);
    sprintf(buff1,"%s \"wsaData.wVersion is %d.%d\"",cmd,LOBYTE(wsaData.wVersion),HIBYTE(wsaData.wVersion));
    Tcl_GlobalEval(interp,buff1);
    sprintf(buff1,"%s \"refcount = %d\"",cmd,refcount);
    Tcl_GlobalEval(interp,buff1);
    sprintf(buff1,"%s \"Tcl_AppendElement is @ %lx\"",cmd,(long)Tcl_AppendElement);
    Tcl_GlobalEval(interp,buff1);
    sprintf(buff1,"%s \"Tcl_AppendResult is @ %lx\"",cmd,(long)Tcl_AppendResult);
    Tcl_GlobalEval(interp,buff1);
    sprintf(buff1,"%s \"Tcl_CreateCommand is @ %lx\"",cmd,(long)Tcl_CreateCommand);
    Tcl_GlobalEval(interp,buff1);
    sprintf(buff1,"%s \"Tcl_GlobalEval is @ %lx\"",cmd,(long)Tcl_GlobalEval);
    Tcl_GlobalEval(interp,buff1);
    sprintf(buff1,"%s \"Tcl_ResetResult is @ %lx\"",cmd,(long)Tcl_ResetResult);
    Tcl_GlobalEval(interp,buff1);
  }
  return TCL_OK;
}
#endif

/*
 *----------------------------------------------------------------------
 *
 * CmdFalconVersion --
 *
 *  returns the DLL's version number. Could be used for 
 *  script dependancies. ex-> if { [FALC_ver] < 1.3 } { blablabla..
 *
 * Results:
 *  DLL's version number
 *
 * Side effects:
 *  None.
 *
 *----------------------------------------------------------------------
 */
int CmdFalconVersion(ClientData clientData,
                   Tcl_Interp *interp,int argc,char *argv[]) {
  Tcl_AppendResult(interp,FALCVER,NULL);
  return TCL_OK;
}

/*
 *----------------------------------------------------------------------
 *
 * CmdFalconUpdate --
 *
 *  This DLL cannot access XiRC directly and needs to have 
 *  this command called from the 'on timer' event so the DLL
 *  can update its async commands. Basicly this my own form 
 *  of a notifier.
 *
 * Results:
 *  None.
 *
 * Side effects:
 *  None.
 *
 *----------------------------------------------------------------------
 */
int CmdFalconUpdate(ClientData clientData,
                   Tcl_Interp *interp,int argc,char *argv[]) {

  while(Falc_DoOneEvent(interp, FALC_DDE_EVENTS));
  return TCL_OK;

}
