/*************************************************************
 **  XiRC_ext.h -  part of the Falcon DLL Extension v1.5
 **
 **  Abstract: Contains all the definitions and prototypes
 **            needed for the exposed Tcl functions found
 **            in XiRCON as of v1.0B4 . Use this if you 
 **            want to write your own extension.
 **
 ** Author: David Gravereaux  mailto:davygrvy@bigfoot.com
 ************************************************************/


#ifndef __XiRCext_h
#define __XiRCext_h


/*
 * When a TCL command returns, the string pointer interp->result points to
 * a string containing return information from the command.  In addition,
 * the command procedure returns an integer value, which is one of the
 * following:
 *
 * TCL_OK		Command completed normally;  interp->result contains
 *			the command's result.
 * TCL_ERROR		The command couldn't be completed successfully;
 *			interp->result describes what went wrong.
 * TCL_RETURN		The command requests that the current procedure
 *			return;  interp->result contains the procedure's
 *			return value.
 * TCL_BREAK		The command requests that the innermost loop
 *			be exited;  interp->result is meaningless.
 * TCL_CONTINUE		Go on to the next iteration of the current loop;
 *			interp->result is meaningless.
 */
#define TCL_OK          0
#define TCL_ERROR       1
#define TCL_RETURN      2
#define TCL_BREAK       3
#define TCL_CONTINUE    4

/*
 * Flag values passed to variable-related procedures.
 */
#define TCL_GLOBAL_ONLY      1
#define TCL_LEAVE_ERR_MSG    0x200

/*
 * Flag values to pass to Tcl_DoOneEvent to disable searches
 * for some kinds of events:
 */
#define TCL_DONT_WAIT       (1<<1)
#define TCL_WINDOW_EVENTS   (1<<2)
#define TCL_FILE_EVENTS     (1<<3)
#define TCL_TIMER_EVENTS    (1<<4)
#define TCL_IDLE_EVENTS     (1<<5)  /* WAS 0x10 ???? */
#define TCL_ALL_EVENTS      (~TCL_DONT_WAIT)


typedef void (Tcl_FreeProc) (char *blockPtr);

#define TCL_STATIC      ((Tcl_FreeProc *) 0)
#define TCL_VOLATILE    ((Tcl_FreeProc *) 1)
#define TCL_DYNAMIC     ((Tcl_FreeProc *) 3)

typedef struct {
	char *result;
	void (*freeProc)(char *blockPtr);
	int errorLine;
} Tcl_Interp;

typedef void *ClientData;
typedef void Tcl_CmdDeleteProc (ClientData clientData);
typedef int Tcl_CmdProc(ClientData clientData,Tcl_Interp *interp,int argc,char *argv[]);

/* Typedefed Tcl functions */
typedef void (*dyn_AppendElement)(Tcl_Interp *interp,char *string);
typedef int  (*dyn_AppendResult)(Tcl_Interp *interp, ...);
typedef void (*dyn_CreateCommand)(Tcl_Interp *interp,const char *cmdName, 
                                  Tcl_CmdProc *proc,ClientData clientData, 
                                  Tcl_CmdDeleteProc *deleteProc);
typedef Tcl_Interp * (*dyn_CreateInterp)(void);
typedef int  (*dyn_DeleteCommand)(Tcl_Interp *interp,char *cmdName);
typedef void (*dyn_DeleteInterp)(Tcl_Interp *interp);
typedef int  (*dyn_DoOneEvent)(int flags);
typedef int  (*dyn_Eval)(Tcl_Interp *interp,char *string);
typedef int  (*dyn_EvalFile)(Tcl_Interp *interp,char *fileName);
typedef char * (*dyn_GetVar)(Tcl_Interp *interp,char *varName,int flags);
typedef int  (*dyn_GlobalEval)(Tcl_Interp *interp,char *command);

/* ResetResult is NOT in Xtcl.dll(1.0B4) and, hopefully, will be one day. email Mark! */
typedef void (*dyn_ResetResult)(Tcl_Interp *interp);

/* SetResult is NOT in Xtcl.dll(1.0B4) and, hopefully, will be one day. email Mark!
 * be aware, using TCL_DYNAMIC may fail if Mark's compiler isn't the same as yours
 *  (run-time library difference w/malloc)
 */
typedef void (*dyn_SetResult)(Tcl_Interp *interp, char *string, Tcl_FreeProc *freeProc);

#endif /* __XiRCext_h */
