/*************************************************************
 ** WinHelp.cpp  --  part of the Falcon DLL Extension v1.50
 **
 ** Abstract:  This file contains the FALC_winhelp command.
 **
 ** Copyrights: See 'main.cpp'
 **
 ** Author: David Gravereaux  mailto:davygrvy@bigfoot.com
 ************************************************************/

#include "falcon.h"
#include "util.h"

extern dyn_AppendResult Tcl_AppendResult;
extern dyn_GlobalEval Tcl_GlobalEval;
extern dyn_ResetResult Tcl_ResetResult;

#ifndef HELP_FINDER
# define HELP_FINDER 0x000b
#endif


/*
 *--------------------------------------------------------------
 *
 * CmdWinHelp --
 *  Provides an interface to the Windows help system.
 *
 * Results:
 *  A standard TCL result.
 *
 * Usage: FALC_winhelp 
 *
 * Side effects:
 *  Will run winhelp.exe if everything works correctly.
 *
 *--------------------------------------------------------------
 */
int CmdWinHelp(ClientData clientData, 
                  Tcl_Interp *interp, int argc, char *argv[]) {
 HWND win;
 char *s;
 char *filename;
 int num;
 int arg;   
 DWORD dwData;
 UINT fuCommand;

  if (argc < 3 || argc > 5) {
Usage:
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
        " <filename> <optionname> ...\"", (char *) NULL);
    return TCL_ERROR;
  }

  win = Falc_GetXiRChWnd(interp);

  filename = argv[1];
  arg = 2;
  s = argv[arg];

  if (strcmp(s, "command") == 0) {
    arg++;
    if (arg + 1 != argc) {
      goto Usage;
    }
    fuCommand = HELP_COMMAND;
    dwData = (DWORD) argv[arg];
  } else if (strcmp(s, "contents") == 0) {
    arg++;
    if (arg + 1 != argc) {
      goto Usage;
    }
    if (Falc_GetInt(interp, argv[arg], (int *) &num) != TCL_OK) {
      return TCL_ERROR;
    }
    fuCommand = HELP_CONTENTS;
    dwData = 0L;
  } else if (strcmp(s, "context") == 0) {
    arg++;
    if (arg + 1 != argc) {
      goto Usage;
    }
    if (Falc_GetInt(interp, argv[arg], (int *) &num) != TCL_OK) {
      return TCL_ERROR;
    }
    fuCommand = HELP_CONTEXT;
    dwData = (DWORD) num;
  } else if (strcmp(s, "contextpopup") == 0) {
    arg++;
    if (arg + 1 != argc) {
      goto Usage;
    }
    if (Falc_GetInt(interp, argv[arg], (int *) &num) != TCL_OK) {
      return TCL_ERROR;
    }
    fuCommand = HELP_CONTEXTPOPUP;
    dwData = (DWORD) num;
  } else if (strcmp(s, "forcefile") == 0) {
    arg++;
    if (arg != argc) {
      goto Usage;
    }
    fuCommand = HELP_FORCEFILE;
    dwData = 0L;
  } else if (strcmp(s, "helponhelp") == 0) {
    arg++;
    if (arg != argc) {
      goto Usage;
    }
    fuCommand = HELP_HELPONHELP;
    dwData = 0L;
  } else if (strcmp(s, "index") == 0) {
    arg++;
    if (arg != argc) {
      goto Usage;
    }
    fuCommand = HELP_INDEX;
    dwData = 0L;
  } else if (strcmp(s, "key") == 0) {
    arg++;
    if (arg + 1 != argc) {
      goto Usage;
    }
    fuCommand = HELP_KEY;
    dwData = (DWORD) argv[arg];
  } else if (strcmp(s, "partialkey") == 0) {
    arg++;
    if (arg + 1 != argc) {
      goto Usage;
    }
    fuCommand = HELP_PARTIALKEY;
    dwData = (DWORD) argv[arg];
  } else if (strcmp(s, "quit") == 0) {
    arg++;
    if (arg != argc) {
      goto Usage;
    }
    fuCommand = HELP_QUIT;
    dwData = 0L;
  } else if (strcmp(s, "setcontents") == 0) {
    arg++;
    if (arg + 1 != argc) {
      goto Usage;
    }
    if (Falc_GetInt(interp, argv[arg], (int *) &num) != TCL_OK) {
      return TCL_ERROR;
    }
    fuCommand = HELP_SETCONTENTS;
    dwData = (DWORD) num;
  } else if (strcmp(s, "setindex") == 0) {
    arg++;
    if (arg + 1 != argc) {
      goto Usage;
    }
    if (Falc_GetInt(interp, argv[arg], (int *) &num) != TCL_OK) {
      return TCL_ERROR;
    }
    fuCommand = HELP_SETINDEX;
    dwData = (DWORD) num;
  } else if (strcmp(s, "finder") == 0) {
    arg++;
    if (arg != argc) {
      goto Usage;
    }
    fuCommand = HELP_FINDER;
    dwData = (DWORD) 0;
  } else {
    Tcl_AppendResult(interp, "unknown option \"", s,
        "\": must be one of command, contents, context,",
        " contextpopup, forcefile, finder, helponhelp,",
        " index, key, partialkey, quit, setcontents,",
        " or setindex", (char *) NULL);
    return TCL_ERROR;
  }

  if (! WinHelp(win, filename, fuCommand, dwData)) {
    Tcl_AppendResult(interp, "winhelp call failed: check to see if the filename is valid",
        (char *) NULL);
    return TCL_ERROR;
  }

  return TCL_OK;
}

