/*************************************************************
 ** Shell.cpp  --  part of the Falcon DLL Extension v1.4
 **
 ** Abstract: This file contains the FALC_shell command.
 **
 ** Copyright: see 'main.cpp'
 **
 ** Author: David Gravereaux  mailto:davygrvy@bigfoot.com
 ************************************************************/

#include "falcon.h"
#include "util.h"

#include <shellapi.h>

extern dyn_AppendResult Tcl_AppendResult;
extern dyn_AppendElement Tcl_AppendElement;
extern dyn_GlobalEval Tcl_GlobalEval;
extern dyn_ResetResult Tcl_ResetResult;
extern BOOL InXiRCON;

/*
 *----------------------------------------------------------------------
 *
 * CmdShell --
 *
 *  a non-blocking way to start external apps using WinAPI's ShellExecute(). 
 *  I found the 'exec' command to be a pain when i didn't want the 
 *  exit code returned
 *
 * Results:
 *  nothing or an error
 *
 * Side effects:
 *  none known.
 *
 *----------------------------------------------------------------------
 */
extern int CmdShell(ClientData clientData,
                    Tcl_Interp *interp,int argc,char *argv[]){
 HWND hwndOwner;
 char *lpOperation,*lpFile,*lpParameters,*lpDirectory;
 int nShowCmd,j;
 unsigned long hInst;

  lpFile=NULL;
  lpOperation=NULL;
  lpParameters=NULL;
  lpDirectory=NULL;
  nShowCmd=SW_SHOWNORMAL;
  hwndOwner = Falc_GetXiRChWnd(interp);


  /* Decode args */
  if (argc > 1) {
    for (j=1;(j+1)<argc;j++) {
      if (!strncmp(argv[j],"-",1)) {
        switch (*(argv[j]+1)) {
        case 'v': /* verb */
          lpOperation=argv[++j]; break;
        case 'p': /* parameters */
          lpParameters=argv[++j]; break;
        case 'd': /* directory */
          if(!(lpDirectory=Falc_DoFileName(argv[++j]))) goto Usage;
          break;
        case 's': /* show style */
          if (!strnicmp(argv[++j],"hi",2))nShowCmd=SW_HIDE;
          else if(!strnicmp(argv[j],"ma",2))nShowCmd=SW_SHOWMAXIMIZED;
          else if(!strnicmp(argv[j],"mi",2))nShowCmd=SW_SHOWMINNOACTIVE;
          break;
        default:
          Tcl_AppendResult(interp,argv[0],": ",argv[j]," is an unknown option. ",NULL);
          goto Usage;
        }
      }
    }

    lpFile=argv[argc-1];

  } else {
Usage:
    Tcl_AppendResult(interp,"Usage: ",argv[0]," [-v <verb>] [-p <parms>] [-d <DefDirectory>] [-s <ShowStyle>] <file>",NULL);
    return TCL_ERROR;
  }


/*
(*Tcl_AppendResult)(interp,
      "lpOperation = ",lpOperation?lpOperation:"",
      "\nlpParameters = ",lpParameters?lpParameters:"",
      "\nlpDirectory = ",lpDirectory?lpDirectory:"",
      "\nnShowCmd = ",itoa(nShowCmd,buff2,10),
      "\nlpFile = ",lpFile?lpFile:"",
      NULL);
return TCL_OK;
*/

  if((hInst=(unsigned long)ShellExecute(hwndOwner,lpOperation,lpFile,lpParameters,
        lpDirectory,nShowCmd))>32){
    if(lpDirectory) xfree(lpDirectory);
    /* success! */
    return TCL_OK;
  } else {
    auto char buff[120 + MAX_PATH];

    switch (hInst) {
    case 0 : 
      sprintf(buff,"The operating system is out of memory or resources (\"%s\").",lpFile); break;
    case ERROR_FILE_NOT_FOUND :
      sprintf(buff,"The specified file (\"%s\") was not found.",lpFile); break;
    case ERROR_PATH_NOT_FOUND :
      sprintf(buff,"The specified path was not found for (\"%s\").",lpFile); break;
    case ERROR_BAD_FORMAT : 
      sprintf(buff,"The .EXE file (\"%s\") is invalid (non-Win32 .EXE or error in .EXE image).",lpFile); break;
    case SE_ERR_ACCESSDENIED :
      sprintf(buff,"The operating system denied access to the specified file (\"%s\").",lpFile); break;
    case SE_ERR_ASSOCINCOMPLETE	:
      sprintf(buff,"The filename association to (\"%s\") is incomplete or invalid.",lpFile); break;
    case SE_ERR_DDEBUSY :
      sprintf(buff,"The DDE transaction could not be completed because other DDE transactions were being processed for (\"%s\").",lpFile); break;
    case SE_ERR_DDEFAIL :
      sprintf(buff,"The DDE transaction failed to (\"%s\").",lpFile); break;
    case SE_ERR_DDETIMEOUT :
      sprintf(buff,"The DDE transaction could not be completed because the request timed out (\"%s\").",lpFile); break;
    case SE_ERR_DLLNOTFOUND :
      sprintf(buff,"The specified dynamic-link library was not found (\"%s\").",lpFile); break;
    case SE_ERR_NOASSOC :
      sprintf(buff,"There is no application associated with the given filename extension for (\"%s\").",lpFile); break;
    case SE_ERR_OOM :
      sprintf(buff,"There was not enough memory to complete the operation."); break;
    case SE_ERR_SHARE :
      sprintf(buff,"A sharing violation occurred with (\"%s\").",lpFile); break;
    default :
      sprintf(buff,"unknown error starting (\"%s\").",lpFile);
    };
    Tcl_AppendResult(interp,buff,NULL);
    if(lpDirectory) xfree(lpDirectory);
    return TCL_ERROR;
  };
}

