/*************************************************************
 ** IAL.cpp  --  part of the Falcon DLL Extension v1.50
 **
 ** Abstract: This file contains the FALC_ial command and 
 **           related functions for the Internal Address
 **           List.
 **
 ** Copyrights: See 'main.cpp'
 **
 ** Author: David Gravereaux  mailto:davygrvy@bigfoot.com
 ************************************************************/

#include "falcon.h"
#include "tclHash.h"

extern dyn_AppendResult Tcl_AppendResult;

/*

  IAL object will be:

  1) nickname
  2) fulladdress
  3) channel membership list

  able to presort list for channel membership. It's possible that 
  not all nicknames will have a channel membership. So that when you leave
  a channel, the entire list is for that channel is dropped without 
  iterating the entire list to discover membership.

  commands will be:

   to add:
  FALC_ial -a[dd] <fulladdress> [<channel>]
   to remove:
  FALC_ial -r[emove] <nick> [<channel>]
   to modify:
  FALC_ial -m[odify] <oldnick> <newnick>
   to dump a channel when parting:
  FALC_ial -d[ump] <channel>
   to get all nicks (returns a Tcl list) from an addressmask:
  FALC_ial -g[et] *!*@clones.foobar.com [<channel>]
   to clear the IAL:
  FALC_ial -c[lear]


  support script will be:

  alias PART { FALC_ial -d [lindex [args] 0] }
  on NICK { FALC_ial -m [nick] [lindex [args] 0] }
  on PART { 
    if {[icomp [nick] [my_nick]]} { 
      FALC_ial -r [nick] [lindex [args] 0]
    }
  }
  on JOIN {
    FALC_ial -a "[nick]![user]@[host]" [lindex [args] 0]
    if {![icomp [nick] [my_nick]]}
      set refreshIAL [lindex [args] 0]
      /who [lindex [args] 0]
    }
  }
  on QUIT { FALC_ial -r [nick] }
  on KICK { FALC_ial -r [nick] [lindex [args] 0] }
  on DISCONNECT {
    if [info exist refreshIAL] { unset refreshIAL }
    FALC_ial -c  
  }
  # RPL_ENDOFWHO
  on 315 { if [info exist refreshIAL] { unset refreshIAL ; complete } }
  # RPL_WHOREPLY
  on 352 {
    if [info exist refreshIAL] {
      FALC_ial -a "[lindex [args] 5]![lindex [args] 2]@[lindex [args] 3]" \
          $refreshIAL
      complete
    }
  }

   
*/

Tcl_HashTable fun;

int CmdIAL (ClientData clientData, 
                  Tcl_Interp *interp, int argc, char *argv[]) {
 char *NickName, *FullAddress, *Channel, *OldNick, *Mask;

 NickName = NULL;
 FullAddress = NULL;
 Channel = NULL;
 OldNick = NULL;
 Mask = NULL;

  /* Decode args */
  if (argc > 1 && *argv[1] == '-') {
    switch (*(argv[1]+1)) {
    case 'a':  /* add */
      if (argc > 2) {
        FullAddress = argv[2];
      } else {
        goto Usage;
      }
      if (argc > 3) {
        Channel = argv[3];
      }
      // extract nick from fulladdress
      while(*(FullAddress + i)!=NULL && flag = FALSE) {
        i++;
        if (*(FullAddress + i)=='!') flag = TRUE;
      }

      break;
    case 'r':  /* remove */
      break;
    case 'm':  /* modify */
      break;
    case 'd':  /* dump */
      break;
    case 'g':  /* get */
      break;
    case 'c':  /* clear */
      break;
    case 's':  /* stats */
      Tcl_AppendResult(interp, FALC_HashStats(&fun), "\n", (char *)NULL);
      break;
    default:
Usage:
      Tcl_AppendResult(interp,argv[0],": unknown arguement ",argv[1]+1,NULL);
      return TCL_ERROR;
    }
  } else {
    goto Usage;
  }

  return TCL_OK;
}