/*************************************************************
 ** falcon.h  --  part of the Falcon DLL Extension
 **
 ** Abstract: This file contains all global defines and 
 **           functions prototypes that are shared within
 **           the modules.
 **
 ** Copyrights: See 'main.cpp'
 **
 ** Author: David Gravereaux  mailto:davygrvy@bigfoot.com
 ************************************************************/

#ifndef __Falcon_h
#define __Falcon_h

/* #define STRICT */
#define WIN32_LEAN_AND_MEAN  /* Reduces needless header crunching */
#define WINVER 0x0400        /* Enables Win95/NT4 special features */
#define _WINSOCKAPI_         /* Forcefully prevents inclusion of winsock.h */

#include <windows.h>
#include <windowsx.h>
#include <winbase.h>
#define INCL_WINSOCK_API_PROTOTYPES 0  /* Turn off load-time linking */
#define INCL_WINSOCK_API_TYPEDEFS 1    /* Enable typedefs for run-time 
                                        * linking thru code with 
                                        * loadlibrary()
                                        */
#include <winsock2.h>
#if !defined(_WS2TCPIP_H_)
# include <ws2tcpip.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "XiRC_ext.h"


/* Structures */
typedef struct {
    HINSTANCE hInstance;    /* Handle to WinSock library. */
    //HWND hWnd;              /* Handle to the window for socket messages. */
    LPFN_GETSERVBYNAME getservbyname;
    LPFN_GETSERVBYPORT getservbyport;
    LPFN_HTONS htons;
    LPFN_HTONL htonl;
    LPFN_INET_ADDR inet_addr;
    LPFN_INET_NTOA inet_ntoa;
    LPFN_NTOHL ntohl;
    LPFN_NTOHS ntohs;
    LPFN_WSASTARTUP WSAStartup;
    LPFN_WSACLEANUP WSACleanup;
    LPFN_WSAGETLASTERROR WSAGetLastError;
} FALC_SOCK;

#define DEFTITLE        "Falcon Toolkit v1.5 for XiRCON"

#ifndef xmalloc
# define xmalloc(s)     HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,(s))
# define xrealloc(p,s)  HeapReAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,(p),(s))
# define xmemsize(p)    HeapSize(GetProcessHeap(),0,(p))
# define xfree(p)       HeapFree(GetProcessHeap(),0,(p))
#endif

#define DllExport  __declspec( dllexport )

#endif /* __Falcon_h */
