/*************************************************************
 ** Yield.cpp  --  part of the Falcon DLL Extension v1.50
 **
 ** Abstract:  This file contains the FALC_yield command.
 **
 ** Copyrights: See 'main.cpp'
 **
 ** Author: David Gravereaux  mailto:davygrvy@bigfoot.com
 ************************************************************/

#include "falcon.h"

extern dyn_AppendResult Tcl_AppendResult;
extern dyn_DoOneEvent Tcl_DoOneEvent;


/*
 *--------------------------------------------------------------
 *
 * CmdYield --
 *  Used to provide a yield to other pending XiRC operations 
 *  in the event queue.
 *
 * Results:
 *  BOOLEAN: whether an event was processed or not.
 *
 * Side effects:
 *  unknown.
 *
 *--------------------------------------------------------------
 */
int CmdYield(ClientData clientData, 
                  Tcl_Interp *interp, int argc, char *argv[]) {
 int result;
 char buff[33];
 
  result = Tcl_DoOneEvent(TCL_DONT_WAIT);
  itoa(result,buff,10);
  Tcl_AppendResult(interp,buff,NULL);

  return TCL_OK;
}
