
# ask the user what we should do about the missing INI file.
switch [FALC_askbox -t $srcfile -b yes_no_cancel -i exclamation -d no \
    " The data INI file for $srcfile is missing.\n \
     A new one will be created at $botfile.\n\n \
     Press YES to accept this.\n  Press NO to select a new location.\n \
     Press CANCEL to abort this script."] {

  yes {
    FALC_yield
    set_cookie botfile $botfile
  }

  no {
    FALC_yield
    if {[set filename [FALC_fileopen -m -e -d [pwd] -f $inifilter \
        -t "Select The INI file to OPEN or CREATE"]] != "" } {

      # be nice to the GUI and let it redraw from the 
      # dialog that was in front of it.
      FALC_yield

      set_cookie botfile [set botfile $filename]
      unset filename
    } else { 
      # user pressed cancel in the open dialog, so abort.
      FALC_yield
      return abort
    }
  }

  cancel { 
    FALC_yield
    return abort
  }
}
return 0
