set txt ""
if { [set txt [prompt $srcfile "What's the name of the network?"]] != "" } {
  FALC_yield

  # grab all section names and set them to lower case.
  set botnets [FALC_ini -r $botfile NULL ""]
  for { set i 0 } { $i < [llength $botnets] } { incr i } {
    set botnets [lreplace $botnets $i $i [string tolower [lindex $botnets $i]]]
  }

  # see if the new name already exists in the ini file
  if { [lsearch $botnets [string tolower $txt]] != -1 } {

    # found the new entry already exists.  What do we do?
    set msg "The entry \"$txt\" already exists!  Overwrite it with a blank one?"
    switch [FALC_askbox -t $srcfile -b yes_no -d no -i exclamation $msg ] {
      yes { 
        FALC_yield
        FALC_ini -w $botfile $txt NULL ""
        FALC_ini -w $botfile $txt NULL NULL
        rehash
      }
      no { FALC_yield }
    }
    unset msg
  } else {
    FALC_ini -w $botfile $txt NULL NULL
    rehash
  }
  unset i botnets
}
unset txt
return 0
