###########################################
#
#   eggie.tcl {PlugIn} for XiRCON Communicator 1.0B4
#
#  (part of the Falcon script collection)
#
#   written by: David Gravereaux
#   mailto:davygrvy@bigfoot.com
#
#   purpose: adds some eggdrop IRC bot support
#
#   NOTE:  requires a CORE falcon.dll script to use
#          this one. if you don't have a CORE,
#          /load dummy.tcl first then this script 
#          second.
#
###########################################
#      ver 1.22
###########################################

#***********************************
# REVISION LOG ENTRY
# Revision By: David Gravereaux
# Revised on 5/14/1998 7:59:03 PM
# Comments: moved "remove a network..." and
#           "remove a bot..." to seperate files.
#           Added a password saving and displaying 
#           routine.
#***********************************


##################
### Edit your paths here.
###
### Paths could be an absolute path
### or relative to your default script
### directory.

set srcpath  ""
set dllpath  ""

set srcfile  eggie.tcl
set menufile egg.mnu

##################



# no need to edit beyond here


# yes, you can load the dll without the 'on timer' event,
# BUT because we know the script won't be the first, FALC_update
# and the DDE server won't be given to this interpreter.
if [catch { load [file join $dllpath falcon.dll] }] {
  echo "[color error]$srcfile: Please edit the paths entries in $srcfile, then load it again." status
  return
}

# We need version 1.49 or better
if {[set ver [FALC_ver]] < 1.49} {
  echo "[color error]$srcfile: falcon.dll is v$ver. This script needs at least version 1.49 of falcon." status
  return
}

if [llength [info commands FALC_update]] {
  # This trap is here for a good reason.  This script is a plugin
  # to a CORE script that uses falcon.dll.  Its nescessary for this
  # script to send a DDE command to the CORE script to tell it to
  # reload this script and CAN'T be done here from code.  IOW, if
  # I put this call ( "/load $srcfile" ) in this code, XiRCON will
  # crash.  A script can't reload itself.
  echo "[color error]$srcfile: This script requires that it NOT be the first loaded."
  return
}



###  Procedures  ###

proc rehash { } {
  global botfile srcpath srcfile

  #  Set a flag so we don't litter the status window
  #  with "*** Loaded script "eggie"" on each rehash
  FALC_ini -w $botfile main rehash 1

  #  This *magic* call tells the main CORE script to rehash
  #  this one to rebuild the menus.
  FALC_dde -a poke Falcon Action Script "/load [file join $srcpath $srcfile]"
}
proc icomp { a b } { return [string compare [string tolower $a] [string tolower $b]] }
proc updatelast { section name } {
  global botfile
  FALC_ini -w $botfile $section @last $name
  rehash
}


# absolute path only, please.
set botfile [get_cookie botfile "[pwd]/botnets.ini"]

set inifilter "Configuration Settings (*.ini)|*.ini"

# check for existence of the ini file.
if { ![file exist $botfile] } {
  if { [source [file join $srcpath eggie_noini.tcl]] == "abort" } {
    return
  }
}

# check to see if our editor has been cookied.
set rand [random 0 65535]
if { [set MyEditor [get_cookie MyEditor $rand]] == $rand } {
  if { [source [file join $srcpath eggie_noedit.tcl]] == "abort" } {
    return
  }
}
unset rand




###  Status Menus  ###

menu status "" { }

# get all the sections in the ini file.
set botnets [FALC_ini -r $botfile NULL ""]

# the section called "main" doesn't contain any bots 
# in it, so remove it from the list if its there.
if { [set idx [lsearch $botnets "main"]] != -1 } {
  set botnets [lreplace $botnets $idx $idx]
}
unset idx
 
# sort the list.
set botnets [lsort -command {icomp} $botnets]

# check to make sure its not blank
if { [lindex $botnets 0] != "" } {

  foreach botnet $botnets {

    # be nice to the GUI and yield to all pending events.
    while [FALC_yield] {}

    # get all keys in this section and sort 'em too.
    set bots [lsort -command {icomp} [FALC_ini -r $botfile $botnet NULL]]

    # get "@last" key if its there.
    if { [set idx [lsearch $bots "@last"]] != -1 } {
      
      # retrieve the last connected bot so we can 
      # highlight it when its menu is created.
      set lastbot [FALC_ini -r $botfile $botnet @last]

      # remove it from the bot list.
      set bots [lreplace $bots $idx $idx]
    }

    # check to see the list is not blank
    if { [lindex $bots 0] != "" } {

      foreach bot $bots {
 
        set A ""
        if {[info exist lastbot] && ![icomp $bot $lastbot]} { set A * }

        # retrieve the key and seperate bot version
        if { [llength [set data [split [FALC_ini -r $botfile $botnet $bot] ,]]] > 1 } {
          set botver "----  BOT: [lindex $data 1]"
        } else {
          set botver "----  BOT: Discovering..."
        }

        # seperate host and port
        set data [split [lindex $data 0] :]

        # if a ":" was found, then its Warp mode
        if { [llength $data] > 1 } {
          # warp-mode
          menu status "BotNets->$botnet->$A$bot" [subst { 
            /raw privmsg \[my_nick\] :\001dcc chat chat \
                [FALC_ip2long [lindex $data 0]] [FALC_port [lindex $data 1]]\001
            updatelast $botnet $bot
          }]
        } else {
          # ctcp-mode
          menu status "BotNets->$botnet->$A$bot" [subst {
            if {\[llength \[set passwords \[get_cookie passwords\]\]\] > 1 &&
                \[set idx \[lsearch \$passwords "$botnet *"\]\] != -1 } {
              set pass " ----  PASS: \[lindex \[lindex \$passwords \$idx\] 1\]"
            } else {
              set pass " ----  PASS: Unknown"
            }
            /dcc chat $data
            window set_title "\[window get_title chat $bot\] $botver \$pass" chat $bot
            updatelast $botnet $bot
          }]
        }
      }
      if [info exist lastbot] { unset lastbot }
      if [info exist A] { unset A }
      menu status "BotNets->$botnet->" { }
    }
    menu status "BotNets->$botnet->set password..." [subst {
      set thisnet $botnet
      source [file join $srcpath eggie_setpass.tcl]
      unset thisnet
    }]
    menu status "BotNets->$botnet->&add a new bot..." [subst {
      set bot ""
      if {\[set bot \[prompt $srcfile \
          "Bot info (<name> | <name>:<host|IP>:<port>)"\]\] != "" } {
        FALC_ini -w $botfile $botnet \[lindex \[split \$bot :\] 0\] \$bot
        rehash
      }
    }]
    if { [lindex $bots 0] != "" } {
      menu status "BotNets->$botnet->&remove a bot..." [subst {
        set thisnet $botnet
        source [file join $srcpath eggie_rmbot.tcl]
        unset thisnet
      }]
    }
  }
  menu status "BotNets->" { }
}

menu status "BotNets->&add a new network..." [subst {
  source [file join $srcpath eggie_addnet.tcl]
}]
if { [lindex $botnets 0] != "" } {
  menu status "BotNets->&remove a network..." [subst {
    source [file join $srcpath eggie_rmnet.tcl]
  }]
}
menu status "BotNets->" { }
menu status "BotNets->&load a new INI file..." {
  if {[set filename [FALC_fileopen -m -e -d [pwd] -f $inifilter \
      -t "Select The INI file to OPEN or CREATE"]] != "" } {
    FALC_yield
    set_cookie botfile $filename
    rehash
  }
}
menu status "BotNets->&merge an INI file->*&add new only..." {
  if {[set filename [FALC_fileopen -m -d [pwd] -f $inifilter \
      -t "Select The INI file to MERGE"]] != "" } {
    FALC_yield
    foreach section [FALC_ini -r $filename NULL ""] {
      foreach key [FALC_ini -r $filename $section NULL] {
        FALC_yield
        if {[FALC_ini -r $botfile $section $key "`"] == "`"} {
          FALC_ini -w $botfile $section $key \
              [FALC_ini -r $filename $section $key]
        }
      }
    }
  }
  rehash
}
menu status "BotNets->&merge an INI file->&overwrite and add..." {
  if {[set filename [FALC_fileopen -m -d [pwd] -f $inifilter \
      -t "Select The INI file to MERGE with overwrite"]] != "" } {
    FALC_yield
    foreach section [FALC_ini -r $filename NULL ""] {
      foreach key [FALC_ini -r $filename $section NULL] {
        FALC_yield
        FALC_ini -w $botfile $section $key \
            [FALC_ini -r $filename $section $key]
      }
    }
    rehash
  }
}
menu status "BotNets->&edit INI file" [subst { FALC_shell -p $botfile $MyEditor }]
menu status "BotNets->re&hash INI file" { rehash }


if [info exist data] { unset data }
if [info exist bot] { unset bot }
if [info exist bots] { unset bots }
if [info exist botnet] { unset botnet }
if [info exist botnets] { unset botnets }
if [info exist idx] { unset idx }
if [info exist txt] { unset txt }
if [info exist MyEditor] { unset MyEditor }

# ensure the chat menus are loaded
if { [lsearch [scripts] "*$menufile"] == -1 } {
  /load [file join $srcpath $menufile]
}


###  Events  ###

on load {
  if {[FALC_ini -r $botfile main rehash 0] == 1} {
    # delete the entire main section
    FALC_ini -w $botfile main NULL ""
    complete
  }
}
on chat_disconnect {
  set title [window get_title chat [join [args]]]
  if {[FALC_wmatch "*--~eggdrop*" $title]} {
    # add code here
  }
}

