;##########################################################################;
;                                                                          ;
;                            tabo FTP Client 2.0                           ;
;                                                                          ;
; /ftpconf to open Site Manager                                            ;
; /ftpmon [on|off] to set Clipboard Monitor                                ;
; /ftp N to connect to account number N                                    ;
; /ftp Syntax: [ftp://][login[:pass]@]<server.com>[:port][/dir][/file.ext] ;
; /ftp without parameters open dialog (easier than typing a whole address) ;
; /ftpabout to open thw about dialog                                       ;
; /ftpunload to unload the addon                                           ;
;                                                                          ;
;                            tabo@linuxmail.org                            ;
;                   http://www.geocities.com/aircscript/                   ;
;                                                                          ;
;                                tabo - 2001                               ;
;                                                                          ;
;##########################################################################;

ON *:LOAD:{
  if ($version < 5.82) {
    error.a tabo FTP Client 2.0 needs mIRC v5.82
    unload -rs $script
  }
  else {
    _ftp.revisa
    var %file = $_list.file(ftpaccounts),%t
    if ($lock(dll)) { %t = - Please unlock DLLs in mIRC options/General/Lock }
    info.a tabo FTP Client 2.0 Loaded! %t
    ftphelp
  }
}
ON *:START:{
  _start.filelist
  _ftp.revisa
  .ftpmon
}
alias -l ftphelp {
  linesep -s
  echo $colour(info) -ist tabo FTP Client 2.0 - HELP
  echo $colour(info) -ist /ftpconf to open Site Manager
  echo $colour(info) -ist /ftpmon [on|off] to set Clipboard Monitor
  echo $colour(info) -ist /ftp N to connect to account number N
  echo $colour(info) -ist /ftp Syntax: [ftp://][login[:pass]@]<server.com>[:port][/dir][/file.ext]
  echo $colour(info) -ist /ftp without parameters open dialog (easier than typing a whole address)
  echo $colour(info) -ist mail tabo@linuxmail.org for support/bug reports
  echo $colour(info) -ist Visit http://www.geocities.com/aircscript/ for more info
  if ($lock(dll)) {
    echo $colour(info) -ist WARNING: DLLs are locked
    echo $colour(info) -ist Please unlock DLLs in mIRC options/General/Lock
  }
  linesep -s
}
menu status,menubar {
  tabo&ftp
  .&connect...:{ ftp }
  .&accounts...:{ ftpconf }
  .$`ifmm($_getsetup(ftp,monitor)) clipboard &monitor:{
    if ($_getsetup(ftp,monitor)) { ftpmon off }
    else { ftpmon on }
  }
  .-
  .$_ftp.mni(1):{ _ftp.mn 1 }
  .$_ftp.mni(2):{ _ftp.mn 2 }
  .$_ftp.mni(3):{ _ftp.mn 3 }
  .$_ftp.mni(4):{ _ftp.mn 4 }
  .$_ftp.mni(5):{ _ftp.mn 5 }
  .$_ftp.mni(6):{ _ftp.mn 6 }
  .$_ftp.mni(7):{ _ftp.mn 7 }
  .$_ftp.mni(8):{ _ftp.mn 8 }
  .$_ftp.mni(9):{ _ftp.mn 9 }
  .$_ftp.mni(10):{ _ftp.mn 10 }
  .-
  .$`bl(ftp):{ _recent.flush ftp }
  .-
  .&unload...:{ ftpunload }
  .$iif($isfile($scriptdirtaboftp.txt),&readme):{ run $scriptdirtaboftp.txt }
  .&about:{ ftpabout }
  .&help:{ ftphelp }
}
alias ftpunload {
  if ($_yesno(1,Unload taboFTP [/ftpunload],1,Unload taboFTP Client v2.0 ?)) {
    if ($_ftp.unload) { return }
    unload -rs " $+ $script $+ "
  }
}
alias ftpabout {
  if ($dialog(_ftp.about)) { dialog -v _ftp.about }
  else { dialog -m _ftp.about _ftp.about }
}
alias -l _ftp.about.photo { did -g $dname 7 $shortfn($scriptdirtaboftp.jpg) }

dialog _ftp.about {
  size -1 -1 168 85
  title "About taboFTP Client v2.0"
  option type dbu

  icon 1,8 5 20 20
  text "",2,30 5 90 50
  icon 7,130 5 32 35
  link "http://www.geocities.com/aircscript/",51,25 55 175 15
  link "tabo@linuxmail.org",52,45 68 90 15
  button "&Author!",53,133 43 26 11
  button "",230,50 50 33 15,cancel hide
}
ON *:DIALOG:_ftp.about:init:0:{
  _mdx.init
  did -g $dname 1 $_icofile(airc.ico)
  did -a $dname 2 taboFTP Client v2.0 $+ $crlf $+ addon for mIRC v5.82 $+ $crlf $crlf $+ Copyright  2001 tabo Co. Ltd $+ $crlf $+ All Rights Reserved $+ $crlf $crlf $+ Written by tabo
  _ftp.about.photo
}
ON *:DIALOG:_ftp.about:sclick:7,53:{ _ftp.about.photo }


;/*******************************************************************************************
; *
; * aIRC
; * FTP Client file 1
; *
; *******************************************************************************************/
;
;
alias _ftp.aircver { return 2.0 }
alias _ftp.loadsetup {
  unset %c.ftpcb.l
  if ($_getsetup(ftp,monitor)) { .timerFTPCB 0 1 _ftp.cb }
  else { .timerFTPCB off }
}
alias ftp {
  _ftp.revisa
  if ($lock(dll)) {
    error.a DLL is locked
    return
  }
  if ($1- == $null) {
    ftpconf
    _ftp.preguntacuenta
    return
  }

  _getlocalip ftp $1-
  if ($result) { return }

  if ($1- isnum) {
    if ($_list.get(ftpaccounts,$1) != $null) { _ftp.cuenta.conecta $1- }
    else { error.a Account $1 was not configured }
    return
  }
  var %ss,%l,%p,%ano,%dir,%pu,%s,%n = 1,%ds
  %ss = $remove($1-,ftp://)
  if ($numtok(%ss,64) > 1) {
    %l = $gettok($gettok(%ss,1- [ $+ [ $calc($numtok(%ss,64) - 1) ] ] ,64),1,58)
    %p = $gettok($gettok(%ss,1- [ $+ [ $calc($numtok(%ss,64) - 1) ] ] ,64),2,58)
  }
  if (%l == $null) {
    %l = anonymous
    %ano = 1
  }
  else { %ano = 0 }
  if (%p == $null) { %p = $null }
  %ss = $gettok(%ss,$numtok(%ss,64),64)
  if ($gettok(%ss,2-,47) != $null) {
    %dir = $ifmatch
    if (/* !iswm %dir) { %dir = / $+ %dir }
  }
  %ss = $gettok(%ss,1,47)
  if ($gettok(%ss,2,58)) { %pu = $ifmatch }
  elseif ($gettok(%dir,2,58)) { %pu = $ifmatch }
  else { %pu = 21 }
  %dir = $gettok(%dir,1,58)
  %ss = $gettok(%ss,1,58)
  %s = $gettok($gettok(%ss,1,47),1,32)
  if (%pu !isnum) { %pu = 21 }
  if (%dir == $null) { var %dir }
  while ($sock(ftp [ $+ [ %n ] ] )) { inc %n }
  %ds = FTP $+ %n
  if ($dialog(%ds) == $null) {
    set -u %~ftpw $calc(($window(-1).w - 5) / $dbuw)
    set -u %~ftph $calc(($window(-1).h - 100) / $dbuh)
    dialog -dm %ds _ftpclient
  }
  else {
    _ftp.reflocal %ds $iif(%c.ftp.dl,%c.ftp.dl,$getdir)
    dialog -v %ds
    unset %c.ftp.dl
  }
  _ftp.addlog.info %ds Connecting: %s %pu
  sockopen %ds %s %pu
  did -o %ds 2994 1 %s
  did -o %ds 2994 2 %l
  did -o %ds 2994 3 %p
  did -o %ds 2994 4 %dir
  did -o %ds 2994 5 $null
  did -o %ds 2994 6 $null
  did -o %ds 2994 7 0
  did -o %ds 2994 8 0
  did -o %ds 2994 9 %ano
  did -o %ds 2994 10 $null
  did -o %ds 2994 11 0
  did -o %ds 2994 12 0
  did -o %ds 2994 13 1
  did -o %ds 2994 14 $null
  did -o %ds 2994 15 1
  did -o %ds 2994 16 $null
  did -o %ds 2994 17 1
  did -o %ds 2994 18 0
  if (%ano) { %p = aIRC@ $+ $ip }
  if (%dir == $null) { %dir = / }
  if (%pu == 21) { _recent.add ftp 10 %ss $+ %dir $+ ? $+ %l $+ ? $+ $_crypt(%p) }
  else { _recent.add ftp 10 %ss $+ : $+ %pu $+ %dir $+ ? $+ %l $+ ? $+ $_crypt(%p) }
}
ON ^*:HOTLINK:ftp?//?*:*:{
  if (ftp://* iswm $1) && ($remove($1,ftp://) != $null) { return }
  halt
}
ON ^*:HOTLINK:ftp.*:*:{
  if ($remove($1,ftp.) != $null) { return }
  halt
}
ON *:HOTLINK:ftp?//?*:*:{ ftp $1 }
ON *:HOTLINK:ftp.*:*:{ ftp $1 }
alias ftpmon {
  if ($1- == $null) { info.a FTP Clipboard Monitor is  $+ $iif($_getsetup(ftp,monitor),ON,OFF) }
  if ($1- == on) {
    if ($show) { info.a FTP Clipboard Monitor is now ON }
    _setsetup ftp monitor 1
  }
  if ($1- == off) {
    if ($show) { info.a FTP Clipboard Monitor is now OFF }
    _setsetup ftp monitor 0
  }
  _ftp.loadsetup
}
alias _ftp.cb {
  if ($strip($remove($cb,$cr,$lf)) == %c.ftpcb.l) { return }
  %c.ftpcb.l = $strip($remove($cb,$cr,$lf))
  if (ftp://* iswm %c.ftpcb.l) || (ftp.* iswm %c.ftpcb.l) {
    if ($_getsetup(ftp,lastmonitor) == %c.ftpcb.l) { return }
    _setsetup ftp lastmonitor %c.ftpcb.l
    .timer 1 2 _setsetup ftp lastmonitor
    ftp %c.ftpcb.l
  }
}
alias ftpconf { _dialog -m conftp _simplelist }
alias _ftp.revisa {
  if ($_getsetup(ftp,ver) == $null) {
    _setsetup ftp ver $_ftp.aircver
    ._list.flush ftpaccounts
    _list.add ftpaccounts DALnet FTPftp.dal.net000021
    _list.add ftpaccounts C++ Users Journalftp.mfi.com000/pub/cuj21
    _list.add ftpaccounts C and C++ tutorialsftp.swcp.com000/pub/users/dodrill/21
    _list.add ftpaccounts Linux Journalftp.ssc.com000/pub/lj21
    _list.add ftpaccounts Linux Onlineftp.linux.org000/pub21
    _list.add ftpaccounts Red Hat Linuxftp.redhat.com000021
    _list.add ftpaccounts Computer Emergency Response Team [CERT]ftp.cert.org000/pub21
    _list.add ftpaccounts World Wibe Web Consortiumftp.w3.org000021
    _list.add ftpaccounts National Center for Supercomputing Applications [NCSA]ftp.ncsa.uiuc.edu000021
    _list.add ftpaccounts Sun Microsystemsftp.sun.com000021
    _list.add ftpaccounts SCOftp.sco.com000021
    _list.add ftpaccounts Appleftp.apple.com000021
    _list.add ftpaccounts Netscapeftp.netscape.com000021
    _list.add ftpaccounts Microsoftftp.microsoft.com000021
  }
}
alias _ftp.unload {
  if ($dialog(conftp)) || ($dialog(cuentaftp)) {
    error.a Please close the Account Dialog before you unload the FTP Client
    return 1
  }
  var %i = 1,%d
  while ($dialog(%i) != $null) {
    %d = $ifmatch
    if (ftp* iswm %d) || (tftp* iswm %d) {
      error.a Please close all FTP Dialogs before you unload the FTP Client
      return 1
    }
    inc %i
  }
  .timerFTP* off
  sockclose ftp*
  sockclose ?ftp*
}
alias _ftp.mni {
  var %l = $_recent.get(ftp,$1)
  if (%l) {
    if ($gettok(%l,2,63) == anonymous) { return ftp:// $+ $gettok(%l,1,63) }
    if ($_decrypt($gettok(%l,3,63)) == $null) { return ftp:// $+ $gettok(%l,2,63) $+ @ $+ $gettok(%l,1,63) }
    return ftp:// $+ $gettok(%l,2,63) $+ : $+ $str(*,$numtok($gettok(%l,3,63),32)) $+ @ $+ $gettok(%l,1,63)
  }
}
alias _ftp.mn {
  var %l = $_recent.get(ftp,$1)
  ftp $gettok(%l,2,63) $+ : $+ $_decrypt($gettok(%l,3,63)) $+ @ $+ $gettok(%l,1,63)
}
alias -l _ftp.preswcheck {
  if ($sock($1).status != active) { _ftp.addlog.error $1 This FTP session is closed }
  elseif ($sock(G [ $+ [ $1 ] ] )) { _ftp.addlog.error $1 Downloading dirinfo... please wait }
  elseif ($sock(D [ $+ [ $1 ] ] )) { _ftp.addlog.error $1 Downloading file... please wait }
  elseif ($sock(U [ $+ [ $1 ] ] )) { _ftp.addlog.error $1 Uploading file... please wait }
  else { return 0 }
  return 1
}
alias _ftp.sw {
  if ($_ftp.preswcheck($1)) { return }
  else {
    sockwrite -n $1 $2-
    if ($2 == pass) { _ftp.addlog.command $1 $2 $str(*,$len($3-)) }
    else { _ftp.addlog.command $1 $2- }
  }
}
alias _ftp.metepass {
  var %p = $_parameterpass($null,1,FTP Client [/ftp],1,$null,Password for account [ $2 ] on server [ $3 ] <CRLF>[This password will not be saved])
  if ($dialog($1) == $null) { return }
  sockwrite -n $1 PASS %p
  _ftp.addlog.info $1 Sending Password..
  _ftp.addlog.command $1 PASS $str(*,$len(%p))
}
alias _ftp.num {
  if ($sockname) { return $remove($sockname,FTP,t,l,g,u,d,a,b,m) }
  if (FTP* iswm $1) { return $remove($1,FTP) }
  if ($dname != $null) { return $remove($dname,FTP,t) }
}
alias _ftp.nums { return FTP $+ $_ftp.num($1) }
alias _ftp.sr {
  _ftp.addlog.reply $sockname $1-
  if ($1 == 150) {
    var %lftpsock = $did($sockname,2994,5)
    if (%lftpsock) {
      if ($round($gettok($gettok($2-,-1,40),1,41),0) > 0) { sockmark %lftpsock $puttok($sock(%lftpsock).mark,$round($gettok($gettok($2-,-1,40),1,41),0),4,9) }
      did -o $sockname 2994 5 $null
    }
  }
  elseif ($1 == 200) {
    if (($2-4 == type set to) && ($remove($5,.) != i)) || (($2-3 == type is) && ((image !isin $4-) && (binary !isin $4-))) {
      _ftp.sw $sockname TYPE I
      _ftp.addlog.info $sockname You must not change the transfer mode, changing back to binary...
    }
    elseif ($2 == port) {
      if ($did($sockname,2994,6) != $null) { _ftp.sw $sockname $ifmatch }
      did -o $sockname 2994 6 $null
    }
  }
  elseif ($1 == 213) {
    var %lftpsock = $did($sockname,2994,5),%win = $replace(%lftpsock,l,t),%send
    if ($did($sockname,2994,8) != $null) {
      %send = $ifmatch
      did -o $sockname 2994 8 $null
      if ($did($sockname,2994,11)) && ($_sockmark(%lftpsock,7) == DFTP) && ($isfile($_sockmark(%lftpsock,1))) {
        if ($file($_sockmark(%lftpsock,1)).size < $2) {
          _ftp.sw $sockname REST $ifmatch
          sockmark %lftpsock $puttok($sock(%lftpsock).mark,$calc($2 - $file($_sockmark(%lftpsock,1)).size),4,9)
          did -o %win 1003 1 0 of $bytes($calc($2 - $file($_sockmark(%lftpsock,1)).size),b) bytes
        }
        else {
          did -o $sockname 2994 6 $null
          did -o $sockname 2994 8 $null
          _ftp.addlog.error $sockname You already have that file
          did -o %win 1004 1 You already have this file!
          var %send
          _ftp.sockflush $sockname
          _ftp.sigue $sockname 0
        }
      }
      else {
        sockmark %lftpsock $puttok($sock(%lftpsock).mark,$2,4,9)
        did -o %win 1003 1 0 of $bytes($2,b) bytes
      }
      did -a %win 1002 0 0 100
      ; TFTP
    }
    if (%send != $null) { _ftp.sw $sockname $ifmatch }
  }
  elseif ($1 == 220) {
    if ($did($sockname,2994,9)) {
      _ftp.addlog.info $sockname Logging as anonymous...
      _ftp.sw $sockname USER anonymous
    }
    else {
      _ftp.addlog.info $sockname Logging...
      _ftp.sw $sockname USER $did($sockname,2994,2)
    }
  }
  elseif ($1 == 226) {
    _ftp.sockflush $sockname
    _ftp.sigue $sockname 0
  }
  elseif ($1 == 227) {
    var %wc,%tok,%ip,%port
    %wc = *,*,*,*,*,*
    %tok = $replace($remove($wildtok($1-,%wc,$wildtok($1-,%wc,0,32),32),:,[,],$chr(40),$chr(41),.),$chr(44),.)
    %ip = $gettok(%tok,1-4,46)
    %port = 0.0. $+ $gettok(%tok,5-,46)
    %port = $longip(%port)
    ;;;
    _ftp.addlog.info $sockname DEBUG: %ip %port
  }
  elseif ($1 == 230) {
    ;    if (log isin $2-) {
    _ftp.sw $sockname TYPE I
    if ($did($sockname,2994,4) != $null) {
      var %path = $ifmatch
      if ($numtok($gettok(%path,-1,47),46) > 1 ) {
        did -a $sockname 2250 _ftp.com $sockname GET %path
        %path = $remove(%path,$gettok(%path,-1,47))
      }
      did -o $sockname 2994 4 $null
      did -a $sockname 2250 _ftp.com $sockname CWD %path
    }
    _ftp.sw $sockname REST 69
    ;    }
  }
  elseif ($1 == 250) { _ftp.sigue $sockname 0 }
  elseif ($1 == 257) {
    if (created !isin $gettok($1-,3-,34)) {
      var %dir = $gettok($1-,2,34)
      if (*/ !iswm %dir) { %dir = %dir $+ / }
      _dialog.add1 $sockname 1020 %dir
      did -o $sockname 1024 1 %dir
      if ($did($sockname,2994,17)) { _ftp.com $sockname DIR }
      did -o $sockname 2994 17 0
    }
  }
  elseif ($1 == 331) {
    if ($did($sockname,2994,9)) {
      _ftp.addlog.info $sockname Sending Password...
      _ftp.sw $sockname PASS aIRC@ $+ $ip
    }
    elseif ($did($sockname,2994,3) != $null) {
      _ftp.addlog.info $sockname Sending Password...
      _ftp.sw $sockname PASS $did($sockname,2994,3)
    }
    else { _ftp.metepass $sockname $did($sockname,2994,2) $did($sockname,2994,1) }
  }
  elseif ($1 == 350) {
    if (destination isin $2-) || (rename isin $2-) {
      if ($did($sockname,2994,10) != $null) { _ftp.sw $sockname RNTO $ifmatch }
      did -o $sockname 2994 10 $null
    }
    elseif ($did($sockname,2994,13)) {
      _ftp.addlog.info $sockname This server can resume broken downloads
      did -o $sockname 2994 11 1
      did -o $sockname 2994 13 0
      _ftp.sw $sockname REST 0
      _ftp.sigue $sockname 0
    }
  }
  elseif ($1 == 426) {
    _ftp.sockflush $sockname
    _ftp.sigue $sockname 0
  }
  elseif ($istok(425 450 501 550 553,$1,32)) || (($1 == 500) && ($3 == port)) { _ftp.sigue $sockname 0 }
  elseif ($1 == 504) {
    _ftp.addlog.info $sockname This server CANNOT resume broken downloads...
    did -o $sockname 2994 13 0
    _ftp.sigue $sockname 0
  }
  elseif ($1 == 500) && ($remove($2,',",:) == size) {
    if ($did($sockname,2994,8) != $null) {
      var %lftpsock = $did($sockname,2994,5)
      _ftp.sw $sockname $ifmatch
      sockmark %lftpsock $puttok($sock(%lftpsock).mark,0,4,9)
      did -o $replace(%lftpsock,l,t) 1003 1 0 bytes
      ; TFTP
    }
    did -o $sockname 2994 8 $null
  }
}
alias _ftp.com {
  if ($_ftp.preswcheck($1)) { return }
  elseif ($2 == cd) { _ftp.sw $1 CWD $3- }
  elseif (cd..* iswm $2-) || (cd/* iswm $2-) || (cd\* iswm $2-) { _ftp.sw $1 CWD $right($2-,-2) }
  elseif ($2 == rd) { _ftp.sw $1 RMD $3- }
  elseif ($2 == md) { _ftp.sw $1 MKD $3- }
  elseif ($2 == del) { _ftp.sw $1 DELE $3- }
  ;;; This is from the days when this addon worked in a custom window!!!   elseif ($2 == cls) { clear }
  elseif ($2 == ren) || ($2 == rename) {
    var %esdir = %c.ftpren.esdir
    unset %c.ftpren.esdir
    did -o $1 2994 10 $_parameter($null,1,FTP Client [/ftp],normal,$3-,New name for remote [ $iif(%esdir,dir,file) ] :<CRLF> [ $3- ] <CRLF>To move it write a dir)
    _ftp.sw $1 RNFR $3-
  }
  elseif ($2 == dir) || ($2 == ls) || ($2 == list) {
    var %afterport
    if ($3- != $null) { %afterport = LIST $3- }
    elseif ($did($1,1024,2) != $null) { %afterport = LIST $ifmatch }
    else { %afterport = LIST }
    did -o $1 2994 6 %afterport
    if (1) {
      var %sock = L $+ $1,%p
      _ftp.sockflush $1
      socklisten %sock
      sockmark %sock $ticks
      %p = $ip $+ . $+ $gettok($longip($sock(%sock).port),3-4,46)
      %p = $replace(%p,.,$chr(44))
      _ftp.sw $1 PORT %p
    }
    else { _ftp.sw $1 PASV }
  }
  elseif ($2 == get) || ($2 == retr) { var %local = $did($1,1014,1) $+ $gettok($3-,-1,47),%tmp = $_ftp.downloadfile($1,$3-,%local,$null) }
  elseif ($2 == upl) || ($2 == stor) { var %remote = $did($1,1024,1) $+ $gettok($3-,-1,$asc(\)),%tmp = $_ftp.uploadfile($1,$3-,%remote,$null) }
  else { _ftp.sw $1 $upper($2) $3- }
  if ($istok(cwd cdup cd rd md del ren rename,$2,32)) || (cd..* iswm $2-) || (cd/* iswm $2-) || (cd\* iswm $2-) { did -o $1 2994 15 1 }
}
alias _ftp.sigue {
  var %t,%d = $1,%l = $2,%closetransfer = 0,%wc = ? $+ %d
  if ($dialog(%d) == $null) || ($sock(%wc,0)) { return }
  sockclose %wc
  if ($did(%d,2250,1) != $null) {
    %t = $ifmatch
    if ($gettok(%t,3,32) != get) && ($gettok(%t,3,32) != upl) { %closetransfer = 1 }
    did -d %d 2250 1
    %t
  }
  elseif ($did(%d,2994,18)) && ($did(%d,1030,2) != $null) {
    var %line = $ifmatch,%icon = $gettok(%line,2,32),%from = $gettok($gettok(%line,1,9),3-,32),%target = $gettok($gettok(%line,2,9),2-,32),%size = $gettok($gettok(%line,3,9),2,32),%tmp
    ; uploads
    if (%icon == 1) { %tmp = $_ftp.uploadfile(%d,%from,%target,%size) }
    ; downloads
    else { %tmp = $_ftp.downloadfile(%d,%from,%target,%size) }
    did -o %d 2994 17 1
    did -d %d 1030 2
  }
  else {
    %closetransfer = 1
    if ($did(%d,2994,15)) || ($did(%d,2994,16) != $did(%d,1024,1)) || ($did(%d,2994,16) == $null) {
      did -o %d 2994 17 1
      _ftp.com %d PWD
    }
    did -o %d 2994 15 0
    did -o %d 2994 18 0
  }
  if (%closetransfer) && ($dialog(T [ $+ [ %d ] ] )) { .timer $+ $ifmatch -o 1 1 _dialog-x $ifmatch }
}
alias -l _ftp.uploadfile {
  var %d = $1,%local = $2,%remote = $3,%size = $4,%win,%sock,%fport
  if (%local == $null) { %local = $dir="Choose File:" }
  if ($isfile(%local) == $false) { _ftp.status.error %d File not found: ' $+ %local $+ ' }
  else {
    did -o %d 2994 15 1
    %size = $file(%local).size
    %win = T $+ %d
    %sock = L $+ %d
    sockclose %sock
    socklisten %sock
    sockmark %sock %local $+ $chr(9) $+ %win $+ $chr(9) $+ $ticks $+ $chr(9) $+ %size $+ $chr(9) $+ %sock $+ $chr(9) $+ 0 $+ $chr(9) $+ UFTP
    %fport = $ip $+ . $+ $gettok($longip($sock(%sock).port),3-4,46)
    %fport = $replace(%fport,.,$chr(44))
    _ftp.sw %d PORT %fport
    did -o %d 2994 6 STOR $gettok(%local,-1,92)
    .timer $+ %win off
    if ($dialog(%win) == $null) {
      dialog -v %d
      dialog -am %win _ftp.transfer
    }
    _ftp.actransf %win 0 %local
  }
}
alias -l _ftp.downloadfile {
  var %d = $1,%remote = $2,%local = $3,%size = $4,%a,%w,%p,%200,%port
  %a = $gettok(%local,-1,47)
  %w = T $+ %d
  %p = L $+ %d
  sockclose %p
  socklisten %p
  sockmark %p %local $+ $chr(9) $+ %w $+ $chr(9) $+ $ticks $+ $chr(9) $+ 0 $+ $chr(9) $+ 1 $+ $chr(9) $+ 0 $+ $chr(9) $+ DFTP
  did -o %d 2994 5 %p
  %p = $ip $+ . $+ $gettok($longip($sock(%p).port),3-4,46)
  %p = $replace(%p,.,$chr(44))
  %200 = RETR %remote
  %port = PORT %p
  _ftp.sw %d SIZE %remote
  did -o %d 2994 8 %port
  did -o %d 2994 6 %200
  .timer $+ %w off
  if ($dialog(%w) == $null) {
    dialog -v %d
    dialog -am %w _ftp.transfer
  }
  _ftp.actransf %w 1 %a
}
alias _ftp.actransf {
  did -r $1 1001,1003,1004
  did -a $1 1002 0 0 100
  did -o $1 1004 1 Waiting connection...
  dialog -t $1 FTP $+ $remove($1,TFTP) - $iif($2,Download,Upload)
  did -o $1 1001 1 $nopath($3-)
}
alias _ftp.upl {
  var %sock = $1,%d
  tokenize 9 $sock(%sock).mark
  var %cps = $calc($6 / (($ticks - $3) / 1000)),%lcps = $_sckbpsw(%cps)
  if ($6 >= $4) {
    %d = $_ftp.nums
    did -o $2 1003 1 $bytes($6,b) of $bytes($4,b) bytes - %lcps
    did -a $2 1002 100 0 100
    did -o $2 1004 1 Completed in $_duratio($calc(($ticks - $3) / 1000),2)
    _ftp.addlog.info %d Transfered $6 bytes in $_duratio($calc(($ticks - $3) / 1000),2) ( $+ %lcps $+ )
    _ftp.transferlocallyforcedthisisabadidea %d
  }
  else {
    var %tmp = 4096
    elseif (%tmp < 512) { %tmp = 512 }
    bread " $+ $1 $+ " $6 %tmp &ftp.upl
    sockwrite %sock &ftp.upl
    sockmark %sock $puttok($sock(%sock).mark,$calc($6 + $bvar(&ftp.upl,0)),6,9)
    did -o $2 1003 1 $bytes($6,b) of $bytes($4,b) bytes - %lcps
    did -a $2 1002 $6 0 $4
    did -o $2 1004 1 Remaining: $_duratio($calc(($4 - $6) / ($6 / (($ticks - $3) / 1000))),2)
  }
}
alias _ftp.preguntacuenta {
  _dialog -ma cuentaftp cuentaftp
  _ftp.cuentainit $gettok($2-,2-,32)
}
alias _ftp.cuenta.revisaedit {
  if ($_text($did(cuentaftp,10)) == $null) || ($chr(176) isin $did(cuentaftp,10)) || ($_ishost($did(cuentaftp,20)) == $null) { goto no }
  if ($_text($did(cuentaftp,30)) != $null) && (: isin $did(cuentaftp,30)) { goto no }
  if ($_text($did(cuentaftp,40)) != $null) && (: isin $did(cuentaftp,40)) { goto no }
  if ($_text($did(cuentaftp,40)) != $null) && ($_text($did(cuentaftp,30)) == $null) { goto no }
  if ($did(cuentaftp,70) != $null) && ($did(cuentaftp,70) !isnum) { goto no }
  if ($_text($did(cuentaftp,50)) != $null) && ($isdir($did(cuentaftp,50)) == $false) { goto no }
  did -e cuentaftp 150
  did -e cuentaftp 151
  return
  :no
  did -b cuentaftp 150
  did -b cuentaftp 151
}
alias _ftp.cuentainit {
  var %i = 1,%c
  did -o cuentaftp 70 1 21
  did -r cuentaftp 10,20,30,40,50,60
  if ($1- != $null) {
    while ($_list.get(ftpaccounts,%i)) {
      %c = $ifmatch
      if ($gettok(%c,1,176) == $1-) {
        did -o cuentaftp 10 1 $1-
        if ($gettok(%c,2,176)) { did -o cuentaftp 20 1 $ifmatch }
        if ($gettok(%c,3,176)) { did -o cuentaftp 30 1 $ifmatch }
        if ($gettok(%c,4,176)) { did -o cuentaftp 40 1 $_decrypt($ifmatch) }
        if ($gettok(%c,5,176)) { did -o cuentaftp 50 1 $ifmatch }
        if ($gettok(%c,6,176)) { did -o cuentaftp 60 1 $ifmatch }
        if ($gettok(%c,7,176)) { did -o cuentaftp 70 1 $ifmatch }
        did -m cuentaftp 10
        break
      }
      inc %i
    }
  }
  else { did -n cuentaftp 10 }
  _ftp.cuenta.revisaedit cuentaftp
}
alias _ftp.cuenta.conecta {
  var %lp
  tokenize 176 $_list.get(ftpaccounts,$round($1,0))
  if ($5) { %c.ftp.dl = $ifmatch }
  if ($3) {
    %lp = $ifmatch
    if ($4) && ($_decrypt($4)) { %lp = %lp $+ : $+ $ifmatch }
    %lp = %lp $+ @
  }
  if ($dialog(conftp)) && ($_getsetup(ftp,closelist)) { dialog -x conftp }
  if ($6) { ftp %lp $+ $2 $+ : $+ $7 $+ $6 }
  else { ftp %lp $+ $2 $+ : $+ $7 }
}
alias _ftp.cuenta.graba {
  var %dr,%tempo = $_list.tokadd(ftpaccounts,1,176,$did(10))
  if ($did(60) != $null) {
    if (/* iswm $did(60)) { %dr = $did(60) }
    else { %dr = / $+ $did(60) }
  }
  else { %dr = 0 }
  write -l $+ %tempo " $+ $_list.file(ftpaccounts) $+ " $_text($did(10)) $+  $+ $iif($did(20),$did(20),0) $+  $+ $iif($did(30),$did(30),0) $+  $+ $iif($did(40),$_crypt($did(40)),0) $+  $+ $iif($did(50),$did(50),0) $+  $+ %dr $+  $+ $iif($did(70),$did(70),0)
  _list.hash ftpaccounts
  _dialog.loadlist conftp 2 1 176 ftpaccounts 1 1
}
dialog _ftp.transfer {
  size -1 -1 125 42
  option type dbu

  text "",1001,2 2 120 8,center
  text "",1002,2 12 120 8,center
  text "",1003,2 22 120 8,center
  text "",1004,2 32 120 8,center

  button "&Cancel",1008,48 45 30 15,cancel
}
ON *:DIALOG:TFTP*:init:0:{
  _mdx.init $_icofile(ftp.ico,$scriptdir)
  _mdx.SetControlMDX ctl_gen.mdx $dname 1002 ProgressBar smooth
  _mdx.SetFont $dname 1001,1002,1003,1004 + 13 400 Tahoma
  did -v $dname 1001
}
ON *:DIALOG:TFTP*:sclick:1008:{
  var %d = $replace($dname,TFTP,FTP)
  sockclose ? $+ %d
  _ftp.com %d ABOR
  did -o %d 2994 18 0
}
ON *:DIALOG:conftp:*:*:{
  var %sclick
  if ($devent == dclick) && ($did == 2) && ($did($dname,2,1).sel != $null) { _ftp.cuenta.conecta $did($dname,2,$did($dname,2,1).sel).text }
  elseif ($devent == sclick) {
    var %sclick = $did($dname,2,1).sel
    if ($did == 101) { _ftp.preguntacuenta }
    elseif ($did == 102) && (%sclick != $null) {
      _list.tokdel ftpaccounts 1 176 $gettok($did($dname,2,%sclick).text,2-,32)
      _dialog.loadlist conftp 2 1 176 ftpaccounts 1 1
      if ($did(2,%sclick) != $null) { did -c $dname 2 %sclick }
    }
    elseif ($did == 103) {
      if (%sclick != $null) { _ftp.preguntacuenta %sclick $did($dname,2,%sclick).text }
    }
    elseif ($did == 104) && (%sclick != $null) && (%sclick > 1) {
      _list.moveup ftpaccounts %sclick
      _dialog.loadlist conftp 2 1 176 ftpaccounts 1 1
      did -c $dname 2 $calc(%sclick - 1)
    }
    elseif ($did == 105) && (%sclick != $null) && (%sclick < $did($dname,2,1).lines) {
      _list.movedown ftpaccounts %sclick
      _dialog.loadlist conftp 2 1 176 ftpaccounts 1 1
      did -c $dname 2 $calc(%sclick + 1)
    }
    elseif ($did == 106) {
      if (%sclick != $null) { _ftp.cuenta.conecta $did($dname,2,%sclick).text }
    }
    elseif ($did == 201) || ($did == 202) { showmirc -s }
    elseif ($did == 220) { _setsetup ftp closelist $did(220).state }
  }
  elseif ($devent == init) {
    _mdx.init $_icofile(ftp.ico,$scriptdir)
    _dialog.loadlist conftp 2 1 176 ftpaccounts 1 1
    did -h $dname 201
    did -o $dname 202 1 Close
    dialog -t $dname FTP Accounts
    did -h $dname 1
    did -v $dname 2
    did -o $dname 101 1 &New...
    did -ov $dname 103 1 &Edit...
    did -ov $dname 104 1 &Up
    did -ov $dname 105 1 &Down
    did -ov $dname 106 1 &Connect
    did -f $dname 201
    did -ov $dname 220 1 Close this list when Connecting
    if ($_getsetup(ftp,closelist)) { did -c $dname 220 }
  }
}
dialog cuentaftp {
  size 1 1 250 77
  option type dbu

  text "&Account Name:",11,2 5 100 8
  edit "",10,2 12 100 11,autohs
  text "&Server:",21,2 25 100 8
  edit "",20,2 32 100 11,autohs
  text "&Login:",31,2 50 48 8
  edit "",30,2 58 48 11,autohs
  text "&Password:",41,52 50 48 8
  edit "",40,52 58 48 11,pass autohs
  text "&Initial Local Directory:",51,105 5 100 8
  edit "",50,105 12 100 11,autohs
  button "...",52,208 12 13 11
  text "Initial &Remote Directory:",61,105 25 100 8
  edit "",60,105 32 100 11,autohs
  text "Por&t:",71,225 5 20 8
  edit "",70,225 12 20 11,autohs
  button "&Connect",150,142 60 30 15
  button "&OK",151,178 60 30 15,ok
  button "&Cancel",152,212 60 30 15,cancel
}
alias _ftp.cuenta.dirlocal {
  var %d = $sdir="Initial Local Directory:" $iif($2- != $null,$2-,$getdir)
  if ($dialog($1) == $null) { return }
  elseif (%d != $null) && (%d != $2-) { did -o $1 50 1 %d }
  dialog -v $1
}
ON *:DIALOG:cuentaftp:init:0:{
  _mdx.init $_icofile(ftp.ico,$scriptdir)
  dialog -t cuentaftp FTP Account
}
ON *:DIALOG:cuentaftp:sclick:52:{ _ftp.cuenta.dirlocal $dname $did(50,1) }
ON *:DIALOG:cuentaftp:sclick:150:{
  _ftp.cuenta.graba
  var %i = 1,%c
  while ($_list.get(ftpaccounts,%i)) {
    %c = $ifmatch
    if ($gettok(%c,1,176) == $did(10)) {
      dialog -x $dname
      _ftp.cuenta.conecta %i
      return
    }
    inc %i
  }
}
ON *:DIALOG:cuentaftp:sclick:151:{
  if ($did(150).enabled) { _ftp.cuenta.graba }
  else { halt }
}
ON *:DIALOG:cuentaftp:edit:*:{ _ftp.cuenta.revisaedit $dname }
ON *:SOCKOPEN:FTP*:{
  if ($sockerr) {
    _ftp.addlog.error $sockname FTP session $did($sockname,2994,1) $+ : $_sockerr
    return
  }
  if ($dialog($sockname) == $null) { dialog -m FTP $+ $_ftp.num ftp }
  did -o $sockname 1000 2 +a 2 Disconnect $+ $chr(9) $+ Disconnects from the FTP Server
  _ftp.setitle $sockname $iif($did($sockname,2994,9),anonymous,$did($sockname,2994,2)) in $did($sockname,2994,1)
  _ftp.addlog.info $sockname Connection established $did($sockname,2994,1) port $sock($sockname).port
  _ftp.antiidle $sockname 0
}
alias _ftp.antiidle {
  if ($sock($1).status == active) {
    if ($2) {
      sockwrite -n $1 NOOP
      _ftp.addlog.command $1 NOOP
    }
    .timer $+ $1 $+ _ANTIIDLE -o 1 180 _ftp.antiidle $1 1
  }
}
ON *:SOCKWRITE:FTP*:{
  if ($sockerr) { _ftp.addlog.error $sockname FTP session $did($sockname,2994,1) $+ : $_sockerr }
}
ON *:SOCKREAD:FTP*:{
  if ($sockerr) {
    _ftp.addlog.error $sockname FTP session $did($sockname,2994,1) $+ : $_sockerr
    return
  }
  var %sr
  sockread %sr
  while ($sockbr) {
    if (%sr != $null) { _ftp.sr %sr }
    if ($sockname == $null) { break }
    sockread %sr
  }
}
ON *:SOCKCLOSE:FTP*:{ _ftp.disconnect $sockname }
ON *:SOCKLISTEN:LFTP*:{
  if ($_sockmark(2)) {
    did -o $_sockmark(2) 1004 1 Connected! Beginning transmission...
    if ($_sockmark(7) == DFTP) {
      if ($_sockmark(5)) && ($isfile($_sockmark(1))) {
        .remove " $+ $_sockmark(1) $+ "
        sockmark $sockname $puttok($sock($sockname).mark,0,5,9)
      }
      sockaccept $replace($sockname,LFTP,DFTP)
      sockmark $replace($sockname,LFTP,DFTP) $puttok($sock($sockname).mark,$ticks,3,9)
    }
    elseif ($_sockmark(7) == UFTP) {
      sockaccept $replace($sockname,LFTP,UFTP)
      sockmark $replace($sockname,LFTP,UFTP) $puttok($sock($sockname).mark,$ticks,3,9)
      _ftp.upl $replace($sockname,LFTP,UFTP)
    }
  }
  else {
    var %d = $_ftp.nums
    did -r %d 1021,1025,1026,2251
    did -o %d 1024 3 0
    did -o %d 1024 5 0
    did -i %d 1022 2 +p 0 Gathering dir info... 0 bytes
    did -o %d 2994 16 $did(%d,1024,1)
    sockaccept $replace($sockname,LFTP,GFTP)
    sockmark $replace($sockname,LFTP,GFTP) $ticks
  }
  sockclose $sockname
}
ON *:SOCKWRITE:GFTP*:{
  if ($sockerr) {
    error.a FTP Dir connection: $_sockerr
    _ftp._refremote.ref $_ftp.nums
  }
}
ON *:SOCKREAD:GFTP*:{
  if ($sockerr) {
    error.a FTP Dir connection: $_sockerr
    _ftp._refremote.ref $_ftp.nums
    return
  }
  var %sr,%d = $remove($sockname,G)
  sockread %sr
  while ($sockbr) {
    if (%sr != $null) { _ftp.gftp.sr %sr }
    if ($sockname == $null) { break }
    sockread %sr
  }
  if ($sock($sockname).rcvd) { did -i %d 1022 2 +p 0 Gathering dir info... $bytes($ifmatch,b) bytes }
}
ON *:SOCKCLOSE:GFTP*:{
  var %sr = $calc(($ticks - $sock($sockname).mark) / 1000)
  _ftp.addlog.info $_ftp.nums $sock($sockname).rcvd bytes transfered in $_duratio(%sr,2) ( $+ $_sckbpsw($calc($sock($sockname).rcvd / %sr)) $+ )
  _ftp._refremote.ref $_ftp.nums
}
ON *:SOCKWRITE:DFTP*:{
  if ($sockerr) { did -o $_sockmark(2) 1004 1 ERROR - Connection Closed }
}
ON *:SOCKREAD:DFTP*:{
  tokenize 9 $sock($sockname).mark
  if ($sockerr) {
    did -o $2 1004 1 ERROR - Connection Closed
    return
  }
  sockread &t.dftp.sr
  bwrite " $+ $1 $+ " -1 &t.dftp.sr
  var %curr = $sock($sockname).rcvd,%total,%cps = $calc(%curr / (($ticks - $3) / 1000)),%lcps = $_sckbpsw(%cps)
  if ($4) {
    %total = $ifmatch
    if (%curr > %total) { %curr = %total }
    did -o $2 1003 1 $bytes(%curr,b) of $bytes(%total,b) bytes - %lcps
    did -a $2 1002 %curr 0 %total
    did -o $2 1004 1 Remaining: $_duratio($calc((%total - %curr) / (%curr / (($ticks - $3) / 1000))),2)
  }
  else { did -o $2 1003 1 %curr bytes - %lcps }
}
ON *:SOCKCLOSE:DFTP*:{
  tokenize 9 $sock($sockname).mark
  var %d = $_ftp.nums,%tmp
  if ($sock($sockname).rcvd >= $4) {
    var %total,%cps = $calc($sock($sockname).rcvd / (($ticks - $3) / 1000)),%lcps = $_sckbpsw(%cps)
    _ftp.reflocal %d $did(%d,1014,1)
    if ($4) { %total = $ifmatch }
    else { %total = $sock($sockname).rcvd }
    did -a $2 1002 100 0 100
    did -o $2 1003 1 $bytes($sock($sockname).rcvd,b) of $bytes(%total,b) bytes - %lcps
    did -o $2 1004 1 Completed in: $_duratio($calc(($ticks - $3) / 1000),2)
    _recent.add files 10 $_fixfilename($1)
    _ftp.addlog.info %d $sock($sockname).rcvd bytes transfered in $_duratio($calc(($ticks - $3) / 1000),2) ( $+ %lcps $+ )
  }
  else {
    did -o $2 1004 1 ERROR - Connection closed
    _ftp.addlog.error %d Transfer incomplete: ' $+ $nopath($1) $+ '
  }
  _ftp.transferlocallyforcedthisisabadidea %d
}
ON *:SOCKWRITE:UFTP*:{
  if ($sockerr) {
    did -o $_sockmark(2) 1004 1 ERROR - Connection closed
    _ftp.transferlocallyforcedthisisabadidea $_ftp.nums
    return
  }
  _ftp.upl $sockname
}
ON *:SOCKCLOSE:UFTP*:{
  did -o $_sockmark(2) 1004 1 ERROR - Connection closed
  _ftp.transferlocallyforcedthisisabadidea $_ftp.nums
}
alias _ftp.addlog.text {
  if ($did($1,1040).lines >= 600) { did -d $1 1040 1 }
  did -a $1 1040 $2- $+ $crlf
}
alias _ftp.addlog.command { _ftp.addlog.text $1 Cmd>	 $+  $2- }
alias _ftp.addlog.reply { _ftp.addlog.text $1 	 $+ $2- }
alias _ftp.addlog.info { _ftp.addlog.text $1 Status>	 $+  $2- }
alias _ftp.addlog.error { _ftp.addlog.text $1 ERROR>	 $+ $2- }

alias _ftp.status.info { did -i $1 2992 2 +p 0 $2- }
alias _ftp.status.error { did -i $1 2992 2 +p 0 $2- }
alias _ftp.sockflush { sockclose ? $+ $_ftp.nums($1) }
alias _ftp.transferlocallyforcedthisisabadidea {
  _ftp.sockflush $1
  return
  _ftp.sigue $1 1
}

;/*******************************************************************************************
; *
; * aIRC
; * FTP Client file 2
; *
; *******************************************************************************************/
;

dialog _ftpclient {
  size -1 -1 %~ftpw %~ftph
  title "taboFTP Client"
  option type dbu

  list 1000,1 1 319 12,size
  ;  box "",1001,159 12 1 178

  combo 1010,1 15 158 200,drop edit
  ; visible list
  list 1011,1 25 158 100,size extsel
  ; statusbar1
  list 1012,1 125 156 8,size
  ; statusbar2
  list 1013,1 133 156 8,size hide
  ; 1=currentdir 2=filter 3=totalbytes 4=sortflags 5=totalfiles
  list 1014,1 133 156 8,size hide
  ; dirs
  list 1015,1 133 156 8,size hide sort
  ; files
  list 1016,1 133 156 8,size hide


  combo 1020,161 15 158 200,drop edit
  list 1021,161 25 158 100,size extsel
  list 1022,162 125 156 8,size
  list 1023,162 133 156 8,size hide
  list 1024,162 133 156 8,size hide
  list 1025,162 133 156 8,size hide sort
  list 1026,162 133 156 8,size hide

  list 1030,1 136 158 57,size
  edit "",1040,161 136 158 57,autohs multi read vsbar hsbar

  ;  menu "FTP",2700
  ;  item "blah",2701

  button "ok",2990,-20 -20 1 1,ok hide
  button "cancel",2991,-20 -20 1 1,cancel hide
  list 2992,1 194 319 12,size
  button "MDX Positioner",2993,10 10 10 10,hide

  ; 1= server
  ; 2= login
  ; 3= password
  ; 4= /dir/file (initial)
  ; 5= LFTP sockname
  ; 6= action after PORT|PASV [LIST...|RETR...|STOR...]
  ; 7= useless
  ; 8= PORT after SIZE
  ; 9= anonymous
  ; 10= new filename
  ; 11= server supports RETR (resuming)
  ; 12= server supports SIZE (get filesize)
  ; 13= logged=0
  ; 14= currlist
  ; 15= refresh dirs after actions...
  ; 16= last listed directory
  ; 17= Waiting PWD reply for LIST
  ; 18= transfering queue
  list 2994,999 999 999 999,hide

  ; oldqueue:
  list 2250,1 136 156 57,size hide
  ; remote directory:
  list 2251,999 999 999 999,hide
}
ON *:DIALOG:ftp*:sclick:2993:{
  if ($istok(size minimize maximize restore,$gettok($did($dname,$did),1,32),32)) {
    .timer $+ $dname $+ _resizedialog -mo 1 50 _ftp.resizedialog $dname
    ;;;    _ftp.resizedialog $dname
  }
}
alias _ftp.resizedialog {
  var %dname = $1
  if ($dialog(%dname) == $null) { return }
  var %dw = $dialog(%dname).cw,%dh = $dialog(%dname).ch,%width = $calc((%dw - 2 * $dbuw ^ 2) / 2),%wwidth = %dw - 1 * $dbuw ^ 2,%row5 = $calc(%dh - 6 * $dbuh ^ 2),%col2 = $calc(2 + %dw / 2),%height2 = %dh / 2,%row3 = $calc(%height2 + 25 * $dbuh),%row4 = $calc(%row3 + 9 * $dbuh),%height4 = %row5 - %row4
  _mdx.MoveControl %dname 1010 * * %width *
  _mdx.MoveControl %dname 1020 %col2 * %width *
  _mdx.MoveControl %dname 1011 * * %width %height2
  _mdx.MoveControl %dname 1021 %col2 * %width %height2
  _mdx.MoveControl %dname 1012 * %row3 %width *
  _mdx.MoveControl %dname 1022 %col2 %row3 %width *
  _mdx.MoveControl %dname 1030 * %row4 %width %height4
  _mdx.MoveControl %dname 2250 * %row4 %width %height4
  _mdx.MoveControl %dname 1040 %col2 %row4 %width %height4
  _mdx.MoveControl %dname 1000 * * %wwidth *
  _mdx.MoveControl %dname 2992 * %row5 %wwidth *
}
ON *:DIALOG:ftp*:init:0:{
  _mdx.init $_icofile(ftp.ico,$scriptdir) title border sysmenu minbox
  _mdx.SetControlMDX dialog.mdx $dname 2993 positioner maxbox minbox size
  _mdx.SetControlMDX bars.mdx $dname 2992 StatusBar
  _mdx.SetControlMDX bars.mdx $dname 1012 StatusBar
  _mdx.SetControlMDX bars.mdx $dname 1022 StatusBar
  _mdx.SetBorderStyle $dname 1012
  _mdx.SetBorderStyle $dname 1022
  _mdx.SetControlMDX bars.mdx $dname 1000 ToolBar arrows flat wrap noresize list
  _mdx.SetBorderStyle $dname 1000
  _mdx.SetBorderStyle $dname 1010
  _mdx.SetBorderStyle $dname 1020
  _mdx.SetBorderStyle $dname 1011 border
  _mdx.SetBorderStyle $dname 1021 border
  _mdx.SetBorderStyle $dname 1030 border
  _mdx.SetBorderStyle $dname 1040 border

  did -o $dname 1014,1024 1 $null
  did -o $dname 1014,1024 2 $null
  did -o $dname 1014,1024 3 0
  did -o $dname 1014,1024 4 te
  did -o $dname 1014,1024 5 0

  var %9+0 = $chr(9) $+ +l 0,%9r0 = $chr(9) $+ +r 0
  _mdx.SetControlMDX views.mdx $dname 1011 ListView report rowselect showsel nosortheader autoarrange
  did -i $dname 1011 1 header $_mdx.fixtablengths(80,40) + 0 Name $+ %9r0 Size
  _mdx.SetControlMDX views.mdx $dname 1021 ListView report rowselect showsel nosortheader autoarrange
  did -i $dname 1021 1 header $_mdx.fixtablengths(80,40,54,36,36,36,36) + 0 Name $+ %9r0 Size $+ %9+0 Date $+ %9+0 Attrib $+ %9+0 Owner $+ %9+0 Group $+ %9+0 Comment
  _mdx.SetControlMDX views.mdx $dname 1030 ListView report rowselect showsel nosortheader autoarrange
  did -i $dname 1030 1 header $_mdx.fixtablengths(80,80,36,150) + 0 From $+ %9+0 Target $+ %9r0 Size $+ %9+0 Server

  did -i $dname 1011,1021 1 seticon 0 $_icofile(cdup.ico)
  did -i $dname 1011,1021 1 seticon 0 $_icofile(folder.ico)
  did -i $dname 1011,1021 1 seticon 0 $_icofile(file.ico)
  did -i $dname 1011,1021 1 seticon 0 $_icofile(drivefloppy.ico)
  did -i $dname 1011,1021 1 seticon 0 $_icofile(drivehard.ico)
  did -i $dname 1011,1021 1 seticon 0 $_icofile(drivecd.ico)

  did -i $dname 1000 1 bmpsize 16 16
  did -i $dname 1000 1 setimage 0 icon small 3, $+ $mircexe
  did -i $dname 1000 1 setimage 0 icon small 4, $+ $mircexe
  did -i $dname 1000 1 setimage 0 icon small $_icofile(stop.ico)
  did -i $dname 1000 1 setimage 0 icon small 9, $+ $mircexe
  did -i $dname 1000 1 setimage 0 icon small 7, $+ $mircexe
  did -i $dname 1000 1 setimage 0 icon small 8, $+ $mircexe
  did -i $dname 1000 1 setimage 0 icon small $_icofile(dtwindow_Trffc10a.ico)
  did -i $dname 1000 1 setimage 0 icon small $_icofile(folder.ico)
  did -i $dname 1000 1 setimage 0 icon small $_icofile(rename.ico)
  did -i $dname 1000 1 setimage 0 icon small $_icofile(remove.ico)
  var %atb = did -a $dname 1000
  %atb +a 1 Connect $+ $chr(9) $+ Connect to a FTP Server
  %atb -
  %atb +a 3 Stop $+ $chr(9) $+ Stop Current Operation
  %atb -
  %atb +a 4 Refresh $+ $chr(9) $+ Refresh Folder
  %atb -
  %atb +a 5 Send $+ $chr(9) $+ Add File or Folder to the Send Queue
  %atb +a 6 Receive $+ $chr(9) $+ Add File or Folder to the Get Queue
  %atb +a 7 Start $+ $chr(9) $+ Transfer Files in Queue
  %atb -
  %atb +a 8 New Folder $+ $chr(9) $+ Create New Folder
  %atb +a 9 Rename $+ $chr(9) $+ Rename File or Folder
  %atb +a 10 Delete $+ $chr(9) $+ Delete File or Folder

  did -i $dname 1030 1 seticon 0 7, $+ $mircexe
  did -i $dname 1030 1 seticon 0 8, $+ $mircexe

  _mdx.SetFont $dname 1000,1010,1011,1012,1020,1021,1022,1030,1040 + 13 400 Tahoma
  did -i $dname 1012,1022 1 separts -1
  did -i $dname 1012,1022 2 +p 0 Waiting...
  _ftp.reflocal $dname $getdir
  _ftp.resizedialog $dname
  did -f $dname 1011
}
ON *:DIALOG:ftp*:sclick:2990:{
  var %text1 = $did($dname,1010).text,%text2 = $did($dname,1020).text
  if (%text1 != $null) && (%text1 != $did($dname,1014,1)) { _ftp.reflocal $dname %text1 }
  if (%text2 != $null) && (%text2 != $did($dname,1024,1)) { _ftp.com $dname CWD %text2 }
  halt
}
ON *:DIALOG:ftp*:sclick:1000:{
  var %button = $did($dname,1000).sel,%remote = 0,%lor = local,%com
  if ($istok(4 8 9 10,%button,32)) || ($did($dname,2994,14) == 1021) { var %remote = 1,%lor = remote }
  if (%button != 2) && (%remote) && ($_ftp.remote.disconnected) { return }
  if (%button == 2) {
    if ($gettok($gettok($did($dname,1000,2),1,9),3,32) == connect) {
      var %string
      if ($did($dname,2994,9)) { %string = ftp:// }
      else { %string = ftp:// $+ $did($dname,2994,2) $+ @ $+ $did($dname,2994,3) $+ : }
      %string = %string $+ $did($dname,2994,1) $+ $did($dname,1024,1)
      ftp %string
      _ftp.addlog.info $dname Connecting to $did($dname,2994,1)
    }
    else { _ftp.disconnect $dname }
  }
  elseif (%button == 4) {
    %com = _ftp.com $dname ABOR
    sockclose ? $+ $dname
    _dialog-x T $+ $dname
    did -o $dname 2994 18 0
  }
  elseif (%button == 6) { %com = _ftp. $+ %lor $+ .refresh }
  elseif (%button == 8) { _ftp.local.transfer }
  elseif (%button == 9) { _ftp.remote.transfer }
  elseif (%button == 10) { _ftp.queue.start }
  elseif (%button == 12) { %com = _ftp. $+ %lor $+ .mkdir }
  elseif (%button == 13) { %com = _ftp. $+ %lor $+ .ren }
  elseif (%button == 14) { %com = _ftp. $+ %lor $+ .del }
  if (%com != $null) { %com }
}
ON *:DIALOG:ftp*:sclick:1010:{
  if ($did($dname,1010,$did($dname,1010,1).sel) != $did($dname,1014,1)) { _ftp.reflocal $dname $ifmatch }
}
ON *:DIALOG:ftp*:sclick:1020:{
  if ($did($dname,1020,$did($dname,1020,1).sel) != $did($dname,1024,1)) { _ftp.com $dname CWD $ifmatch }
}
ON *:DIALOG:ftp*:sclick:1011:{
  var %d = $dname,%header = $did(%d,1011,1),%lastevent = $gettok(%header,1,32)
  if ($did(%d,2994,14) != 1011) {
    did -i %d 1012 1 setbkcolor 65535
    did -i %d 1022 1 setbkcolor $rgb(face)
    did -o %d 2994 14 1011
  }
  if (%lastevent == rclick) {
    var %menu1 = FTPLOCALDIR,%menu2 = %menu1 $+ arrangeicons,%menu3 = %menu1 $+ viewmodes,%result,%sflags = $did(%d,1014,4)
    _popupdll.New %menu2 16 16
    _popupdll.AddItem %menu2 end $iif(n isin %sflags,+xr,+) 0 0 by &name $cr _ftp.localsortfiltertoggle %d n
    _popupdll.AddItem %menu2 end $iif(s isin %sflags,+xr,+) 0 0 by &size $cr _ftp.localsortfiltertoggle %d s
    _popupdll.AddItem %menu2 end $iif(t isin %sflags,+xr,+) 0 0 by &type $cr _ftp.localsortfiltertoggle %d t
    _popupdll.AddItem %menu2 end
    _popupdll.AddItem %menu2 end $iif(d !isin %sflags,+xr,+) 0 0 &ascending $cr _ftp.localsortfiltertoggle %d -d
    _popupdll.AddItem %menu2 end $iif(d isin %sflags,+xr,+) 0 0 &descending $cr _ftp.localsortfiltertoggle %d +d

    _popupdll.New %menu3 16 16
    _popupdll.AddItem %menu3 end $iif(b isin %sflags,+xr,+) 0 0 &large icons $cr _ftp.localsortfiltertoggle %d b
    _popupdll.AddItem %menu3 end $iif(i isin %sflags,+xr,+) 0 0 &small icons $cr _ftp.localsortfiltertoggle %d i
    _popupdll.AddItem %menu3 end $iif(l isin %sflags,+xr,+) 0 0 &list $cr _ftp.localsortfiltertoggle %d l
    _popupdll.AddItem %menu3 end $iif(e isin %sflags,+xr,+) 0 0 &details $cr _ftp.localsortfiltertoggle %d e

    _popupdll.New %menu1 8 8
    _popupdll.AddItem %menu1 end +D 0 0 &transfer $cr _ftp.local.transfer
    _popupdll.AddItem %menu1 end + 0 0 &queue $cr _ftp.local.queue
    _popupdll.AddItem %menu1 end
    _popupdll.AddItem %menu1 end + 0 0 de&lete $cr _ftp.local.del
    _popupdll.AddItem %menu1 end + 0 0 re&name $cr _ftp.local.ren
    _popupdll.AddItem %menu1 end +> 0 0 arran&ge $cr %menu2
    _popupdll.AddItem %menu1 end +> 0 0 &view $cr %menu3
    _popupdll.AddItem %menu1 end
    _popupdll.AddItem %menu1 end + 0 0 make &dir $cr _ftp.local.mkdir
    _popupdll.AddItem %menu1 end + 0 0 &change dir $cr _ftp.local.chdir
    _popupdll.AddItem %menu1 end + 0 0 cd&up $cr _ftp.local.cdup
    _popupdll.AddItem %menu1 end
    _popupdll.AddItem %menu1 end + 0 0 &refresh $cr _ftp.local.refresh
    _popupdll.Popup %menu1 + $mouse.dx $mouse.dy
    %result = $result
    if ($gettok(%result,1,32) == OK) && ($gettok(%result,4-,32) != $null) { $ifmatch }
    _popupdll.Destroy %menu1
    _popupdll.Destroy %menu2
  }
  if ($istok(item sclick,%lastevent,32)) { .timer $+ $dname $+ _ $+ $devent $+ $sclick -mo 1 50 _ftp.dirstatus %d 1012 1011 1015 1016 1014 }
}
ON *:DIALOG:ftp*:sclick:1021:{
  var %d = $dname,%header = $did(%d,1021,1),%lastevent = $gettok(%header,1,32)
  if ($did(%d,2994,14) != 1021) {
    did -i %d 1012 1 setbkcolor $rgb(face)
    did -i %d 1022 1 setbkcolor 65535
    did -o %d 2994 14 1021

  }
  if (%lastevent == rclick) {
    var %menu1 = FTPLOCALDIR,%menu2 = %menu1 $+ arrangeicons,%menu3 = %menu1 $+ viewmodes,%result,%sflags = $did(%d,1024,4)
    _popupdll.New %menu2 16 16
    _popupdll.AddItem %menu2 end $iif(n isin %sflags,+xr,+) 0 0 by &name $cr _ftp.remotesortfiltertoggle %d n
    _popupdll.AddItem %menu2 end $iif(s isin %sflags,+xr,+) 0 0 by &size $cr _ftp.remotesortfiltertoggle %d s
    _popupdll.AddItem %menu2 end $iif(t isin %sflags,+xr,+) 0 0 by &type $cr _ftp.remotesortfiltertoggle %d t
    _popupdll.AddItem %menu2 end $iif(m isin %sflags,+xr,+) 0 0 by &date $cr _ftp.remotesortfiltertoggle %d m
    _popupdll.AddItem %menu2 end $iif(a isin %sflags,+xr,+) 0 0 by &attrib $cr _ftp.remotesortfiltertoggle %d a
    _popupdll.AddItem %menu2 end $iif(o isin %sflags,+xr,+) 0 0 by &owner $cr _ftp.remotesortfiltertoggle %d o
    _popupdll.AddItem %menu2 end $iif(g isin %sflags,+xr,+) 0 0 by &group $cr _ftp.remotesortfiltertoggle %d g
    _popupdll.AddItem %menu2 end $iif(c isin %sflags,+xr,+) 0 0 by &comment $cr _ftp.remotesortfiltertoggle %d c
    _popupdll.AddItem %menu2 end
    _popupdll.AddItem %menu2 end $iif(d !isin %sflags,+xr,+) 0 0 &ascending $cr _ftp.remotesortfiltertoggle %d -d
    _popupdll.AddItem %menu2 end $iif(d isin %sflags,+xr,+) 0 0 &descending $cr _ftp.remotesortfiltertoggle %d +d

    _popupdll.New %menu3 16 16
    _popupdll.AddItem %menu3 end $iif(b isin %sflags,+xr,+) 0  0 &large icons $cr _ftp.remotesortfiltertoggle %d b
    _popupdll.AddItem %menu3 end $iif(i isin %sflags,+xr,+) 0 0 &small icons $cr _ftp.remotesortfiltertoggle %d i
    _popupdll.AddItem %menu3 end $iif(l isin %sflags,+xr,+) 0 0 &list $cr _ftp.remotesortfiltertoggle %d l
    _popupdll.AddItem %menu3 end $iif(e isin %sflags,+xr,+) 0 0 &details $cr _ftp.remotesortfiltertoggle %d e

    _popupdll.New %menu1 8 8
    _popupdll.AddItem %menu1 end +D 0 0 &transfer $cr _ftp.remote.transfer
    _popupdll.AddItem %menu1 end + 0 0 &queue $cr _ftp.remote.queue
    _popupdll.AddItem %menu1 end
    _popupdll.AddItem %menu1 end + 0 0 de&lete $cr _ftp.remote.del
    _popupdll.AddItem %menu1 end + 0 0 re&n/move $cr _ftp.remote.ren
    _popupdll.AddItem %menu1 end + 0 0 copy &url $cr _ftp.remote.copyurl
    _popupdll.AddItem %menu1 end +d 0 0 chm&od $cr _ftp.remote.chmod
    _popupdll.AddItem %menu1 end + 0 0 &quote $cr _ftp.remote.quote
    _popupdll.AddItem %menu1 end +> 0 0 arran&ge $cr %menu2
    _popupdll.AddItem %menu1 end +> 0 0 &view $cr %menu3
    _popupdll.AddItem %menu1 end
    _popupdll.AddItem %menu1 end + 0 0 make &dir $cr _ftp.remote.mkdir
    _popupdll.AddItem %menu1 end + 0 0 &change dir $cr _ftp.remote.chdir
    _popupdll.AddItem %menu1 end + 0 0 cd&up $cr _ftp.remote.cdup
    _popupdll.AddItem %menu1 end
    _popupdll.AddItem %menu1 end + 0 0 &refresh $cr _ftp.remote.refresh
    _popupdll.Popup %menu1 + $mouse.dx $mouse.dy
    %result = $result
    if ($gettok(%result,1,32) == OK) && ($gettok(%result,4-,32) != $null) { $ifmatch }
    _popupdll.Destroy %menu1
    _popupdll.Destroy %menu2
  }
  if ($istok(item sclick,%lastevent,32)) { .timer $+ $dname $+ _ $+ $devent $+ $sclick -mo 1 50 _ftp.dirstatus %d 1022 1021 1025 1026 1024 }
}
ON *:DIALOG:ftp*:sclick:1030:{
  var %d = $dname,%lastevent = $gettok($did(%d,1030,1),1,32)
  if (%lastevent == rclick) {
    var %menu1 = FTPQUEUE,%menu2 = %menu1 $+ remove,%menu3 = %menu1 $+ move,%result,%sflags = $did(%d,1014,4)
    _popupdll.New %menu2 16 16
    _popupdll.AddItem %menu2 end + 0 0 &selected $cr _ftp.queuelist.del.sel %d
    _popupdll.AddItem %menu2 end
    _popupdll.AddItem %menu2 end + 0 0 &uploads $cr _ftp.queuelist.del.downupl %d 0
    _popupdll.AddItem %menu2 end + 0 0 &downloads $cr _ftp.queuelist.del.downupl %d 1
    _popupdll.AddItem %menu2 end
    _popupdll.AddItem %menu2 end + 0 0 &all $cr _ftp.queuelist.del.all %d

    _popupdll.New %menu3 16 16
    _popupdll.AddItem %menu3 end + 0 0 &up $cr _ftp.queuelist.move.up %d
    _popupdll.AddItem %menu3 end + 0 0 &down $cr _ftp.queuelist.move.down %d
    _popupdll.AddItem %menu3 end + 0 0 to &top $cr _ftp.queuelist.move.top %d
    _popupdll.AddItem %menu3 end + 0 0 to &bottom $cr _ftp.queuelist.move.bottom %d
    _popupdll.AddItem %menu3 end
    _popupdll.AddItem %menu3 end + 0 0 &uploads to top $cr _ftp.queuelist.move.downupl %d 0
    _popupdll.AddItem %menu3 end + 0 0 &downloads to top $cr _ftp.queuelist.move.downupl %d 1

    _popupdll.New %menu1 8 8
    _popupdll.AddItem %menu1 end +D 0 0 &transfer $cr _ftp.queue.start %d
    _popupdll.AddItem %menu1 end +> 0 0 &delete $cr %menu2
    _popupdll.AddItem %menu1 end +> 0 0 &move $cr %menu3
    _popupdll.AddItem %menu1 end
    _popupdll.AddItem %menu1 end + 0 0 queue &info $cr _ftp.queuelist.info %d
    _popupdll.AddItem %menu1 end + 0 0 &load queue $cr _ftp.queuelist.load %d
    _popupdll.AddItem %menu1 end + 0 0 &save queue $cr _ftp.queuelist.save %d

    _popupdll.Popup %menu1 + $mouse.dx $mouse.dy
    %result = $result
    if ($gettok(%result,1,32) == OK) && ($gettok(%result,4-,32) != $null) { $ifmatch }
    _popupdll.Destroy %menu1
    _popupdll.Destroy %menu2
  }
}
ON *:DIALOG:ftp*:sclick:2991:{
  if ($sock($dname)) { info.a Closing FTP session $remove($dname,FTP) }
  showmirc -s
  _ftp.disconnect $dname
}
alias -l _ftp.localsortfiltertoggle {
  var %d = $1,%old = $did(%d,1014,4)
  if ($istok(n s t,$2,32)) {
    if ($remove(%old,n,s,t) != $null) { did -o %d 1014 4 $ifmatch $+ $2 }
    else { did -o %d 1014 4 $2 }
  }
  elseif ($istok(b i l e,$2,32)) {
    if ($remove(%old,b,i,l,e) != $null) { did -o %d 1014 4 $ifmatch $+ $2 }
    else { did -o %d 1014 4 $2 }
  }
  else {
    %old = $remove(%old,d)
    if (+d isin $2) { %old = %old $+ d }
    did -o %d 1014 4 %old
  }
  _ftp._reflocal.ref %d
}
alias -l _ftp.remotesortfiltertoggle {
  var %d = $1,%old = $did(%d,1024,4)
  if ($istok(n s t m a o g c,$2,32)) {
    if ($remove(%old,n,s,t,m,a,o,g,c) != $null) { did -o %d 1024 4 $ifmatch $+ $2 }
    else { did -o %d 1024 4 $2 }
  }
  elseif ($istok(b i l e,$2,32)) {
    if ($remove(%old,b,i,l,e) != $null) { did -o %d 1024 4 $ifmatch $+ $2 }
    else { did -o %d 1024 4 $2 }
  }
  else {
    %old = $remove(%old,d)
    if (+d isin $2) { %old = %old $+ d }
    did -o %d 1024 4 %old
  }
  _ftp._refremote.ref %d
}
ON *:DIALOG:ftp*:dclick:1011:{
  var %d = $dname,%line = $did(%d,$did,$did(%d,$did,1).sel),%oldpath = $did(%d,1014,1),%path = %oldpath,%icon = $gettok(%line,2,32),%name = $gettok($gettok(%line,1,9),3-,32)
  if (%icon == 1) { %path = $deltok(%path,-1,92) }
  elseif (%icon == 2) { %path = %oldpath $+ %name $+ \ }
  elseif (%icon == 3) {
    _ftp.localdir.filedclick %d %oldpath $+ %name
    return
  }
  else { %path = $mid($gettok(%name,-1,32),2,2) $+ \ }
  _ftp.reflocal %d %path
}
ON *:DIALOG:ftp*:dclick:1021:{
  var %d = $dname,%line = $did(%d,$did,$did(%d,$did,1).sel),%oldpath = $did(%d,1024,1),%path = %oldpath,%icon = $gettok(%line,2,32),%name = $gettok($gettok(%line,1,9),3-,32)
  if (%icon == 1) { _ftp.com $dname cdup }
  elseif (%icon == 2) { _ftp.com $dname CWD %name }
  else { _ftp.remotedir.filedclick %d %oldpath $+ %name }
}
; /_ftp.dirstatus dname statusdid listdid dirdid filedid free
alias -l _ftp.dirstatus {
  var %d = $1
  if ($dialog(%d) == $null) { return }
  var %folders = $did(%d,$4).lines,%files = $did(%d,$5).lines,%sels = $did(%d,$3,0).sel,%totalbytes = $bytes($did(%d,$6,3),3).suf,%showfree = 0,%showtotal = 0,%com
  %com = did -i %d $2 2 +p 0 $_nsingoplur(%folders,Folder,Folders) $+ , $_nsingoplur(%files,File,Files) $+ , $calc(%folders + %files) Total
  if (%totalbytes == $null) { %totalbytes = 0b }
  if (%sels) { %com ( $+ %totalbytes $+ , $_nsingoplur(%sels,item,items) selected) }
  else {
    if ($6 == 1014) { %com ( $+ %totalbytes $+ , free: $bytes($disk($did(%d,$6,1)).free,3).suf $+ ) }
    else { %com ( $+ %totalbytes $+ ) }
  }
}
alias -l _ftp.localdir.filedclick {  }
alias -l _ftp.remotedir.filedclick {  }
alias _ftp.reflocal {
  var %m,%i,%d = $1,%path = $2-
  if ($disk($left(%path,1)).type == $null) || ($isdir(%path) == $false) {
    _ftp.addlog.error %d Local directory " $+ %path $+ " not found
    return
  }
  if (*\ !iswm %path) { %path = %path $+ \ }
  did -r %d 1015,1016
  did -o %d 1014 1 %path
  _dialog.add1 %d 1010 %path
  if (ftp* iswm $dname) && ($did(%d,1014,2) != $null) { %m = $ifmatch }
  else { %m = * }
  did -i %d 1012 2 +p 0 Gathering dir info...

  ;;; "/set -u %var" will behave oddly here
  ;;; Only Khaled knows why
  %~ftptotalbytes = 0
  %~ftptotalfiles = 0

  _dummy $finddir(%path,*,0,1,_ftp._reflocal.adddir %d $1-)
  _dummy $findfile(%path,%m,0,1,_ftp._reflocal.addfile %d $1-)
  did -o %d 1014 3 $round(%~ftptotalbytes,0)
  did -o %d 1014 5 $round(%~ftptotalfiles,0)
  unset %~ftptotalbytes %~ftptotalfiles
  _ftp._reflocal.ref %d
}
alias _ftp._reflocal.adddir { did -a $1 1015 - 2 $nopath($2-) }
alias _ftp._reflocal.addfile {
  var %size = $file($2-).size,%nopath = $nopath($2-),%ext = $gettok(%nopath,-1,46)
  if ($numtok(%nopath,46) == 1) { var %ext }
  did -a $1 1016 - 3 %nopath $+ $chr(9) $+ 0 $bytes(%size,b) $+ $chr(9) $+ %size $+ $chr(9) $+ %ext
  if (%size) { inc %~ftptotalbytes $ifmatch }
  inc %~ftptotalfiles
}
alias _ftp.liststyle {
  var %l = showsel autoarrange rowselect
  if (b isin $1) { %l = %l icon }
  elseif (i isin $1) { %l = %l icon smallicon }
  elseif (l isin $1) { %l = %l list }
  else { %l = %l nosortheader report nosortheader }
  return %l
}
alias _ftp._reflocal.ref {
  var %d = $1,%i
  did -r %d 1011
  _mdx.SetMDXStyle %d 1011 $_ftp.liststyle($did(%d,1014,4))
  %i = 67
  while (%i <= 90) {
    if ($disk($chr(%i)).type != $null) {
      var %drive = $chr(%i),%label = $disk(%drive).label,%pd = ( $+ %drive $+ :)
      if (%drive isin ab) { did -a %d 1011 + 4 Floppy Drive %pd }
      elseif ($disk(%drive).type == cdrom) { did -a %d 1011 + 6 %label %pd }
      else { did -a %d 1011 + 5 %label %pd }
    }
    inc %i
  }
  if ($numtok($did(%d,1014,1),92) > 1) { did -a %d 1011 + 1 Up }
  var %sflags = $did(%d,1014,4),%col,%fflags = -iot
  if (d isin %sflags) { %fflags = -iote }
  if (n isin %sflags) { %col = 1 }
  elseif (s isin %sflags) { var %col = 3,%fflags = %fflags $+ u }
  else { %col = 4 }
  filter %fflags %col 9 %d 1015 %d 1011
  filter %fflags %col 9 %d 1016 %d 1011
  _ftp.dirstatus %d 1012 1011 1015 1016 1014
}
alias _ftp.gftp.sr {
  var %d = $_ftp.nums,%name = $9-,%isdir = 0,%isv = 0
  did -a %d 2251 $1-
  if (%name != $null) {
    if (d* iswm $1) {
      if ($istok(. ..,$9-,32) == $false) { %isdir = 1 }
      else { return }
    }
    elseif ($istok($9-,->,32)) {
      var %a = $findtok($9-,->,1,32) $+ - $+ $numtok($9-,32),%b = 1- $+ $findtok($9-,->,1,32),%a = $deltok($9-,%a,32),%b = $deltok($9-,%b,32),%name = %a
      if (*.* !iswm %b) { %isdir = 1 }
      %isv = 1
    }
    var %c9 = $chr(9),%90 = %c9 $+ 0,%date = $6-7,%time,%year
    if (*:* iswm $8) { var %time = $8,%year = $asctime($ctime,yyyy) }
    else { var %time = 00:00,%year = $8 }
    var %ctime = %date %year %time,%ctime = $ctime(%ctime),%asctime = $asctime(%ctime,dd/mmm/yyyy HH:nn)
    if (%isdir) { did -a %d 1025 - 2 %name $+ %90 $bytes($5,b) $+ %90 %asctime $+ %90 $1 $+ %90 $3 $+ %90 $4 $+ %90 $+ %c9 $+ $5 $+ %c9 $+ %ctime $+ %c9 }
    else {
      var %ext = $gettok(%name,-1,46)
      if ($numtok(%name,46) == 1) { var %ext }
      did -a %d 1026 - 3 %name $+ %90 $bytes($5,b) $+ %90 %asctime $+ %90 $1 $+ %90 $3 $+ %90 $4 $+ %90 $+ %c9 $+ $5 $+ %c9 $+ %ctime $+ %c9 $+ %ext
      did -o %d 1024 3 $calc($did(%d,1024,3) + $5)
      did -o %d 1024 5 $calc($did(%d,1024,5) + 1)
    }
  }
}
alias _ftp._refremote.ref {
  var %d = $1
  did -r %d 1021
  did -a %d 1021 + 1 Up
  _mdx.SetMDXStyle %d 1021 $_ftp.liststyle($did(%d,1024,4))
  var %sflags = $did(%d,1024,4),%col,%fflags = -iot
  if (d isin %sflags) { %fflags = -iote }
  if (n isin %sflags) { %col = 1 }
  elseif (s isin %sflags) { var %col = 8,%fflags = %fflags $+ u }
  elseif (m isin %sflags) { var %col = 9,%fflags = %fflags $+ u }
  elseif (a isin %sflags) { %col = 4 }
  elseif (o isin %sflags) { %col = 5 }
  elseif (g isin %sflags) { %col = 6 }
  elseif (c isin %sflags) { %col = 7 }
  else { %col = 10 }
  filter %fflags %col 9 %d 1025 %d 1021
  filter %fflags %col 9 %d 1026 %d 1021
  _ftp.dirstatus %d 1022 1021 1025 1026 1024
}
alias -l _ftp.local.transfer {
  if ($_ftp.remote.disconnected) { return }
  _ftp.local.queue +t
  _ftp.queue.start
}
alias -l _ftp.local.queue {
  if ($_ftp.remote.disconnected) { return }
  var %d = $dname,%icon,%name,%l,%t,%parent = $did($dname,1014,1),%z,%c = 0,%text,%z = $did(%d,1011,0).sel,%xxx,%remotedir = $did(%d,1024,1),%remotefile,%server = ftp:// $+ $did(%d,2994,1) $+ : $+ $sock(%d).port
  if (%z) {
    did -i %d 1012 2 +p 0 Adding $_nsingoplur(%z,item,items) to the queue... please wait
    while (%z) {
      var %l = $did(%d,1011,%z).sel,%t = $did(%d,1011,%l),%icon = $gettok(%t,2,32),%name = $gettok($gettok(%t,1,9),3-,32)
      if (%icon == 3) {
        %remotefile = %remotedir $+ %name
        %name = %parent $+ %name
        %xxx = $_ftp.queue.add($dname,0,%name,%remotefile,$gettok($gettok(%t,2,9),2,32),%server)
        inc %c
      }
      dec %z
    }
    _ftp.dirstatus $dname 1012 1011 1015 1016 1014
  }
  if (%c == 0) { _ftp.status.error $dname No local files selected to $iif(t isin $1,transfer,queue) }
}
alias -l _ftp.local.del {
  var %d = $dname,%icon,%name,%l,%t,%parent = $did($dname,1014,1),%z,%c = 0,%text
  if ($did(%d,1011,0).sel) {
    var %z = $ifmatch,%text = Remove $_nsingoplur(%z,selected item?,selected items?)
    if ($_not($_yesno(1,FTP Client [/ftp],1,%text))) { return }
    did -i %d 1012 2 +p 0 Removing %z items... please wait
    while (%z) {
      var %l = $did(%d,1011,%z).sel,%t = $did(%d,1011,%l),%icon = $gettok(%t,2,32),%name = $gettok($gettok(%t,1,9),3-,32)
      if (%icon == 2) {
        _rmdir " $+ %parent $+ %name $+ "
        inc %c
      }
      elseif (%icon == 3) {
        .remove " $+ %parent $+ %name $+ "
        inc %c
      }
      dec %z
    }
  }
  if (%c) {
    _ftp.status.info $dname $_nsingoplur(%c,item,items) removed
    _ftp.local.refresh
  }
  else {
    _ftp.status.error $dname No directories/files selected to remove
    _ftp.dirstatus $dname 1012 1011 1015 1016 1014
  }
}
alias -l _ftp.local.ren {
  var %t,%oldir = $did($dname,1014,1),%line = $did($dname,1011,$did($dname,1011,1).sel),%new,%icon = $gettok(%line,2,32),%file = $gettok($gettok(%line,1,9),3-,32)
  if (%icon == 3) {
    %new = $_parameter($null,1,FTP Client [/ftp],isvalidfilename,%file,New name for local file:<CRLF> [ %file ] )
    if ($dialog($dname) == $null) { return }
    %t = %oldir $+ %new
    if (%new != $null) {
      if ($isfile(%t) == $false) {
        .rename " $+ %oldir $+ %file $+ " " $+ %oldir $+ %new $+ "
        _ftp.reflocal $dname %oldir
      }
      elseif (%new == %file) { _ftp.status.error $dname Cannot rename local file ' $+ %file $+ ' - Same filename! }
      else { _ftp.status.error $dname Cannot rename local file ' $+ %file $+ ' - Already exists file ' $+ %new $+ ' }
    }
  }
  else { _ftp.status.error $dname Only files can be renamed }
}
alias -l _ftp.local.mkdir {
  var %newdir,%localdir = $did($dname,1014,1),%createdir
  if (*\ !iswm %localdir) { %localdir = %localdir $+ \ }
  %newdir = $_parameter($null,1,FTP Client [/ftp],len < 250,$null,Local directory to create inside<CRLF> [ %localdir ] )
  if ($dialog($dname) == $null) { return }
  %createdir = %localdir $+ %newdir
  if (/ !isin %newdir) && (\ !isin %newdir) && ($_fixdir(%createdir)) {
    .mkdir " $+ %createdir $+ "
    _ftp.local.refresh
  }
  else { _ftp.status.error $dname Invalid directory: %createdir }
}
alias -l _ftp.local.chdir {
  var %dir = $$sdir="Change Local Directory in FTP Session [ $_ftp.num ] " $did($dname,1014,1)
  if ($dialog($dname) == $null) { return }
  if ($istok(a b,$left(%dir,1),32) == $false) { _ftp.reflocal $dname %dir }
  else { _ftp.status.error $dname Please don't use diskettes! }
}
alias -l _ftp.local.cdup {
  if ($deltok($did($dname,1014,1),-1,92) != $null) { _ftp.reflocal $dname $ifmatch }
}
alias -l _ftp.local.refresh { _ftp.reflocal $dname $did($dname,1014,1) }
alias -l _ftp.remote.transfer {
  if ($_ftp.remote.disconnected) { return }
  _ftp.remote.queue +t
  _ftp.queue.start
}
alias -l _ftp.remote.queue {
  if ($_ftp.remote.disconnected) { return }
  var %d = $dname,%icon,%name,%l,%t,%parent = $did($dname,1024,1),%z,%c = 0,%text,%z = $did(%d,1021,0).sel,%xxx,%localdir = $did(%d,1014,1),%localfile,%server = ftp:// $+ $did(%d,2994,1) $+ : $+ $sock(%d).port
  if (%z) {
    did -i %d 1022 2 +p 0 Adding $_nsingoplur(%z,item,items) to the queue... please wait
    while (%z) {
      var %l = $did(%d,1021,%z).sel,%t = $did(%d,1021,%l),%icon = $gettok(%t,2,32),%name = $gettok($gettok(%t,1,9),3-,32)
      if (%icon == 3) {
        %localfile = %localdir $+ %name
        %name = %parent $+ %name
        %xxx = $_ftp.queue.add($dname,1,%localfile,%name,$gettok($gettok(%t,2,9),2,32),%server)
        inc %c
      }
      dec %z
    }
    _ftp.dirstatus $dname 1022 1021 1025 1026 1024
  }
  if (%c == 0) { _ftp.status.error $dname No remote files selected to $iif(t isin $1,transfer,queue) }
}
alias -l _ftp.remote.del {
  if ($_ftp.remote.disconnected) { return }
  var %d = $dname,%icon,%name,%l,%t,%parent = $did($dname,1024,1),%z,%c = 0,%text
  if ($did(%d,1021,0).sel) {
    var %z = $ifmatch,%text = Remove $_nsingoplur(%z,selected item?,selected items?)
    if ($_not($_yesno(1,FTP Client [/ftp],1,%text))) { return }
    while (%z) {
      var %l = $did(%d,1021,%z).sel,%t = $did(%d,1021,%l),%icon = $gettok(%t,2,32),%name = $gettok($gettok(%t,1,9),3-,32)
      if (%icon == 2) {
        did -a $dname 2250 _ftp.com $dname rd %name
        inc %c
      }
      elseif (%icon == 3) {
        did -a $dname 2250 _ftp.com $dname del %name
        inc %c
      }
      dec %z
    }
  }
  if (%c) {
    _ftp.sigue $dname 0
    did -o $dname 2994 15 1
  }
  else { _ftp.status.error $dname No directories/files selected to remove }
}
alias -l _ftp.remote.ren {
  if ($_ftp.remote.disconnected) { return }
  var %t,%oldir = $did($dname,1024,1),%line = $did($dname,1021,$did($dname,1021,1).sel),%new,%icon = $gettok(%line,2,32),%file = $gettok($gettok(%line,1,9),3-,32)
  if (%icon isin 23) {
    if (%icdon == 2) { %c.ftpren.esdir = 1 }
    _ftp.com $dname ren %file
  }
  else { _ftp.status.error $dname Only files or directories can be renamed }
}
alias -l _ftp.remote.copyurl {
  if ($_ftp.remote.disconnected) { return }
  if ($did($dname,2994,1) != $null) {
    var %server = $ifmatch,%dir = $did($dname,1024,1),%line = $did($dname,1021,$did($dname,1021,1).sel),%icon = $gettok(%line,2,32),%file = $gettok($gettok(%line,1,9),3-,32),%cb = ftp:// $+ %server $+ %dir
    if (*/ !iswm %cb) { %cb = %cb $+ / }
    if (%icon == 3) { %cb = %cb $+ %file }
    clipboard %cb
  }
  else { _ftp.status.error $dname Unknown server }
}
alias -l _ftp.remote.chmod {
  if ($_ftp.remote.disconnected) { return }
  ;;;
}
alias -l _ftp.remote.quote {
  if ($_ftp.remote.disconnected) { return }
  var %q = $_parameter($null,1,FTP Client [/ftp],normal,$_randtok(help syst,32),Command to execute in server:)
  if ($dialog($dname)) { _ftp.com $dname %q }
}
alias -l _ftp.remote.mkdir {
  if ($_ftp.remote.disconnected) { return }
  var %dir = $_parameter($null,1,FTP Client [/ftp],len < 250,$null,Remote directory to create inside:<CRLF> [ $did($dname,1024,1) ] )
  if ($dialog($dname)) { _ftp.com $dname MKD %dir }
}
alias -l _ftp.remote.chdir {
  if ($_ftp.remote.disconnected) { return }
  var %win = @__ftpremotechdir,%dir
  _openwins %win
  filter -iw $dname 1020 %win
  %dir = $_rparameter($null,1,FTP Client [/ftp],normal,$line(%win,1),%win,$null,Change to remote directory:)
  if ($dialog($dname) != $null) && (%dir != $did($dname,1024,1)) { _ftp.com $dname CWD %dir }
  close -@ %win
}
alias -l _ftp.remote.cdup {
  if ($_ftp.remote.disconnected) { return }
  _ftp.com $dname CDUP
}
alias -l _ftp.remote.refresh {
  if ($_ftp.remote.disconnected == 0) { _ftp.com $dname dir }
}
alias -l _ftp.remote.disconnected {
  var %d = $iif($1,$1,$dname)
  if ($dialog(%d)) && ($sock(%d)) { return 0 }
  return 1
}
alias -l _ftp.queuelist.del.sel {
  if ($did($1,1030,1).sel) && ($_not($_yesno(1,FTP Client [/ftp],1,Remove selected entries from the queue?))) { return }
  while ($did($1,1030,1).sel) { did -d $1 1030 $ifmatch }
}
alias -l _ftp.queuelist.del.downupl {
  var %d = $1,%downupl = $calc($2 + 1),%i = $did(%d,1030,1).lines,%icon
  if (%i > 1) && ($_yesno(1,FTP Client [/ftp],1,Remove [ $iif(%downupl == 2,downloads,uploads) ] from the queue?)) {
    while (%i > 1) {
      %icon = $gettok($did(%d,1030,%i),2,32)
      if (%icon == %downupl) { did -d %d 1030 %i }
      dec %i
    }
  }
}
alias -l _ftp.queuelist.del.all {
  if ($did($1,1030,1).lines > 1) && ($_yesno(1,FTP Client [/ftp],1,Clear queue?)) { did -r $1 1030 }
}
alias -l _ftp.queuelist.move.up { _dialog.MDXVIEWLISTup $1 1030 1030 }
alias -l _ftp.queuelist.move.down { _dialog.MDXVIEWLISTdown $1 1030 1030 }
alias -l _ftp.queuelist.move.top {
  var %d = $1,%l,%t,%c = 0,%i = 2
  while ($did(%d,1030,1).sel) {
    var %l = $ifmatch,%t = $did(%d,1030,%l)
    did -d %d 1030 %l
    did -i %d 1030 %i %t
    inc %i
  }
  dec %i
  while (%i > 1) {
    did -ck %d 1030 %i
    dec %i
  }
}
alias -l _ftp.queuelist.move.bottom {
  var %d = $1,%l,%t,%c = 0,%i = 0
  while ($did(%d,1030,1).sel) {
    var %l = $ifmatch,%t = $did(%d,1030,%l)
    did -d %d 1030 %l
    did -a %d 1030 %t
    inc %i
  }
  dec %i
  %t = $did(%d,1030).lines
  %i = %t - %i
  while (%i <= %t) {
    did -ck %d 1030 %i
    inc %i
  }
}
alias -l _ftp.queuelist.move.downupl {
  var %d = $1,%downupl1 = $calc($2 + 1),%downupl2 = $iif(%downupl1 == 1,2,1),%win = @__ftpqueuelistmovedownupl
  _openwins %win
  filter -iwr 2-999999999 %d 1030 %win & %downupl1 *
  filter -iwr 2-999999999 %d 1030 %win & %downupl2 *
  filter -woc %win %d 1030
}
alias -l _ftp.queuelist.info {
  var %d = $1,%i = $did(%d,1030).lines,%dc = 0,%uc = 0,%db = 0,%ub = 0,%tc = 0,%tb = 0,%line,%icon,%size
  while (%i > 1) {
    var %line = $did(%d,1030,%i),%icon = $gettok(%line,2,32),%size = $remove($gettok($gettok(%line,3,9),2,32),$chr(44))
    if (%icon == 1) {
      inc %uc
      if (%size) { inc %ub %size }
    }
    else {
      inc %dc
      if (%size) { inc %db %size }
    }
    dec %i
  }
  %tc = %uc + %dc
  %tb = %ub + %db
  if (%tc) {
    _ftp.addlog.info %d Queue Info:
    _ftp.addlog.info %d Uploads: %uc ( $+ $bytes(%ub,3).suf $+ )
    _ftp.addlog.info %d Downloads: %dc ( $+ $bytes(%db,3).suf $+ )
    _ftp.addlog.info %d Total: %tc ( $+ $bytes(%tb,3).suf $+ )
  }
  else { _ftp.addlog.info %d The transfer queue is empty }
}
alias -l _ftp.queuelist.load {
  var %d = $1,%win = @__tmp,%file = $hfile="Load FTP queue from:" $_usrdir(*.afq),%line
  if ($isfile(%file)) {
    tokenize 32 $read -nl1 %file
    if ($0 == 3) && (//aIRCFTPqueuelist == $1) && ($2 == 2) && ($3 isnum) { filter -focr 2-9999999999999 " $+ %file $+ " %d 1030 }
    else { _ftp.status.error %d Invalid queue list file: ' $+ %file $+ ' }
  }
  else { _ftp.status.error %d File not found: ' $+ %file $+ ' }
}
alias -l _ftp.queuelist.save {
  var %d = $1,%win = @__tmp,%file = $hfile="Save FTP queue in:" $_usrdir(*.afq)
  if (%file != $null) {
    _openwins %win
    filter -iwr 2-99999999999 %d 1030 %win
    iline %win 1 //aIRCFTPqueuelist 2 $ctime
    savebuf %win " $+ %file $+ "
    close -@ %win
  }
}
alias _ftp.queue.start {
  var %d = $iif($1,$1,$dname)
  did -o %d 2994 18 1
  if ($did(%d,1030).lines > 1) { _ftp.sigue %d 0 }
  else { _ftp.status.error %d The transfer queue is empty }
}
; $_ftp.queue.add(session,0|1,local,remote,bytes,server)
; 0=upload 1=download
alias _ftp.queue.add {
  var %icon = $calc($2 + 1),%local = $3,%remote = $4,%size = $5,%server = $6,%from,%target,%90 = $chr(9) $+ 0
  if (%icon == 1) { var %from = %local,%target = %remote }
  else { var %from = %remote,%target = %local }
  did -a $1 1030 - %icon %from $+ %90 %target $+ %90 %size $+ %90 %server
}
alias _ftp.setitle {
  if ($2- != $null) { dialog -t $1 $2- - taboFTP Client v2.0 }
  else { dialog -t $1 taboFTP Client v2.0 }
}
alias _ftp.disconnect {
  if (ftp* iswm $1) {
    sockclose $1
    sockclose ? $+ $1
    .timer $+ $1 off
    .timer $+ $1 $+ _* off
    if ($dialog($1)) {
      did -o $1 1000 2 +a 1 Connect $+ $chr(9) $+ Connect to a FTP Server
      _ftp.setitle $1
      _ftp.addlog.info $1 Disconnected!
      did -r $1 1020,1021,1022,1025,1026
    }
  }
}
;;;;;;;;
;;;;;
;;;;; SUPPORT
;;;;;
;;;;;;;;

alias -l _start.filelist { var %tmp = $findfile($scriptdir,*.tfl,0,1,_list.hash $nopath($1-)),%tmp = _dummy $findfile($scriptdir,*.tfr,0,1,_recent.hash $nopath($1-)) }
alias -l _dialog {
  if ($dialog($2)) { dialog -v $2 }
  else { dialog $1-3 }
}
alias -l _hmake {
  var %name = $1,%num = $round($2,0)
  if ($_not($_isint(%num))) { %num = 15 }
  if (%name == $null) { return }
  if ($hget(%name)) { hfree %name }
  hmake %name %num
}
alias -l _getlocalip {
  if ($ip == $null) {
    .localinfo -h
    info.a Looking up your I.P...
    .timer -o 1 1 __getlocalip 1 $1-
    return 1
  }
  return 0
}
alias -l __getlocalip {
  if ($ip != $null) {
    if ($2- != $null) { $2- }
  }
  elseif ($1 == 5) { error.a Your IP is unknown. Press "ALT+O", go to "Local Info" and configure your I.P. }
  else { .timer -o 1 1 __getlocalip $calc($1 + 1) $2- }
}
alias -l _crypt {
  if ($len($1-) == 0) { return }
  var %t = $len($1-),%i = 1,%r,%_
  while (%i <= %t) { var %_ = $calc($asc($mid($1-,%i,1)) * 3 - 2 + $hash($chr(%i),32) - %i * 3),%_ = $len(%_) $+ $_randstring($calc(5 - $len(%_)),n) $+ %_,%r = %r $+ %_,%i = %i + 1 }
  return %r
}
alias -l _decrypt {
  if ($len($1-) == 0) { return }
  if ($1- !isnum) { return }
  var %t = $len($1-),%i = 1,%r,%_,%x,%n,%m,%l
  while (%i <= %t) {
    var %m = $mid($1-,%i,6),%n = $left(%m,1),%l = $right(%m,%n),%x = $calc((%i + 5) / 6),%_ = $calc((%l + 2 - $hash($chr(%x),32) + %x * 3) / 3)
    if (%_ != 032) { %r = %r $+ $chr(%_) }
    else { %r = %r $chr(%_) }
    inc %i 6
  }
  return %r
}
dialog _simplelist {
  size -1 -1 172 170
  option type dbu

  list 1,5 10 125 145,sort extsel size
  list 2,5 10 125 145,sort size hide
  list 3,5 10 125 145,sort extsel size hide
  list 4,5 10 125 145,sort size hide

  combo 20,5 11 125 9999,drop hide
  button "",21,5 10 125 15,hide
  text "",22,5 5 125 20,hide

  list 40,5 25 125 130,sort extsel size hide
  list 41,5 25 125 130,sort extsel size hide
  list 42,5 25 125 130,sort extsel size hide
  list 43,5 25 125 130,sort extsel size hide
  list 44,5 25 125 130,sort extsel size hide
  list 45,5 25 125 130,sort extsel size hide
  list 46,5 25 125 130,sort extsel size hide
  list 47,5 25 125 130,sort extsel size hide
  list 48,5 25 125 130,sort extsel size hide
  list 49,5 25 125 130,sort extsel size hide
  list 50,5 25 125 130,sort extsel size hide

  list 60,5 25 125 130,sort size hide
  list 61,5 25 125 130,sort size hide
  list 62,5 25 125 130,sort size hide
  list 63,5 25 125 130,sort size hide
  list 64,5 25 125 130,sort size hide
  list 65,5 25 125 130,sort size hide
  list 66,5 25 125 130,sort size hide
  list 67,5 25 125 130,sort size hide
  list 68,5 25 125 130,sort size hide
  list 69,5 25 125 130,sort size hide
  list 70,5 25 125 130,sort size hide

  list 80,5 30 125 125,sort size hide

  button "&New...",101,135 10 33 15
  button "&Delete",102,135 30 33 15
  button "",103,135 50 33 15,hide
  button "",104,135 70 33 15,hide
  button "",105,135 90 33 15,hide
  button "",106,135 110 33 15,hide

  button "&OK",201,135 120 33 15,ok
  button "&Cancel",202,135 140 33 15,cancel
  check "",220,5 156 170 15,hide
  text "",221,5 156 170 15,hide

  list 246,1 1 1 1,hide
  list 247,1 1 1 1,hide
  list 248,1 1 1 1,hide
  list 249,1 1 1 1,hide
  list 250,1 1 1 1,hide
}
alias -l _usrdir { return $scriptdir $+ $1- }
alias -l _sockmark {
  if ($2 == $null) && ($sockname) { return $gettok($sock($sockname).mark,$1,9) }
  return $gettok($sock($1).mark,$2,9)
}
alias -l _dialog.add1 {
  if ($dialog($1) == $null) { return }
  var %i = 1,%l
  while ($didwm($1,$2,$3-,%i)) {
    %l = $ifmatch
    if ($did($1,$2,%l).text == $3-) {
      did -d $1 $2 %l
      break
    }
    inc %i
  }
  did -ic $1 $2 1 $3-
}
alias -l _dialog-x {
  if ($dialog($1)) { dialog -x $1 }
}
alias -l _sckbpsw {
  if ($1- == $null) { return 0 bytes/s }
  return $bytes($1,3).suf $+ /s
}
alias -l _duratio {
  if ($1 <= 0) { return 0 }
  var %a = $remove($duration($gettok($1,1,46)),ecs,ec,ins,in,rs,r,ays,ay)
  if ($2 > 0) && ($gettok($1,2,46) isnum)  { return $left(%a,-1) $+ . $+ $mid($gettok($1,2,46),1,$2) $+ s }
  return $remove($duration($round($1,0)),ecs,ec,ins,in,rs,r,ays,ay)
}
alias -l _text { return $1- }
; $_ishost(host)
alias -l _ishost {
  if ($_isint($remove($1,.))) && ($_not($_isip($1))) { return }
  if ($__ishost($1-)) { return $1 }
  return
}
; $_isip(ip)
alias -l _isip {
  if ($__ishost($1-)) && ($numtok($1,46) == 4) && ($gettok($1,1,46) isnum 0-255) && ($gettok($1,2,46) isnum 0-255) && ($gettok($1,3,46) isnum 0-255) && ($gettok($1,4,46) isnum 0-255) { return $1 }
  return
}
alias -l __ishost {
  if ($1- == $1) && ($1- != #$1) && (.* !iswm $1) && (*. !iswm $1) && (.. !isin $1) && ($len($remove($1,.))) && ($len($remove($1,@,$chr(44),:,?,*,/,<,>,[,])) == $len($1)) { return $1 }
  return
}
; $_isint(number)
alias -l _isint {
  if ($1- isnum) && ($1 > 0) { return $int($1) }
  return
}
alias -l _dialog.loadlist {
  var %lt,%i = 1,%lines = $_list.total($5)
  if ($6) { %lt = $len($iif(%lines,%lines,1)) }
  if ($7) { did -r $1 $2 }
  while ($_list.get($5,%i) != $null) {
    if ($gettok($ifmatch,$3,$4)) { did -a $1 $2 $iif($6,$base(%i,10,10,%lt)) $gettok($_list.get($5,%i),$3,$4) }
    inc %i
  }
}
alias -l _mdx.init {
  var %d = $dname
  _mdx.MarkDialog %d
  if ($2- != $null) { _mdx.SetDialog %d style $2-  }
  _mdx.SetDialog %d icon $1
}
; _mdx.MarkDialog [dname]
alias -l _mdx.MarkDialog { return $dll($scriptdirmdx.dll,MarkDialog,$iif($1 != $null,$1,$dname)) }
; _mdx.SetDialog <dialog> <property> <value>
alias -l _mdx.SetDialog { return $dll($scriptdirmdx.dll,SetDialog,$1-) }
; _mdx.SetControlMDX <plugin> <dialog name> <ID> <control> [styles]
alias -l _mdx.SetControlMDX {
  var %parms = $2- > $scriptdir $+ $1
  return $dll($scriptdirmdx.dll,SetControlMDX,%parms)
}
; _mdx.SetFont <dialog> <ID> [+flags] [charset] <size> <weight> <font>
alias -l _mdx.SetFont {
  var %dialog = $1,%ids = $2,%parms = $3-,%tmp,%i = 1,%n = $numtok(%ids,44),%z
  while (%i <= %n) {
    %z = %dialog $gettok(%ids,%i,44) %parms
    %tmp = $dll($scriptdirmdx.dll,SetFont,%z)
    inc %i
  }
}
; _mdx.MoveControl <dialog> <ID> [x] [y] [w] [h]
alias -l _mdx.MoveControl { return $dll($scriptdirmdx.dll,MoveControl,$1-) }
; _mdx.SetBorderStyle <dialog> <ID> <styles>
alias -l _mdx.SetBorderStyle { return $dll($scriptdirmdx.dll,SetBorderStyle,$1-) }
alias -l _mdx.fixtablengths {
  var %r,%i = 1,%n = $numtok($1-,32),%t
  while (%i <= %n) {
    %t = $calc($dbuw * $gettok($1-,%i,32))
    %r = %r $+ , $+ %t
    inc %i
  }
  return @ $+ $right(%r,-1)
}
; _mdx.SetMDXStyle <dialog> <ID> <styles>
alias -l _mdx.SetMDXStyle { return $dll($scriptdirmdx.dll,SetMDXStyle,$1-) }
; $_icofile(file.ico,dir)
alias -l _icofile {
  var %ico = $scriptdir $+ taboftp_ $+ $1
  if ($isfile(%ico) == $false3) { %ico = $scriptdirtaboftp_airc.ico }
  return $shortfn(%ico)
}
alias -l _sockerr { return $sock($sockname).wsmsg }
alias -l _fixfilename {
  var %file = $1,%flags = $2,%err1 = 0,%err2 = 0
  %file = $remove($replace(%file,/,\),")
  while (\\ isin %file) { %file = $replace(%file,\\,\) }
  if (?:\* iswm %file) {  }
  elseif (?:* iswm %file) { %file = $left(%file,2) $+ \ $+ $right(%file,-2) }
  elseif (\* iswm %file) { %file = $left($mircdir,2) $+ %file }
  else { %file = $mircdir $+ %file }
  if (~ isin %file) && ($longfn(%file) != $null) { %file = $ifmatch }
  if ($len($remove(%file,*,?,<,>,|)) < $len(%file)) || ($count(%file,:) > 1) {
    if (f isincs %flags) { %file = $left(%file,3) $+ $right(%file,-3) }
    elseif (n !isin %flags) { %err1 = 1 }
  }
  if ($nopath(%file) == $null) { %err2 = 1 }
  if (%err1) || (%err2) { return }
  if (e isincs %flags) && ($_not($isfile(%file))) { return }
  if (m isincs %flags) && ($mircdir* iswm %file) { return $remove(%file,$mircdir) }
  return %file
}
; _popupdll.New <menu> <icon width> <icon height>
alias -l _popupdll.New {
  tokenize 32 $1-
  if ($dll($scriptdirPopups.dll,GetProperty, [ $1 ] imgsize) != $null) { var %tmp = $dll($scriptdirPopups.dll,Destroy,$1) }
  return $dll($scriptdirPopups.dll,New,$1-)
}

; _popupdll.Destroy <menu>
alias -l _popupdll.Destroy { return $dll($scriptdirPopups.dll,Destroy,$1-) }
; _popupdll.AddItem <menu> <pos> [+flags] [unsel#] [sel#] [trans] [text]{cr}[info]
alias -l _popupdll.AddItem { return $dll($scriptdirPopups.dll,AddItem,$1-) }
; _popupdll.Popup <menu> [+flags] <x> <y> [x y w h]
alias -l _popupdll.Popup { return $dll($scriptdirPopups.dll,Popup,$1-) }
; /_dialog.MDXVIEWLISTup dialog seldid dids
alias -l _dialog.MDXVIEWLISTup {
  if ($dialog($1) == $null) { return }
  var %i = 1,%m,%t,%win = @__dialogMDXVIEWLISTup,%z = 0
  _openwins %win
  ;;;  while ($did($1,$2,%i).sel != $null) {
  while ($did($1,$2,1).sel != $null) {
    %m = $ifmatch
    if (%m > 2) {
      %t = $did($1,$2,%m)
      did -d $1 $3 %m
      dec %m
      did -i $1 $3 %m %t
      ;;;      did -ck $1 $3 %m
      aline %win %m
    }
    elseif (%z <= 2) {
      did -uk $1 $3 %m
      aline %win %m
      inc %z
    }
    else { break }
    inc %i
  }
  var %i = $line(%win,0)
  while (%i) {
    did -ck $1 $3 $line(%win,%i)
    dec %i
  }
  close -@ %win
}
; /_dialog.MDXVIEWLISTdown dialog seldid dids
alias -l _dialog.MDXVIEWLISTdown {
  if ($dialog($1) == $null) { return }
  var %l = $did($1,$2).lines,%i = $did($1,$2,0).sel,%m,%t
  ;;;  while (%i) && ($did($1,$2,%i).sel != $null) {
  if ($did($1,$2,1).sel != $null) {
    %m = $ifmatch
    ;    if (%m < %l) && ($_not($did($1,$2,$calc(%m + 1)).state)) {
    if (%m < %l) {
      %t = $did($1,$2,%m)
      did -d $1 $3 %m
      inc %m
      did -i $1 $3 %m %t
      did -ck $1 $3 %m
    }
    dec %i
  }
}
alias -l _openwins {
  if ($1- != $null) { close -@ $1- }
  if ($1) { window -hl $1 }
  if ($2) { window -hl $2 }
  if ($3) { window -hl $3 }
  if ($4) { window -hl $4 }
  if ($5) { window -hl $5 }
  if ($6) { window -hl $6 }
  if ($7) { window -hl $7 }
  if ($8) { window -hl $8 }
  if ($9) { window -hl $9 }
}
; $_randtok(text,C)
alias -l _randtok {
  if ($numtok($1,$2)) { return $gettok($1,$rand(1,$ifmatch),$2) }
  return
}
alias -l _rmdir {
  if ($isid) { return }
  var %l
  tokenize 32 $_fixdir($remove($replace($iif(*\ iswm $1-,$left($1-,-1),$1-),/,\,\\,\),"))
  if ($isdir($1-) == $false) { return }
  _dummy $findfile($1-,*,0,_rmdir.remove $1-)
  window -hkls @_rmdir
  clear @_rmdir
  aline @_rmdir $1-
  _dummy $finddir($1-,*,0,@_rmdir)
  while ($line(@_rmdir,0)) {
    %l = $ifmatch
    _dummy $findfile($line(@_rmdir,%l),*,0,_rmdir.remove $1-)
    .rmdir " $+ $line(@_rmdir,%l) $+ "
    dline @_rmdir %l
  }
  close -@ @_rmdir
}
alias -l _rmdir.remove {
  .remove " $+ $1- $+ "
}
alias -l _fixdir {
  var %dir = $1,%flags = $2
  %dir = $remove($replace(%dir,/,\),")
  while (\\ isin %dir) { %dir = $replace(%dir,\\,\) }
  if (?:\* iswm %dir) {  }
  elseif (?:* iswm %dir) { %dir = $left(%dir,2) $+ \ $+ $right(%dir,-2) }
  elseif (\* iswm %dir) { %dir = $left($mircdir,2) $+ %dir }
  else { %dir = $mircdir $+ %dir }
  if ($len($remove(%dir,*,?,<,>,|)) < $len(%dir)) || ($count(%dir,:) > 1) { %dir = $left(%dir,3) $+ $right(%dir,-3) }
  if  (%dir == $null) { return }
  if (e isincs %flags) && ($_not($isdir(%dir))) { return }
  if (m isincs %flags) && ($mircdir* iswm %dir) { return $remove(%dir,$mircdir) }
  return %dir
}
alias -l _not {
  if ($1-) { return 0 }
  return 1
}
alias -l _dummy { return $1- }
; $_nsingoplur(N,singular,plural)
alias -l _nsingoplur { return $1 $iif($1 == 1,$2,$3) }
alias -l _singoplur { return $iif($1 == 1,$2,$3) }

alias -l _yesno {
  unset %c.dyesno.*
  %c.dyesno.yes = %c.onfoff.yes
  %c.dyesno.no = %c.onfoff.no
  unset %c.onfoff.*
  if (%c.dyesno.yes == $null) { %c.dyesno.yes = &Yes }
  if (%c.dyesno.no == $null) { %c.dyesno.no = &No }
  var %i,%d
  while (1) {
    inc %i
    %d = yesno $+ %i
    if ($dialog(%d) == $null) { break }
  }
  if ($count($4-,<CRLF>) == 0) { %c.dyesno.text = $crlf $+ $_evaltext($4-) }
  else { %c.dyesno.text = $_evaltext($4-) }
  %c.dyesno.title = $2
  if ($3) { inc %c.dyesno.def }
  if ($dialog(%d,yesno,-4) != $null) { return $ifmatch }
  unset %c.dyesno.*
  if ($1) { halt }
}
dialog yesno {
  size -1 -1 202 42
  option type dbu

  text "",1,5 2 190 23,center

  button %c.dyesno.yes,241,46 24 33 15,ok
  button %c.dyesno.no,242,83 24 33 15
  button "&Cancel",243,122 24 33 15,cancel

  edit "1",248,1 1 1 1,hide result
}
ON *:DIALOG:yesno*:init:0:{
  _mdx.init $_icofile(question.ico)
  if (%c.dyesno.title != $null) { dialog -t $dname $ifmatch }
  if (%c.dyesno.text != $null) { did -o $dname 1 1 $ifmatch }
  if (%c.dyesno.def) { did -f $dname 242 }
  else { did -f $dname 241 }
  unset %c.dyesno.*
}
ON *:DIALOG:yesno*:sclick:241:{ ^playthemesound OK }
ON *:DIALOG:yesno*:sclick:242:{
  did -o $dname 248 1 0
  dialog -k $dname
}
ON *:DIALOG:yesno*:sclick:243:{ ^playthemesound CANCEL }
alias -l _parameter {
  if ($_parameter.edit($4,0,$1)) {
    unset %c.dparm.*
    return $_parameter.return($4,$1)
  }
  var %i,%d
  while (1) {
    inc %i
    %d = parameter $+ %i
    if ($dialog(%d) == $null) { break }
  }
  if ($1 != $null) {
    %c.dparm.default = $ifmatch
    %c.dparm.invalid = $numtok($ifmatch,32)
  }
  else { %c.dparm.default = $5 }
  ;  %c.dparm.default = $replace(%c.dparm.default,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32))
  %c.dparm.need = $2
  if ($count($6-,<CRLF>) == 0) { %c.dparm.texto = $crlf $+ $replace($6-,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32)) }
  else { %c.dparm.texto = $replace($6-,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32)) }
  %c.dparm.cond = $4
  %c.dparm.title = $3
  if ($dialog(%d,$iif(%c.dparm.pass,parameterPASS,parameter),-4) != $null) { return $_parameter.return($4,$ifmatch) }
  unset %c.dparm.*
  if ($2) { halt }
}
alias -l _parameterpass {
  %c.dparm.pass = 1
  return $_parameter($1,$2,$3,$4,$5,$6)
}
alias -l _param { return $_parameter($null,1,$null,$1,$2,$3) }
alias -l _parampass { return $_parameterpass($null,1,$null,$1,$2,$3) }
alias -l _param1 { return $_parameter($null,0,$null,$1,$2,$3) }
alias -l _parampass1 { return $_parameterpass($null,0,$null,$1,$2,$3) }
alias -l _parameter.return {
  var %1 = $gettok($1,1,32),%2 = $gettok($1,2,32),%3 = $gettok($1,3,32)
  if (%1 == replace) { return $replace($_text($2-),$chr(%2),$chr(%3)) }
  return $2-
}
alias -l _parameter.edit {
  if ($3- == $null) {
    if ($2) { goto 1 }
    goto 0
  }
  elseif ($istok(normal,$1,32)) { goto 1 }
  elseif ($1 isnum) {
    if ($numtok($3-,32) == $1) { goto 1 }
    goto 0
  }
  elseif (alias:* iswm $gettok($1,1,32)) {
    var %alias -l = $gettok($gettok($1,1,32),2-,58)
    if ($isalias(%alias)) {
      _result2null
      %alias -l $3-
      if ($result) { goto 1 }
      goto 0
    }
    goto 1
  }
  else {
    var %alias -l =  $+ $gettok($1,1,32)
    if ($isalias(%alias)) {
      %_parm.edit = $1
      _result2null
      %alias -l $3-
      unset %_parm.edit
      if ($result) { goto 1 }
      goto 0
    }
    goto 1
  }
  :0
  if (param* iswm $dname) || (selec* iswm $dname) || (rparam* iswm $dname) {
    did -b $dname 241
    did -o $dname 249 2 0
    did -r $dname 200
  }
  else { return 0 }
  goto end
  :1
  if (param* iswm $dname) || (selec* iswm $dname) || (rparam* iswm $dname) {
    did -e $dname 241
    did -o $dname 249 2 1
    did -r $dname 200
  }
  else { return 1 }
  :end
  if ($devent != init) && (param* iswm $dname) { did -f $dname 2 }
}
alias -l isvalidfilename { if ($_isvalidfilename($1-) != $null) { return 1 } }
alias -l len {
  var %2 = $gettok(%_parm.edit,2,32),%3 = $gettok(%_parm.edit,3,32)
  if ($len($1-) %2 %3) { return 1 }
}
alias -l len1 {
  var %2 = $gettok(%_parm.edit,2,32),%3 = $gettok(%_parm.edit,3,32)
  if ($0 == 1) && ($len($1-) %2 %3) { return 1 }
}
dialog parameter {
  size -1 -1 200 58
  option type dbu

  text "",1,10 3 180 23
  edit "",2,10 24 180 11,autohs result

  text "",200,10 40 94 15

  button "&OK",241,114 40 33 15,ok disable
  button "&Cancel",242,157 40 33 15,cancel

  edit "",248,1 1 1 1,hide
  edit "",249,1 1 1 1,hide
  edit "",250,1 1 1 1,hide
}
dialog parameterPASS {
  size -1 -1 200 58
  option type dbu

  text "",1,10 3 180 23
  edit "",2,10 24 180 11,autohs pass result

  text "",200,10 40 94 15

  button "&OK",241,114 40 33 15,ok disable
  button "&Cancel",242,157 40 33 15,cancel

  edit "",248,1 1 1 1,hide
  edit "",249,1 1 1 1,hide
  edit "",250,1 1 1 1,hide
}
ON *:DIALOG:parameter*:init:0:{
  _mdx.init $_icofile(question.ico)
  if (%c.dparm.title) { dialog -t $dname $ifmatch }
  did -a $dname 1 %c.dparm.texto
  did -o $dname 250 1 %c.dparm.cond
  if (%c.dparm.default != $null) { did -o $dname 2 1 $ifmatch }
  did -o $dname 248 1 $iif(%c.dparm.need,0,1)
  if ($_parameter.edit($did(250),$did(248),$did(2))) { }
  if (%c.dparm.invalid) {
    did -o $dname 200 1 Invalid $_singoplur($ifmatch,parameter,parameters) $+ : %c.dparm.default
    ^playthemesound ERROR
  }
  unset %c.dparm.*
  did -c $dname 2 1 1 99999999999999999999
}
ON *:DIALOG:parameter*:edit:*:{ return $_parameter.edit($did(250),$did(248),$did(2)) }
ON *:DIALOG:parameter*:sclick:241:{
  if ($did($dname,248)) && ($did(2) == $null) { }
  elseif ($did($dname,249) == 0) {
    did -o $dname 200 1 Invalid $_singoplur($numtok($did(2),32),parameter,parameters)
    ^playthemesound ERROR
    halt
  }
  ^playthemesound OK
}
alias -l _rparameter {
  if ($_parameter.edit($4,0,$1)) {
    unset %c.drparm.*
    return $_parameter.return($4,$1)
  }
  var %i,%d
  while (1) {
    inc %i
    %d = rparameter $+ %i
    if ($dialog(%d) == $null) { break }
  }
  if ($1 != $null) {
    %c.drparm.default = $ifmatch
    %c.drparm.invalid = $numtok($ifmatch,32)
  }
  else { %c.drparm.default = $5 }
  ;  %c.drparm.default = $replace(%c.drparm.default,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32))
  %c.drparm.need = $2
  if ($count($8-,<CRLF>) == 0) { %c.drparm.texto = $crlf $+ $replace($8-,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32)) }
  else { %c.drparm.texto = $replace($8-,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32)) }
  %c.drparm.cond = $4
  %c.drparm.title = $3
  %c.drparm.list = $6
  %c.drparm.chan = $7
  if ($dialog(%d,rparameter,-4) != $null) { return $_parameter.return($4,$ifmatch) }
  unset %c.drparm.*
  if ($2) { halt }
}
alias -l _rparam { return $_rparameter($null,1,$null,$1,$2,$3,$4,$5) }
dialog rparameter {
  size -1 -1 200 58
  option type dbu

  text "",1,10 3 180 23
  combo 2,10 27 180 100,drop edit result

  text "",200,10 40 75 15

  button "&Clear list",240,87 40 33 15
  button "&OK",241,122 40 33 15,ok disable
  button "&Cancel",242,157 40 33 15,cancel

  edit "",247,1 1 1 1,hide
  edit "",248,1 1 1 1,hide
  edit "",249,1 1 1 1,hide
  edit "",250,1 1 1 1,hide
}
ON *:DIALOG:rparameter*:init:0:{
  _mdx.init $_icofile(question.ico)
  var %file,%winfrom = @__rparameter,%i,%n
  ^playthemesound QUESTION
  if (%c.drparm.title) { dialog -t $dname $ifmatch }
  did -a $dname 1 %c.drparm.texto
  did -o $dname 250 1 %c.drparm.cond
  _openwins %winfrom
  if (@* iswm %c.drparm.list) {
    if ($window(%c.drparm.list)) { filter -ww %c.drparm.list %winfrom * }
  }
  else {
    %file = $_recent.file(%c.drparm.list)
    if ($isfile(%file)) {
      loadbuf %winfrom $"(%file)
      did -o $dname 247 1 %file
    }
  }

  if (%c.drparm.chan == $null) && (%c.drparm.default == $null) { _win2dialog %winfrom $dname 2 * }
  else {
    var %i = 1,%n = $line(%winfrom,0)
    while (%i <= %n) {
      if (%c.drparm.chan != $null) {
        if ($replace($line(%winfrom,%i),<CHAN>,%c.drparm.chan) != %c.drparm.default) { did -a $dname 2 $ifmatch }
      }
      else {
        if ($line(%winfrom,%i) != %c.drparm.default) { did -a $dname 2 $ifmatch }
      }
      inc %i
    }
  }
  close -@ %winfrom

  if (%c.drparm.default != $null) { did -i $dname 2 1 $ifmatch }
  did -o $dname 248 1 $iif(%c.drparm.need,0,1)
  if ($_parameter.edit($did(250),$did(248),$did(2,1))) { }
  if (%c.drparm.invalid) {
    did -o $dname 200 1 Invalid $_singoplur($ifmatch,parameter,parameters) $+ : %c.drparm.default
    ^playthemesound ERROR
  }
  unset %c.drparm.*
  did -c $dname 2 1 1 99999999999999999999
}
ON *:DIALOG:rparameter*:*:2:{
  return $_parameter.edit($did(250),$did(248),$did(2))
}
ON *:DIALOG:rparameter*:sclick:240:{
  var %file = $did($dname,247,1)
  if (%file != $null) && (@* !iswm %file) {
    if ($isfile(%file)) { .remove " $+ %file $+ " }
  }
}
ON *:DIALOG:rparameter*:sclick:241:{
  if ($did($dname,248)) && ($did(2) == $null) { }
  elseif ($did($dname,249) == 0) {
    did -o $dname 200 1 Invalid $_singoplur($numtok($did(2),32),parameter,parameters)
    ^playthemesound ERROR
    halt
  }
  ^playthemesound OK
}
alias -l _result2null { return $null }
alias -l _isvalidfilename { return $iif((/ !isin $1-) && (\ !isin $1-) && (: !isin $1-) && (* !isin $1-) && (? !isin $1-) && (" !isin $1-) && (< !isin $1-) && (> !isin $1-) && (| !isin $1-),$1-) }
alias -l _win2dialog {
  if ($window($1) == $null) || ($dialog($2) == $null) { return }
  filter -wo $1 $2 $3 $iif($4- != $null,$4-,*)
}
alias -l _getsetup { return $readini -n " $+ $scriptdirtaboftp.ini $+ " " $+ $1 $+ " $2 }
alias -l _setsetup {
  if ($1 == $null) || ($2 == $null) { }
  if ($3- == $null) { .remini " $+ $scriptdirtaboftp.ini $+ " " $+ $1 $+ " $2 }
  else { .writeini " $+ $scriptdirtaboftp.ini $+ " " $+ $1 $+ " $2- }
  .flushini $scriptdirtaboftp.ini
}
alias -l _chfile {
  var %file = $remove($1-,")
  if ($isfile(%file) == $false) { write -c " $+ %file $+ " }
  return %file
}


;;; LISTS
alias -l _filelist.file {
  var %file = $scriptdirtaboftp_ $+ $gettok($gettok($2,1,46),-1,95) $+ $iif(l* iswm $1,.tfl,.tfr)
  return $_chfile(%file)
}
alias -l _filelist.tablename { return _taboftp $+ $iif(l* iswm $1,lists,recent) $+ _ $+ $2 }
alias -l _filelist.hash {
  var %h = $_filelist.tablename($1,$2),%file = $_filelist.file($1,$2)
  _hmake %h 10
  hload -n %h " $+ %file $+ "
}
alias -l _filelist.add {
  if ($2 == $null) || ($3 !isnum) || ($3 < 0) || ($4- == $null) { return }
  var %file = $shortfn($_filelist.file($1,$2)),%win = @__filelistadd,%i,%l
  _openwins %win
  loadbuf %win %file
  %i = $fline(%win,$4-,0,0)
  while (%i) {
    %l = $fline(%win,$4-,%i,0)
    if ($line(%win,%l) == $4-) { dline %win %l }
    dec %i
  }
  iline %win 1 $4-
  if ($3 > 0) { savebuf 1- $+ $3 %win %file }
  else { savebuf %win %file }
  close -@ %win
  _filelist.hash $1 $2 %file
  return 1
}
alias -l _filelist.ladd {
  if ($2 == $null) || ($3 !isnum) || ($3 < 0) || ($4- == $null) { return }
  var %file = $shortfn($_filelist.file($1,$2)),%win = @__filelistladd,%i,%l
  _openwins %win
  loadbuf %win %file
  %i = $fline(%win,$4-,0,0)
  while (%i) {
    %l = $fline(%win,$4-,%i,0)
    if ($line(%win,%l) == $4-) { dline %win %l }
    dec %i
  }
  aline %win $4-
  if ($3 > 0) { savebuf 1- $+ $3 %win %file }
  else { savebuf %win %file }
  close -@ %win
  _filelist.hash $1 $2 %file
  return $_filelist.total($1,$2)
}
alias -l _filelist.del {
  if ($2 == $null) || ($3- == $null) { return }
  var %file = $shortfn($_filelist.file($1,$2)),%win = @__filelistdel,%i,%l,%deleted = 0
  _openwins %win
  loadbuf %win %file
  %i = $fline(%win,$3-,0,0)
  while (%i) {
    %l = $fline(%win,$3-,%i,0)
    if ($line(%win,%l) == $3-) {
      dline %win %l
      inc %deleted
    }
    dec %i
  }
  savebuf %win %file
  close -@ %win
  _filelist.hash $1 $2 %file
  return %deleted
}
alias -l _filelist.flush {
  var %file = $shortfn($_filelist.file($1,$$2)),%lines = $lines(%file)
  write -c %file
  if ($show) { info.a Cleared list }
  _filelist.hash $1 $2 %file
  return %lines
}
alias -l _filelist.get { return $hget($_filelist.tablename($1,$2),$3) }
alias -l _filelist.fileget { return $read -nl $+ $3 " $+ $_filelist.file($1,$$2) $+ " }
alias -l _filelist.total { return $lines($shortfn($_filelist.file($1,$2))) }
alias -l _filelist.tokadd {
  var %i = 1,%file = $shortfn($_filelist.file($1,$2))
  while ($_filelist.fileget($1,$2,%i) != $null) {
    if ($gettok($ifmatch,$3,$4) === $5-) {
      if (%i) { return $ifmatch }
    }
    inc %i
  }
  if ($lines(%file) > 0) { return $calc($ifmatch + 1) }
  return 1
}
alias -l _filelist.tokdel {
  var %i = 1,%file = " $+ $_filelist.file($1,$2) $+ "
  while ($_filelist.fileget($1,$2,%i) != $null) {
    if ($gettok($ifmatch,$3,$4) == $5-) {
      write -dl $+ %i %file
      break
    }
    inc %i
  }
  _filelist.hash $1 $2 %file
}
alias -l _filelist.moveup {
  var %file = " $+ $_filelist.file($1,$2) $+ ",%i = $read -nl $+ $3 %file
  if ($3 <= 1) { return }
  write -l $+ $3 %file $read -nl $+ $calc($3 - 1) %file
  write -l $+ $calc($3 - 1) %file %i
  _filelist.hash $1 $2 %file
}
alias -l _filelist.movedown {
  var %file = " $+ $_filelist.file($1,$2) $+ ",%i = $read -nl $+ $3 %file
  if ($3 >= $lines(%file)) { return }
  write -l $+ $3 %file $read -nl $+ $calc($3 + 1) %file
  write -l $+ $calc($3 + 1) %file %i
  _filelist.hash $1 $2 %file
}
alias -l _filelist.findline {
  if ($2 == $null) || ($3- == $null) { return }
  var %file = $shortfn($_filelist.file($1,$2)),%win = @__filelistfindline,%i,%l,%found
  _openwins %win
  loadbuf %win %file
  %i = $fline(%win,$3-,0,0)
  while (%i) {
    %l = $fline(%win,$3-,%i,0)
    if ($line(%win,%l) == $3-) {
      %found = %l
      break
    }
    dec %i
  }
  close -@ %win
  _filelist.hash $1 $2 %file
  return %found
}

;;
;
; $_recent.tablename(<type>)
; /_recent.add <type> <max> <text>
; /_recent.ladd <type> <max> <text>
; /_recent.del <type> <text>
; /_recent.flush <type>
; $_recent.file(<type>)
; $_recent.get(type,n)
; $_recent.total(type)
; /_recent.tokadd type N token text
; /_recent.tokdel type N token text
; /_recent.moveup type N
; /_recent.movedown type N
; $_recent.findline(type,text)
;
alias -l _recent.tablename { return $_filelist.tablename(r,$1) }
alias -l _recent.add { return $_filelist.add(r,$1,$2,$3-) }
alias -l _recent.ladd { return $_filelist.ladd(r,$1,$2,$3-) }
alias -l _recent.del { return $_filelist.del(r,$1,$2-) }
alias -l _recent.flush {
  _filelist.flush r $1
  return $result
}
alias -l _recent.file { return $_filelist.file(r,$1) }
alias -l _recent.get { return $_filelist.get(r,$1,$2) }
alias -l _recent.total { return $_filelist.total(r,$1) }
alias -l _recent.tokadd { return $_filelist.tokadd(r,$1,$2,$3,$4-) }
alias -l _recent.tokdel { return $_filelist.tokdel(r,$1,$2,$3,$4-) }
alias -l _recent.moveup { return $_filelist.moveup(r,$1,$2) }
alias -l _recent.movedown { return $_filelist.movedown(r,$1,$2) }
alias -l _recent.findline { return $_filelist.findline(r,$1,$2-) }
alias -l _recent.hash { return $_filelist.hash(r,$1,$2) }
;
;
; $_list.tablename(<type>)
; /_list.add <type> <text>
; /_list.ladd <type> <text>
; /_list.del <type> <text>
; /_list.flush <type>
; $_list.file(<type>)
; $_list.get(type,n)
; $_list.total(type)
; /_list.tokadd type N token text
; /_list.tokdel type N token text
; /_list.moveup type N
; /_list.movedown type N
; $_list.findline(type,text)
;
alias -l _list.tablename { return $_filelist.tablename(l,$1) }
alias -l _list.add { return $_filelist.add(l,$1,0,$2-) }
alias -l _list.ladd { return $_filelist.ladd(l,$1,0,$2-) }
alias -l _list.del { return $_filelist.del(l,$1,$2-) }
alias -l _list.flush {
  _filelist.flush l $1
  return $result
}
alias -l _list.file { return $_filelist.file(l,$1) }
alias -l _list.get { return $_filelist.get(l,$1,$2) }
alias -l _list.total { return $_filelist.total(l,$1) }
alias -l _list.tokadd { return $_filelist.tokadd(l,$1,$2,$3,$4-) }
alias -l _list.tokdel { return $_filelist.tokdel(l,$1,$2,$3,$4-) }
alias -l _list.moveup { return $_filelist.moveup(l,$1,$2) }
alias -l _list.movedown { return $_filelist.movedown(l,$1,$2) }
alias -l _list.findline { return $_filelist.findline(l,$1,$2-) }
alias -l _list.hash { return $_filelist.hash(l,$1,$2) }
alias -l error.a { echo $colour(ctcp) -eiqst *** ERROR: $1- }
alias -l info.a { echo $colour(info) -eiqst *** $1- }
alias -l ^playthemesound { }
alias -l _evaltext { return $replace($1-,<CRLF>,$crlf) }
alias -l `ifmm {
  if ($1) { return > }
  return -
}
alias -l `bl {
  if ($_recent.get($1,1) != $null) { return &clear list... }
}
