;/*******************************************************************************************
; *
; * tabo IRC Client - Support File
; *
; *******************************************************************************************/
;
alias _taboirc._showerror.a {
  echo $colour(ctcp) -aeit $^error($1-)
  beep
}
alias _taboirc._dummy { return $1- }

; $_taboirc._text(text)
alias _taboirc._text { return $1- }

alias _taboirc._not {
  if ($1) { return 0 }
  return 1
}

; $_taboirc._isint(number)
alias _taboirc._isint  {
  if ($1- isnum) && ($1 > 0) { return $int($1) }
}

; $_taboirc._mini(section,item)
alias _taboirc._mini { return $readini -n " $+ $mircini $+ " $1 $2 }

; $_taboirc._mini(n,token)
alias _taboirc._minio {
  var %t = n $+ $remove($1,n)
  return $gettok($_taboirc._mini(options,%t),$2,44)
}

; $_taboirc._ishost(host)
alias _taboirc._ishost {
  if ($_taboirc._isint($remove($1,.))) && ($_taboirc._not($_taboirc._isip($1))) { return }
  if ($__taboirc._ishost($1-)) { return $1 }
}

; $_taboirc._isip(ip)
alias _taboirc._isip {
  if ($__taboirc._ishost($1-)) && ($numtok($1,46) == 4) && ($gettok($1,1,46) isnum 0-255) && ($gettok($1,2,46) isnum 0-255) && ($gettok($1,3,46) isnum 0-255) && ($gettok($1,4,46) isnum 0-255) { return $1 }
}

alias __taboirc._ishost {
  if ($1- == $1) && ($1- != #$1) && (.* !iswm $1) && (*. !iswm $1) && (.. !isin $1) && ($len($remove($1,.))) && ($len($remove($1,@,$chr(44),:,?,*,/,<,>,[,])) == $len($1)) { return $1 }
}

; $_taboirc._ischan(channel)
alias _taboirc._ischan {
  if ($left($1-,1) isin !#&+) && ($chr(32) !isin $1-) && ($chr(44) !isin $1-) && ($right($1-,-1) != $null) { return $1- }
}

alias _taboirc._sockmark {
  if ($2 == $null) && ($sockname) { return $gettok($sock($sockname).mark,$1,9) }
  return $gettok($sock($1).mark,$2,9)
}

alias _taboirc._duratio { return $_taboirc._duration($1-) }
alias _taboirc._duration {
  return $remove($duration($1-),ecs,ec,ins,in,rs,r,ays,ay,ks,k)
}

; $_taboirc._percent(number,number,[floating point number],[no "%"])
;   defaults: (floating pont: 0) (Show "%")
alias _taboirc._percent { return $iif(($1 == 0) || ($2 == 0) || ($1 !isnum) || ($2 !isnum),0,$round($calc($1 * 100 / $2),$iif(($3 isnum) && ($3 >= 0),$3,0))) $+ $iif($_taboirc._not($4),%) }

; $_taboirc._fixfilename(filename)
; If filename is invalid, returns $null
; $1 - Filename
; $2 - flags
;        f - If filename has invalid characters, replace them with "_"
;        n - Don't bother for invalid filenames
;        e - If file doesn't exist, returns $null
;        m - If file isin $mircdir, removes $mircdir
alias _taboirc._fixfilename {
  var %f = $2,%err1 = 0,%err2 = 0
  tokenize 32 $remove($replace($1,/,\,\\,\),")
  if (?:\* iswm $1-) { tokenize 32 $1- }
  elseif (?:* iswm $1-) { tokenize 32 $left($1-,2) $+ \ $+ $right($1-,-2) }
  elseif (\* iswm $1-) { tokenize 32 $left($mircdir,2) $+ $1- }
  else { tokenize 32 $mircdir $+ $1- }
  if ($len($remove($1-,*,?,<,>,|)) < $len($1-)) || ($count($1-,:) > 1) {
    if (f isincs %f) { tokenize 32 $left($1-,3) $+ $right($1-,-3) }
    else { %err1 = 1 }
  }
  if  ($nopath($1-) == $null) { %err2 = 1 }
  if (%err1) || (%err2) { return }
  if (e isincs %f) && ($_taboirc._not($isfile($1-))) { return }
  if (m isincs %f) && ($mircdir* iswm $1-) { return $remove($1-,$mircdir) }
  return $1-
}
alias _taboirc._closesocket {
  if ($sock($1)) {
    sockclose $1
    if ($2 != $null) { echo -s $2- }
  }
}
alias _taboirc._inifont2winfont {
  tokenize 32 $1-
  var %win = $1,%size = $2,%font = $3-,%bold
  if (%size > 700) {
    dec %size 700
    %bold = -b
  }
  if (%size > 400) { dec %size 400 }
  font %bold %win %size %font
}

; $_taboirc._nospaces(text)
alias _taboirc._nospaces { return $remove($1-,$chr(32)) }

alias _taboirc._window.ciright {
  if ($mouse.lb) && ($sline($active,1) != $null) && ($1 != $null) { return $1- }
}
alias _taboirc._window.cileft {
  if ($_taboirc._not($mouse.lb)) && ($1 != $null) { return $1- }
}

; $_taboirc._inputcom(chr,string)
alias _taboirc._inputcom {
  var %i = 1
  while ($mid($2-,%i,1) == $1) { inc %i }
  return $mid($2-,%i)
}

alias _taboirc._sockerr {
  if ($sockerr == 3) { return Connection refused }
  if ($sockerr == 4) { return No Route to Host }
  if ($sockerr) { return $sockerr }
}

; $_taboirc._chanevent(event,chan)
;
;   event: joins parts quits modes topics ctcps nicks kicks
;   returns:
;     0 = on channel
;     1 = in status
;     2 = hide
alias _taboirc._chanevent {
  var %tc,%tg,%r,%t = $findtok(joins parts quits modes topics ctcps nicks kicks,$1,32)
  if ($2 != $null) && ($_taboirc._mini(events,$2) != $null) { %tc = $gettok($ifmatch,%t,44) }
  if (%tc > 0) { %r = %tc - 1 }
  else { %r = $gettok($_taboirc._mini(events,default),%t,44) }
  return %r
}
alias _taboirc._snoticefilter {
  var %server = $1,%me = $2,%line = $3-,%filters
  tokenize 32 %line
  if ($strip($1-3) == *** Notice --) { tokenize 32 $4- }
  elseif ($strip($1) == ***) { tokenize 32 $2- }
  return $^snotice.default(%server,$1-)
}

; $_taboirc._order(string,[1|0])
;   Orders a string of characters.
;   If $2 , removes duplicated characters.
alias _taboirc._order {
  var %s,%r,%win = @__taboirc._order
  window -c %win
  window -hs %win
  var %i = $len($1)
  while (%i) {
    if ($mid($1,%i,1) != $chr(32)) { aline %win $ifmatch }
    dec %i
  }
  var %i = 1,%t = $line(%win,0)
  while (%i <= %t) {
    %s = $line(%win,%i)
    if ($2) { %r = $remove(%r,%s) }
    if (%r == $null) { var %r }
    %r = %r $+ %s
    inc %i
  }
  window -c %win
  return %r
}

; $_taboirc._fixchans(channel1,channel2,channel3,...)
alias _taboirc._fixchans {
  if ($1- == $null) { return }
  var %t = $replace($1-,$chr(32),$chr(44)),%r,%i = $numtok(%t,44)
  while (%i) {
    tokenize 32 $gettok(%t,%i,44)
    %r = $addtok(%r,#$1,44)
    dec %i
  }
  return %r
}

; $_taboirc._evaltext(text)
alias _taboirc._evaltext {
  var %i = 1,%t,%b,%r = $replace($1-,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32),<VER>,$ver,<VERS>,$vers,<VERT>,taboIRC[0.9],<VERIN>,$_taboirc._verinf,<VERINF>,$_taboirc._verinf,<AIRCWEB>,http://members.xoom.com/tabo/,<YO>,$me,<ME>,$me,<#>,#,<CHAN>,$chan,<NICK>,$nick)
  if (<% !isin %r) && (<$ !isin %r) && (<& !isin %r) { return %r }
  while ($gettok(%r,%i,60) != $null) {
    if (> isin $ifmatch) {
      if (<% !isin %r) && (<$ !isin %r) && (<& !isin %r) { return %r }
      %t = $gettok($gettok(%r,%i,60),1,62)
      if (< isin %t) || ($istok(36 37 38,$asc($left(%t,1)),32) == $false) {
        inc %i
        continue
      }
      var %b = < $+ %t $+ >,%r = $replace(%r,%b,$__taboirc._evaltext(%t)),%i
    }
    inc %i
  }
  return %r
}
alias __taboirc._evaltext { return [ [ $1- ] ] }

; $_taboirc._bracket(text)
alias _taboirc._bracket {
  if ($1- != $null) { return [[ $+ $1- $+ ]] }
}

; $_taboirc._singoplur(N,singular,plural)
alias _taboirc._singoplur { return $iif($1 == 1,$2,$3) }

; $_taboirc._color(name)
alias _taboirc._color { return  $+ $iif($colour($1) < 10,0) $+ $colour($1) }

alias _taboirc._server {
  if ($server != $null) {
    if ($gettok($_taboirc._mini(mirc,host),2,58) != $null) { return $ifmatch }
  }
}
alias _taboirc._dialog {
  if ($dialog($2)) { dialog -v $2 }
  else { dialog $1-3 }
}
alias _taboirc._whoisextra.get {
  var %var = =whois.extra. $+ $1,%line = % [ $+ [ %var ] ]
  if (r* iswm $2) { return $gettok(%line,1,32) }
  return $gettok(%line,2-,32)
}
alias _taboirc._whoisextra.add {
  var %i = 1
  while ($_taboirc._whoisextra.get(%i,raw)) { inc %i }
  set %=whois.extra. $+ %i $1-
}
alias _taboirc.`channel {
  if ($gettok($_taboirc._recent.get(channel,$1),1,32) != $null) { return $iif($1 == 10,1&0,& [ $+ [ $1 ] ] ) $replace($gettok($_taboirc._recent.get(channel,$$1),1,32),&,&&) }
}
alias _taboirc.`bl {
  if ($_taboirc._recent.get($1,1) != $null) { return &clear list... }
}
alias _taboirc.`recent {
  var %t = $_taboirc._recent.get($1,$2)
  if (%t != $null) { return $iif($2 == 10,1&0,& [ $+ [ $2 ] ] ) $replace(%t,&,&&) }
}
;
; $_taboirc.`usermode.net(<mode>,[$usermode],[%.usermodes])
;
alias _taboirc.`usermode.net {
  var %t
  tokenize 32 $$1 $iif($2,$2,$usermode) $iif($3,$3,%.usermodes)
  tokenize 32 $1-2 $iif($3,$3,iwso)
  if ($1 !isincs $3) { return }
  if ($1 === i) { %t = invisible }
  elseif ($1 === w) { %t = wallops }
  elseif ($1 === s) { %t = server notices }
  elseif ($1 === o) { %t = ircop }
  return $iif($1 isincs $2,$`+,$`-) %t $+ $chr(9) $+ $iif($1 isincs $2,+,-) $+ $1
}

;;
;
; $_taboirc._parameter(parameters,required?,title,type,def editbox,text)
;
; 1 - parameters in command
; 2 - 1=required|0=not required
; 3 - title
; 4 - type [$_taboirc._parameter.edit]
; 5 - default editbox
; 6 - text
;
;
alias _taboirc._parameter {
  if ($_taboirc._parameter.edit($4,0,$1)) {
    unset %c.dparm.*
    return $_taboirc._parameter.return($4,$1)
  }
  var %i,%d
  while (1) {
    inc %i
    %d = parameter $+ %i
    if ($dialog(%d) == $null) { break }
  }
  if ($1 != $null) {
    %c.dparm.default = $ifmatch
    %c.dparm.invalid = $numtok($ifmatch,32)
  }
  else { %c.dparm.default = $5 }
  ;  %c.dparm.default = $replace(%c.dparm.default,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32))
  %c.dparm.need = $2
  if ($count($6-,<CRLF>) == 0) { %c.dparm.texto = $crlf $+ $replace($6-,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32)) }
  else { %c.dparm.texto = $replace($6-,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32)) }
  %c.dparm.cond = $4
  %c.dparm.title = $3
  if ($dialog(%d,$iif(%c.dparm.pass,parameterPASS,parameter),-4) != $null) { return $_taboirc._parameter.return($4,$ifmatch) }
  unset %c.dparm.*
  if ($2) { halt }
}
alias _taboirc._parameterpass {
  %c.dparm.pass = 1
  return $_taboirc._parameter($1,$2,$3,$4,$5,$6)
}
alias _taboirc._param { return $_taboirc._parameter($null,1,$null,$1,$2,$3) }
alias _taboirc._parampass { return $_taboirc._parameterpass($null,1,$null,$1,$2,$3) }
alias _taboirc._param1 { return $_taboirc._parameter($null,0,$null,$1,$2,$3) }
alias _taboirc._parampass1 { return $_taboirc._parameterpass($null,0,$null,$1,$2,$3) }
alias _taboirc._parameter.return {
  var %1 = $gettok($1,1,32),%2 = $gettok($1,2,32),%3 = $gettok($1,3,32)
  if (%1 == replace) { return $replace($_taboirc._text($2-),$chr(%2),$chr(%3)) }
  if ($1 == fixchans) { return $_taboirc._fixchans($_taboirc._text($2-)) }
  if ($istok(ischan ismychan,$1,32)) && ($_taboirc._not($_taboirc._ischan($2-))) { return #$2 }
  return $2-
}
alias _taboirc._parameter.edit {
  if ($3- == $null) {
    if ($2) { goto 1 }
    goto 0
  }
  elseif ($istok(normal,$1,32)) { goto 1 }
  elseif ($1 isnum) {
    if ($numtok($3-,32) == $1) { goto 1 }
    goto 0
  }
  else {
    var %alias = _taboirc. $+ $gettok($1,1,32)
    if ($isalias(%alias)) {
      %_parm.edit = $1
      %alias $3-
      unset %_parm.edit
      if ($result) { goto 1 }
      goto 0
    }
    goto 1
  }
  :0
  if (param* iswm $dname) || (selec* iswm $dname) || (rparam* iswm $dname) {
    did -b $dname 241
    did -o $dname 249 2 0
    did -r $dname 200
  }
  else { return 0 }
  goto end
  :1
  if (param* iswm $dname) || (selec* iswm $dname) || (rparam* iswm $dname) {
    did -e $dname 241
    did -o $dname 249 2 1
    did -r $dname 200
  }
  else { return 1 }
  :end
  if ($devent != init) && (param* iswm $dname) { did -f $dname 2 }
}
alias _taboirc.isnum {
  var %2 = $gettok(%_parm.edit,2,32),%3 = $gettok(%_parm.edit,3,32)
  if ($1- !isnum) { return 0 }
  if (%_parm.edit == isnum) { return 1 }
  if (- isin %2) {
    if ($1- isnum %2) { return 1 }
    return 0
  }
  if ($1- %2 %3) { return 1 }
}
alias _taboirc.ischan { if ($0 == 1) && ($numtok($1-,44) == 1) { return 1 } }
alias _taboirc.len {
  var %2 = $gettok(%_parm.edit,2,32),%3 = $gettok(%_parm.edit,3,32)
  if ($len($1-) %2 %3) { return 1 }
}
alias _taboirc.fixchans { return $1- }


alias _taboirc._parmchans {
  var %c,%1,%2
  if ($_taboirc._ischan($7)) { %c = $_taboirc._parameter($7,1,$1,$3,$null,$2) }
  elseif ($active ischan) { %c = # }
  else { %c = $_taboirc._parameter($null,1,$1,$3,$null,$2) }
  if ($4) { %1 = $_taboirc._parameter($8,1,$1,$5,$_activequery,$4) }
  if ($6) { %2 = $9 }
  return %c %1 %2
}
dialog parameter {
  size -1 -1 200 58
  option type dbu

  text "",1,10 3 180 23
  edit "",2,10 24 180 11,autohs result

  text "",200,10 40 94 15

  button "&OK",241,114 40 33 15,ok disable
  button "&Cancel",242,157 40 33 15,cancel

  edit "",248,1 1 1 1,hide
  edit "",249,1 1 1 1,hide
  edit "",250,1 1 1 1,hide
}
dialog parameterPASS {
  size -1 -1 200 58
  option type dbu

  text "",1,10 3 180 23
  edit "",2,10 24 180 11,autohs pass result

  text "",200,10 40 94 15

  button "&OK",241,114 40 33 15,ok disable
  button "&Cancel",242,157 40 33 15,cancel

  edit "",248,1 1 1 1,hide
  edit "",249,1 1 1 1,hide
  edit "",250,1 1 1 1,hide
}
ON *:DIALOG:parameter*:init:0:{
  if (%c.dparm.title) { dialog -t $dname $ifmatch }
  else { dialog -t $dname taboIRC[0.9] }
  did -a $dname 1 %c.dparm.texto
  did -o $dname 250 1 %c.dparm.cond
  if (%c.dparm.default != $null) { did -o $dname 2 1 $ifmatch }
  did -o $dname 248 1 $iif(%c.dparm.need,0,1)
  if ($_taboirc._parameter.edit($did(250),$did(248),$did(2))) { }
  if (%c.dparm.invalid) {
    did -o $dname 200 1 Invalid $_taboirc._singoplur($ifmatch,parameter,parameters) $+ : %c.dparm.default
  }
  unset %c.dparm.*
  did -c $dname 2 1 1 99999999999999999999
}
ON *:DIALOG:parameter*:edit:*:{ return $_taboirc._parameter.edit($did(250),$did(248),$did(2)) }
ON *:DIALOG:parameter*:sclick:241:{
  if ($did($dname,248)) && ($did(2) == $null) { }
  elseif ($did($dname,249) == 0) {
    did -o $dname 200 1 Invalid $_taboirc._singoplur($numtok($did(2),32),parameter,parameters)
    halt
  }
}
;;
;
; $_taboirc._rparameter(parameters,required?,title,type,def editbox,[@]list,channel,text)
;
; 1 - parameters in command
; 2 - 1=required|0=not required
; 3 - title
; 4 - type [$_taboirc._parameter.edit]
; 5 - default editbox
; 6 - [@]list
; 7 - channel
; 8 - text
;
alias _taboirc._rparameter {
  if ($_taboirc._parameter.edit($4,0,$1)) {
    unset %c.drparm.*
    return $_taboirc._parameter.return($4,$1)
  }
  var %i,%d
  while (1) {
    inc %i
    %d = rparameter $+ %i
    if ($dialog(%d) == $null) { break }
  }
  if ($1 != $null) {
    %c.drparm.default = $ifmatch
    %c.drparm.invalid = $numtok($ifmatch,32)
  }
  else { %c.drparm.default = $5 }
  ;  %c.drparm.default = $replace(%c.drparm.default,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32))
  %c.drparm.need = $2
  if ($count($8-,<CRLF>) == 0) { %c.drparm.texto = $crlf $+ $replace($8-,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32)) }
  else { %c.drparm.texto = $replace($8-,<CRLF>,$crlf,<COMMA>,$chr(44),<ESP>,$chr(32)) }
  %c.drparm.cond = $4
  %c.drparm.title = $3
  %c.drparm.list = $6
  %c.drparm.chan = $7
  if ($dialog(%d,rparameter,-4) != $null) { return $_taboirc._parameter.return($4,$ifmatch) }
  unset %c.drparm.*
  if ($2) { halt }
}
alias _taboirc._rparam { return $_taboirc._rparameter($null,1,$null,$1,$2,$3,$4,$5) }
dialog rparameter {
  size -1 -1 200 58
  option type dbu

  text "",1,10 3 180 23
  combo 2,10 27 180 100,drop edit result

  text "",200,10 40 75 15

  button "&Clear list",240,87 40 33 15
  button "&OK",241,122 40 33 15,ok disable
  button "&Cancel",242,157 40 33 15,cancel

  edit "",247,1 1 1 1,hide
  edit "",248,1 1 1 1,hide
  edit "",249,1 1 1 1,hide
  edit "",250,1 1 1 1,hide
}
ON *:DIALOG:rparameter*:init:0:{
  var %file,%winfrom = @__taboirc._rparameter,%i,%n
  if (%c.drparm.title) { dialog -t $dname $ifmatch }
  else { dialog -t $dname taboIRC[0.9] }
  did -a $dname 1 %c.drparm.texto
  did -o $dname 250 1 %c.drparm.cond
  _openwins %winfrom
  if (@* iswm %c.drparm.list) {
    if ($window(%c.drparm.list)) { filter -ww %c.drparm.list %winfrom * }
  }
  else {
    %file = $_taboirc._recent.file(%c.drparm.list)
    if ($isfile(%file)) {
      loadbuf %winfrom $_taboirc."(%file)
      did -o $dname 247 1 %file
    }
  }

  if (%c.drparm.chan == $null) && (%c.drparm.default == $null) { _win2dialog %winfrom $dname 2 * }
  else {
    var %i = 1,%n = $line(%winfrom,0)
    while (%i <= %n) {
      if (%c.drparm.chan != $null) {
        if ($replace($line(%winfrom,%i),<CHAN>,%c.drparm.chan) != %c.drparm.default) { did -a $dname 2 $ifmatch }
      }
      else {
        if ($line(%winfrom,%i) != %c.drparm.default) { did -a $dname 2 $ifmatch }
      }
      inc %i
    }
  }
  _closewins %winfrom

  if (%c.drparm.default != $null) { did -i $dname 2 1 $ifmatch }
  did -o $dname 248 1 $iif(%c.drparm.need,0,1)
  if ($_taboirc._parameter.edit($did(250),$did(248),$did(2,1))) { }
  if (%c.drparm.invalid) {
    did -o $dname 200 1 Invalid $_taboirc._singoplur($ifmatch,parameter,parameters) $+ : %c.drparm.default
  }
  unset %c.drparm.*
  did -c $dname 2 1 1 99999999999999999999
}
ON *:DIALOG:rparameter*:*:2:{
  return $_taboirc._parameter.edit($did(250),$did(248),$did(2))
}
ON *:DIALOG:rparameter*:sclick:240:{
  var %file = $did($dname,247,1)
  if (%file != $null) && (@* !iswm %file) {
    if ($_isfile(%file)) { _remove $ifmatch }
  }
}
ON *:DIALOG:rparameter*:sclick:241:{
  if ($did($dname,248)) && ($did(2) == $null) { }
  elseif ($did($dname,249) == 0) {
    did -o $dname 200 1 Invalid $_taboirc._singoplur($numtok($did(2),32),parameter,parameters)
    halt
  }
}

alias _taboirc._recent.add { return $_taboirc._filelist.add(r,$1,$2,$3-) }
alias _taboirc._recent.flush { return $_taboirc._filelist.flush(r,$1) }
alias _taboirc._recent.get { return $_taboirc._filelist.get(r,$1,$2) }
alias _taboirc._filelist.file {
  var %file = $scriptdir $+ taboirc_ $+ $2 $+ .recent
  return $_taboirc._chfile(%file)
}
alias _taboirc._filelist.add {
  if ($2 == $null) || ($3 !isnum) || ($3 < 0) || ($4- == $null) { return }
  var %file = $_taboirc._filelist.file($1,$2),%win = @__filelistadd,%i,%l
  window -c %win
  window -hl %win
  loadbuf %win $_taboirc."(%file)
  %i = $fline(%win,$4-,0,0)
  while (%i) {
    %l = $fline(%win,$4-,%i,0)
    if ($line(%win,%l) == $4-) { dline %win %l }
    dec %i
  }
  iline %win 1 $4-
  if ($3 > 0) { savebuf 1- $+ $3 %win $_taboirc."(%file) }
  else { savebuf %win $_taboirc."(%file) }
  window -h %win
  return 1
}
alias _taboirc._filelist.flush {
  var %file = $_taboirc._filelist.file($1,$$2),%lines = $lines(%file)
  write -c $_taboirc."(%file)
  if ($show) { echo $colour(info) -aeit $^*** Cleared list }
  return %lines
}
alias _taboirc._filelist.get {
  var %file = $_taboirc._filelist.file($1,$2),%line
  %line = $read -nl $+ $3 %file
  return %line
}
alias _taboirc._lusers.varsnull2zero {
  if (%=lusers.norm == $null) { %=lusers.norm = 0 }
  if (%=lusers.services == $null) { %=lusers.services = 0 }
  if (%=lusers.invisible == $null) { %=lusers.invisible = 0 }
  if (%=lusers.servers == $null) { %=lusers.servers = 0 }
  if (%=lusers.ircops == $null) { %=lusers.ircops = 0 }
  if (%=lusers.unknown == $null) { %=lusers.unknown = 0 }
  if (%=lusers.chans == $null) { %=lusers.chans = 0 }
  if (%=lusers.localusers == $null) { %=lusers.localusers = 0 }
  if (%=lusers.totalusers == $null) { %=lusers.totalusers = 0 }
}
alias _taboirc." { return " $+ $remove($1-,") $+ " }
alias _taboirc._chfile {
  var %file = $remove($1-,")
  if ($isfile(%file) == $false) { write -c $_taboirc."(%file) }
  return %file
}
alias _taboirc.`ifm {
  if ($1 $2 $3) { return $`+ }
  return $`-
}
alias _taboirc.`ifmm {
  if ($1) { return $`+ }
  return $`-
}
alias _taboirc._verinf { return tabo IRC Client 0.9 (http://members.xoom.com/tabo/) }

;
;
;eof
