;##########################################################################;
;                                                                          ;
;                            tabo IRC Client 0.9                           ;
;                                                                          ;
; /irc Syntax: <server> [port] [nick]                                      ;
; /irc without parameters opens dialog (easier than typing a whole address);
;                                                                          ;
;                            tabo@linuxmail.org                            ;
;                       http://members.xoom.com/tabo/                      ;
;                                                                          ;
;                                tabo - 2000                               ;
;                                                                          ;
;##########################################################################;
;
;
;
ON *:LOAD:{
  if ($_taboirc.ikiteru == 0) {
    echo $colour(info) -eist tabo IRC Client 0.9 Loaded!
    _taboirc.help
  }
}
ON *:START:{ _taboirc.ikiteru }
ON me:*:JOIN:#:{ _taboirc._recent.add channel 10 $chan }
ON *:CONNECT:{
  _taboirc._recent.add nick 10 $me
  _taboirc._recent.add server 10 $_taboirc._server $port
}
ON me:*:NICK:{ _taboirc._recent.add nick 10 $newnick }
alias _taboirc.ikiteru {
  if ($version != 5.71) || ($bits != 32) {
    beep
    echo $colour(ctcp) -eist *** ERROR: taboIRC[0.9] is for mIRC32v5.71 only! Unloading...
    beep
    _taboirc.unloadnow
    beep
    return 1
  }
  var %files = taboirc.mrc taboirc_2.mrc taboirc_3.mrc taboirc_4.mrc taboirc_5.mrc taboirc_q.mrc taboirc_th.mrc,%i,%n = $numtok(%files,32),%file
  %i = 1
  while (%i <= %n) {
    %file = $_taboirc.file($gettok(%files,%i,32))
    if ($isfile(%file) == $false) {
      beep
      echo $colour(ctcp) -eist *** ERROR: taboIRC[0.9] has missing files! Please reinstall it! Unloading...
      beep
      _taboirc.unloadnow
      beep
      return 1
    }
    elseif ($script(%file) == $null) { load -rs " $+ %file $+ " }
    inc %i
  }
  unset %+irc.*.*
  return 0
}
alias _taboirc.unloadnow {
  .timer -o 1 0 unload -rs " $+ $_taboirc.file(taboirc.mrc) $+ "
  unload -rs " $+ $_taboirc.file(taboirc_2.mrc) $+ "
  unload -rs " $+ $_taboirc.file(taboirc_3.mrc) $+ "
  unload -rs " $+ $_taboirc.file(taboirc_4.mrc) $+ "
  unload -rs " $+ $_taboirc.file(taboirc_5.mrc) $+ "
  unload -rs " $+ $_taboirc.file(taboirc_q.mrc) $+ "
  unload -rs " $+ $_taboirc.file(taboirc_th.mrc) $+ "
}
alias _taboirc.file { return $scriptdir $+ $1- }

alias _taboirc.help {
  linesep -s
  echo $colour(info) -ist tabo IRC Client 0.9 - HELP
  echo $colour(info) -ist /irc Syntax: <server> [port] [nick]
  echo $colour(info) -ist /irc without parameters opens dialog (easier than typing a whole address)
  echo $colour(info) -ist mail tabo@linuxmail.org for support/bug reports
  echo $colour(info) -ist Visit http://members.xoom.com/tabo/ for more info
  linesep -s
}
alias _taboirc.load {
}

alias _taboirc.unload {
  if ($sock(IRC*)) || ($sock(DCCSEND*)) || ($sock(DCCSEND*)) || ($sock(DCCCHAT*)) || ($sock(DCCCHAT*)) || ($sock(DCCGET*)) {
    _taboirc._showerror.a Please close all IRC and DCC sessions before you try to uninstall the IRC Client.
    return 1
  }
  while ($window(@Status*,1)) { window -c $ifmatch }
  while ($window(@Channel*,1)) { window -c $ifmatch }
  while ($window(@Query*,1)) { window -c $ifmatch }
  while ($window(@DCCCHAT*,1)) { window -c $ifmatch }
  while ($window(@DCCSEND*,1)) { window -c $ifmatch }
  while ($window(@DCCGET*,1)) { window -c $ifmatch }
  var %a $findfile($scriptdir,taboirc_*.recent,0,.remove $1-)
  _taboirc.unloadnow
}
dialog _taboirc.dialog {
  size -1 -1 115 157
  title "taboIRC Client"
  option type dbu

  box "Server",1000,5 5 105 55
  text "Server:",1001,10 15 25 10
  edit "",1002,35 13 70 10,autohs
  text "Port:",1003,10 30 25 10
  edit "",1004,35 28 70 10,autohs
  text "Password:",1005,10 45 25 10
  edit "",1006,35 43 70 10,autohs

  box "User",1010,5 65 105 70
  text "&Full Name:",1011,10 75 25 10
  edit "",1012,35 73 70 10,autohs
  text "E-&Mail:",1013,10 90 25 10
  edit "",1014,35 88 70 10,autohs
  text "&Nickname:",1015,10 105 25 10
  edit "",1016,35 103 70 10,autohs
  text "&Alt Nick:",1017,10 120 25 10
  edit "",1018,35 118 70 10,autohs

  button "Help",2991,5 140 30 15,disable
  button "Connect!",2992,43 140 30 15,ok
  button "Cancel",2993,80 140 30 15,cancel
}
alias _taboirc.dialog { _taboirc._dialog -m _taboirc.dialog _taboirc.dialog }
ON *:DIALOG:_taboirc.dialog:*:*:{
  if ($devent == sclick) && ($did == 2992) { 
    var %d = $dname,%server = $did(%d,1002,1),%port = $did(%d,1004,1),%pass = $did(%d,1006,1),%name = $did(%d,1012,1),%email = $did(%d,1014,1),%nick = $did(%d,1016,1),%anick = $did(%d,1018,1)
    _taboirc._dummy $_taboirc.connect(%server,%port,%pass,%name,%email,%nick,%anick)
  }
  _taboirc.rdialog
}
alias irc {
  var %d = _taboirc.dialog,%server,%port,%pass,%name,%email,%nick,%anick,%tnick1,%tnick2

  %server = $1
  tokenize 32 $int($2) $3-
  if ($_taboirc._not($_taboirc._isint($1))) { tokenize 32 $int($_taboirc._minio(5,11)) $1- }
  %port = $1
  %nick = $2

  %name = $remove($_taboirc._mini(mirc,user),$chr(9))
  if (%name == $null) { %name = taboirc }
  if ($_taboirc._mini(mirc,email) != $null) { %email = $ifmatch }
  else { %email = taboirc@taboirc.com }
  %tnick1 = $_taboirc._mini(mirc,nick)
  %tnick2 = $_taboirc._mini(mirc,anick)

  if (%nick != $null) {
    if (%tnick1 != %nick) { %anick = %tnick1 }
    else { %anick = %tnick2 }
    _taboirc._dummy $_taboirc.connect(%server,%port,%pass,%name,%email,%nick,%anick)
  }
  else {
    if (%server == $null) { %server = $gettok($_taboirc._mini(mirc,host),2,58) }
    %nick = %tnick1
    %anick = %tnick2
    _taboirc._dialog -m %d %d
    did -o %d 1002 1 %server
    did -o %d 1004 1 %port
    did -o %d 1006 1 %pass
    did -o %d 1012 1 %name
    did -o %d 1014 1 %email
    did -o %d 1016 1 %nick
    did -o %d 1018 1 %anick
    _taboirc.rdialog
  }
}
alias _taboirc.connect {
  var %server = $1,%port = $2,%pass = $3,%name = $remove($4,$chr(9)),%email = $5,%nick = $6,%anick = $7,%i = 1,%tmp
  if (%pass == $null) { %pass = $null }
  if ($remove(%email,$chr(9)) != $null) { %email = $ifmatch }
  else { %email = taboirc@taboirc.com }
  if (%name == $null) { %name = taboirc }
  while ($sock(IRC [ $+ [ %i ] ] )) { inc %i }
  if ($window(@Status [ $+ [ %i ] ] ) == $null) { _taboirc.openwin status @Status $+ %i }
  echo $colour(info) -it @Status $+ %i $^*** Connecting to %server ( $+ %port $+ )
  %tmp = +irc.*. $+ %i
  unset % [ $+ [ %tmp ] ]
  sockopen IRC $+ %i %server %port
  sockmark IRC $+ %i %nick $+ $chr(9) $+ %server $+ $chr(9) $+ $null $+ $chr(9) $+ 0 $+ $chr(9) $+ $iif(%pass != $null,%pass,$null) $+ $chr(9) $+ %name $+ $chr(9) $+ $iif(%email != $null,%email,%email) $+ $chr(9) $+ $iif(%anick != $null,%anick,$null) $+ $chr(9) $+ _
}
alias _taboirc.rdialog {
  var %d = _taboirc.dialog
  if ($dialog(%d) == $null) { return }
  if ($_taboirc._not($_taboirc._ishost($did(%d,1002,1)))) || ($_taboirc._not($_taboirc._isint($did(%d,1004,1)))) || ($_taboirc._text($did(%d,1012,1)) == $null) || ($_taboirc._text($did(%d,1014,1)) == $null) || ($_taboirc._text($did(%d,1016,1)) == $null) { did -b %d 2992 }
  else { did -e %d 2992 }
}
alias _taboirc.ircnum {
  if ($sockname) && ($2 == $null) { return $remove($gettok($sockname,1-2,160),$remove($gettok($sockname,1-2,160),1,2,3,4,5,6,7,8,9)) }
  if (@Status* iswm $1) { return $remove($1,@Status) }
  if (@Channel* iswm $1) { return $remove($gettok($1,1,160),@Channel) }
  if (@Query* iswm $1) { return $remove($gettok($1,1,160),@Query) }
  if (@DCCCHAT* iswm $1) { return $remove($gettok($1,1-2,160),@DCCCHAT) }
  if (@DCCSEND* iswm $1) { return $remove($gettok($1,1-2,160),@DCCSEND) }
  if (@DCCGET* iswm $1) { return $remove($gettok($1,1-2,160),@DCCGET) }
  if (@Status* iswm $active) { return $remove($active,@Status) }
  if (@Channel* iswm $active) { return $remove($gettok($active,1,160),@Channel) }
  if (@Query* iswm $active) { return $remove($gettok($active,1,160),@Query) }
  if (@DCCCHAT* iswm $active) { return $remove($gettok($active,1-2,160),@DCCCHAT) }
  if (@DCCSEND* iswm $active) { return $remove($gettok($active,1-2,160),@DCCSEND) }
  if (@DCCGET* iswm $active) { return $remove($gettok($active,1-2,160),@DCCGET) }
}
alias _taboirc.ircnums {
  if ($1) { return IRC $+ $_taboirc.ircnum($1) }
  return IRC $+ $_taboirc.ircnum
}
alias _taboirc.active { return $gettok($active,2,160) }
alias _taboirc.ischan { return $iif(@Channel* iswm $1,1,0) }
alias _taboirc.isquery { return $iif(@Query* iswm $1,1,0) }
alias _taboirc.linick {
  if ($fline($2,$1,1,1)) || ($fline($2,+ [ $+ [ $1 ] ] ,1,1)) || ($fline($2,@ [ $+ [ $1 ] ] ,1,1)) || ($fline($2,. [ $+ [ $1 ] ] ,1,1)) { return $ifmatch }
}
alias _taboirc.Wisowner { return $iif(1.* iswm $line($2,$_taboirc.linick($1,$2),1),1,0) }
alias _taboirc.Wisop {
  var %t = $line($2,$_taboirc.linick($1,$2),1)
  return $iif(2@* iswm %t || 1.* iswm %t,1,0)
}
alias _taboirc.Wisvo { return $iif(3+* iswm $line($2,$_taboirc.linick($1,$2),1),1,0) }
alias _taboirc.snicks {
  if (@Channel* !iswm $active) { return }
  if ($sline($active,0) == 0) { return }
  if ($sline($active,0) == 1) { return $remove($strip($sline($active,1)),.,@,+) }
  var %t = 1,%f
  while ($sline($active,%t) != $null) {
    %f = %f $ifmatch
    inc %t
  }
  return $replace($remove($strip(%f),.,@,+),$chr(32),$chr(44))
}
alias _taboirc.prefixnick {
  var %nick = $1,%chanwin = $2
  if ($_taboirc._minio(2,30)) {
    if ($_taboirc.linick(%nick,%chanwin)) { return $strip($line(%chanwin,$ifmatch,1)) }
  }
  return %nick
}
alias _taboirc.chanmembers2title {
  var %win = $1,%members,%title
  if ($window(%win)) {
    var %members = $line(%win,0,1),%title = $gettok($window(%win).title,2-,32)
    if (%title != $null) && ([+*] * !iswm %title) && ([+*]: * !iswm %title) { titlebar %win [ $+ %members $+ ]: %title }
    else { titlebar %win [[ $+ %members $+ ]] %title }

  }
}
alias _taboirc.param { return $_taboirc._parameter($1,1,taboIRC Client,$2,$3,$4) }
alias _taboirc.busynick { _taboirc.busynick2 $1 $2 $_taboirc._parameter($null,0,taboIRC Client,1,$remove($2,"),Somebody is using the nick [ $remove($2,") ] <COMMA> please choose another:) }
alias _taboirc.busynick2 {
  if ($3 == $null) { _taboirc.busynick $1 $2 }
  else {
    sockwrite -n $1 NICK $3
    sockmark $1 $puttok($sock($1).mark,$3,1,9)
  }
}
alias _taboirc.badnick { _taboirc.badnick2 $1 $2 $_taboirc._parameter($null,0,taboIRC Client,1,$remove($2,"),Invalid nick: [ $remove($2,") ] <COMMA> please choose another:) }
alias _taboirc.badnick2 {
  if ($3 == $null) { _taboirc.busynick $1 $2 }
  else {
    sockwrite -n $1 NICK $3
    sockmark $1 $puttok($sock($1).mark,$3,1,9)
  }
}
alias _taboirc.sw {
  var %sock = IRC $+ $_taboirc.ircnum
  if ($sock(%sock)) { sockwrite -n %sock $1- }
}
alias _taboirc.checkquery {
  var %t = @Query $+ $_taboirc.ircnum $+  $+ $gettok($1,1,33),%t2
  if ($window(%t)) {
    if ($2 != $null) {
      %t2 = @Query $+ $_taboirc.ircnum $+  $+ $2
      renwin %t %t2
      echo $colour(nick) -it %t2 $^nick($gettok($1,1,33),$gettok($1,2,33),$null,$1,$gettok($1,2,64),$2)
    }
    titlebar $iif($2,%t2,%t) ( $+ $gettok($1,2,33) $+ )
  }
}
alias _taboirc.mequit {
  var %i = $window(0),%win,%tmp
  while (%i) {
    %win = $window(%i)
    if ($gettok(%win,1,160) == @Channel [ $+ [ $1 ] ] ) || ($gettok(%win,1,160) == @Query [ $+ [ $1 ] ] ) {
      window -c %win
    }
    dec %i
  }
  %tmp = +irc.*. $+ $1
  unset % [ $+ [ %tmp ] ]
  .timer $+ %tmp off
  %win = @Status $+ $1
  if ($window(%win)) { echo $colour(info) -eit %win $^*** Disconnected }
}
alias _taboirc.mmode {
  var %i = 1
  tokenize 32 $1 $2 $replace($3-,$chr(44),$chr(32))
  while ($gettok($3-,%i,32)) {
    _taboirc.sw MODE $1 $left($2,1) $+ $str($right($2,1),$numtok($gettok($3-, [ %i $+ - $+ [ $calc(%i + 3) ] ] ,32),32)) $gettok($3-, [ %i $+ - $+ [ $calc(%i + 3) ] ] ,32)
    inc %i 4
  }
}
alias _taboirc.usermode {
  var %win
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %win = @Status $+ $1
  if ($window(%win) == $null) { return }
  return $right($left($gettok($window(%win).title,2,32),-1),-1)
}
;
;;
;
; $_taboirc.chan(session|0 or $null for autodetect,N/chan).[property]
;   properties: topic, mode, key, limit, ial, win
;
alias _taboirc.chan {
  var %chan,%wwildcard,%win,%modes,%m,%tmp,%title,%topic,%members,%tmode
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %wwildcard = @Channel $+ $1 $+ *
  if ($2 != $null) {
    if ($2 isnum) {
      if ($2 <= 0) { return $window(%wwildcard,0) }
      else { %win = $window(%wwildcard,$2) }
    }
    elseif (%wwildcard iswm $2) { %win = $2 }
    elseif ($_taboirc._ischan($2)) { %chan = $2 }
  }
  elseif (%wwildcard iswm $active) { %win = $active }
  if (%chan == $null) && (%win != $null) { %chan = $gettok(%win,2,160) }
  %win = @Channel $+ $1 $+ $chr(160) $+ %chan
  if ($window(%win) == $null) { return }
  if ($prop == $null) { return %chan }
  if ($prop == win) { return %win }
  if ($prop == status) { return joined }
  if ($prop == ial) { return $false }
  %title = $window(%win).title
  tokenize 32 %title
  %members = $remove($1,[,],:)
  if (*]: iswm $1) || ([* !iswm $2) { var %modes,%topic = $2- }
  elseif (*]: iswm $2) || (*] iswm $2) { var %modes = $2,%topic = $3- }
  elseif (k isincs $2) && (l isincs $2) { var %modes = $2-4,%topic }
  elseif (k isincs $2) || (l isincs $2) { var %modes = $2-3,%topic }
  else { }
  if ($prop == topic) { return %topic }
  %tmode = $remove($gettok(%modes,1,32),[,],+,:)
  %modes = + $+ %tmode $gettok(%modes,2-,32)
  if ($prop == mode) {
    if (%tmode == $null) { return }
    return %modes
  }
  %m = $gettok(%modes,1,32)
  if ($prop == key) {
    if (k isincs %m) {
      if (l !isincs %m) || ($pos(%m,k) < $pos(%m,l)) { return $gettok(%modes,2,32) }
      return $gettok(%modes,3,32)
    }
  }
  if ($prop == limit) {
    if (l isincs %m) {
      if (k !isincs %m) || ($pos(%m,l) < $pos(%m,k)) { return $gettok(%modes,2,32) }
      return $gettok(%modes,3,32)
    }
  }
}
;
;;
;
; $_taboirc.query(session|0 or $null for autodetect,N/query).[property]
;   properties: address, win
;
alias _taboirc.query {
  var %query,%wwildcard,%win
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %wwildcard = @Query $+ $1 $+ *
  if ($2 != $null) {
    if ($2 isnum) {
      if ($2 <= 0) { return $window(%wwildcard,0) }
      else { %win = $window(%wwildcard,$2) }
    }
    elseif (%wwildcard iswm $2) { %win = $2 }
    else { %query = $2 }
  }
  elseif (%wwildcard iswm $active) { %win = $active }
  if (%query == $null) && (%win != $null) { %query = $gettok(%win,2,160) }
  %win = @Query $+ $1 $+ $chr(160) $+ %query
  if ($window(%win) == $null) { return }
  if ($prop == $null) { return %query }
  if ($prop == win) { return %win }
  if ($prop == address) { return $remove($window(%win).title,$chr(40),$chr(41))) }
}
;
;;
;
; $_taboirc.chat(session|0 or $null for autodetect,N/chat).[property]
;   properties: ip, status, win
;
alias _taboirc.chat {
  var %chat,%wwildcard,%win,%sock1,%sock2
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %wwildcard = @DCCCHAT $+ $1 $+ *
  if ($2 != $null) {
    if ($2 isnum) {
      if ($2 <= 0) { return $window(%wwildcard,0) }
      else { %win = $window(%wwildcard,$2) }
    }
    elseif (%wwildcard iswm $2) { %win = $2 }
    else { %chat = $2 }
  }
  elseif (%wwildcard iswm $active) { %win = $active }
  if (%chat == $null) && (%win != $null) { %chat = $gettok(%win,3,160) }
  %win = @DCCCHAT $+ $1 $+ $chr(160) $+ %chat
  if ($window(%win) == $null) { return }
  if ($prop == $null) { return %chat }
  if ($prop == win) { return %win }
  if ($prop == ip) { return $remove($window(%win).title,$chr(40),$chr(41))) }
  if ($prop == status) {
    %sock1 = $remove(%win,@)
    %sock2 = $replace(%sock1,DCCCHAT,DCCCHAT)
    if ($sock(%sock2)) { return waiting }
    if ($sock(%sock1)) { return active }
    return inactive
  }
}
;
;;
;
; $_taboirc.ison(session|0 or $null for autodetect,nick,channel)
;
alias _taboirc.ison {
  var %win
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %win = @Channel $+ $1 $+ $chr(160) $+ $3
  if ($window(%win) == $null) { return 0 }
  if ($_taboirc.linick($2,%win)) { return 1 }
  return 0
}
;
;;
;
; $_taboirc.isowner(session|0 or $null for autodetect,nick,channel)
;
alias _taboirc.isowner {
  var %win
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %win = @Channel $+ $1 $+ $chr(160) $+ $3
  if ($window(%win) == $null) { return 0 }
  return $_taboirc.Wisowner($2,%win)
}
;
;;
;
; $_taboirc.isop(session|0 or $null for autodetect,nick,channel)
;
alias _taboirc.isop {
  var %win
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %win = @Channel $+ $1 $+ $chr(160) $+ $3
  if ($window(%win) == $null) { return 0 }
  return $_taboirc.Wisop($2,%win)
}
;
;;
;
; $_taboirc.isvo(session|0 or $null for autodetect,nick,channel)
;
alias _taboirc.isvo {
  var %win
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %win = @Channel $+ $1 $+ $chr(160) $+ $3
  if ($window(%win) == $null) { return 0 }
  return $_taboirc.Wisvo($2,%win)
}
;
;;
;
; $_taboirc.comchan(session|0 or $null for autodetect,nick,N)
;
alias _taboirc.comchan {
  var %i,%chan,%c
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %i = $_taboirc.chan($1,0)
  while (%i) {
    %chan = $_taboirc.chan($1,%i)
    if ($_taboirc.ison($1,$2,%chan)) {
      inc %c
      if (%c == $3) { return %chan }
    }
    dec %i
  }
  if ($3 == 0) { return %c }
}
;
;;
;
; $_taboirc.idle(session|0 or $null for autodetect)
;
alias _taboirc.idle {
  var %s,%idlem
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %idlem = %+irc.idlem. [ $+ [ $1 ] ]
  if (%idlem) {
    if ($ctime > %idlem) { return $round($calc($ctime - %idlem),0) }
  }
  return 0
}
;
;;
;
; $_taboirc.away(session|0 or $null for autodetect)
;
alias _taboirc.away {
  var %s
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %s = IRC $+ $1
  if (a isincs $_taboirc._sockmark(%s,9)) { return $true }
  return $false
}
;
;;
;
; $_taboirc.me(session|0 or $null for autodetect)
;
alias _taboirc.me {
  var %s
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %s = IRC $+ $1
  return $_taboirc._sockmark(%s,1)
}
;
;;
;
; $_taboirc.server(session|0 or $null for autodetect)
;
alias _taboirc.server {
  var %s
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %s = IRC $+ $1
  return $_taboirc._sockmark(%s,3)
}
;
;;
;
; $_taboirc._taboirc._server(session|0 or $null for autodetect)
;
alias _taboirc._taboirc._server {
  var %s
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %s = IRC $+ $1
  return $_taboirc._sockmark(%s,2)
}
;
;;
;
; $_taboirc.nick(session|0 or $null for autodetect,chan,N/nick)
;
alias _taboirc.nick {
  var %win
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %win = @Channel $+ $1 $+ $chr(160) $+ $2
  if ($window(%win) == $null) { return }
  if ($3 == 0) { return $line(%win,0,1) }
  if ($_taboirc._isint($3)) { return $remove($strip($line(%win,$3,1)),.,@,+) }
  if ($_taboirc.linick($3,%win)) { return $3 }
}
;
;;
;
; $_taboirc.snick(session|0 or $null for autodetect,chan,N)
;
alias _taboirc.snick {
  var %win
  if ($_taboirc._not($1)) { tokenize 32 $_taboirc.ircnum $2- }
  if ($_taboirc._not($_taboirc._isint($1))) { return }
  %win = @Channel $+ $1 $+ $chr(160) $+ $2
  if ($window(%win) == $null) { return }
  if ($3 == 0) {
    if ($sline(%win,0)) { return $ifmatch }
    return 0
  }
  if ($remove($strip($sline(%win,$3)),.,@,+) != $null) { return $ifmatch }
}
;
;;
; 
; /_taboirc.togglechanmodes <chan> <mode>
;
alias _taboirc.togglechanmodes {
  var %m = $gettok($_taboirc.chan(0,$1).mode,1,32)
  if ($2 === k) {
    if (k isincs %m) { _taboirc.com MODE $1 -k $_taboirc.chan(0,$1).key }
    else { _taboirc.com MODE $1 +k $_taboirc._param(1,$null,Channel key:)) }
  }
  elseif ($2 === l) {
    if (l isincs %m) { _taboirc.com MODE $1 -l }
    else { _taboirc.com MODE $1 +l $_taboirc._param(isnum > 0,$null,Max users in channel:) }
  }
  else { _taboirc.com MODE $1 $iif($2 isincs %m,-,+) $+ $2 }
}
;
;;
;
; /_taboirc.askdccchatrequest
; 1 - local nick
; 2 - dcc socket name
; 3 - remote nick
; 4 - remote site
; 5 - remote IP
; 6 - remote port
; 7 - dcc window name
; 8 - IRC session socket name
;
alias _taboirc.askdccchatrequest {
  var %i,%d,%r
  while (1) {
    inc %i
    %d = irc.askdccchatrequest $+ %i
    if ($dialog(%d) == $null) { break }
  }
  unset %c.irc.askdccchatrequest.*
  %c.irc.askdccchatrequest.nick = $3
  %c.irc.askdccchatrequest.addy = ( $+ $4 $+ )
  showmirc -s
  %r = $dialog(%d,irc.askdccchatrequest,-4)
  if (%r == chat) {
    sockopen $2 $5 $6-
    sockmark $2 $3 $+ $chr(9) $+ $1 $+ $chr(9) $+ $7 $+ $chr(9) $+ $8 $+ $chr(9) $+ 0
    _taboirc.openwin.chat $2
  }
}
dialog irc.askdccchatrequest {
  title "taboIRC DCC Chat"
  size -1 -1 122 60
  option type dbu

  text %c.irc.askdccchatrequest.nick,10,2 6 119 10,center
  text %c.irc.askdccchatrequest.addy,20,2 14 119 10,center

  box "",30,2 0 118 24

  text "Wants to chat with you.",40,3 30 119 10,center

  button "Chat!",100,17 41 27 13,ok
  button "Cancel",101,48 41 27 13,cancel
  button "Ignore",102,79 41 27 13

  edit "chat",200,100 100 100 100,autohs hide result
}
ON *:DIALOG:irc.askdccchatrequest*:init:0:{
  unset %c.irc.askdccchatrequest.*
  did -b $dname 102
}
ON *:DIALOG:irc.askdccchatrequest*:sclick:101:{
  did -o $dname 200 1 cancel
  dialog -k $dname
}
ON *:DIALOG:irc.askdccchatrequest*:sclick:102:{
  did -o $dname 200 1 ignore
  dialog -k $dname
}
alias _taboirc.askdccsendfile {
  var %f = $$dir="File to send:" *.*
  if (%f != $null) { _taboirc.com dcc send $1 $remove(%f,$chr(34)) }
}
alias _taboirc.send {
  if ($calc($_taboirc._sockmark($1,7) + $_taboirc._sockmark($1,8)) >= $_taboirc._sockmark($1,4)) {
    var %sockname = $1
    _taboirc.send.rwin $1
    _taboirc.send.rcwin $1 DCC Send completed
    if ($_taboirc._minio(0,17)) { beep }
    if ($_taboirc._minio(2,13)) {
      window -c $_taboirc._sockmark($1,2)
      tokenize 9 $sock($1).mark
      var %time = $calc($ctime - $3),%cps = $round($calc($8 / %time),0)
      if ($_taboirc._not(%cps)) { %cps = 0 }
      _taboirc.lechol.s $colour(ctcp) DCC Send of $nopath($1) to $6 completed ( $+ $_taboirc._duratio(%time) %cps $+ cps)
    }
    sockclose %sockname
  }
  else {
    bread " $+ $_taboirc._sockmark($1,1) $+ " $calc($_taboirc._sockmark($1,7) + $_taboirc._sockmark($1,8)) $_taboirc._minio(0,21) &irc.send
    sockwrite $1 &irc.send
    sockmark $1 $puttok($sock($1).mark,$calc($_taboirc._sockmark($1,8) + $bvar(&irc.send,0)),8,9)
    _taboirc.send.rwin $1
  }
}
;
;;
;
; /_taboirc.send.rwin <socket>
;
alias _taboirc.send.rwin {
  tokenize 9 $sock($1).mark
  if ($window($2) == $null) { return }
  var %time = $calc($ctime - $3),%cps = $round($calc($8 / %time),0),%left
  if ($8 = 0) { %left = n/a }
  elseif ($round($calc(($4 - $7 - $8) / %cps),0)) { %left = $_taboirc._duratio($ifmatch) }
  else { %left = 0s }
  if ($_taboirc._not(%cps)) { %cps = 0 }
  if ($line($2,0) == 0) {
    aline $colour(ctcp) $2  DCC Send session
    aline $2 
    aline $2    To: $+ $6
    aline $2  File: $+ $nopath($1)
    aline $2  Size: $+ $4
    aline $2 
    aline $colour(info2) $2  Time: $+ $_taboirc._duratio(%time) $+ $chr(9) $+  $+ $colour(info) $+ Sent: $+ $8
    aline $colour(info2) $2  Left: $+ %left $+ $chr(9) $+   $+ $colour(info) $+ Ack: $+ 0
    aline $colour(info2) $2   Cps: $+ %cps $+ $chr(9) $+  $+ $colour(info) $+ Perc: $+ $_taboirc._percent($calc($7 + $8),$4)
    aline $2 
    aline $colour(ctcp) $2 
    aline $colour(ctcp) $2 
  }
  else {
    rline $colour(info2) $2 7  Time: $+ $_taboirc._duratio(%time) $+ $chr(9) $+  $+ $colour(info) $+ Sent: $+ $8
    rline $colour(info2) $2 8  Left: $+ %left $+ $chr(9) $+   $+ $colour(info) $+ Ack: $+ 0
    rline $colour(info2) $2 9   Cps: $+ %cps $+ $chr(9) $+  $+ $colour(info) $+ Perc: $+ $_taboirc._percent($calc($7 + $8),$4)
  }
}
;
;;
;
; /_taboirc.send.rcwin <socket> <text>
;
alias _taboirc.send.rcwin {
  var %text = $2-
  tokenize 9 $sock($1).mark
  if ($window($2) == $null) { return }
  if ($line($2,0) == 0) { _taboirc.send.rwin $1 }
  var %l11 = $strip($line($2,11)),%l12 = $strip($line($2,12))
  if (%l11 == $null) { rline $colour(ctcp) $2 11  %text }
  else {
    if (%l12 != $null) { rline $colour(ctcp) $2 11  $ifmatch }
    rline $colour(ctcp) $2 12  %text
  }
}
;
;;
;
; /_taboirc.send.chtimer <socket> <counter>
;
alias _taboirc.send.chtimer {
  var %win = $_taboirc._sockmark($1,2)
  .timer $+ $1 off
  if ($window(%win) == $null) { return }
  _taboirc.send.rwin $1
  if ($calc($ctime - $_taboirc._sockmark($1,3)) == $_taboirc._minio(2,11)) { _taboirc.send.rcwin $1 DCC Send timed out... }
  else { .timer $+ $1 -mo 1 500 _taboirc.send.chtimer $1 }
}
;
;;
;
; /_taboirc.get.rwin <socket>
;
alias _taboirc.get.rwin {
  var %bytes = $sock($1).rcvd
  tokenize 9 $sock($1).mark
  if ($window($2) == $null) { return }
  var %time = $calc($ctime - $3),%cps = $round($calc(%bytes / %time),0),%left
  if (%bytes = 0) { %left = n/a }
  elseif ($round($calc(($4 - $7 - %bytes) / %cps),0)) { %left = $_taboirc._duratio($ifmatch) }
  else { %left = 0s }
  if ($_taboirc._not(%cps)) { %cps = 0 }
  if ($line($2,0) == 0) {
    aline $colour(ctcp) $2  DCC Get session
    aline $2 
    aline $2  From: $+ $6
    aline $2  File: $+ $nopath($1)
    aline $2  Size: $+ $4
    aline $2 
    aline $colour(info2) $2  Time: $+ $_taboirc._duratio(%time) $+ $chr(9) $+  $+ $colour(info) $+ Sent: $+ %bytes
    aline $colour(info2) $2  Left: $+ %left $+ $chr(9) $+   $+ $colour(info) $+ Cps: $+ %cps
    aline $colour(info2) $2  Perc: $+ $_taboirc._percent($calc($7 + %bytes),$4)
    aline $2 
    aline $colour(ctcp) $2 
    aline $colour(ctcp) $2 
  }
  else {
    rline $colour(info2) $2 7  Time: $+ $_taboirc._duratio(%time) $+ $chr(9) $+  $+ $colour(info) $+ Sent: $+ %bytes
    rline $colour(info2) $2 8  Left: $+ %left $+ $chr(9) $+   $+ $colour(info) $+ Cps: $+ %cps
    rline $colour(info2) $2 9  Perc: $+ $_taboirc._percent($calc($7 + %bytes),$4)
  }
}
;
;;
;
; /_taboirc.get.rcwin <socket> <text>
;
alias _taboirc.get.rcwin {
  var %text = $2-
  tokenize 9 $sock($1).mark
  if ($window($2) == $null) { return }
  if ($line($2,0) == 0) { _taboirc.get.rwin $1 }
  var %l11 = $strip($line($2,11)),%l12 = $strip($line($2,12))
  if (%l11 == $null) { rline $colour(ctcp) $2 11  %text }
  else {
    if (%l12 != $null) { rline $colour(ctcp) $2 11  $ifmatch }
    rline $colour(ctcp) $2 12  %text
  }
}
;
;;
;
; /_taboirc.get.chtimer <socket> <counter>
;
alias _taboirc.get.chtimer {
  var %win = $_taboirc._sockmark($1,2)
  .timer $+ $1 off
  if ($window(%win) == $null) { return }
  _taboirc.get.rwin $1
  if ($calc($ctime - $_taboirc._sockmark($1,3)) == $_taboirc._minio(2,11)) { _taboirc.get.rcwin $1 DCC Get timed out... }
  else { .timer $+ $1 -mo 1 500 _taboirc.get.chtimer $1 }
}

;
;
;eof
