; -- sGet Downloader v1.0 -- Sphoo Inc. -- www.sphoo.cx --
;
; standard short description: A small addon to conveniently download files from web (HTTP) or FTP servers so you don't have the hassle
; of opening a web browser. Allows an infinate number of downloads at any time and is very simple to use.
;

on *:load:{
  if ($version < 5.82) var %sget.msg = requires mIRC 5.82 or higher to run. Unloading...
  else var %sget.msg = loaded. Use /sget URL to download a file.
  linesep -s
  echo 2 -s *** sGet Downloader v1.0 %sget.msg
  linesep -s
  if (r* iswm %sget.msg) .unload " $+ $script $+ "
}

alias sget {
  if ($1 = $null) { linesep -s | echo 2 -s *** /sget: insufficient parameters. Use /sget URL | linesep -s | return }
  if ($1 = -r) {
    var %sget.var = $3-
    var %sget.sock = $2
  }
  else var %sget.var = $1-
  var %sget.path = $remove(%sget.var,http://,ftp://)
  var %sget.host = $gettok(%sget.path,1,47)
  if (ftp://* iswm %sget.var) var %sget.option = -sget.ftp:anonymous:sget@sget.com
  if (@ isin %sget.host) {
    var %sget.option = $iif(%sget.option,-sget.ftp:,-sget.auth:) $+ $gettok(%sget.host,1,64)
    set %sget.host $gettok(%sget.host,2-,64)
  }
  if (: isin %sget.host) {
    var %sget.port = $gettok(%sget.host,2-,58)
    set %sget.host $gettok(%sget.host,1,58)
  }
  elseif (-sget.ftp* iswm %sget.option) var %sget.port = 21
  set %sget.path / $+ $gettok(%sget.path,2-,47))
  if (*/ iswm %sget.var) && (*/ !iswm %sget.path) set %sget.path %sget.path $+ /
  if (%sget.sock) goto done.sock
  :loop.sock
  var %sget.sock = sget/ $+ $rand(0,9999) $+ / $+ %sget.host
  if ($sock(%sget.sock)) goto loop.sock
  :done.sock
  if ($exists($gettok($iif(*/ iswm %sget.path,index.html,%sget.path),-1,47))) {
    :start.rename
    if (%sget.newname) && ($exists(%sget.newname) = $false) goto done.rename
    var %sget.action = $dialog(sget.d.m,sget.d.m)
    if (%sget.action = Cancel) || (%sget.action = $null) { linesep -s | echo 2 -s *** /sget: command halted. | linesep -s | halt }
    elseif (%sget.action = Overwrite) .remove $iif(%sget.newname,%sget.newname,$gettok($iif(*/ iswm %sget.path,index.html,%sget.path),-1,47)))
    else {
      var %sget.newname = $?="Enter new filename"
      if (%sget.newname = $null) { linesep -s | echo 2 -s *** /sget: command halted. | linesep -s | unset % [ $+ [ %sget.sock ] $+ ] .newname | halt }
      set % $+ %sget.sock $+ .newname %sget.newname
      goto start.rename
    }
  }
  :done.rename
  if ($dialog(%sget.sock) = $null) dialog -md %sget.sock $iif($exists($scriptdirsget10-blue.bmp),sget.d,sget.d.box)
  dialog -t %sget.sock sGet v1.0 - $gettok(%sget.sock,-1,47)
  did -o %sget.sock 3 1 Connecting to %sget.host $+ ...
  did -o %sget.sock 5 1 $iif(%sget.newname,%sget.newname,$iif(*/ iswm %sget.path,index.html,$gettok(%sget.path,-1,47)))
  sockopen %sget.sock %sget.host $iif(%sget.port,%sget.port,80)
  set % $+ %sget.sock %sget.option %sget.path
}

on *:sockopen:sget/*:{
  if ($sockerr) { 
    if ($sockerr = 4) var %sget.err = resolve host
    else var %sget.err = connect to host
    did -o $sockname 3 1 Error - Unable to %sget.err
    unset % $+ $sockname $+ *
    did -o $sockname 1 1 &Close
    did -o $sockname 9 1 Error recieving file
    dialog -t $sockname sGet v1.0 - Finished
    return
  }
  var %sget.host = $left($gettok($sockname,-1,47),21) $+ ...
  did -o $sockname 3 1 Connected to %sget.host
  var %sget.path = % [ $+ [ $sockname ] ]
  if (-sget.ftp* iswm %sget.path) goto ftp
  if (-sget.auth* iswm %sget.path) {
    var %sget.auth = $gettok($gettok(%sget.path,1,32),2-,58)
    set %sget.path $gettok(%sget.path,2-,32)
  }
  sockwrite -n $sockname GET %sget.path HTTP/1.0
  sockwrite -n $sockname Accept: */*
  sockwrite -n $sockname User-Agent: go to www.skeletaltitwank.co.uk ;-)
  sockwrite -n $sockname Host: $gettok($sockname,-1,47)
  if (%sget.auth) sockwrite -n $sockname Authorization: Basic $encode(%sget.auth,m)
  if (% [ $+ [ $sockname ] $+ ] .newname) set %sget.path % [ $+ [ $sockname ] $+ ] .newname
  unset % $+ $sockname $+ *
  if (*/ iswm %sget.path) set %sget.path %sget.path $+ index.html
  sockmark $sockname $gettok(%sget.path,-1,47)
  sockwrite -n $sockname $crlf
  return
  :ftp
  sockwrite -n $sockname USER $gettok(%sget.path,2,58)
  sockmark $sockname %sget.path
  unset % $+ $sock($sockname) $+ *
}

on *:sockread:sget/*:{
  if ($sockerr) return
  if ($dialog($sockname) = $null) { sockclose $sockname | halt }
  var %sget.temp
  var %sget.mark = $sock($sockname).mark
  if (-sget.ftp* iswm %sget.mark) goto ftp
  if ($gettok(%sget.mark,1,32) isnum) {
    sockread &sget.temp
    if ($sockbr == 0) return
    bwrite " $+ $did($sockname,5) $+ " -1 -1 &sget.temp
  }
  else {
    sockread %sget.temp
    if ($sockbr == 0) return
    if (%sget.temp = $null) {
      did -o $sockname 40 1 $ctime
      sget.refresh $sockname
      .timer $+ $sockname -m 0 500 sget.refresh $sockname
      sockmark $sockname $sock($sockname).rcvd %sget.mark
    }
    else {
      if (HTTP/* iswm %sget.temp) {
        var %sget.code = $gettok(%sget.temp,2-,32)
        if (4* iswm %sget.code) || (5* iswm %sget.code) {
          did -o $sockname 3 1 Error - %sget.code
          did -r $sockname 5,7,9
          did -o $sockname 1 1 &Close
          sockclose $sockname
          return
        }
        elseif (3* iswm %sget.code) {
          if (302* iswm %sget.code) || (301* iswm %sget.code) || (303* iswm %sget.code) {
            sockmark $sockname redirect
          }
        }
      }
      if (location:* iswm %sget.temp) && (%sget.mark = redirect) {
        set %sget.temp $gettok(%sget.temp,-1,32)        
        did -r $sockname 3,5,7,9
        .timer 1 0 sget -r $sockname %sget.temp
        sockclose $sockname
        return
      }
      if (content-length:* iswm %sget.temp) {
        did -o $sockname 30 1 $gettok(%sget.temp,2-,32)
      }
    }
  }
  return
  :ftp
  sockread %sget.temp
  if ($sockbr == 0) return
  elseif (331* iswm %sget.temp) sockwrite -n $sockname PASS $gettok($gettok(%sget.mark,3,58),1,32)
  elseif (5* iswm %sget.temp) {
    did -o $sockname 3 1 Error - $gettok(%sget.temp,2-,32)
    did -o $sockname 1 1 &Close
    dialog -t $sockname sGet v1.0 - Finished
    sockclose $sockname
    return
  }
  elseif (230* iswm %sget.temp) {
    if ($sock(sget.ftplisten/ [ $+ [ $gettok($sockname,2-,47) ] ] )) return
    sockwrite -n $sockname TYPE A
    :loop.port
    var %sget.realport = $rand(1025,5000)
    if ($portfree(%sget.realport) = $false) goto loop.port
    var %sget.port1 = $gettok($calc(%sget.realport / 256),1,46)
    var %sget.port2 = $calc(%sget.realport - (%sget.port1 * 256))
    var %sget.port = $replace($ip,$chr(46),$chr(44)) $+ , $+ %sget.port1 $+ , $+ %sget.port2
    var %sget.mark1 = $gettok(%sget.mark,2-,32)
    sockmark $sockname -sget.ftp:list %sget.mark1
    socklisten sget.ftplisten/ $+ $gettok($sockname,2-,47) %sget.realport
    sockwrite -n $sockname PORT %sget.port
    sockwrite -n $sockname LIST %sget.mark1
  }
}

on *:socklisten:sget.ftplisten/*:{
  var %sget.newsock = sget.ftp/ $+ $gettok($sockname,2-,47)
  sockaccept %sget.newsock
  sockclose $sockname
  var %sget.sock = sget/ $+ $gettok(%sget.newsock,2-,47)
  var %sget.sock1 = $gettok($sock(%sget.sock).mark,1,32)
  sockmark %sget.newsock $gettok(%sget.sock1,2,58)
  if ($sock(%sget.newsock).mark = retr) {
    did -o %sget.sock 3 1 0 of $did(%sget.sock,30) bytes
    did -o %sget.sock 40 1 $ctime
    sget.refresh %sget.sock %sget.newsock
    .timer $+ %sget.sock -m 0 500 sget.refresh %sget.sock %sget.newsock
    sockmark %sget.sock 0 $sock(%sget.sock).mark
  }
}

on *:sockread:sget.ftp/*:{
  if ($sockerr > 0) return
  var %sget.temp
  var %sget.mark = $sock($sockname).mark
  var %sget.sock = sget/ $+ $gettok($sockname,2-,47)
  if (%sget.mark = list) goto list
  sockread &sget.temp
  if ($sockbr = 0) return
  bwrite " $+ $did(%sget.sock,5) $+ " -1 -1 &sget.temp
  return
  :list
  sockread %sget.temp
  if ($sockbr = 0) return
  did -o %sget.sock 30 1 $gettok(%sget.temp,5,32)
}

on *:sockclose:sget.ftp/*:{
  var %sget.sock = sget/ $+ $gettok($sockname,2-,47)
  var %sget.mark = $sock(%sget.sock).mark
  if ($sock($sockname).mark = list) {
    if ($sock($sockname).rcvd = 0) {
      did -o %sget.sock 3 1 Error - File Not Found
      did -o %sget.sock 1 1 &Close
      dialog -t %sget.sock sGet v1.0 - Finished
      sockclose %sget.sock
      return
    }
    sockwrite -n %sget.sock TYPE I
    :loop.port
    var %sget.realport = $rand(1025,5000)
    if ($portfree(%sget.realport) = $false) goto loop.port
    var %sget.port1 = $gettok($calc(%sget.realport / 256),1,46)
    var %sget.port2 = $calc(%sget.realport - (%sget.port1 * 256))
    var %sget.port = $replace($ip,$chr(46),$chr(44)) $+ , $+ %sget.port1 $+ , $+ %sget.port2
    var %sget.mark1 = $gettok(%sget.mark,2-,32)
    sockmark %sget.sock -sget.ftp:retr $gettok(%sget.mark1,-1,47)
    socklisten sget.ftplisten/ $+ $gettok(%sget.sock,2-,47) %sget.realport
    sockwrite -n %sget.sock PORT %sget.port
    sockwrite -n %sget.sock RETR %sget.mark1
  }
  elseif ($sock($sockname).mark = retr) {
    sockwrite -n %sget.sock QUIT
    sget.close %sget.sock $sockname
  }
}

on *:sockclose:sget/*:if (0 -sget.ftp* !iswm $sock($sockname).mark) sget.close $sockname
alias -l sget.close {
  var %d = $1
  var %s = $iif($2,$2,$1)
  var %sget.mark = $sock(%d).mark
  if ($dialog(%d)) {
    if ($did(%d,30) !isnum) || ($calc($sock(%s).rcvd - $gettok(%sget.mark,1,32)) => $did(%d,30)) {
      did -o %d 9 1 Download complete
      did -o %d 10 1 Progress: 100%
      var %sget.n = 11
      while (%sget.n < 28) {
        if ($did(%d,%sget.n).visible = $false) did -v %d %sget.n
        inc %sget.n
      }
      var %sget.rcvd = $calc($sock(%s).rcvd - $gettok(%sget.mark,1,32))
      did -o %d 3 1 $bytes(%sget.rcvd,3).suf of $bytes($did(%d,30),3).suf (at $bytes($calc(%sget.rcvd / ($ctime - $did(%d,40))),3).suf $+ /sec)
    }
    did -o %d 1 1 &Close
    did -e %d 28,29
    did -o %d 4 1 Saved As:
    dialog -t %d sGet v1.0 - Finished
  }
  elseif ($2 = $null) {
    did -o %d 9 1 Error recieving file
  }
  if ($did(%d,32).state = 1) dialog -x %d
  else dialog -v %d
  .timer $+ %d off
}

alias -l sget.refresh {
  if ($1 = $null) || ($dialog($1) = $null) { .timer $+ $1 off | return }
  var %d = $1
  var %s = $iif($2,$2,$1)
  var %sget.elapse = $calc($ctime - $did(%d,40))
  var %sget.rcvd = $calc($sock(%s).rcvd - $gettok($sock(%d).mark,1,32))
  did -o %d 3 1 $bytes(%sget.rcvd,3).suf of $bytes($did(%d,30),3).suf (at $bytes($calc(%sget.rcvd / ($ctime - $did(%d,40))),3).suf $+ /sec)
  did -o %d 7 1 $duration(%sget.elapse)
  if ($did(%d,30) isnum) {
    var %sget.remain = $calc(%sget.elapse / %sget.rcvd * $did(%d,30) - %sget.elapse)
    did -o %d 9 1 $duration(%sget.remain)
    var %sget.percent = $round($calc(100 / $did(%d,30) * %sget.rcvd),0)
    did -o %d 10 1 Progress: %sget.percent $+ %
    dialog -t %d sGet v1.0 - $gettok(%s,-1,47) - %sget.percent $+ %
    var %sget.bar = 11
    var %sget.bar1 = 5.88235
    while (%sget.percent > %sget.bar1) {
      if ($did(%d,%sget.bar).visible = $false) did -v %d %sget.bar
      inc %sget.bar
      set %sget.bar1 $calc(%sget.bar1 + 5.88235)
    }
  }
}

on *:dialog:sget/*:sclick:1:{
  if ($sock($dname)) sockclose $dname
  var %sget.sock = sget.ftp/ $+ $dname
  if ($sock(%sget.sock)) sockclose %sget.sock
  .timer $+ $dname off
}

on *:dialog:sget/*:sclick:28:.run " $+ $did(5) $+ "
on *:dialog:sget/*:sclick:29:{
  :start
  var %sget.dir = $$sdir(c:\,$iif(%sget.err,%sget.err,- Choose Target Directory))
  var %sget.newfile = %sget.dir $+ $nopath($did(5))
  if ($exists(%sget.newfile)) { var %sget.err = - File Already Exists, Choose Another Directory | goto start }
  .copy " $+ $did(5) $+ " " $+ %sget.dir $+ "
  .remove " $+ $did(5) $+ "
  did -o $dname 5 1 %sget.newfile
}
on *:dialog:sget/*:sclick:31:dialog $iif($did(31).state = 1,-o,-n) $dname

dialog sget.d {
  title ""
  size -1 -1 300 165
  button "&Launch File",28,35 135 70 22,disabled
  button "&Cancel",1,115 135 70 22,ok
  button "&Move File",29,195 135 70 22,disabled
  check "O",31,3 135 28 22,left
  check "C",32,269 135 28 22

  text "Status:",2,10 10 60 15,right
  text "",3,75 10 210 15

  text "Saving As:",4,10 30 60 15,right
  text "",5,75 30 210 15
  text "Elapsed:",6,10 50 60 15,right
  text "",7,75 50 210 15

  text "Remaining:",8,10 70 60 15,right
  text "Unknown",9,75 70 210 15

  box "Progress: 0%",10,17 90 266 36
  icon 11,25 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 12,40 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 13,55 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 14,70 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 15,85 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 16,100 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 17,115 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 18,130 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 19,145 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 20,160 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 21,175 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 22,190 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 23,205 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 24,220 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 25,235 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 26,250 106 10 10,$scriptdirsget10-blue.bmp,hide
  icon 27,265 106 10 10,$scriptdirsget10-blue.bmp,hide

  text "???",30,600 600 1 1
  text "",40,600 600 1 1
}

dialog sget.d.box {
  title ""
  size -1 -1 300 165
  button "&Launch File",28,35 135 70 22,disabled
  button "&Cancel",1,115 135 70 22,ok
  button "&Move File",29,195 135 70 22,disabled
  check "O",31,3 135 28 22,left
  check "C",32,269 135 28 22

  text "Status:",2,10 10 60 15,right
  text "",3,75 10 210 15

  text "Saving As:",4,10 30 60 15,right
  text "",5,75 30 210 15
  text "Elapsed:",6,10 50 60 15,right
  text "",7,75 50 210 15

  text "Remaining:",8,10 70 60 15,right
  text "Unknown",9,75 70 210 15

  box "Progress: 0%",10,17 90 266 36
  box "",11,25 106 10 10,hide
  box "",12,40 106 10 10,hide
  box "",13,55 106 10 10,hide
  box "",14,70 106 10 10,hide
  box "",15,85 106 10 10,hide
  box "",16,100 106 10 10,hide
  box "",17,115 106 10 10,hide
  box "",18,130 106 10 10,hide
  box "",19,145 106 10 10,hide
  box "",20,160 106 10 10,hide
  box "",21,175 106 10 10,hide
  box "",22,190 106 10 10,hide
  box "",23,205 106 10 10,hide
  box "",24,220 106 10 10,hide
  box "",25,235 106 10 10,hide
  box "",26,250 106 10 10,hide
  box "",27,265 106 10 10,hide

  text "???",30,600 600 1 1
  text "",40,600 600 1 1
}

on *:dialog:sget.d.m:sclick:*:{
  if ($did(5)) return
  did -o sget.d.m 5 1 $did($did)
  dialog -k sget.d.m
}
dialog sget.d.m {
  title "sGet v1.0"
  size -1 -1 300 80
  button "Overwrite",1,35 45 70 22,ok
  button "Rename",2,115 45 70 22
  button "Cancel",3,195 45 70 22
  text "Local file already exists!!",4,2 10 196 30,center
  text "",5,500 500 0 0,result
}
