;*************************************************
;* Project.name: Kind of unix whois              *
;* Version.....: 1.0                             *
;* this file...: event, alias and dialogs code   *
;* joined file.: RIPE whois help in txt format   *
;* Author......: blaster^                        *
;* E-mail......: blaster@irc-scripts.com         *
;* Homepage....:                                 *
;*************************************************
menu menubar {
  unix whois:dialog -m ripe ripe
}
menu @Whois {
  dclick:savebuf @Whois $$dir="save" c:\*.log
}
dialog ripe {
  title "Ripe whois search options"
  size -1 -1 170 170
  option dbu

  button "Cancel", 255,   5 155 80 10, cancel
  button "Submit", 254,  85 155 80 10, ok

  tab "basic options",   251, 5 5 160 145
  tab "advance search",  252
  tab "search template", 253

  check "search all databases -a"                             ,   1,  12  25 120 10, tab 1
  check "fast raw output (implies -Fr) -F"                    ,   2,  12  35 120 10, tab 1                      
  check "search alternate server -h"                          ,   3,  12  45  80 10, tab 1
  radio "internic"                                            ,  30,  25  55  30 10, tab 1, group   
  radio "arin"                                                ,  31,  60  55  30 10, tab 1
  radio "apnic"                                               ,  32,  90  55  30 10, tab 1
  radio "nic.gov"                                             ,  33, 130  55  30 10, tab 1
  radio "nic.mx"                                              ,  34,  25  65  30 10, tab 1
  radio "aunic"                                               ,  35,  60  65  30 10, tab 1
  radio "nic.ml.org"                                          ,  36,  90  65  40 10, tab 1 
  radio "nic.uk"                                              ,  37, 130  65  30 10, tab 1
  text  "others"                                              ,  38,  25  77  20 10, tab 1
  edit  ""                                                    ,  39,  45  75 115 10, tab 1  

  check "inverse look-up -i"                                  ,   4,  12  25 120 10, tab 2
  check "admin-c"                                             ,  40,  25  35  30 10, tab 2 
  check "tech-c"                                              ,  41,  60  35  30 10, tab 2
  check "zone-c"                                              ,  42,  95  35  30 10, tab 2
  check "notify"                                              ,  43,  25  45  30 10, tab 2
  check "origin"                                              ,  44,  60  45  30 10, tab 2
  check "mnt-by"                                              ,  45,  95  45  30 10, tab 2
  check "author"                                              ,  46, 130  45  30 10, tab 2
  check "find all Less specific matches -L"                   ,   5,  12  55 120 10, tab 2
  check "find first level More specific matches -m"           ,   6,  12  65 120 10, tab 2
  check "find all More specific matches -M"                   ,   7,  12  75 120 10, tab 2
  check "turn off recursive lookups -r"                       ,   8,  12  85 120 10, tab 2

  check "search databases with source <source> -s"            ,   9,  12  25 120 8, tab 3
  radio "RIPE"                                                ,  90,  20  33  35 8, group, tab 3
  radio "RADB"                                                ,  91,  55  33  35 8, tab 3
  radio "ANS"                                                 ,  92,  90  33  35 8, tab 3
  radio "CW"                                                  ,  93, 125  33  35 8, tab 3
  radio "CANET"                                               ,  94,  20  41  35 8, tab 3
  radio "APNIC"                                               ,  95,  55  41  35 8, tab 3
  radio "ARIN"                                                ,  96,  90  41  35 8, tab 3
  radio "FGC"                                                 ,  97, 125  41  35 8, tab 3
  check "tell server to leave out <syntactic sugar> -S"       ,  10,  12  49 120 8, tab 3
  check "requests template for object of type <type> -t"      ,  11,  12  57 120 8, tab 3
  check "verbose"                                             , 124, 132  57  30 8, tab 3
  radio "all"                                                 , 110,  20  65  35 8, group, tab 3            
  radio "role"                                                , 111,  55  65  35 8, tab 3
  radio "aut-num"                                             , 112,  20  73  35 8, tab 3            
  radio "as-macro"                                            , 113,  55  73  35 8, tab 3            
  radio "community"                                           , 114,  90  73  35 8, tab 3     
  radio "domain"                                              , 115, 125  73  35 8, tab 3
  radio "inetnum"                                             , 116,  20  81  35 8, tab 3
  radio "inet6num"                                            , 117,  55  81  35 8, tab 3
  radio "person"                                              , 118,  90  81  35 8, tab 3
  radio "dom-prefix"                                          , 119, 125  81  35 8, tab 3
  radio "inet-rtr"                                            , 120,  20  89  35 8, tab 3
  radio "limerick"                                            , 121,  55  89  35 8, tab 3
  radio "mntner"                                              , 122,  90  89  35 8, tab 3
  radio "route"                                               , 123, 125  89  35 8, tab 3
  check "only look for objects of type <type> -T"             ,  13,  12  97 120 8, tab 3
  radio "role"                                                , 130,  20 105  35 8, group, tab 3            
  radio "aut-num"                                             , 131,  55 105  35 8, tab 3
  radio "as-macro"                                            , 132,  90 105  35 8, tab 3
  radio "community"                                           , 133, 125 105  35 8, tab 3
  radio "domain"                                              , 134,  20 113  35 8, tab 3
  radio "inetnum"                                             , 135,  55 113  35 8, tab 3
  radio "inet6num"                                            , 136,  90 113  35 8, tab 3
  radio "person"                                              , 137, 125 113  35 8, tab 3
  radio "dom-prefix"                                          , 138,  20 121  35 8, tab 3
  radio "inet-rtr"                                            , 139,  55 121  35 8, tab 3
  radio "limerick"                                            , 140,  90 121  35 8, tab 3
  radio "mntner"                                              , 141, 125 121  35 8, tab 3
  radio "route"                                               , 142,  20 129  35 8, tab 3
}
alias -l HrTab3 { did -h ripe 9,90,91,92,93,94,95,96,97,10,11,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,13,130,131,132,133,134,135,136,137,138,139,140,141,142 }
alias -l SrTab3 { did -v ripe 9,90,91,92,93,94,95,96,97,10,11,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,13,130,131,132,133,134,135,136,137,138,139,140,141,142 }
alias -l HrTab2 { did -h ripe 4,40,41,42,43,44,45,46,5,6,7,8 }
alias -l SrTab2 { did -v ripe 4,40,41,42,43,44,45,46,5,6,7,8 }
alias -l HrTab1 { did -h ripe 1,2,3,30,31,32,33,34,35,36,37,38,39 }
alias -l SrTab1 { did -v ripe 1,2,3,30,31,32,33,34,35,36,37,38,39 }
on 1:dialog:ripe:init:0:{
  SrTab1 | HrTab2 | HrTab3
  did -b ripe 30,31,32,33,34,35,36,37,39
  did -b ripe 40,41,42,43,44,45,46
  did -b ripe 110,111,112,113,114,115,116,117,118,119,120,121,122,123,124
  did -b ripe 130,131,132,133,134,135,136,137,138,139,140,141,142
  did -b ripe 90,91,92,93,94,95,96,97
}
on 1:dialog:ripe:sclick:251:{ SrTab1 | HrTab2 | HrTab3 }
on 1:dialog:ripe:sclick:252:{ HrTab1 | SrTab2 | HrTab3 }
on 1:dialog:ripe:sclick:253:{ HrTab1 | HrTab2 | SrTab3 }
on 1:dialog:ripe:sclick:3:{
  if ($did(3,ripe).state) { did -e ripe 30,31,32,33,34,35,36,37,39 }
  else { did -b ripe 30,31,32,33,34,35,36,37,39 }
}
on 1:dialog:ripe:sclick:4:{
  if ($did(4,ripe).state) { did -e ripe 40,41,42,43,44,45,46 }
  else { did -b ripe 40,41,42,43,44,45,46 }
}
on 1:dialog:ripe:sclick:9: {
  if ($did(9,ripe).state) { did -e ripe 90,91,92,93,94,95,96,97 }
  else { did -b ripe 90,91,92,93,94,95,96,97 }
}
on 1:dialog:ripe:sclick:11:{
  if ($did(11,ripe).state) { did -e ripe 110,111,112,113,114,115,116,117,118,119,120,121,122,123,124 }
  else { did -b ripe 110,111,112,113,114,115,116,117,118,119,120,121,122,123,124 }
}
on 1:dialog:ripe:sclick:13:{
  if ($did(13,ripe).state) { did -e ripe 130,131,132,133,134,135,136,137,138,139,140,141,142 }
  else { did -b ripe 130,131,132,133,134,135,136,137,138,139,140,141,142 }
}
on 1:dialog:ripe:sclick:254:{
  unset %request | set %wsserver whois.ripe.net
  if ($did(1,ripe).state) { set %request -a }
  if ($did(2,ripe).state) { set %request %request -F }
  if ($did(8,ripe).state) { set %request %request -r }
  if ($did(3,ripe).state) { 
    if ($did(39,ripe).text) { set %wsserver $did(39,ripe).text } 
    elseif ($did(30,ripe).state) { set %wsserver whois.internic.net }
    elseif ($did(31,ripe).state) { set %wsserver whois.arin.net }
    elseif ($did(32,ripe).state) { set %wsserver whois.apnic.net }
    elseif ($did(33,ripe).state) { set %wsserver whois.nic.gov }
    elseif ($did(34,ripe).state) { set %wsserver whois.nic.mx }
    elseif ($did(35,ripe).state) { set %wsserver whois.aunic.net }
    elseif ($did(36,ripe).state) { set %wsserver whois.nic.ml.org }
    elseif ($did(37,ripe).state) { set %wsserver whois.nic.uk }
  }
  if ($did(4,ripe).state) {     
    if ($did(40,ripe).state) { set %request1 $addtok(%request1,admin-c,44) }   
    if ($did(41,ripe).state) { set %request1 $addtok(%request1,tech-c,44) }   
    if ($did(42,ripe).state) { set %request1 $addtok(%request1,zone-c,44) }   
    if ($did(43,ripe).state) { set %request1 $addtok(%request1,notify,44) }   
    if ($did(44,ripe).state) { set %request1 $addtok(%request1,origin,44) }   
    if ($did(45,ripe).state) { set %request1 $addtok(%request1,mnt-by,44) }   
    if ($did(46,ripe).state) { set %request1 $addtok(%request1,author,44) }   
    if (%request1) { set %request %request -i %request1 | unset %request1 }
  }
  if ($did(5,ripe).state) { set %request %request -L }
  if ($did(6,ripe).state) { set %request %request -m }
  if ($did(7,ripe).state) { set %request %request -M } 
  if ($did(9,ripe).state) { 
    if ($did(90,ripe).state) { set %request1 RIPE }
    elseif ($did(91,ripe).state) { set %request1 RADB }
    elseif ($did(92,ripe).state) { set %request1 ANS }
    elseif ($did(93,ripe).state) { set %request1 CW }
    elseif ($did(94,ripe).state) { set %request1 CANET }
    elseif ($did(95,ripe).state) { set %request1 APNIC }
    elseif ($did(96,ripe).state) { set %request1 ARIN }
    elseif ($did(97,ripe).state) { set %request1 FGC }
    elseif (%request1) { set %request %request -s %request1 | unset %request1 }
  }
  if ($did(10,ripe).state) { set %request %request -S }
  if ($did(11,ripe).state) { 
    if ($did(110,ripe).state) { set %request1 all }
    elseif ($did(111,ripe).state) { set %request1 ro }
    elseif ($did(112,ripe).state) { set %request1 an }
    elseif ($did(113,ripe).state) { set %request1 am }
    elseif ($did(114,ripe).state) { set %request1 cm }
    elseif ($did(115,ripe).state) { set %request1 dn }
    elseif ($did(116,ripe).state) { set %request1 in }
    elseif ($did(117,ripe).state) { set %request1 i6 }
    elseif ($did(118,ripe).state) { set %request1 pn }
    elseif ($did(119,ripe).state) { set %request1 dp }
    elseif ($did(120,ripe).state) { set %request1 ir }
    elseif ($did(121,ripe).state) { set %request1 li }
    elseif ($did(122,ripe).state) { set %request1 mt }
    elseif ($did(123,ripe).state) { set %request1 rt }
    if (%request1) {
      if ($did(124,ripe).state) { set %request %request -v %request1 }
      else { set %request %request -t %request1 }
      unset %request1
    }
  }
  if ($did(13,ripe).state) { 
    if ($did(130,ripe).state) { set %request1 ro }
    elseif ($did(131,ripe).state) { set %request1 an }
    elseif ($did(132,ripe).state) { set %request1 am }
    elseif ($did(133,ripe).state) { set %request1 cm }
    elseif ($did(134,ripe).state) { set %request1 dn }
    elseif ($did(135,ripe).state) { set %request1 in }
    elseif ($did(136,ripe).state) { set %request1 i6 }
    elseif ($did(137,ripe).state) { set %request1 pn }
    elseif ($did(138,ripe).state) { set %request1 dp }
    elseif ($did(139,ripe).state) { set %request1 ir }
    elseif ($did(140,ripe).state) { set %request1 li }
    elseif ($did(141,ripe).state) { set %request1 mt }
    elseif ($did(142,ripe).state) { set %request1 rt }
    if (%request1) { set %request %request -T %request1 | unset %request1 }
  }
  .timer -m 1 10 StartWhois
}
alias StartWhois {
  set %wsdomain $$?="which address/name/block descriptor you want infos on ?" 
  window -h +tbs @Whois -1 -1 600 150 Arial 13  | aline 1 @Whois $str(-,150) | aline 4 @Whois Query : whois -h %wsserver %request %wsdomain on $fulldate GMT+ $+ $calc( ( 0 - $timezone - $daylight ) / 3600 ) | sockopen ws %wsserver 43 | .timerWs 1 60 WsTimeOut
}
on 1:load:{ if ($version < 5.7) { echo 4 -s Sorry, this script is designed for mIRC v5.7 | .unload -rs $scriptname } }
  alias -l WsTimeOut {
    if ($sock(ws).status) {
      sockclose ws
      aline 4 @Whois Query timed out
      unset %wsdomain 
      window -a @Whois
    }
  }
  on 1:sockopen:ws:{ sockwrite -n ws %request %wsdomain }
  on 1:sockread:ws:{ 
    set %txt ""
    :nextread
    sockread -n %txt
    if (%txt) { aline @Whois %txt }
    if ($sockbr != 0 ) { goto nextread }
  }
  on 1:sockclose:ws:{
    unset %wsdomain
    aline 10 @Whois double click on the window to save the text
    window -a @Whois
  }
