;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;|||||||||||||||||||||||||||||||||||||||[---((mp3n v3.0))---]||||||||||||||||||||||||||||||||||||||||||||||
;|||||||||||||||||||||||||||||||||[----((by Pendragon))----]|||||||||||||||||||||||||||||||||||||||||
;|||||||||||||||||||||||||[----((http://edgefiles.cjb.net))----]||||||||||||||||||||||||||||
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;|||||[Scott Oleson, 2000-2001. All Rights Reserved.]|||||
;||||||||||||||[Email: archpendragon@eudoramail.com]|||||||||||||||||
;||||||||||||||||[Questions and comments are welcome]||||||||||||||||||
;||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


;change the function key # 's to the ones of your choice here:
alias f6 mp3nplaylistnext
alias f5 mp3nplaylistprev
alias f8 mp3nsinglestop
aliad f9 mp3nrew
alias f10 mp3nff

;______________(Setup)______________

on *:load:{
  if ($version <= 5.80) {
    set %mp3n.continue $?!="Your version of mIRC is earlier than 5.8 and may cause mp3n to not operate correctly.  Continue anyway?"
    if (%mp3n.continue == $true) {
      mp3nchoosedir
      mp3nchoosemode
      echo Be sure to select "Choose Playlist" to set your current playlist before using any of the playlist options.
      echo You will probably experience problems running mp3n on your mIRC $version $+ . Download the newest version of mIRC at http://www.mirc.com
    }
    unset %mp3n.continue
    else unload -rs mp3n-v3.mrc
  }
  else {    
    mp3nchoosedir
    mp3nchoosemode
    echo Be sure to select "Choose Playlist" to set your current playlist before using any of the playlist options.
  }
}

alias mp3nchoosedir {
  set %mp3n.dirloc $$sdir="Choose Default Directory To Search For Files To Play:"
  echo 10((14-10mp14 $+ 310n14!14-10)|10(14Default Directory Set To: $+ 14 %mp3n.dirloc $+ 10)
  set %mp3n.mp3dirloc %mp3n.dirloc $+ *.mp3;*.wav;*.mid
  set %mp3n.playlistdirloc %mp3n.dirloc $+ *.m3u;*.pls
}

alias mp3nchoosechan {
  set %mp3n.defchan $?="Enter Default Channel to Send to (with the #)"
  echo 10((14-10mp14 $+ 310n14!14-10)|10(14Default Channel Set To: $+ 14 %mp3n.defchan $+ 10))
}

alias mp3nchoosemode {
  set %mp3n.disp $?!="Would you like to send Playlist song messages to a default channel? (Else they will go to a custom window - semi-silent mode)"
  if (%mp3n.disp == $false) {
    set %mp3n.defchan @mp3n
    echo 10((14-10mp14 $+ 310n14!14-10)|10(14Sending playlist song messages to custom window: $+ 14 %mp3n.defchan $+ 10))
  }
  else {
    set %mp3n.defchan $?="Enter Default Channel to Send to (with the #)"
    echo 10((14-10mp14 $+ 310n14!14-10)|10(14Sending to default channel: $+ 14 %mp3n.defchan $+ 10))
  }
  unset %mp3n.disp
}

;______________(Play)______________

;____(((Main Play)))____
alias mp3nplay {
  mp3nfileinfo
  if ($right(%mp3n.fileloc,3) == mp3) %mp3n.typeswitch = -p
  elseif ($right(%mp3n.fileloc,3) == mid) %mp3n.typeswitch = -m
  elseif ($right(%mp3n.fileloc,3) == wav) %mp3n.typeswitch = -w
  else echo Error - mp3n can only play .mp3, .wav, or .mid files.
  if (%mp3n.pltype == single) || (%mp3n.pltype == singlerand) {
    if ($active != @mp3n) say %mp3n.playtype $+ 10((14 $+ $nopath(%mp3n.fileloc) $+ 10)| 10|(14 $+ $bytes(%mp3n.fileinfo.size,m3).suf $+ 10)(14 $+ %mp3n.fileinfo.minutes $+ m $+ %mp3n.fileinfo.seconds $+ s $+ 10)(14 $+ %mp3n.fileinfo.bitrate $+ kbps $+ 10)(14 $+ $left(%mp3n.fileinfo.sample,2) $+ khz $+ 10)| 10|(14-10mp14 $+ 310n14!14-10)) 
    else msg %mp3n.defchan %mp3n.playtype $+ 10((14 $+ $nopath(%mp3n.fileloc) $+ 10)| 10|(14 $+ $bytes(%mp3n.fileinfo.size,m3).suf $+ 10)(14 $+ %mp3n.fileinfo.minutes $+ m $+ %mp3n.fileinfo.seconds $+ s $+ 10)(14 $+ %mp3n.fileinfo.bitrate $+ kbps $+ 10)(14 $+ $left(%mp3n.fileinfo.sample,2) $+ khz $+ 10)| 10|(14-10mp14 $+ 310n14!14-10))     
    splay %mp3n.typeswitch " $+ %mp3n.fileloc $+ "
    unset %mp3n.playtype
  }
  else {
    splay %mp3n.typeswitch " $+ %mp3n.fileloc $+ "
    unset %mp3n.playtype
  }
}

alias mp3n.plwindow.play {
  set %mp3n.fileloc $1-
  if ($right(%mp3n.fileloc,3) == mp3) %mp3n.typeswitch = -p
  elseif ($right(%mp3n.fileloc,3) == mid) %mp3n.typeswitch = -m
  elseif ($right(%mp3n.fileloc,3) == wav) %mp3n.typeswitch = -w
  splay %mp3n.typeswitch " $+ %mp3n.fileloc $+ "
}

;____(((Controls)))____
alias mp3nff {
  if ($inmp3 == $true) { splay seek $calc($inmp3.pos + 5000) }
  elseif ($inwave == $true) { splay seek $calc($inwave.pos + 5000) }
  elseif ($inmidi == $true) { splay seek $calc($inmidi.pos + 5000) }
  else halt
}

alias mp3nrew {
  if ($inmp3 == $true) { splay seek $calc($inmp3.pos - 5000) }
  elseif ($inwave == $true) { splay seek $calc($inwave.pos - 5000) }
  elseif ($inmidi == $true) { splay seek $calc($inmidi.pos - 5000) }
  else halt
}


;____(((Single)))____
alias mp3nsingleplay {
  set %mp3n.fileloc $$dir="Choose Single File To Play:" %mp3n.mp3dirloc
  set %mp3n.pltype single
  mp3nplay
}

alias mp3nsinglestop {
  splay stop
  echo 10((14Stop10))
}


;_________(((Playlist))))________
alias mp3nchooseplaylist {
  set %mp3n.playlistdirloc %mp3n.dirloc $+ *.m3u;*.pls
  set %mp3n.playlistloc $$dir="Choose Playlist File:" %mp3n.playlistdirloc
  echo 10((14Current Playlist Set To: 14 $+ %mp3n.playlistloc $+ 10)|(14-10mp14 $+ 310n14!14-10))
  set %mp3n.playlist.songnum 0
}

;___-(Playlist Load)-___
alias mp3nplaylistload {
  set %mp3n.playlistloadloc $$dir="Choose Playlist File:" %mp3n.playlistdirloc
  window -armdk0l @mp3nPlaylist mp3n-popup.txt
  set %mp3n.plinfo.lines $lines(%mp3n.playlistloadloc)
  loadbuf %mp3n.plinfo.lines -r @mp3nPlaylist %mp3n.playlistloadloc
  say 10((14Playlist 14 $+ $nopath(%mp3n.playlistloadloc) 14Loaded $+ 10)|(14-10mp14 $+ 310n14!14-10))
  echo Right click in the new window to play files or edit the playlist.
}

alias mp3n.plwindow.sort {
  window -S @mp3nPlaylist
}

alias mp3n.plwindow.add {
  set %mp3n.plwindow.addfile $$dir="Choose File To Add:" %mp3n.mp3dirloc
  aline @mp3nPlaylist %mp3n.plwindow.addfile
  unset %mp3n.plwindow.addfile
}

alias mp3n.plwindow.rem { 
  set %mp3n.plwindow.remtotlines $sline(@mp3nPlaylist,0)
  set %mp3n.plwindow.remtotlines2 $calc($sline(@mp3nPlaylist,1).ln + %mp3n.plwindow.remtotlines)
  dline @mp3nPlaylist $sline(@mp3nPlaylist,1).ln $+ - $+ %mp3n.plwindow.remtotlines2
  unset %mp3n.plwindow.remtotlines
  unset %mp3n.plwindow.remtotlines2
}

alias mp3n.plwindow.save {
  set %mp3n.plwindow.totlines $line(@mp3nPlaylist,0,1)
  set %mp3n.plwindow.plname " $+ %mp3n.dirloc $+ $?="Enter Filename (without extension) $crlf $+ Playlist Will Be Saved to Your Default mp3 Directory." $+ .m3u $+ "
  set %mp3n.plwindow.curline 0
  write -c %mp3n.plwindow.plname deleting...
  :start
  inc %mp3n.plwindow.curline 1
  write -l $+ %mp3n.plwindow.curline %mp3n.plwindow.plname $line(@mp3nPlaylist, %mp3n.plwindow.curline ,1)
  if (%mp3n.plwindow.curline != %mp3n.plwindow.totlines) { goto start }
  unset %mp3n.plwindow.curline
  unset %mp3n.plwindow.plname
  unset %mp3n.plwindow.totlines
}

alias mp3n.plwindow.create {
  window -c @mp3nplaylist
  window -mdk0l @mp3nPlaylist mp3n-popup.txt
  echo Right click in the new window to add/remove files then to save.
}

alias mp3n.plwindow.adddir {
  set %mp3n.plwindow.seldir $$sdir="Choose Directory To Load To Playlist:" %mp3n.dirloc
  set %mp3n.plwindow.addnum 0
  :start
  inc %mp3n.plwindow.addnum 1
  set %mp3n.plwindow.addfile $findfile( %mp3n.plwindow.seldir ,*.mp3, %mp3n.plwindow.addnum )
  if (%mp3n.plwindow.addfile != $null) { aline @mp3nPlaylist %mp3n.plwindow.addfile }
  if (%mp3n.plwindow.addfile != $null) { goto start }
  else { echo Directory Finished Loading }
  unset mp3n.plwindow.seldir
  unset %mp3n.plwindow.addnum
}

;______________

alias mp3nplaylistplay {
  set %mp3n.playlist.songnum 0
  inc %mp3n.playlist.songnum
  set %mp3n.playlistline -l $+ %mp3n.playlist.songnum
  set %mp3n.fileloc $read %mp3n.playlistline %mp3n.playlistloc
  set %mp3n.playtype 10((14Playlist10)| |
  set %mp3n.pltype plrepeat
  mp3nplay
  say 10((14Playlist Play ON10))
  if (%mp3n.defchan == @mp3n) {
    window -ark0 @mp3n 
    msg @mp3n 10((14Playlist Play ON10))
  }
  set %mp3n.fileloc.nopath $nopath(%mp3n.fileloc)
  set %mp3n.fileinfo.sample2 $left(%mp3n.fileinfo.sample,2)
  set %mp3n.playtype 10((14Playlist - %mp3n.playlist.songnum $+ 10)| |
  msg %mp3n.defchan %mp3n.playtype $+ 10((14 $+ %mp3n.fileloc.nopath $+ 10)| 10|(14 $+ $bytes(%mp3n.fileinfo.size,m3).suf $+ 10)(14 $+ %mp3n.fileinfo.minutes $+ m $+ %mp3n.fileinfo.seconds $+ s $+ 10)(14 $+ %mp3n.fileinfo.bitrate $+ kbps $+ 10)(14 $+ %mp3n.fileinfo.sample2 $+ khz $+ 10)| 10|(14-10mp14 $+ 310n14!14-10)) 
  unset %mp3n.fileloc.nopath
  unset %mp3n.fileinfo.sample2
  unset %mp3n.playtype
}

alias mp3n.playlist.stop {
  splay stop
  say 10((14Playlist Play OFF10))
  window -c @mp3n
}

alias mp3nplaylistnext {
  inc %mp3n.playlist.songnum 1
  set %mp3n.playlistline -l $+ %mp3n.playlist.songnum
  set %mp3n.fileloc $read %mp3n.playlistline %mp3n.playlistloc
  mp3nplay
  set %mp3n.fileloc.nopath $nopath(%mp3n.fileloc)
  set %mp3n.fileinfo.sample2 $left(%mp3n.fileinfo.sample,2)
  set %mp3n.playtype 10((14Playlist - %mp3n.playlist.songnum $+ 10)| |
  msg %mp3n.defchan %mp3n.playtype $+ 10((14 $+ %mp3n.fileloc.nopath $+ 10)| 10|(14 $+ $bytes(%mp3n.fileinfo.size,m3).suf $+ 10)(14 $+ %mp3n.fileinfo.minutes $+ m $+ %mp3n.fileinfo.seconds $+ s $+ 10)(14 $+ %mp3n.fileinfo.bitrate $+ kbps $+ 10)(14 $+ %mp3n.fileinfo.sample2 $+ khz $+ 10)| 10|(14-10mp14 $+ 310n14!14-10)) 
  unset %mp3n.fileloc.nopath
  unset %mp3n.fileinfo.sample2
  unset %mp3n.playtype
}

alias mp3nplaylistprev {
  dec %mp3n.playlist.songnum 1
  set %mp3n.playlistline -l $+ %mp3n.playlist.songnum
  set %mp3n.fileloc $read %mp3n.playlistline %mp3n.playlistloc
  set %mp3n.playtype 10((14Playlist10)| |
  mp3nplay
}

alias mp3nplaylistrandom {
  set %mp3n.fileloc $read %mp3n.playlistloc
  set %mp3n.pltype singlerand
  set %mp3n.playtype 10((14Random10)| |
  mp3nplay
}

alias mp3nplrandON {
  set %mp3n.fileloc $read %mp3n.playlistloc
  if (%mp3n.pltype != randrepeat) { 
if ($active != @mp3n) say 10((14Random Playlist Play ON10)) 
else msg %mp3n.defchan 10((14Random Playlist Play ON10)) 
}
  if (%mp3n.defchan == @mp3n) && ($window(@mp3n).mdi == $null) { window -k0 @mp3n }
  set %mp3n.pltype randrepeat
  mp3nplay
  set %mp3n.fileloc.nopath $nopath(%mp3n.fileloc)
  set %mp3n.fileinfo.sample2 $left(%mp3n.fileinfo.sample,2)
  set %mp3n.playtype 10((14Playlist Random10)| |
  msg %mp3n.defchan %mp3n.playtype $+ 10((14 $+ %mp3n.fileloc.nopath $+ 10)| 10|(14 $+ $bytes(%mp3n.fileinfo.size,m3).suf $+ 10)(14 $+ %mp3n.fileinfo.minutes $+ m $+ %mp3n.fileinfo.seconds $+ s $+ 10)(14 $+ %mp3n.fileinfo.bitrate $+ kbps $+ 10)(14 $+ %mp3n.fileinfo.sample2 $+ khz $+ 10)| 10|(14-10mp14 $+ 310n14!14-10)) 
  unset %mp3n.fileloc.nopath
  unset %mp3n.fileinfo.sample2
  unset %mp3n.playtype
}

alias mp3nplrandOFF {
  splay stop
  if (%mp3n.pltype == randrepeat) say 10((14Random Playlist Play OFF10))
  else echo ERROR: Random Playlist Play is not ON.
  unset %mp3n.pltype
  window -c @mp3n
}

on *:start:unset %mp3n.pltype

on *:midiend: { if (%mp3n.pltype == randrepeat) { mp3nplrandON } 
  if (%mp3n.pltype == plrepeat) { mp3nplaylistnext }
}
on *:wavend: { if (%mp3n.pltype == randrepeat) { mp3nplrandON }
  if (%mp3n.pltype == plrepeat) { mp3nplaylistnext }
}
on *:mp3end: {  if (%mp3n.pltype == randrepeat) { mp3nplrandON } 
  if (%mp3n.pltype == plrepeat) { mp3nplaylistnext }
}

;______________(File Info)______________

alias mp3nfileinfo {
  %mp3n.fileinfo.nopath = $nopath(%mp3n.fileloc)
  %mp3n.fileinfo.size = $file(%mp3n.fileloc).size
  %mp3n.fileinfo.bitrate = $mp3(%mp3n.fileloc).bitrate
  %mp3n.fileinfo.sample = $mp3(%mp3n.fileloc).sample
  %mp3n.fileinfo.length = $mp3(%mp3n.fileloc).length
  %mp3n.fileinfo.actuallength = $calc($len(%mp3n.fileinfo.length)-3)
  %mp3n.fileinfo.totalseconds = $left(%mp3n.fileinfo.length,%mp3n.fileinfo.actuallength)
  if (. isin $calc( %mp3n.fileinfo.totalseconds / 60)) { %mp3n.fileinfo.minutes = $left($calc(%mp3n.fileinfo.totalseconds / 60),$calc($pos($calc(%mp3n.fileinfo.totalseconds / 60),.,1)-1)) }
  else { %mp3n.fileinfo.minutes = $calc( %mp3n.fileinfo.totalseconds / 60) }
  %mp3n.fileinfo.seconds = $calc(%mp3n.fileinfo.totalseconds - %mp3n.fileinfo.minutes * 60)
}

;______________(Make List)______________

alias mp3n.makelist {
  echo Creating List of mp3n Default Directory and Its Subdirectories. (this may take a while)...
  window -armdk0l @mp3nFileList mp3n-popup.txt
  set %mp3n.makelist.addnum 0
  :start
  inc %mp3n.makelist.addnum 1
  set %mp3n.makelist.addfile $findfile( %mp3n.dirloc ,*.mp3, %mp3n.makelist.addnum , 10,@mp3nFileList )
  if (%mp3n.makelist.addfile != $null) { write mp3nFileList.txt $nopath(%mp3n.makelist.addfile) }
  if (%mp3n.makelist.addfile != $null) { goto start }
  else { echo File List Creation Complete. Your File List is Located in The Same Directory the mp3n script file is in. }
  unset mp3n.makelist.addnum
  unset mp3n.makelist.addfile
}
;______________(Menu)______________

menu query,nicklist,channel,@mp3nplaylist,@mp3n {
  -
  mp3n!
  .Single File
  ..> Single Play...:mp3nsingleplay
  ..[] Single Stop:mp3nsinglestop
  .Playlist
  ..Choose Playlist...:mp3nchooseplaylist
  ..-
  ..Playlist Play On:mp3nplaylistplay
  ..Playlist Play Controls
  ...>> Next Song:mp3nplaylistnext
  ...<< Previous Song:mp3nplaylistprev
  ...[] Stop:mp3n.playlist.stop
  ..-
  ..Random Single File From Playlist:mp3nplaylistrandom
  ..Random Playlist Play
  ...On:mp3nplrandON
  ...Off:mp3nplrandOFF
  ..-
  ..Create Playlist...:mp3n.plwindow.create
  ..Load Playlist...:mp3nplaylistload
  .-
  .Setup
  ..Default mp3 Directory:mp3nchoosedir
  ..-
  ..Default Channel:mp3nchoosechan
  ..Display Mode:mp3nchoosemode
  ..-
  ..Create .txt File List:mp3n.makelist
  ..Advertise:say 10((14Running 10(14-10mp14 $+ 310n14!14-10)14 v3.0 by Pendragon - Visit http://www.edgefiles.cjb.net for more info10))
  ..Help:mp3nhelp
  ..-
  ..Uninstall:mp3nuninstall
}

ctcp 1:VERSION:*:.ctcpreply $nick VERSION 10((14Running 10(14-10mp14310n14!14-10)14 v2.0 by Pendragon - http://www.edgefiles.cjb.net10))

;______________(Help)______________
alias mp3nhelp {
  echo _____________________________________
  echo mp3n Help:
  echo --------------------------------------------------
  echo After Selecting "Playlist Play On":
  echo Instead of using the menu controls, you may use the function keys:
  echo f5: next song
  echo f6: previous song
  echo --------------------------------------------------
  echo Any Time While a File is Playing:
  echo f8: stop
  echo f9: rewind
  echo f10: fast forward
  echo --------------------------------------------------
  echo Tip: try creating a playlist with all the songs you currently listen to and then pick and choose what you want to hear
  echo _____________________________________
}

;______________(Uninstall)______________
alias mp3nuninstall {
  if ($?!="Are you sure you want to uninstall mp3n v3.0?" == $true) {
    unset %mp3n.*
    echo mp3n v3.0 Uninstallation Complete.  Please visit http://www.edgefiles.cjb.net for the latest version.
    unload -rs mp3n-v3.mrc
  }
  else halt
}
