;lag check by kocain
;#kocain on irc.dal.net

alias durat { return $remove($replace($duration($1-),wks,w,wk,w,days,d,day,d,hrs,h,hr,h,mins,m,min,m,secs,s,sec,s),$chr(32)) }

alias lag.check { 
  unset %lag
  .raw ping $server
  set %ping.time $ctime
}

on *:pong: {
  if (%ping.time != $null) {
    set %lag $durat($calc($ctime - %ping.time))
    unset %ping.time
    echo -a * calculating lag...pls wait
    .timer 1 2 lag.s
  }
}

alias lag { return %lag }

alias lag.s {
  var %x = $remove(%lag,w,d,h,m,s)
  window -adp @lag 270 300 400 90
  drawtext -bp @lag 0 1 Verdana 14 5 5 Your ping from $server is $lag $+ .
  if (%x < 1) { 
    drawtext -bp @lag 0 1 Verdana 14 5 22 Meter: $str(|,20)
    drawtext -bp @lag 0 1 Verdana 14 5 40 Advice: No lag. Don't reconnect!
  }
  elseif (%x < 4) {
    drawtext -bp @lag 0 1 Verdana 14 5 22 Meter: $str(|,%x) $+ $str(|,$calc(20 - %x))
    drawtext -bp @lag 0 1 Verdana 14 5 40 Advice: Not bad, Check again in a few minutes!
  }
  elseif (%x < 5) {
    drawtext -bp @lag 0 1 Verdana 14 5 22 Meter: $str(|,%x) $+ $str(|,$calc(20 - %x))
    drawtext -bp @lag 0 1 Verdana 14 5 40 Advice: Check lag in a few minutes, if over 5s, reconnect! 
  }
  elseif (%x > 5) {
    drawtext -bp @lag 0 1 Verdana 14 5 22 Meter: $str(|,%x) $+ $str(|,$calc(20 - %x))
    drawtext -bp @lag 0 1 Verdana 14 5 40 Advice: Reconnect, could be much better!
  }
  elseif (%x = 10) {
    drawtext -bp @lag 0 1 Verdana 14 5 22 Meter: $str(|,%x) $+ $str(|,$calc(20 - %x))
    drawtext -bp @lag 0 1 Verdana 14 5 40 Advice: Reconnect, horrible lag!
  }
  elseif (%x > 10) {
    drawtext -bp @lag 0 1 Verdana 14 5 22 Meter: $str(|,%x) $+ $str(|,$calc(20 - %x))
    drawtext -bp @lag 0 1 Verdana 14 5 40 Advice: Reconnect, horrible lag!
  }
  elseif (%x > 18) {
    drawtext -bp @lag 0 1 Verdana 14 5 22 Meter: $str(|,%x) $+ $str(|,$calc(20 - %x))
    drawtext -bp @lag 0 1 Verdana 14 5 40 Advice: Find a new server, this one is WAY to lagged!
  }
}

