on 1:LOAD:{
  echo -a explorer!v1.4
  echo -a type /explorer <directory> to begin
}
+
dialog explorer {
  title "explorer"
  size 100 92 260 145
  option dbu
  button "Exit",1,230 115 25 10,ok
  button "Open",2,230 49 25 10
  button "Delete",3,230 61 25 10
  button "Move",4,230 73 25 10
  button "Rename",5,230 85 25 10
  button "Open",6,2 49 25 10
  button "Delete",7,2 61 25 10
  button "Refresh",8,2 73 25 10
  button "New",9,2 85 25 10
  button "Search",10,230 5 25 10
  list 11,28 5 100 130,sort vsbar
  list 12,128 18 100 114,sort vsbar hsbar extsel
  edit "",20,128 5 100 10,autohs
  text "25 files",30,130 125 100 10
  text "Free space:",31,28 125 100 10
  text "Used space:",32,28 132 100 10
  text "Total space:",33,130 132 100 10
}
+
alias explorer {
  if ($1 == $null) {
    set %explorer.dir $mircdir
    goto explorer
  }
  else {
    set %explorer.dir $1-
    goto explorer
  }
  :explorer
  if ($isdir(%explorer.dir) == $false) {
    echo -a Error: No such directory ( $+ $1- $+ )
    halt
  }
  dialog -m explorer explorer
}
+
on 1:DIALOG:explorer:init:0:{
  if (%explorer.dir) {
    explorer.dir %explorer.dir
    explorer.file * %explorer.dir
  }
}
+
on 1:DIALOG:explorer:sclick:2:{
  if ($did($dname,12).seltext) run " $+ %explorer.cdir $+ $did($dname,12).seltext $+ "
}
+
on 1:DIALOG:explorer:sclick:3:{
  if ($did($dname,12).seltext) {
    if ($did($dname,12,0).sel == 1) var %explorer.del = $?!="Are you sure you want to delete $crlf $+ %explorer.cdir $+ $did($dname,12).seltext $+ ?"
    else var %explorer.del = $?!="Are you sure you want to delete these $did($dname,12,0).sel files?"
    if (%explorer.del == $false) halt
    var %explorer.del.var = 1
    while (%explorer.del.var <= $did($dname,12,0).sel) {
      .remove " $+ %explorer.cdir $+ $did($dname,12,$did($dname,12,%explorer.del.var).sel).text $+ "
      did -d explorer 12 $did($dname,12,%explorer.del.var).sel
      inc %explorer.del.var
    }
    if ($did($dname,12).seltext) {
      .remove " $+ %explorer.cdir $+ $did($dname,12).seltext $+ "
      did -d $dname 12 $did($dname,12,$did($dname,12,0).sel).sel
    }
  }
}
+
on 1:DIALOG:explorer:sclick:4:{
  if ($did($dname,12).seltext) {
    var %explorer.mdir = $sdir($left(%explorer.dir,2),Select directory to move to)
    if (%explorer.mdir == $null) halt
    if ($isfile(%explorer.mdir $+ $did($dname,12).seltext) == $true) {
      echo -a Error: File already exists ( %+ %explorer.mdir $+ $did($dname,12).seltext $+ )
      halt
    }
    .rename " $+ %explorer.cdir $+ $did($dname,12).seltext $+ " " $+ %explorer.mdir $+ $did($dname,12).seltext $+ "
    did -d explorer 12 $did($dname,12,$did($dname,12,0).sel).sel
  }
}
+
on 1:DIALOG:explorer:sclick:5:{
  if ($did($dname,12).seltext) {
    var %explorer.rfile = $?="Rename $crlf $+ %explorer.cdir $+ $did($dname,12).seltext $crlf $+ to:"
    var %explorer.rfile = %explorer.cdir $+ $nopath(%explorer.rfile)
    if (%explorer.rfile == $null) halt
    if ($isfile(%explorer.rfile) == $true) {
      echo -a Error: File already exists ( $+ %explorer.rfile $+ )
      halt
    }
    .rename " $+ %explorer.cdir $+ $did($dname,12).seltext $+ " " $+ %explorer.rfile $+ "
    did -o explorer 12 $did($dname,12,$did($dname,12,0).sel).sel $nopath(%explorer.rfile)
  }
}
+
on 1:DIALOG:explorer:sclick:6:{
  if ($did($dname,11).seltext) {
    if ($did($dname,11).seltext == \..) {
      explorer.file * $explorer.dirup(%explorer.cdir)
      explorer.dir $explorer.dirup(%explorer.cdir)
    }
    else {
      explorer.file * %explorer.cdir $+ $did($dname,11).seltext
      explorer.dir %explorer.cdir $+ $did($dname,11).seltext
    }
  }
}
+
on 1:DIALOG:explorer:sclick:7:{
  if ($did($dname,11).seltext) {
    if ($did($dname,11).seltext != \..) {
      var %explorer.ddir = $?!="Are you sure you want to delete the folder $crlf $+ %explorer.cdir $+ $did($dname,11).seltext $crlf $+ and all its contents?"
      if (%explorer.ddir == $false) halt
      explorer.ddir %explorer.cdir $+ $did(explorer,11).seltext
      did -d explorer 11 $did(explorer,11).sel
    }
  }
}
+
on 1:DIALOG:explorer:sclick:8:{
  if (%explorer.cdir) {
    explorer.file * %explorer.cdir
    explorer.dir %explorer.cdir
  }
}
+
on 1:DIALOG:explorer:sclick:9:{
  var %explorer.ndir = $?="Enter name for new directory:"
  var %explorer.ndir = %explorer.cdir $+ $nopath(%explorer.ndir)
  if (%explorer.ndir == $null) halt
  if ($isdir(%explorer.ndir)) {
    echo -a Error: Directory already exists ( $+ %explorer.ndir $+ )
    halt
  }
  .mkdir " $+ %explorer.ndir $+ "
  if ($dialog(explorer)) did -a explorer 11 $nopath(%explorer.ndir)
}
+
on 1:DIALOG:explorer:sclick:10:{
  if (($did($dname,20).text) && (%explorer.cdir)) {
    var %explorer.search = $?!="WARNING: $crlf $+ Searching for files may freeze your mIRC for a long period of time. $crlf $+ Do you still wish to proceed?"
    if (%explorer.search == $false) halt
    explorer.search $gettok($did($dname,20).text,1,32)
  }
}
+
on 1:DIALOG:explorer:dclick:12:{
  if ($did($dname,12).seltext) run " $+ %explorer.cdir $+ $did($dname,12).seltext $+ "
}
+
on 1:DIALOG:explorer:dclick:11:{
  if ($did($dname,11).seltext) {
    if ($did($dname,11).seltext == \..) {
      explorer.file * $explorer.dirup(%explorer.cdir)
      explorer.dir $explorer.dirup(%explorer.cdir)
    }
    else {
      explorer.file * %explorer.cdir $+ $did($dname,11).seltext
      explorer.dir %explorer.cdir $+ $did($dname,11).seltext
    }
  }
}
+
alias explorer.dir {
  if ($1 == $null) halt
  if ($dialog(explorer)) {
    did -r explorer 11
    did -a explorer 11 \..
    var %explorer.dir.num = $finddir($1-,*,0,$calc($numtok($1-,92) - 1))
    var %explorer.dir.var = 1
    while (%explorer.dir.var <= %explorer.dir.num) {
      did -a explorer 11 $nopath($finddir($1-,*,%explorer.dir.var))
      inc %explorer.dir.var
    }
    if ($right($1-,1) == \) set %explorer.cdir $1-
    else set %explorer.cdir $1- $+ \
    explorer.stats %explorer.cdir
  }
}
+
alias explorer.dirup {
  if ($1 == $null) return
  if ($isdir($1-) == $false) return
  return $deltok($1-,$numtok($1-,92),92)
}
+
alias explorer.file {
  if ($2 == $null) halt
  if ($dialog(explorer)) {
    did -r explorer 12
    var %explorer.file.num = $findfile($2-,$1,0,$calc($numtok($2-,92) - 1))
    var %explorer.file.var = 1
    while (%explorer.file.var <= %explorer.file.num) {
      did -az explorer 12 $nopath($findfile($2-,$1,%explorer.file.var))
      inc %explorer.file.var
    }
  }
}
+
alias explorer.dsize {
  if ($1 == $null) halt
  if ($isdir($1-) == $false) halt
  var %explorer.dsize.num = $findfile($1-,*,0,$calc($numtok($1-,92) - 1))
  var %explorer.dsize.var = 1
  while (%explorer.dsize.var <= %explorer.dsize.num) {
    var %explorer.dsize = $calc(%explorer.dsize + $lof($findfile($1-,*,%explorer.dsize.var)))
    inc %explorer.dsize.var
  }
  return $bytes(%explorer.dsize).suf
}
+
alias explorer.ddir {
  if ($1 == $null) halt
  if ($isdir($1-) == $false) halt
  :file
  var %explorer.ddir.num = $findfile($1-,*,0)
  var %explorer.ddir.var = 1
  while ($findfile($1-,*,%explorer.ddir.var)) {
    .remove " $+ $findfile($1-,*,%explorer.ddir.var) $+ "
    inc %explorer.ddir.var
  }
  if ($findfile($1-,*,0) >= 1) goto file
  else explorer.ddir2 $1-
}
+
alias explorer.ddir2 {
  if ($1 == $null) halt
  :dir
  var %explorer.ddir.num = $finddir($1-,*,0)
  var %explorer.ddir.var = 1
  while ($finddir($1-,*,%explorer.ddir.var)) {
    if ($finddir($finddir($1-,*,%explorer.ddir.var),*,0) == 0) .rmdir " $+ $finddir($1-,*,%explorer.ddir.var) $+ "
    inc %explorer.ddir.var
  }
  if ($finddir($1-,*,0) >= 1) goto dir
  else .rmdir " $+ $1- $+ "
}
+
alias explorer.stats {
  if ($1 == $null) halt
  if ($dialog(explorer)) {
    did -r explorer 30
    did -a explorer 30 $findfile($1-,*,0,$calc($numtok($1-,92) - 1)) files ( $+ $explorer.dsize($1-) $+ )
    did -r explorer 31
    did -a explorer 31 Free space: $bytes($disk($left($1-,2)).free).suf
    did -r explorer 32
    did -a explorer 32 Used space: $bytes($calc($disk($left($1-,2)).size - $disk($left($1-,2)).free)).suf
    did -r explorer 33
    did -a explorer 33 Total space: $bytes($disk($left($1-,2)).size).suf
  }
}
+
alias explorer.search {
  if ($1 == $null) halt
  if ($dialog(explorer)) {
    did -r explorer 12
    did -az explorer 12 Searching...
    var %explorer.search.num = $findfile($left(%explorer.dir,2),$1,0)
    if (%explorer.search.num == 0) {
      did -r explorer 12
      did -az explorer 12 No matches found!
      halt
    }
    did -r explorer 12
    did -az explorer 12 %explorer.search.num matches found:
    var %explorer.search.var = 1
    while (%explorer.search.var <= %explorer.search.num) {
      did -az explorer 12 $findfile($left(%explorer.dir,2),$1,%explorer.search.var)
      inc %explorer.search.var
    }
  }
}
menu menubar,status,channel,query {
explorer:explorer
}
