;
;  dur.mrc by moho
;                  version 2.20
;  
;  contact:  email: moho@punkass.com
;              irc: moho on dalnet
;
;  help: [*this might look screwed if youre not using a fixed-width font*]
;
;  usage: $dur(<seconds|ticks>)[.<[t|t-][f|g][z|y|w|d|h|m|s|c|c+|c=][1|2|0]>]
;
;  the main parameter requres a whole number of seconds or ticks (whith an exception, see comments)
;  if the number given is ticks, the properties 't'/'t-' and/or 'u'/'i' should be given.
;  in addition to this, one of the following parameters may also be supplied: z,y,w,d,h,m,s,c,c+,c=
;  this will determine where the span of the duration will end, and in what format it will be returned.
;    'u' and 'i' are kinda special cases, read below. '1', '2' and '0' will round decimals if applicable.
;  
;  properties and what they do:
;
;  t    designates calculations will be based on ticks. there will be a decimal output (if possible).
;  t-   designates calculations will be based on ticks. there will NOT be a decimal output.
;         + this will override any other decimal specifications [0,1,2]
;
;  u    input must be in ticks. basically it just sticks a 'ms' on the end of the string. [VERY efficient ;P]
;  i    input must be in ticks. sticks a 'ms' on the end of the string if its >= 1000.
;
;  z    output will have all time units (with weeks), including years (based on 365-day year).
;  y    output will have all time units (without weeks), including years (based on 365-day year).
;  w    output will have all time units up to weeks.
;  d    output will have all time units up to days.
;  h    output will have all time units up to hours.
;  m    output will have all time units up to minutes.
;  s    output will have all time units up to seconds. [wow!]
;  c    output will be in a "time" format (00:00), including hours and minutes. [c stands for clock]
;  c+   as above, but also with seconds (00:00:00)
;  c=   as above, but also with milliseconds (00:00:00.000) if the number is in ticks.
;
;  1    will round decimals to one decimal place if applicable.
;  2    will round decimals to two decimal places if applicable.
;  0    will not show any decimal places. [might not work too well.. kinda dodgy (?)]
;         + you can generally use t- for this.. in fact its probably a good idea. i think.
;
;  comments:
;  * if NO properties are supplied, or the only property supplied doesnt give a max unit, then $dur will
;    default to a "d"-type time, with the maximum showed units being days. this is set by %default
;    during alias initialisation. i guess you can change it if you want (dont be complex.. things like
;    the 'c' params just wont work properly as a default)
;
;  * the "t" and "t-" are really just calculating the duration based on the number supplied, excluding
;    the final 3 digits, which are treated as decimal seconds.
;
;  * i really cant be bothered trying to calculate leap years.. its actually harder to do accurately than
;    it might sound. its not even CLOSE to being worth the speed degradation.
;
;  * i realise this could be more thoroughly error checked, but seeing as this is the kind of script that
;    might be used every second, and only by people who have some mirc knowledge, i dont think its
;    necessary to go to all that trouble. it feels pretty big already, but im not noticing a speed drop
;    just yet...
;
;  * i removed false parameter checking.. it was getting really big with these new features and would need
;    to get complex to work right. so, just be careful. feeidng it wird params could cause it to "default"
;    to days and other quirky things.
;
;  * you may have noticed that the "weeks" unit is neglected here, unlike in mirc. here it is only
;    used in the "w"-type $dur, because it is harder to mentally caculate time using the moronic system of
;    seven-day periods. if you want weeks in your "y"-type $dur, tough luck.
;
;  * Update: Due to popular demand, a "y"-type dur with weeks has been included: "z" parameter.
;
;  * IMPORTANT! $dur has a feature that will try to automatically detect and use tick-type durations
;    even if no "t*" property is supplied. if the duration supplied contains a "." (ie it is a decimal
;    number) then $dur will treat it as a tick duration which has been pre-divided. this had a problem,
;    however, when the number supplied ends with three 0s, and therefore may have no decimal place.
;      eg: $dur($calc(6786875000 / 1000)).h
;    here a decimal place will not exist, so it will not be treated as a tick duration. therefore, it
;    is best to include the .t* property whenever possible, and not to rely on automatic detection.
;
;  **CONDITIONS OF USE**:
;    Okay, i dont mind a lot how you use it, and if can understand what its doing youre free to alter
;    it a bit. BUT, i wont stand for people claiming this as their own work. Just dont do it. Anyway,
;    feel free to use this in your private scripts all you like.
;      If youre putting in a puclically available script, give me credit for this script somewhere,
;    keep the first six comment lines at LEAST in the file, and send me an email or msg/memo me so
;    i know someone is actually using this thing :P
;             (you can do that even if youre not distributing it.. a scripters life is a lonely one.)

alias dur {
  var %x = $prop, %default = d
  if (%x == $null) { %x = %default }
  if (f isin %x) { return $1 $+ ms }
  var %dur = $1, %t, %c, %negative, %tp = .s, %round
  if (- isin %dur) { %dur = $remove(%dur,-) | %negative = 1 }
  if (. isin %dur) { %dur = $calc(%dur * 1000) | %t = 1 }
  if (g isin %x) {
    if (%dur < 1000) { return $1 $+ ms }
    elseif (t !isin %x) { %x = $replace(%x,g,t) }
    else { %x = $remove(%x,g) }
  }
  if (0 isin %x) { %x = $remove($replace(%x,t,t-),0) }
  elseif (1 isin %x) { %x = $remove(%x,1) | %round = 1 }
  elseif (2 isin %x) { %x = $remove(%x,2) | %round = 2 }
  if (t- isin %x) {
    %x = $remove(%x,t-)
    if (%x == $null) { %x = %default }
    if (%t == 1) { %t = 0 }
    %dur = $round($calc(%dur / 1000),0)
  }
  if ((t isin %x) || (%t)) {
    %x = $remove(%x,t)
    if (%x == $null) { %x = %default }
    var %t = 1, %tt = $calc(%dur / 1000), %dur = $gettok(%tt,1,46), %tp = . $+ $gettok(%tt,2,46) $+ s
    if (%round) { %tp = . $+ $remove($round($remove(%tp,s),%round),0.) $+ s }
  }
  if (c isin %x) { %x = h | %c = 1 }
  tokenize 32 $tdur(%dur)
  var %y = 0, %w = $1, %d = $2, %h = $3, %m = $4, %s = $5, %rem, %out
  if (%x == w) { goto end }
  %d = $calc((%w * 7) + %d)
  %w = 0
  if (%x == z) { %y = $int($calc(%d / 365)) | %d = $calc(%d % 365) | %w = $int($calc(%d / 7)) | %d = $calc(%d % 7) }
  elseif (%x == y) { %y = $int($calc(%d / 365)) | %d = $calc(%d % 365) }
  elseif (%x == d) { }
  elseif (%x == h) { %h = $calc(%h + (%d * 24)) | %d = 0 }
  elseif (%x == m) { %m = $calc(%m + (%d * 1440) + (%h * 60)) | %d = 0 | %h = 0 }
  elseif (%x == s) { %s = $calc(%s + (%d * 86400) + (%h * 3600) + (%m * 60)) | %d = 0 | %h = 0 | %m = 0 }
  :end
  %out = $iif(%y,$merge(%y,y)) $iif(%w,$merge(%w,w)) $iif(%d,$merge(%d,d)) $iif(%h,$merge(%h,h)) $iif(%m,$merge(%m,m)) $iif(%s,$merge(%s,s))
  if (%t) {
    if (%s) { %out = $replace(%out,s,%tp) }
    else { %out = %out 0 $+ %tp }
    %out = $replace(%out,..,.,.s,s)
  }
  if (%c) {
    var %ch = $remove($wildtok(%out,*h,1,32),h), %cm = $remove($wildtok(%out,*m,1,32),m), %cs = $remove($remove($wildtok(%out,*s,1,32),m),s)
    %out = $iif(%ch,$base(%ch,10,10,2),00) $+ : $+ $iif(%cm,$base(%cm,10,10,2),00)
    if (c+ isin $prop) { %out = %out $+ : $+ $base($round(%cs,0),10,10,2) }
    if (c= isin $prop) {
      %out = %out $+ : $+ $base($round(%cs,0),10,10,2)
      if (%tp != .s) { %out = %out $+ $remove(%tp,s) }
      else { %out = %out }
    }
  }
  if (%out == $null) { %out = 0s }
  if (%negative) { %out = - $+ %out }
  return %out
}
alias -l tdur {
  var %tdur = $duration($$1)
  var %tdur.w = $round($wildtok(%tdur,*wk*,1,32),0) | if (%tdur.w == $null) { %tdur.w = 0 }
  var %tdur.d = $round($wildtok(%tdur,*day*,1,32),0) | if (%tdur.d == $null) { %tdur.d = 0 }
  var %tdur.h = $round($wildtok(%tdur,*hr*,1,32),0) | if (%tdur.h == $null) { %tdur.h = 0 }
  var %tdur.m = $round($wildtok(%tdur,*min*,1,32),0) | if (%tdur.m == $null) { %tdur.m = 0 }
  var %tdur.s = $round($wildtok(%tdur,*sec*,1,32),0) | if (%tdur.s == $null) { %tdur.s = 0 }
  return %tdur.w %tdur.d %tdur.h %tdur.m %tdur.s
}
alias -l merge { return $remove($1-,$chr(32)) }
