;*************************************************
;* Project.name: DALnet services                 *
;* Version.....: 4.0                             *
;* Part 1......: menus and dialogs definitions   *
;                general raw/events              *
;* Author......: blaster^ @mIRC DALnet irc       *
;* E-mail......: blaster@irc-scripts.com         *
;* Homepage....:                                 *
;*                                               *
;* Initial dialog design done using              *
;* projectx editor - http://www.projectx.mx.dk   *
;*************************************************
;*************************************************
;*  menu                                         *
;*************************************************
menu channel,menubar {
  $iif( DALnet === $network, Services ) 
  .$iif( (CS isin $level(ChanServ!service@dal.net)) && ($dialog(CS) == $null), Chanserv ) :{ if ($menu == menubar) { set %CS.title ChanServ : $+ $$?="wich channel?" } | else { set %CS.title ChanServ : $+ $chan } | dialog -m CS CS }
  .$iif( (NS isin $level(NickServ!service@dal.net)) && ($dialog(NS) == $null), NickServ ) :{ if ($menu == menubar) { set %NS.title NickServ : $+ $$?="wich nick?" } | else { set %NS.title NickServ : $+ $me } | dialog -m NS NS }
  .$iif( (SS isin $level(StatServ!stats@dal.net)) && ($dialog(SS) == $null), StatServ ) :{ dialog -m SS SS }
  .Help :{ run http://www.dal.net/services/index.php3 }
  .$iif( DALnet === $network, Notify list infos )
  ..check:raw -q watch l
  ..stats:raw -q watch s
}

;*************************************************
;*                                               *
;*  Dialogs definition                           *
;*                                               *
;*************************************************
dialog Wrn {
  title "Error!!!"
  size -1 -1 200 50
  option dbu

  button "OK", 1, 85 35 30 10, cancel
  text "", 2, 5 5 190 10
  text "", 3, 5 15 190 10
  text "", 4, 5 25 190 10
}

;*************************************************
;   Main Chanserv dialog                         *
;*************************************************
dialog CS  {
  title %CS.title
  size -1 -1 200 125
  option dbu

  tab "status", 1, 5 5 190 115
  tab "usefull cmd", 2
  tab "settings", 3
  tab "mlock", 4
  tab "cs lists", 5
  tab "misc", 6

  button "close", 200, 1 1 35 10, cancel, hide

  list 202, 10 22 180 78, extsel, size, hsbar, tab 1
  button "start logging", 203, 10 105 35 10, tab 1
  button "stop logging", 204, 46 105 35 10, tab 1
  button "clear log file", 205, 82 105 35 10, tab 1
  button "clear status", 206, 118 105 35 10, tab 1
  button "copy", 207, 154 105 35 10, tab 1

  box "founder access", 10, 10 22 45 93, tab 2
  box "sop access", 11, 55 22 45 93, tab 2
  box "aop access", 12, 100 22 45 93, tab 2
  box "free access", 13, 145 22 45 93, tab 2

  button "register", 20, 15 33 35 10, tab 2
  button "identify", 21, 15 44 35 10, tab 2
  button "set", 22, 15 55 35 10, tab 2
  button "drop", 23, 15 66 35 10, tab 2
  button "sop", 24, 15 77 35 10, tab 2

  button "aop", 25, 60 33 35 10, tab 2
  button "akick", 26, 60 44 35 10, tab 2
  button "mkick", 27, 60 66 35 10, tab 2

  button "op", 28, 105 33 35 10, tab 2
  button "deop", 29, 105 44 35 10, tab 2
  button "mdeop", 30, 105 55 35 10, tab 2
  button "unban", 31, 105 66 35 10, tab 2
  button "invite me", 32, 105 77 35 10, tab 2
  button "access", 33, 105 88 35 10, tab 2
  button "why", 34, 105 99 35 10, tab 2

  button "info", 36, 150 33 35 10, default, tab 2
  button "count", 37, 150 44 35 10, tab 2

  button "Founder", 40, 10 22 35 10, tab 3
  button "Password", 41, 10 33 35 10, tab 3
  button "Desc", 42, 10 44 35 10, tab 3
  button "URL", 43, 10 55 35 10, tab 3
  button "ModeLock", 44, 10 66 35 10, tab 3
  check "KeepTopic", 45, 46 22 56 10, tab 3
  radio "TopicLock Founder", 46, 46 32 56 10, group, tab 3
  radio "TopicLock SOP", 47, 46 42 56 10, tab 3
  radio "TopicLock OFF", 48, 46 52 56 10, tab 3

  check "Verbose", 55, 46 72 40 10, tab 3
  check "OpGuard", 49, 103 22 40 10, tab 3
  check "LeaveOps", 50, 103 32 40 10, tab 3
  check "Restrict", 51, 103 42 40 10, tab 3
  check "UnSecure", 52, 103 52 40 10, tab 3
  check "Ident", 53, 103 62 40 10, tab 3
  check "Private", 54, 103 72 40 10, tab 3

  radio "Memo Founder", 56, 144 22 47 10, group, tab 3
  radio "Memo SuperOP", 57, 144 32 47 10, tab 3
  radio "Memo AutoOp", 58, 144 42 47 10, tab 3
  radio "Memo None", 59, 144 52 47 10, tab 3

  box  "", 60, 10 82 180 33, tab 3
  edit "", 61, 15 91 170 10, size, tab 3
  button "Cancel", 62, 15 102 85 10, tab 3
  button "Valid", 63, 100 102 85 10, tab 3

  text "mode", 70, 120 22 70 10, tab 4
  button "Cancel", 71, 120 32 30 10, tab 4
  button "Valid", 72, 150 32 30 10, tab 4

  text "Off", 73, 80 22 10 10, tab 4
  text "+", 74, 92 22 10 10, tab 4
  text "--", 75,102 22 10 10, tab 4

  text "Topic limited to ops (t)", 76, 10 32 70 8, tab 4
  text "No External messages (n)", 77, 10 40 70 8, tab 4
  text "Invite only (i)", 78, 10 48 70 8, tab 4
  text "Moderate (m)", 79, 10 56 70 8, tab 4
  text "Private (p)", 80, 10 64 70 8, tab 4
  text "Secret (s)", 81, 10 72 70 8, tab 4
  text "Key (k)", 82, 10 80 70 8, tab 4
  text "Limit nb of users (l)", 83, 10 88 70 8, tab 4
  text "Clear color code (c)", 84, 10 96 70 8, tab 4

  radio "", 90, 80 32 10 8, group, tab 4
  radio "", 91, 90 32 10 8, tab 4
  radio "", 92, 100 32 10 8, tab 4
  radio "", 100, 80 40 10 8, group, tab 4
  radio "", 101, 90 40 10 8, tab 4
  radio "", 102, 100 40 10 8, tab 4
  radio "", 110, 80 48 10 8, group, tab 4
  radio "", 111, 90 48 10 8, tab 4
  radio "", 112, 100 48 10 8, tab 4
  radio "", 120, 80 56 10 8, group, tab 4
  radio "", 121, 90 56 10 8, tab 4
  radio "", 122, 100 56 10 8, tab 4
  radio "", 130, 80 64 10 8, group, tab 4
  radio "", 131, 90 64 10 8, tab 4
  radio "", 132, 100 64 10 8, tab 4
  radio "", 140, 80 72 10 8, group, tab 4
  radio "", 141, 90 72 10 8, tab 4
  radio "", 142, 100 72 10 8, tab 4
  radio "", 150, 80 80 10 8, group, tab 4
  radio "", 151, 90 80 10 8, tab 4
  radio "", 152, 100 80 10 8, tab 4
  radio "", 160, 80 88 10 8, group, tab 4
  radio "", 161, 90 88 10 8, tab 4
  radio "", 162, 100 88 10 8, tab 4
  radio "", 170, 80 96 10 8, group, tab 4
  radio "", 171, 90 96 10 8, tab 4
  radio "", 172, 100 96 10 8, tab 4

  text "", 180, 10 23 180 10, tab 5
  list 181, 10 33 150 54, size, extsel, hsbar, tab 5
  button "Refresh", 182, 162 33 30 10, tab 5
  button "Add", 183, 162 44 30 10, tab 5
  button "Del", 184, 162 55 30 10, tab 5
  button "Clean", 185, 162 66 30 10, tab 5
  button "Wipe", 186, 162 77 30 10, tab 5
  button "Save", 187, 162 88 30 10, tab 5

  box  "", 188, 10 88 182 30, tab 5
  edit "", 189, 15 95 172 10, tab 5
  button "Cancel", 190, 15 106 81 10, tab 5
  button "Valid", 191, 106 106 81 10, tab 5

  text "", 192, 10 23 180 10, tab 6
  list 193, 10 33 180 80, size, extsel, hsbar, tab 6
}
;*************************************************
;   Main Nickserv dialog                         *
;*************************************************
dialog NS {
  title %NS.title
  size -1 -1 195 125
  option dbu

  tab "Status", 1, 5 5 185 115
  tab "Usefull cmd", 2
  tab "Nick Settings", 3
  tab "Acces list", 4

  button "close", 200, 1 1 35 10, cancel, hide

  list 202, 10 22 175 85, extsel, hsbar, tab 1
  button "start logging", 203, 10 105 32 10, tab 1
  button "stop logging", 204, 45 105 32 10, tab 1
  button "clear log file", 205, 80 105 32 10, tab 1
  button "clear status", 206, 115 105 32 10, tab 1
  button "copy", 207, 150 105 32 10, tab 1

  button "Identify", 10, 10 23 35 10, tab 2
  button "Register", 11, 10 35 35 10, tab 2
  button "Drop", 12, 10 47 35 10, tab 2
  button "Kill a ghost", 13, 55 23 35 10, tab 2
  button "Release", 14, 55 35 35 10, tab 2
  button "Recover", 15, 55 47 35 10, tab 2
  button "Nick Info", 16, 100 23 35 10, tab 2

  box "", 20, 10 83 175 33, tab 2
  edit "", 21, 15 90 165 10, size, tab 2
  button "Cancel", 22, 15 102 80 10, tab 2
  button "Valid", 23, 100 102 80 10, tab 2

  text "Enforce", 30, 55 23 35 10, tab 3
  radio "On", 31, 95 23 20 10, group, tab 3
  radio "Off", 32, 120 23 20 10, tab 3
  text "NoMemo", 40, 55 33 35 10, tab 3
  radio "On", 41, 95 33 20 10, group, tab 3
  radio "Off", 42, 120 33 20 10, tab 3
  text "NoOp", 50, 55 43 35 10, tab 3
  radio "On", 51, 95 43 20 10, group, tab 3
  radio "Off", 52, 120 43 25 10, tab 3
  text "Secure", 60, 55 53 35 10, tab 3
  radio "On", 61, 95 53 20 10, group, tab 3
  radio "Off", 62, 120 53 20 10, tab 3
  text "ShowEmail", 70, 55 63 35 10, tab 3
  radio "On", 71, 95 63 20 10, group, tab 3
  radio "Off", 72, 120 63 20 10, tab 3

  button "Access list", 80, 10 23 35 10, tab 3
  button "Password", 81, 10 34 35 10, tab 3
  button "URL", 82, 10 45 35 10, tab 3
  button "Email", 83, 10 56 35 10, tab 3

  box "", 84, 10 83 175 33, tab 3  
  edit "", 85, 15 90 165 10, size, tab 3
  button "cancel", 86, 15 102 55 10, tab 3
  button "remove", 87, 70 102 55 10, tab 3
  button "ok", 88, 125 102 55 10, tab 3

  list 90, 10 23 135 55, vsbar, extsel, size, hsbar, tab 4
  button "Refresh", 91, 150 23 35 10, tab 4
  button "Add a mask", 92, 150 34 35 10, tab 4
  button "Del a mask", 93, 150 45 35 10, tab 4
  button "Wipe the list", 94, 150 56 35 10, tab 4
  button "Save", 95, 150 67 35 10, tab 4

  box "", 96, 10 83 175 33, tab 4
  edit "", 97, 15 90 165 10, size, tab 4
  button "Cancel", 98, 15 102 80 10, tab 4
  button "Valid", 99, 100 102 80 10, tab 4
}
;*************************************************
;   Main Satserv dialog                          *
;*************************************************
dialog SS  {
  title "Statserv"
  size -1 -1 200 120
  option dbu

  tab "status", 1, 5 5 190 95
  tab "cmds", 2
  tab "servs list", 4
  tab "net stats", 5
  tab "misc", 6

  button "close", 200, 1 1 35 10, cancel, hide

  list 202, 10 22 180 73, extsel, size, hsbar, tab 1
  button "start logging", 203, 10 105 35 10, tab 1
  button "stop logging", 204, 46 105 35 10, tab 1
  button "clear log file", 205, 82 105 35 10, tab 1
  button "clear status", 206, 118 105 35 10, tab 1
  button "copy", 207, 154 105 35 10, tab 1

  button "Server Stats", 10, 10 25 35 10, tab 2
  button "Domain Stats", 11, 10 37 35 10, tab 2
  button "Host Stats", 12, 10 49 35 10, tab 2

  button "Login", 13, 50 25 35 10, tab 2

  box "", 14, 10 65 180 33, tab 2
  edit "", 15, 15 73 170 10, size, tab 2
  button "Cancel", 16, 15 85 85 10, tab 2   
  button "Valid", 17, 100 85 85 10, tab 2

  list 30, 10 22 180 73, size, hsbar, tab 4
  button "Refresh", 31, 10 105 30 10, tab 4
  text "double click on a line to get the server stats", 32, 45 105 145 10, tab4
  list 40, 10 22 180 73, size, hsbar, tab 5
  button "Refresh", 41, 10 105 30 10, tab 5
  list 50, 10 22 180 73, size, hsbar, tab 6
  button "Refresh", 51, 10 105 30 10, tab 6
}
;*************************************************
;*  General raws/events                          *
;*************************************************
On 1:LOAD:{
  if ($version < 5.71) {
    echo -a 4Notice: Sorry, but you can't use this script with your mIRC version. 
    echo -a Download mIRC Version 5.71 or higher from http://www.mirc.org
    echo -a The script has been unloaded.
    .unload -rs $scriptname
  }
  else {
    if ($script(dalserv.mrc) == $null) { .load -rs $scriptdirdalserv.mrc }
    else { echo -s dalserv script is succesfully loaded | if (DALnet === $network) { watch +nickserv +chanserv +statserv } }
  }
}
on 1:start:{ .rlevel CS NS SS }
on 1:connect:{ if (DALnet === $network) { .watch +ChanServ +NickServ +StatServ } }
alias -l WLeft { echo -s 4,15 $+ $time $1 has left IRC } 
alias -l WJoin { echo -s 3,15 $+ $time $1 has joined IRC } 
alias -l WOffline { echo -s 4,15 $+ $time $1 is offline } 
alias -l WOnline { echo -s 3,15 $+ $time $1 is online } 
alias -l WStop { echo -s 4,15 $+ $time Stop watching $1 }
alias -l ServLvl { return $upper( $left($1,1) ) $+ S }
alias -l ServMsk { return $1 $+ ! $+ $2 $+ @ $+ $3 }
raw 600:*????Serv*:{ if ((($3 == service) || ($3 == stats)) && ($4 == dal.net)) { .auser -a $ServLvl($2) $ServMsk($2,$3,$4) | WJoin $2 | haltdef } }
raw 601:*????Serv*:{ if ((($3 == service) || ($3 == stats)) && ($4 == dal.net)) { .rlevel -r $ServLvl($2) $ServMsk($2,$3,$4) | Wleft $2 | haltdef } }
raw 602:*????Serv*:{ if ($network === DALnet) { .rlevel -r $ServLvl($2) $ServMsk($2,$3,$4) | WStop $2 | haltdef } }
raw 604:*????Serv*:{ if ((($3 == service) || ($3 == stats)) && ($4 == dal.net)) { .auser -a $ServLvl($2) $ServMsk($2,$3,$4) | WOnline $2 | haltdef } }
raw 605:*????Serv*:{ if ($network === DALnet) { .rlevel -r $ServLvl($2) $ServMsk($2,$3,$4) | WOffline $2 | haltdef } }
raw 603:*:{ set %W.stat 1 | echo -a 6,15Watch stats : you have $4 entries in your watch list and you are on $8 watchlist | echo -a 6,15Current watch list : | haltdef }
raw 606:*:{ echo -a 6,15 $+ $2- | haltdef }
raw 607:*:{ if (%W.stat) { echo -a 6,15End of list | unset %W.stat } | haltdef }
raw 440:*:{ .timer 1 1 Wrn $2- | halt }
;*************************************************
;*  common code dialog alias/events              *
;*************************************************
on 1:dialog:?S:sclick:203:{ .timer -m 1 10 ChooseLogFile $dname }
on 1:dialog:?S:sclick:204:{ unset % $+ [ [ $dname ] $+ .logging ] | dd $+ [ $dname ] -b 204 | dd $+ [ $dname ] -e 203 | write [ % $+ [ [ $dname ] $+ .logfile ] ] ***** Session stopped $fulldate }
on 1:dialog:?S:sclick:205:{ if ([ % $+ [ [ $dname ] $+ .logfile ] ]) { write -c [ % $+ [ [ $dname ] $+ .logfile ] ] } }
on 1:dialog:?S:sclick:206:{ dd $+ [ $dname ] -r 202 }
on 1:dialog:?S:sclick:207:{ 
  var %nbline = $did($dname,202,0).sel, %i = 1, %k = 0
  if (%nbline) {
    while (%i <= %nbline) {
      set %txt1 $did($dname,202,$did($dname,202,%i).sel).text
      if ($left(%txt1,1) == -) { if (%j == $null) { set %j 0 } | inc %j | set %txt1 $right(%txt1,$calc($len(%txt1)-1)) } 
      else { unset %j }
      if ((%j) && (%j > 1)) { set %txt %txt %txt1 }
      else { set %txt %txt $+ $chr(13) $+ $chr(10) $+ %txt1 }
      inc %k | inc %i
    }
    clipboard %txt | unset %txt %j %txt1
  }
}
