;*************************************************
;* Project.name: DALnet services                 *
;* Version.....: 4.0                             *
;* Part 1......: event, alias and dialogs code   *
;* Author......: blaster^                        *
;* E-mail......: blaster@irc-scripts.com         *
;* Homepage....:                                 *
;* Initial dialog design done using              *
;* projectx editor - http://www.projectx.mx.dk   *
;*************************************************
alias ChooseLogFile { 
  var %file [ % $+ [ [ $1 ] $+ .logfile ] ]
  set % $+ [ [ $1 ] $+ .logfile ] $dir="Enter the filename" $iif( %file,  %file, *.log ) 
  if ([ % $+ [ [ $1 ] $+ .logfile ] ]) { set % $+ [ [ $1 ] $+ .logging ] 1 | dd $+ [ $1 ] -e 204,205 | dd $+ [ $1 ] -b 203 
    if ($1 == CS) { write [ % $+ [ [ $1 ] $+ .logfile ] ] ***** ChanServ session on $Cname started $asctime( $calc( $gmt - $daylight ) ) GMT } 
    elseif ($1 == NS) { write [ % $+ [ [ $1 ] $+ .logfile ] ] ***** NickServ session on $Nname started $asctime( $calc( $gmt - $daylight ) ) GMT } 
    elseif ($1 == SS) { write [ % $+ [ [ $1 ] $+ .logfile ] ] ***** StatServ session started $asctime( $calc( $gmt - $daylight ) ) GMT } 
  }
}
alias -l Stlog { 
  if ($dialog($1)) { 
    if ([ % $+ [ [ $1 ] $+ .logging ] ]) { write [ % $+ [ [ $1 ] $+ .logfile ] ] $2- }
    dd $+ [ $1 ] -a 202 $strip($2-)
    dd $+ [ $1 ] -c 202 $did($1,202).lines | dd $+ [ $1 ] -u 202 $did($1,202).lines
    dd $+ [ $1 ] -z 202
  }
}
;*************************************************
;*  Error dialog alias/events                    *
;*************************************************
alias Wrn { if ($dialog(Wrn)) { set %Wrnmsg $addtok(%Wrnmsg,$strip($1-),160) } | else { Wrn1 $strip($1-) } }
alias -l Wrn1 { if ($dialog(Wrn)) { dialog -v Wrn } | else { dialog -m Wrn Wrn }
  var %l = $len($1-), %i = 1, %j = 2
  did -r Wrn 2,3,4
  while ( %l > 75 ) {
    if (j == 3) { halt } 
    var %txt1 = $mid($1-,%i,75), %i1 = $numtok(%txt1,32) 
    set %txt1 $deltok(%txt1,%i1,32) | %i1 = $len(%txt1) + 1
    did -a Wrn %j %txt1 | inc %i %i1 | inc %j | dec %l %i1
  }
  if (%i != 1) { did -a Wrn %j $mid($1-,%i,%l) }
  else { did -a Wrn %j $mid($1-,%i,%l) }
}
on 1:dialog:Wrn:sclick:1:{
  if ($numtok(%Wrnmsg,160)) { .timer -m 1 10 Wrn1 $gettok(%Wrnmsg,1,160) | set %Wrnmsg $deltok(%Wrnmsg,1,160) }
}
;*************************************************
;*  ChanServ dialog alias/events                 *
;*************************************************
#CS off
raw 367:*:{ if (($dialog(CS) == $null) || ($Nfunc(ban) == 0)) { goto end } | ddCS -i 193 3 $3 ( $4 ) $duration( $calc( $ctime - $5 ) ) ago | :end | haltdef }
raw 368:*:{ if (($dialog(CS) == $null) || ($Nfunc(ban) == 0)) { goto end } | ddCS -ze 193 | :end | haltdef }
on ^CS:notice:Info for*:?:{ Stlog CS $strip($1-) | unset %CS.opt* | haltdef }
on ^CS:notice:Memo Level*:?:{ StLog CS $strip($1-) | DecodeMemoLevel $4 | haltdef }
on ^CS:notice:Mode Lock*:?:{ StLog CS $strip($1-) | set %cs.mlock $strip( $iif( $3 == for, $9, $4 ) ) | haltdef }
on ^CS:notice:Options *:?:{ StLog CS $strip($1-) | DecodeOptions $3- | DecodeTopicLock $3- | haltdef }
on ^CS:notice:*End of Info*:?:{ StLog CS $strip($1-) | ddCS -e 22 | haltdef }
on ^CS:notice:$(The channel  $+ $Cname $+  is not registered.):?:{ StLog CS $strip($1-) | haltdef }
on ^CS:notice:$(The channel  $+ $Cname $+  has been registered to you.*):?:{  StLog CS $strip($1-) | ddCS -e 22 | haltdef }
on ^CS:notice:$(Channel management of  $+ $Cname $+  has been stopped.):?:{ StLog $strip($1-) | unset %cs.opt* %cs.mlock | haltdef }
on ^CS:notice:$(Founder for  $+ $Cname $+  changed to*):?:{ StLog CS $strip($1-) | .notice @ $+ $Cname $1- | haltdef }
on ^CS:notice:$(* option for  $+ $Cname $+  is now set to *):?:{ StLog CS $strip($1-) | if ($1 === MEMO) { DecodeMemoLevel $remove($10,.) } | else { DecodeOptions2 $1 $9 } | haltdef }
on ^CS:notice:$(The password you supplied for  $+ $Cname $+  is incorrect.):?:{ StLog CS $strip($1-) | Wrn $strip($1-) | haltdef }
on ^CS:notice:$(Password accepted for  $+ $Cname $+ *):?:{ StLog CS $strip($1-) | haltdef }
on ^CS:notice:$(Password for  $+ $Cname $+  has been set to*):?:{ StLog CS $strip($1-) | haltdef }
on ^CS:notice:$(You must identify as the founder to change  $+ $Cname $+ 's settings.):?:{ StLog CS $strip($1-) | Wrn $strip($1-) | haltdef }
on ^CS:notice:$(AOp list for  $+ $Cname $+ ):?:{ ddCS -r 181 | StLog CS $strip($1-) | haltdef }
on ^CS:notice:$(SOp list for  $+ $Cname $+ ):?:{ ddCS -r 181 | StLog CS $strip($1-) | haltdef }
on ^CS:notice:$(AKick list for  $+ $Cname $+ ):?:{ ddCS -r 170 | StLog CS $strip($1-) | haltdef }
on ^CS:notice:*already exists on*:?:{ StLog CS $strip($1-) | Wrn $strip($1-) | haltdef } 
on ^CS:notice:End of list.:?:{ ddCS -ev 181,182,183,184,185,186,187 | ddCs -z 181 | StLog CS $1- | haltdef }
on ^CS:notice:You do not*:?:{ wrn $1- | stlog cs $1- | haltdef }
on ^CS:notice:$(*ACC $Cname *):?:{ DspChanAccInfo $1- | haltdef }
on ^CS:notice:To confirm, type*:?:StLog CS $1- | CS $5- | haltdef
on ^CS:notice:*:?:{ var %txt = $1 | if ($remove( %txt, . ) isnum ) { ddCS -a 181 $1- } | StLog CS $strip($1-) | halt }
on ^CS:notice:*:#:{ StLog CS $1- | haltdef }
on ^CS:notice:WARNING*:#:{ StLog CS $1- | Wrn $1- | haltdef }
#CS end
on 1:dialog:CS:init:0:{ .enable #CS #csdlg | CS info $Cname | ddCS -b 22 | set %cs.session $asctime( $calc( $gmt - $daylight ) ) GMT
  if ((%CS.logging) && (%CS.logfile)) { write %cs.logfile ***** Chanserv session on $Cname started %cs.session } 
  if (%CS.logfile) { ddCS -ev 205 } | else { ddCS -vb 205 }
  if (%CS.logging) { ddCS -ev 204 | ddCS -vb 203 }
  else { ddCS -ev 203 | ddCS -vb 204 }
  set %cs.tab 1
}
#CsDlg off
alias -l CS { chanserv $1- | StLog CS $1- }
alias ddCS { did $1 CS $2- }
alias CName { return $gettok( %CS.title, 2, 58 ) }
alias -l Nfunc { if ($1 == %cs.func) { return 1 } | return 0 }
alias -l CsDrop { if ($$?!="You are sure you want drop $Cname ") { CS DROP $Cname } }
alias -l DecodeMemoLevel {
  if (AOP isin $1) { set %CS.optMemo 2 }
  elseif (SOP isin $1) { set %CS.optMemo 1 }
  elseif (none isin $1) { set %CS.optMemo 3 }
  else { set %CS.optMemo 0 }
}
alias -l DecodeTopicLock {
  if (Sticky isin $1-) { set %CS.optKEEPTOPIC on }
  elseif ((Topic Lock(S) isin $1-) || (Sop isin $1-)) { set %CS.optTpLock 1 }
  elseif ((Topic Lock(F) isin $1-) || (Founder isin $1-)) { set %CS.optTpLock 0 }
  elseif (Founder == $1) { set %CS.optTpLock 0 }
  elseif (SOP == $1) { set %CS.optTpLock 1 }
  else { set %CS.optTpLock 2 }
}
alias -l DecodeOptions {
  if (Private isin $1-) { set %CS.optPrivate on }
  if (SecuredOps isin $1-) { set %CS.optOpGuard on }
  if (LeaveOps isin $1-) { set %CS.optLeaveOps on }
  if (Unsecure isin $1-) { set %CS.optUnsecure on }
  if (Restricted isin $1-) { set %cs.optRestrict on }
  if (Ident isin $1-) { set %CS.optIdent on }
  if (Verbose isin $1-) { set %CS.optVerbose on }
}
alias -l DecodeOptions2 { if (Topic isin $1) { DecodeTopiclock $2 } | elseif (ON isin $2) { set %CS.opt [ $+ [ $1 ] ] on } | else { unset %CS.opt [ $+ [ $1 ] ] } }
alias -l DspChanAccInfo {
  if ($4 == 0) { StLog CS $1 is a normal user in $3 }
  elseif ($4 == 1) { StLog CS $1 is an AutoOP in $3 }
  elseif ($4 == 2) { StLog CS $1 is a SuperOp in $3 }
  elseif ($4 >= 3) { StLog CS $1 has Founder access in $3 }
  elseif ($4 == -1) { StLog CS $1 is Akicked in $3 }
}
alias -l FounderIdent { CS IDENTIFY $Cname $$?="Enter the founder password " }
alias -l Cregister { CS REGISTER $Cname $$?="enter your founder password ( don't forget it !!! )" $$?="enter the channel description" }
alias -l ShowSettings {
  CsEditOff
  var %i = 45 | while (%i <= 59) { ddCS -u %i | inc %i } 
  if (%CS.optKEEPTOPIC != $null) { ddCS -c 45,48 | ddCS -ub 46,47 }
  elseif (%CS.optTpLock != $null) { ddCS -c $calc( 46 + %CS.optTpLock ) }
  ddCS -c $calc( 56 + %CS.optMemo )
  if (%CS.optOpGuard) { ddCS -c 49 } | if (%CS.optLeaveOps) { ddCS -c 50 } | if (%CS.optRestrict) { ddCS -c 51 } | if (%CS.optUnsecure) { ddCS -c 52 } | if (%CS.optIdent) { ddCS -c 53 } | if (%CS.optPrivate) { ddCS -c 54 } | if (%CS.optVerbose) { ddCS -c 55 }
}
alias -l ShowMlock {  
  ddCS -u 90,91,92,100,101,102,110,111,112,120,121,122,130,131,132,140,141,142,150,151,152,160,161,162,170,171,172
  if (%CS.mlock == $null) { set %CS.mlock +tn-impsklR }
  ddCS -c 90,100,110,120,130,140,150,160,170 | .timer -m 1 10 ddCS -ra 70 mode selected %CS.mlock | .timer -m 1 10 ddCS -ra 74 + 
  var %add.rem = $left(%CS.mlock, 1), %iii = 2, %ml = tnimpsklc-
  while (%iii <= $len(%CS.mlock)) {
    var %j = $findtok( %ml, $mid(%CS.mlock, %iii, 1), 1, 160 )
    if (%j) {
      if (%j < 9) {
        var %j0 = $calc( ( %j * 10 ) + 80 ), %j1 = %j0 + 1, %j2 = %j1 + 1
        if (%add.rem == +) { ddCS -c %j1 | ddCS -u %j0 $+ , $+ %j2 } | else { ddCS -c %j2 | ddCS -u %j0 $+ , $+ %j1 } 
      }
      else { set %add.rem - }
    }
    inc %iii 
  }
}
alias -l SetMlock {
  var %cmlock1 = +, %cmlock2 = -, %i = 91, %j = 1, %k = 1, %ml = tnimpsklc
  :loop 
  if ($did(CS,%i).state) { %cmlock [ $+ [ %k ] ] = %cmlock [ $+ [ %k ] ] $+ $gettok( %ml, %j, 160 ) }
  inc %i 10 | inc %j 1 | if (%i < 180) { goto loop } | if (%k == 1) { %i = 92 | %j = 1 | inc %k | goto loop }
  %cmlock2 = %cmlock2 $+ R
  ddCS -ra 70 mode selected $iif( $len(%cmlock1) == 1, %cmlock2, [ %cmlock1 $+ [ %cmlock2 ] ] ) 
}
alias -l CsEditOn { ddCS -r 61 | ddCS -ev 60,61,62,63 | ddCS -ra 60 $1- }
alias -l CsEditOff { ddCS -bh 60,61,62,63 } 
alias -l CsEdit3On { ddCS -bh 187 | ddCS -ev 188,189,190,191 | ddCS -ra 188 $1- | ddCS -fr 189 }
alias -l CsEdit3Off { if ($did(CS,188).visible) { if ($did(CS,182).enabled) { ddCS -ev 187 } | else { ddCS -vb 187 } } | ddCS -bh 188,189,190,191 } 
alias -l InitChNList {   
  set %cs.func $1 | CsTab6
  if ($1 == ban) { ddCS -a 193 ME | ddCS -a 193 ALL | mode $Cname +b | return }
  elseif ($1 == op) { set %fun nopnick }
  elseif (($1 == deop) || ($1 == why)) { set %fun opnick }
  else { set %fun nick }
  var %i = [ $ $+ [ [ %fun ] $+ ( $+ [ $CName $+ [ $chr(44) $+ 0) ] ] ] ]
  while ((%i != $null) && (%i != 0)) { ddCS -a 193 [ $ $+ [ [ %fun ] $+ ( $+ [ $CName $+ [ $chr(44) $+ %i ) ] ] ] ] | dec %i }
  :end
  unset %fun | ddCS -ze 193
}
alias -l ChNlistCmd {
  if ($Nfunc(deop)) { CS deop $CName $1-  }
  elseif ($NFunc(op)) { CS op $CName $1- }
  elseif ($NFunc(ban)) { if ($me isop $Cname) { StLog CS mode $CName - $+ $str(b,$numtok($1-,32)) $1- | mode $CName - $+ $str(b,$numtok($1-,32)) $1- } }
}
alias -l CsTab1 { set %cs.tab 1 }
alias -l CsTab2 { set %cs.tab 2 }
alias -l CsTab3 { ddCS -c 3 | .timer -m 1 10 ShowSettings | set %cs.tab 3 }
alias -l CsTab4 { ShowMlock | set %cs.tab 4 }
alias -l CsTab5 { ddCs -c 5 | ddCS -ra 180 You're managing $Cname $+ 's %cs.func list | ddCS -r 181 | ddCS -b 182,183,184,185,186,187 | CsEdit3Off | set %cs.tab 5 }
alias -l CsTab6 { ddCs -c 6 | ddCS -ra 192 You're managing $Cname $+ 's %cs.func list | ddCS -r 193 | set %cs.tab 6 }
alias -l CsSopList { set %cs.func sop | CsTab5 | CS SOP $Cname LIST }
alias -l CsAopList { set %cs.func aop | CsTab5 | CS AOP $Cname LIST }
alias -l CsAkickList { set %cs.func akick | CsTab5 | CS AKICK $Cname LIST }
alias -l SaveCsListToTxtFile {
  var %svfile = $$dir="Enter the filename" *.txt, %i = $did(CS,181).lines, %j = 1
  write -c %svfile | write %svfile **** $Cname $+ 's %cs.func list on $fulldate
  while (%j <= %i) { write %svfile $did(CS,181,%j).text | inc %j }
}
on 1:dialog:CS:sclick:2:CsTab2
on 1:dialog:CS:sclick:3:CsTab3
on 1:dialog:CS:sclick:4:CsTab4
on 1:dialog:CS:sclick:5:ddCs -c %cs.tab | Wrn You can't access the tab 'cs lists' directly
on 1:dialog:CS:sclick:6:ddCs -c %cs.tab | Wrn You can't access the tab 'mics' directly
on 1:dialog:CS:sclick:20:.timer -m 1 10 Cregister
on 1:dialog:CS:sclick:21:.timer -m 1 10 FounderIdent
on 1:dialog:CS:sclick:22:CsTab3
on 1:dialog:CS:sclick:23:.timer -m 1 10 CsDrop
on 1:dialog:CS:sclick:24:CsSopList
on 1:dialog:CS:sclick:25:CsAopList
on 1:dialog:CS:sclick:26:CsAkickList
on 1:dialog:CS:sclick:27:.timer -m 1 10 mkick
alias -l mkick { if ($$?!="are you sure you want mkick $cname ") { CS MKICK $CName } }
on 1:dialog:CS:sclick:28:InitChNlist op
on 1:dialog:CS:sclick:29:InitChNlist deop
on 1:dialog:CS:sclick:30:if ($opnick($CName,0) == 0) { halt } | .timer -m 1 10 mdeop
alias -l mdeop { if ($$?!="are you sure you want mdeop $cname ") { CS MDEOP $CName } }
on 1:dialog:CS:sclick:31:InitChNlist ban
on 1:dialog:CS:sclick:32:CS INVITE $CName  
on 1:dialog:CS:sclick:33:InitChNlist access
on 1:dialog:CS:sclick:34:InitChNlist why
on 1:dialog:CS:sclick:36:ddCS -b 22 | unset %CS.opt* %CS.mlock | CS info $CName
on 1:dialog:CS:sclick:37:CS count $CName | CsTab1
on 1:dialog:CS:sclick:40:CS set $Cname Founder
on 1:dialog:CS:sclick:41:CsEditOn Enter the founder password
on 1:dialog:CS:sclick:42:CsEditOn Enter the chan description
on 1:dialog:CS:sclick:43:CsEditOn Enter the channel web site address
on 1:dialog:CS:sclick:44:ddCs -c 4 | CsTab4
on 1:dialog:CS:sclick:45:{ 
  if ($did(45).state) { CS set $CName TopicLock OFF | CS set $CName KeepTopic ON | ddCS -bu 46,47,48 | ddCS -c 48 }
  else { CS set $CName KeepTopic OFF | ddCS -e 46,47,48 }
}
on 1:dialog:CS:sclick:46:CS set $CName TopicLock Founder
on 1:dialog:CS:sclick:47:CS set $CName TopicLock SOP
on 1:dialog:CS:sclick:48:CS set $CName TopicLock OFF
on 1:dialog:CS:sclick:49:CS set $CName OpGuard $iif($did(49).state, ON, OFF)
on 1:dialog:CS:sclick:50:CS set $CName LeaveOps $iif($did(50).state, ON, OFF)
on 1:dialog:CS:sclick:51:CS set $CName Restrict $iif($did(51).state, ON, OFF)
on 1:dialog:CS:sclick:52:CS set $CName Unsecure $iif($did(52).state, ON, OFF)
on 1:dialog:CS:sclick:53:CS set $CName Ident $iif($did(53).state, ON, OFF)
on 1:dialog:CS:sclick:54:CS set $CName Private $iif($did(54).state, ON, OFF)
on 1:dialog:CS:sclick:55:CS set $CName Verbose $iif($did(54).state, ON, OFF)
on 1:dialog:CS:sclick:56:CS set $CName Memo Founder
on 1:dialog:CS:sclick:57:CS set $CName Memo Sop
on 1:dialog:CS:sclick:58:CS set $CName Memo Aop
on 1:dialog:CS:sclick:59:CS set $CName Memo None
on 1:dialog:CS:sclick:62:CsEditOff
on 1:dialog:CS:sclick:63:{
  if ($did(CS,61).text) { if (password isin $did(CS,60)) { CS SET $CName PASSWD $did(CS,61) } }
  else { Wrn You must provide a password or hit the Cancel button | halt }
  if (description isin $did(CS,60)) { CS SET $Cname DESC $did(CS,61) }
  if (address isin $did(CS,60)) { CS SET $Cname URL $did(CS,61) }
  CsEditOff
}
on 1:dialog:CS:sclick:182:Cs $+ %cs.func $+ List
on 1:dialog:CS:sclick:183:CsEdit3On Enter the nick/mask to add on $Cname %cs.func list
on 1:dialog:CS:sclick:184:{ 
  var %j = $did(181,0).sel | while (%j > 0) { var %k = $did(181,%j).sel | CS %cs.func $Cname del $gettok($did(181,%k).text,1,32) | dec %j }
  ddCS -r 181 | CS %cs.func $Cname list | ddCS -b 181,182,183,184,185,186,187
}
on 1:dialog:CS:sclick:185:CS %cs.func $Cname clean | CS %cs.func $Cname list | ddCS -b 181,182,183,184,184,185,186
on 1:dialog:CS:sclick:186:CS %cs.func $Cname wipe | CS %cs.func $Cname list | ddCS -b 181,182,183,184,184,185,186
on 1:dialog:CS:sclick:187:.timer -m 1 10 SaveCsListToTxtFile
on 1:dialog:CS:sclick:190:CsEdit3off
on 1:dialog:CS:sclick:191:{ 
  if ($did(CS,189).text) { CS %cs.func $Cname add $did(CS,189).text | CS %cs.func $Cname list | ddCS -r 181 | ddCS -b 182,183,184,185,186 | CsEdit3Off }
  else { Wrn Enter the nick/mask before you use Valid }
}
on 1:dialog:CS:dclick:193:{
  var %i = $did(193,0).sel, %j = 1, %k = 0, %l = 0
  :loop
  while ((%i) && (%j <= %i)) { 
    set %k $did(193,%j).sel
    if (%txt.cmd) { set %txt.cmd %txt.cmd $gettok($did(193,%k).text,1,32) }
    else { set %txt.cmd $gettok($did(193,%k).text,1,32) }
    if ($NFunc(access)) { CS access $CName $did(193,%k).text | goto incj }
    elseif ($NFunc(why)) { CS why $CName $did(193,%k).text | goto incj }
    elseif ($NFunc(ban)) { 
      var %w = $gettok($did(193,%k).text,1,32)
      if (%w == me) { CS unban $CName | goto end }
      elseif (%w == all) { CS unban $CName * | goto end }
      elseif ($me !isop $Cname) { StLog CS you are not opped }
    }
    inc %l | if (%l == 6) { ChNlistcmd %txt.cmd | %l = 0 | unset %txt.cmd }
    :incj
    inc %j
  }
  :end
  if (%l) { ChNlistcmd %txt.cmd }
  unset %ch.nlist %txt.cmd 
  ddCS -c 1
}
on 1:dialog:CS:sclick:200:{ .disable #CS #CsDlg | unset %CS.title %cs.opt* %cs.mlock %cs.func %cs.tab %cs.session }
on 1:dialog:CS:sclick:*:{ 
  if ($did == 71) { CsTab3 }
  elseif ($did == 72) { CS SET $Cname MLOCK $gettok($did(70).text,3,32) | CsTab3 }
  elseif (($did >= 90) && ($did < 173)) { SetMlock }
}
#CsDlg end
;*************************************************
;* Nickserv Dialog code/events                   *
;*************************************************
#Nacc off
on ^NS:notice:$(Access list for  $+ $Nname $+  $+ *):?:haltdef | StLog NS $strip($1-)
on ^NS:notice:*was not found*:?:AccRefresh | StLog NS **** $1- | halt
on ^NS:notice:*has been removed from your access*:?:StLog NS $strip($1-) | ddNS -d 90 $did(Ns,90,1).sel | if ($did(Ns,90,0).sel == 0) { EbleNsAcc } | halt
on ^NS:notice:$(The mask  $+ %acc1.mask $+  has been added*):?:StLog NS $strip($1-) | ddNS -a 90 $strip($3) | EbleNsAcc | halt
on ^NS:notice:$(The mask  $+ %acc1.mask $+  already exists*):?:StLog NS **** $strip($1-) | Wrn $strip($1-) | EbleNsAcc | halt
on ^NS:notice:The nick *:?:StLog NS **** $strip($1-) | Wrn $strip($1-) | halt
on ^NS:notice:Invalid user@host mask*:?:Wrn $strip($1-) | EbleNsAcc | halt
on ^NS:notice:You currently have*:?:StLog Ns $1- | halt
on ^NS:notice:End of list:?:EbleNsAcc | StLog NS $1- | halt
on ^NS:notice:*Usage*:?:StLog NS $strip($1-) | Wrn $strip($1-) | EbleNsAcc | halt
on ^NS:notice:*For help*:?:StLog NS $strip($1-) | EbleNsAcc | halt
on ^NS:notice:*:?:ddNS -a 90 $1- | StLog NS $1- | haltdef
on ^NS:notice:WARNING*:#:{ StLog NS $1- | Wrn $1- | haltdef }
#Nacc end
#Nserv off
on ^NS:notice:*End of info*:?:set %ns.info.ok 1 | haltdef
on ^NS:notice:Options*:?:StLog NS $1- | set %ns.options $remove($2-,$chr(44)) | haltdef | halt
on ^NS:notice:Your * option has been set to *:?:StLog NS $1- | if (ON isin $8) { set %ns.options %ns.options $2 } | else { set %ns.options $remove(%ns.options,$2) } | haltdef | halt
on ^NS:notice:To confirm, type*:?:StLog NS $1- | NS $5- | haltdef
on ^NS:notice:*:?:StLog NS $strip($1-) | haltdef
#Nserv end
on 1:dialog:NS:init:0:{ .enable #Nserv #nsdlg | set %ns.session $asctime( $calc( $gmt - $daylight ) ) GMT | 
  if ((%ns.logging) && (%ns.logfile)) { write %ns.logfile ***** NickServ session on $Nname started %ns.session } 
  if (%NS.logfile) { ddNS -ev 205 } | else { ddNS -vb 205 }
  if (%NS.logging) { ddNS -ev 204 | ddNS -vb 203 }
  else { ddNS -ev 203 | ddNS -vb 204 }
  Ns info $Nname | set %ns.tab 1 
}
#NsDlg off
alias -l NS { nickserv $1- | unset %Ned %Npar1 %Npar2 | StLog NS $1- }
alias ddNS { did $1 NS $2- }
alias Nname { return $gettok(%NS.title,2,58) }
alias -l NDrop { if ($$?!="Do you confirm you want drop the nick $Nname " == $true) { Ns drop $Nname } }
alias -l NsEditOn { ddNS -ev 20,21,22,23 | ddNS -ra 20 $1- | ddNS -rf 21 }
alias -l NsEditOff { ddNS -bh 20,21,22,23 } 
alias -l NsEdit2On { if (password isin $1-) { ddNS -bh 87 } | else { ddNS -ev 87 } | ddNS -ev 84,85,86,88 | ddNS -ra 84 $1- | ddNS -rf 85 }
alias -l NsEdit2Off { ddNS -bh 84,85,86,87,88 } 
alias -l NsEdit3On { ddNS -ev 96,97,98,99 | ddNS -ra 96 $1- | ddNS -rf 97 }
alias -l NsEdit3Off { ddNS -bh 96,97,98,99 | unset %ns.passwd } 
alias -l EbleNsAcc { ddNS -e 91,94,95 | ddNS -z 90 | if ($Nname == $me) { ddNS -e 92,93 } }
alias -l DbleNsAcc { ddNS -b 91,92,93,94,95 }
alias -l AccRefresh { ddNS -r 90 | Ns ACCESS LIST $Nname | DbleNsAcc }
alias -l StartNsTab1 { set %ns.tab 1 | ddNS -c 1 | .disable #Nacc }
alias -l StartNsTab2 { set %ns.tab 2 | ddNS -c 2 | .disable #Nacc | .timer -m 1 10 NsEditOff | if ($Nname != $me) { ddNS -b 11 } }
alias -l StartNsTab3 { set %ns.tab 3 | ddNS -c 3 | .disable #Nacc | .timer -m 1 10 NsEdit2Off | if ($Nname != $me) { ddNS -b 31,32,41,42,51,52,61,62,71,72,81,82 } 
  ddNS -c $iif(Enforced isin %ns.options,31,32) $+ , $+ $iif(NoOp isin %ns.options,51,52)
}
alias -l StartNsTab4 { if ($Nname != $me) { ddNS -b 92,93,94 } | if (%ns.info.ok) { .timer -m 1 10 NsEdit3Off | ddNS -r 90 | DbleNsAcc | .enable #Nacc | Ns ACCESS LIST $Nname | ddNS -c 4 } | else { Wrn Please, wait nickserv send the nick's infos | StartNstab $+ %ns.tab } } 
alias -l SaveNsListToTxtFile {
  var %svfile = $$dir="Enter the filename" *.txt, %i = $did(NS,90).lines, %j = 1
  write -c %svfile | write %svfile **** NCname $+ 's access list on $fulldate
  while (%j <= %i) { write %svfile $did(NS,90,%j).text | inc %j }
}
on 1:dialog:NS:sclick:1:StartNsTab1
on 1:dialog:NS:sclick:2:StartNsTab2 
on 1:dialog:NS:sclick:3:StartNsTab3
on 1:dialog:NS:sclick:4:StartNsTab4
on 1:dialog:NS:sclick:10:NsEditOn identification : enter the nick to ident (blank=current nick)
on 1:dialog:NS:sclick:11:NsEditOn registration : enter the password for $Nname
on 1:dialog:NS:sclick:12:.timer -m 1 10 NDrop
on 1:dialog:NS:sclick:13:NsEditOn ghost : enter the nick (blank=current nick)
on 1:dialog:NS:sclick:14:NsEditOn release : enter the nick (blank=current nick)
on 1:dialog:NS:sclick:15:NsEditOn recover : enter the nick (blank=current nick)
on 1:dialog:NS:sclick:16:NsEditOn Nick Infos : enter the nick (blank=current nick)
on 1:dialog:NS:sclick:22:NsEditOff
on 1:dialog:NS:sclick:23:{ 
  var %func = $gettok($did(NS,20).text,1,32), %value = $did(NS,21).text
  echo 7 -s %func * %value
  if (Nick === %func) { if (%value == $null) { var %value = $Nname } | Ns INFO %value }
  elseif (identification === %func) { if (%value == $null) { var %value = $Nname } | NsEditOn Identify : enter the password for %value | halt }
  elseif (registration === %func) { if (%value) { set %ns.passwd %value | NsEditOn Email : enter the email for nick $Nname } | else { Wrn You must enter a password } | halt }
  elseif (ghost === %func) { if (%value == $null) { var %value = $Nname } | NsEditOn Ghost : enter the password for %value | halt }
  elseif (recover === %func) { if (%value == $null) { var %value = $Nname } | NsEditOn Recover : enter the password for %value | halt }
  elseif (release === %func) { if (%value == $null) { var %value = $Nname } | NsEditOn Release : enter the password for %value | halt }
  elseif (Email === %func) { if (%value) { NS REGISTER %ns.passwd %value } | else { Wrn You must enter a valid email | halt } }
  elseif ($gettok($did(NS,20).text,5,32) == password) { if (%value) { Ns %func $gettok($did(NS,20).text,7,32) %value } | else { Wrn You MUST provide the password | halt } }
  NsEditOff
}
on 1:dialog:NS:sclick:31,32:Ns SET ENFORCE $iif($did == 31, ON, OFF)
on 1:dialog:NS:sclick:41,42:Ns SET NOMEMO $iif($did == 41, ON, OFF)
on 1:dialog:NS:sclick:51,52:Ns SET NOOP $iif($did == 51, ON, OFF)
on 1:dialog:NS:sclick:61,62:Ns SET SECURE $iif($did == 61, ON, OFF)
on 1:dialog:NS:sclick:71,72:Ns SET SHOWEMAIL $iif($did == 71, ON, OFF)
on 1:dialog:NS:sclick:80:StartNsTab4
on 1:dialog:NS:sclick:81:NsEdit2On Password : enter the new password for nick $Nname
on 1:dialog:NS:sclick:82:NsEdit2On URL : enter the web site for nick $Nname
on 1:dialog:NS:sclick:83:NsEdit2On Email : enter your email for nick $Nname
on 1:dialog:NS:sclick:86:NsEdit2Off
on 1:dialog:NS:sclick:87:Ns SET $gettok($did(NS,84).text,1,32) | NsEdit2Off
on 1:dialog:NS:sclick:88:{ 
  var %func = $gettok($did(NS,84).text,1,32), %value = $did(NS,85).text
  if (url == %func) { if (%value == $null) { Wrn You MUST enter the URL before using ok | halt } | else { Ns SET URL %value } }
  elseif (Password == %func) { if (%value == $null) { Wrn You MUST enter the new password before using ok | halt } | else { Ns SET PASSWD %value } }
  elseif (Email == %func) { if (%value == $null) { Wrn You MUST enter the email using ok | halt } | else { Ns SET EMAIL %value } }
  NsEdit2Off
}
on 1:dialog:NS:sclick:91:AccRefresh
on 1:dialog:NS:sclick:92:NsEdit3On Enter the mask to add
on 1:dialog:NS:sclick:93:if ($did(Ns,90).sel) { var %i = 1 | while (%i <= $did(Ns,90,0).sel) { Ns ACCESS DEL $did(Ns,90,$did(Ns,90,%i).sel).text | inc %i } | DbleNsAcc }
on 1:dialog:NS:sclick:94:Ns ACCESS WIPE
on 1:dialog:NS:sclick:95:.timer -m 1 10 SaveNsListToTxtFile
on 1:dialog:NS:sclick:98:NsEdit3Off
on 1:dialog:NS:sclick:99:set %acc1.mask $did(NS,97).text | if (%acc1.mask == $null) { Wrn You MUST enter the mask using Valid | halt } | Ns ACCESS ADD %acc1.mask | NsEdit3Off | DbleNsAcc
on 1:dialog:NS:sclick:200:.disable #Nserv #Nacc #NsDlg | unset %NS.title %ns.info.ok %ns.tab %acc1.mask %ns.session %ns.options
#NsDlg end
;*************************************************
;*  StatServ dialog alias/events                 *
;*************************************************
#SSList off
on ^SS:notice:[*]*:?:haltdef | StLog SS $1- | ddSS -a 30 $1- | .timerSsList 1 2 EofSSList
#SSlist end
#SSstats off
on ^SS:notice:Server/Oper Kills*:?:haltdef | StLog SS $1- | ddSS -a 40 $1- | .disable #SSstats | ddSS -e 41 | ddSS -z 40
on ^SS:notice:*:?:haltdef | StLog SS $1- | ddSS -a 40 $1- 
#SSstats end
#SSstat2 off
on ^SS:notice:*not found?:?:haltdef | ddSS -a 50 $strip($1-) | StLog SS $strip($1-) | Wrn $strip($1-) | .disable #SSstat2 | ddSS -e 51 | ddSS -z 50
on ^SS:notice:End of*:?:haltdef | StLog SS $1- | ddSS -za 50 $1- | ddSS -e 51 | .disable #SSstat2
on ^SS:notice:*statistics for *:?:haltdef | StLog SS $strip($1-) | ddSS -a 50 $strip($1-)
on ^SS:notice:*:?:haltdef | StLog SS $1- | ddSS -a 50 $1-
#SSstat2 end
#SS off
on ^SS:notice:UserName*incorrect*:?:haltdef | StLog SS $1- | Wrn $1-
#SS end
on 1:dialog:ss:init:0:{ .enable #SS #SsDlg | set %ss.tab 1 | set %ss.session $asctime( $calc( $gmt - $daylight ) ) GMT
  if ((%SS.logging) && (%SS.logfile)) { write %ss.logfile ***** Statserv session started %ss.session } 
  if (%SS.logfile) { ddSS -ev 205 } | else { ddSS -vb 205 }
  if (%SS.logging) { ddSS -ev 204 | ddSS -vb 203 }
  else { ddSS -ev 203 | ddSS -vb 204 }
}
#SsDlg off
alias -l SS { statserv $1- | StLog SS $1- }
alias ddSS { did $1 SS $2- }
alias -l EofSSList { .disable #SSList | ddSS -e 30,31 | ddSS -z 30 }
alias -l SSTab4 { if ((%ss.tab == 5) && ($group(#Sstat) == on)) { Wrn wait Statserv finished to send the net stats } | else { set %ss.tab 4 | ddSS -rb 30 | ddSS -b 31  | .enable #SSList | SS SERVERS }  | ddSS -c %ss.tab }
alias -l SSTab5 { if ((%ss.tab == 4) && ($group(#SSList) == on)) { Wrn wait Statserv finished to send the servers list } | else { set %ss.tab 5 | ddSS -r 40 | ddSS -b 41 | .enable #SSstats | SS NetStats }  | ddSS -c %ss.tab }
alias -l SSTab6 { if (%ss.tab != 6) { Wrn You can't access this tab directly } | else { .enable #SSstat2 | ddSS -r 50 }  | ddSS -c %ss.tab }
alias -l SSEditOn { ddSS -ev 14,15,16,17 | ddSS -a 14 $1- | ddSS -rf 15 }
alias -l SSEditOff { ddSS -bh 14,15,16,17 }
on 1:dialog:ss:sclick:1:set %ss.tab 1
on 1:dialog:ss:sclick:2:set %ss.tab 2 | .timer -m 1 10 SSEditOff
on 1:dialog:ss:sclick:10:SSEditOn Enter the server name (ex: liberty)
on 1:dialog:ss:sclick:11:SSEditOn Enter the domain name (ex: aol.com)
on 1:dialog:ss:sclick:12:SSEditOn Enter the host name (ex:tty10.chicken.com)
on 1:dialog:ss:sclick:13:SSEditOn Enter your username
on 1:dialog:ss:sclick:16:SSeditOff
on 1:dialog:ss:sclick:17:{  
  if ($did(SS,15).text) { 
    if (username isin $did(SS,14,text)) { SSEditOn Enter the password for $did(SS,15).text | halt }
    elseif (password isin $did(SS,14,text)) { SS login $gettok($did(ss,14).text,5,32) $did(SS,15).text | SSEditOff | halt }
    else { set %ss.tab 6 | SSTab6 | SS $gettok($did(SS,14).text,3,32) $did(SS,15).text | SSEditOff } | else { Wrn You must enter a value before using <valid> } 
  } 
}
on 1:dialog:ss:dclick:30:{ 
  var %txt = $did(ss,$did,$did(SS,$did,1).sel).text
  set %ss.tab 6 | SSTab6 | if ($left(%txt,1) == [) { set %txt $gettok(%txt,2,32) } | else { set %txt $remove(%txt,|,-,`) } | ddSS -ra 15 %txt | SS server %txt
}
on 1:dialog:ss:sclick:4,31:SSTab4
on 1:dialog:ss:sclick:5,41:SSTab5
on 1:dialog:ss:sclick:6:SSTab6
on 1:dialog:ss:sclick:51:.enable #SSstat2 | SS $gettok($did(SS,50,1).text,1,32) $did(SS,15).text | ddSS -r 50 | ddSS -b 51
on 1:dialog:ss:sclick:200:.timerSs* off | .disable #Ss* | unset %ss.tab %ss.session
#SsDlg end
