;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Zmodem's Channel Statistics: v1.00
;
;By: Zmodem
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;ALIASES
alias -l stats {
  if ($server == $null) { echo -a  $+ $colour(info) $+ *** Not connected to a server! | return }
  if ($dialog(stats) != $null) { dialog -x stats }
  zstats_check_type
  if (%^_zstats.type == 1) { dialog -md stats stats | goto resume }  
  dialog -m stats stats
  :resume
  did -f stats 2
  set %^_zstats.tmp.Here 0
  set %^_zstats.tmp.Away 0
  set %^_zstats.tmp.IrcOps 0
  .enable #Zstats
  who #
}
alias -l zstats_check_type if (%^_zstats.type == $null) || (%^_zstats.type !isnum) || (%^_zstats.type < 0) || (%^_zstats.type > 1) { set %^_zstats.type 0 }

;DIALOG
dialog stats {
  option dbu
  size -1 -1 120 109
  title "Zmodem's Channel Statistics"
  button "&OK", 1, 95 100 21 8, ok
  box "Building Database...This may take a while", 2, 3 3 113 92
  text "Total Users:", 3, 15 13 29 10
  text "", 4, 55 13 30 10
  box "", 5, 15 22 90 4
  text "Operators:", 6, 15 29 24 10
  text "", 7, 55 29 30 10
  text "Voiced:", 8, 15 40 20 10
  text "", 9, 55 40 30 10
  text "Regulars:", 10, 15 51 22 10
  text "", 11, 55 51 30 10
  text "Here:", 12, 15 62 22 10
  text "", 13, 55 62 30 10
  text "Away:", 14, 15 73 22 10
  text "", 15, 55 73 30 10
  text "IrcOps:", 16, 15 84 22 10
  text "", 17, 55 84 30 10
  check "Open On &Desktop Next Time", 18, 3 98 80 10
}

;GROUP
#Zstats off
raw 315:*: {
  if ($dialog(stats) == $null) { haltdef | return }
  if (%^_zstats.tmp.Here == $null) { set %^_zstats.tmp.Here 0 }
  if (%^_zstats.tmp.Away == $null) { set %^_zstats.tmp.Away 0 }
  if (%^_zstats.tmp.IrcOps == $null) { set %^_zstats.tmp.IrcOps 0 }

  did -ra stats 2 Channel Statistics: $2

  did -ra stats 4 $nick($2,0)


  ;Ops
  var %tmp.ops = $calc($nick($2,0,o) / $nick($2,0))
  if (%tmp.ops == 1) { %tmp.ops = 100 }
  if (%tmp.ops == 00) { %tmp.ops = 0 }
  if (%tmp.ops != 100) && (%tmp.ops != 0) {
    %tmp.ops = $gettok($round(%tmp.ops,2),2,46)
    if ($len(%tmp.ops) < 2) { %tmp.ops = %tmp.ops $+ 0 }
    if ($left(%tmp.ops,1) == 0) { %tmp.ops = $right(%tmp.ops,$calc($len(%tmp.ops) - 1)) }
  }
  ;Voice
  var %tmp.voice = $calc($nick($2,0,v) / $nick($2,0))
  if (%tmp.voice == 1) { %tmp.voice = 100 }
  if (%tmp.voice == 00) { %tmp.voice = 0 }
  if (%tmp.voice != 100) && (%tmp.voice != 0) {
    %tmp.voice = $gettok($round(%tmp.voice,2),2,46)
    if ($len(%tmp.voice) < 2) { %tmp.voice = %tmp.voice $+ 0 }
    if ($left(%tmp.voice,1) == 0) { %tmp.voice = $right(%tmp.voice,$calc($len(%tmp.voice) - 1)) }
  }
  ;Regular
  var %tmp.regular = $calc($nick($2,0,r) / $nick($2,0))
  if (%tmp.regular == 1) { %tmp.regular = 100 }
  if (%tmp.regular == 00) { %tmp.regular = 0 }
  if (%tmp.regular != 100) && (%tmp.regular != 0) {
    %tmp.regular = $gettok($round(%tmp.regular,2),2,46)
    if ($len(%tmp.regular) < 2) { %tmp.regular = %tmp.regular $+ 0 }
    if ($left(%tmp.regular,1) == 0) { %tmp.regular = $right(%tmp.regular,$calc($len(%tmp.regular) - 1)) }
  }

  ;Away
  var %tmp.Away = $calc(%^_zstats.tmp.Away / $nick($2,0))
  if (%tmp.Away == 1) { %tmp.Away = 100 }
  if (%tmp.Away == 00) { %tmp.Away = 0 }
  if (%tmp.Away != 100) && (%tmp.Away != 0) {
    %tmp.Away = $gettok($round(%tmp.Away,2),2,46)
    if ($len(%tmp.Away) < 2) { %tmp.Away = %tmp.Away $+ 0 }
    if ($left(%tmp.Away,1) == 0) { %tmp.Away = $right(%tmp.Away,$calc($len(%tmp.Away) - 1)) }
  }

  ;Here
  var %tmp.Here = $calc(%^_zstats.tmp.Here / $nick($2,0))
  if (%tmp.Here == 1) { %tmp.Here = 100 }
  if (%tmp.Here == 00) { %tmp.Here = 0 }
  if (%tmp.Here != 100) && (%tmp.Here != 0) {
    %tmp.Here = $gettok($round(%tmp.Here,2),2,46)
    if ($len(%tmp.Here) < 2) { %tmp.Here = %tmp.Here $+ 0 }
    if ($left(%tmp.Here,1) == 0) { %tmp.Here = $right(%tmp.Here,$calc($len(%tmp.Here) - 1)) }
  }

  ;IrcOps
  var %tmp.IrcOps = $calc(%^_zstats.tmp.IrcOps / $nick($2,0))
  if (%tmp.IrcOps == 1) { %tmp.IrcOps = 100 }
  if (%tmp.IrcOps == 00) { %tmp.IrcOps = 0 }
  if (%tmp.IrcOps != 100) && (%tmp.IrcOps != 0) {
    %tmp.IrcOps = $gettok($round(%tmp.IrcOps,2),2,46)
    if ($len(%tmp.IrcOps) < 2) { %tmp.IrcOps = %tmp.IrcOps $+ 0 }
    if ($left(%tmp.IrcOps,1) == 0) { %tmp.IrcOps = $right(%tmp.IrcOps,$calc($len(%tmp.IrcOps) - 1)) }
  }

  did -ra stats 7 $nick($2,0,o) : %tmp.ops $+ %
  did -ra stats 9 $nick($2,0,v) : %tmp.voice $+ %
  did -ra stats 11 $nick($2,0,r) : %tmp.regular $+ %
  did -ra stats 13 %^_zstats.tmp.Here : %tmp.Here $+ %
  did -ra stats 15 %^_zstats.tmp.Away : %tmp.Away $+ %
  did -ra stats 17 %^_zstats.tmp.IrcOps : %tmp.IrcOps $+ %
  unset %^_zstats.tmp.*
  .disable #Zstats
  haltdef
}
raw 352:*: {
  if (H isin $7) { set %^_zstats.tmp.Here $calc(%^_zstats.tmp.Here + 1) }
  if (G isin $7) { set %^_zstats.tmp.Away $calc(%^_zstats.tmp.Away + 1) } 
  if ($chr(42) isin $7) { set %^_zstats.tmp.IrcOps $calc(%^_zstats.tmp.IrcOps + 1) }
  haltdef
} 
#Zstats end


;MENUS
menu Channel {
  Zmodem's Channel Stats
  .# Stats:stats
  .-
  .Read Me File: {
    if ($exists($scriptdirzstatreadme.txt) == $false) { echo -a  $+ $colour(info) $+ *** Error locating Readme file! Re-download this file if you have misplaced or lost this file | return }
    run $scriptdirzstatreadme.txt
  }
  .Removal
  ..Unload: {
    var %tmp.u.sure $?!="Are you positive that you want to Unload: Zmodem's Channel Statistics v1.00?"
    if (%tmp.u.sure == $true) { echo -a  $+ $colour(info) $+ *** Removed: Zmodem's Channel Statistics v1.00 Successfully! Find versions of this and other Zmodem scripts at: http://www.irc-scripts.com | unset %^_zstat* | .unload -rs $script }
  }
  ..Un-Install: {
    var %tmp.u.sure $?!="Are you positive that you want to UNINSTALL: Zmodem's Channel Statistics v1.00? This means removing all variables AND files from mIRC AND wherever they are stored on your hard-drive!"
    if (%tmp.u.sure == $true) {
      if ($exists($scriptdirzstatreadme.txt) == $true) { .remove $scriptdirzstatreadme.txt }
      echo -a  $+ $colour(info) $+ *** Successfully UNINSTALLED: Zmodem's Channel Statistics! Find versions of this and other Zmodem scripts at: http://www.irc-scripts.com
      .timerREMOVEZSTATS off
      .timerREMOVEZSTATS 1 0 .remove $script
      unset %^_zstat*
      .unload -rs $script
    }
  }
}

;EVENTS
on *:LOAD: {
  echo -a  $+ $colour(info) $+ *** Zmodem's Channel Statistics Loaded!
  echo -a  $+ $colour(info) $+ *** Click your Channel menubar to access it's popups.
  echo -a  $+ $colour(info) $+ *** All bug reports, feedback and suggestions welcome; or if you just wanna say "Hi" :-). Contact Zmodem at: justinterri@netzero.net Thanks!
  set %^_zstats.type 0
}


;;;Dialog Events

on *:DIALOG:stats:init:0: {
  zstats_check_type
  if (%^_zstats.type == 1) { did -c stats 18 }
}
on *:DIALOG:stats:sclick:1: {
  set %^_zstats.type $did($dname,18).state
}
