alias zeneth.notice.open {
  var %zeneth.dlg = zeneth-Notice- [ $+ [ $1 ] ]
  if ($dialog(%zeneth.dlg).x == $null) { dialog -m %zeneth.dlg zeneth-Notice }
  else { zeneth.notice.add $1 %zeneth.dlg }
}
dialog zeneth-Notice {
  title "Important Notices"
  size 8 162 776 138
  list 1,2.5 25 767.5 120
  button "-&Clear-",2,367.5 2.5 267.5 20
  combo 3,2.5 2.5 130 150,drop
  combo 4,640 2.5 130 150,drop
  text "No. Notices:",5,162.5 5 200 17.5
  button "HIDDEN",6,1 1 1 1,cancel,hide
}
on *:dialog:zeneth-Notice-*:init:0:{ 
  dialog -t $dname $zeneth.titlebar( [ $str($chr(160),6) ] Important Notices: [ $zeneth.notic($dname) ] [ $str($chr(160),6) ] )
  zeneth.exp.filemenu $dname 3
  zeneth.exp.helpmenu $dname 4
  zeneth.notice.loadinfo $zeneth.notic($dname)
  zeneth.notice.ref $zeneth.notic($dname) $dname
}
on *:dialog:zeneth-Notice-*:sclick:3:zeneth.checkfile
on *:dialog:zeneth-Notice-*:sclick:4:zeneth.exp.checkhelp
on *:dialog:zeneth-Notice-*:sclick:2:zeneth.exp.cmd zeneth.notice.clear $zeneth.notic($dname)
alias zeneth.notic { return $right($1,-14) }
alias zeneth.notice.loadinfo { var %zeneth.f = %zeneth.dir $+ $zeneth.rep1($1) $+ .not | if ($exists(%zeneth.f)) { loadbuf -po $dname 1 %zeneth.f } }
alias zeneth.notice.add { did -i $2 1 1 $read -nl1 [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .not ] | zeneth.notice.ref $1 $2 }
alias zeneth.notice.clear { if ($?!="Are you sure u wish to clear the list of FileServer notices?") { write -c %zeneth.dir $+ $zeneth.rep1($1) $+ .not | did -r zeneth-Notice- [ $+ [ $1 ] ] 1 |  zeneth.notice.ref $1 zeneth-Notice- [ $+ [ $1 ] ] } }
alias zeneth.notice.ref { did -a $2 5 No. Notices: [ $lines( [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .not ] ) ] }
alias zeneth.about { dialog -m zeneth-About zeneth-About }
dialog zeneth-About {
  title "About ZeNeTh FileServer Explorer"
  size -1 -1 244 276
  box "Author",1,10 177.5 222.5 95
  text "Author: Fant0m",2,20 192.5 122.5 17.5
  text "Version",3,15 130 210 17.5
  text "FileServer's Accessed:",11,15 150 152.5 17.5
  text "Mercury Scripts:",4,22.5 227.5 147.5 17.5
  button "&http://come.to/mercuryscripts",5,22.5 245 200 17.5
  text "E-Mail: bowler@iaccess.com.au",6,20 207.5 157.5 15
  button "&Mail",7,182.5 205 42.5 17.5
  box "Script Info",8,10 115 222.5 60
  icon 9, 10 7.5 220 100,%zeneth.bmp
  button "HIDDEN",10,1 1 1 1,cancel,hide
}
on *:dialog:zeneth-About:init:0:{
  dialog -t $dname $zeneth.version
  did -a $dname 3 Version: $zeneth.version
  did -a $dname 11 FileServer's Accessed: $zeneth.accessed
}
on *:dialog:zeneth-About:sclick:5:{ run http://come.to/mercuryscripts }
on *:dialog:zeneth-About:sclick:7:{ run mailto:bowler@iaccess.com.au }
alias zeneth.accessed { return $zeneth.read($zeneth.d , Access) }
alias zeneth.mask.open {
  if ($dialog(zeneth-Mask- [ $+ [ $1 ] ] ).x == $null) { dialog -m zeneth-Mask- [ $+ [ $1 ] ] zeneth-Mask }
  dialog -v zeneth-Mask- [ $+ [ $1 ] ]
}
dialog zeneth-Mask {
  title "Mask"
  size 18 73 536 140
  box "Filename",1,2.5 22.5 142.5 115
  radio "Filename",2,2.5 2.5 82.5 20,group
  radio "Size",3,150 2.5 52.5 20
  radio "None",4,282.5 2.5 60 20
  button "-&Apply-",5,352.5 2.5 92.5 20
  box "Size",6,150 22.5 382.5 115
  box "If Match:",7,40 42.5 70 60
  radio "Show",8,47.5 57.5 50 20,group
  radio "Hide",9,47.5 77.5 50 20
  edit "",10,7.5 112.5 132.5 20,center
  combo 11,157.5 40 175 150,drop
  box "Range 1",12,157.5 67.5 182.5 65
  radio "",13,160 85 15 20,group
  radio "Credit",14,160 110 75 20
  edit "",15,177.5 85 77.5 22.5,center
  combo 16,255 85 80 150,drop
  box "Range 2",17,342.5 67.5 185 65
  radio "",18,345 85 15 20,group
  radio "Credit",19,345 110 67.5 20
  edit "",20,362.5 85 77.5 22.5,center
  combo 21,440 85 80 150,drop
  button "-&Cancel-",22,447.5 2.5 85 20,cancel
}
on *:dialog:zeneth-Mask-*:init:0:{
  dialog -t $dname $zeneth.stitlebar(Mask [ ( $+ [ $zeneth.curdir($zeneth.rep1($zeneth.mas)) ] $+ ): ] [ $zeneth.mas ] )
  zeneth.mask.loadtype
  zeneth.mask.loadsettings $zeneth.mas
  did -tf $dname 5
}
on *:dialog:zeneth-Mask-*:sclick:2:zeneth.mask.init file
on *:dialog:zeneth-Mask-*:sclick:3:zeneth.mask.init size
on *:dialog:zeneth-Mask-*:sclick:4:zeneth.mask.change disable all $dname
on *:dialog:zeneth-Mask-*:sclick:13:zeneth.exp.cmd zeneth.mask.change enable creditr2 $dname check | zeneth.writeini $zeneth.mas MaskRange1 $zeneth.mask.value($did(15))
on *:dialog:zeneth-Mask-*:sclick:14:zeneth.exp.cmd zeneth.mask.change disable creditr2 $dname | zeneth.writeini $zeneth.mas MaskRange1 Credit
on *:dialog:zeneth-Mask-*:sclick:18:zeneth.exp.cmd zeneth.mask.change enable creditr1 $dname | zeneth.writeini $zeneth.mas MaskRange2 $zeneth.mask.value($did(20))
on *:dialog:zeneth-Mask-*:sclick:19:zeneth.exp.cmd zeneth.mask.change disable creditr1 $dname | zeneth.writeini $zeneth.mas MaskRange2 Credit
on *:dialog:zeneth-Mask-*:sclick:11:zeneth.mask.checksize $zeneth.mas
on *:dialog:zeneth-Mask-*:sclick:8:zeneth.writeini $zeneth.mas MaskSetting Show
on *:dialog:zeneth-Mask-*:sclick:9:zeneth.writeini $zeneth.mas MaskSetting Hide
on *:dialog:zeneth-Mask-*:sclick:16:zeneth.writeini $zeneth.mas MaskR1C $did($did)
on *:dialog:zeneth-Mask-*:sclick:21:zeneth.writeini $zeneth.mas Maskr2C $did($did)
on *:dialog:zeneth-Mask-*:sclick:5:zeneth.mask.apply $zeneth.mas
on *:dialog:zeneth-Mask-*:edit:10:if ($did($did) != $null) { zeneth.writeini $zeneth.mas MaskFilter $did($did) }
on *:dialog:zeneth-Mask-*:edit:15:did -c $dname 13 | did -u $dname 14 | zeneth.exp.cmd zeneth.mask.change enable creditr2 $dname check
on *:dialog:zeneth-Mask-*:edit:20:did -c $dname 18 | did -u $dname 19 | zeneth.exp.cmd zeneth.mask.change enable creditr1 $dname
alias zeneth.mas { return $right($dname,-12) }
alias zeneth.mask.loadtype {
  did -a $dname 16,21 Bytes
  did -a $dname 16,21 KiloBytes
  did -a $dname 16,21 MegaBytes
  did -a $dname 11 Equal To Range 1
  did -a $dname 11 Greater Than Range 1
  did -a $dname 11 Less Than Range 1
  did -a $dname 11 Between Range 1 and Range 2
  did -c $dname 16,21 1
}
alias zeneth.mask.loadsettings {
  var %zeneth.mask = $zeneth.r.mask($1)
  if (%zeneth.mask == *.*) { did -c $dname 4 | zeneth.mask.change disable all $dname }
  else {
    var %zeneth.mask = $zeneth.r.masktype($1)
    if (%zeneth.mask == filename) { zeneth.exp.cmd zeneth.mask.change disable size $dname | zeneth.mask.loadfile $1 }
    if (%zeneth.mask == size) { zeneth.exp.cmd zeneth.mask.change disable filename $dname | zeneth.mask.loadsize $1 }
  }
}
alias zeneth.mask.init {
  if ($1 == file) {
    .timer.zeneth.mask.1. [ $+ [ $zeneth.mas ] ] 1 0 zeneth.mask.change disable size $dname
    .timer.zeneth.mask.2. [ $+ [ $zeneth.mas ] ] 1 0 zeneth.mask.change enable filename $dname
    zeneth.mask.loadfile $zeneth.mas
  }
  else {
    .timer.zeneth.mask.1. [ $+ [ $zeneth.mas ] ] 1 0 zeneth.mask.change enable size $dname
    .timer.zeneth.mask.2. [ $+ [ $zeneth.mas ] ] 1 0 zeneth.mask.change disable filename $dname
    zeneth.mask.loadsize $zeneth.mas
  }
}
alias zeneth.mask.loadfile {
  did -c $dname 2
  if ($zeneth.r.masksetting($1) == Hide) { did -c $dname 9 | did -u $dname 8 }
  else { did -c $dname 8 | did -u $dname 9 }
  var %zeneth.mask.filter = $zeneth.r.maskfilter($1)
  if (%zeneth.mask.filter == $null) { var %zeneth.mask.filter = *.* }
  did -o $dname 10 1 %zeneth.mask.filter
}
alias zeneth.mask.loadsize {
  did -c $dname 3
  var %zeneth.mask.setting = $zeneth.r.masksetting($1)
  if (%zeneth.mask.setting == Range) { did -c $dname 11 4 }
  elseif (%zeneth.mask.setting == Greater) { did -c $dname 11 2 }
  elseif (%zeneth.mask.setting == Less) { did -c $dname 11 3 }
  else { did -c $dname 11 1) }
  var %zeneth.mask.r1 = $zeneth.r.maskrange1($1)
  if (%zeneth.mask.r1 == Credit) { zeneth.exp.cmd zeneth.mask.change disable creditr2 $dname | did -c $dname 14 }
  else { did -o $dname 15 1 %zeneth.mask.r1 | did -c $dname 13 }
  zeneth.exp.cmd zeneth.mask.ctype [ $zeneth.r.maskr1c($1) ] 16 $dname
  zeneth.mask.loadr2 $1 %zeneth.mask.setting
}
alias zeneth.mask.change {
  if ($1 == disable) { var %zeneth.mask.action = -b }
  else { var %zeneth.mask.action = -e }
  if ($2 == all) { did %zeneth.mask.action $3 1,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21 }
  if ($2 == size) { did %zeneth.mask.action $3 6,11,12,13,14,15,16,17,18,19,20,21 }
  if ($2 == filename) { did %zeneth.mask.action $3 1,7,8,9,10 }
  if ($2 == creditr2) { 
    if (($4 == check) && ($did($3,20).enabled == $false) && ($1 != disable)) { halt }
    did %zeneth.mask.action $3 19 
  }
  if ($2 == creditr1) { did %zeneth.mask.action $3 14 }
  if ($2 == r2) { did %zeneth.mask.action $3 17,18,19,20,21 }
}
alias zeneth.mask.ctype {
  if ($1 == MegaBytes) { did -c $3 $2 3 }
  elseif ($1 == KiloBytes) { did -c $3 $2 2 }
  else { did -c $3 $2 1 }
}
alias zeneth.mask.range {
  if ($1 == r1) {
    did -o $dname 15 1 $zeneth.r.maskrange1($2)
    if ( [ $zeneth.r.maskr1c($2) ] == $null) { did -c $dname 16 1 }
    else { zeneth.mask.ctype $zeneth.r.maskr1c($2) 16 $dname }
  }
  if ($1 == r2) {
    did -o $dname 20 1 $zeneth.r.maskrange2($2)
    if ($zeneth.r.maskr2c($2) == $null) { did -c $dname 21 1 }
    else { zeneth.mask.ctype $zeneth.r.maskr2c($2) 21 $dname }
  }
}
alias zeneth.mask.value {
  if ($1 !isnum) { if ($zeneth.read($2 , $3) != $null) { return $zeneth.read($2 , $3) } | else { return 0 } }
  else { return $1 }
}
alias zeneth.mask.checksize {
  var %zeneth.mask.setting = $zeneth.mask.checksiz($1)
  zeneth.writeini $1 MaskSetting %zeneth.mask.setting
  if ($2 == $null) { zeneth.mask.loadr2 $1 %zeneth.mask.setting }
}
alias zeneth.mask.checksiz {
  if (equal isin $did(11)) { return Equal }
  elseif (greater isin $did(11)) { return Greater }
  elseif (less isin $did(11)) { return Less }
  else { return Range }
}
alias zeneth.mask.loadr2 {
  if ($2 == Range) {
    var %zeneth.mask.r2 = $zeneth.r.maskrange2($1)
    else { did -o $dname 20 1 %zeneth.mask.r2 | did -c $dname 18 }
    zeneth.exp.cmd zeneth.mask.ctype [ $zeneth.r.maskr2c($1) ] 21 $dname
    .timer.zeneth.loadr2. [ $+ [ $1 ] ] 1 0 zeneth.mask.change enable r2 $dname
    if ($did(14).state == 1) { .timer.zeneth.loadr21. [ $+ [ $1 ] ] -m 3 2 did -b $dname 19 | did -c $dname 18 | did -u $dname 19 }
    elseif (%zeneth.mask.r2 == Credit) { did -b $dname 14 | did -c $dname 19 }
    else { did -c $dname 18 | did -o $dname 20 1 $zeneth.r.maskrange2($1) }
  }
  else { .timer.zeneth.loadr2. [ $+ [ $1 ] ] -m 3 2 zeneth.mask.change disable r2 $dname | did -e $dname 14 }
}
alias zeneth.mask.apply {
  if ($did(2).state == 1) { 
    if ($did(10) == *.*) { goto end }
    zeneth.writeini $1 MaskType FileName
    if ($did(9).state == 1) { zeneth.writeini $1 MaskSetting Hide }
    else { zeneth.writeini $1 MaskSetting Show }
    zeneth.writeini $1 MaskFilter $did(10)
  }
  if ($did(3).state == 1) {
    var %zeneth.mask.set = $zeneth.mask.checksiz($1)
    zeneth.writeini $1 MaskSetting %zeneth.mask.set
    zeneth.writeini $1 MaskType Size
    if ($did(14).state == 1) { zeneth.writeini $1 MaskRange1 Credit }
    else {
      var %zeneth.mask.r1 = $did(15)
      if (%zeneth.mask.r1 !isnum) { zeneth.exp.cmd zeneth.error $1 I'm sorry but Range1 is not a valid number! | did -rf $dname 15 | halt }
      zeneth.writeini $1 MaskRange1 %zeneth.mask.r1
      zeneth.writeini $1 MaskR1C $did(16)
      if (%zeneth.mask.set == Range) {
        if ($did(19).state == 1) { zeneth.writeini $1 MaskRange2 Credit }
        else {
          var %zeneth.mask.r2 = $did(20)
          if (%zeneth.mask.r2 !isnum) { zeneth.exp.cmd zeneth.error $1 I'm sorry but Range2 is not a valid number! | did -rf $dname 20 | halt }
          zeneth.writeini $1 MaskRange2 %zeneth.mask.r2
          zeneth.writeini $1 MaskR2C $did(21)
        }
      }
    }
  }
  if ($did(4).state == 1) { goto end }
  dialog -x $dname
  zeneth.mask.filter $1
  halt
  :end
  dialog -x $dname
  var %zeneth.mask = $zeneth.r.mask($1)
  zeneth.writeini $1 Mask *.* 
  if (%zeneth.mask != *.*) { zeneth.exp.loadinfo $1 }
  halt
}

alias zeneth.mask.filter {
  var %zeneth.mask.type = $zeneth.r.masktype($1)
  unset %zeneth.view. [ $+ [ $1 ] ]
  zeneth.work o $1 Filtering [ $zeneth.curdir($1) ] $+ .... Please Wait
  var %zeneth.mask.set = $zeneth.r.masksetting($1)
  if (%zeneth.mask.set == hide) { var %zeneth.reverse = on }
  else { var %zeneth.reverse = off }
  write -c [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .msk ]
  var %zeneth.currentdir = [ $zeneth.rep3($zeneth.curdir($1)) ]
  var %zeneth.filter.tot = $zeneth.total($1)
  if (%zeneth.mask.set != Hide) { var %zeneth.lop = 1 }
  else { var %zeneth.lop = 2 }
  if (%zeneth.mask.type == FileName) { var %zeneth.match = $zeneth.mask.filt($zeneth.r.maskfilter($1)) | var %zeneth.creditt = $zeneth.r.credit($1) }
  else { 
    var %zeneth.creditt = [ $zeneth.mask.convert($1 , $zeneth.r.maskrange1($1) , $zeneth.r.maskr1c($1)) ]
    if (%zeneth.mask.set == Range) { var %zeneth.creditt2 = [ $zeneth.mask.convert($1 , $zeneth.r.maskrange2($1) , $zeneth.r.maskr2c($1)) ] }
  }
  write -c %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .mtc
  write -c %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .msk
  :loop
  if (%zeneth.mask.type == Filename) { goto results }
  var %zeneth.ready = [ $read -nl [ $+ [ %zeneth.lop ] ] [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ - $+ [ $zeneth.repdir(%zeneth.currentdir) ] ] ]
  if (%zeneth.mask.set == Range) {
    if (%zeneth.creditt2 < %zeneth.creditt) {
      var %zeneth.c1 = %zeneth.creditt
      var %zeneth.creditt = %zeneth.creditt2
      var %zeneth.creditt2 = %zeneth.c1
    }
    if ((%zeneth.creditt <= [ $zeneth.seperate(%zeneth.ready) ] ) && ( [ $zeneth.seperate(%zeneth.ready) ] <= %zeneth.creditt2)) { write [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .msk ] [ %zeneth.ready ] }
    goto chek
  }
  if (%zeneth.mask.set == Greater) {
    if ($zeneth.seperate(%zeneth.ready) >= %zeneth.creditt) { write [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .msk ] [ %zeneth.ready ] }
    goto chek
  }
  if (%zeneth.mask.set == Equal) {
    if ($zeneth.seperate(%zeneth.ready) isnum $zeneth.mask.rang($1 , %zeneth.creditt)) { write [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .msk ] [ %zeneth.ready ] }
    goto chek
  }
  if (%zeneth.mask.set == Less) {
    if ($zeneth.seperate(%zeneth.ready) <= %zeneth.creditt) { write [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .msk ] [ %zeneth.ready ] }
    goto chek
  }
  var %zeneth.ready = $remove(%zeneth.ready, [ $zeneth.seperate(%zeneth.ready) $+ b ] )
  :chek
  if (%zeneth.lop > %zeneth.filter.tot) { goto results }
  inc %zeneth.lop 1
  goto loop
  :results
  if (%zeneth.mask.type == FileName) {
    var %zeneth.filtfile = [ $zeneth.rep3( [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ - $+ [ $zeneth.repdir(%zeneth.currentdir) ] ] ) ]
    if (%zeneth.reverse == on) { filter -ffx [ %zeneth.filtfile ] [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .msk ] %zeneth.match }
    else { filter -ff [ %zeneth.filtfile ] [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .msk ] %zeneth.match }
    var %zeneth.match = $right(%zeneth.match,-2)
  }
  if (%zeneth.mask.set == Greater) { goto nextthing }
  if (( .. !isin [ $read -l1 [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .msk ] ] ) && (%zeneth.currentdir != \)) { write -il1 [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .msk ] d .. }
  :nextthing
  var %zeneth.size1 = $zeneth.sizetype($zeneth.r.maskr1c($1))
  var %zeneth.size2 = $zeneth.sizetype($zeneth.r.maskr2c($1))
  var %zeneth.msk1 = $zeneth.r.maskrange1($1)
  var %zeneth.msk2 = $zeneth.r.maskrange2($1)
  if (%zeneth.msk1 == Credit) { unset %zeneth.size1 }
  if (%zeneth.msk2 == Credit) { unset %zeneth.size2 }
  if (%zeneth.msk2 == $null) { unset %zeneth.size2 }
  if (%zeneth.mask.set == Equal) { var %zeneth.match = [ %zeneth.msk1 ] $+ [ $chr(160) ] $+ [ %zeneth.size1 ] }
  elseif (%zeneth.mask.set == Greater) { var %zeneth.match = Sizes $+ [ $chr(160) ] $+ > $+ [ $chr(160) ] $+ [ %zeneth.msk1 $+ [ $chr(160) ] $+ [ %zeneth.size1 ] ] }
  elseif (%zeneth.mask.set == Less) { var %zeneth.match = Sizes $+ [ $chr(160) ] $+ < $+ [ $chr(160) ] $+ [ %zeneth.msk1 $+ [ $chr(160) ] $+ [ %zeneth.size1 ] ] }
  elseif (%zeneth.mask.set == Range) { var %zeneth.match = [ %zeneth.msk1 $+ [ $chr(160) ] $+ [ %zeneth.size1 ] ] $+ [ $chr(160) ] $+ <-> $+ [ $chr(160) ] $+ [ %zeneth.msk2 $+ [ $chr(160) ] $+ [ %zeneth.size2 ] ] }
  if (%zeneth.reverse == on) { var %zeneth.match [ *.* $+ [ $chr(160) ] $+ <= No- $+ [ $chr(160) ] $+ [ $zeneth.r.maskfilter($1) ] ] $+ => }
  elseif (%zeneth.mask.type == FileName) { var %zeneth.match = [ $left(%zeneth.match,-1) ] }
  :do
  zeneth.error $1 Finished Filtering: [ $zeneth.spacedir($1 , $zeneth.curdir($1)) ] [ $str($chr(160),10) ] Mask: %zeneth.match
  zeneth.writeini $1 Mask %zeneth.match
  zeneth.exp.loadinfo $1 [ [ [ $zeneth.rep1($1) ] $+ .msk ] ]
  :end
}
alias zeneth.sizetype {
  if (kilobytes == $1) { Return KB }
  if (MegaBytes == $1) { Return MB }
  Return Bytes
}
alias zeneth.mask.convert {
  if ($2 == Credit) { return $zeneth.r.credit($1) }
  if ($3 == Bytes) { return $2 }
  if ($3 == KiloBytes) { return $calc($2 * 1024) }
  if ($3 == MegaBytes) { return $calc(($2 * 1024)*1024) }
}
alias zeneth.mask.size {
  if ($remove($remove($remove($1,b),*),?) isnum) {
    if ($2 == $null) {
      if (b isin $1) { var %zeneth.filter = *.???? $+ $1 }
      else { var %zeneth.filter = *.???? $+ $1 $+ b }
    }
    else { var %zeneth.filter = *.???? $+ $1 $+ b }
    return %zeneth.filter
  }
}
alias zeneth.mask.filt {
  if (. isin $1-) { return ?? $+ $1- $+ * }
  else { return ?? $+ $1- $+ * $+ $chr(32) $+ * }
}
alias zeneth.mask.rang {
  var %zeneth.mask.r = $zeneth.r.maskr1c($1)
  if (%zeneth.mask.r == MegaBytes) { var %zeneth.mask.r1 = 10485.76 }
  if (%zeneth.mask.r == KiloBytes) { var %zeneth.mask.r1 = 10.24 }
  if (%zeneth.mask.r == Bytes) { var %zeneth.mask.r1 = 1 }
  return [ $calc($2 - %zeneth.mask.r1) ] $+ - $+ [ $calc($2 + %zeneth.mask.r1) ]
}
alias zeneth.exp.ref {
  if ($dialog($1).x == $null) { goto end }
  if ($3 == $null) {
    var %zeneth.exp.refret = $zeneth.read($zeneth.exp($1) , $2)
    if ($2 == Credit) { zeneth.credit.ref $zeneth.exp($1) 1 | goto end }
    if ($2 == Ratio) { var %zeneth.exp.refc = 2 }
    if ($2 == MaxGets) { var %zeneth.exp.refc = 5 }
    if ($2 == MaxSends) { var %zeneth.exp.refc = 6 }
    if ($2 == Mask) { var %zeneth.exp.refc = 30 }
    if ($2 == Asend) { var %zeneth.exp.refc = 22 }
    if ($2 == AsendCredit) { var %zeneth.exp.refc = 24 }
    if ($2 == CurrentDir) { var %zeneth.exp.refc = 42 | if (~ isin %zeneth.exp.refret) { var %zeneth.exp.refret = [ $zeneth.spacedir($zeneth.exp($1) , %zeneth.exp.refret) ] } | var %zeneth.exp.refret = $zeneth.path.len(%zeneth.exp.refret) }
  }
  if ($2 == Dir) { 
    var %zeneth.ref.mask = $zeneth.r.mask($zeneth.exp($1))
    if (($3 == Files) && (%zeneth.ref.mask == *.*)) { var %zeneth.exp.refc = 11 |  var %zeneth.exp.refret = $zeneth.files($zeneth.exp($1)) | did -o $1 14 1 Files }
    elseif ($3 == Files) { var %zeneth.exp.refc = 11 | var %zeneth.exp.refret = [ $lines( [ %zeneth.dir $+ [ $zeneth.rep1($zeneth.exp($1)) ] $+ .msk ] ) ] | did -o $1 14 1 Shown }
    if (($3 == Dirs) && (%zeneth.ref.mask == *.*)) { var %zeneth.exp.refc = 12 |  var %zeneth.exp.refret = $zeneth.dir($zeneth.exp($1)) | did -o $1 15 1 Dirs }
    elseif ($3 == Dirs) { var %zeneth.exp.refc = 12 |  var %zeneth.exp.refret = [ $zeneth.total($zeneth.exp($1)) ] | did -o $1 15 1 Total }
    if (%zeneth.exp.refc == $null) { var %zeneth.exp.refc = 0 }
  }
  if ($2 == Failed) { var %zeneth.exp.refc = 47 | var %zeneth.exp.refret = View Failed-Files List ( $+ [ $zeneth.fail.total($zeneth.exp($1)) ] $+ ) }
  if ($2 == Lookup) {
    if ($3 == Path) { var %zeneth.exp.refc = 23 | var %zeneth.exp.refret = $zeneth.shorten($zeneth.asenddir($zeneth.exp($1))) }
    if ($3 == Tagged) { var %zeneth.exp.refc = 13 | var %zeneth.exp.refret = $zeneth.tagged($zeneth.exp($1)) }
    if ($3 == Asendno) { var %zeneth.exp.refc = 26 | var %zeneth.exp.refret = $zeneth.asendno($zeneth.exp($1)) $+ / $+ $zeneth.asendtot($zeneth.exp($1)) }
    if ($3 == Dup) { var %zeneth.exp.refc = 18 | var %zeneth.exp.refret = $zeneth.dupstat($zeneth.exp($1)) }
    if (%zeneth.exp.refc == $null) { var %zeneth.exp.refc = 0 }
  }
  did -o $1 %zeneth.exp.refc 1 %zeneth.exp.refret
  if ($2 == maxsends) { 
    var %zeneth.ref.ms = Off
    if ($did($1,43).sel == 1) { var %zeneth.ref.ms = On }
    did -o $1 43 1 Next [ $zeneth.r.maxsends($zeneth.exp($1)) ] Files (AutoSend) 
    if (%zeneth.ref.ms == On) { did -c $1 43 1 }
  }
  if ($2 == Currentdir) { zeneth.exp.menureset $1 }
  :end
}
alias zeneth.stats.open {
  if ($dialog(zeneth-Stats- [ $+ [ $1 ] ] ).x == $null) { dialog -m zeneth-Stats- [ $+ [ $1 ] ] zeneth-Stats }
  else { zeneth.stats.localinfo $1 zeneth-Stats- [ $+ [ $1 ] ] }
}
dialog ZeNeTh-Stats {
  title "FileServer Statistics"
  size 94 -72 294 536
  text "Total Gets:",1,12.5 55 72.5 17.5
  edit "Total Gets",2,85 52.5 52.5 20,read,center
  button "Size",3,172.5 52.5 112.5 20,read,center
  text "Size:",4,142.5 55 27.5 15
  combo 5,5 5 137.5 150,drop
  combo 6,147.5 5 142.5 150,drop
  edit "TextBox",7,85 77.5 52.5 20,read,center
  text "Size:",8,142.5 80 25 15
  button "Size",9,172.5 77.5 112.5 20,read,center
  text "Total Sends:",10,12.5 80 72.5 17.5
  box "Script Statistics",11,5 30 285 260
  text "FileServer Type:",13,12.5 210 200 17.5
  text "Ratio:",14,12.5 142.5 40 17.5
  edit "Ratio",15,52.5 140 40 20,read,center
  text "Credit:",16,97.5 142.5 42.5 20
  button "Credit",17,140 140 145 20,read,center
  button "Clear Above Stats",18,10 100 275 20
  edit "",19,142.5 167.5 40 20,center
  edit "",20,142.5 190 40 20,center
  edit "MaxSendsA",21,245 167.5 40 20,read,center
  edit "MaxGetsA",22,245 190 40 20,read,center
  text "Actual:",23,202.5 170 35 20
  text "Actual:",24,202.5 192.5 37.5 17.5
  edit "TextBox",25,87.5 237.5 192.5 20,read
  edit "TextBox",26,87.5 262.5 192.5 20,read
  text "Extension:",27,32.5 240 52.5 20
  text "Beginning:",28,32.5 265 52.5 20
  box "Dissallowed:",29,10 225 275 62.5
  text "Max Sends-",30,12.5 170 57.5 20
  text "Max Gets-",31,12.5 192.5 52.5 17.5
  text "Script:",32,95 170 37.5 20
  text "Script:",33,95 192.5 37.5 17.5
  box "FileServer Statistics",34,5 292.5 285 167.5
  button "Store as Script Stats",35,10 307.5 275 20
  box "Sent",36,7.5 330 140 127.5
  box "Recieved",37,147.5 330 140 127.5
  edit "No# Sent",38,75 342.5 67.5 20,center,read
  button "Size",39,57.5 365 85 20,center
  edit "Avg. Size",40,57.5 387.5 85 20,center,read
  edit "Top Speed",41,70 410 72.5 20,center,read
  edit "Avg. Speed",42,70 432.5 72.5 20,center,read
  text "No. Sent",43,12.5 345 52.5 20
  text "Size",44,12.5 367.5 45 20
  text "Avg. Size",45,12.5 390 45 20
  text "Top Speed",46,12.5 412.5 55 20
  text "Avg. Speed",47,12.5 435 57.5 17.5
  edit "No. Recieved",48,220 342.5 62.5 20,center,read
  text "No. Recieved",49,152.5 345 68 20
  button "SizeR",50,200 365 82.5 20,center
  edit "Avg. SizeR",51,200 387.5 82.5 20,center,read
  edit "Top Speed R",52,212.5 410 70 20,center,read
  edit "Avg. SpeedR",53,212.5 432.5 70 22.5,center,read
  text "Size",54,152.5 367.5 45 20
  text "Avg. Size",55,152.5 390 45 20
  text "Top Speed",56,152.5 412.5 60 20
  text "Avg. Speed",57,152.5 435 60 20
  box "Visits",58,5 462.5 160 70
  text "Total Visits",59,10 480 62.5 17.5
  edit "Tot. Visits",60,75 477.5 85 20,center,read
  text "1st Visit",61,10 505 65 17.5
  edit "1st Visit",62,75 505 85 20,center,read
  button "HIDDEN",63,1 1 1 1,cancel,hide
  icon 64, 180 450 100 100,%zeneth.bmp
  button "Rules Message?",12,10 122.5 140 17.5
  button "M.O.T.D?",65,150 122.5 135 17.5
}
on *:dialog:zeneth-Stats-*:init:0:{
  zeneth.exp.filemenu $dname 5
  zeneth.exp.helpmenu $dname 6
  dialog -t $dname FileServer Statistics for: $zeneth.stat
  dialog -s $dname $zeneth.x($zeneth.stat) $zeneth.y($zeneth.stat) 294 294
  zeneth.stats.localinfo $zeneth.stat $dname
}
on *:dialog:zeneth-Stats-*:sclick:3:zeneth.stats.conv $zeneth.stat $did GetSize
on *:dialog:zeneth-Stats-*:sclick:9:zeneth.stats.conv $zeneth.stat $did SendSize
on *:dialog:zeneth-Stats-*:sclick:17:zeneth.stats.conv $zeneth.stat $did Credit | zeneth.credit.ref $zeneth.stat 1
on *:dialog:zeneth-Stats-*:sclick:39:zeneth.stats.conv $zeneth.stat $did FSSize
on *:dialog:zeneth-Stats-*:sclick:50:zeneth.stats.conv $zeneth.stat $did FGSize
on *:dialog:zeneth-Stats-*:sclick:5:zeneth.checkfile
on *:dialog:zeneth-Stats-*:sclick:6:zeneth.exp.checkhelp
on *:dialog:zeneth-Stats-*:sclick:12:zeneth.ruleread $zeneth.stat
on *:dialog:zeneth-Stats-*:sclick:65:zeneth.motdread $zeneth.stat
on *:dialog:zeneth-Stats-*:sclick:18:zeneth.exp.cmd zeneth.stats.clear $zeneth.stat
on *:dialog:zeneth-Stats-*:sclick:35:zeneth.exp.cmd zeneth.stats.load $zeneth.stat
on *:dialog:zeneth-Stats-*:edit:19:{ zeneth.writeini $zeneth.stat MaxSends $zeneth.maxs($int($did($did)) , $zeneth.stat) | zeneth.stats.localinfo $zeneth.stat $dname }
on *:dialog:zeneth-Stats-*:edit:20:{ zeneth.writeini $zeneth.stat MaxGets $zeneth.maxg($int($did($did)) , $zeneth.stat) | zeneth.stats.localinfo $zeneth.stat $dname }
alias zeneth.stat { return $right($dname,-13) }
alias zeneth.stats.localinfo {
  dialog -v $2
  did -o $2 2 1 $zeneth.r.gets($1)
  zeneth.stats.ref $1 3 GetSize
  did -o $2 7 1 $zeneth.r.sends($1)
  zeneth.stats.ref $1 9 SendSize
  did -o $2 12 1 Rules Message? $zeneth.r.ruleread($1)
  did -o $2 65 1 M.O.T.D? $zeneth.r.motd($1)
  did -o $2 13 1 FileServer Type: $zeneth.r.fserv($1)
  did -o $2 15 1 $zeneth.r.ratio($1)
  zeneth.stats.ref $1 17 Credit
  did -o $2 21 1 $zeneth.r.maxsendsa($1)
  did -o $2 22 1 $zeneth.r.maxgetsa($1)
  did -o $2 25 1 $zeneth.r.extension($1)
  did -o $2 26 1 $zeneth.r.disallowed($1)
  var %zeneth.c = $zeneth.r.maxsends($1)
  if (%zeneth.c != $did($dname,19)) { did -o $2 19 1 $zeneth.r.maxsends($1) }
  var %zeneth.c = $zeneth.r.maxgets($1)
  if (%zeneth.c != $did($dname,20)) { did -o $2 20 1 $zeneth.r.maxgets($1) }
  zeneth.exp.ref $zeneth.exp.dialog($1) MaxGets
  zeneth.exp.ref $zeneth.exp.dialog($1) MaxSends
}
alias zeneth.stats.fservinfo {
  did -o $2 38 1 $zeneth.read($1 , FSends)
  zeneth.stats.ref $1 39 FSSize
  did -o $2 40 1 $zeneth.read($1 , FSAvg)
  did -o $2 41 1 $zeneth.read($1 , FSTSpeed)
  did -o $2 42 1 $zeneth.read($1 , FSAvgSpeed)
  did -o $2 48 1 $zeneth.read($1 , FGets)
  zeneth.stats.ref $1 50 FGSize
  did -o $2 51 1 $zeneth.read($1 , FGAvg)
  did -o $2 52 1 $zeneth.read($1 , FGTspeed)
  did -o $2 53 1 $zeneth.read($1 , FGAvgSpeed)
  did -o $2 60 1 $zeneth.read($1 , FTVisits)
  did -o $2 62 1 $zeneth.read($1 , FMiscVisit)
  did -o $2 34 1 FileServer Statistics ( $+ [ $zeneth.r.statstype($1) ] $+ )
  if ($zeneth.r.statstype($1) == FileServer) {
    did -o $2 61 1 Today
    did -b $2 35
  }
  else {
    did -o $2 61 1 1st Visit
    did -e $2 35
  }
  dialog -s $2 $zeneth.x($1) $zeneth.y($1) 294 536
}
alias zeneth.stats.clear {
  if ($?!="Are you sure you want to clear your stats?" != $true) { halt }
  zeneth.writeini $1 Sends 0
  zeneth.writeini $1 Sendsize 0
  zeneth.writeini $1 Gets 0
  zeneth.writeini $1 Getsize 0
  zeneth.stats.localinfo $1 zeneth-Stats- [ $+ [ $1 ] ]
}
alias zeneth.stats.load {
  if ($?!="Are you sure you wish to do this? $+ $crlf (Local Stats are usually more accurate)" != $true) { halt }
  zeneth.writeini $1 Sends $zeneth.read($1 , FSends)
  zeneth.writeini $1 Sendsize $zeneth.read($1 , FSsize)
  zeneth.writeini $1 Gets $zeneth.read($1 , FGets)
  zeneth.writeini $1 Getsize $zeneth.read($1 , FGSize)
  zeneth.stats.localinfo $1 zeneth-Stats- [ $+ [ $1 ] ]
}
alias zeneth.stat.getstat {
  if ($chat($1) == $null) { halt }
  if ( [ $zeneth.r.fserv($1) ] == regular) { halt }
  unset %zeneth.stat. [ $+ [ $1 ] ]
  write -c [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .sta ]
  zeneth.stats.statclear $1
  zeneth.work o $1 Obtaining your Stats from [ [ $1 ] $+ .... ] Please Wait
  if ($2 == $null) {
    zeneth.writeini $1 StatsType You
    zeneth.writeini $1 Status Stats
  }
  else {
    zeneth.writeini $1 StatsType FileServer
    zeneth.writeini $1 Status FStats
  }
  var %zeneth.statype = $zeneth.r.fserv($1)
  if ((%zeneth.statype == hawkee) || (%zeneth.statype == panzer)) {
    zeneth.writeini $1 StatsType You
    .msg = $+ $1 stats
    goto end
  }
  if ((%zeneth.statype == Panzer-v2.3b) || (%zeneth.statype == zeneth)) {
    if ($2 == $null) { .msg = $+ $1 mstat }
    else { .msg = $+ $1 fstat }
    goto end
  }
  elseif (%zeneth.statype == vK FServer) {
    if ($2 == $null) { .msg = $+ $1 ustat }
    else { .msg = $+ $1 fstat }
    goto end
  }
  else {
    zeneth.work c $1
    zeneth.writeini $1 Status Norm
  }
  :end
}
alias zeneth.stats.endstat {
  zeneth.work c $1
  if ( [ $zeneth.r.status($1) ] == top10) { var %zeneth.top = on }
  else { var %zeneth.top = off }
  if ( [ $zeneth.r.status($1) ] == fstats) { var %zeneth.f = on }
  else { var %zeneth.f = off }
  zeneth.writeini $1 Status Norm
  write -dl1 [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .sta ]
  var %zeneth.stlines = $lines( [ %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .sta ] )
  if (%zeneth.top != off) { 
  zeneth.top.open $1 }
  elseif (%zeneth.top == off) { zeneth.stats.open $1 | zeneth.stats.fservinfo $1 Zeneth-Stats- [ $+ [ $1 ] ] }
}
