alias zeneth.config.script.open {
  if ($dialog(zeneth-Config-Script).x == $null) { dialog -m zeneth-Config-Script zeneth-Config-Script }
  dialog -v zeneth-Config-Script
}
dialog zeneth-Config-Script {
  title "ZeNeTh FileServer Explorer - Script Configuration"
  size 28 27 406 260
  box "Behaviour",1,5 5 210 115
  box "Miscellenious",2,220 5 180 40
  box "Display and Records",3,7.5 125 207.5 60
  text "Open FileServer Explorer if Closed?",4,10 20 167.5 17.5
  text "Refresh Root [\] on Connect?",5,10 40 160 17.5
  text "Display Notice Window?",6,10 100 155 17.5
  text "Display Rules",7,10 60 120 17.5
  text "Display M.O.T.D.?",8,10 80 105 17.5
  button "Yes",9,180 17.5 30 17.5
  button "Yes",10,180 37.5 30 17.5
  button "Yes",11,180 57.5 30 17.5
  button "Yes",12,180 77.5 30 17.5
  button "Yes",13,180 97.5 30 17.5
  combo 14,15 160 192.5 150,drop
  text "Default Explorer-Window State:",15,15 140 185 17.5
  button "Off",16,172.5 205 37.5 47.5
  button "Flush Cache Now!",17,17.5 232.5 150 20
  edit "",18,17.5 205 55 22.5,center
  combo 19,80 205 87.5 150,drop
  box "Automatic Cache Flushing",20,7.5 190 207.5 67.5
  text "Show Splash Screen?",21,225 22.5 125 20
  button "Yes",22,357.5 20 35 17.5
  box "ZeNeTh FileServer Explorer Status",23,220 50 180 70
  radio "Active",24,277.5 70 70 17.5
  radio "Disabled",25,277.5 92.5 72.5 17.5
  button "About!",26,220 220 182.5 17.5
  button "Misc. Settings",27,220 240 182.5 17.5
  button "HIDDEN",28,1 1 1 1,cancel,hide
  icon 29,225 130 170 80,%zeneth.bmp
}
on *:dialog:Zeneth-Config-Script:init:0:zeneth.config.loadscriptinfo
on *:dialog:zeneth-Config-Script:init:0:zeneth.config.loadscriptinfo
on *:dialog:zeneth-Config-Script:sclick:9:zeneth.config.toggle1 AExp
on *:dialog:zeneth-Config-Script:sclick:10:zeneth.config.toggle1 DRoot
on *:dialog:zeneth-Config-Script:sclick:11:zeneth.config.toggle1 RuleRead
on *:dialog:zeneth-Config-Script:sclick:12:zeneth.config.toggle1 MOTD
on *:dialog:zeneth-Config-Script:sclick:13:zeneth.config.toggle1 Notice
on *:dialog:zeneth-Config-Script:edit:18:if ($did($did) isnum) { zeneth.writeini $zeneth.d FlushNo $did($did) } | else { zeneth.config.loadflush }
on *:dialog:zeneth-Config-Script:sclick:16:zeneth.config.toggle2 Flush | zeneth.config.loadflush
on *:dialog:zeneth-Config-Script:sclick:17:zeneth.flush.period
on *:dialog:zeneth-Config-Script:sclick:19:zeneth.writeini $zeneth.d FlushPeriod $did($did)
on *:dialog:zeneth-Config-Script:sclick:22:zeneth.config.toggle1 Splash
on *:dialog:zeneth-Config-Script:sclick:24:zeneth.writeini $zeneth.d Active Yes | zeneth.config.loadscriptinfo
on *:dialog:zeneth-Config-Script:sclick:25:zeneth.writeini $zeneth.d Active No | zeneth.config.loadscriptinfo
on *:dialog:zeneth-Config-Script:sclick:26:zeneth.about
on *:dialog:zeneth-Config-Script:sclick:27:zeneth.config.misc.open
on *:dialog:zeneth-Config-Script:sclick:14:zeneth.config.checksize
alias zeneth.config.disp {
  if ($1 == Show) { var %zeneth.cmd = -e }
  elseif ($1 == Hide) { var %zeneth.cmd = -b }
  else { halt }
  did %zeneth.cmd $2 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22
}
alias zeneth.config.loadscriptinfo {
  did -a $dname 9 $zeneth.r.aexp($zeneth.d)
  did -a $dname 10 $zeneth.r.droot($zeneth.d)
  did -a $dname 11 $zeneth.r.ruleread($zeneth.d)
  did -a $dname 12 $zeneth.r.motd($zeneth.d)
  did -a $dname 13 $zeneth.r.notice($zeneth.d)
  did -a $dname 22 $zeneth.r.splash($zeneth.d)
  if ($zeneth.r.active($zeneth.d) == Yes) { did -c $dname 24 | zeneth.config.disp Show $dname }
  else { did -c $dname 25 | zeneth.config.disp Hide $dname }
  zeneth.config.loadsize
  zeneth.config.loadflush
}
alias zeneth.config.loadsize {
  did -r $dname 14
  did -a $dname 14 Full View
  did -a $dname 14 Full View (No Status)
  did -a $dname 14 Compact View
  var %zeneth.v = $zeneth.r.size($zeneth.d)
  if (%zeneth.v == Full) { var %zeneth.s = 1 }
  elseif (%zeneth.v == NoStatus) { var %zeneth.s = 2 }
  else { var %zeneth.s = 3 }
  did -c $dname 14 %zeneth.s
}
alias zeneth.config.loadflush {
  did -r $dname 19
  did -a $dname 19 Hours
  did -a $dname 19 Days
  did -a $dname 19 Weeks
  did -a $dname 19 Months
  var %zeneth.v = $zeneth.r.flushperiod($zeneth.d)
  if (%zeneth.v == Days) { var %zeneth.c = 2 }
  elseif (%zeneth.v == Weeks) { var %zeneth.c = 3 }
  elseif (%zeneth.v == Months) { var %zeneth.c = 4 }
  else { var %zeneth.c = 1 }
  did -c $dname 19 %zeneth.c
  did -o $dname 18 1 $zeneth.r.FlushNo($zeneth.d)
  var %zeneth.v = $zeneth.r.flush($zeneth.d)
  did -a $dname 16 %zeneth.v
  if (%zeneth.v == Off) { zeneth.config.flush disable }
  elseif ($zeneth.r.active($zeneth.d) != No) { zeneth.config.flush enable }
}
alias zeneth.config.flush {
  if ($1 == disable) { var %zeneth.c = -b }
  else { var %zeneth.c = -e }
  did %zeneth.c Zeneth-Config-Script 17,18,19
}
alias zeneth.config.toggle1 { zeneth.config.toggle $1 Yes No }
alias zeneth.config.toggle {
  var %zeneth.c = $did($dname,$did)
  if (%zeneth.c != $2) { zeneth.writeini $zeneth.d $1 $2 | did -a $dname $did $2 }
  else { zeneth.writeini $zeneth.d $1 $3 | did -a $dname $did $3 }
}
alias zeneth.config.toggle2 { zeneth.config.toggle $1 On Off }
alias zeneth.config.checksize {
  var %zeneth.c = $did($did)
  if (Status isin %zeneth.c) { var %zeneth.w = NoStatus }
  elseif (Compact isin %zeneth.c) { var %zeneth.w = Compact }
  else { var %zeneth.w = Full }
  zeneth.writeini $zeneth.d Size %zeneth.w
}
alias zeneth.d { return DEFAULTZENETHDEFAULT }
alias zeneth.config.misc.open {
  if ($dialog(zeneth-Config-Misc).x == $null) { dialog -m zeneth-Config-Misc zeneth-Config-Misc }
  dialog -v zeneth-Config-Misc
  if ($1 != $null) { zeneth.config.add $1 }
}
dialog zeneth-Config-Misc {
  title "ZeNeTh FileServer Explorer - Misc. Configuration"
  size 10 10 402 400
  box "AutoSend Function",1,5 7.5 202.5 295
  radio "On",2,67.5 22.5 65 20,group
  radio "Off",3,67.5 42.5 65 20
  edit "",4,12.5 65 77.5 20,center
  text "Bytes Minimum Credit",5,92.5 67.5 110 20
  edit "",6,10 112.5 192.5 20,read,center
  text "AutoSend List:",7,30 92.5 170 20
  box "Change AutoSend List by:",8,10 160 192.5 137.5
  box "Directory",9,15 175 90 70
  box "Selection",10,107.5 175 90 70
  button "Default",11,20 195 80 20
  button "Non-Default",12,20 217.5 80 20
  button "Default",13,112.5 195 80 20
  button "Non-Default",14,112.5 217.5 80 20
  button "Default Selection/Directory",15,15 272.5 182.5 20
  button "Clear AutoSend List",16,15 250 182.5 20
  button "Refresh List",17,10 135 192.5 20
  box "Allow Duplicate Files?",18,210 7.5 182.5 82.5
  radio "Yes",19,270 25 70 20,group
  radio "No",20,270 45 75 20
  button "Add Files to Duplicate List",21,215 65 170 20
  box "Display Download Status?",22,210 92.5 182.5 57.5
  radio "Yes",23,270 107.5 52.5 20,group
  radio "No",24,270 127.5 52.5 20
  box "Chat Window?",25,210 150 182.5 60
  radio "On",26,270 165 55 20,group
  radio "Off",27,270 185 55 20
  box "Configuration For:",28,210 260 182.5 42.5
  combo 29,237.5 275 117.5 150,drop
  button "HIDDEN",30,1 1 1 1,cancel,hide
  box "Max Defaults",31,210 212.5 182.5 45
  text "Gets",32,220 232.5 25 20
  edit "",33,247 230 40 20
  text "Sends",34,305 232.5 27 20
  edit "",35,342 230 40 20
  icon 40,100 300 200 100,%zeneth.bmp
}
on *:dialog:zeneth-Config-Misc:init:0:{
  did -a $zeneth.confi 29 Default
  did -c $zeneth.confi 29 1 Default
  zeneth.config.loadsettings
}
on *:dialog:zeneth-Config-Misc:sclick:2:zeneth.writeini $zeneth.conf($did(29)) Asend On | zeneth.exp.ref zeneth-Exp- [ $+ [ $zeneth.conf($did(29)) ] ] Asend
on *:dialog:zeneth-Config-Misc:sclick:3:zeneth.writeini $zeneth.conf($did(29)) Asend Off | zeneth.exp.ref zeneth-Exp- [ $+ [ $zeneth.conf($did(29)) ] ] Asend
on *:dialog:zeneth-Config-Misc:edit:4:zeneth.writeini $zeneth.conf($did(29)) AsendCredit $did($did) | zeneth.exp.ref zeneth-Exp- [ $+ [ $zeneth.conf($did(29)) ] ] asendcredit
on *:dialog:zeneth-Config-Misc:sclick:19:zeneth.writeini $zeneth.conf($did(29)) Dup Yes | zeneth.exp.ref zeneth-Exp- [ $+ [ $zeneth.conf($did(29)) ] ] Lookup Dup
on *:dialog:zeneth-Config-Misc:sclick:20:zeneth.writeini $zeneth.conf($did(29)) Dup No | zeneth.exp.ref zeneth-Exp- [ $+ [ $zeneth.conf($did(29)) ] ] Lookup Dup
on *:dialog:zeneth-Config-Misc:sclick:23:zeneth.writeini $zeneth.conf($did(29)) CacheRead Yes
on *:dialog:zeneth-Config-Misc:sclick:24:zeneth.writeini $zeneth.conf($did(29)) CacheRead No
on *:dialog:zeneth-Config-Misc:sclick:26:zeneth.writeini $zeneth.conf($did(29)) FChat Yes
on *:dialog:zeneth-Config-Misc:sclick:27:zeneth.writeini $zeneth.conf($did(29)) FChat No
on *:dialog:zeneth-Config-Misc:sclick:29:zeneth.config.loadsettings
on *:dialog:zeneth-Config-Misc:sclick:11:zeneth.config.wipe $zeneth.conf($did(29)) | zeneth.exp.cmd zeneth.config.mklist change
on *:dialog:zeneth-Config-Misc:sclick:12:zeneth.exp.cmd zeneth.config.mklist newdir $zeneth.conf($did(29))
on *:dialog:zeneth-Config-Misc:sclick:13:zeneth.config.wipe $zeneth.conf($did(29)) | zeneth.exp.cmd zeneth.config.mkulist
on *:dialog:zeneth-Config-Misc:sclick:14:zeneth.exp.cmd zeneth.config.mkulist $zeneth.conf($did(29))
on *:dialog:zeneth-Config-Misc:sclick:17:zeneth.exp.cmd zeneth.config.mklist ref $zeneth.conf($did(29))
on *:dialog:zeneth-Config-Misc:sclick:21:zeneth.exp.cmd zeneth.duplic
on *:dialog:zeneth-Config-Misc:sclick:16:zeneth.writeini $zeneth.conf($did(29)) Asenddir <Nothing> | zeneth.remini $zeneth.conf($did(29)) Total | zeneth.config.loadsettings
on *:dialog:zeneth-Config-Misc:sclick:15:zeneth.remini $zeneth.conf($did(29)) Asenddir | zeneth.remini $zeneth.conf($did(29)) Total | zeneth.config.loadsettings
on *:dialog:zeneth-Config-Misc:edit:33:{ zeneth.writeini $zeneth.conf($did($zeneth.confi,29)) MaxGets $zeneth.maxg($int($did($did)) , $zeneth.conf($did($zeneth.confi,29))) | zeneth.config.loadget }
on *:dialog:zeneth-Config-Misc:edit:35:{ zeneth.writeini $zeneth.conf($did($zeneth.confi,29)) MaxSends $zeneth.maxs($int($did($did)) , $zeneth.conf($did($zeneth.confi,29))) | zeneth.config.loadsend }
alias zeneth.config.wipe { zeneth.remini $1 Asenddir | zeneth.remini $1 Custno }
alias zeneth.conf { if ($1 == Default) { return $zeneth.d } | else { return $1 } }
alias zeneth.config.loadget {
  var %zeneth.name = $zeneth.conf($did($zeneth.confi,29))
  did -o $zeneth.confi 33 1 $zeneth.r.maxgets(%zeneth.name)
}
alias zeneth.config.loadsend {
  var %zeneth.name = $zeneth.conf($did($zeneth.confi,29))
  did -o $zeneth.confi 35 1 $zeneth.r.maxsends(%zeneth.name)
}
alias zeneth.config.loadsettings {
  var %zeneth.name = $did($zeneth.confi,29)
  var %zeneth.asend.def = $zeneth.r.asenddir($zeneth.d)
  if (%zeneth.name == Default) { var %zeneth.name = $zeneth.d | var %zeneth.asend = %zeneth.asend.def }
  else { var %zeneth.asend = $zeneth.r.asenddir(%zeneth.name) }
  if (%zeneth.asend == $null) { %zeneth.asend = $zeneth.r.asenddir($zeneth.d) }
  if (%zeneth.asend == %zeneth.asend.def) { did -o $zeneth.confi 7 1 AutoSend List: Default | did -b $zeneth.confi 15 }
  else { did -o $zeneth.confi 7 1 AutoSend List: Non-Default | did -e $zeneth.confi 15 }
  if (%zeneth.asend == <Nothing>) { did -b $zeneth.confi 17,16 }
  else { did -e $zeneth.confi 17,16 }
  zeneth.exp.ref [ zeneth-Exp- [ $+ [ $zeneth.conf(%zeneth.name) ] ] ] lookup path
  zeneth.exp.ref [ zeneth-Exp- [ $+ [ $zeneth.conf(%zeneth.name) ] ] ] lookup asendno
  did -o $zeneth.confi 6 1 [ $zeneth.shorten(%zeneth.asend) ]
  did -o $zeneth.confi 4 1 $zeneth.r.asendcredit(%zeneth.name)
  var %zeneth.asend.st = $zeneth.r.asend(%zeneth.name)
  if (%zeneth.asend.st == On) { did -c $zeneth.confi 2 | did -u $zeneth.confi 3 }
  else { did -c $zeneth.confi 3 | did -u $zeneth.confi 2 }
  var %zeneth.chat = $zeneth.r.fchat(%zeneth.name)
  if (%zeneth.chat == Yes) { did -c $zeneth.confi 26 | did -u $zeneth.confi 27 }
  else { did -c $zeneth.confi 27 | did -u $zeneth.confi 26 }
  var %zeneth.dl = $zeneth.r.Cacheread(%zeneth.name)
  if (%zeneth.dl == Yes) { did -c $zeneth.confi 23 | did -u $zeneth.confi 24 }
  else { did -c $zeneth.confi 24 | did -u $zeneth.confi 23 }
  var %zeneth.dup = $zeneth.r.Dup(%zeneth.name)
  if (%zeneth.dup == Yes) { did -c $zeneth.confi 19 | did -u $zeneth.confi 20 }
  else { did -c $zeneth.confi 20 | did -u $zeneth.confi 19 }
  zeneth.config.loadget
  zeneth.config.loadsend
  zeneth.config.change %zeneth.name
}
alias zeneth.shorten {
  if ($len($1-) >= 35) { return ... $+ $right($1-,33) }
  else { return $1- }
}
alias zeneth.config.change {
  if ($1 == $zeneth.d) { did -b $zeneth.confi 12,14 }
  else { did -e $zeneth.confi 12,14 }
}
alias zeneth.config.add {
  if ($zeneth.config.check($1) != 0) { goto end }
  did -i zeneth-Config-Misc 29 1 $1
  did -c zeneth-Config-Misc 29 1
  :end
  zeneth.config.loadsettings
}
alias zeneth.config.check {
  var %zeneth.lines = $did($zeneth.confi,29).lines
  var %zeneth.l = 1
  :loop
  if (%zeneth.l > %zeneth.lines) { goto end }
  if ( [ $did($zeneth.confi,29,%zeneth.l) ] == $1) { return $%zeneth.l }
  inc %zeneth.l 1
  goto loop
  :end
  Return 0
}
alias zeneth.confi { return zeneth-Config-Misc }
alias zeneth.config.mklist {
  var %zeneth.senddir = $zeneth.r.asenddir($zeneth.d)
  if ($1 == change) { goto change }
  if ($1 == newdir) { goto newdir }
  if ($1 == ref) { goto norm }
  :newdir
  var %zeneth.tempsend = $zeneth.r.asenddir($2)
  if (%zeneth.tempsend != $null) { var %zeneth.senddir = %zeneth.tempsend }
  write -c %zeneth.dir $+ [ $zeneth.rep1($2) ] $+ .dir
  var %zeneth.senddir2 = $$sdir[="Select directory for Sending"] %zeneth.senddir
  zeneth.remini $2 Asendir
  if (%zeneth.senddir2 == $null) { goto newdir }
  zeneth.work o $2 Creating a list of Files in %zeneth.senddir2 $+ .... Please Wait
  if (%zeneth.senddir2 == %zeneth.senddir) { var %zeneth.same = on }
  else { var %zeneth.same = off }
  var %zeneth.senddir = %zeneth.senddir2
  goto start1
  :change
  if (%zeneth.senddir == $null) {
    var %zeneth.senddir2 = $$sdir[="Select directory for Sending"] c:\
    if (%zeneth.senddir2 == $null) { goto change }
    zeneth.work o Default Creating a DEFAULT list of Files in %zeneth.senddir2 $+ .... Please Wait
    if (%zeneth.senddir2 == %zeneth.senddir) { var %zeneth.same = on }
    var %zeneth.senddir = %zeneth.senddir2
    goto start1
  }
  else {
    var %zeneth.senddir2 = $$sdir[="Select directory for Sending"] %zeneth.senddir
    if (%zeneth.senddir2 == $null) { goto change }
    zeneth.work o Default Creating a DEFAULT list of Files in %zeneth.senddir2 $+ .... Please Wait
    if (%zeneth.senddir2 == %zeneth.senddir) { car %zeneth.same = on }
    var %zeneth.senddir = %zeneth.senddir2
    goto start1
  }
  :norm
  if (( [ $zeneth.r.asenddir($zeneth.d) ] == $null) || ( [ $zeneth.r.asenddir($zeneth.d) ] == Selection)) {
    var %zeneth.senddir2 = $$sdir[="Select directory for Sending"] c:\
    if (%zeneth.senddir2 == $null) { goto change }
    zeneth.work o Default Creating a DEFAULT list of Files in %zeneth.senddir2 $+ .... Please Wait
    if (%zeneth.senddir2 == %zeneth.senddir) { var %zeneth.same = on }
    var %zeneth.senddir = %zeneth.senddir2
    goto start1
  }
  if ($2 != $zeneth.d) { var %zeneth.senddir.own = [ $zeneth.r.asenddir($2) ] }
  if (($2 == $null) || (%zeneth.senddir.own == $null)) {
    var %zeneth.senddir = [ $zeneth.r.asenddir($zeneth.d) ]
    write -c [ %zeneth.dirlistt ]
  }
  else { var %zeneth.senddir = %zeneth.senddir.own | write -c [ %zeneth.dir $+ [ $zeneth.rep1($2) ] $+ .dir ] }
  :start1
  if (($1 != newdir) && (%zeneth.senddir.own == $null)) { write -c %zeneth.dirr $+ Zeneth-Files.txt }
  var %zeneth.sendmask = $?="Mask for files to add? (Blank = *.*)"
  if (%zeneth.sendmask == $null) { var %zeneth.sendmask = *.* }
  zeneth.meter
  var %zeneth.loopy = 1
  var %zeneth.mktot = $findfile(%zeneth.senddir,%zeneth.sendmask,0)
  var %zeneth.mktot2 = %zeneth.mktot
  if (%zeneth.mktot == 0) { goto end }
  window -c @ZeNeTh-List
  window -nlh @ZeNeTh-List
  aline -s @ZeNeTh-List $findfile(%zeneth.senddir,%zeneth.sendmask,@ZeNeTh-List)
  zeneth.pc [ $int($calc( [ ( [ %zeneth.loopy ] / [ %zeneth.mktot ] ) ] *100)) ] Files Left: %zeneth.mktot2
  :Start
  var %zeneth.dirlist = [ $zeneth.rep3($line(@ZeNeTh-List,%zeneth.loopy)) ]
  if (%zeneth.dirlist isnum) { goto ckiiy }
  if (($1 != newdir) && (%zeneth.senddir.own == $null)) { write %zeneth.dirr $+ Zeneth-Files.txt %zeneth.dirlist }
  else { write %zeneth.dir $+ [ $zeneth.rep1($2) ] $+ .dir %zeneth.dirlist }
  if (%zeneth.loopy >= %zeneth.mktot) {
    var %zeneth.senddir = $zeneth.rep3( [ %zeneth.senddir ] )
    goto end
  }
  else {
    :ckiiy
    inc %zeneth.loopy 1
    dec %zeneth.mktot2 1
    zeneth.pc [ $int($calc( [ ( [ %zeneth.loopy ] / [ %zeneth.mktot ] ) ] *100)) ] Files Left: %zeneth.mktot2
    goto start
  }
  :end
  window -c @ZeNeTh-List
  dialog -x zeneth-meter
  if ($1 == newdir) { zeneth.work c $2 }
  else { zeneth.work c Default }
  if ($2 == $null) { var %zeneth.asend.nik = Default }
  else { var %zeneth.asend.nik = $2 }
  zeneth.msg %zeneth.asend.nik e Auto-Send Directory: [ %zeneth.senddir ] 
  zeneth.msg %zeneth.asend.nik ee Mask: [ %zeneth.sendmask ] [ $str($chr(160),20) ] Total Files: [ %zeneth.mktot ]
  if (($1 != newdir) && (%zeneth.senddir.own == $null)) {
    zeneth.writeini $zeneth.d Asenddir %zeneth.senddir
    zeneth.writeini $zeneth.d Total %zeneth.loopy
    if ($dialog($zeneth.exp.dialog($2)).x != $null) { zeneth.credref $2 }
  }
  else {
    zeneth.writeini $2 Total %zeneth.loopy
    zeneth.writeini $2 Asenddir %zeneth.senddir
    if (%zeneth.same == off) {
      zeneth.writeini $2 Custno 0
      zeneth.remini $2 Asendno
    }
    if ($dialog($zeneth.exp.dialog($2)).x != $null) { zeneth.credref $2 }
  }
  if ($dialog($zeneth.confi).x != $null) { zeneth.config.loadsettings }
}
alias zeneth.config.mkulist {
  if ($1 == $null) { write -c %zeneth.dirr $+ Zeneth-Files.txt | var %zeneth.lnick = $zeneth.d }
  else {
    write -c %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .dir
    var %zeneth.lnick = $1
  }
  var %zeneth.ljop = 1
  zeneth.msg %zeneth.lnick e Select the File to add and repeat this for as many files as u want!
  zeneth.msg %zeneth.lnick ee To Stop selecting, just click "Cancel"
  zeneth.msg %zeneth.lnick 3
  :ljop
  if (%zeneth.aadir == $null) { var %zeneth.aafile = $dir[="Select a file to Add"] }
  else { var %zeneth.aafile = $dir[="Select a file to Add"] %zeneth.aadir }
  if (%zeneth.aafile == $null) { goto fin }
  else {
    var %zeneth.aadir = [ $nofile(%zeneth.aafile) ]
    if ($1 == $null) { write %zeneth.dirr $+ Zeneth-Files.txt %zeneth.aafile }
    else { write %zeneth.dir $+ [ $zeneth.rep1($1) ] $+ .dir %zeneth.aafile }
    inc %zeneth.ljop 1
    goto ljop
  }
  :fin
  dec %zeneth.ljop 1
  if ($1 == $null) { zeneth.writeini $zeneth.d Total %zeneth.ljop }
  else { zeneth.writei %zeneth.dir $+ [ [ $zeneth.rep1($1) ] $+ ] .ini [ $zeneth.readread($zeneth.rep1($1)) ] Total %zeneth.ljop }
  zeneth.writeini %zeneth.lnick Asenddir Selection
  zeneth.writeini %zeneth.lnick Custno 0
  zeneth.msg %zeneth.lnick e Auto-Send list Created.... ( $+ [ %zeneth.ljop ] Files)
  if ($dialog($zeneth.confi) != $null) { zeneth.config.loadsettings }
  if (($dialog( [ zeneth-Exp- [ $+ [ $1 ] ] ] ).x != $null) && ($1 != $null)) { zeneth.credref $1 }
}
alias zeneth.duplic {
  if ($dialog(zeneth-meter) != $null) { zeneth.meterr }
  window -c @ZeNeTh-Duplicate
  var %zeneth.dupdir = $$sdir[="Select Dir to Check Files?"]
  zeneth.work o Duplicate Creating a Duplicate List of Files in %zeneth.dupdir
  window -nlh @ZeNeTh-Duplicate
  var %zeneth.dupc = 1
  var %zeneth.duptot = $findfile(%zeneth.dupdir,*,0)
  var %zeneth.duptot2 = %zeneth.duptot
  aline -s @ZeNeTh-Duplicate $findfile(%zeneth.dupdir,*,@ZeNeTh-Duplicate)
  zeneth.meter
  :loop
  zeneth.pc [ $int($calc( [ ( [ %zeneth.dupc ] / [ %zeneth.duptot ] ) ] * 100)) ] Files Left: %zeneth.duptot2
  var %zeneth.dupch = $line(@ZeNeTh-Duplicate,%zeneth.dupc)
  if (%zeneth.dupch isnum) { goto chek }
  var %zeneth.dupch2 = [ $nopath(%zeneth.dupch) ]
  var %zeneth.dupini = [ $left(%zeneth.dupch2,2) ]
  if (($chr(40) || $chr(41)) isin %zeneth.dupini) { var %zeneth.dupini = [ $zeneth.repb(%zeneth.dupini) ] }
  if (%zeneth.dupini == $null) { var %zeneth.dupini = ?? }
  write -s $+ %zeneth.dupch2 %zeneth.dirr $+ files\ $+ %zeneth.dupini $+ .ini [ %zeneth.dupch2 ] - [Path]-> %zeneth.dupch
  :chek
  if (%zeneth.dupc >= %zeneth.duptot) { goto done }
  else {
    inc %zeneth.dupc 1
    dec %zeneth.duptot2
    goto loop
  }
  :done
  dialog -x zeneth-meter
  window -c @ZeNeTh-Duplicate
  zeneth.error Duplicate All Files in %zeneth.dupdir have been recorded!
}
dialog zeneth-meter {
  size 10 10 200 100
  title "ZeNeTh Progress Meter"
  Text "", 1, 20 5 200 15
  edit "", 2, 10 40 180 20
  text "Percent Done: 0%", 3, 50 68 100 15
  button "", 4, 1 1 1 1, ok hide
}
alias zeneth.meter {
  dialog -m zeneth-meter zeneth-meter
}
alias zeneth.pc {
  if (($1 !isnum) || ($2 == $null)) { halt }
  var %zeneth.pc = [ $calc( [ $1 ] / 100) ]
  var %zeneth.prog = [ $int( [ $calc( [ %zeneth.pc ] * 86) ] ) ]
  :lp
  did -o zeneth-meter 1 1 $2-
  did -o zeneth-meter 2 1 $str($chr(124),%zeneth.prog)
  did -o zeneth-meter 3 1 Percent Done: $int($1) $+ %
}
alias zeneth.msg {
  var %zeneth.msg = 1
  :loop
  if (%zeneth.msg >= 50) { halt }
  var %zeneth.name = zeneth-Msg- [ $+ [ %zeneth.msg ] $+ ] - [ $+ [ $1 ] ]
  if ($dialog(%zeneth.name).x == $null) {
    if (($2 == 2) || ($2 == ee)) { dec %zeneth.msg 1 }
    else { dialog -mo %zeneth.name zeneth-Msg }
    zeneth.msg.msg %zeneth.msg $1-
  }
  else { inc %zeneth.msg 1 | goto loop }
}
dialog Zeneth-Msg {
  title "ZeNeTh FileServer Explorer - Notice"
  size 10 10 402 82
  box "Notice-",1,2.5 0 397.5 80
  button "&OK",2,157.5 52.5 72.5 20,ok
  text "",3,7.5 17.5 390 16.25
  text "",4,7.5 34 390 16.25
}
alias zeneth.msg.msg {
  var %zeneth.name = zeneth-Msg- [ $+ [ $1 ] $+ ] - [ $+ [ $2 ] ]
  if (e !isin $3) { dialog -t %zeneth.name ZeNeTh FileServer Explorer - Notice - $2 }
  if (($3 == 1) || ($3 == e)) {
    did -a %zeneth.name 3 $4-
    did -r %zeneth.name 4
    did -v %zeneth.name 2
    if ($3 == 1) { write -il1 %zeneth.dir $+ $zeneth.rep1($2) $+ .not $asctime(hh:nn:ss tt) $4- $chr(160) }
  }
  if (($3 == 2) || ($3 == ee)) { did -a %zeneth.name 4 $4- | if ($3 == 2) { write -al1 %zeneth.dir $+ $zeneth.rep1($2) $+ .not <=> $4- } }
  if ($3 == 3) { did -h %zeneth.name 2 }
  if (($zeneth.r.notice($zeneth.d) == yes) && (e !isin $3)) { if ($3 == 2) { did -d zeneth-Notice- [ $+ [ $2 ] ] 1 1 } | zeneth.notice.open $2 }
}
alias zeneth.work.open { dialog $2 zeneth-Work- [ $+ [ $1 ] ] zeneth-Work }
dialog zeneth-Work {
  title "Working"
  size 10 10 402 58
  box "Operation",1,2.5 0 397.5 55
  text "Message",2,7.5 17.5 390 32.5
  button "HIDDEN",3,1 1 1 1,cancel,hide
}
on *:dialog:zeneth-Work-*:init:0:{ dialog -t $dname ZeNeTh FileServer Explorer - Working - $right($dname,-12) }
alias zeneth.work {
  if ($3 != access) { .timer.zeneth.ff [ $+ [ $2 ] ] 1 1 .timer.zeneth.den $+ $2 off }
  if (o isin $1) { goto open }
  if ($1 == c) { goto close }
  goto end
  :open
  if ( [ $dialog( [ zeneth-Exp- [ $+ [ $2 ] ] ] ).x ] != $null) { dialog -v zeneth-Exp- [ $+ [ $2 ] ] }
  if ($dialog($zeneth.wor($2)).x == $null) { zeneth.work.open $2 -ma
    if ($1 != oo) { var %zeneth.x = $zeneth.x($2), %zeneth.y = $zeneth.y($2) }
    else { var %zeneth.x = 10, %zeneth.y = 10 }
    if ((%zeneth.x == $null) || (%zeneth.y === $null)) { var %zeneth.x = -1, %zeneth.y = -1 }
    dialog -s $zeneth.wor($2) %zeneth.x %zeneth.y 402 58
  }
  zeneth.work.write $2 $3-
  if ( [ $dialog( [ zeneth-Exp- [ $+ [ $2 ] ] ] ).x ] != $null) { zeneth.exp.status $zeneth.exp.dialog($2) Operation: $3- }
  goto end
  :Close
  if ($dialog($zeneth.wor($2)).x != $null) { dialog -x $zeneth.wor($2) }
  if ( [ $dialog( [ zeneth-Exp- [ $+ [ $2 ] ] ] ).x ] != $null) { zeneth.exp.status $zeneth.exp.dialog($2) }
  :end
}
alias zeneth.work.write { did -a zeneth-Work- [ $+ [ $1 ] ] 2 $2- }
alias zeneth.error {
  zeneth.work o $1-
  .timer.zeneth.error. [ $+ [ $1 ] ] 1 5 zeneth.work c $1
}
alias zeneth.wor { return zeneth-Work- [ $+ [ $1 ] ] }
alias zeneth.exp.pc {
  var %zeneth.name = $zeneth.exp.dialog($1)
  did -h %zeneth.name 33,32
  did -v %zeneth.name 31,34,35,52
  did -o %zeneth.name 35 1 [ $str(|,$2) ]
  did -a %zeneth.name 34 $3-
  did -a %zeneth.name 52 $2 $+ % Complete
}
alias zeneth.exp.filedir { if ( [ $dialog($zeneth.exp.dialog($1)).x ] != $null) { did -o [ $zeneth.exp.dialog($1) ] 32 1 $2 } }
alias zeneth.exp.filedir.show {
  var %zeneth.name = $zeneth.exp.dialog($1)
  if ($dialog(%zeneth.name).x != $null) { did -h %zeneth.name 34,35,36,52 | did -v %zeneth.name 33,32,31 | zeneth.exp.filedir $1 0 }
}
alias zeneth.slide.dlg {
  if ($3 !isnum) { halt }
  var %zeneth.h = $dialog($1).h
  dec %zeneth.h 25
  var %zeneth.w = $dialog($1).w 
  dec %zeneth.w 6
  var %zeneth.x = $dialog($1).x, %zeneth.y = $dialog($1).y
  if ($2 == h) { var %zeneth.l = %zeneth.h }
  else { var %zeneth.l = %zeneth.w }
  var %zeneth.lo = %zeneth.l
  :loop
  if (%zeneth.lo < $3) { if (%zeneth.l >= $3) { goto end } | inc %zeneth.l 15 }
  else { if (%zeneth.l <= $3) { goto end } | dec %zeneth.l 15 }
  if ($2 == w) { dialog -s $1 %zeneth.x %zeneth.y %zeneth.l %zeneth.h }
  else { dialog -s $1 %zeneth.x %zeneth.y %zeneth.w %zeneth.l }
  goto loop
  :end
  if ($2 == w) { dialog -s $1 %zeneth.x %zeneth.y $3 %zeneth.h }
  else { dialog -s $1 %zeneth.x %zeneth.y %zeneth.w $3 }
}
alias zeneth.Browse.open {   if ( [ $dialog(zeneth-Browse).x ] == $null) { dialog -m zeneth-Browse zeneth-Browse } | else { dialog -v Zeneth-Browse } }
dialog zeneth-Browse {
  title "Settings"
  size -1 -1 101 256
  button "&Misc Settings",1,2.5 10 95 20
  button "&Script Settings",2,2.5 35 95 20
  button "&Help",3,2.5 62.5 95 20
  button "&About",4,5 170 87.5 20
  button ">>>",5,2.5 230 95 20
  box "&Offline Browsing",6,102.5 5 215 245
  list 7,110 22.5 200 157.5,sort,extsel
  button "&Refresh",8,215 185 97.5 20
  button "&View",9,110 185 97.5 20
  button "&Delete Selected",10,112.5 222.5 95 20
  box "Deletion",11,107.5 207.5 205 40
  button "D&elete All",12,212.5 222.5 95 20
  text "Offline Browsing:",13,2.5 212.5 97.5 17.5
  box "",14,0 92.5 97.5 102.5
  button "HIDDEN",15,1 1 1 1,cancel,hide
  icon 16,5 90 85 95,%zeneth.bmp
}
on *:dialog:zeneth-Browse:sclick:1:zeneth.config.misc.open
on *:dialog:zeneth-Browse:sclick:2:zeneth.config.script.open
on *:dialog:zeneth-Browse:sclick:3:zeneth.hlp
on *:dialog:zeneth-Browse:sclick:4:zeneth.about
on *:dialog:zeneth-Browse:sclick:5:zeneth.browse.check
on *:dialog:zeneth-Browse:dclick:7:zeneth.browse.view
on *:dialog:zeneth-Browse:sclick:8:zeneth.browse.ref $dname
on *:dialog:zeneth-Browse:sclick:9:zeneth.browse.view
on *:dialog:zeneth-Browse:sclick:10:zeneth.browse.delete
on *:dialog:zeneth-Browse:sclick:12:zeneth.exp.cmd zeneth.browse.clear

alias zeneth.browse.check {
  if ($did($did) == >>>) { zeneth.slide.dlg $dname w 322 | did -a $dname $did <<< | dialog -t $dname Settings - Offline Browsing | zeneth.browse.refresh.check }
  else { zeneth.slide.dlg $dname w 101 | did -a $dname $did >>> | dialog -t $dname Settings }
}
alias zeneth.browse.refresh.check { if ($did($dname,7).lines == 0) { zeneth.browse.ref $dname } }
alias zeneth.browse.ref {
  var %zeneth.lop = 1
  write -c %zeneth.dir $+ Dirlist.Dir
  :loop
  %zeneth.dirlist = $findfile(%zeneth.dir,*.nfo,%zeneth.lop)
  if (%zeneth.dirlist == $null) { goto end }
  if ( [ $nofile(%zeneth.dirlist) ] != %zeneth.dir) { goto l2 }
  write %zeneth.dir $+ Dirlist.Dir  [ $replace( [ $remove($remove(%zeneth.dirlist,.nfo),%zeneth.dir) ] ,$chr(222),$chr(124)) ]
  :l2
  inc %zeneth.lop 1
  goto loop
  :end
  did -r $1 7
  if ($lines( [ %zeneth.dir $+ dirlist.dir ] ) != $null) {
    loadbuf -po $1 7 %zeneth.dir $+ dirlist.dir
    did -e $1 9,11,12
  }
  else { did -b $1 9,11,12 }
}
alias zeneth.browse.view {
  %zeneth.browse = $did($dname,7,$did($dname,7,1).sel)
  if (%zeneth.browse == $null) { halt }
  zeneth.writeini %zeneth.browse Mask *.*
  zeneth.exp.view %zeneth.browse
}
alias zeneth.browse.delete {
  var %zeneth.ts = $did($dname,7,0).sel
  if (%zeneth.ts == $null) { halt }
  var %zeneth.tss = 1
  :loop
  var %zeneth.repl = $did($dname,7,$did($dname,7,%zeneth.tss).sel)
  zeneth.flush.bat [ [ $zeneth.rep1(%zeneth.repl) ] $+ ] *
  if (%zeneth.tss >= %zeneth.ts) { halt }
  else { inc %zeneth.tss 1 | goto loop }
}
alias zeneth.browse.clear {
  if ($?!="Are u sure you wish to Clear All Records?") { goto next }
  goto end
  :next
  zeneth.flush.bat *
  zeneth.error Wait Please wait for the Dirictory list to be refreshed!
  :end
}
alias zeneth.repc { var %zeneth.r = $chr(160) $+ $chr(44) $+ $chr(160) | return [ $replace($replace($1-,$chr(32),%zeneth.r),$chr(160),$chr(32)) ] }
