; %Tyrant Socket Chat 
; %Version: 1.0(the one and only version)
; %Released: 17/06/2000

; Dialogs [GUI]

dialog tyschat {
  title "[Tyrant] - Socket Chat"
  size -1 -1 210 112
  option dbu

  box "Tyrant S&ocket Chat", 1, 5 5, 200 75,

  edit "", 2, 8 15, 194 62, multi, vsbar, hsbar
  edit "", 3, 5 83, 200 11, 

  button "Send Text", 4, 10 96, 40 12, default
  button "Close Server", 5, 60 96, 40 12, ok
  button "Ping Remote", 6, 110 96, 40 12, 
  button "Clear Screen", 7, 160 96, 40 12,
}

dialog schat.connect {
  title "[Tyrant] - Socket Chat"
  size -1 -1 100 30
  option dbu

  box "&Enter IP:", 1, 2 2, 95 25
  edit "", 3, 4 12, 80 11,
  button "!", 5, 85 12, 10 10, default, ok
}
; Dialogs [Events]

alias schat.connect { dialog -m schat.connect schat.connect } 
alias tychat.gui { dialog -m tyschat tyschat }

alias schat.host {
  if ($sock(ty.chat.listen).name == $null) {
    ty.start.server
  } 
  else {
    sockclose ty* 
    ty.start.server
  }
}
alias ty.start.server {
  socklisten ty.chat.listen 7475
  tychat.gui
  did -i tyschat 2 1 * Server Started on $fulldate
  inc %tyschat.lines 1
}
on 1:dialog:schat.connect:sclick:*:{
  if $did == 5 { 
    set %my.nick $me
    if ($did(3).text == $null) { return }
    set %schat.ip $did(3).text 
    sockopen Tyrant.chat.connect %schat.ip 7475
    tychat.gui
    did -i tyschat 2 1 * Connecting to %schat.ip $+ ...
    inc %tyschat.lines 1
  }
}
on 1:dialog:tyschat:init:*:{
  set %tyschat.lines 0
  did -f tyschat 3
}

on 1:dialog:tyschat:sclick:*:{
  if $did == 4 {
    inc %tyschat.lines 1
    did -i tyschat 2 %tyschat.lines $me $+ : $did(3).text
    sockwrite -n ty*  $me $+ : $did(3).text 
    did -r tyschat 3
  }

  if $did == 7 { set %tyschat.lines 0 | did -r tyschat 2 }
  if $did == 5 { sockwrite -n ty* * $me $+ ( $+ $ip $+ ) has disconnected from server | .timer75 1 1 sockclose ty* }
  if $did == 6 { set %ping.secs 0 | .timer7475 0 1 inc %ping.secs 1  | sockwrite -n ty* ^PING }
}

; Sockets [Main]

on 1:socklisten:ty.chat.listen:{
  %tychat.client = ty.chat.user
  sockaccept %tychat.client
  sockwrite -n %tychat.client * Connected to server!
  inc %tyschat.lines 1
  did -i tyschat 2 %tyschat.lines * $sock($sockname).ip joins server
}

on 1:sockread:ty*:{
  if ($sockerr > 0) return
  :nextread
  sockread %temp
  if ($sockbr == 0) return
  if (%temp == $null) return 
  if (%temp == ^PING) { sockwrite -n ty* ^PONG | return }
  if (%temp == ^PONG) { .timer7475 off | inc %tyschat.lines 1 | did -i tyschat 2 %tyschat.lines * Ping reply: %ping.secs $+ secs | return } 
  inc %tyschat.lines 1
  did -i tyschat 2 %tyschat.lines %temp
  goto nextread
}

; Those silly popup things

menu channel,menubar {
  &Sock-Chat
  .&Host:schat.host
  .Cli&ent:schat.connect
}

; Thats all folks!
