; TuS Xdcc Server
; by
; TuS on EFNET
; 

; *** System Script Load Routine
on *:load: {
  if ($version < 5.8) {
    echo -a 5This Xdcc Server addon  requires mIRC 5.8 or higher. Get it at http://www.mirc.co.uk .
  unload -rs $script | halt }
  else { echo -a 5Loaded Xdcc Server by TuS v1.0 Thank you for trying this mIRC 5.8 addon.
    ; Init data file ($mircdir\TuSXdata.ini) if doesn't existe
    if ($isfile($mircdir\TuSXdata.ini) == $false) {
      xdccset main enab $false
      xdccset main mainslots 5
      xdccset main queueslots 5
      xdccset main getsuser 1
      xdccset main maxcps 0
      xdccset main timeout 120
      xdccset main msg1 *-* XDCC Server by TuS v1.0 *-*
      xdccset main msg2 *-* Thank you for trying this mIRC 5.8 addon *-*
      xdccset main msg3 *-* Contact : TuSTuS@Hotmail.com / TuS on EFNet *-*      
      xdccset main Allrecord 0.0
      xdccset main Allserved 0.0
      xdccset main AllDL 0      
      xdccset main Currentrecord 0.0
      xdccset main Currentserved 0.0 
      xdccset main CurrentDL 0
    xdccset main Currentbps 0.0 }  
dialog -m xdcc xdcc  } }

; *** Server Served Trigger
on 1:FILESENT:*.*:  { 
  xdcc.statssrv
xdcc.checkqueue }

; *** Server Send fail Trigger
on 1:SENDFAIL:*.*:  { 
xdcc.checkqueue }

; *** Server Restart Timers on join
on 1:Join:#:  { 
  if ( $xdccget(main, enab) == $true) {
    if ($send(0) > 0 ) { .timercheckminspeed 0 15 xdcc.checkminspeed | .timerstatsbps 0 10 xdcc.statsbps }
  if ($xdccget(main, chanplay) > 0) { .timerchanplay 0 $xdccget(main, chanplay) c.play # | c.play # } }
}

; *** Server /CTCP Requests Reply Routine
ctcp 1:xdcc *: {
  if ($xdccget(main,enab)) {

    ; *** /CTCP Send Request (Check Syntax / Pack N) 
    if ($2 == send) {
      xdcc.checkpack $nick $3
    if ($result == $true) { xdcc.checkcurrentstate $nick $3 } }

    ; *** /CTCP Remove Request (ALL or Pack)     
    else if ($2 == remove) {
    xdcc.remove $nick $3 }

    ; *** /CTCP View Queue     
    else if ($2 == queue) {
    xdcc.userqueue $nick }

    ; *** /CTCP List Request (Same as Channel Play but /notice) 
    else if ($2 == list) { 
      xdcc.statsbps
      /notice $nick 5** $$numtok($xdccget(main,packets),32) Packs ** $+ $chr(32) $+ $calc($xdccget(main,mainslots) - $send(0)) of $+ $chr(32) $+ $xdccget(main,mainslots)  slots open ** ALL Time Record $+ $chr(32) $+ $xdccget(main,Allrecord) KB/s **
      /notice $nick 5** Bandwidth Usage ** Current : $+ $chr(32) $+ $xdccget(main,Currentbps) KB/s, Record $xdccget(main,Currentrecord) KB/s **
      /notice $nick 5** To request a file type : "/ctcp $me xdcc send #x" **
      if ( $len($xdccget(main,msg1)) > 0) { /notice $nick 5 ^*^ $xdccget(main,msg1) ^*^ }
      :loopl | inc -u0 %.x.var
      set -u0 %.xl.var $gettok($xdccget(main,packets),%.x.var,32)
      /notice $nick 5 $+ $chr(35) $+ %.x.var $xdccget(%.xl.var,dl) $+ x $chr(91) $+ $xdccget(%.xl.var,size) $+ $chr(93)  $chr(91) $+ %.xl.var $+ $chr(93) $chr(91) $+ $xdccget(%.xl.var,desc) $+ $chr(93)
      if (%.x.var < $numtok($xdccget(main,packets),32)) { goto loopl }
      if ($len($xdccget(main,msg2)) > 0) { /notice $nick 5 ^*^ $xdccget(main,msg2) ^*^ }
      if ($len($xdccget(main,msg3) > 0)) { /notice $nick 5 ^*^ $xdccget(main,msg3) ^*^ } 
    /notice $nick 5** Current Served : $+ $chr(32) $+ $xdccget(main,Currentserved) MB, Total Transfered :  $+ $chr(32) $+ $xdccget(main,Allserved) MB ** }

    ; *** /CTCP Search Request (Search Through Packs)
    else if ($2 == search) {
      /notice $nick 5*** To request a file type: "/msg $me xdcc send #x" ***
      :loops | inc -u0 %.x.var
      set -u0 %.xs.var $gettok($xdccget(main,packets),%.x.var,32)
      if (($3 isin %.xs.var) || ($3 isin $xdccget(%.xs.var,desc))) {
        if (%.found == $null) { /notice $nick 5*** Matching Packets Found : }
        /notice $nick 5 $+ $chr(35) $+ %.x.var $xdccget(%.xs.var,dl) $+ x $chr(91) $+ $xdccget(%.xs.var,size) $+ $chr(93)  $chr(91) $+ %.xs.var $+ $chr(93) $chr(91) $+ $xdccget(%.xs.var,desc) $+ $chr(93)
      set -u0 %.found $true }
      if (%.x.var <= $numtok($xdccget(main,packets),32)) { goto loops }
    if (%.found == $true) { return } | else { /notice $nick 5*** No Matching Packets Found. } }

    ; *** /CTCP Help Request
    else if ( ($2 == help) || ($2 == $null) ) {
      /notice $nick 5***                   *-* XDCC Server by TuS v1.0 *-*                  ***
      if ($len($xdccget(main,msg1)) > 0) { /notice $nick 5 ^*^ $xdccget(main,msg1) ^*^ }
      /notice $nick 5***  Help : This screen
      /notice $nick 5***  List : List all offerings
      /notice $nick 5***  Send $chr(35) $+ x : Get a packet (example: /ctcp $me xdcc send #3)
      /notice $nick 5***  Search <string>: Search for a packet (example: /ctcp $me xdcc search acid)
      /notice $nick 5***  Queue : View Your Queue Status (example: /ctcp $me xdcc queue )
      /notice $nick 5***  Remove  : Remove Pack or ALL Queued Transfers 
      /notice $nick 5***   (example: /ctcp $me xdcc remove all ) or ( example: /ctcp $me xdcc remove #2 )
      if ($len($xdccget(main,msg2)) > 0) { /notice $nick 5 ^*^ $xdccget(main,msg2) ^*^ }
    if ($len($xdccget(main,msg3) > 0)) { /notice $nick 5 ^*^ $xdccget(main,msg3) ^*^ } }
  else { /notice $nick : Command no recognized (example: /ctcp $me xdcc send #3) } }
else { /notice $nick my xdcc server is currently disabled. | ignore -tu15 $nick } }

; *** System Read/Write data file
alias xdccget return $readini $mircdir\TuSXdata.ini $1 $2
alias xdccset writeini $mircdir\TuSXdata.ini $1 $2 $3-

; *** Dialog The Dialog 
alias xdcc.setup dialog -m xdcc xdcc
dialog xdcc {
  title $me XDCC Setup
  size -1 -1 480 440
  list 1,100 30 370 120
  button "&Add packet",2,10 30 75 20
  button "&Del packet",3,10 55 75 20
  button "&Edit desc",4,10 80 75 20
  button "&Min Speed",27,10 105 75 20
  button "&Refresh",5,10 130 75 20
  button "&Done",200,10 327 75 20,Ok
  text "Size :",6, 105 155 100 20
  text  "DL's :",7,190 155 100 20
  text "Desc :",8,105 172 360 15
  box "Packet Info",9, 100 140 370 50
  text "Send Slots (1-99) :",10,217 209 90 15
  edit "",11,307 205 23 20
  check "",12, 105 205 20 20
  text "",13,125 209 90 15
  text "*-* XDCC Server v1.00 by TuS *-*",14,160 9 325 15
  box "Server Setup",15, 100 190 370 158
  text "            \\|//                        (o o)           _oOOo_(_)_oOOo_",16,2 285 92 40
  box "",17,10 0 460 25
  text "Message Before List :",18,105 250 110 15
  edit "",19,105 265 360 20 
  text "Messages After List :",20,105 290 110 15
  edit "",21,105 305 360 20
  text "Ext  :",22, 270 155 60 20
  text "XDCC Server : ADD Packets, Set Options, Enable Server and That's all :))   *-* Have Fun *-*",23,20 420 440 15
  box "",24,10 411 460 26
  edit "",26,105 323 360 20
  text "Min Speed :",28, 340 155 125 15
  text "Max Gets/User (1-9) :",29,345 209 105 15
  edit "",30,449 205 16 20
  box "Server Stats",31, 100 350 370 50 
  text "Max Cps/Send :",32,340 229 80 15
  edit "",33,420 225 45 20
  text "Over All",34, 105 365 80 15
  text  "DL's : 0",35,160 365 70 15
  text "Served (MB) : 0.0",36,235 365 110 15
  text "Record (KB/s) : 0.0",37, 350 365 110 15
  text "Session",38, 105 380 80 15
  text  "DL's : 0",39,160 380 70 15
  text "Served (MB) : 0.0",40,235 380 110 15
  text "Record (KB/s) : 0.0",41, 350 380 110 15
  button "Reset &Session",42,10 379 75 20
  button "Reset &All",43,10 356 75 20
  text "Queue Slots (0-99) :",44,210 229 100 15
  edit "",45,307 225 23 20
  text "DCC Timeout :",46,105 229 70 15
  edit "",47,175 225 28 20 
}

; *** Dialog Events Routine
on 1:dialog:xdcc:*:*: {
  if ($devent == init) { xdcc.init }
  if ($devent == sclick) {
    if ($did == 1) {
      did -ra xdcc 6 Size : $xdccget($gettok($did(xdcc,1,$did(xdcc,1).sel).text,2,32) ,size) 
      did -ra xdcc 7 DL's : $xdccget($gettok($did(xdcc,1,$did(xdcc,1).sel).text,2,32) ,dl) 
      did -ra xdcc 22 Ext : $xdccget($gettok($did(xdcc,1,$did(xdcc,1).sel).text,2,32) ,Ext) 
      did -ra xdcc 8 Desc : $xdccget($gettok($did(xdcc,1,$did(xdcc,1).sel).text,2,32) ,desc)
      if ( $xdccget($gettok($did(xdcc,1,$did(xdcc,1).sel).text,2,32) ,minspeed) == 0 ) {
      did -ra xdcc 28 Min Speed : Disabled }
    else { did -ra xdcc 28 Min Speed : $xdccget($gettok($did(xdcc,1,$did(xdcc,1).sel).text,2,32) ,minspeed) $+ $chr(32) KB/s } }
    if ($did == 2) { .timer 1 0 xdcc.add }
    if ($did == 3) { .timer 1 0 xdcc.rem }
    if ($did == 5) { .timer 1 0 xdcc.init }
    if ($did == 4) { .timer 1 0 xdcc.changeDesc }
    if ($did == 27) { .timer 1 0 xdcc.changeMinspeed }
    if ($did == 12) { 
      if ($did(12).state) { xdccset main enab $true | did -ra xdcc 13 Xdcc Enabled :) | did -ra xdcc 23  XDCC Server : Enabled :) } 
    else { xdccset main enab $false | did -ra xdcc 13 Xdcc Disabled :(  | did -ra xdcc 23  XDCC Server : Disabled  :( } }
    if ($did == 42) { .timer 1 0 xdcc.ResetStats Session }
    if ($did == 43) { .timer 1 0 xdcc.ResetStats All }
  if ($did == 142) { .timer 1 0 xdcc.SetAllStats } }

  if ($devent == edit) { 
    if ($did == 11) { 
      if ($did(11).text isnum 1-99) { 
        xdccset main mainslots $ifmatch
        did -ra xdcc 23  XDCC Server : Send Slots set to $+ $chr(32) $+ $ifmatch 
        if ($send(0) < $xdccget(main,mainslots)) {
    xdcc.checkqueue } } } 
    if ($did == 45) { if ($did(45).text isnum 0-99) { xdccset main queueslots $ifmatch | did -ra xdcc 23  XDCC Server : Queue Slots set to $+ $chr(32) $+ $ifmatch } }
    if ($did == 19) {  if ( $len($did(19)) > 0) && ($left($did(19),1) != $chr(32)) { xdccset main msg1 $did(19).text } | else { remini  $mircdir\TuSXdata.ini  main msg1 } } 
    if ($did == 21) {  if ( $len($did(21)) > 0) && ($left($did(21),1) != $chr(32)) { xdccset main msg2 $did(21).text } | else { remini  $mircdir\TuSXdata.ini  main msg2 } } 
    if ($did == 26) {  if ( $len($did(26)) > 0) && ($left($did(26),1) != $chr(32)) { xdccset main msg3 $did(26).text } | else { remini  $mircdir\TuSXdata.ini  main msg3 } } 
    if ($did == 30) { if ($did(30).text isnum 1-9) { xdccset main getsuser $ifmatch | did -ra xdcc 23  XDCC Server : Max Gets/User set to $+ $chr(32) $+ $ifmatch } } 
    if ($did == 47) { if ($did(47).text isnum 1-999) { xdccset main timeout $ifmatch | did -ra xdcc 23  XDCC Server : DCC Timeout set to $+ $chr(32) $+ $ifmatch Seconds } } 

    if ($did == 33) {  if ($did(33).text isnum 0-999999) { 
        xdccset main maxcps $ifmatch
        if ( $ifmatch == 0 ) { /dcc maxcps 0 | did -ra xdcc 23  XDCC Server : Max Cps/Send Disabled }
      else { /dcc maxcps $xdccget(main,maxcps) | did -ra xdcc 23  XDCC Server : Max Cps/Send set to $+ $chr(32) $+ $xdccget(main,maxcps) $+ $chr(32) Cps } }
else { did -ra xdcc 23  XDCC Server : Max Cps/Send must be 0 to 999999 (0 to Disable) } } } }

; *** Dialog Init Dialog
alias xdcc.init {
  if ($xdccget(main,enab)) { did -ra xdcc 13 Xdcc Enabled :) | did -c xdcc 12 } | else { did -ra xdcc 13 Xdcc Disabled :( | did -u xdcc 12 }
  did -ra xdcc 11 $xdccget(main,mainslots)
  did -ra xdcc 45 $xdccget(main,queueslots)
  did -ra xdcc 30 $xdccget(main,getsuser)
  did -ra xdcc 33 $xdccget(main,maxcps)
  did -ra xdcc 47 $xdccget(main,timeout)
  did -ra xdcc 19 $xdccget(main,msg1)
  did -ra xdcc 21 $xdccget(main,msg2)
  did -ra xdcc 26 $xdccget(main,msg3)
  did -ra xdcc 35 DL's : $+ $chr(32) $+ $xdccget(main,AllDL)
  if ($Round($Calc($xdccget(main,Allserved) / 1000),0) == 0) { 
  did -ra xdcc 36 Served (MB) : $+ $chr(32) $+ $xdccget(main,Allserved) }
  else { did -ra xdcc 36 Served (GB) : $+ $chr(32) $+ $Round($Calc($xdccget(main,Allserved) / 1000),1) }
  did -ra xdcc 37 Record (KB/s) : $+ $chr(32) $+ $xdccget(main,Allrecord)
  did -ra xdcc 39 DL's : $+ $chr(32) $+ $xdccget(main,CurrentDL)
  if ($Round($Calc($xdccget(main,Currentserved) / 1000),0) == 0) { did -ra xdcc 40 Served (MB) : $+ $chr(32) $+ $xdccget(main,Currentserved) }
  else { did -ra xdcc 40 Served (GB) : $+ $chr(32) $+ $Round($Calc($xdccget(main,Currentserved) / 1000),1) }
  did -ra xdcc 41 Record (KB/s) : $+ $chr(32) $+ $xdccget(main,Currentrecord)
  did -r xdcc 1 | did -ra xdcc 6 Size : | did -ra xdcc 7 DL's : | did -ra xdcc 8 Desc : | did -ra xdcc 22 Ext : | did -ra xdcc 28 Min Speed :
  :loop | inc -u0 %.x.var
  if ($gettok($xdccget(main,packets),%.x.var,32)) {
    set -u0 %.get $gettok($xdccget(main,packets),%.x.var,32)
    did -a xdcc 1 $chr(35) $+ %.x.var %.get
goto loop } }

; *** Dialog Add PACK (Unique Pack Name Without Spaces)
alias xdcc.add {
  set -u0 %.xf.var $dir="Select packet file"
  set -u0 %myfile [ $left( [ $nopath(%.xf.var) ] , [ $calc( [ $len( [ $nopath(%.xf.var) ] ) ] - 4 ) ] ) ]
  if ($pos(%myfile,$chr(32),1) == $null ) { 
    set -u0 %mylist $xdccget(main,packets)
    if ( ( $istok($xdccget(main,packets),%myfile,32) == $false ) ||  ($xdccget(main,packets) == $null) ) {
      xdccset main packets $xdccget(main,packets) %myfile
      xdccset %myfile Ext [ $right( [ $nopath(%.xf.var) ] , 4 ) ]
      xdccset %myfile dl 0
      xdccset %myfile minspeed 0
      xdccset %myfile path $nofile(%.xf.var)
      if ($Round($Calc($file( [ %.xf.var ] ).size / 1024000),0) == 0) { 
        if ($Round($Calc($file( [ %.xf.var ] ).size / 1024),0) == 0) {
        xdccset %myfile size <1K }    
      else { xdccset %myfile size $Round($Calc($file( [ %.xf.var ] ).size / 1024),1) $+ K } }
      else { xdccset %myfile size $Round($Calc($file( [ %.xf.var ] ).size / 1024000),1) $+ M }
      xdccset %myfile desc $upper( [ $right( [ $nopath(%.xf.var) ] , 3 ) ] ) $+ $chr(32) $+ File
      did -ra xdcc 23  XDCC Server : Pack Added :) 
    xdcc.init }
  else { did -ra xdcc 23  XDCC Server : Pack already exists :(  } }
else { did -ra xdcc 23  XDCC Server : Spaces in filename are not supported :(  } }

; *** Dialog Delete PACK
alias xdcc.rem {
  if ($did(xdcc,1,$did(xdcc,1).sel).text) {
    set -u0 %.t.var $remtok($xdccget(main,packets),$gettok($did(xdcc,1,$did(xdcc,1).sel).text,2,32),32)
    if (%.t.var == $null) { remini $mircdir\TuSXdata.ini main packets | goto done }
    xdccset main packets %.t.var
:done | remini $mircdir\TuSXdata.ini $gettok($did(xdcc,1,$did(xdcc,1).sel).text,2,32) | xdcc.init | did -ra xdcc 23  XDCC Server : Pack Deleted. } }

; *** Dialog Update File Description
alias xdcc.changeDesc { 
  if ($nopath($gettok($did(xdcc,1,$did(xdcc,1).sel).text,2,32))) {
    if ($len($$?="Enter new packet description") < 55 ) {    
      xdccset $nopath($gettok($did(xdcc,1,$did(xdcc,1).sel).text,2,32)) desc $! 
    did -ra xdcc 8 Desc : $! | did -ra xdcc 23  XDCC Server : Pack Description Updated. }
else {  did -ra xdcc 23  XDCC Server : Pack Description must be LESS than 54 caracters. } } }

; *** Dialog Update File Min Speed
alias xdcc.changeMinspeed { 
  if ($nopath($gettok($did(xdcc,1,$did(xdcc,1).sel).text,2,32))) {
    if ( $$?="Enter new Min Speed (0 - 999 KB/s)" isnum 0-999) {
      xdccset $nopath($gettok($did(xdcc,1,$did(xdcc,1).sel).text,2,32)) minspeed $! 
      if ( $! == 0 ) {
        did -ra xdcc 28 Min Speed : Disabled.
      did -ra xdcc 23  XDCC Server : Pack Min Speed Disabled. }
      else { 
        did -ra xdcc 28 Min Speed : $! $+ $chr(32) KB/s 
    did -ra xdcc 23  XDCC Server : Pack Min Speed Set to $+ $chr(32) $! KB/s. (0 to Disable). } }
else {  did -ra xdcc 23  XDCC Server : Pack Min Speed must be 0 to 999 KB/s  (0 to Disable). } } }

alias xdcc.checkpack {
  if ($asc($left($2,1)) != 35) { /notice $1 5*** Invalid Pack Number, Try Again. | return $False }
  set -u0 %Filenum $right($2,$calc($len($2) - 1))
  if (%Filenum !isnum ) { /notice $1 5*** Invalid Pack Number, Try Again. | return $False }
  if ($gettok($xdccget(main,packets),%Filenum,32)) { return $true }
else { /notice $1 5*** Invalid Pack Number, Try Again. | return $False } }

; *** Server Current State Check (Transfer if Slots Availaible and Sends Per User left)
alias xdcc.checkcurrentstate {
  xdcc.checktransfers  $1 $right($2,$calc($len($2) - 1))
  if ( $result == $true ) {
    xdcc.checkslots mainslots
    if ( $result  == $true ) { xdcc.send $1 $right($2,$calc($len($2) - 1)) }
    else {  xdcc.checkslots queueslots
      if ( $result  == $true ) { xdcc.addqueuetoken $1 $right($2,$calc($len($2) - 1))  }
else { /notice $nick 5*** No Slots Availaible, try again later...  } } } }

; *** Server Availaible Slots Check
alias xdcc.checkslots {
  if ( $1 == mainslots ) { if ( $calc($xdccget(main, $1) - $send(0)) > 0 ) { return $true } 
  return $False }
  if ( $1 == queueslots ) { if ( $calc( $xdccget(main, $1) -  $numtok($xdccget(main,queueusers),32))  > 0 )  { return $true }
return $False } }  

; *** Server Availaible Sends/User, duplicate request check
alias xdcc.checktransfers {
  set -u0 %usersend 0
  set -u0 %userqueue 0
  set -u0 %userrequest 0
  set -u0 %mysend 0 
  :loopsend 
  inc -u0 %mysend 1
  if ( $send(%mysend) == $1 ) { 
    inc %usersend 1 
    set -u0 %.xg.var $gettok($xdccget(main,packets),$2,32) 
    if ( $send(%mysend).file == %.xg.var $+ $xdccget(%.xg.var,ext) ) {
  inc %userrequest 1 } }  
  if ($calc(($send(0) -%mysend)) > 0 )  { goto loopsend }
  set -u0 %mysend 0
  :loopqueue
  inc -u0 %mysend 1
  if ( $gettok($xdccget(main, queueusers),%mysend,32) == $1 ) {
    inc %userqueue 1 
    if ( $gettok($xdccget(main, queuepacks),%mysend,32) == $2 ) {
  inc %userrequest 1 } }
  if ($calc($numtok($xdccget(main,queueusers),32) -%mysend) >= 0 )  { goto loopqueue }
  if ( %userrequest > 0 ) { /notice $1 5*** You  allready requested that pack. | return $false }
  if ( $calc(%usersend +%userqueue) >=  $xdccget(main, getsuser)) { 
    /notice $1 5*** You  allready have $+ $chr(32) $+ %usersend DCC send running and $+ $chr(32) $+ %userqueue Send Queued (Only $+ $chr(32) $+ $xdccget(main, getsuser) allowed).  
  return $false }
return $true  }

; *** Server Send (nick Pack)
alias xdcc.send {
  ;/dcc maxcps $xdccget(main,maxcps)
  set -u0 %.xg.var $gettok($xdccget(main,packets),$2,32)  
  /notice $1 5*** Sending you Pack $+ $chr(32)  $+ $chr(35) $+ $2 Which is $chr(91) $+ $xdccget(%.xg.var,size) $+ $chr(93).  (Resume Supported) 
  /dcc send  $1 $xdccget(%.xg.var,path) $+ %.xg.var $+ $xdccget(%.xg.var,ext)
  .timercheckminspeed 0 15 xdcc.checkminspeed
  .timerstatsbps 0 10 xdcc.statsbps
.timercheckpend 0 $calc( $xdccget(main ,timeout)  / 3) xdcc.dccpending | xdcc.dccpending }

; *** Server Add queue Token (nick Pack)
alias xdcc.addqueuetoken {
  xdccset main queueusers $instok($xdccget(main,queueusers),$1,0,32)
  xdccset main queuepacks $instok($xdccget(main,queuepacks),$2,0,32)
  xdccset main queuetimes $instok($xdccget(main,queuetimes),$ctime,0,32)
/notice $1 5***  All Slots Full, Added you to the main queue in position $+ $chr(32) $+ $numtok($xdccget(main,queueusers),32)  $+ $chr(32) $+ for Pack $+ $chr(32) $+ $chr(35) $+ $2 }  

; *** Server Delete queue Token 
alias xdcc.delqueuetoken {
  if ($numtok($xdccget(main,queueusers),32) == 1) {
    remini  $mircdir\TuSXdata.ini  main queueusers
    remini  $mircdir\TuSXdata.ini  main queuepacks 
  remini  $mircdir\TuSXdata.ini  main queuetimes }
  else if  ($numtok($xdccget(main,queueusers),32) > 1)    {
    xdccset main queueusers  $deltok($xdccget(main,queueusers),$1,32)
    xdccset main queuepacks $deltok($xdccget(main,queuepacks),$1,32)
xdccset main queuetimes $deltok($xdccget(main,queuetimes),$1,32)  } }  

; *** Server Check Queue Routine
alias xdcc.checkqueue {
  if ($numtok($xdccget(main,queueusers),32) >= 1) {
    xdcc.send $gettok($xdccget(main,queueusers),1,32) $gettok($xdccget(main,queuepacks),1,32)
    xdcc.delqueuetoken 1
xdcc.noticequeueusers } }  

; *** Server Notice Queue Users 
alias xdcc.noticequeueusers {
  set -u0 %users $numtok($xdccget(main,queueusers),32) 
  if ( %users >= 1 ) { xdcc.timeleft  
    :loopnotice 
    /notice $gettok($xdccget(main,queueusers),%users,32) 5***  You have been queued for  $+ $chr(32) $+ $duration($calc($ctime - $gettok($xdccget(main,queuetimes),%users,32))) , Currently in main queue in position $+ $chr(32) $+ %users of $+ $chr(32) $+ $numtok($xdccget(main,queueusers),32)  $+ $chr(32) $+ for Pack $+ $chr(32) $+ $chr(35) $+ $gettok($xdccget(main,queuepacks),%users,32)
    /notice $gettok($xdccget(main,queueusers),%users,32) 5***  Estimated remaining time is $+ $chr(32) $+ $duration($result) or less 
    /notice $gettok($xdccget(main,queueusers),%users,32) 5***  Queue : View Your Queue Status (example: /ctcp $me xdcc queue )
    dec %users 1
if (%users > 0) { goto loopnotice } } }

; *** Server remove from Queue (All or #x) 
alias xdcc.remove {
  if ($2 == all) {
    :looprem       
    if ( $istok($xdccget(main,queueusers),$1,32) == $true ) {
      set -u0 %myremove $findtok($xdccget(main,queueusers),$1,1,32)
      /notice $1 5*** Queued Pack $+ $chr(32) $+ $gettok($xdccget(main,queuepacks),%myremove, 32) Transfer Deleted.
      xdcc.delqueuetoken %myremove
      if ($istok($xdccget(main,queueusers),$1,32) == $true ) { 
      goto looprem  }
    else {  /notice $1 5*** ALL Queued Packs Transfer Deleted. } } 
  else { /notice $1 5*** No Transfers Queued.  } }
  else {  
    xdcc.checkpack $1 $2
    if ($result == $true) { 
      if ( $istok($xdccget(main,queueusers),$1,32) == $true ) {
        set -u0 %Packsdel $numtok($xdccget(main,queueusers),32 )            
        set -u0 %mypackdel 0
        :looprempack
        inc %mypackdel 1
        set -u0 %myremove $findtok($xdccget(main,queueusers),$1,%mypackdel,32)
        if ( $gettok($xdccget(main,queuepacks),%mypackdel,32) == $right($2,$calc($len($2) - 1)))  { 
          xdcc.delqueuetoken %mypackdel  
          /notice $1 5*** Pack $+ $chr(32) $+ $2 Queued Transfer Deleted.
        return }
        if ( %mypackdel < %Packsdel ) {
        goto looprempack } 
      else {  /notice $1 5*** That Pack $+ $chr(32) $+ $2 in NOT Queued for Transfer. } } 
else { /notice $1 5*** No Pack Transfer Queued. } } } }

; *** Server queue  view   
alias xdcc.userqueue {
  set -u0 %usersqueueview $numtok($xdccget(main,queueusers),32) 
  if ( $istok($xdccget(main,queueusers),$1,32) == $true ) {
    set -u0 %myviewtoken 0    
    :loopview
    inc %myviewtoken 1  
    set -u0 %myview $findtok($xdccget(main,queueusers),$1,%myviewtoken,32)
    /notice $1 5***  You have been queued for  $+ $chr(32) $+ $duration($calc($ctime - $gettok($xdccget(main,queuetimes),%myview,32))) , Currently in main queue in position $+ $chr(32) $+ %myview of $+ $chr(32) $+ $numtok($xdccget(main,queueusers),32)  $+ $chr(32) $+ for Pack $+ $chr(32) $+ $chr(35) $+ $gettok($xdccget(main,queuepacks),%myview,32)
    if (%myview < %usersqueueview )  { goto loopview   }
    xdcc.timeleft
/notice $1 5***  Estimated remaining time is $+ $chr(32) $+ $duration($result) or less } }

; *** Server timeleft till next Send   
alias xdcc.timeleft { if ( $send(0) > 0)  { set -u0 %mytimecheck 0 | set -u0 %mymintime 0 
    :looptime 
    inc %mytimecheck 1
    set -u0 %timepack $left($nopath($send(%mytimecheck).file), $calc($len($send(%mytimecheck).file) - 4 ))
    if ($istok($xdccget(main,packets),%timepack,32) == $true && $send( %mytimecheck).status ==  active )  { 
      set -u0 %mytime $calc($calc($send(%mytimecheck).size - $send(%mytimecheck).sent) / $send(%mytimecheck).cps )
      if ( %mytime < %mymintime || %mytimecheck == 1) { set -u0 %mymintime %mytime | return %mymintime }
if ( $calc($send(0) - %mytimecheck ) > 0 )  { goto looptime } } } }

; *** Server Min Speed Check 
alias xdcc.checkminspeed {
  :restart  
  if ( $send(0) > 0)  {
    set  -u0 %myspeedcheck 0
    :loopl 
    inc %myspeedcheck 1
    set -u0 %pack $left($nopath($send(%myspeedcheck).file), $calc($len($send(%myspeedcheck).file) - 4 ))
    if ($istok($xdccget(main,packets),%Pack,32) == $true && $send( %myspeedcheck).status ==  active && $send( %myspeedcheck).secs > 45 )  { 
      if ( $round($calc($send( %myspeedcheck).cps / 1024),1) < $xdccget(%Pack ,minspeed) ) {
        set  -u0 %myusercheck 0
        :loopUser
        inc %myusercheck 1
        if ($send($send(%myspeedcheck),%myusercheck).file == $send(%myspeedcheck).file ) {
          /notice $send(%myspeedcheck)  5*** Closing Connection : Under Min Speed Requirement, $+ $chr(32) $+ $round($calc($send( %myspeedcheck).cps / 1024),1) $+ KB/s is less than $+ $chr(32) $+ $xdccget(%Pack ,minspeed) $+ KB/s 
          /close -s $+ %myusercheck $send(%myspeedcheck)
          xdcc.checkqueue
        goto restart }
      else { goto loopUser } }
  if ( $calc($send(0) - %myspeedcheck ) > 0 )  { goto loopl } } }
else { .timercheckminspeed off | .timerstatsbps off } }

; *** Server DCC pending routine
alias xdcc.dccpending {
  :restart  
  set -u0 %mypendcount 0
  if ( $send(0) > 0)  {
    set  -u0 %mypendcheck 0
    :loopl 
    inc %mypendcheck 1
    set -u0 %pendpack $left($nopath($send(%mypendcheck).file), $calc($len($send(%mypenddcheck).file) - 4 ))
    set -u0 %timeleft $calc($round($calc(($xdccget(main ,timeout) - $send( %mypendcheck).secs) / $calc($xdccget(main ,timeout) / 3)),0) )
    if ($istok($xdccget(main,packets),%pendpack,32) == $true && $send( %mypendcheck).status ==  waiting )  { 
      inc %mypendcount 1 
      if (%timeleft > 0 ) {
      /notice $send(%mypendcheck)  5*** You have a DCC pending, Set your client to to receive the transfer. $+ $chr(32) ( $+ $calc( ($xdccget(main ,timeout)  / 3) * %timeleft ) $+ $chr(32) $+ Seconds remaining until timeout) }      
      if (%timeleft <= 0) {
        set  -u0 %myuserpendcheck 0
        :loopUser
        inc %myuserpendcheck 1
        if ($send($send(%mypendcheck),%myuserpendcheck).file == $send(%mypendcheck).file ) {
          /notice $send(%mypendcheck)   5*** Closing Connection : DCC Timeout ( $+ $xdccget(main ,timeout) Sec Timeout).
          /close -s $+ %myuserpendcheck $send(%mypendcheck)
        goto restart }
    else { goto loopuser } } }    
    if ( $calc($send(0) - %mypendcheck ) > 0 )  { goto loopl }
  if  (%mypendcount == 0 ) { .timercheckpend off } }
else { .timercheckpend off  } }

; *** Server Bandwidth Stats (Served Over ALL / Served Per Session)
alias xdcc.statsbps {
  set -u0 %mysendstatsbps 0
  set -u0 %globalstatsbps 0
  :loopl 
  inc %mysendstatsbps 1
  set -u0 %globalstatsbps  $Round($calc( $send(%mysendstatsbps).cps  + ( %globalstatsbps )),1)
  if ($calc($send(0) - %mysendstatsbps) > 0 )  { goto loopl }
  set -u0 %globalstatsbps  $Round($calc( %globalstatsbps / 1024),1)
  xdccset main Currentbps %globalstatsbps
  if (%globalstatsbps > $xdccget(main,Currentrecord)) { xdccset main Currentrecord $ifmatch } 
if ($xdccget(main,Currentrecord) > $xdccget(main,Allrecord)) { xdccset main Allrecord $ifmatch } }

; *** Server Served Stats Routine (MB, Files, Served Over ALL / Served Per Session, Pack DLs)
alias xdcc.statssrv {
  xdccset main Currentserved $calc($Round($calc(($file($filename).size) / 1024000),1) + $xdccget(main,Currentserved)) 
  xdccset main Allserved $calc($Round($calc(($file($filename).size) / 1024000),1) + $xdccget(main,Allserved))
  xdccset main CurrentDL $calc( 1+ $xdccget(main,CurrentDL)) 
  xdccset main AllDL $calc( 1+ $xdccget(main,AllDL)) 
  set -u0 %Packsent [ $left( [ $nopath($filename) ] , [ $calc( [ $len( [ $nopath($filename) ] ) ] - 4 ) ] ) ]
if  ($istok($xdccget(main,packets),%Packsent,32) == $true )  { xdccset %Packsent  DL $calc( 1+ $xdccget(%Packsent ,DL)) } }

; *** Server Reset Stats (Session or All)
alias xdcc.ResetStats {
  if ( $1 = All ) { xdccset main Allrecord 0.0 | xdccset main Allserved 0.0 | xdccset main AllDL 0 }
  xdccset main Currentrecord 0.0 | xdccset main Currentserved 0.0 | xdccset main CurrentDL 0 | xdcc.init
did -ra xdcc 23  XDCC Server : Server $+ $chr(32) $+ $1 Stats Reset }

; *** Server Channel Play 
alias c.play { xdcc.statsbps
  amsg 5** $$numtok($xdccget(main,packets),32) Packs ** $+ $chr(32) $+ $calc($xdccget(main,mainslots) - $send(0)) of $+ $chr(32) $+ $xdccget(main,mainslots)  slots open ** ALL Time Record $+ $chr(32) $+ $xdccget(main,Allrecord) KB/s **
  amsg 5** Bandwidth Usage ** Current : $+ $chr(32) $+ $xdccget(main,Currentbps) KB/s, Record $xdccget(main,Currentrecord) KB/s **
  amsg 5** To request a file type: "/ctcp $me xdcc send #x" **
  if ( $len($xdccget(main,msg1)) > 0) { /amsg  5^*^ $xdccget(main,msg1) ^*^ } 
  :loopl | inc -u0 %.x.var
  set -u0 %.xl.var $gettok($xdccget(main,packets),%.x.var,32)
  amsg 5 $+ $chr(35) $+ %.x.var $xdccget(%.xl.var,dl) $+ x $chr(91) $+ $xdccget(%.xl.var,size) $+ $chr(93)  $chr(91) $+ %.xl.var $+ $chr(93) $chr(91) $+ $xdccget(%.xl.var,desc) $+ $chr(93)
  if (%.x.var < $numtok($xdccget(main,packets),32)) { goto loopl }
  if ( $len($xdccget(main,msg2)) > 0) { /amsg  5 ^*^ $xdccget(main,msg2) ^*^ }
  if ( $len($xdccget(main,msg3)) > 0) { /amsg  5 ^*^ $xdccget(main,msg3) ^*^ }
amsg 5** Current Served : $+ $chr(32) $+ $xdccget(main,Currentserved) MB ** Total Transferred :  $+ $chr(32) $+ $xdccget(main,Allserved) MB ** }

; *** System MIRC Menu
menu channel,menubar {
  &TuSXdcc
  .Setup Server:xdcc.setup
  .-
  .Offer
  ..Start: .timer361 0 $$?="At what interval (seconds) ?" amsg 5 $+ $me $+ 's xdcc server is now 12enabled5. "4ctcp $me xdcc help5" for help | amsg 5 $+ $me $+ 's xdcc server is now 12enabled5. "4ctcp $me xdcc help5" for help 
  ..Stop: .timer361 off
  .Chan Play
  ..Start: .timerchanplay 0 $$?="At what interval (seconds) ?" c.play # | c.play # | xdccset main chanplay $!
  ..Stop: .timerchanplay off | xdccset main chanplay 0
