;
; TitleBar Pro V0.3
; By DarkHalf    (darkhalf@gamesinferno.com)
; Part of my upcoming IRCraft script    (http://hosted.gamesinferno.com/darkhalf/ircraft)
;

alias _titlebar.winopen {
  if ($dialog(titleedit) == $null) {
    .dialog -mrd titleedit titleedit | halt
    } else {
    .dialog -a titleedit titleedit | halt
  }
}
dialog titleedit {
  size -1 -1 520 395
  list 1,10 30 200 265,vsbar
  list 2,320 30 190 265,vsbar
  button "/\",3,215 65 25 25
  button "^",4,215 100 25 25
  button ">>",5,215 135 25 25
  button "v",6,215 170 25 25
  button "\/",7,215 210 25 25
  button "<<",8,290 135 25 25
  button ">><<",9,245 135 40 25
  button "Close Editor",10,10 365 200 25
  edit "",11,10 310 200 20
  text "Info:",16,10 290 60 20
  edit "",12,320 290 190 20
  text "Name",17,285 290 35 20
  edit "",13,320 315 190 20
  text "Style",18,290 315 30 20
  edit "",14,320 340 190 20
  text "Alias",19,290 340 30 20
  button "Save Changes",15,10 335 200 25
  text "Preview:",23,10 10 50 20
  edit "",24,55 6 455 20
  button "X",20,290 245 25 25
  button "Add Custom Item",21,320 365 190 25
  button "Prefs",25,220 365 90 25
  button "HIDDEN",22,1 1 1 1,cancel,hide
}
alias _titlebar.prefs {
  dialog -m titleprefs titleprefs
}
dialog titleprefs {
  title "TitleBar Pro Prefs"
  size 41 98 255 143
  text "Separator:",1,75 55 70 20,hide
  edit " ",2,135 55 35 20,hide
  text "Update Frequency:",3,35 55 100 20
  edit "2",4,135 55 35 20
  check "Use TitleBar Pro",5,10 5 115 15
  box "Options",6,10 30 235 80
  text "Seconds",7,175 55 50 20
  button "UnLoad",8,165 5 80 20
  button "Save",9,10 115 115 20
  button "Cancel",10,130 115 115 20,cancel
}
on 1:dialog:titleprefs:init:0:{
  dialog -s titleprefs -1 -1 255 143
  if (%titlebar.on) did -c $dname 5
  halt
}
on *:dialog:titleprefs:sclick:5:{
  _titlebar.toggle
} 
on *:dialog:titleprefs:sclick:8:{
  _titlebar.unload
} 
on *:dialog:titleprefs:sclick:9:{
  writeini  $scriptdirtitlebar.ini  Settings Use %titlebar.on 
  if ($did($dname,4) isnum) { %titlebar.freq = $did($dname,4) }
  writeini  $scriptdir/titlebar.ini  Settings Freq %titlebar.freq
  dialog -x $dname
}

alias _titlebar.unload {
  if ($dialog(titleprefs)) { .dialog -x titleprefs }
  if ($dialog(titleedit)) { .dialog -x titleedit }
  .timer.titlebar* off
  unset %titlebar*
  titlebar $chr(32)
  .unload -rs $nopath($script)
}

alias _titlebar.refresh {
  ; work on temp file
  did -r titleedit 1,2

  var %_title.line = 1, %_title.read
  :looptop
  set %_title.read $readini  $scriptdirtitlebar.tmp On %_title.line
  if (%_title.read == $null) { goto end }
  did -a titleedit 1 $gettok(%_title.read,1,200)
  inc %_title.line 1
  goto looptop
  :end

  var %_title.line = 1, %_title.read
  :looptop2
  set %_title.read $readini  $scriptdirtitlebar.tmp  Off %_title.line
  if (%_title.read == $null) { goto end2 }
  did -a titleedit 2 $gettok(%_title.read,1,200)
  inc %_title.line 1
  goto looptop2
  :end2

  _titlebar.preview 
}

alias _titlebar.preview {
  if ($dialog(titleedit).x != $null) {
    did -ra titleedit 24 $_titlebar.text(temp) | return
    } else {
    .timer.titlebar.prev off
  }
}
alias _titlebar.main {
  .titlebar $_titlebar.text
}

alias _titlebar.text {
  var %_title.text
  var %_title.line = 1, %_title.read
  var %_title.file = $iif($1 == temp, $scriptdir/titlebar.tmp, $scriptdir/titlebar.ini)
  :looptop
  var %_title.read $readini -n %_title.file On %_title.line
  if (%_title.read == $null) { goto end }
  var %_val = $gettok(%_title.read,3-,200)
  var %_val = [ [ %_val ] ]
  var %_val2 = $replace($gettok(%_title.read,2,200),&val&,%_val)
  var %_title.text = $addtok(%_title.text,%_val2,32)
  inc %_title.line 1
  goto looptop
  :end
  return %_title.text 
}

alias _titlebar.timer {
  .timer.titlebar.refresh 0 $1 /_titlebar.main
}

; INIT
on *:dialog:titleedit:init:0:{ 
  .dialog -t titleedit TitleBar Pro - By DarkHalf
  .copy -o  $scriptdir/titlebar.ini   $scriptdir/titlebar.tmp  
  .timer.titlebar.prev 0 %titlebar.freq /_titlebar.preview
  ._titlebar.refresh
}

; On Select (Left)
on *:dialog:titleedit:sclick:1:{
  var %_num = $did($dname,1,1).sel
  var %_string = $readini  $scriptdir/titlebar.tmp  On %_num
  var %_info = $gettok(%_string,2-,200)
  did -ra $dname 11 %_info
}

; On Select (Right)
on *:dialog:titleedit:sclick:2:{
  var %_num = $did($dname,2,1).sel
  var %_string = $readini  $scriptdir/titlebar.tmp  Off %_num
  var %_name = $gettok(%_string,1,200)
  var %_style = $gettok(%_string,2,200)
  var %_Alias = $gettok(%_string,3-,200)
  did -ra $dname 12 %_name
  did -ra $dname 13 %_style
  did -ra $dname 14 %_alias
}

; Control Buttons (/\)
on *:dialog:titleedit:sclick:3:{
  if ($did($dname,1,0).sel == 0) { halt | return }
  var %_num = $did($dname,1,1).sel
  if (%_num < 2) { halt | return }

  var %_which = 1
  :looptop
  if (%_which == %_num ) { goto end }
  var %_text = $readini  $scriptdir/titlebar.tmp  On $calc(%_num - %_which)
  .writeini  $scriptdir/titlebar.2  On $calc(%_num - %_which) %_text
  inc %_which 1
  goto looptop
  :end

  var %_to = $readini  $scriptdir/titlebar.tmp  On %_num
  .writeini  $scriptdir/titlebar.tmp  On 1 %_to

  var %_which = 2
  :looptop2
  var %_val2 = $calc(%_which - 1)
  var %_val = $readini  $scriptdir/titlebar.2  On %_val2
  .writeini  $scriptdir/titlebar.tmp  On %_which %_val
  if (%_which == %_num) { goto end2 }
  inc %_which 1
  goto looptop2
  :end2

  _titlebar.refresh
  did -c $dname 3 1

}

; Control Buttons (^)
on *:dialog:titleedit:sclick:4:{
  if ($did($dname,1,0).sel == 0) { halt | return }
  var %_num = $did($dname,1,1).sel
  if (%_num < 2) { halt | return }
  var %_from = $readini  $scriptdir/titlebar.tmp  On %_num
  var %_to = $readini  $scriptdir/titlebar.tmp  On $calc(%_num - 1)
  ;  did -o $dname 1 $calc(%_num - 1) %_from
  ;  did -o $dname 1 %_num %_to
  .writeini  $scriptdir/titlebar.tmp  On $calc(%_num - 1) %_from
  .writeini  $scriptdir/titlebar.tmp  On %_num %_to
  _titlebar.refresh
  did -f $dname 3 $calc(%_num - 1)
}

; Control Buttons (v)
on *:dialog:titleedit:sclick:6:{
  if ($did($dname,1,0).sel == 0) { halt | return }
  var %_num = $did($dname,1,1).sel
  var %_total = $did($dname,1).lines
  if (%_num > $calc(%_total - 1)) { halt | return }
  var %_from = $readini  $scriptdir/titlebar.tmp  On %_num
  var %_to = $readini  $scriptdir/titlebar.tmp  On $calc(%_num + 1)
  ;  did -o $dname 1 $calc(%_num + 1) %_from
  ;  did -o $dname 1 %_num %_to
  .writeini  $scriptdir/titlebar.tmp  On $calc(%_num + 1) %_from
  .writeini  $scriptdir/titlebar.tmp  On %_num %_to
  _titlebar.refresh
  did -f $dname 3 $calc(%_num + 1)
}

; Control Buttons (\/)
on *:dialog:titleedit:sclick:7:{
  if ($did($dname,1,0).sel == 0) { halt | return }
  var %_num = $did($dname,1,1).sel
  var %_total = $did($dname,1).lines
  if (%_num => %_total) { halt | return }

  var %_which = $calc(%_num + 1)
  :looptop
  var %_text = $readini  $scriptdir/titlebar.tmp  On $calc(%_which)
  .writeini  $scriptdir/titlebar.2  On $calc(%_which - 1) %_text
  if (%_which == %_total ) { goto end }
  inc %_which 1
  goto looptop
  :end

  var %_to = $readini  $scriptdir/titlebar.tmp  On %_num
  .writeini  $scriptdir/titlebar.tmp  On %_total %_to

  var %_which = $calc(%_total - 1)
  :looptop2
  ;  var %_val2 = $calc(%_total - %_which)
  var %_text = $readini  $scriptdir/titlebar.2  On %_which
  .writeini  $scriptdir/titlebar.tmp  On %_which %_text
  if (%_which == %_num) { goto end2 }
  dec %_which 1
  goto looptop2
  :end2

  _titlebar.refresh
  did -f $dname 3 $calc(%_num - 1)
}


; Control Buttons (>>)
on *:dialog:titleedit:sclick:5:{
  if ($did($dname,1,0).sel == 0) { halt | return }
  var %_num = $did($dname,1,1).sel
  var %_total = $did($dname,1).lines
  var %_rtotal = $did($dname,2).lines

  if (%_num = %_total) {
    var %_to = $readini  $scriptdir/titlebar.tmp  On %_num
    .writeini  $scriptdir/titlebar.tmp  Off $calc(%_rtotal + 1) %_to
    goto end2
  }

  var %_which = $calc(%_num + 1)
  :looptop
  var %_text = $readini  $scriptdir/titlebar.tmp  On $calc(%_which)
  .writeini  $scriptdir/titlebar.2  On $calc(%_which - 1) %_text
  if (%_which == %_total ) { goto end }
  inc %_which 1
  goto looptop
  :end

  var %_to = $readini  $scriptdir/titlebar.tmp  On %_num
  .writeini  $scriptdir/titlebar.tmp  Off $calc(%_rtotal + 1) %_to

  var %_which = $calc(%_total - 1)
  :looptop2
  ;  var %_val2 = $calc(%_total - %_which)
  var %_text = $readini  $scriptdir/titlebar.2  On %_which
  .writeini  $scriptdir/titlebar.tmp  On %_which %_text
  if (%_which == %_num) { goto end2 }
  dec %_which 1
  goto looptop2
  :end2

  .remini  $scriptdir/titlebar.tmp  On %_total  

  _titlebar.refresh
  did -f $dname 3 $calc(%_num - 1)
}

; Control Buttons (>><<)
on *:dialog:titleedit:sclick:9:{
  if ($did($dname,1,0).sel == 0) { halt | return }
  if ($did($dname,2,0).sel == 0) { halt | return }
  var %_num = $did($dname,1,1).sel
  var %_rnum = $did($dname,2,1).sel

  var %_left = $readini  $scriptdir/titlebar.tmp  On %_num
  var %_right = $readini  $scriptdir/titlebar.tmp  Off %_rnum

  .writeini  $scriptdir/titlebar.tmp  On %_num %_right
  .writeini  $scriptdir/titlebar.tmp  Off %_rnum %_left

  _titlebar.refresh
  did -f $dname 3 $calc(%num - 1)
}

; Control Buttons (<<)
on *:dialog:titleedit:sclick:8:{
  if ($did($dname,2,0).sel == 0) { halt | return }
  var %_rnum = $did($dname,2,1).sel
  var %_total = $did($dname,1).lines
  var %_rtotal = $did($dname,2).lines

  if (%_rnum = %_rtotal) {
    var %_to = $readini  $scriptdir/titlebar.tmp  Off %_rtotal
    .writeini  $scriptdir/titlebar.tmp  On $calc(%_total + 1) %_to
    goto end2
  }

  var %_which = $calc(%_rnum + 1)
  :looptop
  var %_text = $readini  $scriptdir/titlebar.tmp  Off $calc(%_which)
  .writeini  $scriptdir/titlebar.2  Off $calc(%_which - 1) %_text
  if (%_which == %_rtotal ) { goto end }
  inc %_which 1
  goto looptop
  :end

  var %_to = $readini  $scriptdir/titlebar.tmp  Off %_rnum
  .writeini  $scriptdir/titlebar.tmp  On $calc(%_total + 1) %_to

  var %_which = $calc(%_rtotal - 1)
  :looptop2
  ;  var %_val2 = $calc(%_rtotal - %_which)
  var %_text = $readini  $scriptdir/titlebar.2  Off %_which
  .writeini  $scriptdir/titlebar.tmp  Off %_which %_text
  if (%_which == %_rnum) { goto end2 }
  dec %_which 1
  goto looptop2
  :end2
  .remini  $scriptdir/titlebar.tmp  Off %_rtotal

  :end3

  _titlebar.refresh
  did -f $dname 3 $calc(%_rnum - 1)
}

; Control Buttons (X)
on *:dialog:titleedit:sclick:20:{
  if ($did($dname,2,0).sel == 0) { halt | return }
  var %_rnum = $did($dname,2,1).sel
  var %_rtotal = $did($dname,2).lines

  if (%_rnum = %_rtotal) {
    .remini  $scriptdir/titlebar.tmp  Off %_rtotal
    goto end3
  }

  var %_which = $calc(%_rnum + 1)
  :looptop
  var %_text = $readini  $scriptdir/titlebar.tmp  Off $calc(%_which)
  .writeini  $scriptdir/titlebar.2  Off $calc(%_which - 1) %_text
  if (%_which == %_rtotal ) { goto end }
  inc %_which 1
  goto looptop
  :end

  var %_which = $calc(%_rtotal - 1)
  :looptop2
  ;  var %_val2 = $calc(%_rtotal - %_which)
  var %_text = $readini  $scriptdir/titlebar.2  Off %_which
  .writeini  $scriptdir/titlebar.tmp  Off %_which %_text
  if (%_which == %_rnum) { goto end2 }
  dec %_which 1
  goto looptop2
  :end2

  .remini  $scriptdir/titlebar.tmp  Off %_rtotal  

  :end3

  _titlebar.refresh
  did -f $dname 3 $calc(%_rnum - 1)
}

; Add Custom Item
on *:dialog:titleedit:sclick:21:{
  if ($did($dname,12).text == $null) { halt | return }
  if ($did($dname,13).text == $null) { halt | return }
  if ($did($dname,14).text == $null) { halt | return }
  var %_rtotal = $did($dname,2).lines
  var %_val = $addtok(%_val,$did($dname,12).text,200)
  var %_val = $addtok(%_val,$did($dname,13).text,200)
  var %_val = $addtok(%_val,$did($dname,14).text,200)
  .writeini  $scriptdir/titlebar.tmp  Off $calc(%_rtotal + 1) %_val
  _titlebar.refresh
}

; Prefs Button
on *:dialog:titleedit:sclick:25:{
  _titlebar.prefs
}

; Save Changes
on *:dialog:titleedit:sclick:15:{
  .copy -o  $scriptdir/titlebar.tmp   $scriptdir/titlebar.ini  
}

; Close Editor
on *:dialog:titleedit:sclick:10:{
  .dialog -c $dname
  .remove  $scriptdirtitlebar.tmp  
  .remove  $scriptdirtitlebar.2  
}

alias _titlebar.close {
  if (%_titlebar.save != cancel) { _titlebar.save 
    .dialog -c $dname | return
    } else {
    .remove  $scriptdir/titlebar.tmp  
    .remove  $scriptdir/titlebar.2  
  }
}

alias _titlebar.add {
  tokenize 47 $1-
  var %_title.line = 1, %_title.read
  :looptop2
  set %_title.read $readini  $scriptdir/titlebar.tmp  Off %_title.line
  if (%_title.read == $null) { goto end2 }
  inc %_title.line 1
  goto looptop2
  :end2

  var %_rtotal = %_title.line
  var %_val = $addtok(%_val,$1,200)
  var %_val = $addtok(%_val,$2,200)
  var %_val = $addtok(%_val,$3-,200)
  .writeini  $scriptdir/titlebar.ini  Off %_rtotal %_val
  .writeini  $scriptdir/titlebar.ini  Off $calc(%_rtotal +1) $null
}

alias _titlebar.toggle {
  titlebar $chr(32)
  %titlebar.on = $calc(1 - %titlebar.on)
  if (%titlebar.on == 0) { .timer.titlebar* off }
  if (%titlebar.on == 1) { _titlebar.timer %titlebar.freq }
}

menu menubar {
  TitleBar Pro
  .Active $iif(%titlebar.on,):{ 
    _titlebar.toggle
  }
  .Edit:._titlebar.winopen
  .UnLoad:{ if ($?!="Are you sure you want to unload TitleBar Pro?") { _titlebar.unload } }
}

alias _titlebar.onstart {
  set %titlebar.on $readini  $scriptdir/titlebar.ini  Settings Use
  if (%titlebar.on == $null) { %titlebar.on = 0 | writeini  $scriptdir/titlebar.ini  Settings Use %titlebar.on }
  set %titlebar.sep $readini  $scriptdir/titlebar.ini  Settings Sep
  if (%titlebar.sep == $null) { %titlebar.sep = 32 | writeini  $scriptdir/titlebar.ini  Settings Sep %titlebar.sep }
  set %titlebar.freq $readini  $scriptdir/titlebar.ini  Settings Freq
  if (%titlebar.freq == $null) { %titlebar.freq = 2 | writeini  $scriptdir/titlebar.ini  Settings Freq %titlebar.freq }
  if (%titlebar.on != 0) { 
    _titlebar.timer %titlebar.freq
  }
}

on *:start:{
  _titlebar.onstart
}

alias _uptime.update { if ($calc($ticks / 1000) >= %uptime.record) { set %uptime.record $calc($ticks / 1000) } }
alias _uptime { ._uptime.update | return $duration($calc($ticks / 1000)) }
alias _uptime.record { ._uptime.update | return $duration(%uptime.record) }
alias _uptime.timer { timer.uptime 0 120 /_uptime.update }
alias _diskfree { 
  var %_totalspace = $round($calc(($disk(c:).free + $disk(d:).free + $disk(e:).free ) / 1024 / 1024),2)
  var %_measure = MB
  if (%_totalspace >= 500) { %_measure = GB | %_totalspace = $round($calc(%_totalspace / 1024),2) }
  return %_totalspace %_measure
}
alias _host { if ($host == $null) { return Unknown } | else return $host }
alias _network { if ($network == $null) { return Current } | else return $network }
alias _server { if ($server == $null) { return None } | else return $server }

ctcp *:VERSION:*:{ if (%titlebar.on) { .notice $nick TitleBar Pro By DarkHalf } }
