;**** Date: 10-18-2000
;**** Programmer: JQ (jq9@hotmail.com)
;**** Purpose: A team trivia bot.  This is modified from the Jotrivia bot addon.
;****          Converted to a team trivia bot addon and fixed minor bugs and annoyances.
;****

;******************************************************************************
;**** Events
;******************************************************************************

on 1:JOIN:%trivchan:{
  if (%advertisett = Disable) {
    if ($me != %botop) || (%triv.status = Enable) halt
    if ($nick != $me) {
      if (%trivia = off)   .notice $nick Welcome $nick $+ . Team trivia is currently off, to start game type !trivon
      else .notice $nick Welcome $nick $+ .
    }
    .notice $nick Type !help for a list of team trivia commands
  }
}

on 1:START:{
  set %triv.status Enable
  set %trivia off
  set %inquestion no
  set %flagtrivoff yes
  set %trivchan $null
  set %advertisett Enable
  set %questiontime 20
  unset.ttvars
}

on 1:TEXT:!help:%trivchan:{
  if ($me != %botop) || (%triv.status = Enable) halt
  showhelp $nick
}

on 1:TEXT:!repeat:%trivchan:{
  if ($me != %botop) halt
  if (%inquestion = yes) msg %trivchan 2Question: 12 %question
}

on 1:TEXT:!hint:%trivchan: {
  if ($me != %botop) halt
  if (%trivia = on) {
    if (%inquestion = yes) {
      if ($istok(%blue.team,$nick,44)) || ($istok(%red.team,$nick,44)) userhint
    }
    else {
      .notice $nick Can't give hint now, question has ended
    }
  }
}

on 1:TEXT:!trivon*:%trivchan: {
  if ($me != %botop) || (%triv.status = Enable) halt
  if (%trivia = off) {
    if (($2 != $null) && ($2 isnum)) %num.quest = $2
    else %num.quest = 10
    %red.team = ""
    %blue.team = ""
    %red.score = 0
    %blue.score = 0
    %trivia = on
    msg %trivchan 1Team trivia starts in 1 minute, type 2!join blue 1or 4!join red 1to join a team
    .timerstart 1 60 trivon
  }
}

on 1:TEXT:!trivoff:%trivchan: {
  if ($me != %botop) halt
  if (%trivia = on) {
    %flagtrivoff = yes
    if (%inquestion == yes) msg %trivchan Trivia will be disabled after question.
    else trivoff
  }
}

on 1:TEXT:!join*:%trivchan:{
  if (%trivia = on) join.team $1-
}

on 1:TEXT:!teams:%trivchan:{
  if ($me != %botop) halt
  if (%trivia = on) display.teams
}

on 1:TEXT:!score:%trivchan:{
  if ($me != %botop) halt
  if (%trivia = on) show.score
}

on 1:TEXT:!timer*:%trivchan:{
  if ($me != %botop) halt
  if (($2 != $null) && ($2 isnum)) {
    if ($istok(%blue.team,$nick,44)) || ($istok(%red.team,$nick,44)) {
      %questiontime = $2
      /msg %trivchan Time between questions has been set to %questiontime seconds
    }
  }
}

on 1:NICK:{
  if %trivia = on) {
    if ($istok(%blue.team,$nick,44)) {
      %blue.team = $reptok(%blue.team,$nick,$newnick,1,44)
    }
    if ($istok(%red.team,$nick,44)) {
      %red.team = $reptok(%red.team,$nick,$newnick,1,44)
    }
  }
}

on 1:TEXT:*:%trivchan:{
  if ($me != %botop) halt
  if (%trivia = on) && (%inquestion = yes) {
    if ($istok(%blue.team,$nick,44)) || ($istok(%red.team,$nick,44)) {
      parsetry $1-
    }
  }
}

;******************************************************************************
;**** Aliases
;******************************************************************************

alias display.teams {
  /var %b = $numtok(%blue.team,44)
  /var %r = $numtok(%red.team,44)
  /var %n = 2
  /var %blue.names
  /var %red.names

  %blue.names = $gettok(%blue.team,1,44)
  if (%b > 1) {
    :blueloop
    if (%n = %b) %blue.names = %blue.names $+ $chr(44) $+ $chr(32) and $gettok(%blue.team,%n,44)
    else %blue.names = %blue.names $+ $chr(44) $+ $chr(32) $gettok(%blue.team,%n,44)
    inc %n
    if (%n <= %b) goto blueloop
  }
  msg %trivchan 2Blue Team: 1 %blue.names
  %n = 2
  %red.names = $gettok(%red.team,1,44)
  if (%r > 1) {
    :redloop
    if (%n = %r) %red.names = %red.names $+ $chr(44) $+ $chr(32) and $gettok(%red.team,%n,44)
    else %red.names = %red.names $+ $chr(44) $+ $chr(32) $gettok(%red.team,%n,44)
    inc %n
    if (%n <= %r) goto redloop
  }
  msg %trivchan 4Red Team : 1 %red.names
}

alias show.score {
  msg %trivchan 2Blue Team: 1 %blue.score
  msg %trivchan 4Red Team : 1 %red.score
}

alias join.team {
  if ($2 == blue) {
    if ($istok(%red.team,$nick,44)) {
      %red.team = $remtok(%red.team,$nick,1,44)
      .msg $nick 1You have been removed from the 4red 1team.
    }
    %blue.team = $addtok(%blue.team,$nick,44)
    .msg $nick 1You have been added to the 2blue 1team.
  }
  if ($2 == red) {
    if ($istok(%blue.team,$nick,44)) {
      %blue.team = $remtok(%blue.team,$nick,1,44)
      .msg $nick 1You have been removed from the 2blue 1team.
    }
    %red.team = $addtok(%red.team,$nick,44)
    .msg $nick 1You have been added to the 4red 1team.
  }
}

alias newquestion {
  .timerhint off
  .timerkill off
  .timernextquestion off
  unset %question
  unset %answer
  unset %lenans
  getquestionnum
  %mystr = $read -l $+ %goodline $scriptdir $+ q.txt
  unset %visible.char
  parsequestion
  showanswer Answer: 
  .timerhint 3 15 timehint
  .timerkill 1 60 killquestion
  %timehintcount = 0
  %inquestion = yes
}

alias parsequestion {
  /var %n = 1
  /var %lenstr = $len(%mystr)
  /var %myans = $replace(%mystr,$chr(32),$chr(160))
  :splitloop
  if ($mid(%mystr,%n,1) != |) {
    inc %n
    if (%n < %lenstr) goto splitloop
  }
  if (%n == %lenstr) || (%mystr == $null) {
    echo -a 2**2*12* 1Question file corrupt. Line = %mystr
    /write $scriptdir $+ corrupt.txt %goodline - %mystr
    inc %numcorrupt
    if (%numcorrupt < 5) newquestion
    else {
      msg %trivchan Trivia question file is corrupt. Exiting.
      trivoff
    }
    halt
  }
  set %answer  $mid(%myans,$calc(%n + 1),$calc(%lenstr - %n))
  %lenans = $len(%answer)
  set %question $left(%mystr,$calc(%n - 1))
  showquestion
}

alias showquestion  msg %trivchan 2Question: 12 %question

alias showanswer {
  /var %n = 1
  /var %l
  /var %ans
  :ansloop
  set %l $mid(%answer,%n,1)
  if (%l isalnum) &&  ($istok(%visible.char,%n,46) == $false) %l = *
  set %ans %ans $+ %l
  inc %n
  if (%n <= %lenans) goto ansloop
  if (%previous.ans != %ans) msg %trivchan 2 $+ $1- 12 %ans
  %previous.ans = %ans
}

alias parsetry {
  /var %n = 1
  /var %try = $replace($1-,$chr(32),$chr(160))
  /var %lentry = $len(%try)
  /var %toklist
  if (%try == %answer) {
    msg %trivchan 1Correct answer by $nick :7 %answer
    if ($istok(%blue.team,$nick,44)) %blue.score = %blue.score + 1
    if ($istok(%red.team,$nick,44)) %red.score = %red.score + 1
    if (%blue.score = %num.quest) {
      msg %trivchan 7Blue team wins %blue.score to %red.score
      trivoff
    }
    if (%red.score = %num.quest) {
      msg %trivchan 7Red team wins %red.score to %blue.score
      trivoff
    }
    show.score
    %misses = 0
    pausenew
    halt
  }
  if (%lenans < %lentry) set %lentry %lenans
  :compareloop
  if ($mid(%answer,%n,1) == $mid(%try,%n,1)) {
    %visible.char = $addtok(%visible.char,%n,46)
  }
  inc %n
  if (%n <= %lentry) goto compareloop
  showanswer Answer:
}

alias userhint {
  /var %threecount = 1
  /var %n = 1
  /var %l
  if ($istok(%visible.char,hint,46) == $false) {
    %visible.char = $addtok(%visible.char,hint,46)
    :hintloop
    %l = $mid(%answer,%n,1)
    if ($istok(%visible.char,%n,46) == $false) && (%l isalnum) {
      %visible.char = $addtok(%visible.char,%n,46)
      inc %threecount
    }
    inc %n
    if (%n <= %lenans) && (%threecount <= 3) goto hintloop
    showanswer Hint:
  }
}

alias timehint {
  /var %n
  /var %l
  %timehintcount = $calc(%timehintcount + 15)
  %n = 1
  :timehintsubloop
  %l = $mid(%answer,%n,1)
  if ($istok(%visible.char,%n,46) == $false) && (%l isalnum) {
    %visible.char = $addtok(%visible.char,%n,46)
  }
  else {
    inc %n
    if (%n <= %lenans) goto timehintsubloop
  }
  showanswer %timehintcount Second Hint:
}


alias killquestion {
  msg %trivchan Time's up! The answer is: %answer
  show.score
  inc %misses
  pausenew
}

alias pausenew {
  %inquestion = no
  .timerhint off
  .timerkill off
  if (%misses > 9) {
    %flagtrivoff = yes
    msg %trivchan 10 misses in a row. Disabling Trivia
  }
  if (%flagtrivoff == yes) trivoff
  else {
    .timernextquestion 0 %questiontime newquestion
    msg %trivchan Next question in %questiontime seconds
  }
}

alias trivoff {
  %trivia = off
  %inquestion = no
  unset.ttvars
  .timerstart off
  .timerhint off
  .timerkill off
  .timernextquestion off
  if (%triv.status  != Enable) msg %trivchan Trivia disabled. Use !trivon to restart Trivia
  halt
}

alias trivon {
  /var %questionpath = $scriptdir $+ q.txt
  %trivia = on
  %flagtrivoff = no
  %misses = 0
  if ($exists(%questionpath) == $false) {
    msg %trivchan 2**2*12* 1Cannot run, question file is not present,
    %triv.status  = Enable
    trivoff 
    halt
  }
  %numquestions = $read -l0 $scriptdir $+ q.txt
  if (%numquestions == 0) {
    echo -a 2**2*12* 1Question file format incorrect
    halt
  }
  msg %trivchan Team Trivia Is Starting
  newquestion
}

alias getquestionnum {
  /var %templine
  /var %usednumsfile = $scriptdir $+ usednums.txt
  %goodline = $rand(1,%numquestions)
  if ($lines(%usednumsfile) >= %numquestions) || ($exists(%usednumsfile) == $false) {
    %goodline = $rand(1,%numquestions)
    echo -a 2**2*12* 1New numsfile
    /write -c $scriptdir $+ usednums.txt %goodline $+ .
  }
  else {
    :templineloop
    %templine = $read -s $+ %goodline $+ . $scriptdir $+ usednums.txt
    if (%templine != $null) {
      inc %goodline
      if (%goodline > %numquestions) %goodline = 1
      goto templineloop
    }
    /write $scriptdir $+ usednums.txt %goodline $+ .
  }
}

alias checkcorrupt {
  /var %n = 1
  /var %nq = $read -l0 $scriptdir $+ q.txt
  /var %ts
  /var %i
  echo -a 2**2*12* 1Scanning - may take awhile
  echo -a 2**2*12* 1Total questions - %nq
  :checkcorruptloop
  %ts = $read -l $+ %n $scriptdir $+ q.txt
  if (%ts == $null) echo -a 2**2*12* 1Line %n is empty
  else {
    if (| !isin %ts) || ($right(%ts,1) == |) echo -a 2**2*12* 1Invalid format line %n : %ts
  }
  inc %n
  %i = $calc(%n / 100)
  if (%i == $int(%i)) echo -a 2**2*12* 1Scanned %n questions
  if (%nq > %n) goto checkcorruptloop
  echo -a 2**2*12* 1Scan complete
}

alias showhelp {
  .msg $1 5!trivon <# of questions> 1- activates the trivia bot if it is not already running.
  .msg $1 1<# of questions> defaults to 10 if not specified.
  .msg $1 5!trivoff 1- turns off the trivia bot if it is running.
  .msg $1 5!hint 1- displays a three letter hint to the channel. 
  .msg $1 5!repeat 1- will redisplay the current question.
  .msg $1 5!join blue 1- join the blue team.
  .msg $1 5!join red 1- join the red team.
  .msg $1 5!teams 1- displays the members of each team.
  .msg $1 5!score 1- displays the current team scores.
  .msg $1 5!timer <# of seconds> 1- sets the number of seconds between questions
  .msg $1 12-------------------------2---------------------10------------------14---------------15------------
  .msg $1 To answer a question, simply type the answer in the channel window.
  .msg $1 You must join a team for the bot to recognize your answers.
  .msg $1 Answers are not case sensitive.
}

alias init {
  /var %first.char = ""
  .timerhint off
  .timerkill off
  .timernextquestion off
  %botop = $me
  %trivia = off
  %inquestion = no
  %flagtrivoff = no
  if ($1 == $null) %trivchan = $?="What channel will the bot run in?"
  else %trivchan = $1
  %first.char = $mid(%trivchan,1,1)
  if (%first.char != $chr(35)) %trivchan = $chr(35) $+ %trivchan
  if ($2 isnum) %questiontime = $2
  else %questiontime = $?="How many seconds to wait between questions?"
  if (%triv.status == Enable) echo -a 2**2*12* 1Join %trivchan and set bot to enable to allow game play.
  else echo -a 2**2*12* 1Join %trivchan to allow game play.
  %previous.ans = ""
}

alias unset.ttvars {
  unset %red.team
  unset %blue.team
  unset %red.score
  unset %blue.score
  unset %question
  unset %answer
  unset %lenans
  unset %mystr
  unset %goodline
  unset %visible.char
  unset %timehintcount
  unset %ans
  unset %misses
  unset %num.quest
  unset %numquestions
  unset %previous.ans
  unset %numcorrupt 
}

alias trivia.status {
  if (%triv.status == Enable) {
    if (%trivchan == $null) init $active %questiontime
    %triv.status = Disable
    echo -a 2**2*12* 1Team trivia is now enabled.
  }
  else {
    %triv.status = Enable
    unset.ttvars
    if (%trivia = on) trivoff
    echo -a 2**2*12* 1Team trivia is now disabled.
  }
}

alias ad.status {
  if (%advertisett = Enable) {
    if (%trivchan == $null) init $active %questiontime
    %advertisett = Disable
    echo -a 2**2*12* 1Team trivia advertisements are now enabled.
  }
  else {
    %advertisett = Enable
    echo -a 2**2*12* 1Team trivia advertisements are now disabled.
  }
}

;******************************************************************************
;**** Menus
;******************************************************************************

menu channel {
  Team Trivia
  .%triv.status team trivia bot:trivia.status
  .%advertisett advertisements:ad.status
  .Initialize bot for $active:init $active %questiontime
  .-
  .Scan question file:checkcorrupt
}
