; +--------------------------------------+
; | Tanks by Andy Dufilie (^Andy@ircnet) |
; | made for use with mIRC32 v5.7+       |
; | email: a_s_d@snet.net                |
; | http://come.to/andys.site/   or      |
; | http://pages.cthome.net/pdufilie/    |
; +--------------------------------------+
;
; put all the files into the same directory
; and type this in any mIRC window: /load -rs c:\mirc\tanks\tanks.mrc
;   (replace "c:\mirc\tanks\" with the directory the files are in.)
;
; then type "/tanks <nick>" to start the game with another person,
; or type "/tanks" to play against the computer.
; 
; Note:  Tanks was made and tested using an AMD 350mhz cpu,
;        it might run too slowly on some machines.
;
alias tanksversion var %v 0.939 | $iif($1,$u,n) %v | $u Tanks v $+ %v
alias -l mirc $u 5.7
on *:load:{
  if $version < $mirc {
    e $tanksversion requires mIRC v $+ $mirc or higher. Get it from $hl(www.mirc.com)
    if $?!="You need mIRC v $+ $mirc to use Tanks." {
      i run http://www.mirc.com/
    }
    unload -rs " $+ $script $+ "
  }
  e $tanksversion loaded. To start a game, type "/tanks" or "/tanks <nick>".
}
alias -l e echo $colour(info) -at  $1-
on *:start:end
alias tankscmd $1-
alias tanks {
  $iif($isid,$u,n) [ $ [ $+ [ $1- ] ] ]
  if $playing { $iif($?!="Cancel current game of Tanks?",cancel,$u) }
  var %b tanksr.bmp tanksb.bmp tanks.bmp,%x 3,%f
  while (%x) {
    %f = $scriptdir $+ $gettok(%b,%x,32)
    if $n($isfile(%f)) { e Tanks file missing: " $+ $nopath(%f) $+ "; download Tanks from $hl($hp) or type ' $+ $hl(/downloadtanks) $+ ' | $u }
    dec %x
  }
  $nodl
  drawpic -c
  end
  new
  t c 1
  checktanksversion
  inf
  if $n($1) || $1 == $me {
    player 0 $rand(1,2)
    $u
  }
  t player $1
  request
}
alias -l player {
  t turn $2
  if $1 == 1 {
    t player.1 0
    t player.2 $v(player)
  }
  elseif $1 == 2 {
    t player.1 $v(player)
    t player.2 0
  }
  else {
    t player .AI.
    t player.1 0
    t player.2 .AI.
  }
  color.pause
}
alias -l end {
  d
  dis *
  .unset %tanks.*
}
alias -l playing $u $iif($v(player) && $window($w) && $v(rounds),1)
alias -l u return return
alias -l en .enable #tanks. $+ $1
alias -l dis .disable #tanks. $+ $1
alias -l gr $u $group(#tanks. [ $+ [ $1 ] ] )
alias -l hl $u  $+ $colour(h) $+ $1- $+ 
alias -l h haltdef
alias -l no if $isid { $u .!notice $$1 tanks } | .!notice $v(player) tanks $1-
alias -l i .timer -o 1 0 $1-
alias -l v $u % [ $+ tanks. $+ [ $replace($1-,$chr(32),$chr(46)) ] ]
alias -l t % [ $+ tanks. $+ [ $1 ] ] = $2-
alias -l tc t $1 $+ . $+ $v(turn) $2-
alias -l tdec t $1 $calc($v($1)-$2)
alias -l tinc t $1 $calc($v($1)+$2)
alias -l n $u $iif($1-,$chr(32),1)
alias -l _rgb $u FFF 000 800 080 00F 008 808 08F 666 0F0 880 FF0 F00 F0F 888 DDD
alias -l rgb_ $u 16777215 0 8388608 32768 255 128 8388736 33023 6316128 65280 8421376 16776960 16711680 16711935 8421504 13684944
alias -l echorgb {
  tokenize 32 $rgb_
  var %x
  while ($1 != $null) {
    %x = %x $base($1,10,16,6)
    tokenize 32 $2-
  }
  e %x
}
alias -l c $u $gettok($rgb_,$calc(1+$1),32)
alias -l fc var %h = $base($getdot($w,$1,$2),10,16,6), %h = $mid(%h,1,1) $+ $mid(%h,3,1) $+ $mid(%h,5,1) | $u $calc($findtok($_rgb,%h,1,32)-1)
alias -l w $u @Tanks
alias -l fx $u fixedsys -9
alias -l mx $u $click($iif($1,$rq,$w),$click($iif($1,$rq,$w),0)).x
alias -l my $u $click($iif($1,$rq,$w),$click($iif($1,$rq,$w),0)).y
alias -l line drawline -rn $w $c($1) 1 $2-
alias -l fill drawfill -srn $w $c($1) $getdot($w,$2,$3) $2-
alias -l cmsg ctext 1 $int($calc(($xmax -$wid($1-))/2)) 4 $1-
alias -l text drawtext -rbn $w $c($1) $c($2) $fx $3-
alias -l ctext drawtext -rn $w $c($1) $fx $2-
alias -l rtext drawtext -rbn $rq $c($1) $c($2) $fx $3-
alias -l orect drawrect -ri $w $c($1) 1 $2-
alias -l circle drawrect -erfn $w $c($1) 1 $calc($3 -$2) $calc($4 -$2) $calc(1+2*$2) $calc(1+2*$2)
alias -l rect drawrect -rfn $w $c($1) 1 $2-
alias -l rrect drawrect -rfn $rq $c($1) 1 $2-
alias -l d $iif($window($iif($1,$rq,$w)),drawdot,n) $iif($1,$rq,$w)

;          line c x y x y
;          fill c x y
;          text c c x y t
;rq       rtext c c x y t
;no bg    ctext c x y t
;        circle c r x y
;          rect c x y w h
;rq       rrect c x y w h

alias -l colorok $u $iif($1 != $v(color.1) && $1 != $v(color.2) && $1 != $color.sky && $1 != $color.ground && $istok(2 3 5 6 8 10,$1,32),1)
alias -l max $u $iif($1 > $2,$1,$2)
alias -l min $u $iif($1 < $2,$1,$2)
alias -l num $u $max($1,$min($2,$3))
alias -l current $u $iif(-* iswm $1,$v($right($1,-1),$calc(3-$v(turn))),$v($1,$v(turn)))

alias -l request {
  if $n($server) {
    e Tanks: not connected to server
    end
    $u
  }
  en outgoing.request
  no request $tanksversion(1)
  inf
  text 0 2 8 74 Asked $v(player) to play
  d
}
#tanks.outgoing.request off
on ^*:notice:tanks *:*:{
  if $nick == $v(player) {
    dis outgoing.request
    inf
    if $2 == accept {
      t address $mask($fulladdress,0)
      text 9 2 8 74 $v(player) accepted
      d
      player $3-
    }
    elseif $istok(old new,$2,32) {
      text 4 2 8 74 $nick has $iif($2 == old,an,a) $2 $+ er version of Tanks
      tb You need identical versions to play
      end
    }
    elseif $istok(decline busy,$2,32) {
      text 4 2 8 74 $nick $replace($2,decline,declined,busy,already had a game in progress)
      end
    }
    elseif $2 == installing {
      text 4 2 8 74 $nick is busy installing the newest version
      end
    }
  }
  h
}
#tanks.outgoing.request end

on ^*:notice:tanks request *:*:{
  var %e e $nick wants to play a game of Tanks $+ $chr(44) but,%r $no($nick)
  if $tanksversion(1) < $3 {
    %e you have an older version.  Get the newest by typing ' $+ $hl(/tanks) $+ ' and clicking on the $hl([install newest version]) button.
    %r old
  }
  elseif $tanksversion(1) > $3 {
    %e they have an older version.
    %r new
  }
  elseif $nodl {
    %e Tanks is busy installing the newest version right now.
    %r installing
  }
  elseif $playing {
    %e you already have one in progress.
    %r busy
  }
  else {
    t player $nick
    t address $mask($fulladdress,0)
    var %q Will you play a game of Tanks with $v(player) $+ ?
    window -dfkp +tf $rq -1 -1 $calc($wid(%q) + 16) 47 $fx
    rrect 1 0 0 $calc($wid(%q)+16) 47
    rtext 15 1 8 8 %q
    hlrq
    en incoming.request
  }
  h
}
alias -l rq $u @Tanksrequest
alias -l hlrq {
  rtext $iif($inrect($mouse.x,$mouse.y,16,24,39,15),0 12,15 2) 16 24 [Yes]
  rtext $iif($inrect($mouse.x,$mouse.y,64,24,31,15),0 12,15 2) 64 24 [No]
  d 1
}
#tanks.incoming.request off
on ^*:close:@tanksrequest:{
  no decline
  dis incoming.request
}
menu @tanksrequest {
  mouse:hlrq
  leave:hlrq
  sclick:{
    if $inrect($mx(1),$my(1),16,24,39,15) {
      window -c $rq
      dis incoming.request
      var %p = $rand(1,2), %t = $rand(1,2)
      no accept $calc(3-%p) %t
      new
      inf
      player %p %t
    }
    elseif $inrect($mx(1),$my(1),64,24,31,15) {
      window -c $rq
      dis incoming.request
      no decline
    }
  }
}
#tanks.incoming.request end

on ^*:notice:tanks cancel:*:{
  if [ $v(address) ] iswm $fulladdress {
    window -c $rq
    if $window($w) && $gr(color.wait) $gr(color.buttons) $gr(terrain) == off off off {
      tb Score: $v(wins.1) to $v(wins.2)
      cmsg Game Cancelled
    }
    else {
      window -c $w
      e $v(player) cancelled the game.
    }
    end
  }
  h
}
on ^*:nick:{
  if $nick == $v(player) {
    t player $newnick
  }
  if $nick == $v(player.1) {
    t player.1 $newnick
  }
  if $nick == $v(player.2) {
    t player.2 $newnick
  }
  if $nick == $me || $newnick == $me && $noai {
    no nick $nick $newnick
  }
  tb
}
on ^*:notice:tanks nick *:*:{
  if [ $v(address) ] iswm $fulladdress {
    if $3 == $v(player) {
      t player $4
    }
    if $3 == $v(player.1) {
      t player.1 $4
    }
    if $3 == $v(player.2) {
      t player.2 $4
    }
    tb
  }
  h
}
on ^*:close:@tanks:cancel
alias -l cancel if $wins < $v(rounds) && $noai { no cancel } | end
alias -l cl window -dfkp +tf $w $window($w).x $window($w).y $calc(1+$xmax) $calc(1+$ymax) $fx | rect $1 0 0 $calc(1+$xmax) $calc(1+$ymax)
alias -l inf cl 1 | text 15 1 4 4 $tanksversion for mIRC v $+ $mirc | text 15 1 4 20 by Andy Dufilie (^Andy@ircnet) | text 15 1 4 36 e-mail: | text 15 1 4 52 website: | hltb
alias -l xmax $u 320
alias -l ymax $u 320
alias -l wid $u $width($1-,fixedsys,9,0,0)
alias -l color.missile $u 1
alias -l color.ground $u 14
alias -l color.sky $u 15
alias -l new {
  t turn 1
  t wins.1 0
  t wins.2 0
  t dirt 1
  t rounds 3
  t skill 4
  t credits.1 400
  t credits.2 400
  window -c $w
  window -dfkp +tf $w -1 -1 $calc(1+$xmax) $calc(1+$ymax) $fx
}

alias -l clb {
  drawpic -cnt $w 65535 0 241 " $+ $scriptdirtanksb.bmp"
  fill 15 $calc(5+$int($calc($v(inc)/5))*18) 302
  fill 0 $calc(12+$int($calc($v(inc)/5))*18) 309
  if $v(item) > 1 { drawpic -cn $w 304 300 $calc(9*$v(item)-18) 0 9 11 " $+ $scriptdirtanksr.bmp" }
  $iif($1,n,d)
}

alias -l fix {
  var %x 2
  while (%x) {
    t power. $+ %x $num(0,$v(power,%x),$v(max,%x))
    t credits. $+ %x $num(0,$v(credits,%x),999)
    dec %x
  }
  $iif($1,n,t) item $num(1,$v(item),$mw)
}
alias -l draw {
  fix 1
  var %x $current(player),%c $current(color)
  rect %c 0 241 321 80
  clb n
  if %x || $v(shield.1) < 1 || $v(shield.2) < 1 {
    rect %c 3 263 36 55 41 244 74 74 206 244 26 74 234 244 84 26 234 292 84 26
    ;rect 14 245 264 71 33
  }
  %c = text 15 %c
  if %x {
    %c 0 241 You
    %c 72 291 Enemy
    if $v(shield.1) > 0 && $v(shield.2) > 0 { %c 240 298 Missile $v(item) }
  }
  %x = $min($current(angle),$calc(180-$current(angle)))
  %c $calc(197-$wid(%x)) 243 %x
  %x = $current(power)
  %c $calc(197-$wid(%x)) 256 %x
  %x = $current(prev)
  %c $calc(197-$wid(%x)) 269 %x
  %x = $current(max)
  %c $calc(197-$wid(%x)) 282 %x
  var %t $v(wind)
  if %t < 0 { %x = < $+ %t } | elseif %t == 0 { %x = 0 } | else %x = %t $+ ->
  %c $calc(197-$wid(%x)) 304 %x
  if %t < 0 { line 15 $calc(200-$wid(%x)) 311 $calc(207-$wid(%x)) 311 }
  if %t > 0 { line 15 193 311 186 311 }
  %x = $current(credits)
  %c $calc(313-$wid(%x)) 273 %x
  var %t $current(shield),%x 1 | while (%x <= %t) { fill $iif($mw(-1) >= %t,4,0) $calc(113+8*%x) 299 | inc %x }
  var %t $current(-shield),%x 1 | while (%x <= %t) { fill $iif($mw >= %t || $v(item) >= %t,4,0) $calc(3+3*%x) 258 | inc %x }
  if $n($1) { drawtank 1 n | drawtank 2 n }
  d
}

alias -l drawtank {
  var %a = $int($calc((182-$v(angle,$1)-$1)/13)), %y = $v(y,$1), %x = $v(x,$1), %s = $max($v(shield,$1),0)
  ; circle $color.sky 20 %x %y
  fill $color.sky %x %y
  :y
  drawpic -cnt $w 65535 $calc(%x -8) $calc(%y -13) 0 $calc(14*%a) 17 14 " $+ $scriptdirtanks.bmp"
  fill $v(color,$1) %x %y
  if %s {
    d
    if $fc(%x,$calc(1+%y)) == $color.sky {
      fill $color.sky %x %y
      inc %y
      goto y
    }
    t y. $+ $1 %y
    ; circle $color.missile 1 $xstart $ystart
  }
  $iif($2,n,d)
}

alias -l color.pause {
  ;if ((you=p2 && p1 picked a color) or you=p1) {
  if $v(player.1) && $v(color.1) != $null || $v(player.2) {
    ;poo rect 0 8 96 96 15
    ;rect 0 7 95 98 17
    text 15 1 112 120 Click on your color.
    var %t 8,%c 1,%l | while (%c <= 15) { if $colorok(%c) { %l = %l %c | rect %c %t 120 16 16 | inc %t 16 } | inc %c }
    rect $color.sky 8 137 18 12
    drawpic -cnt $w 65535 8 134 0 182 17 14 " $+ $scriptdirtanks.bmp"
    fill 1 11 140
    t colors %l
    en color.buttons
  }
  else text 15 1 8 96 Waiting...
  if $noai { en color.wait }
  hltb
}

#tanks.color.wait off
on ^*:notice:tanks color *:*:{
  if [ $v(address) ] iswm $fulladdress {
    dis color.wait
    text 15 1 16 152 Opponent has chosen:
    rect $3 182 152 16 16
    var %c = $iif($colorok($3),$3,10)
    t rounds $4
    hltb 1
    if $v(player.1) == $v(player) {
      t color.1 %c
      hltb
      color.pause
    }
    else {
      t color.2 %c
      hltb
      terrain
    }
  }
  h
}
#tanks.color.wait end

alias -l hp $u http://come.to/andys.site/
alias -l hltb {
  if $isid { var %x $mx,%y $my }
  else var %x $mouse.x,%y $mouse.y

  var %b,%r n,%t a_s_d@snet.net, %i = $inrect(%x,%y,76,36,$wid(%t),15), %e = $iif($gr(color.buttons) == on,1)
  text $iif(%i && %e,0 12,15 2) 76 36 %t
  if %i { %r = run mailto: $+ %t $+ ?subject= $+ $tanksversion }

  if $isfile($scriptdirtanks.txt) {
    var %t [help], %i = $inrect(%x,%y,268,4,$wid(%t),15)
    text $iif(%i && %e,0 12,15 2) 268 4 %t
    if %i { %r = run " $+ $scriptdirtanks.txt" }
  }

  var %t $hp, %i = $inrect(%x,%y,76,52,$wid(%t),15)
  text $iif(%i && %e,0 12,15 2) 76 52 %t
  if %i { %r = run %t }

  if %e || $1 && $n($2) {
    if $v(player) == .ai. {
      text 15 1 8 74 Skill:
      %t = 0
      while (%t < 5) {
        var %b $calc(66+25*%t), %i = $inrect(%x,%y,%b,74,23,15)
        text $iif(%i && %e,0 12,15 2) %b 74 $replace($iif(%t == $v(skill),(&),&),&,%t)
        if %i { %r = t skill %t }
        inc %t
      }
    }
    text 15 1 8 96 Number of rounds:
    %t = 9
    while (%t > 0) {
      var %b $calc(152+25*$calc((%t -1)/2)), %i = $inrect(%x,%y,%b,96,23,15)
      text $iif(%i && %e,0 12,15 2) %b 96 $replace($iif(%t == $v(rounds),(&),&),&,%t)
      if %i { %r = t rounds %t }
      dec %t 2
    }
  }

  var %t [check for new version], %i = $inrect(%x,%y,4,280,$wid(%t),15)
  text $iif(%i && %e,0 12,15 2) 4 280 %t
  if %i { %r = checktanksversion }

  var %t [install newest version], %i = $inrect(%x,%y,4,296,$wid(%t),15)
  text $iif(%i && %e,0 12,15 2) 4 296 %t
  if %i { %r = downloadtanks }
  d
  $u %r
}
#tanks.color.buttons off
menu @tanks {
  mouse:{
    if $v(mycolor) == $null {
      rect $color.sky 8 137 18 12
      drawpic -cnt $w 65535 8 134 0 182 17 14 " $+ $scriptdirtanks.bmp"
      fill $iif($inrect($mouse.x,$mouse.y,8,120,$iif($n($v(player.1)),95,79),15),$fc($mouse.x,$mouse.y),1) 11 140
      hltb
    }
  }
  leave:hltb
  sclick:{
    if $inrect($mx,$my,8,120,$iif($n($v(player.1)),95,79),15) && $v(mycolor) == $null {
      var %c = $fc($mx,$my)
      if $n($v(player.1)) { t color.1 %c } | else t color.2 %c
      text 15 1 48 136 You have chosen:
      rect %c 182 136 16 16
      if $noai {
        no color %c $v(rounds)
        text 15 1 16 168 Waiting...
      }
      else {
        t color.2 $gettok($remtok($v(colors),%c,1,32),$rand(1,5),32)
        text 15 1 16 152 Opponent has chosen:
        rect $v(color.2) 182 152 16 16
      }
      t mycolor %c | hltb
      dis color.buttons
      if $v(color.1) != $null && $v(color.2) != $null { terrain }
    }
    else { $hltb | hltb }
  }
}
#tanks.color.buttons end

alias -l slope $u $calc($rand(0,16)/5-1.6) | $replace($calc($rand(0,6)-3),3,.5)
alias -l terrain {
  if $wins >= $v(rounds) {
    tb
    cmsg Game Over
    draw
    var %n 2
    while (%n) {
      drawtext -rn $w $c(1) fixedsys -14 $calc($v(x,%n)-6+%n) $calc($v(y,%n)-36) $v(wins,%n)
      dec %n
    }
    end
    halt
  }
  if $wins {
    t credits.1 $max($v(credits,1),250)
    t credits.2 $max($v(credits,2),250)
  }
  if $v(player.1) { en terrain | $u }
  t wind $calc($rand(1,199)-100)
  t x.1 $rand(25,75)
  t x.2 $calc($xmax -$rand(25,75))
  t y.1 1
  t y.2 1
  var %b = $rand(100,180), %o 0,%x 0,%y $slope,%g
  t terrain %b
  while (%x <= $xmax) {
    inc %o
    %g = $rand(12,36)
    if %o >= %g || %x == $xmax {
      t terrain $v(terrain) %y %o
      var %o 0,%y $slope
    }
    if %b <= 40 { %y = $abs($slope) }
    if %b >= 200 { %y = 0 - $abs($slope) }
    inc %b %y
    %b = $num(40,%b,200)
    ;if %x == $v(x.1) { t y.1 $calc(%b -1) }
    ;if %x == $v(x.2) { t y.2 $calc(%b -1) }
    inc %x
  }
  var %n $tn(0)
  while (%n) {
    t terrain $v($tn(%n)) $v(terrain)
    dec %n
  }
  if $noai { no terrain $v(terrain) }
  start
}
alias -l tn $u $gettok(x.1 y.1 x.2 y.2 wind,$1,32)

#tanks.terrain off
on ^*:notice:tanks terrain *:*:{
  if [ $v(address) ] iswm $fulladdress {
    dis terrain
    t terrain $3-
    start
  }
  h
}
#tanks.terrain end

alias -l wins $u $calc($v(wins.1)+$v(wins.2))
alias -l tb if $window($w) { titlebar $w [[ $+ $iif($noai,$v(player),Skill [ $v(skill) ] ) $+ ]] [ $iif($fc(0,0) == $color.sky && $n($1-) && $wins < $v(rounds),- Round [ $calc($wins + 1) of $v(rounds) ] , [ $iif($1-,- [ $1- ] ,) ] ) ] }
alias -l noai $u $iif($v(player) && $v(player) != .ai.,1)
alias -l start {
  tokenize 32 $v(terrain)
  cl $color.sky
  tb
  t angle.1 35 | t power.1 45 | t max.1 100 | t prev.1 0 | t shield.1 10
  t angle.2 145 | t power.2 45 | t max.2 100 | t prev.2 0 | t shield.2 10
  t item 1
  t inc 5
  var %n 1
  while (%n <= $tn(0)) {
    t $tn(%n) $1
    inc %n
    tokenize 32 $2-
  }
  draw n
  var %b $1,%o 0,%x 0,%y $2,%g
  while %x <= $xmax && $2 != $null {
    inc %o
    %g = $3
    if %o >= %g || %x == $xmax {
      tokenize 32 $3-
      var %o 0,%y $2
    }
    line $color.ground %x 240 %x %b
    d
    inc %b %y
    %b = $num(40,%b,200)
    inc %x
  }
  drawtank 1
  drawtank 2
  t first 1
  next
}
alias -l next {
  %n = $current(player)
  if %n == .AI. { i think }
  elseif %n { en fire.wait }
  else i en buttons
}
alias -l think {
  var %w $v(wind),%a $current(-x),%b $current(-y),%x $v(aix),%y $v(aiy),%p $current(prev),%g $v(aiw),%n $current(angle),%s $v(skill)
  $iif($window($w),t item 1,$u)
  if $v(first) == 1 {
    if %w <= 0 { var %n 120,%g 60 }
    if %w <= -20 { var %n 115,%g 60 }
    if %w <= -45 { var %n 110,%g 55 }
    if %w <= -70 { var %n 105,%g 50 }
    if %w > 0 { var %n 125,%g 65 }
    if %w > 33 { var %n 130,%g 70 }
    if %w > 66 { var %n 130,%g 75 }
    t first 0
    if %s < 1 { inc %n 15 | dec %g 30 }
  }
  elseif %x >= $calc(%a -30) && %x <= $calc(%a +30) && %y >= $calc(%b -38) && %y <= $calc(%b +30) {
    t item $num(1,$iif($v(mw) && %s < 4 || %s < 2,1,$iif(%s < 4,$iif(%s < 3,$rand(1,3),$rand(2,5)))),$mw)
    if %y > %b { %g = %p $iif(%x < %a,- 2,+ 1) }
    if %y < $calc(%b -8) && %x <= %a || %x < $calc(%a -8) { %g = %p - 3 }
    if %y > %b && %x >= %a || %x > $calc(%a +8) { %g = %p + 2 }
  }
  else {
    if %y > %b { %g = %p $iif(%x < %a,- 6,+ 5) }
    if %x < $calc(%a -30) { %g = %p - 8 }
    if %x > $calc(%a +30) { %g = %p + 7 }
    if %x < %a && %y < $calc(%b -60) || %x < $calc(%a -70) { %g = %p - 14 }
    if %x > %a && %y > $calc(%b +60) || %x > $calc(%a +70) { %g = %p + 13 }
    if %x < $calc(%a -70) && %w >= 75 { %g = %p - 10 }
    if %x > $calc(%a +70) && %w <= -75 { %g = %p + 9 }
  }
  tc angle %n
  t aiw %g
  while $current(shield) <= $mw(-1) || %g > $current(max) && $current(credits) >= 30 && $current(shield) < 10 { shield | draw }
  tc power %g
  fix
  draw
  b f
}
alias -l mw var %t $v(turn),%x 5 | while %x > 1 && $calc(25*%x) > $calc($v(credits,$iif($1,$replace($1,-1,$calc(3-%t)),%t))) { dec %x } | $u %x

alias -l b {
  var %a,%t $v(turn)
  if $1 isin 15 { t inc $1 }
  if $1 isin ud { tc power $num(0,$calc($current(power) $replace($1,u,+,d,-) $v(inc)),$current(max)) }
  if $1 isin lr { %a = $replace($1,l,1,r,-1) | tinc angle. $+ %t $calc($v(inc)*%a) | if $calc($current(angle)-$v(inc)*%a) == $calc(90+90*%a) { tc angle $calc(90-90*%a) } | tc angle $num(0,$current(angle),180) }
  if $1 == n { var %i = $min($calc($v(item)+1),5) | if $calc(25*%i) <= $current(credits) { t item %i } }
  if $1 == p { t item $max($calc($v(item)-1),1) }
  if $1 == s { shield }
  if $1 == f { fire $2- }
  else { fix | draw $iif(%a,0,n) }
}
alias -l bn $u 1 5 u d l r n p s f
alias -l ir while ($1) { $iif($inrect($mx,$my, [ $gettok($irc,$findtok($bn,$1,1,32),32) ] ),b,n) $1 | tokenize 32 $2- }
alias -l irc $u 4,301,15,16 22,301,15,16 41,244,35,35 41,282,35,35 3,263,35,35 79,263,35,35 206,244,25,35 206,282,25,35 234,244,83,25 234,292,83,25
#tanks.buttons off
on *:keydown:@tanks:*:b $replace($keyval,38,u,40,d,37,l,39,r,33,n,34,p,13,f,32,s,9,$iif($v(inc) == 1,5,1))
;,49,1,109,1,53,5,107,5
alias -l showbutton t sb  | while ($1) { t sb $iif($inrect($mouse.x,$mouse.y, [ $gettok($irc,$findtok($bn,$1,1,32),32) ] ),$upper($1),$v(sb)) | tokenize 32 $2- } | titlebar $w [[ $mouse.x , $mouse.y ]] $v(sb)
menu @tanks {
  mouse:{
    ;showbutton $bn
    $u
    ; $calc(x-8) $calc(y-9) 17 12
    if $istank(1,$mouse.x,$mouse.y) { tb mouse on player 1 }
    elseif $istank(2,$mouse.x,$mouse.y) { tb mouse on player 2 }
    else tb
  }
  sclick:ir $bn
  dclick:ir $bn
}
#tanks.buttons end
alias -l angle $u $calc($current(angle)*3.14159/180)
alias -l xstart $u $calc($current(x)+$cos($angle)*12)
alias -l ystart $u $calc($current(y)-$sin($angle)*10-6)
alias -l istank $u $inrect($2,$3,$calc($v(x,$1)-7),$calc($v(y,$1)-9),14,9) | $iif($sqrt($calc(($v(y,$1)-4-$3)^2+($v(x,$1)-$2)^2)) <= 7,1)
alias -l testhit {
  var %b 1
  while (%b <= 2) {
    var %x = $calc($v(x,%b)-20), %y
    fill $color.sky $v(x,%b) $calc($v(y,%b)+1) | d
    while (%x <= $calc($v(x,%b)+20)) {
      %y = $calc($v(y,%b)-20)
      while (%y <= $calc($v(y,%b)+20)) {
        if $hit(%x,%y) {
          orect 1 %x %y 1 1
          d
        }
        inc %y
      }
      inc %x
    }
    inc %b
  }
}
alias -l hit $u $iif($2 > 240 || $fc($1,$calc(1+$2)) != $color.sky || $istank(1,$1,$2) || $istank(2,$1,$2) && $2 >= 0,1)
alias -l fvars {
  var %x 1,%t $v(item) $v(dirt)
  while (%x <= $fn(0)) {
    %t = %t $current($fn(%x))
    inc %x
  }
  $u %t
}
alias -l fn $u $gettok(angle power,$1,32)
alias -l shield {
  if $current(credits) >= 30 && $current(shield) < 10 {
    if $current(-player) && $current(-player) != .ai. {
      no shield
    }
    tdec credits. $+ $v(turn) 30
    tinc shield. $+ $v(turn) 1
    tc max $min(100,$calc($current(max) + 10))
    t item $min($v(item),$mw)
  }
}
alias -l fire {
  dis buttons
  fix
  if $current(-player) && $noai {
    no fire $fvars
  }
  elseif $1- {
    t item $1
    t dirt $2
    tokenize 32 $3-
    var %x $fn(0)
    while (%x) {
      tc $fn(%x) $ [ $+ [ %x ] ]
      dec %x
    }
    fix
  }
  var %sky,%h,%who,%what,%g $v(item),%size $calc(3+5*%g),%turn $v(turn),%t -.1,%s $current(power) / 1.3,%c,%x1 $xstart,%y1 $ystart,%x %x1,%y %y1,%x0,%y0,%xhit,%yhit,%x_,%y_,%n,%w $v(wind) / 55
  if %g > 1 { tdec credits. $+ %turn $calc(25*%g) }
  if $current(player) == .ai. { t mw $iif(%g > 1,1) }
  draw 0 1
  var %c %s * $cos($angle),%s %s * $sin($angle)
  :wl | var %x0 %x,%y0 %y,%t %t + .1
  var %x $calc(%x1 +%t *(%c +%w *%t)),%y $calc(%y1 -%t *(%s -4.9*%t)), %xhit = $num(0,%x,$xmax), %yhit = $num(0,%y,240)
  $iif(%t,circle,n) $color.sky 1 %x0 %y0
  if $hit(%xhit,%yhit) { goto hit }
  circle $color.missile 1 %x %y | d
  goto wl
  :hit
  var %y %yhit, %what = $fc(%xhit,%y)
  ;begin explosion
  circle 4 $calc(%size -1) %x %y | d
  ;see who got hit
  %n = 2
  while (%n) {
    if %what == $v(color,%n) || $sqrt($calc(($v(x,%n)-%x)^2+($v(y,%n)-4-%y)^2)) <= $calc(7+%size) { %who = %n }
    dec %n
  }
  ;tb %who
  if %who {
    t shield. $+ %who $calc($v(shield,%who)-%g)
    t max. $+ %who $max(50,$calc($v(max,%who)-10*%g))
  }
  if %who == $calc(3-%turn) {
    tinc credits. $+ %turn $calc($iif($current(credits) < 150,4,3)*%g)
  }
  ;make dirt fall
  if $v(dirt) {
    %x_ = $calc(%x -%size)
    while %x_ <= $calc(%x +%size) {
      if %x_ isnum 0- $+ $calc(1+$xmax) {
        var %y_ = $min($calc(%y +%size),240), %h %y_,%sky 0
        while (%y_ >= 40) {
          %n = $fc(%x_,%y_)
          ; orect 3 %x_ %y_ 1 1
          if %n == $color.ground {
            dec %h
          }
          elseif %n == $color.sky {
            %y_ = 0
          }
          dec %y_
        }
        line $color.sky %x_ 0 %x_ $calc(%y +%size)
        line $color.ground %x_ $calc(%y +%size) %x_ %h
      }
      inc %x_
    }
  }
  else {
    %x_ = $num(0,%x,$xmax)
    $iif($fc(%x_,%y) == 4,fill,n) $color.sky %x_ %y
  }
  line $color.ground 0 240 $calc(1+$xmax) 240
  ;end explosion
  var %n $current(shield),%h $current(-shield)
  if $current(credits) >= 150 { tdec credits. $+ %turn 6 }
  if %n > %h { tinc credits. $+ %turn 8 }
  if %n == %h { tinc credits. $+ %turn 10 }
  if %n < %h { tinc credits. $+ %turn 13 }
  if %turn == 2 { t aix %x | t aiy %y }
  tc prev $current(power)
  t turn $calc(3-%turn)
  fix
  t item 1
  if $v(shield.1) <= 0 { tinc wins.2 1 | terrain }
  elseif $v(shield.2) <= 0 { tinc wins.1 1 | terrain }
  else { draw | next }
}
#tanks.fire.wait off
on ^*:notice:tanks shield:*:{
  if [ $v(address) ] iswm $fulladdress { b s }
  h
}
on ^*:notice:tanks fire *:*:{
  if [ $v(address) ] iswm $fulladdress {
    dis fire.wait
    b f $3-
  }
  h
}
#tanks.fire.wait end
;on *:keydown:@:*:e pressed key $keyval $keyrpt

alias -l we {
  if on isin $gr(outgoing.request) $gr(color.buttons) $gr(color.wait) || $n($v(rounds)) && $window($w) {
    rect 1 200 280 120 40
    $iif($1-,text,n) 15 1 200 280 $gettok($1-,1,124)
    d
  }
  elseif (| isin $1-) { e $gettok($1-,2,124) }
}
alias checktanksversion {
  $nodl
  we $v(v)
  if $v(v) { t c | t v | $u }
  $iif($sock(tanksversion).name,$u,$iif($v(c),t v,we)) checking...
  sockopen tanksversion pages.cthome.net 80
}
on *:sockopen:tanksversion:{
  if $sockerr {
    $iif($v(c),t v,we) Error $sockerr
    $u
  }
  sockwrite -n $sockname GET /pdufilie/versions.txt
}
on *:sockread:tanksversion:{
  var %d
  :x
  sockread %d
  if $sockbr {
    $nodl
    if tanks * iswm %d {
      var %v = $calc($gettok(%d,2,32)), %d = $calc($gettok(%d,3,32))
      if $tanksversion(1) < %v {
        if %d > $version {
          t v | t c | we need mIRC %d
          $u
        }
        t v | t c | we new: v $+ %v
      }
      else $iif($v(c),t v,we) no new version
    }
    goto x
  }
}
alias -l dl $u downloadtank $+ $iif($1,spif,s)
alias downloadtanks {
  $nodl
  if $timer(installtanks1) { $u }
  if $noai { no cancel }
  if $window($w) { rect 1 0 72 320 200 | hltb 0 1 }
  end
  we downloading...|Downloading newest version of Tanks...
  sockopen $dl pages.cthome.net 80
}
alias -l nodl $u $iif($sock($dl).name || $sock($dl(1)).name,$u)
alias -l dlpif {
  $iif($sock($dl(1)).name,$u,n)
  sockopen $dl(1) pages.cthome.net 80
}
alias -l dlfile $u " $+ $scriptdirtanks. $+ $iif($1,pif,exe) $+ "
on *:sockopen:downloadtanks*:{
  var %p = $iif(pif isin $sockname,1,0)
  if $sockerr {
    if %p {
      installtanks
    }
    else {
      window -c $w
      e Connection error ( $+ $sockerr $+ ) when downloading Tanks
    }
    $u
  }
  write -c $dlfile(%p)
  sockwrite -n $sockname GET /pdufilie/irc/tanks. $+ $iif(%p,pif,exe)
}
on *:sockread:downloadtanks*:{
  var %s $sockname, %p = $iif(pif isin %s,1,0)
  :x
  sockread 4096 &d
  if $sockbr {
    bwrite $dlfile(%p) -1 -1 &d
    goto x
  }
}
on *:sockclose:downloadtanks*:{
  if pif isin $sockname { installtanks }
  else dlpif
}
alias -l installtanks {
  if $isfile($dlfile) {
    we installing...|Installing Tanks...
    .timerinstalltanks1 -o 1 3 .remove $dlfile
    .timerinstalltanks2 -o 1 3 .remove $dlfile(1)
    .timer -o 1 2 window -c $w
    .timerinstalltankserror -o 1 0 e Error occured while downloading Tanks.
    run -n $shortfn($dlfile) -o $shortfn($scriptdir)
    .timerinstalltankserror off
    .timerinstalltanks3 -o 1 2 .load -rs " $+ $script $+ "
    .unload -rs " $+ $script $+ "
  }
}
