;addon: stats for channels
;Author: PerObaO (perobao@brasnet.org)
;where is PerObaO?: irc.brasnet.org ... /join #scriptX

;load addon

on 1:load:{
  if $version < 5.5 { echo error... can only use with mirc 5.5+ | echo unload $script | /unload -rs $script }
  else {
    echo -a $str(30,-) $str(40,-)
    echo -a load: stats for channels (stats.mrc)
    echo -a email: perobao@brasnet.org
    echo -a by: PerObaO ..: #scriptX :.. irc.brasnet.org
    echo -a using: channel/statuschan
    echo -a $str(30,-) $str(40,-)
  }
}

;dialog

dialog status {

  title "stats channels"
  size 150 100 270 220

  box "channels", 1, 10 5 150 50
  combo 2, 15 23 140 80, drop
  box "stats", 3, 10 60  250 157

  text "ops:", 4, 15  80 20 15
  text "nops:",5, 15 100 25 15
  text "non-voice:",6, 15 120 50 15
  text "voice:",7, 15 140 40 15
  text "ircop:",8, 160 80 25 15 
  text "away:",9, 160 100 30 15
  text "clones:", 10, 160 120 40 15
  text "bans", 11, 160 140 30 15

  edit "", 12, 70 77 35 20
  edit "", 13, 70 97 35 20
  edit "", 14, 70 117 35 20
  edit "", 15, 70 137 35 20
  edit "",16, 215 77 35 20 
  edit "",17, 215 97 35 20
  edit "",18, 215 117 35 20
  edit "",19, 215 137 35 20
  edit "",20, 15 165 235 18 

  button "  ", 21, 15 190 50 20, disable
  button "&refresh #", 22, 190 10 70 20
  button "&exit", 23, 190 35 70 20, cancel

  box "more..", 24, 10 220 250 180

  button "whois", 25, 15 240 60 15
  button "ping", 26, 15 260 60 15 
  button "kick", 27, 15 280 60 15 
  button "ban", 28, 15 300 60 15 
  button "kick&&ban", 29, 15 320 60 15 
  button "op", 30, 15 340 60 15 
  button "deop", 31, 15 360 60 15 

  combo 32, 120 240 130 165, drop

  text "stats channels by PerObaO", 33, 70 380 150 15
  text "users", 34, 112 80 39 15

  edit "", 35, 115 95 32 20

  box "whois", 36, 90 265 160 110, hide

  text "Real name:", 37, 95 280 60 15, hide
  text "Addy:", 38, 95 295 30 15, hide
  text "server:", 39, 95 310 35 15, hide
  text "channel:", 40, 95 325 37 15, hide
  text "away:", 41, 95 340 35 15, hide
  text "ircop:", 42, 95 355 35 15, hide

  edit "", 43, 153 278 95 17 , autohs hide
  edit "", 44, 133 293 115 17, autohs hide
  edit "", 45, 133 308 115 17, autohs hide
  edit "", 46, 133 323 115 17, autohs hide
  edit "", 47, 133 338 115 17, autohs hide
  edit "", 48, 133 353 115 17, autohs hide

  text "ping reply:", 49, 120 280 70 15, hide
  text "sec(s)", 50, 212 280 32 15, hide

  edit "", 51, 170 278 40 20, autohs hide

}

;events

on *:dialog:status:*:*:{
  if $devent == init { 
    did -m status 12 | did -m status 16
    did -m status 13 | did -m status 17
    did -m status 14 | did -m status 18
    did -m status 15 | did -m status 19
    did -m status 20 | did -m status 35  | did -a status 20 stats for channels
    did -m status 43 | did -m status 44 | did -m status 45 | did -m status 46
    did -m status 47 | did -m status 48 | did -m status 51
  }
  if $devent == sclick {
    if $did == 21 &&   isin $did(21).text { more | did -a status 21    }
    elseif $did == 21 &&  isin $did(21).text { back | did -a status 21    }
    if $did == 22 { refreshchan $did(2).text }
    if $did == 25 {
      set %whois-yeap on 
      $hidetxtedt(49,51)
      $visibletxtedt(37,48)
      whois $did(32).text 
    }
    if $did == 26 {
      $hidetxtedt(37,48)
      $visibletxtedt(49,51)
      ctcp $did(32).text ping 
    }
    if $did == 27 { 
      if $Me isop $did(2).text {
        kick $did(2).text $did(32).text kick! 
        did -ra status 33 $did(32).text was kicked.. $did(2).text
      }
      elseif $me !isop $did(2).text { did -ra status 33 you're not channel operator }
    }
    if $did == 28 { 
      if $Me isop $did(2).text {
        ban $did(2).text $did(32).text 3
        did -ra status 33 $did(32).text was banned.. $did(2).text
      }
      elseif $me !isop $did(2).text { did -ra status 33 you're not channel operator }
    }
    if $did == 29 { 
      if $Me isop $did(2).text {
        kick $did(2).text $did(32).text kick & baN!
        ban $did(2).text $did(32).text 3
        did -ra status 33 $did(32).text was kicked/banned.. $did(2).text
      }
      elseif $me !isop $did(2).text { did -ra status 33 you're not channel operator }
    }
    if $did == 30 { 
      if $Me isop $did(2).text {
        mode $did(2).text +o $did(32).text 
        did -ra status 33 sets mode: +o $did(32).text
      }
      elseif $me !isop $did(2).text { did -ra status 33 you're not channel operator }
    }
    if $did == 31 { 
      if $Me isop $did(2).text {
        mode $did(2).text -o $did(32).text 
        did -ra status 33 sets mode: -o $did(32).text
      }
      elseif $me !isop $did(2).text { did -ra status 33 you're not channel operator }
    }
    if $did == 2 { 
      $hidetxtedt(37,48)
      $hidetxtedt(49,51)
      unset %stats.*
      did -r status 32
      did -ra status 20 refreshing channel..
      %stats.who = on | %stats.ban = on
      %stats.bans = 0 | %stats.cops = 0
      %stats.away = 0
      did -e status 21
      mode $did(2).text +b
      who $did(2).text
    } 
  }
}

on 1:ctcpreply:ping*:{ 
  %pt = $calc($ticks - $2)
  ftime %pt
  set %pingreply $gettok(%ftime,2,46) 
  did -ra status 51 $calc($ctime - $2) $+ . $+ %pingreply 
  halt  
}

on 1:part:#:{
  if $nick == $me && $dialog(status) != $null { 
    unset %stats.channels 
    did -r status 2
    :loop
    inc %stats.channels 1
    if $chan(0) > %stats.channels {
      did -ca status 2 $chan(%stats.channels)
      goto loop
    }
  }
}

;alias

alias status dialog -m status status

alias statuschan {
  if $me !ison $chan { echo -s dks: you are not is on channel | halt }
  status
  unset %status.channels
  :loop
  inc %status.channels 1
  if $chan(0) > %status.channels {
    if $chan(%status.channels) == $chan { goto loop }
    did -a status 2 $chan(%status.channels)
    goto loop
  }
  unset %stats.*
  did -r status 32
  did -ra status 20 refreshing channel..
  %stats.who = on | %stats.ban = on
  %stats.bans = 0 | %stats.cops = 0
  %stats.away = 0
  did -e status 21
  mode # +b
  who #
  did -ca status 2 #
}
alias refreshchan {
  unset %stats.*
  did -r status 32
  did -ra status 20 refreshing channel..
  %stats.who = on | %stats.ban = on
  %stats.bans = 0 | %stats.cops = 0
  %stats.away = 0
  did -e status 21
  mode $did(2).text +b
  who $did(2).text
}
alias stats.clones {
  unset %stats.clones*
  set %stats.clonestotal 0
  :go
  inc %stats.clones 1
  if $nick(%stats.canal,%stats.clones) == $null  { goto end }
  else {
    if (% [ $+ [ stats.clones [  $+ [ $address($nick(%stats.canal,%stats.clones),2) ] ] ] ] == 1 ) { inc %stats.clonestotal 1 | goto go | halt }
    else { inc % [ $+ [ stats.clones [  $+ [ $address($nick(%stats.canal,%stats.clones),2) ] ] ] ] 1 | goto go | halt }
  }
  :end
}

alias more {
  set %more. 220
  :loop
  inc %more. 1
  if %more. < 410 {
    dialog -s status 150 100 270 %more. 
    goto loop
  }
}
alias back {
  set %more. 410
  :loop
  dec %more. 1
  if %more. > 220 {
    dialog -s status 150 100 270 %More.
    goto loop
  }
}

alias ftime {
  if ($len($1) == 1) { set %ftime 000 $+ $1 }
  elseif ($len($1) == 2) { set %ftime 00 $+ $1 }
  elseif ($len($1) == 3) { set %ftime 0 $+ $1 }
  else { set %ftime $1 }
  set %ftime $left(%ftime,$calc($len(%ftime) - 3)) $+ . $+ $right(%ftime,3)
  return %ftime
}

alias hidetxtedt {
  set %hidetxtedt $calc($1 - 1)
  :go
  inc %hidetxtedt 1
  if %hidetxtedt <= $2 {
    did -h status %hidetxtedt
    goto go
  }
}

alias visibletxtedt {
  set %hidetxtedt $calc($1 - 1)
  :go
  inc %hidetxtedt 1
  if %hidetxtedt <= $2 {
    did -v status %hidetxtedt
    goto go
  }
}


;raw

raw 352:*:{
  if %stats.who == on {
    if (* isin $7) { inc %stats.cops 1 }
    if (G isin $7) { inc %stats.away 1 }
    halt
  }
}

raw 367:*:{
  if %stats.ban == on {
    inc %stats.bans 1
    halt 
  }
}
raw 368:*:{ if %stats.ban == on { halt } } 
raw 315:*:{
  if %stats.who == on {
    stats.clones
    if $dialog(status) != $null {
      did -ra status 12 $opnick($2,0) | did -ra status 15 $vnick($2,0)
      did -ra status 13 $nopnick($2,0) | did -ra status 14 $nvnick($2,0)
      did -ra status 16 %stats.cops | did -ra status 17 %stats.away
      did -ra status 18 %stats.clonestotal | did -ra status 19 %stats.bans
      did -ra status 35 $nick($2,0)
      did -ra status 20 completed
      did -a status 21         
      did -r status 32
      :list
      inc %stats.list 1
      if $nick($2,0) > %stats.list {
        did -ca status 32 $nick($2,%stats.list) | goto list 
      }
    }
    unset %stats.*
  }
}

raw 311:*:{
  if %whois-yeap == on {
    did -ra status 43 $6-
    did -ra status 44 $3 $+ @ $+ $4
    halt
  }
}

raw 319:*:{
  if %whois-yeap == on {
    did -ra status 46 $3-
    halt
  }
}
raw 312:*:{
  if %whois-yeap == on {
    did -ra status 45 $3-
    halt
  }
}
raw 301:*:{
  if %whois-yeap == on {
    did -ra status 47 $3-
    halt 
  }
}
raw 313:*:{
  if %whois-yeap == on { 
    did -ra status 48 is an ircop
    halt
  }
}
raw 318:*:/unset %whois-yeap | halt
raw 366:*:{
  unset %stats.channels
  if $dialog(status) != $null { 
    did -r status 2 
    :loop
    inc %stats.channels 1
    if $chan(0) > %stats.channels {
      if $chan(%stats.channels) == $2 { goto loop }
      did -a status 2 $chan(%stats.channels)
      goto loop
    }
    /did -ca status 2 $2
  }
}

;menu

menu channel {
  -
  &status chan
  .&status:/statuschan
  .&unload:/unload -rs $script
  .-
  .&about:/echo -a :(Status cHanneL by PerObaO.): | echo -a :(e-mail: perobao@brasnet.org): 
}
