; Aliases
alias smhelp { run $scriptdir $+ statman.hlp }
alias statman { .timer -m 1 1 sm.opendlg }
alias sm.ar { setopt autorefresh active yes | cstats %SMChannel }
alias sm.load {
  %SMFile = $scriptdir $+ $did(sm.stat,104,$did(sm.stat,104,1).sel) $+ .stm
  if ($exists(%SMFile) == $false) { halt }
  unset %SM.*
  %SMChannel = $readini %SMFile Totals Channel
  %SM.Total = $readini %SMFile Totals Total
  %SM.ChanOps = $readini %SMFile Totals ChanOps
  %SM.NonOps = $readini %SMFile Totals NonOps
  %SM.Voiced = $readini %SMFile Totals Voiced
  %SM.IRCOps = $readini %SMFile Totals IRCops
  %SM.Here = $readini %SMFile Totals Here
  %SM.Away = $readini %SMFile Totals Away
  %SM.Hops = $readini %SMFile Totals Hops
  %SM.PerChanOps = $percent(%SM.ChanOps,%SM.Total)
  %SM.PerNonOps = $percent(%SM.NonOps,%SM.Total)
  %SM.PerIRCops = $percent(%SM.IRCOps,%SM.Total)
  %SM.PerVoiced = $percent(%SM.Voiced,%SM.Total)
  %SM.PerAway = $percent(%SM.Away,%SM.Total)
  %SM.PerHere = $percent(%SM.Here,%SM.Total)
  %x = 1
  :start1
  %y = $readini %SMFile Total %x
  if (%y) { %SM.Total. [ $+ [ %x ] ] = %y | inc %x 1 | goto start1 }
  sm.showstats
  sm.fillnl
}
alias sm.save {
  %SMFile = $scriptdir $+ %SMChannel $+ .stm
  if ($exists(%SMFile)) { .remove %SMFile }
  writeini %SMFile Totals Channel %SMChannel
  writeini %SMFile Totals Total %SM.Total
  writeini %SMFile Totals ChanOps %SM.ChanOps
  writeini %SMFile Totals NonOps %SM.NonOps
  writeini %SMFile Totals Voiced %SM.Voiced
  writeini %SMFile Totals IRCops %SM.IRCops
  writeini %SMFile Totals Here %SM.Here
  writeini %SMFile Totals Away %SM.Away
  writeini %SMFile Totals Hops %SM.Hops
  %x = 1
  :start1
  if (%SM.Total. [ $+ [ %x ] ] != $null) { writeini %SMFile Total %x %SM.Total. [ $+ [ %x ] ] | inc %x 1 | goto start1 }
  sm.filecheck
}
alias sm.del {
  if (%SMFile == $null) { %SMFile = $scriptdir $+ $$1 $+ .stm }
  if ($exists(%SMFile) == $true) { .remove %SMFile }
  unset %SMFile
  sm.filecheck
}
alias -l percent return $round($calc(($$1 / $$2 ) * 100),2)
alias sm.opendlg {
  if ($dialog(sm.stat) == $null) { dialog -dmn sm.stat sm.dlg }
  if ($getopt(window,status) == big) { dialog -s sm.stat -1 -1 500 380 }
  else { dialog -s sm.stat -1 -1 268 185 }
  did -c sm.stat $iif($sock(statman,1) != $null,126,127)
  sm.showstats
  sm.fillnl
  sm.filecheck
}
alias sm.showstats {
  did -a sm.stat 58 $iif(%SM.Total == $null,0,%SM.Total)
  did -a sm.stat 59 $iif(%SM.ChanOps == $null,0,%SM.ChanOps)
  did -a sm.stat 60 $iif(%SM.NonOps == $null,0,%SM.NonOps)
  did -a sm.stat 61 $iif(%SM.Voiced == $null,0,%SM.Voiced)
  did -a sm.stat 62 $iif(%SM.IRCops == $null,0,%SM.IRCops)
  did -a sm.stat 63 $iif(%SM.Here == $null,0,%SM.Here)
  did -a sm.stat 64 $iif(%SM.Away == $null,0,%SM.Away)
  did -a sm.stat 65 $iif(%SM.Hops == $null,0,%SM.Hops)
  did -a sm.stat 66 %SM.PerChanops $+ $chr(37)
  did -a sm.stat 67 %SM.PerNonOps $+ $chr(37)
  did -a sm.stat 68 %SM.PerVoiced $+ $chr(37)
  did -a sm.stat 69 %SM.PerIRCops $+ $chr(37)
  did -a sm.stat 70 %SM.PerHere $+ $chr(37)
  did -a sm.stat 71 %SM.PerAway $+ $chr(37)
  did -a sm.stat 72 Stats for %SMChannel
}
alias sm.sortnl {
  window -hls @statman.nicklist
  window -hls @statman.nicklist.nonalphanum
  %x = 1
  :start
  if ( [ %SM.Total. [ $+ [ %x ] ] ] != $null) {
    if ($mid( [ %SM.Total. [ $+ [ %x ] ] ] ,1,1) isletter) || ($mid( [ %SM.Total. [ $+ [ %x ] ] ] ,1,1) isnum) || ($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,2,32) == 1) || ($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,3,32) == 1) {
      aline @statman.nicklist $iif($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,3,32) == 1,+) $+ $iif($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,2,32) == 1,@) $+ %SM.Total. [ $+ [ %x ] ]
    }
    else {
      aline @statman.nicklist.nonalphanum $iif($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,3,32) == 1,+) $+ $iif($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,2,32) == 1,@) $+ %SM.Total. [ $+ [ %x ] ]
    }
    inc %x
    goto start
  }
  %x = 1
  :start1
  if ($line(@statman.nicklist,%x) != $null) {
    %SM.Total. [ $+ [ %x ] ] = $remove($line(@statman.nicklist,%x),@,+)
    inc %x
    goto start1
  }
  %x = 1
  :start2
  if ($line(@statman.nicklist.nonalphanum,%x) != $null) {
    %SM.Total. [ $+ [ $calc($line(@statman.nicklist,0) + %x) ] ] = $line(@statman.nicklist.nonalphanum,%x)
    inc %x
    goto start2
  }
  window -c @statman.nicklist
  window -c @statman.nicklist.nonalphanum
}
alias cstats {
  if ($group(#sm.stat).status != on) {
    unset %SM.*
    set %SM.Total 0
    set %SM.ChanOps 0
    set %SM.NonOps 0
    set %SM.IRCops 0
    set %SM.Away 0
    set %SM.Voiced 0
    set %SM.Here 0
    set %SM.Hops 0
    if ($1 == $null) { set %SMChannel $active }
    else { set %SMChannel $1 }
    if (#* !iswm %SMChannel) {
      echo -s 3[StatMan Error]: Unable to retrieve statistics:
      echo -s 3You either typed /cstats while not in a channel or typed /cstats with a
      echo -s 3parameter which is not a valid channel.
      halt
    }
    .enable #sm.stat
    who %SMChannel
  }
}
alias sm.fillnl {
  did -r sm.stat 1
  %x = 1
  :start
  if (%x <= %SM.Total) {
    did -a sm.stat 1 $iif($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,2,32) == 1,@) $+ $iif($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,3,32) == 1,+) $+ $gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,1,32)
    inc %x
    goto start
  }
}
alias sm.filecheck {
  if ($len(%SMFile) > 27) { did -a sm.stat 100 Current file: $nopath(%SMFile) }
  else { did -a sm.stat 100 Current file: $iif(%SMFile != $null,%SMFile,none) }
  did -r sm.stat 104
  %x = 1
  :start
  if ($findfile($scriptdir,*.stm,%x) != $null) {
    did -a sm.stat 104 $remove($gettok($nopath($findfile($scriptdir,*.stm,%x)),$gettok($nopath($findfile($scriptdir,*.stm,%x)),0,92),92),.stm)
    inc %x | goto start
  }
}
; Raw
#sm.stat off
raw 352:*:{
  if ($2 == %SMChannel) {
    inc %SM.Total 1
    set %SM.Total. [ $+ [ %SM.Total ] ] $6 $iif(@ isin $7,1,0) $iif(+ isin $7,1,0) $iif(* isin $7,1,0) $iif(H isin $7,1,0)
    inc %SM.Hops $8
    if (@ isin $7) { inc %SM.ChanOps 1 }
    if (@ !isin $7) { inc %SM.NonOps 1 }
    if (* isin $7) { inc %SM.IRCops 1 }
    if (+ isin $7) { inc %SM.Voiced 1 }
    if (H isin $7) { inc %SM.Here 1 }
    if (G isin $7) { inc %SM.Away 1 }
    halt
  }
}
raw 315:*:{
  if ($2 == %SMChannel) {
    .disable #sm.stat
    %SM.PerChanOps = $percent(%SM.ChanOps,%SM.Total)
    %SM.PerNonOps = $percent(%SM.NonOps,%SM.Total)
    %SM.PerIRCops = $percent(%SM.IRCOps,%SM.Total)
    %SM.PerVoiced = $percent(%SM.Voiced,%SM.Total)
    %SM.PerAway = $percent(%SM.Away,%SM.Total)
    %SM.PerHere = $percent(%SM.Here,%SM.Total)
    %SM.Hops = %SM.Hops / %SM.Total
    %SM.Hops = $iif($len($gettok(%SM.Hops,2,46)) > 3,$round(%SM.Hops,3),%SM.Hops)
    unset %SMFile
    sm.sortnl
    if ($getopt(autorefresh,active) != yes) || (($getopt(autorefresh,active) == yes) && ($dialog(sm.stat) != $null)) { .timer -m 1 1 sm.opendlg }
    else { setopt autorefresh active no }
    halt
  }
}
#sm.stat end
; Events
on 1:load: {
  if ($version < 5.5) { echo 4 -a *** Unable to load StatMan, you must be using at least version 5.5. | unload -rs statman.mrc | halt }
  .timer -m 1 1 sm.welcome
}
alias sm.welcome {
  dialog -m sm.welcome sm.welcome
  did -a sm.welcome 1 Welcome to StatMan99 $+ $crlf
  did -a sm.welcome 1 $crlf
  did -a sm.welcome 1 StatMan99 is optimized for mIRC v5.5 and will not work on any older version. $+ $crlf
  did -a sm.welcome 1 Usage for this script is fairly simple, just type /cstats from any channel. For more info click the "Help" button from StatMan's main window or see $scriptdir $+ smhelp.hlp $+ $crlf
  did -a sm.welcome 1 $crlf
  did -a sm.welcome 1 If you have any questions, please email benh@mirc.org and I will try to get back to you as soon as possible $+ $crlf
  did -a sm.welcome 1 $crlf
  did -a sm.welcome 1 The latest version of StatMan is available from http://mirc.spaceports.com/files/statman.zip
}
on 1:start: {
  if ($getopt(web,status) == on) && ($portfree(80) == $true) {
    socklisten statman 80
    setopt web status on
  }
  .disable #sm.stat
}
on 1:dialog:sm.stat:init:*: {
  did -f sm.stat 155
  if ($getopt(autorefresh,status) == $null) { setopt autorefresh status off }
  if ($getopt(autorefresh,rate) == $null) { setopt autorefresh rate 10 }
  if ($getopt(web,status) == on) { did -c sm.stat 126 | did -u sm.stat 127 }
  else { did -c sm.stat 127 | did -u sm.stat 126 }
  did -a sm.stat 129 $getopt(autorefresh,rate)
  if ($getopt(autorefresh,status) == on) { did -c sm.stat 128 }
  else { did -u sm.stat 128 | did -b sm.stat 129 }
  did -b sm.stat 7 | did -b sm.stat 8 | did -b sm.stat 9 | did -b sm.stat 10
}
on 1:dialog:sm.stat:dclick:*: {
  if ($did == 1) { whois $remove($did(1,$did(1,1).sel),@,+) }
  if ($did == 104) { sm.load }
}
alias -l ginfo {
  %x = 1
  :start
  if ( [ %SM.Total. [ $+ [ %x ] ] ] != $null) {
    if ($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,1,32) == $$1) {
      return $gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,2-,32)
    }
    inc %x
    goto start
  }
  return $null
}
on 1:dialog:sm.stat:sclick:*: {
  if ($did == 1) {
    if ($notify($remove($did(1,$did(1,1).sel),@,+)) != $null) { did -r sm.stat 5 | did -a sm.stat 5 Remove from Notify }
    else { did -r sm.stat 5 | did -a sm.stat 5 Add to Notify }
    set -u0 %sm._temp $ginfo($remove($did(1,$did(1,1).sel),@,+))
    if ($gettok(%sm._temp,1,32) == 1) { did -c sm.stat 7 }
    else { did -u sm.stat 7 }
    if ($gettok(%sm._temp,2,32) == 1) { did -c sm.stat 8 }
    else { did -u sm.stat 8 }
    if ($gettok(%sm._temp,3,32) == 1) { did -c sm.stat 9 }
    else { did -u sm.stat 9 }
    if ($gettok(%sm._temp,4,32) == 1) { did -c sm.stat 10 }
    else { did -u sm.stat 10 }
  }
  if ($did == 101) { sm.save }
  if ($did == 102) && ($did(104,1).sel != $null) { sm.load }
  if ($did == 103) { sm.del %SMChannel }
  if ($did(1,1).sel != $null) {
    if ($did == 2) { whois $remove($did(1,$did(1,1).sel),@,+) }
    if ($did == 3) { uwho $remove($did(1,$did(1,1).sel),@,+) }
    if ($did == 4) { dns $remove($did(1,$did(1,1).sel),@,+) }
    if ($did == 5) {
      notify $iif($notify($remove($did(1,$did(1,1).sel),@,+)) != $null,-r) $remove($did(1,$did(1,1).sel),@,+)
      did -r sm.stat 5
      did -a sm.stat 5 $iif($notify($remove($did(1,$did(1,1).sel),@,+)) != $null,Remove from Notify,Add to Notify)
    }
    if ($did == 6) { query $remove($did(1,$did(1,1).sel),@,+) }
  }
  if ($did == 126) {
    if ($portfree(80) == $false) && ($sock(statman) == $null) { did -u sm.stat 126 | did -c sm.stat 127 | did -f sm.stat 127 | .timer -m 1 1 dialog -mdo sm.webalert sm.webalert }
    elseif ($sock(statman) == $null) { socklisten statman 80 | setopt web status on }
  }
  if ($did == 127) && ($sock(statman).name != $null) { sockclose statman* | setopt web status off }
  if ($did == 128) {
    if ($did(128).state == 0) { sm.setar off | did -b sm.stat 129 }
    if ($did(128).state == 1) { sm.setar on | did -e sm.stat 129 }
  }
  if ($did == 140) && (%SM.Total != $null) && ($did(141).text != $null) {
    did -t sm.stat 140
    .msg $did(141).text 4<>Stats for %SMChannel $+ :
    .msg $did(141).text 4<> Total: $+ %SM.Total ChanOps: $+ %SM.ChanOps $+ ( $+ %SM.PerChanOps $+ $chr(37) $+ ) NonOps: $+ %SM.NonOps $+ ( $+ %SM.PerNonOps $+ $chr(37) $+ ) Voiced: $+ %SM.Voiced $+ ( $+ %SM.PerVoiced $+ $chr(37) $+ ) IRC Ops: $+ %SM.IRCops $+ ( $+ %SM.PerIRCops $+ $chr(37) $+ ) Here: $+ %SM.Here $+ ( $+ %SM.PerHere $+ $chr(37) $+ ) Away: $+ %SM.Away $+ ( $+ %SM.PerAway $+ $chr(37) $+ ) Avg Hops: $+ %SM.Hops $+ 
    .msg $did(141).text 4<>StatMan99 Glitch 1999
  }
  if ($did == 142) { setopt autorefresh active yes | cstats %SMChannel }
  if ($did == 143) { unset %SM.* | unset %SMFile | sm.filecheck | sm.showstats | sm.fillnl }
  if ($did == 154) { smhelp }
  if ($did == 155) { .timer -m 1 1 sm.details }
}
on 1:dialog:sm.stat:edit:129: {
  .timerSM.CHECKAR -m 1 1500 sm.checkar
}
alias sm.checkar {
  if ($did(sm.stat,129).text < 10) || ($did(sm.stat,129) !isnum) { did -r sm.stat 129 | did -a sm.stat 129 10 }
  else { setopt autorefresh rate $did(sm.stat,129).text }
  if ($getopt(autorefresh,status) == on) { sm.setar on }
}
alias sm.setar {
  if ($$1 == on) { .timerSMAR 0 $getopt(autorefresh,rate) sm.ar | setopt autorefresh status on }
  else {
    if ($timer(SMAR) != $null) { .timerSMAR off }
    setopt autorefresh status off
  }
}
alias sm.details {
  if ($getopt(window,status) == $null) { setopt window status big }
  if ($getopt(window,status) == small) {
    did -a sm.stat 155 Details <<
    dialog -s sm.stat -1 -1 500 380
    setopt window status big
  }
  else {
    did -a sm.stat 155 Details >>
    dialog -s sm.stat -1 -1 268 185
    setopt window status small
  }
}
; Dialog table
dialog sm.dlg {
  title "StatMan99"
  size 20 20 0 0

  list 1, 15 205 130 130
  button "Whois", 2, 150 205 103 25
  button "User Central", 3, 150 235 103 25
  button "DNS", 4, 150 265 103 25
  button "Add to Notify", 5, 150 295 103 25
  button "Query", 6, 150 325 103 25
  check "Op", 7, 15 320 55 15
  check "Voiced", 8, 15 335 55 15
  check "IRC Op", 9, 80 320 55 15
  check "Here", 10, 80 335 55 15

  button "Close", 153, 10 158 58 22, cancel
  button "Details <<", 155, 102 158 58 22, default
  button "Help", 154, 200 158 58 22

  text "Total", 50, 25 25 50 15, left
  text "ChanOps", 51, 25 40 50 15, left
  text "NonOps", 52, 25 55 50 15, left
  text "Voiced" 53, 25 70 50 15, left
  text "IRC Ops", 54, 25 85 50 15, left
  text "Here", 55, 25 100 50 15, left
  text "Away", 56, 25 115 50 15, left
  text "Avg. Hops" 57, 25 130 50 15, left
  text " ", 58, 110 25 50 15, left
  text " ", 59, 110 40 50 15, left
  text " ", 60, 110 55 50 15, left
  text " ", 61, 110 70 50 15, left
  text " ", 62, 110 85 50 15, left
  text " ", 63, 110 100 50 15, left
  text " ", 64, 110 115 50 15, left
  text " ", 65, 110 130 50 15, left
  text " ", 66, 190 40 50 15, left
  text " ", 67, 190 55 50 15, left
  text " ", 68, 190 70 50 15, left
  text " ", 69, 190 85 50 15, left
  text " ", 70, 190 100 50 15, left
  text " ", 71, 190 115 50 15, left
  box " ", 72, 10 7 250 145, left

  text "Current file: (none)", 100, 290 25 190 15, left
  button "Save", 101, 425 45 55 25
  button "Load", 102, 425 80 55 25
  button "Delete", 103, 425 115 55 25
  list 104, 290 45 125 110, sort

  text "StatMan99 Web Server:", 125, 285 277 150 15
  radio "On", 126, 295 292 100 15
  radio "Off", 127, 295 307 100 15
  check "Enable Auto Refresh", 128, 285 330 120 15
  edit "", 129, 405 327 30 20, right
  text "secs", 130, 440 330 40 15

  button "Send Stats to:", 140, 275 192 75 22
  edit "", 141, 355 192 130 22
  button "Refresh", 142, 275 222 100 25
  button "Clear", 143, 385 222 100 25

  box "Options", 150, 275 262 215 100
  box "Nick List", 151, 10 187 250 175
  box "File Manager", 152, 275 7 215 145
}
dialog sm.webalert {
  title "Alert"
  size 150 150 300 78
  text "Port 80 is not free. You may be running another web server", 1, 0 10 300 15, center
  text "such as Microsoft FrontPage's personal web server.", 2, 0 25 300 15, center
  button "Ok", 3, 128 45 55 20, default cancel
}
dialog sm.welcome {
  title "Welcome to StatMan99"
  size -1 -1 390 236
  button "Close", 2, 320 200 55 20, cancel, default
  edit "", 1, 5 5 380 190, left, multi, read
}
; Menu
menu channel {
  StatMan99
  .Retrieve stats:/cstats
  .Open StatMan:/.timer -m 1 1 sm.opendlg
}
; Web Server
on *:socklisten:statman: { sockaccept statman $+ $ticks }
on *:sockread:statman*: {
  sockread %temp
  if (%SM.Total == $null) {
    sockwrite $sockname <HTML><HEAD><TITLE>StatMan99 Stat Server</TITLE></HEAD><BODY BGCOLOR=WHITE marginwidth=0 marginheight=0> $+ $crlf
    sockwrite $sockname <H1 ALIGN=CENTER>No stats are currently available</H1></BODY></HTML>
    sockclose $sockname
  }
  elseif ( [ GET /chatstreamoff * ] iswm %temp) {
    sockwrite $sockname <HTML><HEAD></HEAD><BODY BGCOLOR=WHITE marginwidth=0 marginheight=0> $+ $crlf
    sockwrite $sockname <A HREF=/chatstream>Click here to reactivate the chat stream</A> $+ $crlf
    sockwrite $sockname </BODY></HTML> $+ $crlf
    sockclose $sockname
  }
  elseif ( [ GET /chatstream * ] iswm %temp) {
    if ($me ison %SMChannel) {
      sockwrite $sockname <HTML> $+ $crlf
      sockwrite $sockname <HEAD><TITLE>StatMan99 Stat Server: Live chat stream in %SMChannel $+ </TITLE></HEAD> $+ $crlf
      sockwrite $sockname <BODY BGCOLOR=WHITE> $+ $crlf
      sockwrite $sockname <TABLE WIDTH=100%><TD><FONT SIZE=+2>Live Chat Stream from %SMChannel $+ </FONT></TD><TD ALIGN=RIGHT><A HREF=/chatstreamoff>Click here to turn off the chat stream</A></TD></TABLE><HR> $+ $crlf
      sockwrite $sockname <FONT FACE=Fixedsys> $+ $crlf
      sockmark $sockname sendlog:0
    }
    else {
      sockwrite $sockname <HTML> $+ $crlf
      sockwrite $sockname <HEAD><TITLE>StatMan99 Stat Server: Live chat stream in %SMChannel $+ </TITLE></HEAD> $+ $crlf
      sockwrite $sockname <BODY BGCOLOR=WHITE marginwidth=0 marginheight=0> $+ $crlf
      sockwrite $sockname <H1 ALIGN=CENTER>Live Chat Stream Not available</H1> $+ $crlf
      sockclose $sockname
    }
  }
  elseif ( [ GET /header * ] iswm %temp) {
    sockwrite $sockname <script language="javascript"> $+ $crlf
    sockwrite $sockname function showstats() $chr(123) window.open("/stats", "", "height=250,width=200,scrollbars=no,menubar=no,toolbar=no"); $chr(125) $+ $crlf
    sockwrite $sockname </script> $+ $crlf
    sockwrite $sockname <BODY onLoad="showstats();" MARGINWIDTH=0 MARGINHEIGHT=0 BGCOLOR=WHITE> $+ $crlf
    sockwrite $sockname <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=100%><TD> $+ $crlf
    sockwrite $sockname <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 ALIGN=LEFT><TD ALIGN=LEFT> $+ $crlf
    sockwrite $sockname <FORM><INPUT TYPE=BUTTON VALUE="View Stats" onClick="showstats();"></FORM></TD></TABLE> $+ $crlf
    sockwrite $sockname <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 ALIGN=CENTER><TD ALIGN=CENTER> $+ $crlf
    sockwrite $sockname <FONT SIZE=+1>Stats and Live Chat Stream for %SMChannel $+ </FONT> $+ $crlf
    sockwrite $sockname </TD></TABLE></TD></TABLE> $+ $crlf
    sockwrite $sockname <HR><CENTER><B>Topic:</B><BR> $+ $crlf
    sockwrite $sockname $iif($chan(%SMChannel).topic == $null,Not available,$html($chan(%SMChannel).topic)) $+ $crlf
    sockwrite $sockname </CENTER> $+ $crlf
    sockwrite $sockname </BODY> $+ $crlf
    sockclose $sockname
  }
  elseif ( [ GET /nicklist * ] iswm %temp) {
    sockwrite $sockname <BODY MARGINWIDTH=0 MARGINHEIGHT=0><TABLE WIDTH=100% BORDER=1> $+ $crlf
    sockwrite $sockname <TR><TD><B>Nick list<B></TD></TR> $+ $crlf
    %x = 1
    :start1
    if (%SM.Total. [ $+ [ %x ] ] != $null) {
      sockwrite $sockname <TR><TD> $+ $iif($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,4,32) == 1,<B>) $+ $iif($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,5,32) == 0,<FONT COLOR=GRAY>) $+ $iif($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,3,32) == 1,+) $+ $iif($gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,2,32) == 1,@) $+ $gettok( [ %SM.Total. [ $+ [ %x ] ] ] ,1,32) $+ </B></FONT></TD></TR> $+ $crlf
      inc %x 1
      goto start1
    }
    sockwrite $sockname <TR><TD><TABLE BORDER=0> $+ $crlf
    sockwrite $sockname <TR><TD COLSPAN=2><B>Key:</B></TD></TR> $+ $crlf
    sockwrite $sockname <TR><TD>@Nick</TD><TD ALIGN=RIGHT>Op</TD></TR> $+ $crlf
    sockwrite $sockname <TR><TD>+Nick</TD><TD ALIGN=RIGHT>Voiced</TD></TR> $+ $crlf
    sockwrite $sockname <TR><TD><B>BoldNick</B></TD><TD ALIGN=RIGHT>IRC Op</TD></TR> $+ $crlf
    sockwrite $sockname <TR><TD><FONT COLOR=GRAY>GrayNick</FONT></TD><TD ALIGN=RIGHT>Away</TD></TR> $+ $crlf
    sockwrite $sockname </TABLE></TD></TR>
    sockwrite $sockname </TABLE></BODY>
    sockclose $sockname
  }
  elseif ( [ GET / * ] iswm %temp) {
    sockwrite $sockname <html> $+ $crlf
    sockwrite $sockname <head><title>StatMan99 Web Server: %SMChannel $+ </title> $+ $crlf
    sockwrite $sockname <frameset cols=80%,20% noresize> $+ $crlf
    sockwrite $sockname   <frameset rows=35%,*,30 noresize> $+ $crlf
    sockwrite $sockname     <frame src=/header marginheight=0 marginwidth=0 noresize> $+ $crlf
    sockwrite $sockname     <frame src=/chatstream noresize> $+ $crlf
    sockwrite $sockname     <frame src=/footer noresize> $+ $crlf
    sockwrite $sockname   </frameset> $+ $crlf
    sockwrite $sockname   <frame src=/nicklist noresize> $+ $crlf
    sockwrite $sockname </frameset></head> $+ $crlf
    sockwrite $sockname </html> $+ $crlf
    sockclose $sockname
  }
  elseif ( [ GET /footer * ] iswm %temp) {
    sockwrite $sockname <BODY MARGINHEIGHT=0 MARGINWIDTH=0><CENTER><B>This Page Generated by <A TARGET=_top HREF=http://mirc.base.org/>StatMan99</A> ... by <A HREF=mailto:benh@mirc.org>Glitch</A></B></CENTER></BODY> $+ $crlf
    sockclose $sockname
  }
  elseif ( [ GET /stats * ] iswm %temp) {
    sockwrite $sockname <HTML> $+ $crlf
    sockwrite $sockname <HEAD><TITLE>StatMan99 Stat Server: Stats for %SMChannel $+ </TITLE></HEAD> $+ $crlf
    sockwrite $sockname <BODY MARGINWIDTH=0 MARGINHEIGHT=0 BGCOLOR=WHITE> $+ $crlf
    sockwrite $sockname <TABLE WIDTH=100% HEIGHT=100% BORDER=2> $+ $crlf
    sockwrite $sockname <TR><TD><B>Total</B></TD><TD> $+ %SM.Total $+ </TD></TR> $+ $crlf
    sockwrite $sockname <TR><TD><B>ChanOps</B></TD><TD> $+ %SM.ChanOps $+ </TD><TD> $+ %SM.PerChanOps $+ $chr(37) $+ </TD></TR> $+ $crlf
    sockwrite $sockname <TR><TD><B>NonOps</B></TD><TD> $+ %SM.NonOps $+ </TD><TD> $+ %SM.PerNonOps $+ $chr(37) $+ </TD></TR> $+ $crlf
    sockwrite $sockname <TR><TD><B>Voiced</B></TD><TD> $+ %SM.Voiced $+ </TD><TD> $+ %SM.PerVoiced $+ $chr(37) $+ </TD></TR> $+ $crlf
    sockwrite $sockname <TR><TD><B>IRC Ops</B></TD><TD> $+ %SM.IRCops $+ </TD><TD> $+ %SM.PerIRCops $+ $chr(37) $+ </TD></TR> $+ $crlf
    sockwrite $sockname <TR><TD><B>Here</B></TD><TD> $+ %SM.Here $+ </TD><TD> $+ %SM.PerHere $+ $chr(37) $+ </TD></TR> $+ $crlf
    sockwrite $sockname <TR><TD><B>Away</B></TD><TD> $+ %SM.Away $+ </TD><TD> $+ %SM.PerAway $+ $chr(37) $+ </TD></TR> $+ $crlf
    sockwrite $sockname <TR><TD><B>Avg Hops</B></TD><TD COLSPAN=2> $+ %SM.Hops $+ </TD></TR> $+ $crlf
    sockwrite $sockname </TABLE> $+ $crlf
    sockwrite $sockname </BODY>
    sockwrite $sockname </HTML>
    sockclose $sockname
  }
}
alias statweb.sendtoall {
  %x = 1
  :start
  if ($sock(statman*,%x) != $null) {
    if (sendlog* iswm $sock(statman*,%x).mark) {
      %sent = $gettok($sock(statman*,%x).mark,2,58)
      inc %sent $len($$1-)
      sockmark $sock(statman*,%x).name sendlog:: $+ %sent
      sockwrite $sock(statman*,%x).name $$1-
      if (%sent >= 1000) {
        sockmark $sock(statman*,%x).name sendlog::0
        sockwrite $sock(statman*,%x).name <META HTTP-EQUIV="Refresh" CONTENT="0;URL=/chatstream">
        sockclose $sock(statman*,%x).name
      }
    }
    inc %x
    goto start
  }
}
on *:JOIN:%SMChannel:if ($getopt(web,status) == on) { /set %sendto <FONT FACE=Fixedsys COLOR=#008F00> $+ $timestamp *** Joins: $nick ( $+ $address $+ ) $+ </FONT> | /statweb.sendtoall $html(%sendto) }
on *:PART:%SMChannel:if ($getopt(web,status) == on) { /set %sendto <FONT FACE=Fixedsys COLOR=#008F00> $+ $timestamp *** Parts: $nick ( $+ $address $+ ) $+ </FONT> | /statweb.sendtoall $html(%sendto) }
on *:TEXT:*:%SMChannel:if ($getopt(web,status) == on) { /set %sendto $timestamp &lt; $+ $nick $+ &gt; $$1- | /statweb.sendtoall $html(%sendto) }
on *:ACTION:*:%SMChannel:if ($getopt(web,status) == on) && (@#* !iswm $target) { /set %sendto <FONT FACE=Fixedsys COLOR=#9F009F> $+ $timestamp * $nick $$1- $+ </FONT> | /statweb.sendtoall $html(%sendto) }
on *:NICK:if ($getopt(web,status) == on) { /set %sendto <FONT FACE=Fixedsys COLOR=#008F00> $+ $timestamp *** $nick is now known as $newnick $+ </FONT> | /statweb.sendtoall $html(%sendto) }
alias -l html {
  %text = $$1-
  %x = 1
  %boldflag = 0
  %underflag = 0
  :start
  if (%x <= $len(%text)) {
    if ($mid(%text,%x,1) == ) {
      if (%boldflag = 0) { %text = $left(%text,$calc(%x - 1)) $+ <B> $+ $right(%text,$calc($len(%text) - %x)) | %boldflag = 1 }
      else { %text = $left(%text,$calc(%x - 1)) $+ </B> $+ $right(%text,$calc($len(%text) - %x)) | %boldflag = 0 }
    }
    if ($mid(%text,%x,1) == ) {
      if (%underflag = 0) { %text = $left(%text,$calc(%x - 1)) $+ <U> $+ $right(%text,$calc($len(%text) - %x)) | %underflag = 1 }
      else { %text = $left(%text,$calc(%x - 1)) $+ </U> $+ $right(%text,$calc($len(%text) - %x)) | %underflag = 0 }
    }
    inc %x
    goto start
  }
  %face = FACE=Fixedsys
  %text = $replace(%text,0,<FONT %face COLOR=#FFFFFF>,1,<FONT %face COLOR=#000000>,2,<FONT %face COLOR=#00007F>,3,<FONT %face COLOR=#008F00>,4,<FONT %face COLOR=#FF0000>,5,<FONT %face COLOR=#7F0000>,6,<FONT %face COLOR=#9F009F>,7,<FONT %face COLOR=#FF7F00>,8,<FONT %face COLOR=#FFFF00>,9,<FONT %face COLOR=#00FF00>,10,<FONT %face COLOR=#008F8F>,11,<FONT %face COLOR=#00FFFF>,12,<FONT %face COLOR=#0000FF>,13,<FONT %face COLOR=#FF00FF>,14,<FONT %face COLOR=#7F7F7F>,15,<FONT %face COLOR=#CFCFCF>,16,<FONT %face COLOR=#FFFFFF>)
  %text = $replace(%text,,</FONT>)
  %text = <FONT FACE=Fixedsys> $+ %text $+ </FONT>
  ;%text = $remove(%text, [ $chr(44) $+ 0 ] , [ $chr(44) $+ 1 ] , [ $chr(44) $+ 2 ] , [ $chr(44) $+ 3 ] , [ $chr(44) $+ 4 ] , [ $chr(44) $+ 5 ] , [ $chr(44) $+ 6 ] , [ $chr(44) $+ 7 ] , [ $chr(44) $+ 8 ] , [ $chr(44) $+ 9 ] , [ $chr(44) $+ 10 ] , [ $chr(44) $+ 11 ] , [ $chr(44) $+ 12 ] , [ $chr(44) $+ 13 ] , [ $chr(44) $+ 14 ] , [ $chr(44) $+ 15 ] , [ $chr(44) $+ 16 ] )
  if (%boldflag = 1) { %text = %text $+ </B> }
  if (%underflag = 1) { %text = %text $+ </U> }
  %x = 0
  :start1
  if (%x <= 16) {
    %commaN = $chr(44) $+ %x
    %text = $remove(%text,%commaN)
    inc %x
    goto start1
  }
  %text = %text $+ $str(</font>,$calc($count(%text,<font) - $count(%text,</font)))
  %text = %text $+ $str(</b>,$calc($count(%text,<font) - $count(%text,</b)))
  %text = %text $+ $str(</u>,$calc($count(%text,<font) - $count(%text,</u)))
  return $strip(%text) $+ <BR>
}
alias -l getopt { return $readini $scriptdir $+ statman.ini $$1 $$2 }
alias -l setopt { writeini $scriptdir $+ statman.ini $$1- }
