;##########################################################################;
;                                                                          ;
;                              sokoban.mrc 1.2                             ;
;                                                                          ;
; /sokoban [file]    starts a new game                                     ;
; /sokobanl [slot]   loads a saved game                                    ;
;                                                                          ;
;                           tabo@linuxmail.org                             ;
;                    http://www.geocities.com/aircscript/                  ;
;                                                                          ;
;                                tabo - 2000                               ;
;                                                                          ;
;##########################################################################;
;
;
;
ON *:LOAD:{ _sokoban.onload }
alias sokoban {
  if ($_sokoban.badver) { return }
  if ($window(@Sokoban)) {
    window -a @Sokoban
    return
  }
  var %dir = $scriptdir,%found = $findfile(%dir,*.spk,0,1),%file
  if (%found == 0) {
    _sokoban.error No '*.spk' files found in ' $+ %dir $+ '
    return
  }
  if ($1- != $null) { %file = $scriptdir $+ $gettok($nopath($1-),1,46) $+ .spk }
  elseif (%found == 1) { %file = $findfile(%dir,*.spk,1,1) }
  else { %file = $$dialog(_sokobanselectpack,_sokobanl,-4) }
  if ($isfile(%file)) { _sokoban.ikiteru $shortfn(%file) }
  else { _sokoban.error File not found: ' $+ %file $+ ' }
}
alias sokobanl { _sokoban.load $1- }
alias _sokoban.ikiteru {
  if ($isfile($1-) == $false) { return }
  var %id = $_sokoban.readini($1,pack,id),%file = $_sokoban.inifile,%topic = PACK_ $+ %id,%last = $_sokoban.get(last,$1-),%tlevel
  %tlevel = %last
  if (%last == 0) { %tlevel = 1 }
  elseif ($_sokoban.isinvalidlevel($1-,$calc(%last + 1)) == 0) { inc %tlevel }
  _sokoban.startgame %tlevel $1-
}
alias _sokoban.onload {
  if ($_sokoban.badver == 0) { _sokoban.info Loaded sokoban.mrc 1.2 - Type /sokoban to play }
}
alias _sokoban.badver {
  if ($version < 5.7) {
    _sokoban.error Sokoban.mrc needs mIRC 5.7
    _sokoban.unload
    return 1
  }
  var %file = $_sokoban.inifile
  if ($_sokoban.readini(%file,sokoban,blockw) !isnum 5-90) { writeini " $+ %file $+ " sokoban blockw 30 }
  if ($_sokoban.readini(%file,sokoban,blockh) !isnum 5-90) { writeini " $+ %file $+ " sokoban blockh 30 }
  return 0
}
alias _sokoban.error {
  if ($window(@Sokoban)) { titlebar @Sokoban - ERROR: $1- }
  else { echo $colour(ctcp) -eist *** ERROR: $1- }
}
alias _sokoban.info {
  if ($window(@Sokoban)) { titlebar @Sokoban - $1- }
  else { echo $colour(info) -eist *** $1- }
}
alias _sokoban.inifile {
  var %file = $scriptdir $+ sokoban.ini
  %file = $shortfn(%file)
  if ($isfile(%file) == $false) { write -c " $+ %file $+ " }
  return %file
}
alias _sokoban.startgame {
  unset %sokoban.*
  var %level = $1,%file = $2-,%sizew,%sizeh,%i,%line
  if (%level isnum) { %level = l $+ %level }
  if ($_sokoban.isinvalidlevel(%file,%level)) { return }

  _sokoban.loadblocksize
  %sokoban.file = %file
  %sokoban.level = %level
  %sokoban.moves = 0
  %sokoban.oldmoves = 0
  %sokoban.id = $_sokoban.readini(%file,pack,id)
  if ($_sokoban.get(best,%sokoban.id,%level)) { %sokoban.best = $ifmatch }
  else { %sokoban.best = N/A }

  %sizew = $_sokoban.readini(%file,%level,sizew)
  %sizeh = $_sokoban.readini(%file,%level,sizeh)
  if ($window(@Sokoban)) { titlebar @Sokoban $chr(35) $+ $remove(%sokoban.level,l) - Loading... }
  %i = 1
  while (%i <= %sizeh) {
    %line = $_sokoban.readini(%file,%level,$base(%i,10,10,2))
    %sokoban.map = %sokoban.map $+ , $+ %line
    inc %i
  }
  if (,* iswm %sokoban.map) { %sokoban.map = $right(%sokoban.map,-1) }
  _sokoban.drawin c Loading...
}
alias _sokoban.youwin {
  var %newlevel = $calc($remove(%sokoban.level,l) + 1)
  if (%sokoban.cheat) { }
  elseif (%sokoban.id != $null) && ((%sokoban.best !isnum) || (%sokoban.moves < %sokoban.best)) {
    writeini " $+ $_sokoban.inifile $+ " PACK_ $+ %sokoban.id last $remove(%sokoban.level,l)
    writeini " $+ $_sokoban.inifile $+ " PACK_ $+ %sokoban.id %sokoban.level %sokoban.moves
  }
  if ($_sokoban.isinvalidlevel(%sokoban.file,%newlevel)) {
    _sokoban.exit
    _sokoban.info Well done! You have finished this Sokoban pack!
  }
  else { _sokoban.startgame %newlevel %sokoban.file }
}
alias _sokoban.titlebar { titlebar @Sokoban $chr(35) $+ $remove(%sokoban.level,l) - Moves: %sokoban.moves - Best: %sokoban.best }
alias _sokoban.undo  {
  var %win = @Sokoban
  if ($window(%win)) && (%sokoban.oldmap) {
    %sokoban.moves = %sokoban.oldmoves
    %sokoban.map = %sokoban.oldmap
    unset %sokoban.oldmap
    _sokoban.drawin _ Undoing...
  }
  else { beep 1 }
}
alias _sokoban.drawin {
  _sokoban.loadblocksize
  var %win = @Sokoban,%file = %sokoban.file,%level = %sokoban.level,%map = %sokoban.map,%i,j,%curr,%blockw = $_sokoban.get(blockw),%blockh = $_sokoban.get(blockh),%winw = $calc($_sokoban.readini(%file,%level,sizew) * %blockw),%winh = $calc($_sokoban.readini(%file,%level,sizeh) * %blockh),%sizew,%sizeh,%i,%j,%winxy = 10 10,%comment
  if ($window(%win)) { %winxy = $window(%win).x $window(%win).y }
  window -adfkp +elt %win %winxy %winw %winh %win
  if (c isin $1) { clear %win }
  %sizew = $len($gettok(%map,1,44))
  %sizeh = $numtok(%map,44)
  if ($2- != $null) { %comment = - $ifmatch }
  titlebar %win $chr(35) $+ $remove(%sokoban.level,l) %comment
  %i = 1
  while (%i <= %sizeh) {
    %j = 1
    while (%j <= %sizew) {
      _sokoban.drawbox %j %i $mid($gettok(%map,%i,44),%j,1)
      inc %j
    }
    inc %i
  }
  drawdot %win
  _sokoban.titlebar
}
alias _sokoban.drawbox {
  var %blockw = $_sokoban.get(blockw),%blockh = $_sokoban.get(blockh),%color,%file,%xywh = $calc(($1 - 1) * %blockw) $calc(($2 - 1) * %blockh) %blockw %blockh
  if ($3 isin w0123) { %file = $scriptdir $+ sokoban_ $+ $3 $+ .bmp }
  elseif ($3 isin 45) { %file = $scriptdir $+ sokoban_m.bmp }
  if ($3 == 0) { %color = 16711680 }
  elseif ($3 == 1) { %color = 65280 }
  elseif ($3 == 2) { %color = 65535 }
  elseif ($3 == 3) { %color = 255 }
  elseif ($3 isin 45) { %color = 16744703 }
  elseif ($3 == w) { %color = 13158600 }
  else { %color = 000000 }
  if ($isfile(%file)) { drawpic -cns @Sokoban %xywh " $+ %file $+ " }
  else { drawrect -fnr @Sokoban %color 1 %xywh }
}
alias _sokoban.loadblocksize {
  var %file = $_sokoban.inifile
  %sokoban.blockw = $_sokoban.readini(%file,sokoban,blockw)
  %sokoban.blockh = $_sokoban.readini(%file,sokoban,blockh)
}
alias _sokoban.get {
  if ($1 == blockw) { return %sokoban.blockw }
  if ($1 == blockh) { return %sokoban.blockh }
  if ($1 == best) {
    var %id = $2,%level = $3,%topic = PACK_ $+ %id,%best
    if (%level isnum) { %level = l $+ %level }
    %best = $round($_sokoban.readini($_sokoban.inifile,%topic,%level),0)
    if (%best !isnum) || (%best <= 0) { %best = 0 }
    return %best
  }
  if  ($1 == last) {
    var %file = $2,%id = $_sokoban.readini(%file,pack,id),%topic = PACK_ $+ %id,%last
    %last = $round($_sokoban.readini($_sokoban.inifile,%topic,last),0)
    if (%last !isnum) || (%last <= 0) { %last = 0 }
    return %last
  }
}
alias _sokoban.getblock {
  var %x = $1,%y = $2,%map = %sokoban.map
  if ($mid($gettok(%map,%y,44),%x,1) != $null) { return $ifmatch }
  return -
}
alias _sokoban.setblock {
  var %x = $1,%y = $2,%map = %sokoban.map,%tok
  if (%map == $null) { return }
  %tok = $gettok(%map,%y,44)
  %tok = $left(%tok,$calc(%x - 1)) $+ $3 $+ $right(%tok,$calc(%x * -1))
  %sokoban.map = $puttok(%map,%tok,%y,44)
}
alias _sokoban.move {
  var %map = %sokoban.map,%cman = $iif(4 isin %map,4,5),%many,%manx,%tok,%r1x,%r1y,%r2x,%r2y,%wr1,%wr2,%tmp1,%tmp2,%tmpm,%movedblock = 0
  %many = $findtok(%map,$matchtok(%map,%cman,1,44),1,44)
  %tok = $gettok(%map,%many,44)
  %manx = $pos(%tok,%cman,1)
  if ($1 == 4) { var %r1x = $calc(%manx - 1),%r1y = %many,%r2x = $calc(%manx - 2),%r2y = %many }
  if ($1 == 8) { var %r1x = %manx,%r1y = $calc(%many - 1),%r2x = %manx,%r2y = $calc(%many - 2) }
  if ($1 == 6) { var %r1x = $calc(%manx + 1),%r1y = %many,%r2x = $calc(%manx + 2),%r2y = %many }
  if ($1 == 2) { var %r1x = %manx,%r1y = $calc(%many + 1),%r2x = %manx,%r2y = $calc(%many + 2) }
  %wr1 = $_sokoban.getblock(%r1x,%r1y)
  %wr2 = $_sokoban.getblock(%r2x,%r2y)
  if (%wr1 == $null) || (%wr1 isin -W) { beep 1 }
  elseif (%wr1 isin 23) {
    if (%wr2 == $null) || (%wr2 isin -w23) { beep 1 }
    else {
      %movedblock = 1
      %tmp2 = $iif($_sokoban.getblock(%r2x,%r2y) == 1,3,2)
      %tmp1 = $iif($_sokoban.getblock(%r1x,%r1y) == 3,5,4)
      %sokoban.oldmoves = %sokoban.moves
      inc %sokoban.moves
      _sokoban.setblock %r2x %r2y %tmp2
      _sokoban.drawbox %r2x %r2y %tmp2
    }
  }
  else {
    %movedblock = 1
    %sokoban.oldmoves = %sokoban.moves
    %tmp1 = $iif($_sokoban.getblock(%r1x,%r1y) == 1,5,4)
  }
  if (%movedblock) {
    %sokoban.oldmap = %map
    %tmpm = $iif($_sokoban.getblock(%manx,%many) == 5,1,0)
    _sokoban.setblock %r1x %r1y %tmp1
    _sokoban.drawbox %r1x %r1y %tmp1
    _sokoban.setblock %manx %many %tmpm
    _sokoban.drawbox %manx %many %tmpm
    drawdot @Sokoban
  }
  _sokoban.titlebar
  if (1 !isin %sokoban.map) && (5 !isin %sokoban.map) { _sokoban.youwin }
}
ON *:KEYDOWN:@Sokoban:37,38,39,40,65,87,68,83:{
  if ($mouse.key & 2) {
    if ($keyval == 83) { .timer -o 1 0 _sokoban.save }
    if ($keyval == 68) { _sokoban.redraw }
  }
  else { _sokoban.move $replace($keyval,37,4,38,8,39,6,40,2,65,4,87,8,68,6,83,2) }
}
ON *:KEYUP:@Sokoban:85,90:{
  if ($mouse.key & 2) { _sokoban.undo }
}
ON *:KEYUP:@Sokoban:82:{
  if ($mouse.key & 2) { _sokoban.retry }
}
ON *:KEYUP:@Sokoban:76:{
  if ($mouse.key & 2) { .timer -o 1 0 _sokoban.load }
}
ON *:KEYUP:@Sokoban:74:{
  if ($mouse.key & 2) { .timer -o 1 0 _sokoban.changelevel }
}
ON *:KEYUP:@Sokoban:81,88:{
  if ($mouse.key & 2) { _sokoban.exit }
}
ON *:KEYUP:@Sokoban:65:{
  if ($mouse.key & 2) { .timer -o 1 0 _sokoban.about }
}
ON *:KEYUP:@Sokoban:67:{
  if ($mouse.key & 2) { .timer -o 1 0 _sokoban.cheat }
}
ON *:CLOSE:@Sokoban:{ unset %sokoban.* }
; returns 0 if valid pack
alias _sokoban.isinvalidpack {
  var %file = $1-,%nlevel,%level,%tmp,%id
  if ($isfile(%file) == $false) { return ERR_NOFILE }
  if ($_sokoban.readini(%file,pack,desc) == $null) { return ERR_NOPACKDESC }
  %id = $_sokoban.readini(%file,pack,id)
  if (%id == $null) || (%id == mainsettings) { return ERR_BAD_ID }
  %tmp = $_sokoban.isinvalidlevel(%file,l1)
  if (ERR* iswm %tmp) { return FIRSTLEVEL %tmp }
  return 0
}
; returns 0 if valid level
alias _sokoban.isinvalidlevel {
  var %file = $1,%level = $2,%sizew,%sizeh,%i,%line,%blank = 0,%floor = 0,%wall = 0,%box = 0,%socket = 0,%man = 0,%id
  if (%level isnum) { %level = l $+ %level }
  if ($isfile(%file) == $false) { return ERR_NOFILE }
  if ($_sokoban.readini(%file,pack,desc) == $null) { return ERR_NOPACKDESC }
  %id = $_sokoban.readini(%file,pack,id)
  if (%id == $null) || (%id == mainsettings) { return ERR_BAD_ID }
  %sizew = $_sokoban.readini(%file,%level,sizew)
  %sizeh = $_sokoban.readini(%file,%level,sizeh)
  if (%sizew == $null) { return ERR_NOSIZEW }
  if (%sizeh == $null) { return ERR_NOSIZEH }
  if (%sizew !isnum) || (%sizew < 4) || (%sizew > 20) { return ERR_INVALIDSIZEW }
  if (%sizeh !isnum) || (%sizeh < 4) || (%sizeh > 20) { return ERR_INVALIDSIZEH }
  %i = 01
  while (%i <= %sizeh) {
    %line = $_sokoban.readini(%file,%level,%i)
    if ($len(%line) != %sizew) { return ERR_INVALIDROWSIZE %i }
    if ($remove(%line,0,1,2,3,4,5,W,-) != $null) { return ERR_INVALIDROW %i }
    if ($count(%line,-)) { inc %blank $ifmatch }
    if ($count(%line,W)) { inc %wall $ifmatch }
    if ($count(%line,0)) { inc %floor $ifmatch }
    if ($count(%line,1)) { inc %socket $ifmatch }
    if ($count(%line,2)) {
      inc %box $ifmatch
      inc %floor $ifmatch
    }
    if ($count(%line,3)) {
      inc %box $ifmatch
      inc %socket $ifmatch
    }
    if ($count(%line,4)) {
      inc %man $ifmatch
      inc %floor $ifmatch
    }
    if ($count(%line,5)) {
      inc %man $ifmatch
      inc %socket $ifmatch
    }
    inc %i
    %i = $base(%i,10,10,2)
  }
  if (%floor < 3) { return ERR_INVALIDFLOOR }
  if (%wall < 10) { return ERR_INVALIDWALL }
  if (%box == 0) { return ERR_NOBOXES }
  if (%socket == 0) { return ERR_NOSOCKETS }
  if (%socket > %box) { return ERR_INSUFFICIENTSOCKETS }
  if (%man == 0) { return ERR_NOMAN }
  if (%man > 1) { return ERR_CLONES }
  return 0
}
alias _sokoban.readini { return $readini -n " $+ $1 $+ " $2 $3 }
alias _sokoban.redraw { _sokoban.drawin _ Redrawing... }
alias _sokoban.retry { _sokoban.startgame %sokoban.level %sokoban.file }
alias _sokoban.changelevel {
  var %max = $_sokoban.get(last,%sokoban.file),%level
  if ($_sokoban.isinvalidlevel(%sokoban.file,$calc(%max + 1)) == 0) { inc %max }
  %level = $round( [ $$?="Jump to level: (1- $+ [ %max ] $+ )" ] ,0)
  if (%level isnum) && (%level >= 1) && (%level <= %max) { _sokoban.startgame %level %sokoban.file }
}
alias _sokoban.exit {
  unset %sokoban.*
  window -c @Sokoban
}
alias _sokoban.load {
  if ($_sokoban.badver) { return }
  var %slot
  if ($1 isnum 1-10) { %slot = $1 }
  else { %slot = $_sokoban.selectsavegameslot(0) }
  var %file = $_sokoban.inifile,%topic = SAVE_ $+ %slot
  if ($_sokoban.isvalidslot(%slot)) {
    unset %sokoban.*
    _sokoban.loadblocksize
    %sokoban.file = $scriptdir $+ $_sokoban.readini(%file,%topic,file)
    %sokoban.level = $_sokoban.readini(%file,%topic,level)
    %sokoban.id = $_sokoban.readini(%file,%topic,id)
    %sokoban.moves = $_sokoban.readini(%file,%topic,moves)
    %sokoban.oldmoves = $_sokoban.readini(%file,%topic,oldmoves)
    %sokoban.map = $_sokoban.readini(%file,%topic,map)
    %sokoban.oldmap = $_sokoban.readini(%file,%topic,oldmap)
    if ($_sokoban.get(best,%sokoban.id,%sokoban.level)) { %sokoban.best = $ifmatch }
    else { %sokoban.best = N/A }
    _sokoban.drawin c Loading...
  }
}
alias _sokoban.save {
  var %slot = $_sokoban.selectsavegameslot(1),%file = $_sokoban.inifile,%wini = writeini " $+ %file $+ " SAVE_ $+ %slot
  remini " $+ %file $+ " SAVE_ $+ %slot
  %wini file $nopath(%sokoban.file)
  %wini level %sokoban.level
  %wini id %sokoban.id
  %wini moves %sokoban.moves
  %wini map %sokoban.map
  if (%sokoban.oldmap != $null) { %wini oldmap %sokoban.oldmap }
  if (%sokoban.oldmoves) { %wini oldmoves %sokoban.oldmoves }
  flushini " $+ %file $+ "
  _sokoban.info Saved game in slot %slot
}
alias _sokoban.isvalidslot {
  var %slot = $1,%file = $_sokoban.inifile,%topic = SAVE_ $+ %slot,%pfile = $scriptdir $+ $_sokoban.readini(%file,%topic,file),%level = $remove($_sokoban.readini(%file,%topic,level),l),%id = $_sokoban.readini(%file,%topic,id),%moves = $_sokoban.readini(%file,%topic,moves),%oldmoves = $_sokoban.readini(%file,%topic,oldmoves),%map = $_sokoban.readini(%file,%topic,map),%oldmap = $_sokoban.readini(%file,%topic,oldmap)
  %pfile = $shortfn(%pfile)
  if ($isfile(%pfile) == $false) { return 0 }
  if (%id != $_sokoban.readini(%pfile,pack,id)) { return 0 }
  if ($_sokoban.isvalidmap(%map) == 0) { return 0 }
  if (%oldmap != $null) && ($_sokoban.isvalidmap(%oldmap) == 0) { return 0 }
  return 1
}
alias _sokoban.isvalidmap {
  var %man = 0,%slots = 0,%boxes = 0
  if ($1- == $null) { return 0 }
  if ($left($1-,1) == $chr(44)) || ($right($1-,1) == $chr(44)) { return 0 }
  if ($remove($1-,$chr(44),-,w,0,1,2,3,4,5) != $null) { return 0 }
  if ($count($1-,5)) {
    inc %man $ifmatch
    inc %slots $ifmatch
  }
  if ($count($1-,4)) { inc %man $ifmatch }
  if ($count($1-,3)) {
    inc %boxes $ifmatch
    inc %slots $ifmatch
  }
  if ($count($1-,2)) { inc %boxes $ifmatch }
  if ($count($1-,1)) { inc %slots $ifmatch }
  if (%man != 1) || (%slots == 0) || (%slots > %boxes) { return 0 }
  return 1
}
alias _sokoban.selectsavegameslot {
  set -u %sokoban.loadsave $iif($1,Save,Load)
  return $$dialog(_sokobanloadsave,_sokobanl,-4)
}
menu status,menubar {
  sokoban
  .&new game:{ sokoban }
  .&load game:{ sokobanl }
  .-
  .&about:{ _sokoban.about }
  .&unload:{
    if ($$?!="Unload Sokoban 1.2?" == $true) { _sokoban.unload }
  }
}
menu @Sokoban {
  $iif(%sokoban.oldmap,&undo	ctrl+z):{ _sokoban.undo }
  -
  &load	ctrl+l:{ _sokoban.load }
  &save	ctrl+s:{ _sokoban.save }
  -
  &retry	ctrl+r:{ _sokoban.retry }
  &jump	ctrl+j:{ _sokoban.changelevel }
  $iif($_sokoban.cheat,&cheat	ctrl+c):{ _sokoban.cheat }
  re&draw	ctrl+d:{ _sokoban.redraw }
  -
  &about	ctrl+a:{ _sokoban.about }
  e&xit	ctrl+x:{ _sokoban.exit }
}
alias _sokoban.cheat {
  var %cheat = $_sokoban.readini(%sokoban.file,%sokoban.level,cheat),%pre
  if (%cheat == $null) { return }
  if ($isid) { return 1 }
  %pre = $$?!="To cheat, you must restart this level. $+ $crlf $+ Restart?"
  if (%pre) {
    _sokoban.startgame %sokoban.level %sokoban.file
    %sokoban.cheat = 1
    var %i = 1,%n = $len(%cheat)
    while (%i <= %n) {
      _sokoban.move $mid(%cheat,%i,1)
      inc %i
    }
  }
}
dialog _sokobanl {
  option type dbu
  size -1 -1 170 110
  title "Sokoban"

  list 1005,10 10 150 75
  button "",1001,50 90 30 15,ok
  button "&Cancel",1002,90 90 30 15,cancel
  edit "",2001,100 100 100 100,autohs hide result
}
ON *:DIALOG:_sokobanloadsave:*:*:{
  if ($devent == init) {
    var %i = 1,%d = $dname,%tmp = %sokoban.loadsave,%file = $_sokoban.inifile,%topic
    dialog -t %d Sokoban - %tmp game
    did -o %d 1001 1 & $+ %tmp
    while (%i <= 10) {
      if ($_sokoban.isvalidslot(%i)) {
        %topic = SAVE_ $+ %i
        did -o %d 1005 %i %i $+ . Pack: $_sokoban.readini(%file,%topic,id) - Level: $remove($_sokoban.readini(%file,%topic,level),l)
      }
      else { did -o %d 1005 %i %i $+ . [empty slot] }
      inc %i
    }
  }
  elseif (($devent == dclick) && ($did == 1005)) || (($devent == sclick) && ($did == 1001)) {
    var %n = $did($dname,1005).sel,%line = $gettok($did($dname,1005,%n),2-,32)
    if (%n) && ((%line != [empty slot]) || (save isin $dialog($dname).title)) {
      did -o $dname 2001 1 %n
      dialog -k $dname
    }
    else {
      beep 1
      halt
    }
  }
}
ON *:DIALOG:_sokobanselectpack:*:*:{
  if ($devent == init) {
    var %i = 1,%d = $dname,%file
    dialog -t %d Sokoban - Select Pack
    did -o %d 1001 1 &Start
    while (1) {
      %file = $findfile($scriptdir,*.spk,%i,1)
      if (%file == $null) { return }
      if ($_sokoban.isinvalidpack(%file) == 0) { did -a $dname 1005 $_sokoban.readini(%file,pack,desc) < $+ $nopath(%file) $+ > }
      inc %i
    }
  }
  elseif (($devent == dclick) && ($did == 1005)) || (($devent == sclick) && ($did == 1001)) {
    var %n = $did($dname,1005).sel,%file = $scriptdir $+ $remove($gettok($did($dname,1005,%n),-1,$asc(<)),>)
    if (%n) && (%file != $null) {
      did -o $dname 2001 1 %file
      dialog -k $dname
    }
    else {
      beep 1
      halt
    }
  }
}
alias _sokoban.about {
  if ($_sokoban.badver) { return }
  if ($dialog(_sokoban.about)) { dialog -v _sokoban.about }
  else { return $dialog(_sokoban.about,$iif($version >= 5.71,_sokoban.about,_sokoban.aboutold),-4) }
}
dialog _sokoban.about {
  size -1 -1 168 85
  title "About sokoban.mrc"
  option type dbu

  icon 1,8 5 20 20
  text "",2,30 5 95 50
  icon 7,130 5 32 35
  link "http://www.geocities.com/aircscript/",51,25 55 175 15
  link "tabo@linuxmail.org",52,45 68 90 15
  button "&Author!",53,133 43 26 11
  button "",230,50 50 33 15,cancel hide
  edit "",249,125 85 33 15,hide
  edit "",250,125 85 33 15,hide
}
dialog _sokoban.aboutold {
  size -1 -1 168 85
  title "About sokoban.mrc"
  option type dbu

  icon 1,8 5 20 20
  text "",2,30 5 95 50
  icon 7,130 5 32 35
  text "http://www.geocities.com/aircscript/",51,25 55 175 15
  text "tabo@linuxmail.org",52,45 68 90 15
  button "&Author!",53,133 43 26 11
  button "",230,50 50 33 15,cancel hide
  edit "",249,125 85 33 15,hide
  edit "",250,125 85 33 15,hide
}
ON *:DIALOG:_sokoban.about:init:0:{
  var %file = $scriptdir $+ sokoban_2.bmp
  did -a $dname 2 sokoban.mrc 1.2 $+ $crlf $+ Game for mIRC v5.7x $+ $crlf $crlf $+ Copyright  2000 tabo Co. Ltd $+ $crlf $+ $crlf $+ Written by tabo $+ $crlf $+ Graphics and levels by Jeng Long Jiang
  did -o $dname 249 1 1
  if ($isfile(%file)) { did -g $dname 1 %file }
  _sokoban.about.photo
}
ON *:DIALOG:_sokoban.about:sclick:7:{ _sokoban.about.photo }
ON *:DIALOG:_sokoban.about:sclick:53:{ _sokoban.about.photo }
alias _sokoban.about.photo {
  var %d = _sokoban.about,%file,%tmp
  if ($dialog(%d)) {
    %tmp = $did(%d,249,1)
    %file = $scriptdir $+ $iif(%tmp,sokoban_a.jpg,sokoban_m.bmp)
    did -o $dname 249 1 $iif(%tmp,0,1)
    if ($version <= 5.71) { %file = $scriptdir $+ sokoban_m.bmp }
    if ($isfile(%file)) { did -g %d 7 %file }
  }
}
alias _sokoban.unload {
  %sokoban.i = $dialog(0)
  :loop
  if (%sokoban.i) {
    %sokoban.d = $dialog(%sokoban.i)
    if (_sokoban.* iswm %sokoban.d) { dialog -c %sokoban.d }
    dec %sokoban.i
    goto loop
  }
  unset %sokoban.*
  window -c @Sokoban
  _sokoban.info Unloaded sokoban.mrc 1.2
  .timer -o 1 0 .unload -rs " $+ $script $+ "
}
