; SloMP3 v3.5
; by Sloloem
; (C) 1998-2000 Punksoft Inc.

;on *:action:*:#: /whois $nick

menu channel,nicklist,status {
  -
  SloMP3
  .MP3 functions  
  ..play MP3: /playmp3

  ..display options: /dispoption

  ..quick options 
  ...silent play(mp3)
  ....on: /set %silent.mp3 on
  ....off: /set %silent.mp3 off
  ...extended info
  ....on: /set %extended.mp3.t on
  ....off: /set %extended.mp3.t off

  ..display about: /dispabout

  ..playlist functions
  ...Play M3U: /play.m3u

  ...make M3U or other playlist: /make.playlist

  ..Repeat
  ...Repeats last MP3 played: /repeat.mp3

  ..ADVERTISE: /describe $chan is using SloMP3 v3.5
}
on *:START: /.timerpdcc 0 20 /.pdcc 2147483647
on *:LOAD: { 
  load -rs zc-ss2.mrc
  /disp.options
  echo $active 12 Thank you for loading SloMP3 v3.0 
}
ctcp *:!mp3 *:*: {
  /dcc send $nick " $+ $2- $+ .mp3 "
}

#Autoplayrecieve off
on 1:FILERCVD:*.mp*:  /run  %mp3.player $filename
#Autoplayrecieve end

alias repeat.mp3 {
  run " $+ %mp3.player $+ " " $+ %previous.mp3 $+ "
} 
alias playmp3 {
  %mp3.dir1 = %mp3.dir $+ *.mp3
  set %mp3 $dir="Mp3, the file you want to play" %mp3.dir1
  if ( %mp3 == $null ) { HALT }
  run " $+ %mp3.player $+ " " $+ %mp3 $+ "
  if ( %silent.mp3 == on ) {
    if ( %extended.mp3.t == on ) {
      if ( $id3.song(1,%mp3) == $null ) { echo no artist in ID3 data }
      else {
        echo Artist: $id3.song(1,%mp3)
      }
      if ( $id3.song(2,%mp3) == $null ) { echo no title in ID3 data }
      else {
        echo Title: $id3.song(2,%mp3)
      }
      if ( $id3.song(3,%mp3) == $null ) { echo no album in ID3 data }
      else {
        echo Album: $id3.song(3,%mp3)
      }
      if ( $id3.song(4,%mp3) == $null ) { echo no year in ID3 data }
      else {
        echo Year: $id3.song(4,%mp3)
      }
      if ( $id3.song(5,%mp3) == $null ) { echo no genre in ID3 data }
      else {
        echo Genre $id3.song(5,%mp3)
      }
      echo Size: $round($calc($lof(%mp3)/ 1050024),2) $+ MB
      echo Length: $slo.duration($duration($song.length(%mp3)))
      echo Bitrate: $mpegbitrate(%mp3) Kbps
      echo Quality: $stereo.mono(%mp3)
    }
    else {
      echo 15<10{12[2 $+ $id3.title(%mp3) <> $round($calc($lof(%mp3)/ 1050024),2) $+ MB <> $slo.duration($duration($song.length(%mp3))) $+ 12]10}15>
    }
    %previous.mp3 = %mp3
    /set %mp3.dir $nofile(%mp3)
  }
  else {
    msg $chan 15<10{12[2 $+ $id3.title(%mp3) <> $round($calc($lof(%mp3)/ 1050024),2) $+ MB <> $slo.duration($duration($song.length(%mp3))) $+ 12]10}15>
    %previous.mp3 = %mp3
    /set %mp3.dir $nofile(%mp3)
  }
}
alias slo.duration {
  set %laa $1-
  set %laa $replace(%laa,hrs,$chr($asc(:)))
  set %laa $replace(%laa,hr,$chr($asc(:)))
  set %laa $replace(%laa,mins,$chr($asc(:)))
  set %laa $replace(%laa,min,$chr($asc(:)))
  set %laa $remove(%laa,secs)
  set %laa $remove(%laa,sec)
  if ( $numtok(%laa,32) == 1 ) { set %laa $instok(%laa,0:,1,32) }
  if ( $len($gettok(%laa,2,32)) == 1 ) { set %laa $instok(%laa,0,2,32) }
  set %laa $remove(%laa,$chr(32))
  return %laa
}
alias play.m3u { 
  if (%mp3.player == $null) { set %mp3.player $dir="Mp3 Player EX. Winamp" $mircdir\*.exe }
  %mp3.dir1 = %mp3.dir $+ \ $+ *.m3u
  set %m3u $dir="M3u, the playlist you want to play" %mp3.dir1
  run " $+ %mp3.player $+ " " $+ %m3u $+ "
  set %realname $remove($nopath(%m3u),$right($nopath(%m3u),4))
  msg $chan 15<10{12[2 $+ %realname <> $m3uinfo(%m3u) $+ 12]10}15>
}

alias m3uinfo {
  set %m3u.temp $read -nl1 $1-
  if ( %m3u.temp == #EXTM3U ) { 
    unset %ext.*
    set %ext.cyc $lines($1-)
    inc %ext.cyc
    goto extloop 
  }
  else { return $lines($1-) }
  :extloop
  if ( %ext.cyc == 1 ) { return %ext.files files <> $round($calc(%ext.size / 1050024),2) $+ MB <> $slo.duration($duration(%ext.secs)) | halt }
  dec %ext.cyc
  set %ext.temp $read -nl $+ %ext.cyc $1-
  if ( #EXT isin %ext.temp ) { goto extloop }
  elseif ( #EXT !isin %ext.temp ) { 
    inc %ext.files
    inc %ext.size $lof($m3u)
    inc %ext.secs $song.length($m3u)
    goto extloop 
  }
}

alias m3u {
  set %m3u.1 $nofile(%m3u)
  set %m3u.2 $read -nl $+ %ext.cyc %m3u
  return %m3u.1 $+ %m3u.2
}
alias make.playlist {
  /set %plname $$?="type the name for the playlist"
  if ( %m3u.dir == $null ) { set %m3u.dir $sdir="directory where m3u will be saved" $mircdir }
  elseif ( %m3u.dir !== $null ) { goto cont }
  :cont {
    /write %m3u.dir $+ \ $+ %plname $+ .m3u $dir="select a file to add"  %mp3.dir
    /set %more $?!="do you want to add another file?"
    if ( %more == $true ) { goto cont }
    elseif ( %more == $false ) { HALT }
  }
}
alias stereo.mono {
  set %tmp.slomp3.mp3.bitrate $read -nl1 $1-
  if ( $mid(%tmp.slomp3.mp3.bitrate,3,1) == $null ) { return Quality : N/A }
  if ( $pos(%tmp.slomp3.mp3.bitrate,$chr(255),1) == 1 ) {
    if (($chr(255) $+ $chr(250) isin %tmp.slomp3.mp3.bitrate) || ($chr(255) $+ $chr(251) isin %tmp.slomp3.mp3.bitrate) || ($chr(255) $+ $chr(253) isin %tmp.slomp3.mp3.bitrate) || ($chr(255) $+ $chr(227) isin %tmp.slomp3.mp3.bitrate) || ($chr(255) $+ $chr(242) isin %tmp.slomp3.mp3.bitrate) || ($chr(255) $+ $chr(243) isin %tmp.slomp3.mp3.bitrate) || ($chr(255) $+ $chr(253) isin %tmp.slomp3.mp3.bitrate)) {
      if $asc($mid(%tmp.slomp3.mp3.bitrate,4,1)) isnum 192-196 { return -mono- }
      else { return stereo }
    }
  }
  return stereo
}

alias mpegbitrate {
  set %tmp.slomp3.mp3.bitrate $read -nl1 $1-
  if ($mid(%tmp.slomp3.mp3.bitrate,3,1) == $null) { return N/A }
  if ($left(%tmp.slomp3.mp3.bitrate,1) == $chr(255)) {
    if (($chr(255) $+ $chr(250) isin %tmp.slomp3.mp3.bitrate) || ($chr(255) $+ $chr(251) isin %tmp.slomp3.mp3.bitrate)) { goto BR2 }
    if ($chr(255) $+ $chr(242) isin %tmp.slomp3.mp3.bitrate) {
      set %tmp.slomp3.mp3.bitrate $asc($mid(%tmp.slomp3.mp3.bitrate,2,1)) 
      set %tmp.slomp3.mp3.bitrate $calc((%tmp.slomp3.mp3.bitrate - (%tmp.slomp3.mp3.bitrate % 32)) / 2)
      return %tmp.slomp3.mp3.bitrate
    }
    else { goto BR1 }
  }
  elseif (riff isin %tmp.slomp3.mp3.bitrate) { return 128 }
  elseif (http isin %tmp.slomp3.mp3.bitrate) { return 128 }
  elseif (mime-version isin %tmp.slomp3.mp3.bitrate) { return 128 }
  :BR1
  if ($chr(255) $+ $chr(253) isin %tmp.slomp3.mp3.bitrate) {
    set %tmp.slomp3.mp3.bitrate $asc($mid(%tmp.slomp3.mp3.bitrate,3,1))
    set %tmp.slomp3.mp3.bitrate $calc((%tmp.slomp3.mp3.bitrate - (%tmp.slomp3.mp3.bitrate % 16)) / 1)
    return %tmp.slomp3.mp3.bitrate
  }
  if ($chr(16) $+ $chr(49) isin %tmp.slomp3.mp3.bitrate) {
    return 128
  }
  if ($Mid(%tmp.slomp3.mp3.bitrate,2,1) != $chr(251)) {
    set %tmp.slomp3.mp3.bitrate $asc($mid(%tmp.slomp3.mp3.bitrate,3,1))
    set %tmp.slomp3.mp3.bitrate $calc((%tmp.slomp3.mp3.bitrate - (%tmp.slomp3.mp3.bitrate % 16)) / 2)
    return %tmp.slomp3.mp3.bitrate
  }
  :BR2
  if ($Mid(%tmp.slomp3.mp3.bitrate,3,1) == $null) { return N/A }
  set %tmp.slomp3.mp3.bitrate $asc($Mid(%tmp.slomp3.mp3.bitrate,3,1))
  if (%tmp.slomp3.mp3.bitrate == $null) { return 128 }
  set %tmp.slomp3.mp3.bitrate $calc((%tmp.slomp3.mp3.bitrate - (%tmp.slomp3.mp3.bitrate % 16)) / 16)
  :cal
  if (%tmp.slomp3.mp3.bitrate == 1) { return 32 } |  elseif (%tmp.slomp3.mp3.bitrate == 2) { return 40 }
  elseif (%tmp.slomp3.mp3.bitrate == 3) { return 48 } | elseif (%tmp.slomp3.mp3.bitrate == 4) { return 56 }
  elseif (%tmp.slomp3.mp3.bitrate == 5) { return 64 } | elseif (%tmp.slomp3.mp3.bitrate == 6) { return 80 }
  elseif (%tmp.slomp3.mp3.bitrate == 7) { return 96 } | elseif (%tmp.slomp3.mp3.bitrate == 8) { return 112 }
  elseif (%tmp.slomp3.mp3.bitrate == 9) { return 128 } | elseif (%tmp.slomp3.mp3.bitrate == 10) { return 160 }
  elseif (%tmp.slomp3.mp3.bitrate == 11) { return 192 } | elseif (%tmp.slomp3.mp3.bitrate == 12) { return 224 }
  elseif (%tmp.slomp3.mp3.bitrate == 13) { return 256 } | elseif (%tmp.slomp3.mp3.bitrate == 14) { return 320 }
  return 128
}
alias song.length {
  unset %n
  unset %m
  unset %bitrate
  unset %timesec
  unset %totsec
  set %bitrate $mpegbitrate($1-) $+ 000 
  if ( %bitrate == N/A000 ) { set %bitrate 128000 }
  %bitrate = %bitrate / 8 
  %n = $lof($1-) 
  %n = %n / %bitrate 
  %m = %n / 60 
  %timsec = %n % 60 
  %m = $int(%m) 
  %timsec = $int(%timsec)
  %totsecs = %m * 60 
  %totsecs = %totsecs + %timsec
  return %totsecs
}

alias genre {
  if ($1 = 0) { return blues } | elseif ($1 = 1) { return Classic Rock } | elseif ($1 = 2) { return Country } | elseif ($1 = 3) { return Dance } | elseif ($1 = 4) { return Disco } | elseif ($1 = 5) { return Funk } | elseif ($1 = 6) { return Grunge } | elseif ($1 = 7) { return Hip-Hop } | elseif ($1 = 8) { return Jazz } | elseif ($1 = 9) { return Metal } | elseif ($1 = 10) { return New Age } 
  elseif ($1 = 11) { return Oldies } | elseif ($1 = 12) { return Other } | elseif ($1 = 13) { return Pop } | elseif ($1 = 14) { return R&B } | elseif ($1 = 15) { return Rap } | elseif ($1 = 16) { return Reggae } | elseif ($1 = 17) { return Rock } | elseif ($1 = 18) { return Techno } | elseif ($1 = 19) { return Industrial } | elseif ($1 = 20) { return Alternative }
  elseif ($1 = 21) { return Ska } | elseif ($1 = 22) { return Death Metal } | elseif ($1 = 23) { return Pranks } | elseif ($1 = 24) { return Soundtrack } | elseif ($1 = 25) { return Euro-Techno } | elseif ($1 = 26) { return Ambient } | elseif ($1 = 27) { return Trip-Hop } | elseif ($1 = 28) { return Vocal } | elseif ($1 = 29) { return Jazz-Funk } | elseif ($1 = 30) { return Fusion } 
  elseif ($1 = 31) { return Trance } | elseif ($1 = 32) { return Classical } | elseif ($1 = 33) { return Instrumental } | elseif ($1 = 34) { return Instrumental } | elseif ($1 = 35) { return House } | elseif ($1 = 36) { return Game } | elseif ($1 = 37) { return Soundclip } | elseif ($1 = 38) { return Gospel } | elseif ($1 = 39) { return Noise } | elseif ($1 = 40) { return AlternRock } 
  elseif ($1 = 41) { return Bass } | elseif ($1 = 42) { return Soul } | elseif ($1 = 43) { return Punk } | elseif ($1 = 44) { return Space } | elseif ($1 = 45) { return Meditative } | elseif ($1 = 46) { return Instrumental Pop } | elseif ($1 = 47) { return Instrumental Rock } | elseif ($1 = 48) { return Ethinnic } | elseif ($1 = 49) { return Gothic } | elseif ($1 = 50) { return Darkwave } 
  elseif ($1 = 51) { return Techno-Industrial } | elseif ($1 = 52) { return Electronic } | elseif ($1 = 53) { return Pop-Folk } | elseif ($1 = 54) { return Eurodance } | elseif ($1 = 55) { return Dream } | elseif ($1 = 56) { return Southern Rock } | elseif ($1 = 57) { return Comedy } | elseif ($1 = 58) { return Cult } | elseif ($1 = 59) { return Gangsta } | elseif ($1 = 60) { return Top 40 }
  elseif ($1 = 61) { return Christian Rap } | elseif ($1 = 62) { return Pop/Funk } | elseif ($1 = 63) { return Jungle } | elseif ($1 = 64) { return Native American } | elseif ($1 = 65) { return Cabaret } | elseif ($1 = 66) { return New Wave } | elseif ($1 = 67) { return Psychedelic } | elseif ($1 = 68) { return Rave } | elseif ($1 = 69) { return Showtunes } | elseif ($1 = 70) { return Trailer }
  elseif ($1 = 71) { return Lo-Fi } | elseif ($1 = 72) { return Tribal } | elseif ($1 = 73) { return Acid Punk } | elseif ($1 = 74) { return Acid Jazz } | elseif ($1 = 75) { return Polka } | elseif ($1 = 76) { return Retro } | elseif ($1 = 77) { return Musical } | elseif ($1 = 78) { return Rock & Roll } | elseif ($1 = 79) { return Hard Rock } | elseif ($1 = 80) { return Folk Rock } 
  elseif ($1 = 81) { return Folk-Rock } | elseif ($1 = 82) { return National Folk } | elseif ($1 = 83) { return Swing } | elseif ($1 = 84) { return Fast Fusion } | elseif ($1 = 85) { return Bebob } | elseif ($1 = 86) { return Latin } | elseif ($1 = 87) { return Revival } | elseif ($1 = 88) { return Celtic } | elseif ($1 = 89) { return Bluegrass } | elseif ($1 = 90) { return Avantgarde } 
  elseif ($1 = 91) { return Gothic Rock } | elseif ($1 = 92) { return Progressive Rock } | elseif ($1 = 93) { return Psychedelic Rock } | elseif ($1 = 94) { return Symphonic Rock } | elseif ($1 = 95) { return Slow Rock } | elseif ($1 = 96) { return Big Band } | elseif ($1 = 97) { return Chorus } | elseif ($1 = 98) { return Easy Listening } | elseif ($1 = 99) { return Acoustic } | elseif ($1 = 100) { return Humour } 
  elseif ($1 = 101) { return Speech } | elseif ($1 = 102) { return Chanson } | elseif ($1 = 103) { return Opera } | elseif ($1 = 104) { return Chamber Music } | elseif ($1 = 105) { return Sonata } | elseif ($1 = 106) { return Symphony } | elseif ($1 = 107) { return Booty Bass } | elseif ($1 = 108) { return Primus } | elseif ($1 = 109) { return Porn Groove } | elseif ($1 = 110) { return Satire }
  elseif ($1 = 111) { return Slow Jam } | elseif ($1 = 112) { return Club } | elseif ($1 = 113) { return Tango } | elseif ($1 = 114) { return Samba } | elseif ($1 = 115) { return Folklore } | elseif ($1 = 116) { return Ballad } | elseif ($1 = 117) { return Power Ballad } | elseif ($1 = 118) { return Rythmic-Soul } | elseif ($1 = 119) { return Freestyle } | elseif ($1 = 120) { return Duet }
  elseif ($1 = 121) { return Punk Rock } | elseif ($1 = 122) { return Drum Solo } | elseif ($1 = 123) { return A capella } | elseif ($1 = 124) { return Euro-House } | elseif ($1 = 125) { return Dance Hall } | elseif ( $1 == 137 ) { return Heavy Metal } | elseif ($1 > 126) && ( $1 < 136 ) { return $null } | else { return $null }
}

dialog slo.opt {
  title "Options for SloMP3 v 3.5"
  option DBU
  size -1 -1 150 150
  button "&Ok.", 1, 10 138 25 10,ok
  button "&Cancel.", 2, 37 138 25 10,cancel
  box "Message Options", 3, 1 1 148 28
  check "Silent Mode?(no channel message)", 4, 3 9 92 6
  check "Display extended info if in silent mode?", 5, 3 18 100 6
  text "MP3 player:", 7, 3 37 30 7
  button "", 6, 3 46 130 10
  box "Other Options", 8, 1 30 148 106
  text "More to come in the next version!", 9, 10 70 100 7
}
on 1:dialog:slo.opt:*:*: {
  if ( $devent == sclick ) && ( $did == 4 ) {
    if ( %silent.mp3 == on ) { set %silent.mp3 off }
    elseif ( %silent.mp3 == off ) { set %silent.mp3 on }
  }
  if ( $devent == sclick ) && ( $did == 5 ) {
    if ( %extended.mp3.t == on ) { set %extended.mp3.t off }
    elseif ( %extended.mp3.t == off ) { set %extended.mp3.t on }
  }
  if ( $did == 6 ) {
    unset %slo.player*
    set %slo.player.dir $nofile(%mp3.player) $+ *.exe
    .timerslo1 1 0 /slo.newplayer  
    if ( %slo.player.temp == $null ) { halt }
    else { set %mp3.player %slo.player.temp  | /did -r slo.opt 6 | /did -a slo.opt 6 %mp3.player }
  }
}
alias slo.newplayer {
  set %slo.player.temp $dir="Select new player" %slo.player.dir
}
alias dispoption {
  dialog -dmr slo.opt slo.opt
  if ( %silent.mp3 == on ) { /did -c slo.opt 4 }
  if ( %extended.mp3.t == on ) { /did -c slo.opt 5 }
  did -a slo.opt 6 %mp3.player
}
dialog slo.about {
  title "About SloMP3 v 3.5"
  option DBU
  size -1 -1 115 155
  button "&Ok.", 1, 10 140 25 10,ok
  button "&Cancel.", 2, 37 140 25 10,cancel
  button "&Kudos", 3, 65 140 25 10
  box "Scripting", 4, 5 -1 104 40
  text "Sloloem did all of it.", 5, 13 6 129 20
  text "every single line was meeeeee ALLL MEEEEE!", 6, 13 12 89 20
  text "All the scripting made me insane.", 7, 13 24 129 20
  box "Bugs", 8, 5 42 104 40
  text "1.M3Us seem to malfunction on root", 9, 13 49 120 7
  text "dirs(D:\)", 10, 13 55 120 7
  text "2.my ass hurts.", 11, 13 62 129 7
  box "Thanks!", 12, 5 86 104 52
  text "Atlas", 13, 13 94 13 6
  text "TheDave", 14, 13 102 23 6
  text "dizolve", 15, 13 109 21 6
  text "Mr. T", 16, 13 116 21 6
  text "Rukh", 17, 13 123 13 6
}
on 1:dialog:slo.about:sclick:3: {
  dialog -dmr finger finger
}
dialog finger {
  title "Kudos"
  option DBU
  size -1 -1 100 90
  button "Very!", 2, 10 78 25 10,cancel
  button "Not Really.", 1, 70 78 28 10,ok
  text "<VanHelsing> _ ", 3, 3 0 140 7
  text "<VanHelsing> () ", 4, 3 7 140 7
  text "<VanHelsing> () ", 5, 3 14 140 7
  text "<VanHelsing> () ", 6, 3 21 140 7
  text "<VanHelsing>       __()__ ", 7, 3 28 140 7
  text "<VanHelsing>  ()())(()( ) ", 8, 3 35 140 7
  text "<VanHelsing> (     ) ", 9, 3 42 140 7
  text "<VanHelsing> (  Piss off!) ", 10, 3 49 140 7 
  text "<VanHelsing> (_________) ", 11, 3 56 140 7
  text "Doesn't that look helpful?", 13,12 70 140 7}
}
alias dispabout {
  dialog -dmr slo.about slo.about
}

alias id3tag {
  bread " $+ $1- $+ " $calc($lof($1-) -128) 128 &tag
  if ( TAG isin $bvar(&tag,1-3).text ) { return TAG }
  else { Return noTAG }
}

alias id3.title {
  if ( $id3tag($1-) == noTAG ) {
    unset %id3.@.1
    unset %id3.@.2
    unset %id3.@.3
    unset %id3.@.4
    unset %id3.@.5
    unset %id3.@.6
    return $replace($nopath($1-),_,$chr(32))
  }
  elseif ( $id3tag($1-) == TAG ) {
    bread " $+ $1- $+ "  $calc($lof($1-) -128) 128 &i
    unset %id3.@.1
    unset %id3.@.2
    unset %id3.@.3
    unset %id3.@.4
    unset %id3.@.5
    unset %id3.@.6
    set %id3.@.1 $bvar(&i,4-33).text
    set %id3.@.2 $bvar(&i,34-63).text
    set %id3.@.3 $bvar(&i,64-93).text
    set %id3.@.4 $bvar(&i,94-97).text
    set %id3.@.5 $bvar(&i,98-127).text
    set %id3.@.6 $bvar(&i,128).text
    if ( %id3.@.1 !== $str($chr(32),30) ) || ( %id3.@.1 !== $null ) { %id3.@.1 = %id3.@.1 <> }
    if ( %id3.@.2 !== $str($chr(32),30) ) || ( %id3.@.2 !== $null ) { %id3.@.2 = %id3.@.2 <> }
    if ( %id3.@.3 !== $str($chr(32),30) ) || ( %id3.@.3 !== $null ) { %id3.@.3 = %id3.@.3 <> }
    if ( %id3.@.4 !== $str($chr(32),4) ) || ( %id3.@.4 !== $null ) { %id3.@.4 = %id3.@.4 <> }
    return %id3.@.2 %id3.@.1 %id3.@.3 %id3.@.4 $genre(%id3.@.6)
  }
}

alias id3.song {
  if ( $id3tag($2-) == noTAG ) {
    return $replace($nopath($2-),_,$chr(32))
  }
  else {
    bread " $+ $2- $+ "  $calc($lof($2-) -128) 128 &i
    unset %id3.@.1
    unset %id3.@.2
    unset %id3.@.3
    unset %id3.@.4
    unset %id3.@.5
    unset %id3.@.6
    set %id3.@.1 $bvar(&i,4-33).text
    set %id3.@.2 $bvar(&i,34-63).text
    set %id3.@.3 $bvar(&i,64-93).text
    set %id3.@.4 $bvar(&i,94-97).text
    set %id3.@.5 $bvar(&i,98-127).text
    set %id3.@.6 $bvar(&i,128).text
    if ( $1 == 1 ) { return %id3.@.2 }
    if ( $1 == 2 ) { return %id3.@.1 }
    if ( $1 == 3 ) { return %id3.@.3 }
    if ( $1 == 4 ) { return %id3.@.4 }
    if ( $1 == 5 ) { return $genre(%id3.@.6) }
  }
}
