; Simple File Encryption 1.0 
; by Soapforge (http://ns.iwarp.com)

alias fencrypt {  
  sfe.cryptography.checkstate $1 $2
  .disable #sfe.decrypt
  .enable #sfe.encrypt
  sfe.password
  sfe.cryptography.engine $1 $2
}

alias fdecrypt {
  sfe.cryptography.checkstate $1 $2
  .disable #sfe.encrypt
  .enable #sfe.decrypt
  sfe.password
  sfe.cryptography.engine $1 $2
}

alias fstatus {
  if ($timer(ste.crypt) != $null) {
    echo -a *** You can't fool with the progress window settings while a task is running
    return
  }
  if ($group(#sfe.fstatus).status == on) || ($1 == off) {
    echo -a *** Progress window is now off
    .disable #sfe.fstatus
    .enable #sfe.nostatus
  }
  else {
    echo -a *** Progress window is now on
    .enable #sfe.fstatus
    .disable #sfe.nostatus
  }
}

alias -l sfe.cryptography.engine {
  writeini sfe.cfg settings position 1
  var %sfe.blocksize = 128
  var %sfe.len = $lof($1)
  if ($3 == -selfcall) {
    var %sfe.pos = $4
  }
  else {
    var %sfe.pos = 0
  }
  :fetch
  if ($calc(%sfe.pos + %sfe.blocksize) >= %sfe.len) {
    var %sfe.blocklen = $calc(%sfe.len - %sfe.pos)
  }
  else {
    var %sfe.blocklen = %sfe.blocksize
  }
  bread $1 %sfe.pos %sfe.blocksize &blockin
  var %sfe.blockpos = 1
  sfe.cryptography.statuscall %sfe.len %sfe.pos
  :process
  if (%sfe.blockpos <= %sfe.blocklen) {     
    bset &blockout %sfe.blockpos $sfe.cryptography.roll($bvar(&blockin,%sfe.blockpos))
    inc %sfe.blockpos 1
    goto process
  }
  bwrite $2 -1 %sfe.blocklen &blockout
  if ($calc(%sfe.pos + %sfe.blocksize) >= %sfe.len) {
    sfe.cryptography.statuscall %sfe.len %sfe.pos closewin
    .remini sfe.cfg settings password
    echo -a *** Task complete
    return
  }
  var %sfe.pos = $calc(%sfe.pos + %sfe.blocksize)
  .timerste.crypt 1 0 sfe.cryptography.engine $1 $2 -selfcall %sfe.pos
}

alias -l sfe.cryptography.keygen {
  var %sfe.read = $readini sfe.cfg settings password
  var %sfe.pos = $readini sfe.cfg settings position
  var %sfe.ret = $asc($mid(%sfe.read,%sfe.pos,1))
  inc %sfe.pos 1
  if (%sfe.pos > $len(%sfe.read)) {
    set %sfe.pos 1
  }
  return %sfe.ret
}

#sfe.decrypt on
alias -l sfe.cryptography.roll {
  var %sfe.er = $calc($1 - $sfe.cryptography.keygen)
  if (%sfe.er < 0) {
    inc %sfe.er 256
  }
  return %sfe.er
}
alias -l sfe.cryptography.statuscall {
  sfe.cryptography.progresswin @Decrypting... $1 $2 $3
}
#sfe.decrypt end

#sfe.encrypt off
alias -l sfe.cryptography.roll {
  var %sfe.er = $calc($1 + $sfe.cryptography.keygen)
  if (%sfe.er > 255) {
    dec %sfe.er 256
  }
  return %sfe.er
}
alias -l sfe.cryptography.statuscall {
  sfe.cryptography.progresswin @Encrypting... $1 $2 $3
}
#sfe.encrypt end

alias -l sfe.cryptography.checkstate {

  if ($timer(ste.crypt) != $null) {
    echo -a *** The current task must be stopped before beginning a new one.
    return
  }
  if ($1 == $null) || ($2 == $null) {
    echo -a *** Syntax: inputfilename.ext outputfilename.ext
    return
  }
  if ($isfile($1) == $false) {
    echo -a *** Input file not found
    return
  }
  if ($isfile($2) == $true) {
    echo -a *** a file named $2 already exists
    return
  }
}

dialog sfe.dpass {
  title "Password"
  size -1 -1 108 50
  option dbu 
  edit "", 1, 10 13 90 11, pass result
  button "Okay", 2, 35 30 40 15, ok
}

alias -l sfe.password {
  :p
  var %sfe.pass = $dialog(requestpassword,sfe.dpass,-2) 
  if (%sfe.pass == $null) {
    goto p
  }
  writeini sfe.cfg settings password $gettok(%sfe.pass,1,32)
}

#sfe.fstatus on
alias sfe.cryptography.progresswin {
  if ($window($1) == $null) {
    var %sfe.x = $readini sfe.cfg settings winx
    var %sfe.y = $readini sfe.cfg settings winy
    if (%sfe.x == $null) || (%sfe.y == $null) {
      window -pdk0 +ft $1 100 100 300 270
      writeini sfe.cfg settings winx 100
      writeini sfe.cfg settings winy 100
    }
    else {
      window -pdk0 +ft $1 %sfe.x %sfe.y 300 270
    }
    drawrect -frn $1 $rgb(220,220,220) 1 0 0 300 270
    drawrect -frn $1 $rgb(255,255,255) 3 20 20 49 206
    drawrect -rn $1 $rgb(0,0,255) 3 20 20 50 207
  }
  var %sfe.p = $round($calc($calc($3 / $2) * 100),1)
  drawrect -frn $1 $rgb(220,220,220) 1 98 0 300 270
  drawrect -fnr $1 $rgb(0,20,200) 3 23 $calc(224 - $calc(%sfe.p * 2)) 43 $calc(%sfe.p * 2)
  drawtext -rno $1 $rgb(0,0,255) arial 14 100 20 Percent complete: %sfe.p
  drawtext -rno $1 $rgb(0,0,255) arial 14 100 40 Processed bytes: $3
  drawtext -rno $1 $rgb(0,0,255) arial 14 100 60 Total bytes: $2
  drawdot $1
  if ($4) {
    writeini sfe.cfg settings winx $window($1).x
    writeini sfe.cfg settings winy $window($1).y
    close -@ $1
  }
}

alias -l sfe.closewin {
  if ($1 == -selfcall) {
    if ($2 == $false) {
      .timerste.crypt 1 0 $3-
      return
    }
    else {
      if ($isfile($5) == $true) {
        .remove $5
        echo -a *** Task halted
      }
    } 
  }
  if ($timer(ste.crypt) != $null) {
    .timer 1 0 sfe.closewin -selfcall $?!="Stop current task?" $timer(ste.crypt).com
    .timerste.crypt off
  }
}
on 1:close:@encrypting...:{
  writeini sfe.cfg settings winx $window($active).x
  writeini sfe.cfg settings winy $window($active).y
  .timer 1 0 sfe.closewin 
}

on 1:close:@decrypting...:{
  writeini sfe.cfg settings winx $window($active).x
  writeini sfe.cfg settings winy $window($active).y
  .timer 1 0 sfe.closewin $active
}
#sfe.fstatus end

#sfe.nostatus off
alias sfe.cryptography.progresswin {
  return
}
#sfe.nostatus end

; Autodetect line follows
; ki.basicregister [ SFE100/Simple File Encryption/SoapForge/encrypts and decrypts files/false ]
